"""
    Cisco Intersight

    Cisco Intersight is a management platform delivered as a service with embedded analytics for your Cisco and 3rd party IT infrastructure. This platform offers an intelligent level of management that enables IT organizations to analyze, simplify, and automate their environments in more advanced ways than the prior generations of tools. Cisco Intersight provides an integrated and intuitive management experience for resources in the traditional data center as well as at the edge. With flexible deployment options to address complex security needs, getting started with Intersight is quick and easy. Cisco Intersight has deep integration with Cisco UCS and HyperFlex systems allowing for remote deployment, configuration, and ongoing maintenance. The model-based deployment works for a single system in a remote location or hundreds of systems in a data center and enables rapid, standardized configuration and deployment. It also streamlines maintaining those systems whether you are working with small or very large configurations. The Intersight OpenAPI document defines the complete set of properties that are returned in the HTTP response. From that perspective, a client can expect that no additional properties are returned, unless these properties are explicitly defined in the OpenAPI document. However, when a client uses an older version of the Intersight OpenAPI document, the server may send additional properties because the software is more recent than the client. In that case, the client may receive properties that it does not know about. Some generated SDKs perform a strict validation of the HTTP response body against the OpenAPI document.  # noqa: E501

    The version of the OpenAPI document: 1.0.11-2025092610
    Contact: intersight@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from intersight.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    set_model_init_error,
    OpenApiModel
)
from intersight.exceptions import ApiAttributeError


def lazy_import():
    from intersight.model.compute_physical_summary_relationship import ComputePhysicalSummaryRelationship
    from intersight.model.hyperflex_node_relationship import HyperflexNodeRelationship
    from intersight.model.virtualization_vmware_attached_resource_tag import VirtualizationVmwareAttachedResourceTag
    from intersight.model.virtualization_vmware_cluster_relationship import VirtualizationVmwareClusterRelationship
    from intersight.model.virtualization_vmware_datacenter_relationship import VirtualizationVmwareDatacenterRelationship
    from intersight.model.virtualization_vmware_datastore_relationship import VirtualizationVmwareDatastoreRelationship
    from intersight.model.virtualization_vmware_distributed_network_relationship import VirtualizationVmwareDistributedNetworkRelationship
    from intersight.model.virtualization_vmware_distributed_switch_relationship import VirtualizationVmwareDistributedSwitchRelationship
    from intersight.model.virtualization_vmware_resource_consumption import VirtualizationVmwareResourceConsumption
    globals()['ComputePhysicalSummaryRelationship'] = ComputePhysicalSummaryRelationship
    globals()['HyperflexNodeRelationship'] = HyperflexNodeRelationship
    globals()['VirtualizationVmwareAttachedResourceTag'] = VirtualizationVmwareAttachedResourceTag
    globals()['VirtualizationVmwareClusterRelationship'] = VirtualizationVmwareClusterRelationship
    globals()['VirtualizationVmwareDatacenterRelationship'] = VirtualizationVmwareDatacenterRelationship
    globals()['VirtualizationVmwareDatastoreRelationship'] = VirtualizationVmwareDatastoreRelationship
    globals()['VirtualizationVmwareDistributedNetworkRelationship'] = VirtualizationVmwareDistributedNetworkRelationship
    globals()['VirtualizationVmwareDistributedSwitchRelationship'] = VirtualizationVmwareDistributedSwitchRelationship
    globals()['VirtualizationVmwareResourceConsumption'] = VirtualizationVmwareResourceConsumption


class VirtualizationVmwareHostAllOf(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('class_id',): {
            'VIRTUALIZATION.VMWAREHOST': "virtualization.VmwareHost",
        },
        ('object_type',): {
            'VIRTUALIZATION.VMWAREHOST': "virtualization.VmwareHost",
        },
        ('hw_power_state',): {
            'UNKNOWN': "Unknown",
            'POWERINGON': "PoweringOn",
            'POWEREDON': "PoweredOn",
            'POWERINGOFF': "PoweringOff",
            'POWEREDOFF': "PoweredOff",
            'STANDBY': "StandBy",
            'PAUSED': "Paused",
            'REBOOTING': "Rebooting",
            'EMPTY': "",
        },
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'class_id': (str,),  # noqa: E501
            'object_type': (str,),  # noqa: E501
            'attached_resource_tags': ([VirtualizationVmwareAttachedResourceTag], none_type,),  # noqa: E501
            'boot_time': (datetime,),  # noqa: E501
            'connection_state': (str,),  # noqa: E501
            'dc_inv_path': (str,),  # noqa: E501
            'dns_servers': ([str], none_type,),  # noqa: E501
            'hw_power_state': (str,),  # noqa: E501
            'is_ssh_enabled': (bool,),  # noqa: E501
            'network_adapter_count': (int,),  # noqa: E501
            'ntp_servers': ([str], none_type,),  # noqa: E501
            'quarantine_mode': (bool,),  # noqa: E501
            'resource_consumed': (VirtualizationVmwareResourceConsumption,),  # noqa: E501
            'storage_adapter_count': (int,),  # noqa: E501
            'time_zone': (str,),  # noqa: E501
            'vcenter_host_id': (str,),  # noqa: E501
            'cluster': (VirtualizationVmwareClusterRelationship,),  # noqa: E501
            'datacenter': (VirtualizationVmwareDatacenterRelationship,),  # noqa: E501
            'datastores': ([VirtualizationVmwareDatastoreRelationship], none_type,),  # noqa: E501
            'distributed_networks': ([VirtualizationVmwareDistributedNetworkRelationship], none_type,),  # noqa: E501
            'distributed_switches': ([VirtualizationVmwareDistributedSwitchRelationship], none_type,),  # noqa: E501
            'hyper_flex_node': (HyperflexNodeRelationship,),  # noqa: E501
            'server': (ComputePhysicalSummaryRelationship,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'class_id': 'ClassId',  # noqa: E501
        'object_type': 'ObjectType',  # noqa: E501
        'attached_resource_tags': 'AttachedResourceTags',  # noqa: E501
        'boot_time': 'BootTime',  # noqa: E501
        'connection_state': 'ConnectionState',  # noqa: E501
        'dc_inv_path': 'DcInvPath',  # noqa: E501
        'dns_servers': 'DnsServers',  # noqa: E501
        'hw_power_state': 'HwPowerState',  # noqa: E501
        'is_ssh_enabled': 'IsSshEnabled',  # noqa: E501
        'network_adapter_count': 'NetworkAdapterCount',  # noqa: E501
        'ntp_servers': 'NtpServers',  # noqa: E501
        'quarantine_mode': 'QuarantineMode',  # noqa: E501
        'resource_consumed': 'ResourceConsumed',  # noqa: E501
        'storage_adapter_count': 'StorageAdapterCount',  # noqa: E501
        'time_zone': 'TimeZone',  # noqa: E501
        'vcenter_host_id': 'VcenterHostId',  # noqa: E501
        'cluster': 'Cluster',  # noqa: E501
        'datacenter': 'Datacenter',  # noqa: E501
        'datastores': 'Datastores',  # noqa: E501
        'distributed_networks': 'DistributedNetworks',  # noqa: E501
        'distributed_switches': 'DistributedSwitches',  # noqa: E501
        'hyper_flex_node': 'HyperFlexNode',  # noqa: E501
        'server': 'Server',  # noqa: E501
    }

    read_only_vars = {
        'datastores',  # noqa: E501
        'distributed_networks',  # noqa: E501
        'distributed_switches',  # noqa: E501
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """VirtualizationVmwareHostAllOf - a model defined in OpenAPI

        Args:

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "virtualization.VmwareHost", must be one of ["virtualization.VmwareHost", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "virtualization.VmwareHost", must be one of ["virtualization.VmwareHost", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            attached_resource_tags ([VirtualizationVmwareAttachedResourceTag], none_type): [optional]  # noqa: E501
            boot_time (datetime): The time when this host booted up.. [optional]  # noqa: E501
            connection_state (str): Indicates if the host is connected to the vCenter. Values are connected, not connected.. [optional]  # noqa: E501
            dc_inv_path (str): This field stores the inventory path of a datacenter. Used in host maintenance action.. [optional]  # noqa: E501
            dns_servers ([str], none_type): [optional]  # noqa: E501
            hw_power_state (str): Is the host Powered-up or Powered-down. * `Unknown` - The entity's power state is unknown. * `PoweringOn` - The entity is powering on. * `PoweredOn` - The entity is powered on. * `PoweringOff` - The entity is powering off. * `PoweredOff` - The entity is powered down. * `StandBy` - The entity is in standby mode. * `Paused` - The entity is in pause state. * `Rebooting` - The entity reboot is in progress. * `` - The entity's power state is not available.. [optional] if omitted the server will use the default value of "Unknown"  # noqa: E501
            is_ssh_enabled (bool): True if SSH is enabled in the host, false otherwise.. [optional]  # noqa: E501
            network_adapter_count (int): The count of all network adapters attached to this host.. [optional]  # noqa: E501
            ntp_servers ([str], none_type): [optional]  # noqa: E501
            quarantine_mode (bool): Indicates if the host is in quarantine mode. Will be set to True, when in quarantine mode.. [optional]  # noqa: E501
            resource_consumed (VirtualizationVmwareResourceConsumption): [optional]  # noqa: E501
            storage_adapter_count (int): The count of all storage adapters attached to this host.. [optional]  # noqa: E501
            time_zone (str): Time zone this host is in.. [optional]  # noqa: E501
            vcenter_host_id (str): The identity of this host within vCenter (optional).. [optional]  # noqa: E501
            cluster (VirtualizationVmwareClusterRelationship): [optional]  # noqa: E501
            datacenter (VirtualizationVmwareDatacenterRelationship): [optional]  # noqa: E501
            datastores ([VirtualizationVmwareDatastoreRelationship], none_type): An array of relationships to virtualizationVmwareDatastore resources.. [optional]  # noqa: E501
            distributed_networks ([VirtualizationVmwareDistributedNetworkRelationship], none_type): An array of relationships to virtualizationVmwareDistributedNetwork resources.. [optional]  # noqa: E501
            distributed_switches ([VirtualizationVmwareDistributedSwitchRelationship], none_type): An array of relationships to virtualizationVmwareDistributedSwitch resources.. [optional]  # noqa: E501
            hyper_flex_node (HyperflexNodeRelationship): [optional]  # noqa: E501
            server (ComputePhysicalSummaryRelationship): [optional]  # noqa: E501
        """

        class_id = "virtualization.VmwareHost" if len(kwargs.get('class_id','').strip()) == 0 else kwargs.get('class_id', "virtualization.VmwareHost")
        object_type = "virtualization.VmwareHost" if len(kwargs.get('object_type','').strip()) == 0 else kwargs.get('object_type', "virtualization.VmwareHost")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', True)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.class_id = class_id
        self.object_type = object_type
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """VirtualizationVmwareHostAllOf - a model defined in OpenAPI

        Args:

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "virtualization.VmwareHost", must be one of ["virtualization.VmwareHost", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "virtualization.VmwareHost", must be one of ["virtualization.VmwareHost", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            attached_resource_tags ([VirtualizationVmwareAttachedResourceTag], none_type): [optional]  # noqa: E501
            boot_time (datetime): The time when this host booted up.. [optional]  # noqa: E501
            connection_state (str): Indicates if the host is connected to the vCenter. Values are connected, not connected.. [optional]  # noqa: E501
            dc_inv_path (str): This field stores the inventory path of a datacenter. Used in host maintenance action.. [optional]  # noqa: E501
            dns_servers ([str], none_type): [optional]  # noqa: E501
            hw_power_state (str): Is the host Powered-up or Powered-down. * `Unknown` - The entity's power state is unknown. * `PoweringOn` - The entity is powering on. * `PoweredOn` - The entity is powered on. * `PoweringOff` - The entity is powering off. * `PoweredOff` - The entity is powered down. * `StandBy` - The entity is in standby mode. * `Paused` - The entity is in pause state. * `Rebooting` - The entity reboot is in progress. * `` - The entity's power state is not available.. [optional] if omitted the server will use the default value of "Unknown"  # noqa: E501
            is_ssh_enabled (bool): True if SSH is enabled in the host, false otherwise.. [optional]  # noqa: E501
            network_adapter_count (int): The count of all network adapters attached to this host.. [optional]  # noqa: E501
            ntp_servers ([str], none_type): [optional]  # noqa: E501
            quarantine_mode (bool): Indicates if the host is in quarantine mode. Will be set to True, when in quarantine mode.. [optional]  # noqa: E501
            resource_consumed (VirtualizationVmwareResourceConsumption): [optional]  # noqa: E501
            storage_adapter_count (int): The count of all storage adapters attached to this host.. [optional]  # noqa: E501
            time_zone (str): Time zone this host is in.. [optional]  # noqa: E501
            vcenter_host_id (str): The identity of this host within vCenter (optional).. [optional]  # noqa: E501
            cluster (VirtualizationVmwareClusterRelationship): [optional]  # noqa: E501
            datacenter (VirtualizationVmwareDatacenterRelationship): [optional]  # noqa: E501
            datastores ([VirtualizationVmwareDatastoreRelationship], none_type): An array of relationships to virtualizationVmwareDatastore resources.. [optional]  # noqa: E501
            distributed_networks ([VirtualizationVmwareDistributedNetworkRelationship], none_type): An array of relationships to virtualizationVmwareDistributedNetwork resources.. [optional]  # noqa: E501
            distributed_switches ([VirtualizationVmwareDistributedSwitchRelationship], none_type): An array of relationships to virtualizationVmwareDistributedSwitch resources.. [optional]  # noqa: E501
            hyper_flex_node (HyperflexNodeRelationship): [optional]  # noqa: E501
            server (ComputePhysicalSummaryRelationship): [optional]  # noqa: E501
        """

        class_id = "virtualization.VmwareHost" if len(kwargs.get('class_id','').strip()) == 0 else kwargs.get('class_id', "virtualization.VmwareHost")
        object_type = "virtualization.VmwareHost" if len(kwargs.get('object_type','').strip()) == 0 else kwargs.get('object_type', "virtualization.VmwareHost")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.class_id = class_id
        self.object_type = object_type
        for var_name, var_value in kwargs.items():
            if var_name in self.read_only_vars:
                set_model_init_error(f"Warning : {var_name} is omitted from request payload as it is a read-only property")
                continue
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
