"""
    Cisco Intersight

    Cisco Intersight is a management platform delivered as a service with embedded analytics for your Cisco and 3rd party IT infrastructure. This platform offers an intelligent level of management that enables IT organizations to analyze, simplify, and automate their environments in more advanced ways than the prior generations of tools. Cisco Intersight provides an integrated and intuitive management experience for resources in the traditional data center as well as at the edge. With flexible deployment options to address complex security needs, getting started with Intersight is quick and easy. Cisco Intersight has deep integration with Cisco UCS and HyperFlex systems allowing for remote deployment, configuration, and ongoing maintenance. The model-based deployment works for a single system in a remote location or hundreds of systems in a data center and enables rapid, standardized configuration and deployment. It also streamlines maintaining those systems whether you are working with small or very large configurations. The Intersight OpenAPI document defines the complete set of properties that are returned in the HTTP response. From that perspective, a client can expect that no additional properties are returned, unless these properties are explicitly defined in the OpenAPI document. However, when a client uses an older version of the Intersight OpenAPI document, the server may send additional properties because the software is more recent than the client. In that case, the client may receive properties that it does not know about. Some generated SDKs perform a strict validation of the HTTP response body against the OpenAPI document.  # noqa: E501

    The version of the OpenAPI document: 1.0.11-2025092610
    Contact: intersight@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from intersight.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    set_model_init_error,
    OpenApiModel
)
from intersight.exceptions import ApiAttributeError


def lazy_import():
    from intersight.model.fabric_eth_network_control_policy_relationship import FabricEthNetworkControlPolicyRelationship
    from intersight.model.fabric_eth_network_group_policy_relationship import FabricEthNetworkGroupPolicyRelationship
    from intersight.model.macpool_pool_relationship import MacpoolPoolRelationship
    from intersight.model.vnic_cdn import VnicCdn
    from intersight.model.vnic_eth_adapter_policy_relationship import VnicEthAdapterPolicyRelationship
    from intersight.model.vnic_eth_network_policy_relationship import VnicEthNetworkPolicyRelationship
    from intersight.model.vnic_eth_qos_policy_relationship import VnicEthQosPolicyRelationship
    from intersight.model.vnic_iscsi_boot_policy_relationship import VnicIscsiBootPolicyRelationship
    from intersight.model.vnic_sriov_settings import VnicSriovSettings
    from intersight.model.vnic_usnic_settings import VnicUsnicSettings
    from intersight.model.vnic_vmq_settings import VnicVmqSettings
    globals()['FabricEthNetworkControlPolicyRelationship'] = FabricEthNetworkControlPolicyRelationship
    globals()['FabricEthNetworkGroupPolicyRelationship'] = FabricEthNetworkGroupPolicyRelationship
    globals()['MacpoolPoolRelationship'] = MacpoolPoolRelationship
    globals()['VnicCdn'] = VnicCdn
    globals()['VnicEthAdapterPolicyRelationship'] = VnicEthAdapterPolicyRelationship
    globals()['VnicEthNetworkPolicyRelationship'] = VnicEthNetworkPolicyRelationship
    globals()['VnicEthQosPolicyRelationship'] = VnicEthQosPolicyRelationship
    globals()['VnicIscsiBootPolicyRelationship'] = VnicIscsiBootPolicyRelationship
    globals()['VnicSriovSettings'] = VnicSriovSettings
    globals()['VnicUsnicSettings'] = VnicUsnicSettings
    globals()['VnicVmqSettings'] = VnicVmqSettings


class VnicBaseEthIfAllOf(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('class_id',): {
            'ETHIF': "vnic.EthIf",
            'VNICTEMPLATE': "vnic.VnicTemplate",
        },
        ('object_type',): {
            'ETHIF': "vnic.EthIf",
            'VNICTEMPLATE': "vnic.VnicTemplate",
        },
    }

    validations = {
        ('pin_group_name',): {
            'regex': {
                'pattern': r'^$|^[a-zA-Z0-9_.:-]{1,64}$',  # noqa: E501
            },
        },
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'class_id': (str,),  # noqa: E501
            'object_type': (str,),  # noqa: E501
            'cdn': (VnicCdn,),  # noqa: E501
            'failover_enabled': (bool,),  # noqa: E501
            'pin_group_name': (str,),  # noqa: E501
            'sriov_settings': (VnicSriovSettings,),  # noqa: E501
            'usnic_settings': (VnicUsnicSettings,),  # noqa: E501
            'vmq_settings': (VnicVmqSettings,),  # noqa: E501
            'eth_adapter_policy': (VnicEthAdapterPolicyRelationship,),  # noqa: E501
            'eth_network_policy': (VnicEthNetworkPolicyRelationship,),  # noqa: E501
            'eth_qos_policy': (VnicEthQosPolicyRelationship,),  # noqa: E501
            'fabric_eth_network_control_policy': (FabricEthNetworkControlPolicyRelationship,),  # noqa: E501
            'fabric_eth_network_group_policy': ([FabricEthNetworkGroupPolicyRelationship], none_type,),  # noqa: E501
            'iscsi_boot_policy': (VnicIscsiBootPolicyRelationship,),  # noqa: E501
            'mac_pool': (MacpoolPoolRelationship,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'class_id': 'ClassId',  # noqa: E501
        'object_type': 'ObjectType',  # noqa: E501
        'cdn': 'Cdn',  # noqa: E501
        'failover_enabled': 'FailoverEnabled',  # noqa: E501
        'pin_group_name': 'PinGroupName',  # noqa: E501
        'sriov_settings': 'SriovSettings',  # noqa: E501
        'usnic_settings': 'UsnicSettings',  # noqa: E501
        'vmq_settings': 'VmqSettings',  # noqa: E501
        'eth_adapter_policy': 'EthAdapterPolicy',  # noqa: E501
        'eth_network_policy': 'EthNetworkPolicy',  # noqa: E501
        'eth_qos_policy': 'EthQosPolicy',  # noqa: E501
        'fabric_eth_network_control_policy': 'FabricEthNetworkControlPolicy',  # noqa: E501
        'fabric_eth_network_group_policy': 'FabricEthNetworkGroupPolicy',  # noqa: E501
        'iscsi_boot_policy': 'IscsiBootPolicy',  # noqa: E501
        'mac_pool': 'MacPool',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, class_id, object_type, *args, **kwargs):  # noqa: E501
        """VnicBaseEthIfAllOf - a model defined in OpenAPI

        Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data. The enum values provides the list of concrete types that can be instantiated from this abstract type.
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property. The enum values provides the list of concrete types that can be instantiated from this abstract type.

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            cdn (VnicCdn): [optional]  # noqa: E501
            failover_enabled (bool): Enabling failover ensures that traffic from the vNIC automatically fails over to the secondary Fabric Interconnect, in case the specified Fabric Interconnect path goes down. Failover applies only to Cisco VICs that are connected to a Fabric Interconnect cluster.. [optional] if omitted the server will use the default value of False  # noqa: E501
            pin_group_name (str): Pingroup name associated to vNIC for static pinning. LCP deploy will resolve pingroup name and fetches the correspoding uplink port/port channel to pin the vNIC traffic.. [optional]  # noqa: E501
            sriov_settings (VnicSriovSettings): [optional]  # noqa: E501
            usnic_settings (VnicUsnicSettings): [optional]  # noqa: E501
            vmq_settings (VnicVmqSettings): [optional]  # noqa: E501
            eth_adapter_policy (VnicEthAdapterPolicyRelationship): [optional]  # noqa: E501
            eth_network_policy (VnicEthNetworkPolicyRelationship): [optional]  # noqa: E501
            eth_qos_policy (VnicEthQosPolicyRelationship): [optional]  # noqa: E501
            fabric_eth_network_control_policy (FabricEthNetworkControlPolicyRelationship): [optional]  # noqa: E501
            fabric_eth_network_group_policy ([FabricEthNetworkGroupPolicyRelationship], none_type): An array of relationships to fabricEthNetworkGroupPolicy resources.. [optional]  # noqa: E501
            iscsi_boot_policy (VnicIscsiBootPolicyRelationship): [optional]  # noqa: E501
            mac_pool (MacpoolPoolRelationship): [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', True)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.class_id = class_id
        self.object_type = object_type
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, class_id, object_type, *args, **kwargs):  # noqa: E501
        """VnicBaseEthIfAllOf - a model defined in OpenAPI

        Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data. The enum values provides the list of concrete types that can be instantiated from this abstract type.
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property. The enum values provides the list of concrete types that can be instantiated from this abstract type.

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            cdn (VnicCdn): [optional]  # noqa: E501
            failover_enabled (bool): Enabling failover ensures that traffic from the vNIC automatically fails over to the secondary Fabric Interconnect, in case the specified Fabric Interconnect path goes down. Failover applies only to Cisco VICs that are connected to a Fabric Interconnect cluster.. [optional] if omitted the server will use the default value of False  # noqa: E501
            pin_group_name (str): Pingroup name associated to vNIC for static pinning. LCP deploy will resolve pingroup name and fetches the correspoding uplink port/port channel to pin the vNIC traffic.. [optional]  # noqa: E501
            sriov_settings (VnicSriovSettings): [optional]  # noqa: E501
            usnic_settings (VnicUsnicSettings): [optional]  # noqa: E501
            vmq_settings (VnicVmqSettings): [optional]  # noqa: E501
            eth_adapter_policy (VnicEthAdapterPolicyRelationship): [optional]  # noqa: E501
            eth_network_policy (VnicEthNetworkPolicyRelationship): [optional]  # noqa: E501
            eth_qos_policy (VnicEthQosPolicyRelationship): [optional]  # noqa: E501
            fabric_eth_network_control_policy (FabricEthNetworkControlPolicyRelationship): [optional]  # noqa: E501
            fabric_eth_network_group_policy ([FabricEthNetworkGroupPolicyRelationship], none_type): An array of relationships to fabricEthNetworkGroupPolicy resources.. [optional]  # noqa: E501
            iscsi_boot_policy (VnicIscsiBootPolicyRelationship): [optional]  # noqa: E501
            mac_pool (MacpoolPoolRelationship): [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.class_id = class_id
        self.object_type = object_type
        for var_name, var_value in kwargs.items():
            if var_name in self.read_only_vars:
                set_model_init_error(f"Warning : {var_name} is omitted from request payload as it is a read-only property")
                continue
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
