"""
    Cisco Intersight

    Cisco Intersight is a management platform delivered as a service with embedded analytics for your Cisco and 3rd party IT infrastructure. This platform offers an intelligent level of management that enables IT organizations to analyze, simplify, and automate their environments in more advanced ways than the prior generations of tools. Cisco Intersight provides an integrated and intuitive management experience for resources in the traditional data center as well as at the edge. With flexible deployment options to address complex security needs, getting started with Intersight is quick and easy. Cisco Intersight has deep integration with Cisco UCS and HyperFlex systems allowing for remote deployment, configuration, and ongoing maintenance. The model-based deployment works for a single system in a remote location or hundreds of systems in a data center and enables rapid, standardized configuration and deployment. It also streamlines maintaining those systems whether you are working with small or very large configurations. The Intersight OpenAPI document defines the complete set of properties that are returned in the HTTP response. From that perspective, a client can expect that no additional properties are returned, unless these properties are explicitly defined in the OpenAPI document. However, when a client uses an older version of the Intersight OpenAPI document, the server may send additional properties because the software is more recent than the client. In that case, the client may receive properties that it does not know about. Some generated SDKs perform a strict validation of the HTTP response body against the OpenAPI document.  # noqa: E501

    The version of the OpenAPI document: 1.0.11-2025092610
    Contact: intersight@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from intersight.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    set_model_init_error,
    OpenApiModel
)
from intersight.exceptions import ApiAttributeError


def lazy_import():
    from intersight.model.iam_idp_reference_relationship import IamIdpReferenceRelationship
    from intersight.model.iam_idp_relationship import IamIdpRelationship
    from intersight.model.iam_user_relationship import IamUserRelationship
    from intersight.model.organization_organization_relationship import OrganizationOrganizationRelationship
    from intersight.model.serviceitem_selection_criteria_input import ServiceitemSelectionCriteriaInput
    from intersight.model.servicerequest_message import ServicerequestMessage
    from intersight.model.workflow_base_operation import WorkflowBaseOperation
    from intersight.model.workflow_catalog_item_definition_relationship import WorkflowCatalogItemDefinitionRelationship
    from intersight.model.workflow_service_item_action_instance_relationship import WorkflowServiceItemActionInstanceRelationship
    from intersight.model.workflow_service_item_instance_relationship import WorkflowServiceItemInstanceRelationship
    globals()['IamIdpReferenceRelationship'] = IamIdpReferenceRelationship
    globals()['IamIdpRelationship'] = IamIdpRelationship
    globals()['IamUserRelationship'] = IamUserRelationship
    globals()['OrganizationOrganizationRelationship'] = OrganizationOrganizationRelationship
    globals()['ServiceitemSelectionCriteriaInput'] = ServiceitemSelectionCriteriaInput
    globals()['ServicerequestMessage'] = ServicerequestMessage
    globals()['WorkflowBaseOperation'] = WorkflowBaseOperation
    globals()['WorkflowCatalogItemDefinitionRelationship'] = WorkflowCatalogItemDefinitionRelationship
    globals()['WorkflowServiceItemActionInstanceRelationship'] = WorkflowServiceItemActionInstanceRelationship
    globals()['WorkflowServiceItemInstanceRelationship'] = WorkflowServiceItemInstanceRelationship


class WorkflowCatalogServiceRequestAllOf(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('class_id',): {
            'WORKFLOW.CATALOGSERVICEREQUEST': "workflow.CatalogServiceRequest",
        },
        ('object_type',): {
            'WORKFLOW.CATALOGSERVICEREQUEST': "workflow.CatalogServiceRequest",
        },
        ('status',): {
            'NOTCREATED': "NotCreated",
            'INPROGRESS': "InProgress",
            'FAILED': "Failed",
            'OKAY': "Okay",
            'DECOMMISSIONED': "Decommissioned",
        },
    }

    validations = {
        ('label',): {
            'regex': {
                'pattern': r'^$|^[a-zA-Z0-9]+[\sa-zA-Z0-9_.:-]{1,92}$',  # noqa: E501
            },
        },
        ('name',): {
            'regex': {
                'pattern': r'^[a-zA-Z0-9]+[\sa-zA-Z0-9_.:-]{1,92}$',  # noqa: E501
            },
        },
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'class_id': (str,),  # noqa: E501
            'object_type': (str,),  # noqa: E501
            'description': (str,),  # noqa: E501
            'end_time': (datetime,),  # noqa: E501
            'input': (bool, date, datetime, dict, float, int, list, str, none_type,),  # noqa: E501
            'label': (str,),  # noqa: E501
            'messages': ([ServicerequestMessage], none_type,),  # noqa: E501
            'name': (str,),  # noqa: E501
            'operation': (WorkflowBaseOperation,),  # noqa: E501
            'selection_criteria_inputs': ([ServiceitemSelectionCriteriaInput], none_type,),  # noqa: E501
            'status': (str,),  # noqa: E501
            'user_id_or_email': (str,),  # noqa: E501
            'catalog_item_definition': (WorkflowCatalogItemDefinitionRelationship,),  # noqa: E501
            'idp': (IamIdpRelationship,),  # noqa: E501
            'idp_reference': (IamIdpReferenceRelationship,),  # noqa: E501
            'organization': (OrganizationOrganizationRelationship,),  # noqa: E501
            'service_item_action_instances': ([WorkflowServiceItemActionInstanceRelationship], none_type,),  # noqa: E501
            'service_item_instances': ([WorkflowServiceItemInstanceRelationship], none_type,),  # noqa: E501
            'user': (IamUserRelationship,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'class_id': 'ClassId',  # noqa: E501
        'object_type': 'ObjectType',  # noqa: E501
        'description': 'Description',  # noqa: E501
        'end_time': 'EndTime',  # noqa: E501
        'input': 'Input',  # noqa: E501
        'label': 'Label',  # noqa: E501
        'messages': 'Messages',  # noqa: E501
        'name': 'Name',  # noqa: E501
        'operation': 'Operation',  # noqa: E501
        'selection_criteria_inputs': 'SelectionCriteriaInputs',  # noqa: E501
        'status': 'Status',  # noqa: E501
        'user_id_or_email': 'UserIdOrEmail',  # noqa: E501
        'catalog_item_definition': 'CatalogItemDefinition',  # noqa: E501
        'idp': 'Idp',  # noqa: E501
        'idp_reference': 'IdpReference',  # noqa: E501
        'organization': 'Organization',  # noqa: E501
        'service_item_action_instances': 'ServiceItemActionInstances',  # noqa: E501
        'service_item_instances': 'ServiceItemInstances',  # noqa: E501
        'user': 'User',  # noqa: E501
    }

    read_only_vars = {
        'end_time',  # noqa: E501
        'status',  # noqa: E501
        'user_id_or_email',  # noqa: E501
        'service_item_action_instances',  # noqa: E501
        'service_item_instances',  # noqa: E501
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """WorkflowCatalogServiceRequestAllOf - a model defined in OpenAPI

        Args:

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "workflow.CatalogServiceRequest", must be one of ["workflow.CatalogServiceRequest", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "workflow.CatalogServiceRequest", must be one of ["workflow.CatalogServiceRequest", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            description (str): The description for this catalog service request which provides information on request from the user.. [optional]  # noqa: E501
            end_time (datetime): The time at which the service request completed or stopped.. [optional]  # noqa: E501
            input (bool, date, datetime, dict, float, int, list, str, none_type): Inputs for a catalog service request instance creation, format is specified by input definition of the catalog item definition.. [optional]  # noqa: E501
            label (str): A user friendly short name to identify the catalog service request instance. Name can only contain letters (a-z, A-Z), numbers (0-9), hyphen (-), period (.), colon (:), space ( ) or an underscore (_).. [optional]  # noqa: E501
            messages ([ServicerequestMessage], none_type): [optional]  # noqa: E501
            name (str): A name of the catalog service request instance.. [optional]  # noqa: E501
            operation (WorkflowBaseOperation): [optional]  # noqa: E501
            selection_criteria_inputs ([ServiceitemSelectionCriteriaInput], none_type): [optional]  # noqa: E501
            status (str): Status of the catalog service request instance which determines the actions that are allowed on this instance. * `NotCreated` - The service item is not yet created and it is in a draft mode. A service item instance can be deleted in this state. * `InProgress` - An action is in progress and until that action has reached a final state, another action cannot be started. * `Failed` - The last action on the service item instance failed and corrective measures need to be taken to bring the service item instance back to valid state. * `Okay` - The last action on the service item instance completed and the service item instance is in Okay state. * `Decommissioned` - The service item is decommissioned and can be safely deleted. A service item instance in any other state after it has been created cannot be deleted until it has been decommissioned.. [optional] if omitted the server will use the default value of "NotCreated"  # noqa: E501
            user_id_or_email (str): The user identifier who invoked the request to create the catalog service request.. [optional]  # noqa: E501
            catalog_item_definition (WorkflowCatalogItemDefinitionRelationship): [optional]  # noqa: E501
            idp (IamIdpRelationship): [optional]  # noqa: E501
            idp_reference (IamIdpReferenceRelationship): [optional]  # noqa: E501
            organization (OrganizationOrganizationRelationship): [optional]  # noqa: E501
            service_item_action_instances ([WorkflowServiceItemActionInstanceRelationship], none_type): An array of relationships to workflowServiceItemActionInstance resources.. [optional]  # noqa: E501
            service_item_instances ([WorkflowServiceItemInstanceRelationship], none_type): An array of relationships to workflowServiceItemInstance resources.. [optional]  # noqa: E501
            user (IamUserRelationship): [optional]  # noqa: E501
        """

        class_id = "workflow.CatalogServiceRequest" if len(kwargs.get('class_id','').strip()) == 0 else kwargs.get('class_id', "workflow.CatalogServiceRequest")
        object_type = "workflow.CatalogServiceRequest" if len(kwargs.get('object_type','').strip()) == 0 else kwargs.get('object_type', "workflow.CatalogServiceRequest")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', True)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.class_id = class_id
        self.object_type = object_type
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """WorkflowCatalogServiceRequestAllOf - a model defined in OpenAPI

        Args:

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "workflow.CatalogServiceRequest", must be one of ["workflow.CatalogServiceRequest", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "workflow.CatalogServiceRequest", must be one of ["workflow.CatalogServiceRequest", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            description (str): The description for this catalog service request which provides information on request from the user.. [optional]  # noqa: E501
            end_time (datetime): The time at which the service request completed or stopped.. [optional]  # noqa: E501
            input (bool, date, datetime, dict, float, int, list, str, none_type): Inputs for a catalog service request instance creation, format is specified by input definition of the catalog item definition.. [optional]  # noqa: E501
            label (str): A user friendly short name to identify the catalog service request instance. Name can only contain letters (a-z, A-Z), numbers (0-9), hyphen (-), period (.), colon (:), space ( ) or an underscore (_).. [optional]  # noqa: E501
            messages ([ServicerequestMessage], none_type): [optional]  # noqa: E501
            name (str): A name of the catalog service request instance.. [optional]  # noqa: E501
            operation (WorkflowBaseOperation): [optional]  # noqa: E501
            selection_criteria_inputs ([ServiceitemSelectionCriteriaInput], none_type): [optional]  # noqa: E501
            status (str): Status of the catalog service request instance which determines the actions that are allowed on this instance. * `NotCreated` - The service item is not yet created and it is in a draft mode. A service item instance can be deleted in this state. * `InProgress` - An action is in progress and until that action has reached a final state, another action cannot be started. * `Failed` - The last action on the service item instance failed and corrective measures need to be taken to bring the service item instance back to valid state. * `Okay` - The last action on the service item instance completed and the service item instance is in Okay state. * `Decommissioned` - The service item is decommissioned and can be safely deleted. A service item instance in any other state after it has been created cannot be deleted until it has been decommissioned.. [optional] if omitted the server will use the default value of "NotCreated"  # noqa: E501
            user_id_or_email (str): The user identifier who invoked the request to create the catalog service request.. [optional]  # noqa: E501
            catalog_item_definition (WorkflowCatalogItemDefinitionRelationship): [optional]  # noqa: E501
            idp (IamIdpRelationship): [optional]  # noqa: E501
            idp_reference (IamIdpReferenceRelationship): [optional]  # noqa: E501
            organization (OrganizationOrganizationRelationship): [optional]  # noqa: E501
            service_item_action_instances ([WorkflowServiceItemActionInstanceRelationship], none_type): An array of relationships to workflowServiceItemActionInstance resources.. [optional]  # noqa: E501
            service_item_instances ([WorkflowServiceItemInstanceRelationship], none_type): An array of relationships to workflowServiceItemInstance resources.. [optional]  # noqa: E501
            user (IamUserRelationship): [optional]  # noqa: E501
        """

        class_id = "workflow.CatalogServiceRequest" if len(kwargs.get('class_id','').strip()) == 0 else kwargs.get('class_id', "workflow.CatalogServiceRequest")
        object_type = "workflow.CatalogServiceRequest" if len(kwargs.get('object_type','').strip()) == 0 else kwargs.get('object_type', "workflow.CatalogServiceRequest")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.class_id = class_id
        self.object_type = object_type
        for var_name, var_value in kwargs.items():
            if var_name in self.read_only_vars:
                set_model_init_error(f"Warning : {var_name} is omitted from request payload as it is a read-only property")
                continue
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
