"""
    Cisco Intersight

    Cisco Intersight is a management platform delivered as a service with embedded analytics for your Cisco and 3rd party IT infrastructure. This platform offers an intelligent level of management that enables IT organizations to analyze, simplify, and automate their environments in more advanced ways than the prior generations of tools. Cisco Intersight provides an integrated and intuitive management experience for resources in the traditional data center as well as at the edge. With flexible deployment options to address complex security needs, getting started with Intersight is quick and easy. Cisco Intersight has deep integration with Cisco UCS and HyperFlex systems allowing for remote deployment, configuration, and ongoing maintenance. The model-based deployment works for a single system in a remote location or hundreds of systems in a data center and enables rapid, standardized configuration and deployment. It also streamlines maintaining those systems whether you are working with small or very large configurations. The Intersight OpenAPI document defines the complete set of properties that are returned in the HTTP response. From that perspective, a client can expect that no additional properties are returned, unless these properties are explicitly defined in the OpenAPI document. However, when a client uses an older version of the Intersight OpenAPI document, the server may send additional properties because the software is more recent than the client. In that case, the client may receive properties that it does not know about. Some generated SDKs perform a strict validation of the HTTP response body against the OpenAPI document.  # noqa: E501

    The version of the OpenAPI document: 1.0.11-2025092610
    Contact: intersight@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from intersight.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    set_model_init_error,
    OpenApiModel
)
from intersight.exceptions import ApiAttributeError


def lazy_import():
    from intersight.model.workflow_base_data_type import WorkflowBaseDataType
    from intersight.model.workflow_catalog_relationship import WorkflowCatalogRelationship
    from intersight.model.workflow_service_item_action_definition_relationship import WorkflowServiceItemActionDefinitionRelationship
    from intersight.model.workflow_validation_information import WorkflowValidationInformation
    globals()['WorkflowBaseDataType'] = WorkflowBaseDataType
    globals()['WorkflowCatalogRelationship'] = WorkflowCatalogRelationship
    globals()['WorkflowServiceItemActionDefinitionRelationship'] = WorkflowServiceItemActionDefinitionRelationship
    globals()['WorkflowValidationInformation'] = WorkflowValidationInformation


class WorkflowServiceItemDefinitionAllOf(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('class_id',): {
            'WORKFLOW.SERVICEITEMDEFINITION': "workflow.ServiceItemDefinition",
        },
        ('object_type',): {
            'WORKFLOW.SERVICEITEMDEFINITION': "workflow.ServiceItemDefinition",
        },
        ('license_entitlement',): {
            'BASE': "Base",
            'ESSENTIAL': "Essential",
            'STANDARD': "Standard",
            'ADVANTAGE': "Advantage",
            'PREMIER': "Premier",
            'IWO-ESSENTIAL': "IWO-Essential",
            'IWO-ADVANTAGE': "IWO-Advantage",
            'IWO-PREMIER': "IWO-Premier",
            'IKS-ADVANTAGE': "IKS-Advantage",
            'INC-PREMIER-1GFIXED': "INC-Premier-1GFixed",
            'INC-PREMIER-10GFIXED': "INC-Premier-10GFixed",
            'INC-PREMIER-100GFIXED': "INC-Premier-100GFixed",
            'INC-PREMIER-MOD4SLOT': "INC-Premier-Mod4Slot",
            'INC-PREMIER-MOD8SLOT': "INC-Premier-Mod8Slot",
            'INC-PREMIER-D2OPSFIXED': "INC-Premier-D2OpsFixed",
            'INC-PREMIER-D2OPSMOD': "INC-Premier-D2OpsMod",
            'INC-PREMIER-CENTRALIZEDMOD8SLOT': "INC-Premier-CentralizedMod8Slot",
            'INC-PREMIER-DISTRIBUTEDMOD8SLOT': "INC-Premier-DistributedMod8Slot",
            'ERP-ADVANTAGE': "ERP-Advantage",
            'INTERSIGHTTRIAL': "IntersightTrial",
            'IWOTRIAL': "IWOTrial",
            'IKSTRIAL': "IKSTrial",
            'INCTRIAL': "INCTrial",
        },
        ('publish_status',): {
            'DRAFT': "Draft",
            'PUBLISHED': "Published",
            'ARCHIVED': "Archived",
        },
        ('status',): {
            'OKAY': "Okay",
            'CRITICAL': "Critical",
            'WARNING': "Warning",
        },
        ('support_status',): {
            'SUPPORTED': "Supported",
            'BETA': "Beta",
            'DEPRECATED': "Deprecated",
        },
    }

    validations = {
        ('label',): {
            'regex': {
                'pattern': r'^[a-zA-Z0-9]+[\sa-zA-Z0-9_.:-]{1,92}$',  # noqa: E501
            },
        },
        ('name',): {
            'regex': {
                'pattern': r'^[a-zA-Z0-9_.:-]{1,64}$',  # noqa: E501
            },
        },
        ('version',): {
            'inclusive_minimum': 1,
        },
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'class_id': (str,),  # noqa: E501
            'object_type': (str,),  # noqa: E501
            'allow_multiple_service_item_instances': (bool,),  # noqa: E501
            'attribute_definition': ([WorkflowBaseDataType], none_type,),  # noqa: E501
            'create_user': (str,),  # noqa: E501
            'cvd_id': (str,),  # noqa: E501
            'default_version': (bool,),  # noqa: E501
            'delete_instance_on_decommission': (bool,),  # noqa: E501
            'description': (str,),  # noqa: E501
            'label': (str,),  # noqa: E501
            'license_entitlement': (str,),  # noqa: E501
            'mod_user': (str,),  # noqa: E501
            'name': (str,),  # noqa: E501
            'publish_status': (str,),  # noqa: E501
            'status': (str,),  # noqa: E501
            'support_status': (str,),  # noqa: E501
            'user_id_or_email': (str,),  # noqa: E501
            'validation_information': (WorkflowValidationInformation,),  # noqa: E501
            'version': (int,),  # noqa: E501
            'action_definitions': ([WorkflowServiceItemActionDefinitionRelationship], none_type,),  # noqa: E501
            'catalog': (WorkflowCatalogRelationship,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'class_id': 'ClassId',  # noqa: E501
        'object_type': 'ObjectType',  # noqa: E501
        'allow_multiple_service_item_instances': 'AllowMultipleServiceItemInstances',  # noqa: E501
        'attribute_definition': 'AttributeDefinition',  # noqa: E501
        'create_user': 'CreateUser',  # noqa: E501
        'cvd_id': 'CvdId',  # noqa: E501
        'default_version': 'DefaultVersion',  # noqa: E501
        'delete_instance_on_decommission': 'DeleteInstanceOnDecommission',  # noqa: E501
        'description': 'Description',  # noqa: E501
        'label': 'Label',  # noqa: E501
        'license_entitlement': 'LicenseEntitlement',  # noqa: E501
        'mod_user': 'ModUser',  # noqa: E501
        'name': 'Name',  # noqa: E501
        'publish_status': 'PublishStatus',  # noqa: E501
        'status': 'Status',  # noqa: E501
        'support_status': 'SupportStatus',  # noqa: E501
        'user_id_or_email': 'UserIdOrEmail',  # noqa: E501
        'validation_information': 'ValidationInformation',  # noqa: E501
        'version': 'Version',  # noqa: E501
        'action_definitions': 'ActionDefinitions',  # noqa: E501
        'catalog': 'Catalog',  # noqa: E501
    }

    read_only_vars = {
        'create_user',  # noqa: E501
        'license_entitlement',  # noqa: E501
        'mod_user',  # noqa: E501
        'status',  # noqa: E501
        'user_id_or_email',  # noqa: E501
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """WorkflowServiceItemDefinitionAllOf - a model defined in OpenAPI

        Args:

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "workflow.ServiceItemDefinition", must be one of ["workflow.ServiceItemDefinition", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "workflow.ServiceItemDefinition", must be one of ["workflow.ServiceItemDefinition", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            allow_multiple_service_item_instances (bool): Service item definition can declare that only one instance can be allowed within the customer account.. [optional] if omitted the server will use the default value of True  # noqa: E501
            attribute_definition ([WorkflowBaseDataType], none_type): [optional]  # noqa: E501
            create_user (str): The user identifier who created or cloned the service item definition.. [optional]  # noqa: E501
            cvd_id (str): The Cisco Validated Design (CVD) Identifier that this service item provides.. [optional]  # noqa: E501
            default_version (bool): The flag to indicate that this is the default version of the service item.. [optional] if omitted the server will use the default value of False  # noqa: E501
            delete_instance_on_decommission (bool): The flag to indicate that service item instance will be deleted after the completion of decommission action.. [optional] if omitted the server will use the default value of False  # noqa: E501
            description (str): The description for this service item which provides information on what are the pre-requisites to deploy the service item and what features are supported on the service item.. [optional]  # noqa: E501
            label (str): A user friendly short name to identify the service item. Name can only contain letters (a-z, A-Z), numbers (0-9), hyphen (-), period (.), colon (:), space ( ) or an underscore (_).. [optional]  # noqa: E501
            license_entitlement (str): License entitlement required to run this service item. * `Base` - Base as a License type. It is default license type. * `Essential` - Essential as a License type. * `Standard` - Standard as a License type. * `Advantage` - Advantage as a License type. * `Premier` - Premier as a License type. * `IWO-Essential` - IWO-Essential as a License type. * `IWO-Advantage` - IWO-Advantage as a License type. * `IWO-Premier` - IWO-Premier as a License type. * `IKS-Advantage` - IKS-Advantage as a License type. * `INC-Premier-1GFixed` - Premier 1G Fixed license tier for Intersight Nexus Cloud. * `INC-Premier-10GFixed` - Premier 10G Fixed license tier for Intersight Nexus Cloud. * `INC-Premier-100GFixed` - Premier 100G Fixed license tier for Intersight Nexus Cloud. * `INC-Premier-Mod4Slot` - Premier Modular 4 slot license tier for Intersight Nexus Cloud. * `INC-Premier-Mod8Slot` - Premier Modular 8 slot license tier for Intersight Nexus Cloud. * `INC-Premier-D2OpsFixed` - Premier D2Ops fixed license tier for Intersight Nexus Cloud. * `INC-Premier-D2OpsMod` - Premier D2Ops modular license tier for Intersight Nexus Cloud. * `INC-Premier-CentralizedMod8Slot` - Premier modular license tier of switch type CentralizedMod8Slot for Intersight Nexus Cloud. * `INC-Premier-DistributedMod8Slot` - Premier modular license tier of switch type DistributedMod8Slot for Intersight Nexus Cloud. * `ERP-Advantage` - Advantage license tier for ERP workflows. * `IntersightTrial` - Virtual dummy license type to indicate trial. Used for UI display of trial mode Intersight tiers. * `IWOTrial` - Virtual dummy license type to indicate trial. Used for UI display of trial mode IKS tiers. * `IKSTrial` - Virtual dummy license type to indicate trial. Used for UI display of trial mode IWO tiers. * `INCTrial` - Virtual dummy license type to indicate trial. Used for UI display of trial mode Nexus tiers.. [optional] if omitted the server will use the default value of "Base"  # noqa: E501
            mod_user (str): The user identifier who last updated the service item definition.. [optional]  # noqa: E501
            name (str): The name for this service item definition. You can have multiple versions of the service item with the same name. Name can only contain letters (a-z, A-Z), numbers (0-9), hyphen (-), period (.), colon (:) or an underscore (_).. [optional]  # noqa: E501
            publish_status (str): The publish status of service item (Draft, Published, Archived). * `Draft` - The enum specifies the option as Draft which means the meta definition is being designed and tested. * `Published` - The enum specifies the option as Published which means the meta definition is ready for consumption. * `Archived` - The enum specifies the option as Archived which means the meta definition is archived and can no longer be consumed.. [optional] if omitted the server will use the default value of "Draft"  # noqa: E501
            status (str): State of service item considering the state of underlying service item actions definitions. * `Okay` - Deployment and other post-deployment actions are in valid state. * `Critical` - Deployment action is not in valid state. * `Warning` - Deployment action is in valid state, and one or more post-deployment actions are not in valid state.. [optional] if omitted the server will use the default value of "Okay"  # noqa: E501
            support_status (str): The service item can be marked as deprecated, supported or beta, the support status indicates that. When a new service item is introduced, it can be marked beta to indicate this is experimental and later moved to Supported status. When Service item is deprecated, it cannot be instantiated and used for a Catalog Item design. * `Supported` - The definition is a supported version and there will be no changes to the mandatory inputs or outputs. * `Beta` - The definition is a Beta version and this version can under go changes until the version is marked supported. * `Deprecated` - The version of definition is deprecated and typically there will be a higher version of the same definition that has been added.. [optional] if omitted the server will use the default value of "Supported"  # noqa: E501
            user_id_or_email (str): This attribute is deprecated and replaced by createUser and modUser.. [optional]  # noqa: E501
            validation_information (WorkflowValidationInformation): [optional]  # noqa: E501
            version (int): The version of the service item to support multiple versions.. [optional] if omitted the server will use the default value of 1  # noqa: E501
            action_definitions ([WorkflowServiceItemActionDefinitionRelationship], none_type): An array of relationships to workflowServiceItemActionDefinition resources.. [optional]  # noqa: E501
            catalog (WorkflowCatalogRelationship): [optional]  # noqa: E501
        """

        class_id = "workflow.ServiceItemDefinition" if len(kwargs.get('class_id','').strip()) == 0 else kwargs.get('class_id', "workflow.ServiceItemDefinition")
        object_type = "workflow.ServiceItemDefinition" if len(kwargs.get('object_type','').strip()) == 0 else kwargs.get('object_type', "workflow.ServiceItemDefinition")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', True)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.class_id = class_id
        self.object_type = object_type
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """WorkflowServiceItemDefinitionAllOf - a model defined in OpenAPI

        Args:

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "workflow.ServiceItemDefinition", must be one of ["workflow.ServiceItemDefinition", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "workflow.ServiceItemDefinition", must be one of ["workflow.ServiceItemDefinition", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            allow_multiple_service_item_instances (bool): Service item definition can declare that only one instance can be allowed within the customer account.. [optional] if omitted the server will use the default value of True  # noqa: E501
            attribute_definition ([WorkflowBaseDataType], none_type): [optional]  # noqa: E501
            create_user (str): The user identifier who created or cloned the service item definition.. [optional]  # noqa: E501
            cvd_id (str): The Cisco Validated Design (CVD) Identifier that this service item provides.. [optional]  # noqa: E501
            default_version (bool): The flag to indicate that this is the default version of the service item.. [optional] if omitted the server will use the default value of False  # noqa: E501
            delete_instance_on_decommission (bool): The flag to indicate that service item instance will be deleted after the completion of decommission action.. [optional] if omitted the server will use the default value of False  # noqa: E501
            description (str): The description for this service item which provides information on what are the pre-requisites to deploy the service item and what features are supported on the service item.. [optional]  # noqa: E501
            label (str): A user friendly short name to identify the service item. Name can only contain letters (a-z, A-Z), numbers (0-9), hyphen (-), period (.), colon (:), space ( ) or an underscore (_).. [optional]  # noqa: E501
            license_entitlement (str): License entitlement required to run this service item. * `Base` - Base as a License type. It is default license type. * `Essential` - Essential as a License type. * `Standard` - Standard as a License type. * `Advantage` - Advantage as a License type. * `Premier` - Premier as a License type. * `IWO-Essential` - IWO-Essential as a License type. * `IWO-Advantage` - IWO-Advantage as a License type. * `IWO-Premier` - IWO-Premier as a License type. * `IKS-Advantage` - IKS-Advantage as a License type. * `INC-Premier-1GFixed` - Premier 1G Fixed license tier for Intersight Nexus Cloud. * `INC-Premier-10GFixed` - Premier 10G Fixed license tier for Intersight Nexus Cloud. * `INC-Premier-100GFixed` - Premier 100G Fixed license tier for Intersight Nexus Cloud. * `INC-Premier-Mod4Slot` - Premier Modular 4 slot license tier for Intersight Nexus Cloud. * `INC-Premier-Mod8Slot` - Premier Modular 8 slot license tier for Intersight Nexus Cloud. * `INC-Premier-D2OpsFixed` - Premier D2Ops fixed license tier for Intersight Nexus Cloud. * `INC-Premier-D2OpsMod` - Premier D2Ops modular license tier for Intersight Nexus Cloud. * `INC-Premier-CentralizedMod8Slot` - Premier modular license tier of switch type CentralizedMod8Slot for Intersight Nexus Cloud. * `INC-Premier-DistributedMod8Slot` - Premier modular license tier of switch type DistributedMod8Slot for Intersight Nexus Cloud. * `ERP-Advantage` - Advantage license tier for ERP workflows. * `IntersightTrial` - Virtual dummy license type to indicate trial. Used for UI display of trial mode Intersight tiers. * `IWOTrial` - Virtual dummy license type to indicate trial. Used for UI display of trial mode IKS tiers. * `IKSTrial` - Virtual dummy license type to indicate trial. Used for UI display of trial mode IWO tiers. * `INCTrial` - Virtual dummy license type to indicate trial. Used for UI display of trial mode Nexus tiers.. [optional] if omitted the server will use the default value of "Base"  # noqa: E501
            mod_user (str): The user identifier who last updated the service item definition.. [optional]  # noqa: E501
            name (str): The name for this service item definition. You can have multiple versions of the service item with the same name. Name can only contain letters (a-z, A-Z), numbers (0-9), hyphen (-), period (.), colon (:) or an underscore (_).. [optional]  # noqa: E501
            publish_status (str): The publish status of service item (Draft, Published, Archived). * `Draft` - The enum specifies the option as Draft which means the meta definition is being designed and tested. * `Published` - The enum specifies the option as Published which means the meta definition is ready for consumption. * `Archived` - The enum specifies the option as Archived which means the meta definition is archived and can no longer be consumed.. [optional] if omitted the server will use the default value of "Draft"  # noqa: E501
            status (str): State of service item considering the state of underlying service item actions definitions. * `Okay` - Deployment and other post-deployment actions are in valid state. * `Critical` - Deployment action is not in valid state. * `Warning` - Deployment action is in valid state, and one or more post-deployment actions are not in valid state.. [optional] if omitted the server will use the default value of "Okay"  # noqa: E501
            support_status (str): The service item can be marked as deprecated, supported or beta, the support status indicates that. When a new service item is introduced, it can be marked beta to indicate this is experimental and later moved to Supported status. When Service item is deprecated, it cannot be instantiated and used for a Catalog Item design. * `Supported` - The definition is a supported version and there will be no changes to the mandatory inputs or outputs. * `Beta` - The definition is a Beta version and this version can under go changes until the version is marked supported. * `Deprecated` - The version of definition is deprecated and typically there will be a higher version of the same definition that has been added.. [optional] if omitted the server will use the default value of "Supported"  # noqa: E501
            user_id_or_email (str): This attribute is deprecated and replaced by createUser and modUser.. [optional]  # noqa: E501
            validation_information (WorkflowValidationInformation): [optional]  # noqa: E501
            version (int): The version of the service item to support multiple versions.. [optional] if omitted the server will use the default value of 1  # noqa: E501
            action_definitions ([WorkflowServiceItemActionDefinitionRelationship], none_type): An array of relationships to workflowServiceItemActionDefinition resources.. [optional]  # noqa: E501
            catalog (WorkflowCatalogRelationship): [optional]  # noqa: E501
        """

        class_id = "workflow.ServiceItemDefinition" if len(kwargs.get('class_id','').strip()) == 0 else kwargs.get('class_id', "workflow.ServiceItemDefinition")
        object_type = "workflow.ServiceItemDefinition" if len(kwargs.get('object_type','').strip()) == 0 else kwargs.get('object_type', "workflow.ServiceItemDefinition")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.class_id = class_id
        self.object_type = object_type
        for var_name, var_value in kwargs.items():
            if var_name in self.read_only_vars:
                set_model_init_error(f"Warning : {var_name} is omitted from request payload as it is a read-only property")
                continue
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
