"""
    Cisco Intersight

    Cisco Intersight is a management platform delivered as a service with embedded analytics for your Cisco and 3rd party IT infrastructure. This platform offers an intelligent level of management that enables IT organizations to analyze, simplify, and automate their environments in more advanced ways than the prior generations of tools. Cisco Intersight provides an integrated and intuitive management experience for resources in the traditional data center as well as at the edge. With flexible deployment options to address complex security needs, getting started with Intersight is quick and easy. Cisco Intersight has deep integration with Cisco UCS and HyperFlex systems allowing for remote deployment, configuration, and ongoing maintenance. The model-based deployment works for a single system in a remote location or hundreds of systems in a data center and enables rapid, standardized configuration and deployment. It also streamlines maintaining those systems whether you are working with small or very large configurations. The Intersight OpenAPI document defines the complete set of properties that are returned in the HTTP response. From that perspective, a client can expect that no additional properties are returned, unless these properties are explicitly defined in the OpenAPI document. However, when a client uses an older version of the Intersight OpenAPI document, the server may send additional properties because the software is more recent than the client. In that case, the client may receive properties that it does not know about. Some generated SDKs perform a strict validation of the HTTP response body against the OpenAPI document.  # noqa: E501

    The version of the OpenAPI document: 1.0.11-2025092610
    Contact: intersight@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from intersight.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    set_model_init_error,
    OpenApiModel
)
from intersight.exceptions import ApiAttributeError


def lazy_import():
    from intersight.model.workflow_message import WorkflowMessage
    from intersight.model.workflow_task_definition_relationship import WorkflowTaskDefinitionRelationship
    from intersight.model.workflow_task_loop_info import WorkflowTaskLoopInfo
    from intersight.model.workflow_task_retry_info import WorkflowTaskRetryInfo
    from intersight.model.workflow_workflow_info_relationship import WorkflowWorkflowInfoRelationship
    globals()['WorkflowMessage'] = WorkflowMessage
    globals()['WorkflowTaskDefinitionRelationship'] = WorkflowTaskDefinitionRelationship
    globals()['WorkflowTaskLoopInfo'] = WorkflowTaskLoopInfo
    globals()['WorkflowTaskRetryInfo'] = WorkflowTaskRetryInfo
    globals()['WorkflowWorkflowInfoRelationship'] = WorkflowWorkflowInfoRelationship


class WorkflowTaskInfoAllOf(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('class_id',): {
            'WORKFLOW.TASKINFO': "workflow.TaskInfo",
        },
        ('object_type',): {
            'WORKFLOW.TASKINFO': "workflow.TaskInfo",
        },
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'class_id': (str,),  # noqa: E501
            'object_type': (str,),  # noqa: E501
            'description': (str,),  # noqa: E501
            'end_time': (datetime,),  # noqa: E501
            'failure_reason': (str,),  # noqa: E501
            'input': (bool, date, datetime, dict, float, int, list, str, none_type,),  # noqa: E501
            'inst_id': (str,),  # noqa: E501
            'internal': (bool,),  # noqa: E501
            'label': (str,),  # noqa: E501
            'message': ([WorkflowMessage], none_type,),  # noqa: E501
            'name': (str,),  # noqa: E501
            'output': (bool, date, datetime, dict, float, int, list, str, none_type,),  # noqa: E501
            'ref_name': (str,),  # noqa: E501
            'retry_count': (int,),  # noqa: E501
            'rollback_disabled': (bool,),  # noqa: E501
            'running_inst_id': (str,),  # noqa: E501
            'start_time': (datetime,),  # noqa: E501
            'status': (str,),  # noqa: E501
            'task_inst_id_list': ([WorkflowTaskRetryInfo], none_type,),  # noqa: E501
            'task_loop_info': (WorkflowTaskLoopInfo,),  # noqa: E501
            'sub_workflow_info': (WorkflowWorkflowInfoRelationship,),  # noqa: E501
            'sub_workflow_retry_history': ([WorkflowWorkflowInfoRelationship], none_type,),  # noqa: E501
            'task_definition': (WorkflowTaskDefinitionRelationship,),  # noqa: E501
            'workflow_info': (WorkflowWorkflowInfoRelationship,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'class_id': 'ClassId',  # noqa: E501
        'object_type': 'ObjectType',  # noqa: E501
        'description': 'Description',  # noqa: E501
        'end_time': 'EndTime',  # noqa: E501
        'failure_reason': 'FailureReason',  # noqa: E501
        'input': 'Input',  # noqa: E501
        'inst_id': 'InstId',  # noqa: E501
        'internal': 'Internal',  # noqa: E501
        'label': 'Label',  # noqa: E501
        'message': 'Message',  # noqa: E501
        'name': 'Name',  # noqa: E501
        'output': 'Output',  # noqa: E501
        'ref_name': 'RefName',  # noqa: E501
        'retry_count': 'RetryCount',  # noqa: E501
        'rollback_disabled': 'RollbackDisabled',  # noqa: E501
        'running_inst_id': 'RunningInstId',  # noqa: E501
        'start_time': 'StartTime',  # noqa: E501
        'status': 'Status',  # noqa: E501
        'task_inst_id_list': 'TaskInstIdList',  # noqa: E501
        'task_loop_info': 'TaskLoopInfo',  # noqa: E501
        'sub_workflow_info': 'SubWorkflowInfo',  # noqa: E501
        'sub_workflow_retry_history': 'SubWorkflowRetryHistory',  # noqa: E501
        'task_definition': 'TaskDefinition',  # noqa: E501
        'workflow_info': 'WorkflowInfo',  # noqa: E501
    }

    read_only_vars = {
        'description',  # noqa: E501
        'end_time',  # noqa: E501
        'failure_reason',  # noqa: E501
        'input',  # noqa: E501
        'inst_id',  # noqa: E501
        'internal',  # noqa: E501
        'label',  # noqa: E501
        'name',  # noqa: E501
        'output',  # noqa: E501
        'ref_name',  # noqa: E501
        'retry_count',  # noqa: E501
        'rollback_disabled',  # noqa: E501
        'running_inst_id',  # noqa: E501
        'start_time',  # noqa: E501
        'sub_workflow_retry_history',  # noqa: E501
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """WorkflowTaskInfoAllOf - a model defined in OpenAPI

        Args:

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "workflow.TaskInfo", must be one of ["workflow.TaskInfo", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "workflow.TaskInfo", must be one of ["workflow.TaskInfo", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            description (str): The task description and this is the description that was added when the task was included into the workflow.. [optional]  # noqa: E501
            end_time (datetime): The time stamp when the task reached a final state.. [optional]  # noqa: E501
            failure_reason (str): Description of the reason why the task failed.. [optional]  # noqa: E501
            input (bool, date, datetime, dict, float, int, list, str, none_type): The input data that was sent to the task at the start of execution. The schema for the inputs is provided in the Task Definition, hence the data provided in this field should adhere to that schema. Eg- If Task Definition takes two inputs with names A and B, then this field should contain key-value pairs having key as the name of the input and value should be provided matching the constraints of it's respective data type. Value can either be mapped from workflow input or previously executed task outputs or any liternal value.. [optional]  # noqa: E501
            inst_id (str): The instance ID of the task running in the workflow engine.. [optional]  # noqa: E501
            internal (bool): Denotes whether or not this is an internal task.  Internal tasks will be hidden from the UI within a workflow.. [optional]  # noqa: E501
            label (str): User friendly short label to describe this task instance in the workflow.. [optional]  # noqa: E501
            message ([WorkflowMessage], none_type): [optional]  # noqa: E501
            name (str): Task definition name which specifies the task type.. [optional]  # noqa: E501
            output (bool, date, datetime, dict, float, int, list, str, none_type): The output data that was generated by this task. The schema for the outputs is provided in the Task Definition, hence the data provided in this field should adhere to that schema. Eg- If Task Definition takes two outputs with names A and B, then this field contains key-value pairs having key as the name of the output and the corresponding value matches the constraints of it's respective data type.. [optional]  # noqa: E501
            ref_name (str): The task reference name to ensure its unique inside a workflow.. [optional]  # noqa: E501
            retry_count (int): Denotes the number of times the task has been retried.. [optional]  # noqa: E501
            rollback_disabled (bool): The task is disabled/enabled for rollback operation in this workflow if the task has rollback support.. [optional] if omitted the server will use the default value of False  # noqa: E501
            running_inst_id (str): The instance ID of the task that is currently being executed. When retrying a workflow with failed tasks, the task in workflow engine will have a new instance ID, but the task may still be in progress. In this case, the task instId reflects the instance ID in the workflow engine, while runningInstId reflects the instance ID of the instance that is currently being executed.. [optional]  # noqa: E501
            start_time (datetime): The time stamp when the task started execution.. [optional]  # noqa: E501
            status (str): The status of the task and this will specify if the task is running or has reached a final state.. [optional]  # noqa: E501
            task_inst_id_list ([WorkflowTaskRetryInfo], none_type): [optional]  # noqa: E501
            task_loop_info (WorkflowTaskLoopInfo): [optional]  # noqa: E501
            sub_workflow_info (WorkflowWorkflowInfoRelationship): [optional]  # noqa: E501
            sub_workflow_retry_history ([WorkflowWorkflowInfoRelationship], none_type): An array of relationships to workflowWorkflowInfo resources.. [optional]  # noqa: E501
            task_definition (WorkflowTaskDefinitionRelationship): [optional]  # noqa: E501
            workflow_info (WorkflowWorkflowInfoRelationship): [optional]  # noqa: E501
        """

        class_id = "workflow.TaskInfo" if len(kwargs.get('class_id','').strip()) == 0 else kwargs.get('class_id', "workflow.TaskInfo")
        object_type = "workflow.TaskInfo" if len(kwargs.get('object_type','').strip()) == 0 else kwargs.get('object_type', "workflow.TaskInfo")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', True)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.class_id = class_id
        self.object_type = object_type
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """WorkflowTaskInfoAllOf - a model defined in OpenAPI

        Args:

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "workflow.TaskInfo", must be one of ["workflow.TaskInfo", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "workflow.TaskInfo", must be one of ["workflow.TaskInfo", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            description (str): The task description and this is the description that was added when the task was included into the workflow.. [optional]  # noqa: E501
            end_time (datetime): The time stamp when the task reached a final state.. [optional]  # noqa: E501
            failure_reason (str): Description of the reason why the task failed.. [optional]  # noqa: E501
            input (bool, date, datetime, dict, float, int, list, str, none_type): The input data that was sent to the task at the start of execution. The schema for the inputs is provided in the Task Definition, hence the data provided in this field should adhere to that schema. Eg- If Task Definition takes two inputs with names A and B, then this field should contain key-value pairs having key as the name of the input and value should be provided matching the constraints of it's respective data type. Value can either be mapped from workflow input or previously executed task outputs or any liternal value.. [optional]  # noqa: E501
            inst_id (str): The instance ID of the task running in the workflow engine.. [optional]  # noqa: E501
            internal (bool): Denotes whether or not this is an internal task.  Internal tasks will be hidden from the UI within a workflow.. [optional]  # noqa: E501
            label (str): User friendly short label to describe this task instance in the workflow.. [optional]  # noqa: E501
            message ([WorkflowMessage], none_type): [optional]  # noqa: E501
            name (str): Task definition name which specifies the task type.. [optional]  # noqa: E501
            output (bool, date, datetime, dict, float, int, list, str, none_type): The output data that was generated by this task. The schema for the outputs is provided in the Task Definition, hence the data provided in this field should adhere to that schema. Eg- If Task Definition takes two outputs with names A and B, then this field contains key-value pairs having key as the name of the output and the corresponding value matches the constraints of it's respective data type.. [optional]  # noqa: E501
            ref_name (str): The task reference name to ensure its unique inside a workflow.. [optional]  # noqa: E501
            retry_count (int): Denotes the number of times the task has been retried.. [optional]  # noqa: E501
            rollback_disabled (bool): The task is disabled/enabled for rollback operation in this workflow if the task has rollback support.. [optional] if omitted the server will use the default value of False  # noqa: E501
            running_inst_id (str): The instance ID of the task that is currently being executed. When retrying a workflow with failed tasks, the task in workflow engine will have a new instance ID, but the task may still be in progress. In this case, the task instId reflects the instance ID in the workflow engine, while runningInstId reflects the instance ID of the instance that is currently being executed.. [optional]  # noqa: E501
            start_time (datetime): The time stamp when the task started execution.. [optional]  # noqa: E501
            status (str): The status of the task and this will specify if the task is running or has reached a final state.. [optional]  # noqa: E501
            task_inst_id_list ([WorkflowTaskRetryInfo], none_type): [optional]  # noqa: E501
            task_loop_info (WorkflowTaskLoopInfo): [optional]  # noqa: E501
            sub_workflow_info (WorkflowWorkflowInfoRelationship): [optional]  # noqa: E501
            sub_workflow_retry_history ([WorkflowWorkflowInfoRelationship], none_type): An array of relationships to workflowWorkflowInfo resources.. [optional]  # noqa: E501
            task_definition (WorkflowTaskDefinitionRelationship): [optional]  # noqa: E501
            workflow_info (WorkflowWorkflowInfoRelationship): [optional]  # noqa: E501
        """

        class_id = "workflow.TaskInfo" if len(kwargs.get('class_id','').strip()) == 0 else kwargs.get('class_id', "workflow.TaskInfo")
        object_type = "workflow.TaskInfo" if len(kwargs.get('object_type','').strip()) == 0 else kwargs.get('object_type', "workflow.TaskInfo")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.class_id = class_id
        self.object_type = object_type
        for var_name, var_value in kwargs.items():
            if var_name in self.read_only_vars:
                set_model_init_error(f"Warning : {var_name} is omitted from request payload as it is a read-only property")
                continue
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
