# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'CdnDistributionConfigArgs',
    'CdnDistributionConfigArgsDict',
    'CdnDistributionConfigBackendArgs',
    'CdnDistributionConfigBackendArgsDict',
    'CdnDistributionConfigOptimizerArgs',
    'CdnDistributionConfigOptimizerArgsDict',
    'CdnDistributionDomainArgs',
    'CdnDistributionDomainArgsDict',
    'ImageChecksumArgs',
    'ImageChecksumArgsDict',
    'ImageConfigArgs',
    'ImageConfigArgsDict',
    'LoadbalancerListenerArgs',
    'LoadbalancerListenerArgsDict',
    'LoadbalancerListenerServerNameIndicatorArgs',
    'LoadbalancerListenerServerNameIndicatorArgsDict',
    'LoadbalancerNetworkArgs',
    'LoadbalancerNetworkArgsDict',
    'LoadbalancerOptionsArgs',
    'LoadbalancerOptionsArgsDict',
    'LoadbalancerOptionsObservabilityArgs',
    'LoadbalancerOptionsObservabilityArgsDict',
    'LoadbalancerOptionsObservabilityLogsArgs',
    'LoadbalancerOptionsObservabilityLogsArgsDict',
    'LoadbalancerOptionsObservabilityMetricsArgs',
    'LoadbalancerOptionsObservabilityMetricsArgsDict',
    'LoadbalancerTargetPoolArgs',
    'LoadbalancerTargetPoolArgsDict',
    'LoadbalancerTargetPoolActiveHealthCheckArgs',
    'LoadbalancerTargetPoolActiveHealthCheckArgsDict',
    'LoadbalancerTargetPoolSessionPersistenceArgs',
    'LoadbalancerTargetPoolSessionPersistenceArgsDict',
    'LoadbalancerTargetPoolTargetArgs',
    'LoadbalancerTargetPoolTargetArgsDict',
    'LogmeInstanceParametersArgs',
    'LogmeInstanceParametersArgsDict',
    'MariadbInstanceParametersArgs',
    'MariadbInstanceParametersArgsDict',
    'MongodbflexInstanceFlavorArgs',
    'MongodbflexInstanceFlavorArgsDict',
    'MongodbflexInstanceOptionsArgs',
    'MongodbflexInstanceOptionsArgsDict',
    'MongodbflexInstanceStorageArgs',
    'MongodbflexInstanceStorageArgsDict',
    'NetworkAreaNetworkRangeArgs',
    'NetworkAreaNetworkRangeArgsDict',
    'ObservabilityAlertgroupRuleArgs',
    'ObservabilityAlertgroupRuleArgsDict',
    'ObservabilityInstanceAlertConfigArgs',
    'ObservabilityInstanceAlertConfigArgsDict',
    'ObservabilityInstanceAlertConfigGlobalArgs',
    'ObservabilityInstanceAlertConfigGlobalArgsDict',
    'ObservabilityInstanceAlertConfigReceiverArgs',
    'ObservabilityInstanceAlertConfigReceiverArgsDict',
    'ObservabilityInstanceAlertConfigReceiverEmailConfigArgs',
    'ObservabilityInstanceAlertConfigReceiverEmailConfigArgsDict',
    'ObservabilityInstanceAlertConfigReceiverOpsgenieConfigArgs',
    'ObservabilityInstanceAlertConfigReceiverOpsgenieConfigArgsDict',
    'ObservabilityInstanceAlertConfigReceiverWebhooksConfigArgs',
    'ObservabilityInstanceAlertConfigReceiverWebhooksConfigArgsDict',
    'ObservabilityInstanceAlertConfigRouteArgs',
    'ObservabilityInstanceAlertConfigRouteArgsDict',
    'ObservabilityInstanceAlertConfigRouteRouteArgs',
    'ObservabilityInstanceAlertConfigRouteRouteArgsDict',
    'ObservabilityLogalertgroupRuleArgs',
    'ObservabilityLogalertgroupRuleArgsDict',
    'ObservabilityScrapeconfigBasicAuthArgs',
    'ObservabilityScrapeconfigBasicAuthArgsDict',
    'ObservabilityScrapeconfigSaml2Args',
    'ObservabilityScrapeconfigSaml2ArgsDict',
    'ObservabilityScrapeconfigTargetArgs',
    'ObservabilityScrapeconfigTargetArgsDict',
    'OpensearchInstanceParametersArgs',
    'OpensearchInstanceParametersArgsDict',
    'PostgresflexInstanceFlavorArgs',
    'PostgresflexInstanceFlavorArgsDict',
    'PostgresflexInstanceStorageArgs',
    'PostgresflexInstanceStorageArgsDict',
    'RabbitmqInstanceParametersArgs',
    'RabbitmqInstanceParametersArgsDict',
    'RedisInstanceParametersArgs',
    'RedisInstanceParametersArgsDict',
    'RoutingTableRouteDestinationArgs',
    'RoutingTableRouteDestinationArgsDict',
    'RoutingTableRouteNextHopArgs',
    'RoutingTableRouteNextHopArgsDict',
    'SecurityGroupRuleIcmpParametersArgs',
    'SecurityGroupRuleIcmpParametersArgsDict',
    'SecurityGroupRulePortRangeArgs',
    'SecurityGroupRulePortRangeArgsDict',
    'SecurityGroupRuleProtocolArgs',
    'SecurityGroupRuleProtocolArgsDict',
    'ServerBackupScheduleBackupPropertiesArgs',
    'ServerBackupScheduleBackupPropertiesArgsDict',
    'ServerBootVolumeArgs',
    'ServerBootVolumeArgsDict',
    'SkeClusterExtensionsArgs',
    'SkeClusterExtensionsArgsDict',
    'SkeClusterExtensionsAclArgs',
    'SkeClusterExtensionsAclArgsDict',
    'SkeClusterExtensionsArgusArgs',
    'SkeClusterExtensionsArgusArgsDict',
    'SkeClusterExtensionsDnsArgs',
    'SkeClusterExtensionsDnsArgsDict',
    'SkeClusterExtensionsObservabilityArgs',
    'SkeClusterExtensionsObservabilityArgsDict',
    'SkeClusterHibernationArgs',
    'SkeClusterHibernationArgsDict',
    'SkeClusterMaintenanceArgs',
    'SkeClusterMaintenanceArgsDict',
    'SkeClusterNetworkArgs',
    'SkeClusterNetworkArgsDict',
    'SkeClusterNodePoolArgs',
    'SkeClusterNodePoolArgsDict',
    'SkeClusterNodePoolTaintArgs',
    'SkeClusterNodePoolTaintArgsDict',
    'SqlserverflexInstanceFlavorArgs',
    'SqlserverflexInstanceFlavorArgsDict',
    'SqlserverflexInstanceOptionsArgs',
    'SqlserverflexInstanceOptionsArgsDict',
    'SqlserverflexInstanceStorageArgs',
    'SqlserverflexInstanceStorageArgsDict',
    'VolumeSourceArgs',
    'VolumeSourceArgsDict',
]

MYPY = False

if not MYPY:
    class CdnDistributionConfigArgsDict(TypedDict):
        backend: pulumi.Input['CdnDistributionConfigBackendArgsDict']
        """
        The configured backend for the distribution
        """
        regions: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]
        """
        The configured regions where content will be hosted
        """
        blocked_countries: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        The configured countries where distribution of content is blocked
        """
        optimizer: NotRequired[pulumi.Input['CdnDistributionConfigOptimizerArgsDict']]
        """
        Configuration for the Image Optimizer. This is a paid feature that automatically optimizes images to reduce their file size for faster delivery, leading to improved website performance and a better user experience.
        """
elif False:
    CdnDistributionConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CdnDistributionConfigArgs:
    def __init__(__self__, *,
                 backend: pulumi.Input['CdnDistributionConfigBackendArgs'],
                 regions: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 blocked_countries: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 optimizer: Optional[pulumi.Input['CdnDistributionConfigOptimizerArgs']] = None):
        """
        :param pulumi.Input['CdnDistributionConfigBackendArgs'] backend: The configured backend for the distribution
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] regions: The configured regions where content will be hosted
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] blocked_countries: The configured countries where distribution of content is blocked
        :param pulumi.Input['CdnDistributionConfigOptimizerArgs'] optimizer: Configuration for the Image Optimizer. This is a paid feature that automatically optimizes images to reduce their file size for faster delivery, leading to improved website performance and a better user experience.
        """
        pulumi.set(__self__, "backend", backend)
        pulumi.set(__self__, "regions", regions)
        if blocked_countries is not None:
            pulumi.set(__self__, "blocked_countries", blocked_countries)
        if optimizer is not None:
            pulumi.set(__self__, "optimizer", optimizer)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> pulumi.Input['CdnDistributionConfigBackendArgs']:
        """
        The configured backend for the distribution
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: pulumi.Input['CdnDistributionConfigBackendArgs']):
        pulumi.set(self, "backend", value)

    @_builtins.property
    @pulumi.getter
    def regions(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The configured regions where content will be hosted
        """
        return pulumi.get(self, "regions")

    @regions.setter
    def regions(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "regions", value)

    @_builtins.property
    @pulumi.getter(name="blockedCountries")
    def blocked_countries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The configured countries where distribution of content is blocked
        """
        return pulumi.get(self, "blocked_countries")

    @blocked_countries.setter
    def blocked_countries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "blocked_countries", value)

    @_builtins.property
    @pulumi.getter
    def optimizer(self) -> Optional[pulumi.Input['CdnDistributionConfigOptimizerArgs']]:
        """
        Configuration for the Image Optimizer. This is a paid feature that automatically optimizes images to reduce their file size for faster delivery, leading to improved website performance and a better user experience.
        """
        return pulumi.get(self, "optimizer")

    @optimizer.setter
    def optimizer(self, value: Optional[pulumi.Input['CdnDistributionConfigOptimizerArgs']]):
        pulumi.set(self, "optimizer", value)


if not MYPY:
    class CdnDistributionConfigBackendArgsDict(TypedDict):
        origin_url: pulumi.Input[_builtins.str]
        """
        The configured backend type for the distribution
        """
        type: pulumi.Input[_builtins.str]
        """
        The configured backend type. Supported values are: `http`.
        """
        origin_request_headers: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]
        """
        The configured origin request headers for the backend
        """
elif False:
    CdnDistributionConfigBackendArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CdnDistributionConfigBackendArgs:
    def __init__(__self__, *,
                 origin_url: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 origin_request_headers: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        :param pulumi.Input[_builtins.str] origin_url: The configured backend type for the distribution
        :param pulumi.Input[_builtins.str] type: The configured backend type. Supported values are: `http`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] origin_request_headers: The configured origin request headers for the backend
        """
        pulumi.set(__self__, "origin_url", origin_url)
        pulumi.set(__self__, "type", type)
        if origin_request_headers is not None:
            pulumi.set(__self__, "origin_request_headers", origin_request_headers)

    @_builtins.property
    @pulumi.getter(name="originUrl")
    def origin_url(self) -> pulumi.Input[_builtins.str]:
        """
        The configured backend type for the distribution
        """
        return pulumi.get(self, "origin_url")

    @origin_url.setter
    def origin_url(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "origin_url", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The configured backend type. Supported values are: `http`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="originRequestHeaders")
    def origin_request_headers(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The configured origin request headers for the backend
        """
        return pulumi.get(self, "origin_request_headers")

    @origin_request_headers.setter
    def origin_request_headers(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "origin_request_headers", value)


if not MYPY:
    class CdnDistributionConfigOptimizerArgsDict(TypedDict):
        enabled: NotRequired[pulumi.Input[_builtins.bool]]
elif False:
    CdnDistributionConfigOptimizerArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CdnDistributionConfigOptimizerArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)


if not MYPY:
    class CdnDistributionDomainArgsDict(TypedDict):
        errors: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        List of domain errors
        """
        name: NotRequired[pulumi.Input[_builtins.str]]
        """
        The name of the domain
        """
        status: NotRequired[pulumi.Input[_builtins.str]]
        """
        The status of the domain
        """
        type: NotRequired[pulumi.Input[_builtins.str]]
        """
        The type of the domain. Each distribution has one domain of type "managed", and domains of type "custom" may be additionally created by the user
        """
elif False:
    CdnDistributionDomainArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CdnDistributionDomainArgs:
    def __init__(__self__, *,
                 errors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] errors: List of domain errors
        :param pulumi.Input[_builtins.str] name: The name of the domain
        :param pulumi.Input[_builtins.str] status: The status of the domain
        :param pulumi.Input[_builtins.str] type: The type of the domain. Each distribution has one domain of type "managed", and domains of type "custom" may be additionally created by the user
        """
        if errors is not None:
            pulumi.set(__self__, "errors", errors)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def errors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of domain errors
        """
        return pulumi.get(self, "errors")

    @errors.setter
    def errors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "errors", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the domain
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the domain
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the domain. Each distribution has one domain of type "managed", and domains of type "custom" may be additionally created by the user
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


if not MYPY:
    class ImageChecksumArgsDict(TypedDict):
        algorithm: NotRequired[pulumi.Input[_builtins.str]]
        """
        Algorithm for the checksum of the image data.
        """
        digest: NotRequired[pulumi.Input[_builtins.str]]
        """
        Hexdigest of the checksum of the image data.
        """
elif False:
    ImageChecksumArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ImageChecksumArgs:
    def __init__(__self__, *,
                 algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 digest: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] algorithm: Algorithm for the checksum of the image data.
        :param pulumi.Input[_builtins.str] digest: Hexdigest of the checksum of the image data.
        """
        if algorithm is not None:
            pulumi.set(__self__, "algorithm", algorithm)
        if digest is not None:
            pulumi.set(__self__, "digest", digest)

    @_builtins.property
    @pulumi.getter
    def algorithm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Algorithm for the checksum of the image data.
        """
        return pulumi.get(self, "algorithm")

    @algorithm.setter
    def algorithm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "algorithm", value)

    @_builtins.property
    @pulumi.getter
    def digest(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Hexdigest of the checksum of the image data.
        """
        return pulumi.get(self, "digest")

    @digest.setter
    def digest(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "digest", value)


if not MYPY:
    class ImageConfigArgsDict(TypedDict):
        boot_menu: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Enables the BIOS bootmenu.
        """
        cdrom_bus: NotRequired[pulumi.Input[_builtins.str]]
        """
        Sets CDROM bus controller type.
        """
        disk_bus: NotRequired[pulumi.Input[_builtins.str]]
        """
        Sets Disk bus controller type.
        """
        nic_model: NotRequired[pulumi.Input[_builtins.str]]
        """
        Sets virtual network interface model.
        """
        operating_system: NotRequired[pulumi.Input[_builtins.str]]
        """
        Enables operating system specific optimizations.
        """
        operating_system_distro: NotRequired[pulumi.Input[_builtins.str]]
        """
        Operating system distribution.
        """
        operating_system_version: NotRequired[pulumi.Input[_builtins.str]]
        """
        Version of the operating system.
        """
        rescue_bus: NotRequired[pulumi.Input[_builtins.str]]
        """
        Sets the device bus when the image is used as a rescue image.
        """
        rescue_device: NotRequired[pulumi.Input[_builtins.str]]
        """
        Sets the device when the image is used as a rescue image.
        """
        secure_boot: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Enables Secure Boot.
        """
        uefi: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Enables UEFI boot.
        """
        video_model: NotRequired[pulumi.Input[_builtins.str]]
        """
        Sets Graphic device model.
        """
        virtio_scsi: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Enables the use of VirtIO SCSI to provide block device access. By default instances use VirtIO Block.
        """
elif False:
    ImageConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ImageConfigArgs:
    def __init__(__self__, *,
                 boot_menu: Optional[pulumi.Input[_builtins.bool]] = None,
                 cdrom_bus: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_bus: Optional[pulumi.Input[_builtins.str]] = None,
                 nic_model: Optional[pulumi.Input[_builtins.str]] = None,
                 operating_system: Optional[pulumi.Input[_builtins.str]] = None,
                 operating_system_distro: Optional[pulumi.Input[_builtins.str]] = None,
                 operating_system_version: Optional[pulumi.Input[_builtins.str]] = None,
                 rescue_bus: Optional[pulumi.Input[_builtins.str]] = None,
                 rescue_device: Optional[pulumi.Input[_builtins.str]] = None,
                 secure_boot: Optional[pulumi.Input[_builtins.bool]] = None,
                 uefi: Optional[pulumi.Input[_builtins.bool]] = None,
                 video_model: Optional[pulumi.Input[_builtins.str]] = None,
                 virtio_scsi: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[_builtins.bool] boot_menu: Enables the BIOS bootmenu.
        :param pulumi.Input[_builtins.str] cdrom_bus: Sets CDROM bus controller type.
        :param pulumi.Input[_builtins.str] disk_bus: Sets Disk bus controller type.
        :param pulumi.Input[_builtins.str] nic_model: Sets virtual network interface model.
        :param pulumi.Input[_builtins.str] operating_system: Enables operating system specific optimizations.
        :param pulumi.Input[_builtins.str] operating_system_distro: Operating system distribution.
        :param pulumi.Input[_builtins.str] operating_system_version: Version of the operating system.
        :param pulumi.Input[_builtins.str] rescue_bus: Sets the device bus when the image is used as a rescue image.
        :param pulumi.Input[_builtins.str] rescue_device: Sets the device when the image is used as a rescue image.
        :param pulumi.Input[_builtins.bool] secure_boot: Enables Secure Boot.
        :param pulumi.Input[_builtins.bool] uefi: Enables UEFI boot.
        :param pulumi.Input[_builtins.str] video_model: Sets Graphic device model.
        :param pulumi.Input[_builtins.bool] virtio_scsi: Enables the use of VirtIO SCSI to provide block device access. By default instances use VirtIO Block.
        """
        if boot_menu is not None:
            pulumi.set(__self__, "boot_menu", boot_menu)
        if cdrom_bus is not None:
            pulumi.set(__self__, "cdrom_bus", cdrom_bus)
        if disk_bus is not None:
            pulumi.set(__self__, "disk_bus", disk_bus)
        if nic_model is not None:
            pulumi.set(__self__, "nic_model", nic_model)
        if operating_system is not None:
            pulumi.set(__self__, "operating_system", operating_system)
        if operating_system_distro is not None:
            pulumi.set(__self__, "operating_system_distro", operating_system_distro)
        if operating_system_version is not None:
            pulumi.set(__self__, "operating_system_version", operating_system_version)
        if rescue_bus is not None:
            pulumi.set(__self__, "rescue_bus", rescue_bus)
        if rescue_device is not None:
            pulumi.set(__self__, "rescue_device", rescue_device)
        if secure_boot is not None:
            pulumi.set(__self__, "secure_boot", secure_boot)
        if uefi is not None:
            pulumi.set(__self__, "uefi", uefi)
        if video_model is not None:
            pulumi.set(__self__, "video_model", video_model)
        if virtio_scsi is not None:
            pulumi.set(__self__, "virtio_scsi", virtio_scsi)

    @_builtins.property
    @pulumi.getter(name="bootMenu")
    def boot_menu(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables the BIOS bootmenu.
        """
        return pulumi.get(self, "boot_menu")

    @boot_menu.setter
    def boot_menu(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "boot_menu", value)

    @_builtins.property
    @pulumi.getter(name="cdromBus")
    def cdrom_bus(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Sets CDROM bus controller type.
        """
        return pulumi.get(self, "cdrom_bus")

    @cdrom_bus.setter
    def cdrom_bus(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cdrom_bus", value)

    @_builtins.property
    @pulumi.getter(name="diskBus")
    def disk_bus(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Sets Disk bus controller type.
        """
        return pulumi.get(self, "disk_bus")

    @disk_bus.setter
    def disk_bus(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "disk_bus", value)

    @_builtins.property
    @pulumi.getter(name="nicModel")
    def nic_model(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Sets virtual network interface model.
        """
        return pulumi.get(self, "nic_model")

    @nic_model.setter
    def nic_model(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nic_model", value)

    @_builtins.property
    @pulumi.getter(name="operatingSystem")
    def operating_system(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enables operating system specific optimizations.
        """
        return pulumi.get(self, "operating_system")

    @operating_system.setter
    def operating_system(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "operating_system", value)

    @_builtins.property
    @pulumi.getter(name="operatingSystemDistro")
    def operating_system_distro(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Operating system distribution.
        """
        return pulumi.get(self, "operating_system_distro")

    @operating_system_distro.setter
    def operating_system_distro(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "operating_system_distro", value)

    @_builtins.property
    @pulumi.getter(name="operatingSystemVersion")
    def operating_system_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Version of the operating system.
        """
        return pulumi.get(self, "operating_system_version")

    @operating_system_version.setter
    def operating_system_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "operating_system_version", value)

    @_builtins.property
    @pulumi.getter(name="rescueBus")
    def rescue_bus(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Sets the device bus when the image is used as a rescue image.
        """
        return pulumi.get(self, "rescue_bus")

    @rescue_bus.setter
    def rescue_bus(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rescue_bus", value)

    @_builtins.property
    @pulumi.getter(name="rescueDevice")
    def rescue_device(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Sets the device when the image is used as a rescue image.
        """
        return pulumi.get(self, "rescue_device")

    @rescue_device.setter
    def rescue_device(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rescue_device", value)

    @_builtins.property
    @pulumi.getter(name="secureBoot")
    def secure_boot(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables Secure Boot.
        """
        return pulumi.get(self, "secure_boot")

    @secure_boot.setter
    def secure_boot(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "secure_boot", value)

    @_builtins.property
    @pulumi.getter
    def uefi(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables UEFI boot.
        """
        return pulumi.get(self, "uefi")

    @uefi.setter
    def uefi(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "uefi", value)

    @_builtins.property
    @pulumi.getter(name="videoModel")
    def video_model(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Sets Graphic device model.
        """
        return pulumi.get(self, "video_model")

    @video_model.setter
    def video_model(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "video_model", value)

    @_builtins.property
    @pulumi.getter(name="virtioScsi")
    def virtio_scsi(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables the use of VirtIO SCSI to provide block device access. By default instances use VirtIO Block.
        """
        return pulumi.get(self, "virtio_scsi")

    @virtio_scsi.setter
    def virtio_scsi(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "virtio_scsi", value)


if not MYPY:
    class LoadbalancerListenerArgsDict(TypedDict):
        port: pulumi.Input[_builtins.int]
        """
        Port number where we listen for traffic.
        """
        protocol: pulumi.Input[_builtins.str]
        """
        Protocol is the highest network protocol we understand to load balance. Supported values are: `PROTOCOL_UNSPECIFIED`, `PROTOCOL_TCP`, `PROTOCOL_UDP`, `PROTOCOL_TCP_PROXY`, `PROTOCOL_TLS_PASSTHROUGH`.
        """
        target_pool: pulumi.Input[_builtins.str]
        """
        Reference target pool by target pool name.
        """
        display_name: NotRequired[pulumi.Input[_builtins.str]]
        server_name_indicators: NotRequired[pulumi.Input[Sequence[pulumi.Input['LoadbalancerListenerServerNameIndicatorArgsDict']]]]
        """
        A list of domain names to match in order to pass TLS traffic to the target pool in the current listener
        """
elif False:
    LoadbalancerListenerArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LoadbalancerListenerArgs:
    def __init__(__self__, *,
                 port: pulumi.Input[_builtins.int],
                 protocol: pulumi.Input[_builtins.str],
                 target_pool: pulumi.Input[_builtins.str],
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 server_name_indicators: Optional[pulumi.Input[Sequence[pulumi.Input['LoadbalancerListenerServerNameIndicatorArgs']]]] = None):
        """
        :param pulumi.Input[_builtins.int] port: Port number where we listen for traffic.
        :param pulumi.Input[_builtins.str] protocol: Protocol is the highest network protocol we understand to load balance. Supported values are: `PROTOCOL_UNSPECIFIED`, `PROTOCOL_TCP`, `PROTOCOL_UDP`, `PROTOCOL_TCP_PROXY`, `PROTOCOL_TLS_PASSTHROUGH`.
        :param pulumi.Input[_builtins.str] target_pool: Reference target pool by target pool name.
        :param pulumi.Input[Sequence[pulumi.Input['LoadbalancerListenerServerNameIndicatorArgs']]] server_name_indicators: A list of domain names to match in order to pass TLS traffic to the target pool in the current listener
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "target_pool", target_pool)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if server_name_indicators is not None:
            pulumi.set(__self__, "server_name_indicators", server_name_indicators)

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Input[_builtins.int]:
        """
        Port number where we listen for traffic.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[_builtins.str]:
        """
        Protocol is the highest network protocol we understand to load balance. Supported values are: `PROTOCOL_UNSPECIFIED`, `PROTOCOL_TCP`, `PROTOCOL_UDP`, `PROTOCOL_TCP_PROXY`, `PROTOCOL_TLS_PASSTHROUGH`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter(name="targetPool")
    def target_pool(self) -> pulumi.Input[_builtins.str]:
        """
        Reference target pool by target pool name.
        """
        return pulumi.get(self, "target_pool")

    @target_pool.setter
    def target_pool(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "target_pool", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="serverNameIndicators")
    def server_name_indicators(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadbalancerListenerServerNameIndicatorArgs']]]]:
        """
        A list of domain names to match in order to pass TLS traffic to the target pool in the current listener
        """
        return pulumi.get(self, "server_name_indicators")

    @server_name_indicators.setter
    def server_name_indicators(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadbalancerListenerServerNameIndicatorArgs']]]]):
        pulumi.set(self, "server_name_indicators", value)


if not MYPY:
    class LoadbalancerListenerServerNameIndicatorArgsDict(TypedDict):
        name: NotRequired[pulumi.Input[_builtins.str]]
        """
        A domain name to match in order to pass TLS traffic to the target pool in the current listener
        """
elif False:
    LoadbalancerListenerServerNameIndicatorArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LoadbalancerListenerServerNameIndicatorArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] name: A domain name to match in order to pass TLS traffic to the target pool in the current listener
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A domain name to match in order to pass TLS traffic to the target pool in the current listener
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


if not MYPY:
    class LoadbalancerNetworkArgsDict(TypedDict):
        network_id: pulumi.Input[_builtins.str]
        """
        Openstack network ID.
        """
        role: pulumi.Input[_builtins.str]
        """
        The role defines how the load balancer is using the network. Supported values are: `ROLE_UNSPECIFIED`, `ROLE_LISTENERS_AND_TARGETS`, `ROLE_LISTENERS`, `ROLE_TARGETS`.
        """
elif False:
    LoadbalancerNetworkArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LoadbalancerNetworkArgs:
    def __init__(__self__, *,
                 network_id: pulumi.Input[_builtins.str],
                 role: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] network_id: Openstack network ID.
        :param pulumi.Input[_builtins.str] role: The role defines how the load balancer is using the network. Supported values are: `ROLE_UNSPECIFIED`, `ROLE_LISTENERS_AND_TARGETS`, `ROLE_LISTENERS`, `ROLE_TARGETS`.
        """
        pulumi.set(__self__, "network_id", network_id)
        pulumi.set(__self__, "role", role)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[_builtins.str]:
        """
        Openstack network ID.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "network_id", value)

    @_builtins.property
    @pulumi.getter
    def role(self) -> pulumi.Input[_builtins.str]:
        """
        The role defines how the load balancer is using the network. Supported values are: `ROLE_UNSPECIFIED`, `ROLE_LISTENERS_AND_TARGETS`, `ROLE_LISTENERS`, `ROLE_TARGETS`.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "role", value)


if not MYPY:
    class LoadbalancerOptionsArgsDict(TypedDict):
        acls: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Load Balancer is accessible only from an IP address in this range.
        """
        observability: NotRequired[pulumi.Input['LoadbalancerOptionsObservabilityArgsDict']]
        """
        We offer Load Balancer metrics observability via ARGUS or external solutions. Not changeable after creation.
        """
        private_network_only: NotRequired[pulumi.Input[_builtins.bool]]
        """
        If true, Load Balancer is accessible only via a private network IP address.
        """
elif False:
    LoadbalancerOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LoadbalancerOptionsArgs:
    def __init__(__self__, *,
                 acls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 observability: Optional[pulumi.Input['LoadbalancerOptionsObservabilityArgs']] = None,
                 private_network_only: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] acls: Load Balancer is accessible only from an IP address in this range.
        :param pulumi.Input['LoadbalancerOptionsObservabilityArgs'] observability: We offer Load Balancer metrics observability via ARGUS or external solutions. Not changeable after creation.
        :param pulumi.Input[_builtins.bool] private_network_only: If true, Load Balancer is accessible only via a private network IP address.
        """
        if acls is not None:
            pulumi.set(__self__, "acls", acls)
        if observability is not None:
            pulumi.set(__self__, "observability", observability)
        if private_network_only is not None:
            pulumi.set(__self__, "private_network_only", private_network_only)

    @_builtins.property
    @pulumi.getter
    def acls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Load Balancer is accessible only from an IP address in this range.
        """
        return pulumi.get(self, "acls")

    @acls.setter
    def acls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "acls", value)

    @_builtins.property
    @pulumi.getter
    def observability(self) -> Optional[pulumi.Input['LoadbalancerOptionsObservabilityArgs']]:
        """
        We offer Load Balancer metrics observability via ARGUS or external solutions. Not changeable after creation.
        """
        return pulumi.get(self, "observability")

    @observability.setter
    def observability(self, value: Optional[pulumi.Input['LoadbalancerOptionsObservabilityArgs']]):
        pulumi.set(self, "observability", value)

    @_builtins.property
    @pulumi.getter(name="privateNetworkOnly")
    def private_network_only(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, Load Balancer is accessible only via a private network IP address.
        """
        return pulumi.get(self, "private_network_only")

    @private_network_only.setter
    def private_network_only(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "private_network_only", value)


if not MYPY:
    class LoadbalancerOptionsObservabilityArgsDict(TypedDict):
        logs: NotRequired[pulumi.Input['LoadbalancerOptionsObservabilityLogsArgsDict']]
        """
        Observability logs configuration. Not changeable after creation.
        """
        metrics: NotRequired[pulumi.Input['LoadbalancerOptionsObservabilityMetricsArgsDict']]
        """
        Observability metrics configuration. Not changeable after creation.
        """
elif False:
    LoadbalancerOptionsObservabilityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LoadbalancerOptionsObservabilityArgs:
    def __init__(__self__, *,
                 logs: Optional[pulumi.Input['LoadbalancerOptionsObservabilityLogsArgs']] = None,
                 metrics: Optional[pulumi.Input['LoadbalancerOptionsObservabilityMetricsArgs']] = None):
        """
        :param pulumi.Input['LoadbalancerOptionsObservabilityLogsArgs'] logs: Observability logs configuration. Not changeable after creation.
        :param pulumi.Input['LoadbalancerOptionsObservabilityMetricsArgs'] metrics: Observability metrics configuration. Not changeable after creation.
        """
        if logs is not None:
            pulumi.set(__self__, "logs", logs)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)

    @_builtins.property
    @pulumi.getter
    def logs(self) -> Optional[pulumi.Input['LoadbalancerOptionsObservabilityLogsArgs']]:
        """
        Observability logs configuration. Not changeable after creation.
        """
        return pulumi.get(self, "logs")

    @logs.setter
    def logs(self, value: Optional[pulumi.Input['LoadbalancerOptionsObservabilityLogsArgs']]):
        pulumi.set(self, "logs", value)

    @_builtins.property
    @pulumi.getter
    def metrics(self) -> Optional[pulumi.Input['LoadbalancerOptionsObservabilityMetricsArgs']]:
        """
        Observability metrics configuration. Not changeable after creation.
        """
        return pulumi.get(self, "metrics")

    @metrics.setter
    def metrics(self, value: Optional[pulumi.Input['LoadbalancerOptionsObservabilityMetricsArgs']]):
        pulumi.set(self, "metrics", value)


if not MYPY:
    class LoadbalancerOptionsObservabilityLogsArgsDict(TypedDict):
        credentials_ref: NotRequired[pulumi.Input[_builtins.str]]
        """
        Credentials reference for logs. Not changeable after creation.
        """
        push_url: NotRequired[pulumi.Input[_builtins.str]]
        """
        Credentials reference for logs. Not changeable after creation.
        """
elif False:
    LoadbalancerOptionsObservabilityLogsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LoadbalancerOptionsObservabilityLogsArgs:
    def __init__(__self__, *,
                 credentials_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 push_url: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] credentials_ref: Credentials reference for logs. Not changeable after creation.
        :param pulumi.Input[_builtins.str] push_url: Credentials reference for logs. Not changeable after creation.
        """
        if credentials_ref is not None:
            pulumi.set(__self__, "credentials_ref", credentials_ref)
        if push_url is not None:
            pulumi.set(__self__, "push_url", push_url)

    @_builtins.property
    @pulumi.getter(name="credentialsRef")
    def credentials_ref(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Credentials reference for logs. Not changeable after creation.
        """
        return pulumi.get(self, "credentials_ref")

    @credentials_ref.setter
    def credentials_ref(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "credentials_ref", value)

    @_builtins.property
    @pulumi.getter(name="pushUrl")
    def push_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Credentials reference for logs. Not changeable after creation.
        """
        return pulumi.get(self, "push_url")

    @push_url.setter
    def push_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "push_url", value)


if not MYPY:
    class LoadbalancerOptionsObservabilityMetricsArgsDict(TypedDict):
        credentials_ref: NotRequired[pulumi.Input[_builtins.str]]
        """
        Credentials reference for metrics. Not changeable after creation.
        """
        push_url: NotRequired[pulumi.Input[_builtins.str]]
        """
        Credentials reference for metrics. Not changeable after creation.
        """
elif False:
    LoadbalancerOptionsObservabilityMetricsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LoadbalancerOptionsObservabilityMetricsArgs:
    def __init__(__self__, *,
                 credentials_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 push_url: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] credentials_ref: Credentials reference for metrics. Not changeable after creation.
        :param pulumi.Input[_builtins.str] push_url: Credentials reference for metrics. Not changeable after creation.
        """
        if credentials_ref is not None:
            pulumi.set(__self__, "credentials_ref", credentials_ref)
        if push_url is not None:
            pulumi.set(__self__, "push_url", push_url)

    @_builtins.property
    @pulumi.getter(name="credentialsRef")
    def credentials_ref(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Credentials reference for metrics. Not changeable after creation.
        """
        return pulumi.get(self, "credentials_ref")

    @credentials_ref.setter
    def credentials_ref(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "credentials_ref", value)

    @_builtins.property
    @pulumi.getter(name="pushUrl")
    def push_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Credentials reference for metrics. Not changeable after creation.
        """
        return pulumi.get(self, "push_url")

    @push_url.setter
    def push_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "push_url", value)


if not MYPY:
    class LoadbalancerTargetPoolArgsDict(TypedDict):
        name: pulumi.Input[_builtins.str]
        """
        Target pool name.
        """
        target_port: pulumi.Input[_builtins.int]
        """
        Identical port number where each target listens for traffic.
        """
        targets: pulumi.Input[Sequence[pulumi.Input['LoadbalancerTargetPoolTargetArgsDict']]]
        """
        List of all targets which will be used in the pool. Limited to 1000.
        """
        active_health_check: NotRequired[pulumi.Input['LoadbalancerTargetPoolActiveHealthCheckArgsDict']]
        session_persistence: NotRequired[pulumi.Input['LoadbalancerTargetPoolSessionPersistenceArgsDict']]
        """
        Here you can setup various session persistence options, so far only "`use_source_ip_address`" is supported.
        """
elif False:
    LoadbalancerTargetPoolArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LoadbalancerTargetPoolArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 target_port: pulumi.Input[_builtins.int],
                 targets: pulumi.Input[Sequence[pulumi.Input['LoadbalancerTargetPoolTargetArgs']]],
                 active_health_check: Optional[pulumi.Input['LoadbalancerTargetPoolActiveHealthCheckArgs']] = None,
                 session_persistence: Optional[pulumi.Input['LoadbalancerTargetPoolSessionPersistenceArgs']] = None):
        """
        :param pulumi.Input[_builtins.str] name: Target pool name.
        :param pulumi.Input[_builtins.int] target_port: Identical port number where each target listens for traffic.
        :param pulumi.Input[Sequence[pulumi.Input['LoadbalancerTargetPoolTargetArgs']]] targets: List of all targets which will be used in the pool. Limited to 1000.
        :param pulumi.Input['LoadbalancerTargetPoolSessionPersistenceArgs'] session_persistence: Here you can setup various session persistence options, so far only "`use_source_ip_address`" is supported.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "target_port", target_port)
        pulumi.set(__self__, "targets", targets)
        if active_health_check is not None:
            pulumi.set(__self__, "active_health_check", active_health_check)
        if session_persistence is not None:
            pulumi.set(__self__, "session_persistence", session_persistence)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        Target pool name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="targetPort")
    def target_port(self) -> pulumi.Input[_builtins.int]:
        """
        Identical port number where each target listens for traffic.
        """
        return pulumi.get(self, "target_port")

    @target_port.setter
    def target_port(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "target_port", value)

    @_builtins.property
    @pulumi.getter
    def targets(self) -> pulumi.Input[Sequence[pulumi.Input['LoadbalancerTargetPoolTargetArgs']]]:
        """
        List of all targets which will be used in the pool. Limited to 1000.
        """
        return pulumi.get(self, "targets")

    @targets.setter
    def targets(self, value: pulumi.Input[Sequence[pulumi.Input['LoadbalancerTargetPoolTargetArgs']]]):
        pulumi.set(self, "targets", value)

    @_builtins.property
    @pulumi.getter(name="activeHealthCheck")
    def active_health_check(self) -> Optional[pulumi.Input['LoadbalancerTargetPoolActiveHealthCheckArgs']]:
        return pulumi.get(self, "active_health_check")

    @active_health_check.setter
    def active_health_check(self, value: Optional[pulumi.Input['LoadbalancerTargetPoolActiveHealthCheckArgs']]):
        pulumi.set(self, "active_health_check", value)

    @_builtins.property
    @pulumi.getter(name="sessionPersistence")
    def session_persistence(self) -> Optional[pulumi.Input['LoadbalancerTargetPoolSessionPersistenceArgs']]:
        """
        Here you can setup various session persistence options, so far only "`use_source_ip_address`" is supported.
        """
        return pulumi.get(self, "session_persistence")

    @session_persistence.setter
    def session_persistence(self, value: Optional[pulumi.Input['LoadbalancerTargetPoolSessionPersistenceArgs']]):
        pulumi.set(self, "session_persistence", value)


if not MYPY:
    class LoadbalancerTargetPoolActiveHealthCheckArgsDict(TypedDict):
        healthy_threshold: NotRequired[pulumi.Input[_builtins.int]]
        """
        Healthy threshold of the health checking.
        """
        interval: NotRequired[pulumi.Input[_builtins.str]]
        """
        Interval duration of health checking in seconds.
        """
        interval_jitter: NotRequired[pulumi.Input[_builtins.str]]
        """
        Interval duration threshold of the health checking in seconds.
        """
        timeout: NotRequired[pulumi.Input[_builtins.str]]
        """
        Active health checking timeout duration in seconds.
        """
        unhealthy_threshold: NotRequired[pulumi.Input[_builtins.int]]
        """
        Unhealthy threshold of the health checking.
        """
elif False:
    LoadbalancerTargetPoolActiveHealthCheckArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LoadbalancerTargetPoolActiveHealthCheckArgs:
    def __init__(__self__, *,
                 healthy_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 interval: Optional[pulumi.Input[_builtins.str]] = None,
                 interval_jitter: Optional[pulumi.Input[_builtins.str]] = None,
                 timeout: Optional[pulumi.Input[_builtins.str]] = None,
                 unhealthy_threshold: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.int] healthy_threshold: Healthy threshold of the health checking.
        :param pulumi.Input[_builtins.str] interval: Interval duration of health checking in seconds.
        :param pulumi.Input[_builtins.str] interval_jitter: Interval duration threshold of the health checking in seconds.
        :param pulumi.Input[_builtins.str] timeout: Active health checking timeout duration in seconds.
        :param pulumi.Input[_builtins.int] unhealthy_threshold: Unhealthy threshold of the health checking.
        """
        if healthy_threshold is not None:
            pulumi.set(__self__, "healthy_threshold", healthy_threshold)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if interval_jitter is not None:
            pulumi.set(__self__, "interval_jitter", interval_jitter)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if unhealthy_threshold is not None:
            pulumi.set(__self__, "unhealthy_threshold", unhealthy_threshold)

    @_builtins.property
    @pulumi.getter(name="healthyThreshold")
    def healthy_threshold(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Healthy threshold of the health checking.
        """
        return pulumi.get(self, "healthy_threshold")

    @healthy_threshold.setter
    def healthy_threshold(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "healthy_threshold", value)

    @_builtins.property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Interval duration of health checking in seconds.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "interval", value)

    @_builtins.property
    @pulumi.getter(name="intervalJitter")
    def interval_jitter(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Interval duration threshold of the health checking in seconds.
        """
        return pulumi.get(self, "interval_jitter")

    @interval_jitter.setter
    def interval_jitter(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "interval_jitter", value)

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Active health checking timeout duration in seconds.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timeout", value)

    @_builtins.property
    @pulumi.getter(name="unhealthyThreshold")
    def unhealthy_threshold(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Unhealthy threshold of the health checking.
        """
        return pulumi.get(self, "unhealthy_threshold")

    @unhealthy_threshold.setter
    def unhealthy_threshold(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "unhealthy_threshold", value)


if not MYPY:
    class LoadbalancerTargetPoolSessionPersistenceArgsDict(TypedDict):
        use_source_ip_address: NotRequired[pulumi.Input[_builtins.bool]]
        """
        If true then all connections from one source IP address are redirected to the same target. This setting changes the load balancing algorithm to Maglev.
        """
elif False:
    LoadbalancerTargetPoolSessionPersistenceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LoadbalancerTargetPoolSessionPersistenceArgs:
    def __init__(__self__, *,
                 use_source_ip_address: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[_builtins.bool] use_source_ip_address: If true then all connections from one source IP address are redirected to the same target. This setting changes the load balancing algorithm to Maglev.
        """
        if use_source_ip_address is not None:
            pulumi.set(__self__, "use_source_ip_address", use_source_ip_address)

    @_builtins.property
    @pulumi.getter(name="useSourceIpAddress")
    def use_source_ip_address(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true then all connections from one source IP address are redirected to the same target. This setting changes the load balancing algorithm to Maglev.
        """
        return pulumi.get(self, "use_source_ip_address")

    @use_source_ip_address.setter
    def use_source_ip_address(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_source_ip_address", value)


if not MYPY:
    class LoadbalancerTargetPoolTargetArgsDict(TypedDict):
        display_name: pulumi.Input[_builtins.str]
        """
        Target display name
        """
        ip: pulumi.Input[_builtins.str]
        """
        Target IP
        """
elif False:
    LoadbalancerTargetPoolTargetArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LoadbalancerTargetPoolTargetArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[_builtins.str],
                 ip: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] display_name: Target display name
        :param pulumi.Input[_builtins.str] ip: Target IP
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "ip", ip)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        Target display name
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def ip(self) -> pulumi.Input[_builtins.str]:
        """
        Target IP
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ip", value)


if not MYPY:
    class LogmeInstanceParametersArgsDict(TypedDict):
        enable_monitoring: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Enable monitoring.
        """
        fluentd_tcp: NotRequired[pulumi.Input[_builtins.int]]
        fluentd_tls: NotRequired[pulumi.Input[_builtins.int]]
        fluentd_tls_ciphers: NotRequired[pulumi.Input[_builtins.str]]
        fluentd_tls_max_version: NotRequired[pulumi.Input[_builtins.str]]
        fluentd_tls_min_version: NotRequired[pulumi.Input[_builtins.str]]
        fluentd_tls_version: NotRequired[pulumi.Input[_builtins.str]]
        fluentd_udp: NotRequired[pulumi.Input[_builtins.int]]
        graphite: NotRequired[pulumi.Input[_builtins.str]]
        """
        If set, monitoring with Graphite will be enabled. Expects the host and port where the Graphite metrics should be sent to (host:port).
        """
        ism_deletion_after: NotRequired[pulumi.Input[_builtins.str]]
        """
        Combination of an integer and a timerange when an index will be considered "old" and can be deleted. Possible values for the timerange are `s`, `m`, `h` and `d`.
        """
        ism_jitter: NotRequired[pulumi.Input[_builtins.float]]
        ism_job_interval: NotRequired[pulumi.Input[_builtins.int]]
        """
        Jitter of the execution time.
        """
        java_heapspace: NotRequired[pulumi.Input[_builtins.int]]
        """
        The amount of memory (in MB) allocated as heap by the JVM for OpenSearch.
        """
        java_maxmetaspace: NotRequired[pulumi.Input[_builtins.int]]
        """
        The amount of memory (in MB) used by the JVM to store metadata for OpenSearch.
        """
        max_disk_threshold: NotRequired[pulumi.Input[_builtins.int]]
        """
        The maximum disk threshold in MB. If the disk usage exceeds this threshold, the instance will be stopped.
        """
        metrics_frequency: NotRequired[pulumi.Input[_builtins.int]]
        """
        The frequency in seconds at which metrics are emitted (in seconds).
        """
        metrics_prefix: NotRequired[pulumi.Input[_builtins.str]]
        """
        The prefix for the metrics. Could be useful when using Graphite monitoring to prefix the metrics with a certain value, like an API key.
        """
        monitoring_instance_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the STACKIT monitoring instance.
        """
        opensearch_tls_ciphers: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        opensearch_tls_protocols: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        sgw_acl: NotRequired[pulumi.Input[_builtins.str]]
        """
        Comma separated list of IP networks in CIDR notation which are allowed to access this instance.
        """
        syslogs: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        List of syslog servers to send logs to.
        """
elif False:
    LogmeInstanceParametersArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LogmeInstanceParametersArgs:
    def __init__(__self__, *,
                 enable_monitoring: Optional[pulumi.Input[_builtins.bool]] = None,
                 fluentd_tcp: Optional[pulumi.Input[_builtins.int]] = None,
                 fluentd_tls: Optional[pulumi.Input[_builtins.int]] = None,
                 fluentd_tls_ciphers: Optional[pulumi.Input[_builtins.str]] = None,
                 fluentd_tls_max_version: Optional[pulumi.Input[_builtins.str]] = None,
                 fluentd_tls_min_version: Optional[pulumi.Input[_builtins.str]] = None,
                 fluentd_tls_version: Optional[pulumi.Input[_builtins.str]] = None,
                 fluentd_udp: Optional[pulumi.Input[_builtins.int]] = None,
                 graphite: Optional[pulumi.Input[_builtins.str]] = None,
                 ism_deletion_after: Optional[pulumi.Input[_builtins.str]] = None,
                 ism_jitter: Optional[pulumi.Input[_builtins.float]] = None,
                 ism_job_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 java_heapspace: Optional[pulumi.Input[_builtins.int]] = None,
                 java_maxmetaspace: Optional[pulumi.Input[_builtins.int]] = None,
                 max_disk_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 metrics_frequency: Optional[pulumi.Input[_builtins.int]] = None,
                 metrics_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 monitoring_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 opensearch_tls_ciphers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 opensearch_tls_protocols: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sgw_acl: Optional[pulumi.Input[_builtins.str]] = None,
                 syslogs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        :param pulumi.Input[_builtins.bool] enable_monitoring: Enable monitoring.
        :param pulumi.Input[_builtins.str] graphite: If set, monitoring with Graphite will be enabled. Expects the host and port where the Graphite metrics should be sent to (host:port).
        :param pulumi.Input[_builtins.str] ism_deletion_after: Combination of an integer and a timerange when an index will be considered "old" and can be deleted. Possible values for the timerange are `s`, `m`, `h` and `d`.
        :param pulumi.Input[_builtins.int] ism_job_interval: Jitter of the execution time.
        :param pulumi.Input[_builtins.int] java_heapspace: The amount of memory (in MB) allocated as heap by the JVM for OpenSearch.
        :param pulumi.Input[_builtins.int] java_maxmetaspace: The amount of memory (in MB) used by the JVM to store metadata for OpenSearch.
        :param pulumi.Input[_builtins.int] max_disk_threshold: The maximum disk threshold in MB. If the disk usage exceeds this threshold, the instance will be stopped.
        :param pulumi.Input[_builtins.int] metrics_frequency: The frequency in seconds at which metrics are emitted (in seconds).
        :param pulumi.Input[_builtins.str] metrics_prefix: The prefix for the metrics. Could be useful when using Graphite monitoring to prefix the metrics with a certain value, like an API key.
        :param pulumi.Input[_builtins.str] monitoring_instance_id: The ID of the STACKIT monitoring instance.
        :param pulumi.Input[_builtins.str] sgw_acl: Comma separated list of IP networks in CIDR notation which are allowed to access this instance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] syslogs: List of syslog servers to send logs to.
        """
        if enable_monitoring is not None:
            pulumi.set(__self__, "enable_monitoring", enable_monitoring)
        if fluentd_tcp is not None:
            pulumi.set(__self__, "fluentd_tcp", fluentd_tcp)
        if fluentd_tls is not None:
            pulumi.set(__self__, "fluentd_tls", fluentd_tls)
        if fluentd_tls_ciphers is not None:
            pulumi.set(__self__, "fluentd_tls_ciphers", fluentd_tls_ciphers)
        if fluentd_tls_max_version is not None:
            pulumi.set(__self__, "fluentd_tls_max_version", fluentd_tls_max_version)
        if fluentd_tls_min_version is not None:
            pulumi.set(__self__, "fluentd_tls_min_version", fluentd_tls_min_version)
        if fluentd_tls_version is not None:
            pulumi.set(__self__, "fluentd_tls_version", fluentd_tls_version)
        if fluentd_udp is not None:
            pulumi.set(__self__, "fluentd_udp", fluentd_udp)
        if graphite is not None:
            pulumi.set(__self__, "graphite", graphite)
        if ism_deletion_after is not None:
            pulumi.set(__self__, "ism_deletion_after", ism_deletion_after)
        if ism_jitter is not None:
            pulumi.set(__self__, "ism_jitter", ism_jitter)
        if ism_job_interval is not None:
            pulumi.set(__self__, "ism_job_interval", ism_job_interval)
        if java_heapspace is not None:
            pulumi.set(__self__, "java_heapspace", java_heapspace)
        if java_maxmetaspace is not None:
            pulumi.set(__self__, "java_maxmetaspace", java_maxmetaspace)
        if max_disk_threshold is not None:
            pulumi.set(__self__, "max_disk_threshold", max_disk_threshold)
        if metrics_frequency is not None:
            pulumi.set(__self__, "metrics_frequency", metrics_frequency)
        if metrics_prefix is not None:
            pulumi.set(__self__, "metrics_prefix", metrics_prefix)
        if monitoring_instance_id is not None:
            pulumi.set(__self__, "monitoring_instance_id", monitoring_instance_id)
        if opensearch_tls_ciphers is not None:
            pulumi.set(__self__, "opensearch_tls_ciphers", opensearch_tls_ciphers)
        if opensearch_tls_protocols is not None:
            pulumi.set(__self__, "opensearch_tls_protocols", opensearch_tls_protocols)
        if sgw_acl is not None:
            pulumi.set(__self__, "sgw_acl", sgw_acl)
        if syslogs is not None:
            pulumi.set(__self__, "syslogs", syslogs)

    @_builtins.property
    @pulumi.getter(name="enableMonitoring")
    def enable_monitoring(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable monitoring.
        """
        return pulumi.get(self, "enable_monitoring")

    @enable_monitoring.setter
    def enable_monitoring(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_monitoring", value)

    @_builtins.property
    @pulumi.getter(name="fluentdTcp")
    def fluentd_tcp(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "fluentd_tcp")

    @fluentd_tcp.setter
    def fluentd_tcp(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "fluentd_tcp", value)

    @_builtins.property
    @pulumi.getter(name="fluentdTls")
    def fluentd_tls(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "fluentd_tls")

    @fluentd_tls.setter
    def fluentd_tls(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "fluentd_tls", value)

    @_builtins.property
    @pulumi.getter(name="fluentdTlsCiphers")
    def fluentd_tls_ciphers(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "fluentd_tls_ciphers")

    @fluentd_tls_ciphers.setter
    def fluentd_tls_ciphers(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fluentd_tls_ciphers", value)

    @_builtins.property
    @pulumi.getter(name="fluentdTlsMaxVersion")
    def fluentd_tls_max_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "fluentd_tls_max_version")

    @fluentd_tls_max_version.setter
    def fluentd_tls_max_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fluentd_tls_max_version", value)

    @_builtins.property
    @pulumi.getter(name="fluentdTlsMinVersion")
    def fluentd_tls_min_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "fluentd_tls_min_version")

    @fluentd_tls_min_version.setter
    def fluentd_tls_min_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fluentd_tls_min_version", value)

    @_builtins.property
    @pulumi.getter(name="fluentdTlsVersion")
    def fluentd_tls_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "fluentd_tls_version")

    @fluentd_tls_version.setter
    def fluentd_tls_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fluentd_tls_version", value)

    @_builtins.property
    @pulumi.getter(name="fluentdUdp")
    def fluentd_udp(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "fluentd_udp")

    @fluentd_udp.setter
    def fluentd_udp(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "fluentd_udp", value)

    @_builtins.property
    @pulumi.getter
    def graphite(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If set, monitoring with Graphite will be enabled. Expects the host and port where the Graphite metrics should be sent to (host:port).
        """
        return pulumi.get(self, "graphite")

    @graphite.setter
    def graphite(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "graphite", value)

    @_builtins.property
    @pulumi.getter(name="ismDeletionAfter")
    def ism_deletion_after(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Combination of an integer and a timerange when an index will be considered "old" and can be deleted. Possible values for the timerange are `s`, `m`, `h` and `d`.
        """
        return pulumi.get(self, "ism_deletion_after")

    @ism_deletion_after.setter
    def ism_deletion_after(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ism_deletion_after", value)

    @_builtins.property
    @pulumi.getter(name="ismJitter")
    def ism_jitter(self) -> Optional[pulumi.Input[_builtins.float]]:
        return pulumi.get(self, "ism_jitter")

    @ism_jitter.setter
    def ism_jitter(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "ism_jitter", value)

    @_builtins.property
    @pulumi.getter(name="ismJobInterval")
    def ism_job_interval(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Jitter of the execution time.
        """
        return pulumi.get(self, "ism_job_interval")

    @ism_job_interval.setter
    def ism_job_interval(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ism_job_interval", value)

    @_builtins.property
    @pulumi.getter(name="javaHeapspace")
    def java_heapspace(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of memory (in MB) allocated as heap by the JVM for OpenSearch.
        """
        return pulumi.get(self, "java_heapspace")

    @java_heapspace.setter
    def java_heapspace(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "java_heapspace", value)

    @_builtins.property
    @pulumi.getter(name="javaMaxmetaspace")
    def java_maxmetaspace(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of memory (in MB) used by the JVM to store metadata for OpenSearch.
        """
        return pulumi.get(self, "java_maxmetaspace")

    @java_maxmetaspace.setter
    def java_maxmetaspace(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "java_maxmetaspace", value)

    @_builtins.property
    @pulumi.getter(name="maxDiskThreshold")
    def max_disk_threshold(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum disk threshold in MB. If the disk usage exceeds this threshold, the instance will be stopped.
        """
        return pulumi.get(self, "max_disk_threshold")

    @max_disk_threshold.setter
    def max_disk_threshold(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_disk_threshold", value)

    @_builtins.property
    @pulumi.getter(name="metricsFrequency")
    def metrics_frequency(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The frequency in seconds at which metrics are emitted (in seconds).
        """
        return pulumi.get(self, "metrics_frequency")

    @metrics_frequency.setter
    def metrics_frequency(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "metrics_frequency", value)

    @_builtins.property
    @pulumi.getter(name="metricsPrefix")
    def metrics_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The prefix for the metrics. Could be useful when using Graphite monitoring to prefix the metrics with a certain value, like an API key.
        """
        return pulumi.get(self, "metrics_prefix")

    @metrics_prefix.setter
    def metrics_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metrics_prefix", value)

    @_builtins.property
    @pulumi.getter(name="monitoringInstanceId")
    def monitoring_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the STACKIT monitoring instance.
        """
        return pulumi.get(self, "monitoring_instance_id")

    @monitoring_instance_id.setter
    def monitoring_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "monitoring_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="opensearchTlsCiphers")
    def opensearch_tls_ciphers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "opensearch_tls_ciphers")

    @opensearch_tls_ciphers.setter
    def opensearch_tls_ciphers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "opensearch_tls_ciphers", value)

    @_builtins.property
    @pulumi.getter(name="opensearchTlsProtocols")
    def opensearch_tls_protocols(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "opensearch_tls_protocols")

    @opensearch_tls_protocols.setter
    def opensearch_tls_protocols(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "opensearch_tls_protocols", value)

    @_builtins.property
    @pulumi.getter(name="sgwAcl")
    def sgw_acl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Comma separated list of IP networks in CIDR notation which are allowed to access this instance.
        """
        return pulumi.get(self, "sgw_acl")

    @sgw_acl.setter
    def sgw_acl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sgw_acl", value)

    @_builtins.property
    @pulumi.getter
    def syslogs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of syslog servers to send logs to.
        """
        return pulumi.get(self, "syslogs")

    @syslogs.setter
    def syslogs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "syslogs", value)


if not MYPY:
    class MariadbInstanceParametersArgsDict(TypedDict):
        enable_monitoring: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Enable monitoring.
        """
        graphite: NotRequired[pulumi.Input[_builtins.str]]
        """
        Graphite server URL (host and port). If set, monitoring with Graphite will be enabled.
        """
        max_disk_threshold: NotRequired[pulumi.Input[_builtins.int]]
        """
        The maximum disk threshold in MB. If the disk usage exceeds this threshold, the instance will be stopped.
        """
        metrics_frequency: NotRequired[pulumi.Input[_builtins.int]]
        """
        The frequency in seconds at which metrics are emitted.
        """
        metrics_prefix: NotRequired[pulumi.Input[_builtins.str]]
        """
        The prefix for the metrics. Could be useful when using Graphite monitoring to prefix the metrics with a certain value, like an API key
        """
        monitoring_instance_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the STACKIT monitoring instance. Monitoring instances with the plan "Observability-Monitoring-Starter" are not supported.
        """
        sgw_acl: NotRequired[pulumi.Input[_builtins.str]]
        """
        Comma separated list of IP networks in CIDR notation which are allowed to access this instance.
        """
        syslogs: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        List of syslog servers to send logs to.
        """
elif False:
    MariadbInstanceParametersArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MariadbInstanceParametersArgs:
    def __init__(__self__, *,
                 enable_monitoring: Optional[pulumi.Input[_builtins.bool]] = None,
                 graphite: Optional[pulumi.Input[_builtins.str]] = None,
                 max_disk_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 metrics_frequency: Optional[pulumi.Input[_builtins.int]] = None,
                 metrics_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 monitoring_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sgw_acl: Optional[pulumi.Input[_builtins.str]] = None,
                 syslogs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        :param pulumi.Input[_builtins.bool] enable_monitoring: Enable monitoring.
        :param pulumi.Input[_builtins.str] graphite: Graphite server URL (host and port). If set, monitoring with Graphite will be enabled.
        :param pulumi.Input[_builtins.int] max_disk_threshold: The maximum disk threshold in MB. If the disk usage exceeds this threshold, the instance will be stopped.
        :param pulumi.Input[_builtins.int] metrics_frequency: The frequency in seconds at which metrics are emitted.
        :param pulumi.Input[_builtins.str] metrics_prefix: The prefix for the metrics. Could be useful when using Graphite monitoring to prefix the metrics with a certain value, like an API key
        :param pulumi.Input[_builtins.str] monitoring_instance_id: The ID of the STACKIT monitoring instance. Monitoring instances with the plan "Observability-Monitoring-Starter" are not supported.
        :param pulumi.Input[_builtins.str] sgw_acl: Comma separated list of IP networks in CIDR notation which are allowed to access this instance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] syslogs: List of syslog servers to send logs to.
        """
        if enable_monitoring is not None:
            pulumi.set(__self__, "enable_monitoring", enable_monitoring)
        if graphite is not None:
            pulumi.set(__self__, "graphite", graphite)
        if max_disk_threshold is not None:
            pulumi.set(__self__, "max_disk_threshold", max_disk_threshold)
        if metrics_frequency is not None:
            pulumi.set(__self__, "metrics_frequency", metrics_frequency)
        if metrics_prefix is not None:
            pulumi.set(__self__, "metrics_prefix", metrics_prefix)
        if monitoring_instance_id is not None:
            pulumi.set(__self__, "monitoring_instance_id", monitoring_instance_id)
        if sgw_acl is not None:
            pulumi.set(__self__, "sgw_acl", sgw_acl)
        if syslogs is not None:
            pulumi.set(__self__, "syslogs", syslogs)

    @_builtins.property
    @pulumi.getter(name="enableMonitoring")
    def enable_monitoring(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable monitoring.
        """
        return pulumi.get(self, "enable_monitoring")

    @enable_monitoring.setter
    def enable_monitoring(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_monitoring", value)

    @_builtins.property
    @pulumi.getter
    def graphite(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Graphite server URL (host and port). If set, monitoring with Graphite will be enabled.
        """
        return pulumi.get(self, "graphite")

    @graphite.setter
    def graphite(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "graphite", value)

    @_builtins.property
    @pulumi.getter(name="maxDiskThreshold")
    def max_disk_threshold(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum disk threshold in MB. If the disk usage exceeds this threshold, the instance will be stopped.
        """
        return pulumi.get(self, "max_disk_threshold")

    @max_disk_threshold.setter
    def max_disk_threshold(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_disk_threshold", value)

    @_builtins.property
    @pulumi.getter(name="metricsFrequency")
    def metrics_frequency(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The frequency in seconds at which metrics are emitted.
        """
        return pulumi.get(self, "metrics_frequency")

    @metrics_frequency.setter
    def metrics_frequency(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "metrics_frequency", value)

    @_builtins.property
    @pulumi.getter(name="metricsPrefix")
    def metrics_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The prefix for the metrics. Could be useful when using Graphite monitoring to prefix the metrics with a certain value, like an API key
        """
        return pulumi.get(self, "metrics_prefix")

    @metrics_prefix.setter
    def metrics_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metrics_prefix", value)

    @_builtins.property
    @pulumi.getter(name="monitoringInstanceId")
    def monitoring_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the STACKIT monitoring instance. Monitoring instances with the plan "Observability-Monitoring-Starter" are not supported.
        """
        return pulumi.get(self, "monitoring_instance_id")

    @monitoring_instance_id.setter
    def monitoring_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "monitoring_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="sgwAcl")
    def sgw_acl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Comma separated list of IP networks in CIDR notation which are allowed to access this instance.
        """
        return pulumi.get(self, "sgw_acl")

    @sgw_acl.setter
    def sgw_acl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sgw_acl", value)

    @_builtins.property
    @pulumi.getter
    def syslogs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of syslog servers to send logs to.
        """
        return pulumi.get(self, "syslogs")

    @syslogs.setter
    def syslogs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "syslogs", value)


if not MYPY:
    class MongodbflexInstanceFlavorArgsDict(TypedDict):
        cpu: pulumi.Input[_builtins.int]
        ram: pulumi.Input[_builtins.int]
        description: NotRequired[pulumi.Input[_builtins.str]]
        id: NotRequired[pulumi.Input[_builtins.str]]
elif False:
    MongodbflexInstanceFlavorArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MongodbflexInstanceFlavorArgs:
    def __init__(__self__, *,
                 cpu: pulumi.Input[_builtins.int],
                 ram: pulumi.Input[_builtins.int],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 id: Optional[pulumi.Input[_builtins.str]] = None):
        pulumi.set(__self__, "cpu", cpu)
        pulumi.set(__self__, "ram", ram)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> pulumi.Input[_builtins.int]:
        return pulumi.get(self, "cpu")

    @cpu.setter
    def cpu(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "cpu", value)

    @_builtins.property
    @pulumi.getter
    def ram(self) -> pulumi.Input[_builtins.int]:
        return pulumi.get(self, "ram")

    @ram.setter
    def ram(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "ram", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "id", value)


if not MYPY:
    class MongodbflexInstanceOptionsArgsDict(TypedDict):
        point_in_time_window_hours: pulumi.Input[_builtins.int]
        """
        The number of hours back in time the point-in-time recovery feature will be able to recover.
        """
        type: pulumi.Input[_builtins.str]
        """
        Type of the MongoDB Flex instance. Supported values are: `Replica`, `Sharded`, `Single`.
        """
        daily_snapshot_retention_days: NotRequired[pulumi.Input[_builtins.int]]
        """
        The number of days that daily backups will be retained.
        """
        monthly_snapshot_retention_months: NotRequired[pulumi.Input[_builtins.int]]
        """
        The number of months that monthly backups will be retained.
        """
        snapshot_retention_days: NotRequired[pulumi.Input[_builtins.int]]
        """
        The number of days that continuous backups (controlled via the `backup_schedule`) will be retained.
        """
        weekly_snapshot_retention_weeks: NotRequired[pulumi.Input[_builtins.int]]
        """
        The number of weeks that weekly backups will be retained.
        """
elif False:
    MongodbflexInstanceOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MongodbflexInstanceOptionsArgs:
    def __init__(__self__, *,
                 point_in_time_window_hours: pulumi.Input[_builtins.int],
                 type: pulumi.Input[_builtins.str],
                 daily_snapshot_retention_days: Optional[pulumi.Input[_builtins.int]] = None,
                 monthly_snapshot_retention_months: Optional[pulumi.Input[_builtins.int]] = None,
                 snapshot_retention_days: Optional[pulumi.Input[_builtins.int]] = None,
                 weekly_snapshot_retention_weeks: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.int] point_in_time_window_hours: The number of hours back in time the point-in-time recovery feature will be able to recover.
        :param pulumi.Input[_builtins.str] type: Type of the MongoDB Flex instance. Supported values are: `Replica`, `Sharded`, `Single`.
        :param pulumi.Input[_builtins.int] daily_snapshot_retention_days: The number of days that daily backups will be retained.
        :param pulumi.Input[_builtins.int] monthly_snapshot_retention_months: The number of months that monthly backups will be retained.
        :param pulumi.Input[_builtins.int] snapshot_retention_days: The number of days that continuous backups (controlled via the `backup_schedule`) will be retained.
        :param pulumi.Input[_builtins.int] weekly_snapshot_retention_weeks: The number of weeks that weekly backups will be retained.
        """
        pulumi.set(__self__, "point_in_time_window_hours", point_in_time_window_hours)
        pulumi.set(__self__, "type", type)
        if daily_snapshot_retention_days is not None:
            pulumi.set(__self__, "daily_snapshot_retention_days", daily_snapshot_retention_days)
        if monthly_snapshot_retention_months is not None:
            pulumi.set(__self__, "monthly_snapshot_retention_months", monthly_snapshot_retention_months)
        if snapshot_retention_days is not None:
            pulumi.set(__self__, "snapshot_retention_days", snapshot_retention_days)
        if weekly_snapshot_retention_weeks is not None:
            pulumi.set(__self__, "weekly_snapshot_retention_weeks", weekly_snapshot_retention_weeks)

    @_builtins.property
    @pulumi.getter(name="pointInTimeWindowHours")
    def point_in_time_window_hours(self) -> pulumi.Input[_builtins.int]:
        """
        The number of hours back in time the point-in-time recovery feature will be able to recover.
        """
        return pulumi.get(self, "point_in_time_window_hours")

    @point_in_time_window_hours.setter
    def point_in_time_window_hours(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "point_in_time_window_hours", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Type of the MongoDB Flex instance. Supported values are: `Replica`, `Sharded`, `Single`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="dailySnapshotRetentionDays")
    def daily_snapshot_retention_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of days that daily backups will be retained.
        """
        return pulumi.get(self, "daily_snapshot_retention_days")

    @daily_snapshot_retention_days.setter
    def daily_snapshot_retention_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "daily_snapshot_retention_days", value)

    @_builtins.property
    @pulumi.getter(name="monthlySnapshotRetentionMonths")
    def monthly_snapshot_retention_months(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of months that monthly backups will be retained.
        """
        return pulumi.get(self, "monthly_snapshot_retention_months")

    @monthly_snapshot_retention_months.setter
    def monthly_snapshot_retention_months(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "monthly_snapshot_retention_months", value)

    @_builtins.property
    @pulumi.getter(name="snapshotRetentionDays")
    def snapshot_retention_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of days that continuous backups (controlled via the `backup_schedule`) will be retained.
        """
        return pulumi.get(self, "snapshot_retention_days")

    @snapshot_retention_days.setter
    def snapshot_retention_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "snapshot_retention_days", value)

    @_builtins.property
    @pulumi.getter(name="weeklySnapshotRetentionWeeks")
    def weekly_snapshot_retention_weeks(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of weeks that weekly backups will be retained.
        """
        return pulumi.get(self, "weekly_snapshot_retention_weeks")

    @weekly_snapshot_retention_weeks.setter
    def weekly_snapshot_retention_weeks(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "weekly_snapshot_retention_weeks", value)


if not MYPY:
    class MongodbflexInstanceStorageArgsDict(TypedDict):
        class_: pulumi.Input[_builtins.str]
        size: pulumi.Input[_builtins.int]
elif False:
    MongodbflexInstanceStorageArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MongodbflexInstanceStorageArgs:
    def __init__(__self__, *,
                 class_: pulumi.Input[_builtins.str],
                 size: pulumi.Input[_builtins.int]):
        pulumi.set(__self__, "class_", class_)
        pulumi.set(__self__, "size", size)

    @_builtins.property
    @pulumi.getter(name="class")
    def class_(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "class_")

    @class_.setter
    def class_(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "class_", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> pulumi.Input[_builtins.int]:
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "size", value)


if not MYPY:
    class NetworkAreaNetworkRangeArgsDict(TypedDict):
        prefix: pulumi.Input[_builtins.str]
        """
        Classless Inter-Domain Routing (CIDR).
        """
        network_range_id: NotRequired[pulumi.Input[_builtins.str]]
elif False:
    NetworkAreaNetworkRangeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NetworkAreaNetworkRangeArgs:
    def __init__(__self__, *,
                 prefix: pulumi.Input[_builtins.str],
                 network_range_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] prefix: Classless Inter-Domain Routing (CIDR).
        """
        pulumi.set(__self__, "prefix", prefix)
        if network_range_id is not None:
            pulumi.set(__self__, "network_range_id", network_range_id)

    @_builtins.property
    @pulumi.getter
    def prefix(self) -> pulumi.Input[_builtins.str]:
        """
        Classless Inter-Domain Routing (CIDR).
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "prefix", value)

    @_builtins.property
    @pulumi.getter(name="networkRangeId")
    def network_range_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "network_range_id")

    @network_range_id.setter
    def network_range_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_range_id", value)


if not MYPY:
    class ObservabilityAlertgroupRuleArgsDict(TypedDict):
        alert: pulumi.Input[_builtins.str]
        """
        The name of the alert rule. Is the identifier and must be unique in the group.
        """
        expression: pulumi.Input[_builtins.str]
        """
        The PromQL expression to evaluate. Every evaluation cycle this is evaluated at the current time, and all resultant time series become pending/firing alerts.
        """
        annotations: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]
        """
        A map of key:value. Annotations to add or overwrite for each alert
        """
        for_: NotRequired[pulumi.Input[_builtins.str]]
        """
        Alerts are considered firing once they have been returned for this long. Alerts which have not yet fired for long enough are considered pending. Default is 0s
        """
        labels: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]
        """
        A map of key:value. Labels to add or overwrite for each alert
        """
elif False:
    ObservabilityAlertgroupRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ObservabilityAlertgroupRuleArgs:
    def __init__(__self__, *,
                 alert: pulumi.Input[_builtins.str],
                 expression: pulumi.Input[_builtins.str],
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 for_: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        :param pulumi.Input[_builtins.str] alert: The name of the alert rule. Is the identifier and must be unique in the group.
        :param pulumi.Input[_builtins.str] expression: The PromQL expression to evaluate. Every evaluation cycle this is evaluated at the current time, and all resultant time series become pending/firing alerts.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: A map of key:value. Annotations to add or overwrite for each alert
        :param pulumi.Input[_builtins.str] for_: Alerts are considered firing once they have been returned for this long. Alerts which have not yet fired for long enough are considered pending. Default is 0s
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A map of key:value. Labels to add or overwrite for each alert
        """
        pulumi.set(__self__, "alert", alert)
        pulumi.set(__self__, "expression", expression)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if for_ is not None:
            pulumi.set(__self__, "for_", for_)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)

    @_builtins.property
    @pulumi.getter
    def alert(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the alert rule. Is the identifier and must be unique in the group.
        """
        return pulumi.get(self, "alert")

    @alert.setter
    def alert(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "alert", value)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> pulumi.Input[_builtins.str]:
        """
        The PromQL expression to evaluate. Every evaluation cycle this is evaluated at the current time, and all resultant time series become pending/firing alerts.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "expression", value)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of key:value. Annotations to add or overwrite for each alert
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter(name="for")
    def for_(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Alerts are considered firing once they have been returned for this long. Alerts which have not yet fired for long enough are considered pending. Default is 0s
        """
        return pulumi.get(self, "for_")

    @for_.setter
    def for_(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "for_", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of key:value. Labels to add or overwrite for each alert
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)


if not MYPY:
    class ObservabilityInstanceAlertConfigArgsDict(TypedDict):
        receivers: pulumi.Input[Sequence[pulumi.Input['ObservabilityInstanceAlertConfigReceiverArgsDict']]]
        """
        List of alert receivers.
        """
        route: pulumi.Input['ObservabilityInstanceAlertConfigRouteArgsDict']
        """
        Route configuration for the alerts.
        """
        global_: NotRequired[pulumi.Input['ObservabilityInstanceAlertConfigGlobalArgsDict']]
        """
        Global configuration for the alerts.
        """
elif False:
    ObservabilityInstanceAlertConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ObservabilityInstanceAlertConfigArgs:
    def __init__(__self__, *,
                 receivers: pulumi.Input[Sequence[pulumi.Input['ObservabilityInstanceAlertConfigReceiverArgs']]],
                 route: pulumi.Input['ObservabilityInstanceAlertConfigRouteArgs'],
                 global_: Optional[pulumi.Input['ObservabilityInstanceAlertConfigGlobalArgs']] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ObservabilityInstanceAlertConfigReceiverArgs']]] receivers: List of alert receivers.
        :param pulumi.Input['ObservabilityInstanceAlertConfigRouteArgs'] route: Route configuration for the alerts.
        :param pulumi.Input['ObservabilityInstanceAlertConfigGlobalArgs'] global_: Global configuration for the alerts.
        """
        pulumi.set(__self__, "receivers", receivers)
        pulumi.set(__self__, "route", route)
        if global_ is not None:
            pulumi.set(__self__, "global_", global_)

    @_builtins.property
    @pulumi.getter
    def receivers(self) -> pulumi.Input[Sequence[pulumi.Input['ObservabilityInstanceAlertConfigReceiverArgs']]]:
        """
        List of alert receivers.
        """
        return pulumi.get(self, "receivers")

    @receivers.setter
    def receivers(self, value: pulumi.Input[Sequence[pulumi.Input['ObservabilityInstanceAlertConfigReceiverArgs']]]):
        pulumi.set(self, "receivers", value)

    @_builtins.property
    @pulumi.getter
    def route(self) -> pulumi.Input['ObservabilityInstanceAlertConfigRouteArgs']:
        """
        Route configuration for the alerts.
        """
        return pulumi.get(self, "route")

    @route.setter
    def route(self, value: pulumi.Input['ObservabilityInstanceAlertConfigRouteArgs']):
        pulumi.set(self, "route", value)

    @_builtins.property
    @pulumi.getter(name="global")
    def global_(self) -> Optional[pulumi.Input['ObservabilityInstanceAlertConfigGlobalArgs']]:
        """
        Global configuration for the alerts.
        """
        return pulumi.get(self, "global_")

    @global_.setter
    def global_(self, value: Optional[pulumi.Input['ObservabilityInstanceAlertConfigGlobalArgs']]):
        pulumi.set(self, "global_", value)


if not MYPY:
    class ObservabilityInstanceAlertConfigGlobalArgsDict(TypedDict):
        opsgenie_api_key: NotRequired[pulumi.Input[_builtins.str]]
        """
        The API key for OpsGenie.
        """
        opsgenie_api_url: NotRequired[pulumi.Input[_builtins.str]]
        """
        The host to send OpsGenie API requests to. Must be a valid URL
        """
        resolve_timeout: NotRequired[pulumi.Input[_builtins.str]]
        """
        The default value used by alertmanager if the alert does not include EndsAt. After this time passes, it can declare the alert as resolved if it has not been updated. This has no impact on alerts from Prometheus, as they always include EndsAt.
        """
        smtp_auth_identity: NotRequired[pulumi.Input[_builtins.str]]
        """
        SMTP authentication information. Must be a valid email address
        """
        smtp_auth_password: NotRequired[pulumi.Input[_builtins.str]]
        """
        SMTP Auth using LOGIN and PLAIN.
        """
        smtp_auth_username: NotRequired[pulumi.Input[_builtins.str]]
        """
        SMTP Auth using CRAM-MD5, LOGIN and PLAIN. If empty, Alertmanager doesn't authenticate to the SMTP server.
        """
        smtp_from: NotRequired[pulumi.Input[_builtins.str]]
        """
        The default SMTP From header field. Must be a valid email address
        """
        smtp_smart_host: NotRequired[pulumi.Input[_builtins.str]]
        """
        The default SMTP smarthost used for sending emails, including port number in format `host:port` (eg. `smtp.example.com:587`). Port number usually is 25, or 587 for SMTP over TLS (sometimes referred to as STARTTLS).
        """
elif False:
    ObservabilityInstanceAlertConfigGlobalArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ObservabilityInstanceAlertConfigGlobalArgs:
    def __init__(__self__, *,
                 opsgenie_api_key: Optional[pulumi.Input[_builtins.str]] = None,
                 opsgenie_api_url: Optional[pulumi.Input[_builtins.str]] = None,
                 resolve_timeout: Optional[pulumi.Input[_builtins.str]] = None,
                 smtp_auth_identity: Optional[pulumi.Input[_builtins.str]] = None,
                 smtp_auth_password: Optional[pulumi.Input[_builtins.str]] = None,
                 smtp_auth_username: Optional[pulumi.Input[_builtins.str]] = None,
                 smtp_from: Optional[pulumi.Input[_builtins.str]] = None,
                 smtp_smart_host: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] opsgenie_api_key: The API key for OpsGenie.
        :param pulumi.Input[_builtins.str] opsgenie_api_url: The host to send OpsGenie API requests to. Must be a valid URL
        :param pulumi.Input[_builtins.str] resolve_timeout: The default value used by alertmanager if the alert does not include EndsAt. After this time passes, it can declare the alert as resolved if it has not been updated. This has no impact on alerts from Prometheus, as they always include EndsAt.
        :param pulumi.Input[_builtins.str] smtp_auth_identity: SMTP authentication information. Must be a valid email address
        :param pulumi.Input[_builtins.str] smtp_auth_password: SMTP Auth using LOGIN and PLAIN.
        :param pulumi.Input[_builtins.str] smtp_auth_username: SMTP Auth using CRAM-MD5, LOGIN and PLAIN. If empty, Alertmanager doesn't authenticate to the SMTP server.
        :param pulumi.Input[_builtins.str] smtp_from: The default SMTP From header field. Must be a valid email address
        :param pulumi.Input[_builtins.str] smtp_smart_host: The default SMTP smarthost used for sending emails, including port number in format `host:port` (eg. `smtp.example.com:587`). Port number usually is 25, or 587 for SMTP over TLS (sometimes referred to as STARTTLS).
        """
        if opsgenie_api_key is not None:
            pulumi.set(__self__, "opsgenie_api_key", opsgenie_api_key)
        if opsgenie_api_url is not None:
            pulumi.set(__self__, "opsgenie_api_url", opsgenie_api_url)
        if resolve_timeout is not None:
            pulumi.set(__self__, "resolve_timeout", resolve_timeout)
        if smtp_auth_identity is not None:
            pulumi.set(__self__, "smtp_auth_identity", smtp_auth_identity)
        if smtp_auth_password is not None:
            pulumi.set(__self__, "smtp_auth_password", smtp_auth_password)
        if smtp_auth_username is not None:
            pulumi.set(__self__, "smtp_auth_username", smtp_auth_username)
        if smtp_from is not None:
            pulumi.set(__self__, "smtp_from", smtp_from)
        if smtp_smart_host is not None:
            pulumi.set(__self__, "smtp_smart_host", smtp_smart_host)

    @_builtins.property
    @pulumi.getter(name="opsgenieApiKey")
    def opsgenie_api_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The API key for OpsGenie.
        """
        return pulumi.get(self, "opsgenie_api_key")

    @opsgenie_api_key.setter
    def opsgenie_api_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "opsgenie_api_key", value)

    @_builtins.property
    @pulumi.getter(name="opsgenieApiUrl")
    def opsgenie_api_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The host to send OpsGenie API requests to. Must be a valid URL
        """
        return pulumi.get(self, "opsgenie_api_url")

    @opsgenie_api_url.setter
    def opsgenie_api_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "opsgenie_api_url", value)

    @_builtins.property
    @pulumi.getter(name="resolveTimeout")
    def resolve_timeout(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The default value used by alertmanager if the alert does not include EndsAt. After this time passes, it can declare the alert as resolved if it has not been updated. This has no impact on alerts from Prometheus, as they always include EndsAt.
        """
        return pulumi.get(self, "resolve_timeout")

    @resolve_timeout.setter
    def resolve_timeout(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resolve_timeout", value)

    @_builtins.property
    @pulumi.getter(name="smtpAuthIdentity")
    def smtp_auth_identity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        SMTP authentication information. Must be a valid email address
        """
        return pulumi.get(self, "smtp_auth_identity")

    @smtp_auth_identity.setter
    def smtp_auth_identity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "smtp_auth_identity", value)

    @_builtins.property
    @pulumi.getter(name="smtpAuthPassword")
    def smtp_auth_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        SMTP Auth using LOGIN and PLAIN.
        """
        return pulumi.get(self, "smtp_auth_password")

    @smtp_auth_password.setter
    def smtp_auth_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "smtp_auth_password", value)

    @_builtins.property
    @pulumi.getter(name="smtpAuthUsername")
    def smtp_auth_username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        SMTP Auth using CRAM-MD5, LOGIN and PLAIN. If empty, Alertmanager doesn't authenticate to the SMTP server.
        """
        return pulumi.get(self, "smtp_auth_username")

    @smtp_auth_username.setter
    def smtp_auth_username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "smtp_auth_username", value)

    @_builtins.property
    @pulumi.getter(name="smtpFrom")
    def smtp_from(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The default SMTP From header field. Must be a valid email address
        """
        return pulumi.get(self, "smtp_from")

    @smtp_from.setter
    def smtp_from(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "smtp_from", value)

    @_builtins.property
    @pulumi.getter(name="smtpSmartHost")
    def smtp_smart_host(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The default SMTP smarthost used for sending emails, including port number in format `host:port` (eg. `smtp.example.com:587`). Port number usually is 25, or 587 for SMTP over TLS (sometimes referred to as STARTTLS).
        """
        return pulumi.get(self, "smtp_smart_host")

    @smtp_smart_host.setter
    def smtp_smart_host(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "smtp_smart_host", value)


if not MYPY:
    class ObservabilityInstanceAlertConfigReceiverArgsDict(TypedDict):
        name: pulumi.Input[_builtins.str]
        """
        Name of the receiver.
        """
        email_configs: NotRequired[pulumi.Input[Sequence[pulumi.Input['ObservabilityInstanceAlertConfigReceiverEmailConfigArgsDict']]]]
        """
        List of email configurations.
        """
        opsgenie_configs: NotRequired[pulumi.Input[Sequence[pulumi.Input['ObservabilityInstanceAlertConfigReceiverOpsgenieConfigArgsDict']]]]
        """
        List of OpsGenie configurations.
        """
        webhooks_configs: NotRequired[pulumi.Input[Sequence[pulumi.Input['ObservabilityInstanceAlertConfigReceiverWebhooksConfigArgsDict']]]]
        """
        List of Webhooks configurations.
        """
elif False:
    ObservabilityInstanceAlertConfigReceiverArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ObservabilityInstanceAlertConfigReceiverArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 email_configs: Optional[pulumi.Input[Sequence[pulumi.Input['ObservabilityInstanceAlertConfigReceiverEmailConfigArgs']]]] = None,
                 opsgenie_configs: Optional[pulumi.Input[Sequence[pulumi.Input['ObservabilityInstanceAlertConfigReceiverOpsgenieConfigArgs']]]] = None,
                 webhooks_configs: Optional[pulumi.Input[Sequence[pulumi.Input['ObservabilityInstanceAlertConfigReceiverWebhooksConfigArgs']]]] = None):
        """
        :param pulumi.Input[_builtins.str] name: Name of the receiver.
        :param pulumi.Input[Sequence[pulumi.Input['ObservabilityInstanceAlertConfigReceiverEmailConfigArgs']]] email_configs: List of email configurations.
        :param pulumi.Input[Sequence[pulumi.Input['ObservabilityInstanceAlertConfigReceiverOpsgenieConfigArgs']]] opsgenie_configs: List of OpsGenie configurations.
        :param pulumi.Input[Sequence[pulumi.Input['ObservabilityInstanceAlertConfigReceiverWebhooksConfigArgs']]] webhooks_configs: List of Webhooks configurations.
        """
        pulumi.set(__self__, "name", name)
        if email_configs is not None:
            pulumi.set(__self__, "email_configs", email_configs)
        if opsgenie_configs is not None:
            pulumi.set(__self__, "opsgenie_configs", opsgenie_configs)
        if webhooks_configs is not None:
            pulumi.set(__self__, "webhooks_configs", webhooks_configs)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the receiver.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="emailConfigs")
    def email_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ObservabilityInstanceAlertConfigReceiverEmailConfigArgs']]]]:
        """
        List of email configurations.
        """
        return pulumi.get(self, "email_configs")

    @email_configs.setter
    def email_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ObservabilityInstanceAlertConfigReceiverEmailConfigArgs']]]]):
        pulumi.set(self, "email_configs", value)

    @_builtins.property
    @pulumi.getter(name="opsgenieConfigs")
    def opsgenie_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ObservabilityInstanceAlertConfigReceiverOpsgenieConfigArgs']]]]:
        """
        List of OpsGenie configurations.
        """
        return pulumi.get(self, "opsgenie_configs")

    @opsgenie_configs.setter
    def opsgenie_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ObservabilityInstanceAlertConfigReceiverOpsgenieConfigArgs']]]]):
        pulumi.set(self, "opsgenie_configs", value)

    @_builtins.property
    @pulumi.getter(name="webhooksConfigs")
    def webhooks_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ObservabilityInstanceAlertConfigReceiverWebhooksConfigArgs']]]]:
        """
        List of Webhooks configurations.
        """
        return pulumi.get(self, "webhooks_configs")

    @webhooks_configs.setter
    def webhooks_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ObservabilityInstanceAlertConfigReceiverWebhooksConfigArgs']]]]):
        pulumi.set(self, "webhooks_configs", value)


if not MYPY:
    class ObservabilityInstanceAlertConfigReceiverEmailConfigArgsDict(TypedDict):
        auth_identity: NotRequired[pulumi.Input[_builtins.str]]
        """
        SMTP authentication information. Must be a valid email address
        """
        auth_password: NotRequired[pulumi.Input[_builtins.str]]
        """
        SMTP authentication password.
        """
        auth_username: NotRequired[pulumi.Input[_builtins.str]]
        """
        SMTP authentication username.
        """
        from_: NotRequired[pulumi.Input[_builtins.str]]
        """
        The sender email address. Must be a valid email address
        """
        smart_host: NotRequired[pulumi.Input[_builtins.str]]
        """
        The SMTP host through which emails are sent.
        """
        to: NotRequired[pulumi.Input[_builtins.str]]
        """
        The email address to send notifications to. Must be a valid email address
        """
elif False:
    ObservabilityInstanceAlertConfigReceiverEmailConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ObservabilityInstanceAlertConfigReceiverEmailConfigArgs:
    def __init__(__self__, *,
                 auth_identity: Optional[pulumi.Input[_builtins.str]] = None,
                 auth_password: Optional[pulumi.Input[_builtins.str]] = None,
                 auth_username: Optional[pulumi.Input[_builtins.str]] = None,
                 from_: Optional[pulumi.Input[_builtins.str]] = None,
                 smart_host: Optional[pulumi.Input[_builtins.str]] = None,
                 to: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] auth_identity: SMTP authentication information. Must be a valid email address
        :param pulumi.Input[_builtins.str] auth_password: SMTP authentication password.
        :param pulumi.Input[_builtins.str] auth_username: SMTP authentication username.
        :param pulumi.Input[_builtins.str] from_: The sender email address. Must be a valid email address
        :param pulumi.Input[_builtins.str] smart_host: The SMTP host through which emails are sent.
        :param pulumi.Input[_builtins.str] to: The email address to send notifications to. Must be a valid email address
        """
        if auth_identity is not None:
            pulumi.set(__self__, "auth_identity", auth_identity)
        if auth_password is not None:
            pulumi.set(__self__, "auth_password", auth_password)
        if auth_username is not None:
            pulumi.set(__self__, "auth_username", auth_username)
        if from_ is not None:
            pulumi.set(__self__, "from_", from_)
        if smart_host is not None:
            pulumi.set(__self__, "smart_host", smart_host)
        if to is not None:
            pulumi.set(__self__, "to", to)

    @_builtins.property
    @pulumi.getter(name="authIdentity")
    def auth_identity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        SMTP authentication information. Must be a valid email address
        """
        return pulumi.get(self, "auth_identity")

    @auth_identity.setter
    def auth_identity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auth_identity", value)

    @_builtins.property
    @pulumi.getter(name="authPassword")
    def auth_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        SMTP authentication password.
        """
        return pulumi.get(self, "auth_password")

    @auth_password.setter
    def auth_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auth_password", value)

    @_builtins.property
    @pulumi.getter(name="authUsername")
    def auth_username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        SMTP authentication username.
        """
        return pulumi.get(self, "auth_username")

    @auth_username.setter
    def auth_username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auth_username", value)

    @_builtins.property
    @pulumi.getter(name="from")
    def from_(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The sender email address. Must be a valid email address
        """
        return pulumi.get(self, "from_")

    @from_.setter
    def from_(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "from_", value)

    @_builtins.property
    @pulumi.getter(name="smartHost")
    def smart_host(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SMTP host through which emails are sent.
        """
        return pulumi.get(self, "smart_host")

    @smart_host.setter
    def smart_host(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "smart_host", value)

    @_builtins.property
    @pulumi.getter
    def to(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The email address to send notifications to. Must be a valid email address
        """
        return pulumi.get(self, "to")

    @to.setter
    def to(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "to", value)


if not MYPY:
    class ObservabilityInstanceAlertConfigReceiverOpsgenieConfigArgsDict(TypedDict):
        api_key: NotRequired[pulumi.Input[_builtins.str]]
        """
        The API key for OpsGenie.
        """
        api_url: NotRequired[pulumi.Input[_builtins.str]]
        """
        The host to send OpsGenie API requests to. Must be a valid URL
        """
        tags: NotRequired[pulumi.Input[_builtins.str]]
        """
        Comma separated list of tags attached to the notifications.
        """
elif False:
    ObservabilityInstanceAlertConfigReceiverOpsgenieConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ObservabilityInstanceAlertConfigReceiverOpsgenieConfigArgs:
    def __init__(__self__, *,
                 api_key: Optional[pulumi.Input[_builtins.str]] = None,
                 api_url: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] api_key: The API key for OpsGenie.
        :param pulumi.Input[_builtins.str] api_url: The host to send OpsGenie API requests to. Must be a valid URL
        :param pulumi.Input[_builtins.str] tags: Comma separated list of tags attached to the notifications.
        """
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if api_url is not None:
            pulumi.set(__self__, "api_url", api_url)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The API key for OpsGenie.
        """
        return pulumi.get(self, "api_key")

    @api_key.setter
    def api_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_key", value)

    @_builtins.property
    @pulumi.getter(name="apiUrl")
    def api_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The host to send OpsGenie API requests to. Must be a valid URL
        """
        return pulumi.get(self, "api_url")

    @api_url.setter
    def api_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_url", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Comma separated list of tags attached to the notifications.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tags", value)


if not MYPY:
    class ObservabilityInstanceAlertConfigReceiverWebhooksConfigArgsDict(TypedDict):
        ms_teams: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Microsoft Teams webhooks require special handling, set this to true if the webhook is for Microsoft Teams.
        """
        url: NotRequired[pulumi.Input[_builtins.str]]
        """
        The endpoint to send HTTP POST requests to. Must be a valid URL
        """
elif False:
    ObservabilityInstanceAlertConfigReceiverWebhooksConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ObservabilityInstanceAlertConfigReceiverWebhooksConfigArgs:
    def __init__(__self__, *,
                 ms_teams: Optional[pulumi.Input[_builtins.bool]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.bool] ms_teams: Microsoft Teams webhooks require special handling, set this to true if the webhook is for Microsoft Teams.
        :param pulumi.Input[_builtins.str] url: The endpoint to send HTTP POST requests to. Must be a valid URL
        """
        if ms_teams is not None:
            pulumi.set(__self__, "ms_teams", ms_teams)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter(name="msTeams")
    def ms_teams(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Microsoft Teams webhooks require special handling, set this to true if the webhook is for Microsoft Teams.
        """
        return pulumi.get(self, "ms_teams")

    @ms_teams.setter
    def ms_teams(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ms_teams", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The endpoint to send HTTP POST requests to. Must be a valid URL
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url", value)


if not MYPY:
    class ObservabilityInstanceAlertConfigRouteArgsDict(TypedDict):
        receiver: pulumi.Input[_builtins.str]
        """
        The name of the receiver to route the alerts to.
        """
        group_bies: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        The labels by which incoming alerts are grouped together. For example, multiple alerts coming in for cluster=A and alertname=LatencyHigh would be batched into a single group. To aggregate by all possible labels use the special value '...' as the sole label name, for example: group_by: ['...']. This effectively disables aggregation entirely, passing through all alerts as-is. This is unlikely to be what you want, unless you have a very low alert volume or your upstream notification system performs its own grouping.
        """
        group_interval: NotRequired[pulumi.Input[_builtins.str]]
        """
        How long to wait before sending a notification about new alerts that are added to a group of alerts for which an initial notification has already been sent. (Usually ~5m or more.)
        """
        group_wait: NotRequired[pulumi.Input[_builtins.str]]
        """
        How long to initially wait to send a notification for a group of alerts. Allows to wait for an inhibiting alert to arrive or collect more initial alerts for the same group. (Usually ~0s to few minutes.)
        """
        match: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]
        """
        A set of equality matchers an alert has to fulfill to match the node.
        """
        match_regex: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]
        """
        A set of regex-matchers an alert has to fulfill to match the node.
        """
        repeat_interval: NotRequired[pulumi.Input[_builtins.str]]
        """
        How long to wait before sending a notification again if it has already been sent successfully for an alert. (Usually ~3h or more).
        """
        routes: NotRequired[pulumi.Input[Sequence[pulumi.Input['ObservabilityInstanceAlertConfigRouteRouteArgsDict']]]]
        """
        List of child routes.
        """
elif False:
    ObservabilityInstanceAlertConfigRouteArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ObservabilityInstanceAlertConfigRouteArgs:
    def __init__(__self__, *,
                 receiver: pulumi.Input[_builtins.str],
                 group_bies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 group_interval: Optional[pulumi.Input[_builtins.str]] = None,
                 group_wait: Optional[pulumi.Input[_builtins.str]] = None,
                 match: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 match_regex: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 repeat_interval: Optional[pulumi.Input[_builtins.str]] = None,
                 routes: Optional[pulumi.Input[Sequence[pulumi.Input['ObservabilityInstanceAlertConfigRouteRouteArgs']]]] = None):
        """
        :param pulumi.Input[_builtins.str] receiver: The name of the receiver to route the alerts to.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] group_bies: The labels by which incoming alerts are grouped together. For example, multiple alerts coming in for cluster=A and alertname=LatencyHigh would be batched into a single group. To aggregate by all possible labels use the special value '...' as the sole label name, for example: group_by: ['...']. This effectively disables aggregation entirely, passing through all alerts as-is. This is unlikely to be what you want, unless you have a very low alert volume or your upstream notification system performs its own grouping.
        :param pulumi.Input[_builtins.str] group_interval: How long to wait before sending a notification about new alerts that are added to a group of alerts for which an initial notification has already been sent. (Usually ~5m or more.)
        :param pulumi.Input[_builtins.str] group_wait: How long to initially wait to send a notification for a group of alerts. Allows to wait for an inhibiting alert to arrive or collect more initial alerts for the same group. (Usually ~0s to few minutes.)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] match: A set of equality matchers an alert has to fulfill to match the node.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] match_regex: A set of regex-matchers an alert has to fulfill to match the node.
        :param pulumi.Input[_builtins.str] repeat_interval: How long to wait before sending a notification again if it has already been sent successfully for an alert. (Usually ~3h or more).
        :param pulumi.Input[Sequence[pulumi.Input['ObservabilityInstanceAlertConfigRouteRouteArgs']]] routes: List of child routes.
        """
        pulumi.set(__self__, "receiver", receiver)
        if group_bies is not None:
            pulumi.set(__self__, "group_bies", group_bies)
        if group_interval is not None:
            pulumi.set(__self__, "group_interval", group_interval)
        if group_wait is not None:
            pulumi.set(__self__, "group_wait", group_wait)
        if match is not None:
            pulumi.set(__self__, "match", match)
        if match_regex is not None:
            pulumi.set(__self__, "match_regex", match_regex)
        if repeat_interval is not None:
            pulumi.set(__self__, "repeat_interval", repeat_interval)
        if routes is not None:
            pulumi.set(__self__, "routes", routes)

    @_builtins.property
    @pulumi.getter
    def receiver(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the receiver to route the alerts to.
        """
        return pulumi.get(self, "receiver")

    @receiver.setter
    def receiver(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "receiver", value)

    @_builtins.property
    @pulumi.getter(name="groupBies")
    def group_bies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The labels by which incoming alerts are grouped together. For example, multiple alerts coming in for cluster=A and alertname=LatencyHigh would be batched into a single group. To aggregate by all possible labels use the special value '...' as the sole label name, for example: group_by: ['...']. This effectively disables aggregation entirely, passing through all alerts as-is. This is unlikely to be what you want, unless you have a very low alert volume or your upstream notification system performs its own grouping.
        """
        return pulumi.get(self, "group_bies")

    @group_bies.setter
    def group_bies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "group_bies", value)

    @_builtins.property
    @pulumi.getter(name="groupInterval")
    def group_interval(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        How long to wait before sending a notification about new alerts that are added to a group of alerts for which an initial notification has already been sent. (Usually ~5m or more.)
        """
        return pulumi.get(self, "group_interval")

    @group_interval.setter
    def group_interval(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_interval", value)

    @_builtins.property
    @pulumi.getter(name="groupWait")
    def group_wait(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        How long to initially wait to send a notification for a group of alerts. Allows to wait for an inhibiting alert to arrive or collect more initial alerts for the same group. (Usually ~0s to few minutes.)
        """
        return pulumi.get(self, "group_wait")

    @group_wait.setter
    def group_wait(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_wait", value)

    @_builtins.property
    @pulumi.getter
    def match(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of equality matchers an alert has to fulfill to match the node.
        """
        return pulumi.get(self, "match")

    @match.setter
    def match(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "match", value)

    @_builtins.property
    @pulumi.getter(name="matchRegex")
    def match_regex(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of regex-matchers an alert has to fulfill to match the node.
        """
        return pulumi.get(self, "match_regex")

    @match_regex.setter
    def match_regex(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "match_regex", value)

    @_builtins.property
    @pulumi.getter(name="repeatInterval")
    def repeat_interval(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        How long to wait before sending a notification again if it has already been sent successfully for an alert. (Usually ~3h or more).
        """
        return pulumi.get(self, "repeat_interval")

    @repeat_interval.setter
    def repeat_interval(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repeat_interval", value)

    @_builtins.property
    @pulumi.getter
    def routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ObservabilityInstanceAlertConfigRouteRouteArgs']]]]:
        """
        List of child routes.
        """
        return pulumi.get(self, "routes")

    @routes.setter
    def routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ObservabilityInstanceAlertConfigRouteRouteArgs']]]]):
        pulumi.set(self, "routes", value)


if not MYPY:
    class ObservabilityInstanceAlertConfigRouteRouteArgsDict(TypedDict):
        receiver: pulumi.Input[_builtins.str]
        """
        The name of the receiver to route the alerts to.
        """
        group_bies: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        The labels by which incoming alerts are grouped together. For example, multiple alerts coming in for cluster=A and alertname=LatencyHigh would be batched into a single group. To aggregate by all possible labels use the special value '...' as the sole label name, for example: group_by: ['...']. This effectively disables aggregation entirely, passing through all alerts as-is. This is unlikely to be what you want, unless you have a very low alert volume or your upstream notification system performs its own grouping.
        """
        group_interval: NotRequired[pulumi.Input[_builtins.str]]
        """
        How long to wait before sending a notification about new alerts that are added to a group of alerts for which an initial notification has already been sent. (Usually ~5m or more.)
        """
        group_wait: NotRequired[pulumi.Input[_builtins.str]]
        """
        How long to initially wait to send a notification for a group of alerts. Allows to wait for an inhibiting alert to arrive or collect more initial alerts for the same group. (Usually ~0s to few minutes.)
        """
        match: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]
        """
        A set of equality matchers an alert has to fulfill to match the node.
        """
        match_regex: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]
        """
        A set of regex-matchers an alert has to fulfill to match the node.
        """
        repeat_interval: NotRequired[pulumi.Input[_builtins.str]]
        """
        How long to wait before sending a notification again if it has already been sent successfully for an alert. (Usually ~3h or more).
        """
elif False:
    ObservabilityInstanceAlertConfigRouteRouteArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ObservabilityInstanceAlertConfigRouteRouteArgs:
    def __init__(__self__, *,
                 receiver: pulumi.Input[_builtins.str],
                 group_bies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 group_interval: Optional[pulumi.Input[_builtins.str]] = None,
                 group_wait: Optional[pulumi.Input[_builtins.str]] = None,
                 match: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 match_regex: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 repeat_interval: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] receiver: The name of the receiver to route the alerts to.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] group_bies: The labels by which incoming alerts are grouped together. For example, multiple alerts coming in for cluster=A and alertname=LatencyHigh would be batched into a single group. To aggregate by all possible labels use the special value '...' as the sole label name, for example: group_by: ['...']. This effectively disables aggregation entirely, passing through all alerts as-is. This is unlikely to be what you want, unless you have a very low alert volume or your upstream notification system performs its own grouping.
        :param pulumi.Input[_builtins.str] group_interval: How long to wait before sending a notification about new alerts that are added to a group of alerts for which an initial notification has already been sent. (Usually ~5m or more.)
        :param pulumi.Input[_builtins.str] group_wait: How long to initially wait to send a notification for a group of alerts. Allows to wait for an inhibiting alert to arrive or collect more initial alerts for the same group. (Usually ~0s to few minutes.)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] match: A set of equality matchers an alert has to fulfill to match the node.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] match_regex: A set of regex-matchers an alert has to fulfill to match the node.
        :param pulumi.Input[_builtins.str] repeat_interval: How long to wait before sending a notification again if it has already been sent successfully for an alert. (Usually ~3h or more).
        """
        pulumi.set(__self__, "receiver", receiver)
        if group_bies is not None:
            pulumi.set(__self__, "group_bies", group_bies)
        if group_interval is not None:
            pulumi.set(__self__, "group_interval", group_interval)
        if group_wait is not None:
            pulumi.set(__self__, "group_wait", group_wait)
        if match is not None:
            pulumi.set(__self__, "match", match)
        if match_regex is not None:
            pulumi.set(__self__, "match_regex", match_regex)
        if repeat_interval is not None:
            pulumi.set(__self__, "repeat_interval", repeat_interval)

    @_builtins.property
    @pulumi.getter
    def receiver(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the receiver to route the alerts to.
        """
        return pulumi.get(self, "receiver")

    @receiver.setter
    def receiver(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "receiver", value)

    @_builtins.property
    @pulumi.getter(name="groupBies")
    def group_bies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The labels by which incoming alerts are grouped together. For example, multiple alerts coming in for cluster=A and alertname=LatencyHigh would be batched into a single group. To aggregate by all possible labels use the special value '...' as the sole label name, for example: group_by: ['...']. This effectively disables aggregation entirely, passing through all alerts as-is. This is unlikely to be what you want, unless you have a very low alert volume or your upstream notification system performs its own grouping.
        """
        return pulumi.get(self, "group_bies")

    @group_bies.setter
    def group_bies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "group_bies", value)

    @_builtins.property
    @pulumi.getter(name="groupInterval")
    def group_interval(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        How long to wait before sending a notification about new alerts that are added to a group of alerts for which an initial notification has already been sent. (Usually ~5m or more.)
        """
        return pulumi.get(self, "group_interval")

    @group_interval.setter
    def group_interval(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_interval", value)

    @_builtins.property
    @pulumi.getter(name="groupWait")
    def group_wait(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        How long to initially wait to send a notification for a group of alerts. Allows to wait for an inhibiting alert to arrive or collect more initial alerts for the same group. (Usually ~0s to few minutes.)
        """
        return pulumi.get(self, "group_wait")

    @group_wait.setter
    def group_wait(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_wait", value)

    @_builtins.property
    @pulumi.getter
    def match(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of equality matchers an alert has to fulfill to match the node.
        """
        return pulumi.get(self, "match")

    @match.setter
    def match(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "match", value)

    @_builtins.property
    @pulumi.getter(name="matchRegex")
    def match_regex(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of regex-matchers an alert has to fulfill to match the node.
        """
        return pulumi.get(self, "match_regex")

    @match_regex.setter
    def match_regex(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "match_regex", value)

    @_builtins.property
    @pulumi.getter(name="repeatInterval")
    def repeat_interval(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        How long to wait before sending a notification again if it has already been sent successfully for an alert. (Usually ~3h or more).
        """
        return pulumi.get(self, "repeat_interval")

    @repeat_interval.setter
    def repeat_interval(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repeat_interval", value)


if not MYPY:
    class ObservabilityLogalertgroupRuleArgsDict(TypedDict):
        alert: pulumi.Input[_builtins.str]
        """
        The name of the alert rule. Is the identifier and must be unique in the group.
        """
        expression: pulumi.Input[_builtins.str]
        """
        The LogQL expression to evaluate. Every evaluation cycle this is evaluated at the current time, and all resultant time series become pending/firing alerts.
        """
        annotations: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]
        """
        A map of key:value. Annotations to add or overwrite for each alert
        """
        for_: NotRequired[pulumi.Input[_builtins.str]]
        """
        Alerts are considered firing once they have been returned for this long. Alerts which have not yet fired for long enough are considered pending. Default is 0s
        """
        labels: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]
        """
        A map of key:value. Labels to add or overwrite for each alert
        """
elif False:
    ObservabilityLogalertgroupRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ObservabilityLogalertgroupRuleArgs:
    def __init__(__self__, *,
                 alert: pulumi.Input[_builtins.str],
                 expression: pulumi.Input[_builtins.str],
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 for_: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        :param pulumi.Input[_builtins.str] alert: The name of the alert rule. Is the identifier and must be unique in the group.
        :param pulumi.Input[_builtins.str] expression: The LogQL expression to evaluate. Every evaluation cycle this is evaluated at the current time, and all resultant time series become pending/firing alerts.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: A map of key:value. Annotations to add or overwrite for each alert
        :param pulumi.Input[_builtins.str] for_: Alerts are considered firing once they have been returned for this long. Alerts which have not yet fired for long enough are considered pending. Default is 0s
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A map of key:value. Labels to add or overwrite for each alert
        """
        pulumi.set(__self__, "alert", alert)
        pulumi.set(__self__, "expression", expression)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if for_ is not None:
            pulumi.set(__self__, "for_", for_)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)

    @_builtins.property
    @pulumi.getter
    def alert(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the alert rule. Is the identifier and must be unique in the group.
        """
        return pulumi.get(self, "alert")

    @alert.setter
    def alert(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "alert", value)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> pulumi.Input[_builtins.str]:
        """
        The LogQL expression to evaluate. Every evaluation cycle this is evaluated at the current time, and all resultant time series become pending/firing alerts.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "expression", value)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of key:value. Annotations to add or overwrite for each alert
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter(name="for")
    def for_(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Alerts are considered firing once they have been returned for this long. Alerts which have not yet fired for long enough are considered pending. Default is 0s
        """
        return pulumi.get(self, "for_")

    @for_.setter
    def for_(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "for_", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of key:value. Labels to add or overwrite for each alert
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)


if not MYPY:
    class ObservabilityScrapeconfigBasicAuthArgsDict(TypedDict):
        password: pulumi.Input[_builtins.str]
        """
        Specifies basic auth password.
        """
        username: pulumi.Input[_builtins.str]
        """
        Specifies basic auth username.
        """
elif False:
    ObservabilityScrapeconfigBasicAuthArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ObservabilityScrapeconfigBasicAuthArgs:
    def __init__(__self__, *,
                 password: pulumi.Input[_builtins.str],
                 username: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] password: Specifies basic auth password.
        :param pulumi.Input[_builtins.str] username: Specifies basic auth username.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies basic auth password.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies basic auth username.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "username", value)


if not MYPY:
    class ObservabilityScrapeconfigSaml2ArgsDict(TypedDict):
        enable_url_parameters: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Specifies if URL parameters are enabled. Defaults to `true`
        """
elif False:
    ObservabilityScrapeconfigSaml2ArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ObservabilityScrapeconfigSaml2Args:
    def __init__(__self__, *,
                 enable_url_parameters: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[_builtins.bool] enable_url_parameters: Specifies if URL parameters are enabled. Defaults to `true`
        """
        if enable_url_parameters is not None:
            pulumi.set(__self__, "enable_url_parameters", enable_url_parameters)

    @_builtins.property
    @pulumi.getter(name="enableUrlParameters")
    def enable_url_parameters(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if URL parameters are enabled. Defaults to `true`
        """
        return pulumi.get(self, "enable_url_parameters")

    @enable_url_parameters.setter
    def enable_url_parameters(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_url_parameters", value)


if not MYPY:
    class ObservabilityScrapeconfigTargetArgsDict(TypedDict):
        urls: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]
        """
        Specifies target URLs.
        """
        labels: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]
        """
        Specifies labels.
        """
elif False:
    ObservabilityScrapeconfigTargetArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ObservabilityScrapeconfigTargetArgs:
    def __init__(__self__, *,
                 urls: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] urls: Specifies target URLs.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Specifies labels.
        """
        pulumi.set(__self__, "urls", urls)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)

    @_builtins.property
    @pulumi.getter
    def urls(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Specifies target URLs.
        """
        return pulumi.get(self, "urls")

    @urls.setter
    def urls(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "urls", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies labels.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)


if not MYPY:
    class OpensearchInstanceParametersArgsDict(TypedDict):
        enable_monitoring: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Enable monitoring.
        """
        graphite: NotRequired[pulumi.Input[_builtins.str]]
        """
        If set, monitoring with Graphite will be enabled. Expects the host and port where the Graphite metrics should be sent to (host:port).
        """
        java_garbage_collector: NotRequired[pulumi.Input[_builtins.str]]
        """
        The garbage collector to use for OpenSearch.
        """
        java_heapspace: NotRequired[pulumi.Input[_builtins.int]]
        """
        The amount of memory (in MB) allocated as heap by the JVM for OpenSearch.
        """
        java_maxmetaspace: NotRequired[pulumi.Input[_builtins.int]]
        """
        The amount of memory (in MB) used by the JVM to store metadata for OpenSearch.
        """
        max_disk_threshold: NotRequired[pulumi.Input[_builtins.int]]
        """
        The maximum disk threshold in MB. If the disk usage exceeds this threshold, the instance will be stopped.
        """
        metrics_frequency: NotRequired[pulumi.Input[_builtins.int]]
        """
        The frequency in seconds at which metrics are emitted (in seconds).
        """
        metrics_prefix: NotRequired[pulumi.Input[_builtins.str]]
        """
        The prefix for the metrics. Could be useful when using Graphite monitoring to prefix the metrics with a certain value, like an API key.
        """
        monitoring_instance_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the STACKIT monitoring instance.
        """
        plugins: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        List of plugins to install. Must be a supported plugin name. The plugins `repository-s3` and `repository-azure` are enabled by default and cannot be disabled.
        """
        sgw_acl: NotRequired[pulumi.Input[_builtins.str]]
        """
        Comma separated list of IP networks in CIDR notation which are allowed to access this instance.
        """
        syslogs: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        List of syslog servers to send logs to.
        """
        tls_ciphers: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        List of TLS ciphers to use.
        """
        tls_protocols: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        The TLS protocol to use.
        """
elif False:
    OpensearchInstanceParametersArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OpensearchInstanceParametersArgs:
    def __init__(__self__, *,
                 enable_monitoring: Optional[pulumi.Input[_builtins.bool]] = None,
                 graphite: Optional[pulumi.Input[_builtins.str]] = None,
                 java_garbage_collector: Optional[pulumi.Input[_builtins.str]] = None,
                 java_heapspace: Optional[pulumi.Input[_builtins.int]] = None,
                 java_maxmetaspace: Optional[pulumi.Input[_builtins.int]] = None,
                 max_disk_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 metrics_frequency: Optional[pulumi.Input[_builtins.int]] = None,
                 metrics_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 monitoring_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 plugins: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sgw_acl: Optional[pulumi.Input[_builtins.str]] = None,
                 syslogs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tls_ciphers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tls_protocols: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        :param pulumi.Input[_builtins.bool] enable_monitoring: Enable monitoring.
        :param pulumi.Input[_builtins.str] graphite: If set, monitoring with Graphite will be enabled. Expects the host and port where the Graphite metrics should be sent to (host:port).
        :param pulumi.Input[_builtins.str] java_garbage_collector: The garbage collector to use for OpenSearch.
        :param pulumi.Input[_builtins.int] java_heapspace: The amount of memory (in MB) allocated as heap by the JVM for OpenSearch.
        :param pulumi.Input[_builtins.int] java_maxmetaspace: The amount of memory (in MB) used by the JVM to store metadata for OpenSearch.
        :param pulumi.Input[_builtins.int] max_disk_threshold: The maximum disk threshold in MB. If the disk usage exceeds this threshold, the instance will be stopped.
        :param pulumi.Input[_builtins.int] metrics_frequency: The frequency in seconds at which metrics are emitted (in seconds).
        :param pulumi.Input[_builtins.str] metrics_prefix: The prefix for the metrics. Could be useful when using Graphite monitoring to prefix the metrics with a certain value, like an API key.
        :param pulumi.Input[_builtins.str] monitoring_instance_id: The ID of the STACKIT monitoring instance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] plugins: List of plugins to install. Must be a supported plugin name. The plugins `repository-s3` and `repository-azure` are enabled by default and cannot be disabled.
        :param pulumi.Input[_builtins.str] sgw_acl: Comma separated list of IP networks in CIDR notation which are allowed to access this instance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] syslogs: List of syslog servers to send logs to.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tls_ciphers: List of TLS ciphers to use.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tls_protocols: The TLS protocol to use.
        """
        if enable_monitoring is not None:
            pulumi.set(__self__, "enable_monitoring", enable_monitoring)
        if graphite is not None:
            pulumi.set(__self__, "graphite", graphite)
        if java_garbage_collector is not None:
            pulumi.set(__self__, "java_garbage_collector", java_garbage_collector)
        if java_heapspace is not None:
            pulumi.set(__self__, "java_heapspace", java_heapspace)
        if java_maxmetaspace is not None:
            pulumi.set(__self__, "java_maxmetaspace", java_maxmetaspace)
        if max_disk_threshold is not None:
            pulumi.set(__self__, "max_disk_threshold", max_disk_threshold)
        if metrics_frequency is not None:
            pulumi.set(__self__, "metrics_frequency", metrics_frequency)
        if metrics_prefix is not None:
            pulumi.set(__self__, "metrics_prefix", metrics_prefix)
        if monitoring_instance_id is not None:
            pulumi.set(__self__, "monitoring_instance_id", monitoring_instance_id)
        if plugins is not None:
            pulumi.set(__self__, "plugins", plugins)
        if sgw_acl is not None:
            pulumi.set(__self__, "sgw_acl", sgw_acl)
        if syslogs is not None:
            pulumi.set(__self__, "syslogs", syslogs)
        if tls_ciphers is not None:
            pulumi.set(__self__, "tls_ciphers", tls_ciphers)
        if tls_protocols is not None:
            pulumi.set(__self__, "tls_protocols", tls_protocols)

    @_builtins.property
    @pulumi.getter(name="enableMonitoring")
    def enable_monitoring(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable monitoring.
        """
        return pulumi.get(self, "enable_monitoring")

    @enable_monitoring.setter
    def enable_monitoring(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_monitoring", value)

    @_builtins.property
    @pulumi.getter
    def graphite(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If set, monitoring with Graphite will be enabled. Expects the host and port where the Graphite metrics should be sent to (host:port).
        """
        return pulumi.get(self, "graphite")

    @graphite.setter
    def graphite(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "graphite", value)

    @_builtins.property
    @pulumi.getter(name="javaGarbageCollector")
    def java_garbage_collector(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The garbage collector to use for OpenSearch.
        """
        return pulumi.get(self, "java_garbage_collector")

    @java_garbage_collector.setter
    def java_garbage_collector(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "java_garbage_collector", value)

    @_builtins.property
    @pulumi.getter(name="javaHeapspace")
    def java_heapspace(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of memory (in MB) allocated as heap by the JVM for OpenSearch.
        """
        return pulumi.get(self, "java_heapspace")

    @java_heapspace.setter
    def java_heapspace(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "java_heapspace", value)

    @_builtins.property
    @pulumi.getter(name="javaMaxmetaspace")
    def java_maxmetaspace(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of memory (in MB) used by the JVM to store metadata for OpenSearch.
        """
        return pulumi.get(self, "java_maxmetaspace")

    @java_maxmetaspace.setter
    def java_maxmetaspace(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "java_maxmetaspace", value)

    @_builtins.property
    @pulumi.getter(name="maxDiskThreshold")
    def max_disk_threshold(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum disk threshold in MB. If the disk usage exceeds this threshold, the instance will be stopped.
        """
        return pulumi.get(self, "max_disk_threshold")

    @max_disk_threshold.setter
    def max_disk_threshold(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_disk_threshold", value)

    @_builtins.property
    @pulumi.getter(name="metricsFrequency")
    def metrics_frequency(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The frequency in seconds at which metrics are emitted (in seconds).
        """
        return pulumi.get(self, "metrics_frequency")

    @metrics_frequency.setter
    def metrics_frequency(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "metrics_frequency", value)

    @_builtins.property
    @pulumi.getter(name="metricsPrefix")
    def metrics_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The prefix for the metrics. Could be useful when using Graphite monitoring to prefix the metrics with a certain value, like an API key.
        """
        return pulumi.get(self, "metrics_prefix")

    @metrics_prefix.setter
    def metrics_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metrics_prefix", value)

    @_builtins.property
    @pulumi.getter(name="monitoringInstanceId")
    def monitoring_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the STACKIT monitoring instance.
        """
        return pulumi.get(self, "monitoring_instance_id")

    @monitoring_instance_id.setter
    def monitoring_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "monitoring_instance_id", value)

    @_builtins.property
    @pulumi.getter
    def plugins(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of plugins to install. Must be a supported plugin name. The plugins `repository-s3` and `repository-azure` are enabled by default and cannot be disabled.
        """
        return pulumi.get(self, "plugins")

    @plugins.setter
    def plugins(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "plugins", value)

    @_builtins.property
    @pulumi.getter(name="sgwAcl")
    def sgw_acl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Comma separated list of IP networks in CIDR notation which are allowed to access this instance.
        """
        return pulumi.get(self, "sgw_acl")

    @sgw_acl.setter
    def sgw_acl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sgw_acl", value)

    @_builtins.property
    @pulumi.getter
    def syslogs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of syslog servers to send logs to.
        """
        return pulumi.get(self, "syslogs")

    @syslogs.setter
    def syslogs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "syslogs", value)

    @_builtins.property
    @pulumi.getter(name="tlsCiphers")
    def tls_ciphers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of TLS ciphers to use.
        """
        return pulumi.get(self, "tls_ciphers")

    @tls_ciphers.setter
    def tls_ciphers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tls_ciphers", value)

    @_builtins.property
    @pulumi.getter(name="tlsProtocols")
    def tls_protocols(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The TLS protocol to use.
        """
        return pulumi.get(self, "tls_protocols")

    @tls_protocols.setter
    def tls_protocols(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tls_protocols", value)


if not MYPY:
    class PostgresflexInstanceFlavorArgsDict(TypedDict):
        cpu: pulumi.Input[_builtins.int]
        ram: pulumi.Input[_builtins.int]
        description: NotRequired[pulumi.Input[_builtins.str]]
        id: NotRequired[pulumi.Input[_builtins.str]]
elif False:
    PostgresflexInstanceFlavorArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PostgresflexInstanceFlavorArgs:
    def __init__(__self__, *,
                 cpu: pulumi.Input[_builtins.int],
                 ram: pulumi.Input[_builtins.int],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 id: Optional[pulumi.Input[_builtins.str]] = None):
        pulumi.set(__self__, "cpu", cpu)
        pulumi.set(__self__, "ram", ram)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> pulumi.Input[_builtins.int]:
        return pulumi.get(self, "cpu")

    @cpu.setter
    def cpu(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "cpu", value)

    @_builtins.property
    @pulumi.getter
    def ram(self) -> pulumi.Input[_builtins.int]:
        return pulumi.get(self, "ram")

    @ram.setter
    def ram(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "ram", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "id", value)


if not MYPY:
    class PostgresflexInstanceStorageArgsDict(TypedDict):
        class_: pulumi.Input[_builtins.str]
        size: pulumi.Input[_builtins.int]
elif False:
    PostgresflexInstanceStorageArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PostgresflexInstanceStorageArgs:
    def __init__(__self__, *,
                 class_: pulumi.Input[_builtins.str],
                 size: pulumi.Input[_builtins.int]):
        pulumi.set(__self__, "class_", class_)
        pulumi.set(__self__, "size", size)

    @_builtins.property
    @pulumi.getter(name="class")
    def class_(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "class_")

    @class_.setter
    def class_(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "class_", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> pulumi.Input[_builtins.int]:
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "size", value)


if not MYPY:
    class RabbitmqInstanceParametersArgsDict(TypedDict):
        consumer_timeout: NotRequired[pulumi.Input[_builtins.int]]
        """
        The timeout in milliseconds for the consumer.
        """
        enable_monitoring: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Enable monitoring.
        """
        graphite: NotRequired[pulumi.Input[_builtins.str]]
        """
        Graphite server URL (host and port). If set, monitoring with Graphite will be enabled.
        """
        max_disk_threshold: NotRequired[pulumi.Input[_builtins.int]]
        """
        The maximum disk threshold in MB. If the disk usage exceeds this threshold, the instance will be stopped.
        """
        metrics_frequency: NotRequired[pulumi.Input[_builtins.int]]
        """
        The frequency in seconds at which metrics are emitted.
        """
        metrics_prefix: NotRequired[pulumi.Input[_builtins.str]]
        """
        The prefix for the metrics. Could be useful when using Graphite monitoring to prefix the metrics with a certain value, like an API key
        """
        monitoring_instance_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the STACKIT monitoring instance.
        """
        plugins: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        List of plugins to install. Must be a supported plugin name.
        """
        roles: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        List of roles to assign to the instance.
        """
        sgw_acl: NotRequired[pulumi.Input[_builtins.str]]
        """
        Comma separated list of IP networks in CIDR notation which are allowed to access this instance.
        """
        syslogs: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        List of syslog servers to send logs to.
        """
        tls_ciphers: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        List of TLS ciphers to use.
        """
        tls_protocols: NotRequired[pulumi.Input[_builtins.str]]
        """
        TLS protocol to use.
        """
elif False:
    RabbitmqInstanceParametersArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RabbitmqInstanceParametersArgs:
    def __init__(__self__, *,
                 consumer_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 enable_monitoring: Optional[pulumi.Input[_builtins.bool]] = None,
                 graphite: Optional[pulumi.Input[_builtins.str]] = None,
                 max_disk_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 metrics_frequency: Optional[pulumi.Input[_builtins.int]] = None,
                 metrics_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 monitoring_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 plugins: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sgw_acl: Optional[pulumi.Input[_builtins.str]] = None,
                 syslogs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tls_ciphers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tls_protocols: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.int] consumer_timeout: The timeout in milliseconds for the consumer.
        :param pulumi.Input[_builtins.bool] enable_monitoring: Enable monitoring.
        :param pulumi.Input[_builtins.str] graphite: Graphite server URL (host and port). If set, monitoring with Graphite will be enabled.
        :param pulumi.Input[_builtins.int] max_disk_threshold: The maximum disk threshold in MB. If the disk usage exceeds this threshold, the instance will be stopped.
        :param pulumi.Input[_builtins.int] metrics_frequency: The frequency in seconds at which metrics are emitted.
        :param pulumi.Input[_builtins.str] metrics_prefix: The prefix for the metrics. Could be useful when using Graphite monitoring to prefix the metrics with a certain value, like an API key
        :param pulumi.Input[_builtins.str] monitoring_instance_id: The ID of the STACKIT monitoring instance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] plugins: List of plugins to install. Must be a supported plugin name.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] roles: List of roles to assign to the instance.
        :param pulumi.Input[_builtins.str] sgw_acl: Comma separated list of IP networks in CIDR notation which are allowed to access this instance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] syslogs: List of syslog servers to send logs to.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tls_ciphers: List of TLS ciphers to use.
        :param pulumi.Input[_builtins.str] tls_protocols: TLS protocol to use.
        """
        if consumer_timeout is not None:
            pulumi.set(__self__, "consumer_timeout", consumer_timeout)
        if enable_monitoring is not None:
            pulumi.set(__self__, "enable_monitoring", enable_monitoring)
        if graphite is not None:
            pulumi.set(__self__, "graphite", graphite)
        if max_disk_threshold is not None:
            pulumi.set(__self__, "max_disk_threshold", max_disk_threshold)
        if metrics_frequency is not None:
            pulumi.set(__self__, "metrics_frequency", metrics_frequency)
        if metrics_prefix is not None:
            pulumi.set(__self__, "metrics_prefix", metrics_prefix)
        if monitoring_instance_id is not None:
            pulumi.set(__self__, "monitoring_instance_id", monitoring_instance_id)
        if plugins is not None:
            pulumi.set(__self__, "plugins", plugins)
        if roles is not None:
            pulumi.set(__self__, "roles", roles)
        if sgw_acl is not None:
            pulumi.set(__self__, "sgw_acl", sgw_acl)
        if syslogs is not None:
            pulumi.set(__self__, "syslogs", syslogs)
        if tls_ciphers is not None:
            pulumi.set(__self__, "tls_ciphers", tls_ciphers)
        if tls_protocols is not None:
            pulumi.set(__self__, "tls_protocols", tls_protocols)

    @_builtins.property
    @pulumi.getter(name="consumerTimeout")
    def consumer_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The timeout in milliseconds for the consumer.
        """
        return pulumi.get(self, "consumer_timeout")

    @consumer_timeout.setter
    def consumer_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "consumer_timeout", value)

    @_builtins.property
    @pulumi.getter(name="enableMonitoring")
    def enable_monitoring(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable monitoring.
        """
        return pulumi.get(self, "enable_monitoring")

    @enable_monitoring.setter
    def enable_monitoring(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_monitoring", value)

    @_builtins.property
    @pulumi.getter
    def graphite(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Graphite server URL (host and port). If set, monitoring with Graphite will be enabled.
        """
        return pulumi.get(self, "graphite")

    @graphite.setter
    def graphite(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "graphite", value)

    @_builtins.property
    @pulumi.getter(name="maxDiskThreshold")
    def max_disk_threshold(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum disk threshold in MB. If the disk usage exceeds this threshold, the instance will be stopped.
        """
        return pulumi.get(self, "max_disk_threshold")

    @max_disk_threshold.setter
    def max_disk_threshold(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_disk_threshold", value)

    @_builtins.property
    @pulumi.getter(name="metricsFrequency")
    def metrics_frequency(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The frequency in seconds at which metrics are emitted.
        """
        return pulumi.get(self, "metrics_frequency")

    @metrics_frequency.setter
    def metrics_frequency(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "metrics_frequency", value)

    @_builtins.property
    @pulumi.getter(name="metricsPrefix")
    def metrics_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The prefix for the metrics. Could be useful when using Graphite monitoring to prefix the metrics with a certain value, like an API key
        """
        return pulumi.get(self, "metrics_prefix")

    @metrics_prefix.setter
    def metrics_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metrics_prefix", value)

    @_builtins.property
    @pulumi.getter(name="monitoringInstanceId")
    def monitoring_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the STACKIT monitoring instance.
        """
        return pulumi.get(self, "monitoring_instance_id")

    @monitoring_instance_id.setter
    def monitoring_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "monitoring_instance_id", value)

    @_builtins.property
    @pulumi.getter
    def plugins(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of plugins to install. Must be a supported plugin name.
        """
        return pulumi.get(self, "plugins")

    @plugins.setter
    def plugins(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "plugins", value)

    @_builtins.property
    @pulumi.getter
    def roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of roles to assign to the instance.
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "roles", value)

    @_builtins.property
    @pulumi.getter(name="sgwAcl")
    def sgw_acl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Comma separated list of IP networks in CIDR notation which are allowed to access this instance.
        """
        return pulumi.get(self, "sgw_acl")

    @sgw_acl.setter
    def sgw_acl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sgw_acl", value)

    @_builtins.property
    @pulumi.getter
    def syslogs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of syslog servers to send logs to.
        """
        return pulumi.get(self, "syslogs")

    @syslogs.setter
    def syslogs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "syslogs", value)

    @_builtins.property
    @pulumi.getter(name="tlsCiphers")
    def tls_ciphers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of TLS ciphers to use.
        """
        return pulumi.get(self, "tls_ciphers")

    @tls_ciphers.setter
    def tls_ciphers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tls_ciphers", value)

    @_builtins.property
    @pulumi.getter(name="tlsProtocols")
    def tls_protocols(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        TLS protocol to use.
        """
        return pulumi.get(self, "tls_protocols")

    @tls_protocols.setter
    def tls_protocols(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tls_protocols", value)


if not MYPY:
    class RedisInstanceParametersArgsDict(TypedDict):
        down_after_milliseconds: NotRequired[pulumi.Input[_builtins.int]]
        """
        The number of milliseconds after which the instance is considered down.
        """
        enable_monitoring: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Enable monitoring.
        """
        failover_timeout: NotRequired[pulumi.Input[_builtins.int]]
        """
        The failover timeout in milliseconds.
        """
        graphite: NotRequired[pulumi.Input[_builtins.str]]
        """
        Graphite server URL (host and port). If set, monitoring with Graphite will be enabled.
        """
        lazyfree_lazy_eviction: NotRequired[pulumi.Input[_builtins.str]]
        """
        The lazy eviction enablement (yes or no).
        """
        lazyfree_lazy_expire: NotRequired[pulumi.Input[_builtins.str]]
        """
        The lazy expire enablement (yes or no).
        """
        lua_time_limit: NotRequired[pulumi.Input[_builtins.int]]
        """
        The Lua time limit.
        """
        max_disk_threshold: NotRequired[pulumi.Input[_builtins.int]]
        """
        The maximum disk threshold in MB. If the disk usage exceeds this threshold, the instance will be stopped.
        """
        maxclients: NotRequired[pulumi.Input[_builtins.int]]
        """
        The maximum number of clients.
        """
        maxmemory_policy: NotRequired[pulumi.Input[_builtins.str]]
        """
        The policy to handle the maximum memory (volatile-lru, noeviction, etc).
        """
        maxmemory_samples: NotRequired[pulumi.Input[_builtins.int]]
        """
        The maximum memory samples.
        """
        metrics_frequency: NotRequired[pulumi.Input[_builtins.int]]
        """
        The frequency in seconds at which metrics are emitted.
        """
        metrics_prefix: NotRequired[pulumi.Input[_builtins.str]]
        """
        The prefix for the metrics. Could be useful when using Graphite monitoring to prefix the metrics with a certain value, like an API key
        """
        min_replicas_max_lag: NotRequired[pulumi.Input[_builtins.int]]
        """
        The minimum replicas maximum lag.
        """
        monitoring_instance_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the STACKIT monitoring instance.
        """
        notify_keyspace_events: NotRequired[pulumi.Input[_builtins.str]]
        """
        The notify keyspace events.
        """
        sgw_acl: NotRequired[pulumi.Input[_builtins.str]]
        """
        Comma separated list of IP networks in CIDR notation which are allowed to access this instance.
        """
        snapshot: NotRequired[pulumi.Input[_builtins.str]]
        """
        The snapshot configuration.
        """
        syslogs: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        List of syslog servers to send logs to.
        """
        tls_ciphers: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        List of TLS ciphers to use.
        """
        tls_ciphersuites: NotRequired[pulumi.Input[_builtins.str]]
        """
        TLS cipher suites to use.
        """
        tls_protocols: NotRequired[pulumi.Input[_builtins.str]]
        """
        TLS protocol to use.
        """
elif False:
    RedisInstanceParametersArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RedisInstanceParametersArgs:
    def __init__(__self__, *,
                 down_after_milliseconds: Optional[pulumi.Input[_builtins.int]] = None,
                 enable_monitoring: Optional[pulumi.Input[_builtins.bool]] = None,
                 failover_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 graphite: Optional[pulumi.Input[_builtins.str]] = None,
                 lazyfree_lazy_eviction: Optional[pulumi.Input[_builtins.str]] = None,
                 lazyfree_lazy_expire: Optional[pulumi.Input[_builtins.str]] = None,
                 lua_time_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 max_disk_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 maxclients: Optional[pulumi.Input[_builtins.int]] = None,
                 maxmemory_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 maxmemory_samples: Optional[pulumi.Input[_builtins.int]] = None,
                 metrics_frequency: Optional[pulumi.Input[_builtins.int]] = None,
                 metrics_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 min_replicas_max_lag: Optional[pulumi.Input[_builtins.int]] = None,
                 monitoring_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 notify_keyspace_events: Optional[pulumi.Input[_builtins.str]] = None,
                 sgw_acl: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot: Optional[pulumi.Input[_builtins.str]] = None,
                 syslogs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tls_ciphers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tls_ciphersuites: Optional[pulumi.Input[_builtins.str]] = None,
                 tls_protocols: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.int] down_after_milliseconds: The number of milliseconds after which the instance is considered down.
        :param pulumi.Input[_builtins.bool] enable_monitoring: Enable monitoring.
        :param pulumi.Input[_builtins.int] failover_timeout: The failover timeout in milliseconds.
        :param pulumi.Input[_builtins.str] graphite: Graphite server URL (host and port). If set, monitoring with Graphite will be enabled.
        :param pulumi.Input[_builtins.str] lazyfree_lazy_eviction: The lazy eviction enablement (yes or no).
        :param pulumi.Input[_builtins.str] lazyfree_lazy_expire: The lazy expire enablement (yes or no).
        :param pulumi.Input[_builtins.int] lua_time_limit: The Lua time limit.
        :param pulumi.Input[_builtins.int] max_disk_threshold: The maximum disk threshold in MB. If the disk usage exceeds this threshold, the instance will be stopped.
        :param pulumi.Input[_builtins.int] maxclients: The maximum number of clients.
        :param pulumi.Input[_builtins.str] maxmemory_policy: The policy to handle the maximum memory (volatile-lru, noeviction, etc).
        :param pulumi.Input[_builtins.int] maxmemory_samples: The maximum memory samples.
        :param pulumi.Input[_builtins.int] metrics_frequency: The frequency in seconds at which metrics are emitted.
        :param pulumi.Input[_builtins.str] metrics_prefix: The prefix for the metrics. Could be useful when using Graphite monitoring to prefix the metrics with a certain value, like an API key
        :param pulumi.Input[_builtins.int] min_replicas_max_lag: The minimum replicas maximum lag.
        :param pulumi.Input[_builtins.str] monitoring_instance_id: The ID of the STACKIT monitoring instance.
        :param pulumi.Input[_builtins.str] notify_keyspace_events: The notify keyspace events.
        :param pulumi.Input[_builtins.str] sgw_acl: Comma separated list of IP networks in CIDR notation which are allowed to access this instance.
        :param pulumi.Input[_builtins.str] snapshot: The snapshot configuration.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] syslogs: List of syslog servers to send logs to.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tls_ciphers: List of TLS ciphers to use.
        :param pulumi.Input[_builtins.str] tls_ciphersuites: TLS cipher suites to use.
        :param pulumi.Input[_builtins.str] tls_protocols: TLS protocol to use.
        """
        if down_after_milliseconds is not None:
            pulumi.set(__self__, "down_after_milliseconds", down_after_milliseconds)
        if enable_monitoring is not None:
            pulumi.set(__self__, "enable_monitoring", enable_monitoring)
        if failover_timeout is not None:
            pulumi.set(__self__, "failover_timeout", failover_timeout)
        if graphite is not None:
            pulumi.set(__self__, "graphite", graphite)
        if lazyfree_lazy_eviction is not None:
            pulumi.set(__self__, "lazyfree_lazy_eviction", lazyfree_lazy_eviction)
        if lazyfree_lazy_expire is not None:
            pulumi.set(__self__, "lazyfree_lazy_expire", lazyfree_lazy_expire)
        if lua_time_limit is not None:
            pulumi.set(__self__, "lua_time_limit", lua_time_limit)
        if max_disk_threshold is not None:
            pulumi.set(__self__, "max_disk_threshold", max_disk_threshold)
        if maxclients is not None:
            pulumi.set(__self__, "maxclients", maxclients)
        if maxmemory_policy is not None:
            pulumi.set(__self__, "maxmemory_policy", maxmemory_policy)
        if maxmemory_samples is not None:
            pulumi.set(__self__, "maxmemory_samples", maxmemory_samples)
        if metrics_frequency is not None:
            pulumi.set(__self__, "metrics_frequency", metrics_frequency)
        if metrics_prefix is not None:
            pulumi.set(__self__, "metrics_prefix", metrics_prefix)
        if min_replicas_max_lag is not None:
            pulumi.set(__self__, "min_replicas_max_lag", min_replicas_max_lag)
        if monitoring_instance_id is not None:
            pulumi.set(__self__, "monitoring_instance_id", monitoring_instance_id)
        if notify_keyspace_events is not None:
            pulumi.set(__self__, "notify_keyspace_events", notify_keyspace_events)
        if sgw_acl is not None:
            pulumi.set(__self__, "sgw_acl", sgw_acl)
        if snapshot is not None:
            pulumi.set(__self__, "snapshot", snapshot)
        if syslogs is not None:
            pulumi.set(__self__, "syslogs", syslogs)
        if tls_ciphers is not None:
            pulumi.set(__self__, "tls_ciphers", tls_ciphers)
        if tls_ciphersuites is not None:
            pulumi.set(__self__, "tls_ciphersuites", tls_ciphersuites)
        if tls_protocols is not None:
            pulumi.set(__self__, "tls_protocols", tls_protocols)

    @_builtins.property
    @pulumi.getter(name="downAfterMilliseconds")
    def down_after_milliseconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of milliseconds after which the instance is considered down.
        """
        return pulumi.get(self, "down_after_milliseconds")

    @down_after_milliseconds.setter
    def down_after_milliseconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "down_after_milliseconds", value)

    @_builtins.property
    @pulumi.getter(name="enableMonitoring")
    def enable_monitoring(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable monitoring.
        """
        return pulumi.get(self, "enable_monitoring")

    @enable_monitoring.setter
    def enable_monitoring(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_monitoring", value)

    @_builtins.property
    @pulumi.getter(name="failoverTimeout")
    def failover_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The failover timeout in milliseconds.
        """
        return pulumi.get(self, "failover_timeout")

    @failover_timeout.setter
    def failover_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "failover_timeout", value)

    @_builtins.property
    @pulumi.getter
    def graphite(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Graphite server URL (host and port). If set, monitoring with Graphite will be enabled.
        """
        return pulumi.get(self, "graphite")

    @graphite.setter
    def graphite(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "graphite", value)

    @_builtins.property
    @pulumi.getter(name="lazyfreeLazyEviction")
    def lazyfree_lazy_eviction(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The lazy eviction enablement (yes or no).
        """
        return pulumi.get(self, "lazyfree_lazy_eviction")

    @lazyfree_lazy_eviction.setter
    def lazyfree_lazy_eviction(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lazyfree_lazy_eviction", value)

    @_builtins.property
    @pulumi.getter(name="lazyfreeLazyExpire")
    def lazyfree_lazy_expire(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The lazy expire enablement (yes or no).
        """
        return pulumi.get(self, "lazyfree_lazy_expire")

    @lazyfree_lazy_expire.setter
    def lazyfree_lazy_expire(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lazyfree_lazy_expire", value)

    @_builtins.property
    @pulumi.getter(name="luaTimeLimit")
    def lua_time_limit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The Lua time limit.
        """
        return pulumi.get(self, "lua_time_limit")

    @lua_time_limit.setter
    def lua_time_limit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "lua_time_limit", value)

    @_builtins.property
    @pulumi.getter(name="maxDiskThreshold")
    def max_disk_threshold(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum disk threshold in MB. If the disk usage exceeds this threshold, the instance will be stopped.
        """
        return pulumi.get(self, "max_disk_threshold")

    @max_disk_threshold.setter
    def max_disk_threshold(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_disk_threshold", value)

    @_builtins.property
    @pulumi.getter
    def maxclients(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of clients.
        """
        return pulumi.get(self, "maxclients")

    @maxclients.setter
    def maxclients(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "maxclients", value)

    @_builtins.property
    @pulumi.getter(name="maxmemoryPolicy")
    def maxmemory_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The policy to handle the maximum memory (volatile-lru, noeviction, etc).
        """
        return pulumi.get(self, "maxmemory_policy")

    @maxmemory_policy.setter
    def maxmemory_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maxmemory_policy", value)

    @_builtins.property
    @pulumi.getter(name="maxmemorySamples")
    def maxmemory_samples(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum memory samples.
        """
        return pulumi.get(self, "maxmemory_samples")

    @maxmemory_samples.setter
    def maxmemory_samples(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "maxmemory_samples", value)

    @_builtins.property
    @pulumi.getter(name="metricsFrequency")
    def metrics_frequency(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The frequency in seconds at which metrics are emitted.
        """
        return pulumi.get(self, "metrics_frequency")

    @metrics_frequency.setter
    def metrics_frequency(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "metrics_frequency", value)

    @_builtins.property
    @pulumi.getter(name="metricsPrefix")
    def metrics_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The prefix for the metrics. Could be useful when using Graphite monitoring to prefix the metrics with a certain value, like an API key
        """
        return pulumi.get(self, "metrics_prefix")

    @metrics_prefix.setter
    def metrics_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metrics_prefix", value)

    @_builtins.property
    @pulumi.getter(name="minReplicasMaxLag")
    def min_replicas_max_lag(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The minimum replicas maximum lag.
        """
        return pulumi.get(self, "min_replicas_max_lag")

    @min_replicas_max_lag.setter
    def min_replicas_max_lag(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_replicas_max_lag", value)

    @_builtins.property
    @pulumi.getter(name="monitoringInstanceId")
    def monitoring_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the STACKIT monitoring instance.
        """
        return pulumi.get(self, "monitoring_instance_id")

    @monitoring_instance_id.setter
    def monitoring_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "monitoring_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="notifyKeyspaceEvents")
    def notify_keyspace_events(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The notify keyspace events.
        """
        return pulumi.get(self, "notify_keyspace_events")

    @notify_keyspace_events.setter
    def notify_keyspace_events(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "notify_keyspace_events", value)

    @_builtins.property
    @pulumi.getter(name="sgwAcl")
    def sgw_acl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Comma separated list of IP networks in CIDR notation which are allowed to access this instance.
        """
        return pulumi.get(self, "sgw_acl")

    @sgw_acl.setter
    def sgw_acl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sgw_acl", value)

    @_builtins.property
    @pulumi.getter
    def snapshot(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The snapshot configuration.
        """
        return pulumi.get(self, "snapshot")

    @snapshot.setter
    def snapshot(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snapshot", value)

    @_builtins.property
    @pulumi.getter
    def syslogs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of syslog servers to send logs to.
        """
        return pulumi.get(self, "syslogs")

    @syslogs.setter
    def syslogs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "syslogs", value)

    @_builtins.property
    @pulumi.getter(name="tlsCiphers")
    def tls_ciphers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of TLS ciphers to use.
        """
        return pulumi.get(self, "tls_ciphers")

    @tls_ciphers.setter
    def tls_ciphers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tls_ciphers", value)

    @_builtins.property
    @pulumi.getter(name="tlsCiphersuites")
    def tls_ciphersuites(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        TLS cipher suites to use.
        """
        return pulumi.get(self, "tls_ciphersuites")

    @tls_ciphersuites.setter
    def tls_ciphersuites(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tls_ciphersuites", value)

    @_builtins.property
    @pulumi.getter(name="tlsProtocols")
    def tls_protocols(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        TLS protocol to use.
        """
        return pulumi.get(self, "tls_protocols")

    @tls_protocols.setter
    def tls_protocols(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tls_protocols", value)


if not MYPY:
    class RoutingTableRouteDestinationArgsDict(TypedDict):
        type: pulumi.Input[_builtins.str]
        """
        CIDRV type. Possible values are: `cidrv4`, `cidrv6`. Only `cidrv4` is supported during experimental stage.
        """
        value: pulumi.Input[_builtins.str]
        """
        An CIDR string.
        """
elif False:
    RoutingTableRouteDestinationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RoutingTableRouteDestinationArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[_builtins.str],
                 value: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] type: CIDRV type. Possible values are: `cidrv4`, `cidrv6`. Only `cidrv4` is supported during experimental stage.
        :param pulumi.Input[_builtins.str] value: An CIDR string.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        CIDRV type. Possible values are: `cidrv4`, `cidrv6`. Only `cidrv4` is supported during experimental stage.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Input[_builtins.str]:
        """
        An CIDR string.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class RoutingTableRouteNextHopArgsDict(TypedDict):
        type: pulumi.Input[_builtins.str]
        """
        Possible values are: `blackhole`, `internet`, `ipv4`, `ipv6`. Only `cidrv4` is supported during experimental stage..
        """
        value: NotRequired[pulumi.Input[_builtins.str]]
        """
        Either IPv4 or IPv6 (not set for blackhole and internet). Only IPv4 supported during experimental stage.
        """
elif False:
    RoutingTableRouteNextHopArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RoutingTableRouteNextHopArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[_builtins.str],
                 value: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] type: Possible values are: `blackhole`, `internet`, `ipv4`, `ipv6`. Only `cidrv4` is supported during experimental stage..
        :param pulumi.Input[_builtins.str] value: Either IPv4 or IPv6 (not set for blackhole and internet). Only IPv4 supported during experimental stage.
        """
        pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Possible values are: `blackhole`, `internet`, `ipv4`, `ipv6`. Only `cidrv4` is supported during experimental stage..
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Either IPv4 or IPv6 (not set for blackhole and internet). Only IPv4 supported during experimental stage.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "value", value)


if not MYPY:
    class SecurityGroupRuleIcmpParametersArgsDict(TypedDict):
        code: pulumi.Input[_builtins.int]
        """
        ICMP code. Can be set if the protocol is ICMP.
        """
        type: pulumi.Input[_builtins.int]
        """
        ICMP type. Can be set if the protocol is ICMP.
        """
elif False:
    SecurityGroupRuleIcmpParametersArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SecurityGroupRuleIcmpParametersArgs:
    def __init__(__self__, *,
                 code: pulumi.Input[_builtins.int],
                 type: pulumi.Input[_builtins.int]):
        """
        :param pulumi.Input[_builtins.int] code: ICMP code. Can be set if the protocol is ICMP.
        :param pulumi.Input[_builtins.int] type: ICMP type. Can be set if the protocol is ICMP.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def code(self) -> pulumi.Input[_builtins.int]:
        """
        ICMP code. Can be set if the protocol is ICMP.
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "code", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.int]:
        """
        ICMP type. Can be set if the protocol is ICMP.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "type", value)


if not MYPY:
    class SecurityGroupRulePortRangeArgsDict(TypedDict):
        max: pulumi.Input[_builtins.int]
        """
        The maximum port number. Should be greater or equal to the minimum.
        """
        min: pulumi.Input[_builtins.int]
        """
        The minimum port number. Should be less or equal to the maximum.
        """
elif False:
    SecurityGroupRulePortRangeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SecurityGroupRulePortRangeArgs:
    def __init__(__self__, *,
                 max: pulumi.Input[_builtins.int],
                 min: pulumi.Input[_builtins.int]):
        """
        :param pulumi.Input[_builtins.int] max: The maximum port number. Should be greater or equal to the minimum.
        :param pulumi.Input[_builtins.int] min: The minimum port number. Should be less or equal to the maximum.
        """
        pulumi.set(__self__, "max", max)
        pulumi.set(__self__, "min", min)

    @_builtins.property
    @pulumi.getter
    def max(self) -> pulumi.Input[_builtins.int]:
        """
        The maximum port number. Should be greater or equal to the minimum.
        """
        return pulumi.get(self, "max")

    @max.setter
    def max(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "max", value)

    @_builtins.property
    @pulumi.getter
    def min(self) -> pulumi.Input[_builtins.int]:
        """
        The minimum port number. Should be less or equal to the maximum.
        """
        return pulumi.get(self, "min")

    @min.setter
    def min(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "min", value)


if not MYPY:
    class SecurityGroupRuleProtocolArgsDict(TypedDict):
        name: NotRequired[pulumi.Input[_builtins.str]]
        """
        The protocol name which the rule should match. Either `name` or `number` must be provided. Possible values are: `ah`, `dccp`, `egp`, `esp`, `gre`, `icmp`, `igmp`, `ipip`, `ipv6-encap`, `ipv6-frag`, `ipv6-icmp`, `ipv6-nonxt`, `ipv6-opts`, `ipv6-route`, `ospf`, `pgm`, `rsvp`, `sctp`, `tcp`, `udp`, `udplite`, `vrrp`.
        """
        number: NotRequired[pulumi.Input[_builtins.int]]
        """
        The protocol number which the rule should match. Either `name` or `number` must be provided.
        """
elif False:
    SecurityGroupRuleProtocolArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SecurityGroupRuleProtocolArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 number: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.str] name: The protocol name which the rule should match. Either `name` or `number` must be provided. Possible values are: `ah`, `dccp`, `egp`, `esp`, `gre`, `icmp`, `igmp`, `ipip`, `ipv6-encap`, `ipv6-frag`, `ipv6-icmp`, `ipv6-nonxt`, `ipv6-opts`, `ipv6-route`, `ospf`, `pgm`, `rsvp`, `sctp`, `tcp`, `udp`, `udplite`, `vrrp`.
        :param pulumi.Input[_builtins.int] number: The protocol number which the rule should match. Either `name` or `number` must be provided.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if number is not None:
            pulumi.set(__self__, "number", number)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The protocol name which the rule should match. Either `name` or `number` must be provided. Possible values are: `ah`, `dccp`, `egp`, `esp`, `gre`, `icmp`, `igmp`, `ipip`, `ipv6-encap`, `ipv6-frag`, `ipv6-icmp`, `ipv6-nonxt`, `ipv6-opts`, `ipv6-route`, `ospf`, `pgm`, `rsvp`, `sctp`, `tcp`, `udp`, `udplite`, `vrrp`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def number(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The protocol number which the rule should match. Either `name` or `number` must be provided.
        """
        return pulumi.get(self, "number")

    @number.setter
    def number(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "number", value)


if not MYPY:
    class ServerBackupScheduleBackupPropertiesArgsDict(TypedDict):
        name: pulumi.Input[_builtins.str]
        retention_period: pulumi.Input[_builtins.int]
        volume_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
elif False:
    ServerBackupScheduleBackupPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServerBackupScheduleBackupPropertiesArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 retention_period: pulumi.Input[_builtins.int],
                 volume_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "retention_period", retention_period)
        if volume_ids is not None:
            pulumi.set(__self__, "volume_ids", volume_ids)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="retentionPeriod")
    def retention_period(self) -> pulumi.Input[_builtins.int]:
        return pulumi.get(self, "retention_period")

    @retention_period.setter
    def retention_period(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "retention_period", value)

    @_builtins.property
    @pulumi.getter(name="volumeIds")
    def volume_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "volume_ids")

    @volume_ids.setter
    def volume_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "volume_ids", value)


if not MYPY:
    class ServerBootVolumeArgsDict(TypedDict):
        source_id: pulumi.Input[_builtins.str]
        """
        The ID of the source, either image ID or volume ID
        """
        source_type: pulumi.Input[_builtins.str]
        """
        The type of the source. Supported values are: `volume`, `image`.
        """
        delete_on_termination: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Delete the volume during the termination of the server. Only allowed when `source_type` is `image`.
        """
        id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the boot volume
        """
        performance_class: NotRequired[pulumi.Input[_builtins.str]]
        """
        The performance class of the server.
        """
        size: NotRequired[pulumi.Input[_builtins.int]]
        """
        The size of the boot volume in GB. Must be provided when `source_type` is `image`.
        """
elif False:
    ServerBootVolumeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServerBootVolumeArgs:
    def __init__(__self__, *,
                 source_id: pulumi.Input[_builtins.str],
                 source_type: pulumi.Input[_builtins.str],
                 delete_on_termination: Optional[pulumi.Input[_builtins.bool]] = None,
                 id: Optional[pulumi.Input[_builtins.str]] = None,
                 performance_class: Optional[pulumi.Input[_builtins.str]] = None,
                 size: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.str] source_id: The ID of the source, either image ID or volume ID
        :param pulumi.Input[_builtins.str] source_type: The type of the source. Supported values are: `volume`, `image`.
        :param pulumi.Input[_builtins.bool] delete_on_termination: Delete the volume during the termination of the server. Only allowed when `source_type` is `image`.
        :param pulumi.Input[_builtins.str] id: The ID of the boot volume
        :param pulumi.Input[_builtins.str] performance_class: The performance class of the server.
        :param pulumi.Input[_builtins.int] size: The size of the boot volume in GB. Must be provided when `source_type` is `image`.
        """
        pulumi.set(__self__, "source_id", source_id)
        pulumi.set(__self__, "source_type", source_type)
        if delete_on_termination is not None:
            pulumi.set(__self__, "delete_on_termination", delete_on_termination)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if performance_class is not None:
            pulumi.set(__self__, "performance_class", performance_class)
        if size is not None:
            pulumi.set(__self__, "size", size)

    @_builtins.property
    @pulumi.getter(name="sourceId")
    def source_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the source, either image ID or volume ID
        """
        return pulumi.get(self, "source_id")

    @source_id.setter
    def source_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "source_id", value)

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the source. Supported values are: `volume`, `image`.
        """
        return pulumi.get(self, "source_type")

    @source_type.setter
    def source_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "source_type", value)

    @_builtins.property
    @pulumi.getter(name="deleteOnTermination")
    def delete_on_termination(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Delete the volume during the termination of the server. Only allowed when `source_type` is `image`.
        """
        return pulumi.get(self, "delete_on_termination")

    @delete_on_termination.setter
    def delete_on_termination(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_on_termination", value)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the boot volume
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "id", value)

    @_builtins.property
    @pulumi.getter(name="performanceClass")
    def performance_class(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The performance class of the server.
        """
        return pulumi.get(self, "performance_class")

    @performance_class.setter
    def performance_class(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "performance_class", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The size of the boot volume in GB. Must be provided when `source_type` is `image`.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "size", value)


if not MYPY:
    class SkeClusterExtensionsArgsDict(TypedDict):
        acl: NotRequired[pulumi.Input['SkeClusterExtensionsAclArgsDict']]
        """
        Cluster access control configuration.
        """
        argus: NotRequired[pulumi.Input['SkeClusterExtensionsArgusArgsDict']]
        """
        A single argus block as defined below. This field is deprecated and will be removed 06 January 2026.
        """
        dns: NotRequired[pulumi.Input['SkeClusterExtensionsDnsArgsDict']]
        """
        DNS extension configuration
        """
        observability: NotRequired[pulumi.Input['SkeClusterExtensionsObservabilityArgsDict']]
        """
        A single observability block as defined below.
        """
elif False:
    SkeClusterExtensionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SkeClusterExtensionsArgs:
    def __init__(__self__, *,
                 acl: Optional[pulumi.Input['SkeClusterExtensionsAclArgs']] = None,
                 argus: Optional[pulumi.Input['SkeClusterExtensionsArgusArgs']] = None,
                 dns: Optional[pulumi.Input['SkeClusterExtensionsDnsArgs']] = None,
                 observability: Optional[pulumi.Input['SkeClusterExtensionsObservabilityArgs']] = None):
        """
        :param pulumi.Input['SkeClusterExtensionsAclArgs'] acl: Cluster access control configuration.
        :param pulumi.Input['SkeClusterExtensionsArgusArgs'] argus: A single argus block as defined below. This field is deprecated and will be removed 06 January 2026.
        :param pulumi.Input['SkeClusterExtensionsDnsArgs'] dns: DNS extension configuration
        :param pulumi.Input['SkeClusterExtensionsObservabilityArgs'] observability: A single observability block as defined below.
        """
        if acl is not None:
            pulumi.set(__self__, "acl", acl)
        if argus is not None:
            warnings.warn("""Use observability instead.""", DeprecationWarning)
            pulumi.log.warn("""argus is deprecated: Use observability instead.""")
        if argus is not None:
            pulumi.set(__self__, "argus", argus)
        if dns is not None:
            pulumi.set(__self__, "dns", dns)
        if observability is not None:
            pulumi.set(__self__, "observability", observability)

    @_builtins.property
    @pulumi.getter
    def acl(self) -> Optional[pulumi.Input['SkeClusterExtensionsAclArgs']]:
        """
        Cluster access control configuration.
        """
        return pulumi.get(self, "acl")

    @acl.setter
    def acl(self, value: Optional[pulumi.Input['SkeClusterExtensionsAclArgs']]):
        pulumi.set(self, "acl", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Use observability instead.""")
    def argus(self) -> Optional[pulumi.Input['SkeClusterExtensionsArgusArgs']]:
        """
        A single argus block as defined below. This field is deprecated and will be removed 06 January 2026.
        """
        return pulumi.get(self, "argus")

    @argus.setter
    def argus(self, value: Optional[pulumi.Input['SkeClusterExtensionsArgusArgs']]):
        pulumi.set(self, "argus", value)

    @_builtins.property
    @pulumi.getter
    def dns(self) -> Optional[pulumi.Input['SkeClusterExtensionsDnsArgs']]:
        """
        DNS extension configuration
        """
        return pulumi.get(self, "dns")

    @dns.setter
    def dns(self, value: Optional[pulumi.Input['SkeClusterExtensionsDnsArgs']]):
        pulumi.set(self, "dns", value)

    @_builtins.property
    @pulumi.getter
    def observability(self) -> Optional[pulumi.Input['SkeClusterExtensionsObservabilityArgs']]:
        """
        A single observability block as defined below.
        """
        return pulumi.get(self, "observability")

    @observability.setter
    def observability(self, value: Optional[pulumi.Input['SkeClusterExtensionsObservabilityArgs']]):
        pulumi.set(self, "observability", value)


if not MYPY:
    class SkeClusterExtensionsAclArgsDict(TypedDict):
        allowed_cidrs: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]
        """
        Specify a list of CIDRs to whitelist.
        """
        enabled: pulumi.Input[_builtins.bool]
        """
        Is ACL enabled?
        """
elif False:
    SkeClusterExtensionsAclArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SkeClusterExtensionsAclArgs:
    def __init__(__self__, *,
                 allowed_cidrs: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 enabled: pulumi.Input[_builtins.bool]):
        """
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_cidrs: Specify a list of CIDRs to whitelist.
        :param pulumi.Input[_builtins.bool] enabled: Is ACL enabled?
        """
        pulumi.set(__self__, "allowed_cidrs", allowed_cidrs)
        pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter(name="allowedCidrs")
    def allowed_cidrs(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Specify a list of CIDRs to whitelist.
        """
        return pulumi.get(self, "allowed_cidrs")

    @allowed_cidrs.setter
    def allowed_cidrs(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "allowed_cidrs", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[_builtins.bool]:
        """
        Is ACL enabled?
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "enabled", value)


if not MYPY:
    class SkeClusterExtensionsArgusArgsDict(TypedDict):
        enabled: pulumi.Input[_builtins.bool]
        """
        Flag to enable/disable Argus extensions.
        """
        argus_instance_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        Argus instance ID to choose which Argus instance is used. Required when enabled is set to `true`.
        """
elif False:
    SkeClusterExtensionsArgusArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SkeClusterExtensionsArgusArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[_builtins.bool],
                 argus_instance_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.bool] enabled: Flag to enable/disable Argus extensions.
        :param pulumi.Input[_builtins.str] argus_instance_id: Argus instance ID to choose which Argus instance is used. Required when enabled is set to `true`.
        """
        pulumi.set(__self__, "enabled", enabled)
        if argus_instance_id is not None:
            pulumi.set(__self__, "argus_instance_id", argus_instance_id)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[_builtins.bool]:
        """
        Flag to enable/disable Argus extensions.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="argusInstanceId")
    def argus_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Argus instance ID to choose which Argus instance is used. Required when enabled is set to `true`.
        """
        return pulumi.get(self, "argus_instance_id")

    @argus_instance_id.setter
    def argus_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "argus_instance_id", value)


if not MYPY:
    class SkeClusterExtensionsDnsArgsDict(TypedDict):
        enabled: pulumi.Input[_builtins.bool]
        """
        Flag to enable/disable DNS extensions
        """
        zones: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Specify a list of domain filters for externalDNS (e.g., `foo.runs.onstackit.cloud`)
        """
elif False:
    SkeClusterExtensionsDnsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SkeClusterExtensionsDnsArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[_builtins.bool],
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        :param pulumi.Input[_builtins.bool] enabled: Flag to enable/disable DNS extensions
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] zones: Specify a list of domain filters for externalDNS (e.g., `foo.runs.onstackit.cloud`)
        """
        pulumi.set(__self__, "enabled", enabled)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[_builtins.bool]:
        """
        Flag to enable/disable DNS extensions
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specify a list of domain filters for externalDNS (e.g., `foo.runs.onstackit.cloud`)
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "zones", value)


if not MYPY:
    class SkeClusterExtensionsObservabilityArgsDict(TypedDict):
        enabled: pulumi.Input[_builtins.bool]
        """
        Flag to enable/disable Observability extensions.
        """
        instance_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        Observability instance ID to choose which Observability instance is used. Required when enabled is set to `true`.
        """
elif False:
    SkeClusterExtensionsObservabilityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SkeClusterExtensionsObservabilityArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[_builtins.bool],
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.bool] enabled: Flag to enable/disable Observability extensions.
        :param pulumi.Input[_builtins.str] instance_id: Observability instance ID to choose which Observability instance is used. Required when enabled is set to `true`.
        """
        pulumi.set(__self__, "enabled", enabled)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[_builtins.bool]:
        """
        Flag to enable/disable Observability extensions.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Observability instance ID to choose which Observability instance is used. Required when enabled is set to `true`.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)


if not MYPY:
    class SkeClusterHibernationArgsDict(TypedDict):
        end: pulumi.Input[_builtins.str]
        """
        End time of hibernation in crontab syntax. E.g. `0 8 * * *` for waking up the cluster at 8am.
        """
        start: pulumi.Input[_builtins.str]
        """
        Start time of cluster hibernation in crontab syntax. E.g. `0 18 * * *` for starting everyday at 6pm.
        """
        timezone: NotRequired[pulumi.Input[_builtins.str]]
        """
        Timezone name corresponding to a file in the IANA Time Zone database. i.e. `Europe/Berlin`.
        """
elif False:
    SkeClusterHibernationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SkeClusterHibernationArgs:
    def __init__(__self__, *,
                 end: pulumi.Input[_builtins.str],
                 start: pulumi.Input[_builtins.str],
                 timezone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] end: End time of hibernation in crontab syntax. E.g. `0 8 * * *` for waking up the cluster at 8am.
        :param pulumi.Input[_builtins.str] start: Start time of cluster hibernation in crontab syntax. E.g. `0 18 * * *` for starting everyday at 6pm.
        :param pulumi.Input[_builtins.str] timezone: Timezone name corresponding to a file in the IANA Time Zone database. i.e. `Europe/Berlin`.
        """
        pulumi.set(__self__, "end", end)
        pulumi.set(__self__, "start", start)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)

    @_builtins.property
    @pulumi.getter
    def end(self) -> pulumi.Input[_builtins.str]:
        """
        End time of hibernation in crontab syntax. E.g. `0 8 * * *` for waking up the cluster at 8am.
        """
        return pulumi.get(self, "end")

    @end.setter
    def end(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "end", value)

    @_builtins.property
    @pulumi.getter
    def start(self) -> pulumi.Input[_builtins.str]:
        """
        Start time of cluster hibernation in crontab syntax. E.g. `0 18 * * *` for starting everyday at 6pm.
        """
        return pulumi.get(self, "start")

    @start.setter
    def start(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "start", value)

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Timezone name corresponding to a file in the IANA Time Zone database. i.e. `Europe/Berlin`.
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timezone", value)


if not MYPY:
    class SkeClusterMaintenanceArgsDict(TypedDict):
        end: pulumi.Input[_builtins.str]
        """
        Time for maintenance window end. E.g. `01:23:45Z`, `05:00:00+02:00`.
        """
        start: pulumi.Input[_builtins.str]
        """
        Time for maintenance window start. E.g. `01:23:45Z`, `05:00:00+02:00`.
        """
        enable_kubernetes_version_updates: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Flag to enable/disable auto-updates of the Kubernetes version. Defaults to `true`. SKE automatically updates the cluster Kubernetes version if you have set `maintenance.enable_kubernetes_version_updates` to true or if there is a mandatory update, as described in [Updates for Kubernetes versions and Operating System versions in SKE](https://docs.stackit.cloud/stackit/en/version-updates-in-ske-10125631.html).
        """
        enable_machine_image_version_updates: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Flag to enable/disable auto-updates of the OS image version. Defaults to `true`. SKE automatically updates the cluster Kubernetes version if you have set `maintenance.enable_kubernetes_version_updates` to true or if there is a mandatory update, as described in [Updates for Kubernetes versions and Operating System versions in SKE](https://docs.stackit.cloud/stackit/en/version-updates-in-ske-10125631.html).
        """
elif False:
    SkeClusterMaintenanceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SkeClusterMaintenanceArgs:
    def __init__(__self__, *,
                 end: pulumi.Input[_builtins.str],
                 start: pulumi.Input[_builtins.str],
                 enable_kubernetes_version_updates: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_machine_image_version_updates: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[_builtins.str] end: Time for maintenance window end. E.g. `01:23:45Z`, `05:00:00+02:00`.
        :param pulumi.Input[_builtins.str] start: Time for maintenance window start. E.g. `01:23:45Z`, `05:00:00+02:00`.
        :param pulumi.Input[_builtins.bool] enable_kubernetes_version_updates: Flag to enable/disable auto-updates of the Kubernetes version. Defaults to `true`. SKE automatically updates the cluster Kubernetes version if you have set `maintenance.enable_kubernetes_version_updates` to true or if there is a mandatory update, as described in [Updates for Kubernetes versions and Operating System versions in SKE](https://docs.stackit.cloud/stackit/en/version-updates-in-ske-10125631.html).
        :param pulumi.Input[_builtins.bool] enable_machine_image_version_updates: Flag to enable/disable auto-updates of the OS image version. Defaults to `true`. SKE automatically updates the cluster Kubernetes version if you have set `maintenance.enable_kubernetes_version_updates` to true or if there is a mandatory update, as described in [Updates for Kubernetes versions and Operating System versions in SKE](https://docs.stackit.cloud/stackit/en/version-updates-in-ske-10125631.html).
        """
        pulumi.set(__self__, "end", end)
        pulumi.set(__self__, "start", start)
        if enable_kubernetes_version_updates is not None:
            pulumi.set(__self__, "enable_kubernetes_version_updates", enable_kubernetes_version_updates)
        if enable_machine_image_version_updates is not None:
            pulumi.set(__self__, "enable_machine_image_version_updates", enable_machine_image_version_updates)

    @_builtins.property
    @pulumi.getter
    def end(self) -> pulumi.Input[_builtins.str]:
        """
        Time for maintenance window end. E.g. `01:23:45Z`, `05:00:00+02:00`.
        """
        return pulumi.get(self, "end")

    @end.setter
    def end(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "end", value)

    @_builtins.property
    @pulumi.getter
    def start(self) -> pulumi.Input[_builtins.str]:
        """
        Time for maintenance window start. E.g. `01:23:45Z`, `05:00:00+02:00`.
        """
        return pulumi.get(self, "start")

    @start.setter
    def start(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "start", value)

    @_builtins.property
    @pulumi.getter(name="enableKubernetesVersionUpdates")
    def enable_kubernetes_version_updates(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to enable/disable auto-updates of the Kubernetes version. Defaults to `true`. SKE automatically updates the cluster Kubernetes version if you have set `maintenance.enable_kubernetes_version_updates` to true or if there is a mandatory update, as described in [Updates for Kubernetes versions and Operating System versions in SKE](https://docs.stackit.cloud/stackit/en/version-updates-in-ske-10125631.html).
        """
        return pulumi.get(self, "enable_kubernetes_version_updates")

    @enable_kubernetes_version_updates.setter
    def enable_kubernetes_version_updates(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_kubernetes_version_updates", value)

    @_builtins.property
    @pulumi.getter(name="enableMachineImageVersionUpdates")
    def enable_machine_image_version_updates(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to enable/disable auto-updates of the OS image version. Defaults to `true`. SKE automatically updates the cluster Kubernetes version if you have set `maintenance.enable_kubernetes_version_updates` to true or if there is a mandatory update, as described in [Updates for Kubernetes versions and Operating System versions in SKE](https://docs.stackit.cloud/stackit/en/version-updates-in-ske-10125631.html).
        """
        return pulumi.get(self, "enable_machine_image_version_updates")

    @enable_machine_image_version_updates.setter
    def enable_machine_image_version_updates(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_machine_image_version_updates", value)


if not MYPY:
    class SkeClusterNetworkArgsDict(TypedDict):
        id: NotRequired[pulumi.Input[_builtins.str]]
        """
        ID of the STACKIT Network Area (SNA) network into which the cluster will be deployed.
        """
elif False:
    SkeClusterNetworkArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SkeClusterNetworkArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] id: ID of the STACKIT Network Area (SNA) network into which the cluster will be deployed.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the STACKIT Network Area (SNA) network into which the cluster will be deployed.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "id", value)


if not MYPY:
    class SkeClusterNodePoolArgsDict(TypedDict):
        availability_zones: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]
        """
        Specify a list of availability zones. E.g. `eu01-m`
        """
        machine_type: pulumi.Input[_builtins.str]
        """
        The machine type.
        """
        maximum: pulumi.Input[_builtins.int]
        """
        Maximum number of nodes in the pool.
        """
        minimum: pulumi.Input[_builtins.int]
        """
        Minimum number of nodes in the pool.
        """
        name: pulumi.Input[_builtins.str]
        """
        Specifies the name of the node pool.
        """
        allow_system_components: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Allow system components to run on this node pool.
        """
        cri: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the container runtime. Defaults to `containerd`
        """
        labels: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]
        """
        Labels to add to each node.
        """
        max_surge: NotRequired[pulumi.Input[_builtins.int]]
        """
        Maximum number of additional VMs that are created during an update. If set (larger than 0), then it must be at least the amount of zones configured for the nodepool. The `max_surge` and `max_unavailable` fields cannot both be unset at the same time.
        """
        max_unavailable: NotRequired[pulumi.Input[_builtins.int]]
        """
        Maximum number of VMs that that can be unavailable during an update. If set (larger than 0), then it must be at least the amount of zones configured for the nodepool. The `max_surge` and `max_unavailable` fields cannot both be unset at the same time.
        """
        os_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        The name of the OS image. Defaults to `flatcar`.
        """
        os_version: NotRequired[pulumi.Input[_builtins.str]]
        """
        This field is deprecated, use `os_version_min` to configure the version and `os_version_used` to get the currently used version instead.
        """
        os_version_min: NotRequired[pulumi.Input[_builtins.str]]
        """
        The minimum OS image version. This field will be used to set the minimum OS image version on creation/update of the cluster. If unset, the latest supported OS image version will be used. SKE automatically updates the cluster Kubernetes version if you have set `maintenance.enable_kubernetes_version_updates` to true or if there is a mandatory update, as described in [Updates for Kubernetes versions and Operating System versions in SKE](https://docs.stackit.cloud/stackit/en/version-updates-in-ske-10125631.html). To get the current OS image version being used for the node pool, use the read-only `os_version_used` field.
        """
        os_version_used: NotRequired[pulumi.Input[_builtins.str]]
        """
        Full OS image version used. For example, if 3815.2 was set in `os_version_min`, this value may result to 3815.2.2. SKE automatically updates the cluster Kubernetes version if you have set `maintenance.enable_kubernetes_version_updates` to true or if there is a mandatory update, as described in [Updates for Kubernetes versions and Operating System versions in SKE](https://docs.stackit.cloud/stackit/en/version-updates-in-ske-10125631.html).
        """
        taints: NotRequired[pulumi.Input[Sequence[pulumi.Input['SkeClusterNodePoolTaintArgsDict']]]]
        """
        Specifies a taint list as defined below.
        """
        volume_size: NotRequired[pulumi.Input[_builtins.int]]
        """
        The volume size in GB. Defaults to `20`
        """
        volume_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the volume type. Defaults to `storage_premium_perf1`.
        """
elif False:
    SkeClusterNodePoolArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SkeClusterNodePoolArgs:
    def __init__(__self__, *,
                 availability_zones: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 machine_type: pulumi.Input[_builtins.str],
                 maximum: pulumi.Input[_builtins.int],
                 minimum: pulumi.Input[_builtins.int],
                 name: pulumi.Input[_builtins.str],
                 allow_system_components: Optional[pulumi.Input[_builtins.bool]] = None,
                 cri: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 max_surge: Optional[pulumi.Input[_builtins.int]] = None,
                 max_unavailable: Optional[pulumi.Input[_builtins.int]] = None,
                 os_name: Optional[pulumi.Input[_builtins.str]] = None,
                 os_version: Optional[pulumi.Input[_builtins.str]] = None,
                 os_version_min: Optional[pulumi.Input[_builtins.str]] = None,
                 os_version_used: Optional[pulumi.Input[_builtins.str]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input['SkeClusterNodePoolTaintArgs']]]] = None,
                 volume_size: Optional[pulumi.Input[_builtins.int]] = None,
                 volume_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] availability_zones: Specify a list of availability zones. E.g. `eu01-m`
        :param pulumi.Input[_builtins.str] machine_type: The machine type.
        :param pulumi.Input[_builtins.int] maximum: Maximum number of nodes in the pool.
        :param pulumi.Input[_builtins.int] minimum: Minimum number of nodes in the pool.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the node pool.
        :param pulumi.Input[_builtins.bool] allow_system_components: Allow system components to run on this node pool.
        :param pulumi.Input[_builtins.str] cri: Specifies the container runtime. Defaults to `containerd`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels to add to each node.
        :param pulumi.Input[_builtins.int] max_surge: Maximum number of additional VMs that are created during an update. If set (larger than 0), then it must be at least the amount of zones configured for the nodepool. The `max_surge` and `max_unavailable` fields cannot both be unset at the same time.
        :param pulumi.Input[_builtins.int] max_unavailable: Maximum number of VMs that that can be unavailable during an update. If set (larger than 0), then it must be at least the amount of zones configured for the nodepool. The `max_surge` and `max_unavailable` fields cannot both be unset at the same time.
        :param pulumi.Input[_builtins.str] os_name: The name of the OS image. Defaults to `flatcar`.
        :param pulumi.Input[_builtins.str] os_version: This field is deprecated, use `os_version_min` to configure the version and `os_version_used` to get the currently used version instead.
        :param pulumi.Input[_builtins.str] os_version_min: The minimum OS image version. This field will be used to set the minimum OS image version on creation/update of the cluster. If unset, the latest supported OS image version will be used. SKE automatically updates the cluster Kubernetes version if you have set `maintenance.enable_kubernetes_version_updates` to true or if there is a mandatory update, as described in [Updates for Kubernetes versions and Operating System versions in SKE](https://docs.stackit.cloud/stackit/en/version-updates-in-ske-10125631.html). To get the current OS image version being used for the node pool, use the read-only `os_version_used` field.
        :param pulumi.Input[_builtins.str] os_version_used: Full OS image version used. For example, if 3815.2 was set in `os_version_min`, this value may result to 3815.2.2. SKE automatically updates the cluster Kubernetes version if you have set `maintenance.enable_kubernetes_version_updates` to true or if there is a mandatory update, as described in [Updates for Kubernetes versions and Operating System versions in SKE](https://docs.stackit.cloud/stackit/en/version-updates-in-ske-10125631.html).
        :param pulumi.Input[Sequence[pulumi.Input['SkeClusterNodePoolTaintArgs']]] taints: Specifies a taint list as defined below.
        :param pulumi.Input[_builtins.int] volume_size: The volume size in GB. Defaults to `20`
        :param pulumi.Input[_builtins.str] volume_type: Specifies the volume type. Defaults to `storage_premium_perf1`.
        """
        pulumi.set(__self__, "availability_zones", availability_zones)
        pulumi.set(__self__, "machine_type", machine_type)
        pulumi.set(__self__, "maximum", maximum)
        pulumi.set(__self__, "minimum", minimum)
        pulumi.set(__self__, "name", name)
        if allow_system_components is not None:
            pulumi.set(__self__, "allow_system_components", allow_system_components)
        if cri is not None:
            pulumi.set(__self__, "cri", cri)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if max_surge is not None:
            pulumi.set(__self__, "max_surge", max_surge)
        if max_unavailable is not None:
            pulumi.set(__self__, "max_unavailable", max_unavailable)
        if os_name is not None:
            pulumi.set(__self__, "os_name", os_name)
        if os_version is not None:
            warnings.warn("""Use `os_version_min` to configure the version and `os_version_used` to get the currently used version instead. Setting a specific OS image version will cause errors during minor OS upgrades due to forced updates.""", DeprecationWarning)
            pulumi.log.warn("""os_version is deprecated: Use `os_version_min` to configure the version and `os_version_used` to get the currently used version instead. Setting a specific OS image version will cause errors during minor OS upgrades due to forced updates.""")
        if os_version is not None:
            pulumi.set(__self__, "os_version", os_version)
        if os_version_min is not None:
            pulumi.set(__self__, "os_version_min", os_version_min)
        if os_version_used is not None:
            pulumi.set(__self__, "os_version_used", os_version_used)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)
        if volume_size is not None:
            pulumi.set(__self__, "volume_size", volume_size)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @_builtins.property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Specify a list of availability zones. E.g. `eu01-m`
        """
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "availability_zones", value)

    @_builtins.property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> pulumi.Input[_builtins.str]:
        """
        The machine type.
        """
        return pulumi.get(self, "machine_type")

    @machine_type.setter
    def machine_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "machine_type", value)

    @_builtins.property
    @pulumi.getter
    def maximum(self) -> pulumi.Input[_builtins.int]:
        """
        Maximum number of nodes in the pool.
        """
        return pulumi.get(self, "maximum")

    @maximum.setter
    def maximum(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "maximum", value)

    @_builtins.property
    @pulumi.getter
    def minimum(self) -> pulumi.Input[_builtins.int]:
        """
        Minimum number of nodes in the pool.
        """
        return pulumi.get(self, "minimum")

    @minimum.setter
    def minimum(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "minimum", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of the node pool.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="allowSystemComponents")
    def allow_system_components(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Allow system components to run on this node pool.
        """
        return pulumi.get(self, "allow_system_components")

    @allow_system_components.setter
    def allow_system_components(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_system_components", value)

    @_builtins.property
    @pulumi.getter
    def cri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the container runtime. Defaults to `containerd`
        """
        return pulumi.get(self, "cri")

    @cri.setter
    def cri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cri", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels to add to each node.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="maxSurge")
    def max_surge(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum number of additional VMs that are created during an update. If set (larger than 0), then it must be at least the amount of zones configured for the nodepool. The `max_surge` and `max_unavailable` fields cannot both be unset at the same time.
        """
        return pulumi.get(self, "max_surge")

    @max_surge.setter
    def max_surge(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_surge", value)

    @_builtins.property
    @pulumi.getter(name="maxUnavailable")
    def max_unavailable(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum number of VMs that that can be unavailable during an update. If set (larger than 0), then it must be at least the amount of zones configured for the nodepool. The `max_surge` and `max_unavailable` fields cannot both be unset at the same time.
        """
        return pulumi.get(self, "max_unavailable")

    @max_unavailable.setter
    def max_unavailable(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_unavailable", value)

    @_builtins.property
    @pulumi.getter(name="osName")
    def os_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the OS image. Defaults to `flatcar`.
        """
        return pulumi.get(self, "os_name")

    @os_name.setter
    def os_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "os_name", value)

    @_builtins.property
    @pulumi.getter(name="osVersion")
    @_utilities.deprecated("""Use `os_version_min` to configure the version and `os_version_used` to get the currently used version instead. Setting a specific OS image version will cause errors during minor OS upgrades due to forced updates.""")
    def os_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This field is deprecated, use `os_version_min` to configure the version and `os_version_used` to get the currently used version instead.
        """
        return pulumi.get(self, "os_version")

    @os_version.setter
    def os_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "os_version", value)

    @_builtins.property
    @pulumi.getter(name="osVersionMin")
    def os_version_min(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The minimum OS image version. This field will be used to set the minimum OS image version on creation/update of the cluster. If unset, the latest supported OS image version will be used. SKE automatically updates the cluster Kubernetes version if you have set `maintenance.enable_kubernetes_version_updates` to true or if there is a mandatory update, as described in [Updates for Kubernetes versions and Operating System versions in SKE](https://docs.stackit.cloud/stackit/en/version-updates-in-ske-10125631.html). To get the current OS image version being used for the node pool, use the read-only `os_version_used` field.
        """
        return pulumi.get(self, "os_version_min")

    @os_version_min.setter
    def os_version_min(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "os_version_min", value)

    @_builtins.property
    @pulumi.getter(name="osVersionUsed")
    def os_version_used(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Full OS image version used. For example, if 3815.2 was set in `os_version_min`, this value may result to 3815.2.2. SKE automatically updates the cluster Kubernetes version if you have set `maintenance.enable_kubernetes_version_updates` to true or if there is a mandatory update, as described in [Updates for Kubernetes versions and Operating System versions in SKE](https://docs.stackit.cloud/stackit/en/version-updates-in-ske-10125631.html).
        """
        return pulumi.get(self, "os_version_used")

    @os_version_used.setter
    def os_version_used(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "os_version_used", value)

    @_builtins.property
    @pulumi.getter
    def taints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SkeClusterNodePoolTaintArgs']]]]:
        """
        Specifies a taint list as defined below.
        """
        return pulumi.get(self, "taints")

    @taints.setter
    def taints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SkeClusterNodePoolTaintArgs']]]]):
        pulumi.set(self, "taints", value)

    @_builtins.property
    @pulumi.getter(name="volumeSize")
    def volume_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The volume size in GB. Defaults to `20`
        """
        return pulumi.get(self, "volume_size")

    @volume_size.setter
    def volume_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "volume_size", value)

    @_builtins.property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the volume type. Defaults to `storage_premium_perf1`.
        """
        return pulumi.get(self, "volume_type")

    @volume_type.setter
    def volume_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "volume_type", value)


if not MYPY:
    class SkeClusterNodePoolTaintArgsDict(TypedDict):
        effect: pulumi.Input[_builtins.str]
        """
        The taint effect. E.g `PreferNoSchedule`.
        """
        key: pulumi.Input[_builtins.str]
        """
        Taint key to be applied to a node.
        """
        value: NotRequired[pulumi.Input[_builtins.str]]
        """
        Taint value corresponding to the taint key.
        """
elif False:
    SkeClusterNodePoolTaintArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SkeClusterNodePoolTaintArgs:
    def __init__(__self__, *,
                 effect: pulumi.Input[_builtins.str],
                 key: pulumi.Input[_builtins.str],
                 value: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] effect: The taint effect. E.g `PreferNoSchedule`.
        :param pulumi.Input[_builtins.str] key: Taint key to be applied to a node.
        :param pulumi.Input[_builtins.str] value: Taint value corresponding to the taint key.
        """
        pulumi.set(__self__, "effect", effect)
        pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def effect(self) -> pulumi.Input[_builtins.str]:
        """
        The taint effect. E.g `PreferNoSchedule`.
        """
        return pulumi.get(self, "effect")

    @effect.setter
    def effect(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "effect", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> pulumi.Input[_builtins.str]:
        """
        Taint key to be applied to a node.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Taint value corresponding to the taint key.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "value", value)


if not MYPY:
    class SqlserverflexInstanceFlavorArgsDict(TypedDict):
        cpu: pulumi.Input[_builtins.int]
        ram: pulumi.Input[_builtins.int]
        description: NotRequired[pulumi.Input[_builtins.str]]
        id: NotRequired[pulumi.Input[_builtins.str]]
elif False:
    SqlserverflexInstanceFlavorArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SqlserverflexInstanceFlavorArgs:
    def __init__(__self__, *,
                 cpu: pulumi.Input[_builtins.int],
                 ram: pulumi.Input[_builtins.int],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 id: Optional[pulumi.Input[_builtins.str]] = None):
        pulumi.set(__self__, "cpu", cpu)
        pulumi.set(__self__, "ram", ram)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> pulumi.Input[_builtins.int]:
        return pulumi.get(self, "cpu")

    @cpu.setter
    def cpu(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "cpu", value)

    @_builtins.property
    @pulumi.getter
    def ram(self) -> pulumi.Input[_builtins.int]:
        return pulumi.get(self, "ram")

    @ram.setter
    def ram(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "ram", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "id", value)


if not MYPY:
    class SqlserverflexInstanceOptionsArgsDict(TypedDict):
        edition: NotRequired[pulumi.Input[_builtins.str]]
        retention_days: NotRequired[pulumi.Input[_builtins.int]]
elif False:
    SqlserverflexInstanceOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SqlserverflexInstanceOptionsArgs:
    def __init__(__self__, *,
                 edition: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_days: Optional[pulumi.Input[_builtins.int]] = None):
        if edition is not None:
            pulumi.set(__self__, "edition", edition)
        if retention_days is not None:
            pulumi.set(__self__, "retention_days", retention_days)

    @_builtins.property
    @pulumi.getter
    def edition(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "edition")

    @edition.setter
    def edition(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "edition", value)

    @_builtins.property
    @pulumi.getter(name="retentionDays")
    def retention_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "retention_days")

    @retention_days.setter
    def retention_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "retention_days", value)


if not MYPY:
    class SqlserverflexInstanceStorageArgsDict(TypedDict):
        class_: NotRequired[pulumi.Input[_builtins.str]]
        size: NotRequired[pulumi.Input[_builtins.int]]
elif False:
    SqlserverflexInstanceStorageArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SqlserverflexInstanceStorageArgs:
    def __init__(__self__, *,
                 class_: Optional[pulumi.Input[_builtins.str]] = None,
                 size: Optional[pulumi.Input[_builtins.int]] = None):
        if class_ is not None:
            pulumi.set(__self__, "class_", class_)
        if size is not None:
            pulumi.set(__self__, "size", size)

    @_builtins.property
    @pulumi.getter(name="class")
    def class_(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "class_")

    @class_.setter
    def class_(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "class_", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "size", value)


if not MYPY:
    class VolumeSourceArgsDict(TypedDict):
        id: pulumi.Input[_builtins.str]
        """
        The ID of the source, e.g. image ID
        """
        type: pulumi.Input[_builtins.str]
        """
        The type of the source. Supported values are: `volume`, `image`, `snapshot`, `backup`.
        """
elif False:
    VolumeSourceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VolumeSourceArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] id: The ID of the source, e.g. image ID
        :param pulumi.Input[_builtins.str] type: The type of the source. Supported values are: `volume`, `image`, `snapshot`, `backup`.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the source, e.g. image ID
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "id", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the source. Supported values are: `volume`, `image`, `snapshot`, `backup`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)


