# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['AffinityGroupArgs', 'AffinityGroup']

@pulumi.input_type
class AffinityGroupArgs:
    def __init__(__self__, *,
                 policy: pulumi.Input[_builtins.str],
                 project_id: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AffinityGroup resource.
        :param pulumi.Input[_builtins.str] policy: The policy of the affinity group.
        :param pulumi.Input[_builtins.str] project_id: STACKIT Project ID to which the affinity group is associated.
        :param pulumi.Input[_builtins.str] name: The name of the affinity group.
        """
        pulumi.set(__self__, "policy", policy)
        pulumi.set(__self__, "project_id", project_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def policy(self) -> pulumi.Input[_builtins.str]:
        """
        The policy of the affinity group.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "policy", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.str]:
        """
        STACKIT Project ID to which the affinity group is associated.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the affinity group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _AffinityGroupState:
    def __init__(__self__, *,
                 affinity_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AffinityGroup resources.
        :param pulumi.Input[_builtins.str] affinity_group_id: The affinity group ID.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] members: The servers that are part of the affinity group.
        :param pulumi.Input[_builtins.str] name: The name of the affinity group.
        :param pulumi.Input[_builtins.str] policy: The policy of the affinity group.
        :param pulumi.Input[_builtins.str] project_id: STACKIT Project ID to which the affinity group is associated.
        """
        if affinity_group_id is not None:
            pulumi.set(__self__, "affinity_group_id", affinity_group_id)
        if members is not None:
            pulumi.set(__self__, "members", members)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)

    @_builtins.property
    @pulumi.getter(name="affinityGroupId")
    def affinity_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The affinity group ID.
        """
        return pulumi.get(self, "affinity_group_id")

    @affinity_group_id.setter
    def affinity_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "affinity_group_id", value)

    @_builtins.property
    @pulumi.getter
    def members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The servers that are part of the affinity group.
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "members", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the affinity group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The policy of the affinity group.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        STACKIT Project ID to which the affinity group is associated.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)


@pulumi.type_token("stackit:index/affinityGroup:AffinityGroup")
class AffinityGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Affinity Group schema. Must have a `region` specified in the provider configuration.

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: The name of the affinity group.
        :param pulumi.Input[_builtins.str] policy: The policy of the affinity group.
        :param pulumi.Input[_builtins.str] project_id: STACKIT Project ID to which the affinity group is associated.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AffinityGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Affinity Group schema. Must have a `region` specified in the provider configuration.

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param AffinityGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AffinityGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AffinityGroupArgs.__new__(AffinityGroupArgs)

            __props__.__dict__["name"] = name
            if policy is None and not opts.urn:
                raise TypeError("Missing required property 'policy'")
            __props__.__dict__["policy"] = policy
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["affinity_group_id"] = None
            __props__.__dict__["members"] = None
        super(AffinityGroup, __self__).__init__(
            'stackit:index/affinityGroup:AffinityGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            affinity_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            members: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            policy: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'AffinityGroup':
        """
        Get an existing AffinityGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] affinity_group_id: The affinity group ID.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] members: The servers that are part of the affinity group.
        :param pulumi.Input[_builtins.str] name: The name of the affinity group.
        :param pulumi.Input[_builtins.str] policy: The policy of the affinity group.
        :param pulumi.Input[_builtins.str] project_id: STACKIT Project ID to which the affinity group is associated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AffinityGroupState.__new__(_AffinityGroupState)

        __props__.__dict__["affinity_group_id"] = affinity_group_id
        __props__.__dict__["members"] = members
        __props__.__dict__["name"] = name
        __props__.__dict__["policy"] = policy
        __props__.__dict__["project_id"] = project_id
        return AffinityGroup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="affinityGroupId")
    def affinity_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The affinity group ID.
        """
        return pulumi.get(self, "affinity_group_id")

    @_builtins.property
    @pulumi.getter
    def members(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The servers that are part of the affinity group.
        """
        return pulumi.get(self, "members")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the affinity group.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def policy(self) -> pulumi.Output[_builtins.str]:
        """
        The policy of the affinity group.
        """
        return pulumi.get(self, "policy")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        STACKIT Project ID to which the affinity group is associated.
        """
        return pulumi.get(self, "project_id")

