# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['CdnCustomDomainArgs', 'CdnCustomDomain']

@pulumi.input_type
class CdnCustomDomainArgs:
    def __init__(__self__, *,
                 distribution_id: pulumi.Input[_builtins.str],
                 project_id: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a CdnCustomDomain resource.
        :param pulumi.Input[_builtins.str] distribution_id: CDN distribution ID
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID associated with the distribution
        """
        pulumi.set(__self__, "distribution_id", distribution_id)
        pulumi.set(__self__, "project_id", project_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="distributionId")
    def distribution_id(self) -> pulumi.Input[_builtins.str]:
        """
        CDN distribution ID
        """
        return pulumi.get(self, "distribution_id")

    @distribution_id.setter
    def distribution_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "distribution_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.str]:
        """
        STACKIT project ID associated with the distribution
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _CdnCustomDomainState:
    def __init__(__self__, *,
                 distribution_id: Optional[pulumi.Input[_builtins.str]] = None,
                 errors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering CdnCustomDomain resources.
        :param pulumi.Input[_builtins.str] distribution_id: CDN distribution ID
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] errors: List of distribution errors
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID associated with the distribution
        :param pulumi.Input[_builtins.str] status: Status of the distribution
        """
        if distribution_id is not None:
            pulumi.set(__self__, "distribution_id", distribution_id)
        if errors is not None:
            pulumi.set(__self__, "errors", errors)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="distributionId")
    def distribution_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        CDN distribution ID
        """
        return pulumi.get(self, "distribution_id")

    @distribution_id.setter
    def distribution_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "distribution_id", value)

    @_builtins.property
    @pulumi.getter
    def errors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of distribution errors
        """
        return pulumi.get(self, "errors")

    @errors.setter
    def errors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "errors", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        STACKIT project ID associated with the distribution
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status of the distribution
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("stackit:index/cdnCustomDomain:CdnCustomDomain")
class CdnCustomDomain(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 distribution_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        CDN distribution data source schema.

        > This resource is in beta and may be subject to breaking changes in the future. Use with caution. See our guide for how to opt-in to use beta resources.

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] distribution_id: CDN distribution ID
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID associated with the distribution
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CdnCustomDomainArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        CDN distribution data source schema.

        > This resource is in beta and may be subject to breaking changes in the future. Use with caution. See our guide for how to opt-in to use beta resources.

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param CdnCustomDomainArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CdnCustomDomainArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 distribution_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CdnCustomDomainArgs.__new__(CdnCustomDomainArgs)

            if distribution_id is None and not opts.urn:
                raise TypeError("Missing required property 'distribution_id'")
            __props__.__dict__["distribution_id"] = distribution_id
            __props__.__dict__["name"] = name
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["errors"] = None
            __props__.__dict__["status"] = None
        super(CdnCustomDomain, __self__).__init__(
            'stackit:index/cdnCustomDomain:CdnCustomDomain',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            distribution_id: Optional[pulumi.Input[_builtins.str]] = None,
            errors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'CdnCustomDomain':
        """
        Get an existing CdnCustomDomain resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] distribution_id: CDN distribution ID
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] errors: List of distribution errors
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID associated with the distribution
        :param pulumi.Input[_builtins.str] status: Status of the distribution
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CdnCustomDomainState.__new__(_CdnCustomDomainState)

        __props__.__dict__["distribution_id"] = distribution_id
        __props__.__dict__["errors"] = errors
        __props__.__dict__["name"] = name
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["status"] = status
        return CdnCustomDomain(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="distributionId")
    def distribution_id(self) -> pulumi.Output[_builtins.str]:
        """
        CDN distribution ID
        """
        return pulumi.get(self, "distribution_id")

    @_builtins.property
    @pulumi.getter
    def errors(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of distribution errors
        """
        return pulumi.get(self, "errors")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        STACKIT project ID associated with the distribution
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Status of the distribution
        """
        return pulumi.get(self, "status")

