# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CdnDistributionArgs', 'CdnDistribution']

@pulumi.input_type
class CdnDistributionArgs:
    def __init__(__self__, *,
                 config: pulumi.Input['CdnDistributionConfigArgs'],
                 project_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a CdnDistribution resource.
        :param pulumi.Input['CdnDistributionConfigArgs'] config: The distribution configuration
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID associated with the distribution
        """
        pulumi.set(__self__, "config", config)
        pulumi.set(__self__, "project_id", project_id)

    @_builtins.property
    @pulumi.getter
    def config(self) -> pulumi.Input['CdnDistributionConfigArgs']:
        """
        The distribution configuration
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: pulumi.Input['CdnDistributionConfigArgs']):
        pulumi.set(self, "config", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.str]:
        """
        STACKIT project ID associated with the distribution
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_id", value)


@pulumi.input_type
class _CdnDistributionState:
    def __init__(__self__, *,
                 config: Optional[pulumi.Input['CdnDistributionConfigArgs']] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 distribution_id: Optional[pulumi.Input[_builtins.str]] = None,
                 domains: Optional[pulumi.Input[Sequence[pulumi.Input['CdnDistributionDomainArgs']]]] = None,
                 errors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering CdnDistribution resources.
        :param pulumi.Input['CdnDistributionConfigArgs'] config: The distribution configuration
        :param pulumi.Input[_builtins.str] created_at: Time when the distribution was created
        :param pulumi.Input[_builtins.str] distribution_id: CDN distribution ID
        :param pulumi.Input[Sequence[pulumi.Input['CdnDistributionDomainArgs']]] domains: List of configured domains for the distribution
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] errors: List of distribution errors
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID associated with the distribution
        :param pulumi.Input[_builtins.str] status: Status of the distribution
        :param pulumi.Input[_builtins.str] updated_at: Time when the distribution was last updated
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if distribution_id is not None:
            pulumi.set(__self__, "distribution_id", distribution_id)
        if domains is not None:
            pulumi.set(__self__, "domains", domains)
        if errors is not None:
            pulumi.set(__self__, "errors", errors)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input['CdnDistributionConfigArgs']]:
        """
        The distribution configuration
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input['CdnDistributionConfigArgs']]):
        pulumi.set(self, "config", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time when the distribution was created
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="distributionId")
    def distribution_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        CDN distribution ID
        """
        return pulumi.get(self, "distribution_id")

    @distribution_id.setter
    def distribution_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "distribution_id", value)

    @_builtins.property
    @pulumi.getter
    def domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CdnDistributionDomainArgs']]]]:
        """
        List of configured domains for the distribution
        """
        return pulumi.get(self, "domains")

    @domains.setter
    def domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CdnDistributionDomainArgs']]]]):
        pulumi.set(self, "domains", value)

    @_builtins.property
    @pulumi.getter
    def errors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of distribution errors
        """
        return pulumi.get(self, "errors")

    @errors.setter
    def errors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "errors", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        STACKIT project ID associated with the distribution
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status of the distribution
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time when the distribution was last updated
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.type_token("stackit:index/cdnDistribution:CdnDistribution")
class CdnDistribution(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config: Optional[pulumi.Input[Union['CdnDistributionConfigArgs', 'CdnDistributionConfigArgsDict']]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        CDN distribution data source schema.

        > This resource is in beta and may be subject to breaking changes in the future. Use with caution. See our guide for how to opt-in to use beta resources.

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['CdnDistributionConfigArgs', 'CdnDistributionConfigArgsDict']] config: The distribution configuration
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID associated with the distribution
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CdnDistributionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        CDN distribution data source schema.

        > This resource is in beta and may be subject to breaking changes in the future. Use with caution. See our guide for how to opt-in to use beta resources.

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param CdnDistributionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CdnDistributionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config: Optional[pulumi.Input[Union['CdnDistributionConfigArgs', 'CdnDistributionConfigArgsDict']]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CdnDistributionArgs.__new__(CdnDistributionArgs)

            if config is None and not opts.urn:
                raise TypeError("Missing required property 'config'")
            __props__.__dict__["config"] = config
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["created_at"] = None
            __props__.__dict__["distribution_id"] = None
            __props__.__dict__["domains"] = None
            __props__.__dict__["errors"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["updated_at"] = None
        super(CdnDistribution, __self__).__init__(
            'stackit:index/cdnDistribution:CdnDistribution',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            config: Optional[pulumi.Input[Union['CdnDistributionConfigArgs', 'CdnDistributionConfigArgsDict']]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            distribution_id: Optional[pulumi.Input[_builtins.str]] = None,
            domains: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CdnDistributionDomainArgs', 'CdnDistributionDomainArgsDict']]]]] = None,
            errors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None) -> 'CdnDistribution':
        """
        Get an existing CdnDistribution resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['CdnDistributionConfigArgs', 'CdnDistributionConfigArgsDict']] config: The distribution configuration
        :param pulumi.Input[_builtins.str] created_at: Time when the distribution was created
        :param pulumi.Input[_builtins.str] distribution_id: CDN distribution ID
        :param pulumi.Input[Sequence[pulumi.Input[Union['CdnDistributionDomainArgs', 'CdnDistributionDomainArgsDict']]]] domains: List of configured domains for the distribution
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] errors: List of distribution errors
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID associated with the distribution
        :param pulumi.Input[_builtins.str] status: Status of the distribution
        :param pulumi.Input[_builtins.str] updated_at: Time when the distribution was last updated
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CdnDistributionState.__new__(_CdnDistributionState)

        __props__.__dict__["config"] = config
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["distribution_id"] = distribution_id
        __props__.__dict__["domains"] = domains
        __props__.__dict__["errors"] = errors
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["status"] = status
        __props__.__dict__["updated_at"] = updated_at
        return CdnDistribution(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def config(self) -> pulumi.Output['outputs.CdnDistributionConfig']:
        """
        The distribution configuration
        """
        return pulumi.get(self, "config")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        Time when the distribution was created
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="distributionId")
    def distribution_id(self) -> pulumi.Output[_builtins.str]:
        """
        CDN distribution ID
        """
        return pulumi.get(self, "distribution_id")

    @_builtins.property
    @pulumi.getter
    def domains(self) -> pulumi.Output[Sequence['outputs.CdnDistributionDomain']]:
        """
        List of configured domains for the distribution
        """
        return pulumi.get(self, "domains")

    @_builtins.property
    @pulumi.getter
    def errors(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of distribution errors
        """
        return pulumi.get(self, "errors")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        STACKIT project ID associated with the distribution
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Status of the distribution
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        Time when the distribution was last updated
        """
        return pulumi.get(self, "updated_at")

