# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['DnsRecordSetArgs', 'DnsRecordSet']

@pulumi.input_type
class DnsRecordSetArgs:
    def __init__(__self__, *,
                 project_id: pulumi.Input[_builtins.str],
                 records: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 type: pulumi.Input[_builtins.str],
                 zone_id: pulumi.Input[_builtins.str],
                 active: Optional[pulumi.Input[_builtins.bool]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ttl: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a DnsRecordSet resource.
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the dns record set is associated.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] records: Records.
        :param pulumi.Input[_builtins.str] type: The record set type. E.g. `A` or `CNAME`
        :param pulumi.Input[_builtins.str] zone_id: The zone ID to which is dns record set is associated.
        :param pulumi.Input[_builtins.bool] active: Specifies if the record set is active or not. Defaults to `true`
        :param pulumi.Input[_builtins.str] comment: Comment.
        :param pulumi.Input[_builtins.str] name: Name of the record which should be a valid domain according to rfc1035 Section 2.3.4. E.g. `example.com`
        :param pulumi.Input[_builtins.int] ttl: Time to live. E.g. 3600
        """
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "records", records)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "zone_id", zone_id)
        if active is not None:
            pulumi.set(__self__, "active", active)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.str]:
        """
        STACKIT project ID to which the dns record set is associated.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def records(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Records.
        """
        return pulumi.get(self, "records")

    @records.setter
    def records(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "records", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The record set type. E.g. `A` or `CNAME`
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[_builtins.str]:
        """
        The zone ID to which is dns record set is associated.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "zone_id", value)

    @_builtins.property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if the record set is active or not. Defaults to `true`
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "active", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Comment.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the record which should be a valid domain according to rfc1035 Section 2.3.4. E.g. `example.com`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Time to live. E.g. 3600
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ttl", value)


@pulumi.input_type
class _DnsRecordSetState:
    def __init__(__self__, *,
                 active: Optional[pulumi.Input[_builtins.bool]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 error: Optional[pulumi.Input[_builtins.str]] = None,
                 fqdn: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 record_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 records: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DnsRecordSet resources.
        :param pulumi.Input[_builtins.bool] active: Specifies if the record set is active or not. Defaults to `true`
        :param pulumi.Input[_builtins.str] comment: Comment.
        :param pulumi.Input[_builtins.str] error: Error shows error in case create/update/delete failed.
        :param pulumi.Input[_builtins.str] fqdn: Fully qualified domain name (FQDN) of the record set.
        :param pulumi.Input[_builtins.str] name: Name of the record which should be a valid domain according to rfc1035 Section 2.3.4. E.g. `example.com`
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the dns record set is associated.
        :param pulumi.Input[_builtins.str] record_set_id: The rr set id.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] records: Records.
        :param pulumi.Input[_builtins.str] state: Record set state.
        :param pulumi.Input[_builtins.int] ttl: Time to live. E.g. 3600
        :param pulumi.Input[_builtins.str] type: The record set type. E.g. `A` or `CNAME`
        :param pulumi.Input[_builtins.str] zone_id: The zone ID to which is dns record set is associated.
        """
        if active is not None:
            pulumi.set(__self__, "active", active)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if error is not None:
            pulumi.set(__self__, "error", error)
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if record_set_id is not None:
            pulumi.set(__self__, "record_set_id", record_set_id)
        if records is not None:
            pulumi.set(__self__, "records", records)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if the record set is active or not. Defaults to `true`
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "active", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Comment.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter
    def error(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Error shows error in case create/update/delete failed.
        """
        return pulumi.get(self, "error")

    @error.setter
    def error(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "error", value)

    @_builtins.property
    @pulumi.getter
    def fqdn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Fully qualified domain name (FQDN) of the record set.
        """
        return pulumi.get(self, "fqdn")

    @fqdn.setter
    def fqdn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fqdn", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the record which should be a valid domain according to rfc1035 Section 2.3.4. E.g. `example.com`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        STACKIT project ID to which the dns record set is associated.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="recordSetId")
    def record_set_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The rr set id.
        """
        return pulumi.get(self, "record_set_id")

    @record_set_id.setter
    def record_set_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "record_set_id", value)

    @_builtins.property
    @pulumi.getter
    def records(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Records.
        """
        return pulumi.get(self, "records")

    @records.setter
    def records(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "records", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Record set state.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Time to live. E.g. 3600
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ttl", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The record set type. E.g. `A` or `CNAME`
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The zone ID to which is dns record set is associated.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("stackit:index/dnsRecordSet:DnsRecordSet")
class DnsRecordSet(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active: Optional[pulumi.Input[_builtins.bool]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 records: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        DNS Record Set Resource schema.

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] active: Specifies if the record set is active or not. Defaults to `true`
        :param pulumi.Input[_builtins.str] comment: Comment.
        :param pulumi.Input[_builtins.str] name: Name of the record which should be a valid domain according to rfc1035 Section 2.3.4. E.g. `example.com`
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the dns record set is associated.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] records: Records.
        :param pulumi.Input[_builtins.int] ttl: Time to live. E.g. 3600
        :param pulumi.Input[_builtins.str] type: The record set type. E.g. `A` or `CNAME`
        :param pulumi.Input[_builtins.str] zone_id: The zone ID to which is dns record set is associated.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DnsRecordSetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        DNS Record Set Resource schema.

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param DnsRecordSetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DnsRecordSetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active: Optional[pulumi.Input[_builtins.bool]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 records: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DnsRecordSetArgs.__new__(DnsRecordSetArgs)

            __props__.__dict__["active"] = active
            __props__.__dict__["comment"] = comment
            __props__.__dict__["name"] = name
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            if records is None and not opts.urn:
                raise TypeError("Missing required property 'records'")
            __props__.__dict__["records"] = records
            __props__.__dict__["ttl"] = ttl
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            if zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_id'")
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["error"] = None
            __props__.__dict__["fqdn"] = None
            __props__.__dict__["record_set_id"] = None
            __props__.__dict__["state"] = None
        super(DnsRecordSet, __self__).__init__(
            'stackit:index/dnsRecordSet:DnsRecordSet',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            active: Optional[pulumi.Input[_builtins.bool]] = None,
            comment: Optional[pulumi.Input[_builtins.str]] = None,
            error: Optional[pulumi.Input[_builtins.str]] = None,
            fqdn: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            record_set_id: Optional[pulumi.Input[_builtins.str]] = None,
            records: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            ttl: Optional[pulumi.Input[_builtins.int]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            zone_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'DnsRecordSet':
        """
        Get an existing DnsRecordSet resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] active: Specifies if the record set is active or not. Defaults to `true`
        :param pulumi.Input[_builtins.str] comment: Comment.
        :param pulumi.Input[_builtins.str] error: Error shows error in case create/update/delete failed.
        :param pulumi.Input[_builtins.str] fqdn: Fully qualified domain name (FQDN) of the record set.
        :param pulumi.Input[_builtins.str] name: Name of the record which should be a valid domain according to rfc1035 Section 2.3.4. E.g. `example.com`
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the dns record set is associated.
        :param pulumi.Input[_builtins.str] record_set_id: The rr set id.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] records: Records.
        :param pulumi.Input[_builtins.str] state: Record set state.
        :param pulumi.Input[_builtins.int] ttl: Time to live. E.g. 3600
        :param pulumi.Input[_builtins.str] type: The record set type. E.g. `A` or `CNAME`
        :param pulumi.Input[_builtins.str] zone_id: The zone ID to which is dns record set is associated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DnsRecordSetState.__new__(_DnsRecordSetState)

        __props__.__dict__["active"] = active
        __props__.__dict__["comment"] = comment
        __props__.__dict__["error"] = error
        __props__.__dict__["fqdn"] = fqdn
        __props__.__dict__["name"] = name
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["record_set_id"] = record_set_id
        __props__.__dict__["records"] = records
        __props__.__dict__["state"] = state
        __props__.__dict__["ttl"] = ttl
        __props__.__dict__["type"] = type
        __props__.__dict__["zone_id"] = zone_id
        return DnsRecordSet(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def active(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies if the record set is active or not. Defaults to `true`
        """
        return pulumi.get(self, "active")

    @_builtins.property
    @pulumi.getter
    def comment(self) -> pulumi.Output[_builtins.str]:
        """
        Comment.
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter
    def error(self) -> pulumi.Output[_builtins.str]:
        """
        Error shows error in case create/update/delete failed.
        """
        return pulumi.get(self, "error")

    @_builtins.property
    @pulumi.getter
    def fqdn(self) -> pulumi.Output[_builtins.str]:
        """
        Fully qualified domain name (FQDN) of the record set.
        """
        return pulumi.get(self, "fqdn")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the record which should be a valid domain according to rfc1035 Section 2.3.4. E.g. `example.com`
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        STACKIT project ID to which the dns record set is associated.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="recordSetId")
    def record_set_id(self) -> pulumi.Output[_builtins.str]:
        """
        The rr set id.
        """
        return pulumi.get(self, "record_set_id")

    @_builtins.property
    @pulumi.getter
    def records(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Records.
        """
        return pulumi.get(self, "records")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        Record set state.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> pulumi.Output[_builtins.int]:
        """
        Time to live. E.g. 3600
        """
        return pulumi.get(self, "ttl")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The record set type. E.g. `A` or `CNAME`
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        The zone ID to which is dns record set is associated.
        """
        return pulumi.get(self, "zone_id")

