# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['DnsZoneArgs', 'DnsZone']

@pulumi.input_type
class DnsZoneArgs:
    def __init__(__self__, *,
                 dns_name: pulumi.Input[_builtins.str],
                 project_id: pulumi.Input[_builtins.str],
                 acl: Optional[pulumi.Input[_builtins.str]] = None,
                 active: Optional[pulumi.Input[_builtins.bool]] = None,
                 contact_email: Optional[pulumi.Input[_builtins.str]] = None,
                 default_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 expire_time: Optional[pulumi.Input[_builtins.int]] = None,
                 is_reverse_zone: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 negative_cache: Optional[pulumi.Input[_builtins.int]] = None,
                 primaries: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 refresh_time: Optional[pulumi.Input[_builtins.int]] = None,
                 retry_time: Optional[pulumi.Input[_builtins.int]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a DnsZone resource.
        :param pulumi.Input[_builtins.str] dns_name: The zone name. E.g. `example.com`
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the dns zone is associated.
        :param pulumi.Input[_builtins.str] acl: The access control list. E.g. `0.0.0.0/0,::/0`
        :param pulumi.Input[_builtins.str] contact_email: A contact e-mail for the zone.
        :param pulumi.Input[_builtins.int] default_ttl: Default time to live. E.g. 3600.
        :param pulumi.Input[_builtins.str] description: Description of the zone.
        :param pulumi.Input[_builtins.int] expire_time: Expire time. E.g. 1209600.
        :param pulumi.Input[_builtins.bool] is_reverse_zone: Specifies, if the zone is a reverse zone or not. Defaults to `false`
        :param pulumi.Input[_builtins.str] name: The user given name of the zone.
        :param pulumi.Input[_builtins.int] negative_cache: Negative caching. E.g. 60
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] primaries: Primary name server for secondary zone. E.g. ["1.2.3.4"]
        :param pulumi.Input[_builtins.int] refresh_time: Refresh time. E.g. 3600
        :param pulumi.Input[_builtins.int] retry_time: Retry time. E.g. 600
        :param pulumi.Input[_builtins.str] type: Zone type. Defaults to `primary`. Supported values are: `primary`, `secondary`.
        """
        pulumi.set(__self__, "dns_name", dns_name)
        pulumi.set(__self__, "project_id", project_id)
        if acl is not None:
            pulumi.set(__self__, "acl", acl)
        if active is not None:
            pulumi.set(__self__, "active", active)
        if contact_email is not None:
            pulumi.set(__self__, "contact_email", contact_email)
        if default_ttl is not None:
            pulumi.set(__self__, "default_ttl", default_ttl)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expire_time is not None:
            pulumi.set(__self__, "expire_time", expire_time)
        if is_reverse_zone is not None:
            pulumi.set(__self__, "is_reverse_zone", is_reverse_zone)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if negative_cache is not None:
            pulumi.set(__self__, "negative_cache", negative_cache)
        if primaries is not None:
            pulumi.set(__self__, "primaries", primaries)
        if refresh_time is not None:
            pulumi.set(__self__, "refresh_time", refresh_time)
        if retry_time is not None:
            pulumi.set(__self__, "retry_time", retry_time)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> pulumi.Input[_builtins.str]:
        """
        The zone name. E.g. `example.com`
        """
        return pulumi.get(self, "dns_name")

    @dns_name.setter
    def dns_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "dns_name", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.str]:
        """
        STACKIT project ID to which the dns zone is associated.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def acl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The access control list. E.g. `0.0.0.0/0,::/0`
        """
        return pulumi.get(self, "acl")

    @acl.setter
    def acl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "acl", value)

    @_builtins.property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "active", value)

    @_builtins.property
    @pulumi.getter(name="contactEmail")
    def contact_email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A contact e-mail for the zone.
        """
        return pulumi.get(self, "contact_email")

    @contact_email.setter
    def contact_email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "contact_email", value)

    @_builtins.property
    @pulumi.getter(name="defaultTtl")
    def default_ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Default time to live. E.g. 3600.
        """
        return pulumi.get(self, "default_ttl")

    @default_ttl.setter
    def default_ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "default_ttl", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the zone.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Expire time. E.g. 1209600.
        """
        return pulumi.get(self, "expire_time")

    @expire_time.setter
    def expire_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "expire_time", value)

    @_builtins.property
    @pulumi.getter(name="isReverseZone")
    def is_reverse_zone(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies, if the zone is a reverse zone or not. Defaults to `false`
        """
        return pulumi.get(self, "is_reverse_zone")

    @is_reverse_zone.setter
    def is_reverse_zone(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_reverse_zone", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user given name of the zone.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="negativeCache")
    def negative_cache(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Negative caching. E.g. 60
        """
        return pulumi.get(self, "negative_cache")

    @negative_cache.setter
    def negative_cache(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "negative_cache", value)

    @_builtins.property
    @pulumi.getter
    def primaries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Primary name server for secondary zone. E.g. ["1.2.3.4"]
        """
        return pulumi.get(self, "primaries")

    @primaries.setter
    def primaries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "primaries", value)

    @_builtins.property
    @pulumi.getter(name="refreshTime")
    def refresh_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Refresh time. E.g. 3600
        """
        return pulumi.get(self, "refresh_time")

    @refresh_time.setter
    def refresh_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "refresh_time", value)

    @_builtins.property
    @pulumi.getter(name="retryTime")
    def retry_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Retry time. E.g. 600
        """
        return pulumi.get(self, "retry_time")

    @retry_time.setter
    def retry_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "retry_time", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Zone type. Defaults to `primary`. Supported values are: `primary`, `secondary`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _DnsZoneState:
    def __init__(__self__, *,
                 acl: Optional[pulumi.Input[_builtins.str]] = None,
                 active: Optional[pulumi.Input[_builtins.bool]] = None,
                 contact_email: Optional[pulumi.Input[_builtins.str]] = None,
                 default_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_name: Optional[pulumi.Input[_builtins.str]] = None,
                 expire_time: Optional[pulumi.Input[_builtins.int]] = None,
                 is_reverse_zone: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 negative_cache: Optional[pulumi.Input[_builtins.int]] = None,
                 primaries: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 primary_name_server: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 record_count: Optional[pulumi.Input[_builtins.int]] = None,
                 refresh_time: Optional[pulumi.Input[_builtins.int]] = None,
                 retry_time: Optional[pulumi.Input[_builtins.int]] = None,
                 serial_number: Optional[pulumi.Input[_builtins.int]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 visibility: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DnsZone resources.
        :param pulumi.Input[_builtins.str] acl: The access control list. E.g. `0.0.0.0/0,::/0`
        :param pulumi.Input[_builtins.str] contact_email: A contact e-mail for the zone.
        :param pulumi.Input[_builtins.int] default_ttl: Default time to live. E.g. 3600.
        :param pulumi.Input[_builtins.str] description: Description of the zone.
        :param pulumi.Input[_builtins.str] dns_name: The zone name. E.g. `example.com`
        :param pulumi.Input[_builtins.int] expire_time: Expire time. E.g. 1209600.
        :param pulumi.Input[_builtins.bool] is_reverse_zone: Specifies, if the zone is a reverse zone or not. Defaults to `false`
        :param pulumi.Input[_builtins.str] name: The user given name of the zone.
        :param pulumi.Input[_builtins.int] negative_cache: Negative caching. E.g. 60
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] primaries: Primary name server for secondary zone. E.g. ["1.2.3.4"]
        :param pulumi.Input[_builtins.str] primary_name_server: Primary name server. FQDN.
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the dns zone is associated.
        :param pulumi.Input[_builtins.int] record_count: Record count how many records are in the zone.
        :param pulumi.Input[_builtins.int] refresh_time: Refresh time. E.g. 3600
        :param pulumi.Input[_builtins.int] retry_time: Retry time. E.g. 600
        :param pulumi.Input[_builtins.int] serial_number: Serial number. E.g. `2022111400`.
        :param pulumi.Input[_builtins.str] state: Zone state. E.g. `CREATE_SUCCEEDED`.
        :param pulumi.Input[_builtins.str] type: Zone type. Defaults to `primary`. Supported values are: `primary`, `secondary`.
        :param pulumi.Input[_builtins.str] visibility: Visibility of the zone. E.g. `public`.
        :param pulumi.Input[_builtins.str] zone_id: The zone ID.
        """
        if acl is not None:
            pulumi.set(__self__, "acl", acl)
        if active is not None:
            pulumi.set(__self__, "active", active)
        if contact_email is not None:
            pulumi.set(__self__, "contact_email", contact_email)
        if default_ttl is not None:
            pulumi.set(__self__, "default_ttl", default_ttl)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dns_name is not None:
            pulumi.set(__self__, "dns_name", dns_name)
        if expire_time is not None:
            pulumi.set(__self__, "expire_time", expire_time)
        if is_reverse_zone is not None:
            pulumi.set(__self__, "is_reverse_zone", is_reverse_zone)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if negative_cache is not None:
            pulumi.set(__self__, "negative_cache", negative_cache)
        if primaries is not None:
            pulumi.set(__self__, "primaries", primaries)
        if primary_name_server is not None:
            pulumi.set(__self__, "primary_name_server", primary_name_server)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if record_count is not None:
            pulumi.set(__self__, "record_count", record_count)
        if refresh_time is not None:
            pulumi.set(__self__, "refresh_time", refresh_time)
        if retry_time is not None:
            pulumi.set(__self__, "retry_time", retry_time)
        if serial_number is not None:
            pulumi.set(__self__, "serial_number", serial_number)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if visibility is not None:
            pulumi.set(__self__, "visibility", visibility)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter
    def acl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The access control list. E.g. `0.0.0.0/0,::/0`
        """
        return pulumi.get(self, "acl")

    @acl.setter
    def acl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "acl", value)

    @_builtins.property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "active", value)

    @_builtins.property
    @pulumi.getter(name="contactEmail")
    def contact_email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A contact e-mail for the zone.
        """
        return pulumi.get(self, "contact_email")

    @contact_email.setter
    def contact_email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "contact_email", value)

    @_builtins.property
    @pulumi.getter(name="defaultTtl")
    def default_ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Default time to live. E.g. 3600.
        """
        return pulumi.get(self, "default_ttl")

    @default_ttl.setter
    def default_ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "default_ttl", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the zone.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The zone name. E.g. `example.com`
        """
        return pulumi.get(self, "dns_name")

    @dns_name.setter
    def dns_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dns_name", value)

    @_builtins.property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Expire time. E.g. 1209600.
        """
        return pulumi.get(self, "expire_time")

    @expire_time.setter
    def expire_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "expire_time", value)

    @_builtins.property
    @pulumi.getter(name="isReverseZone")
    def is_reverse_zone(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies, if the zone is a reverse zone or not. Defaults to `false`
        """
        return pulumi.get(self, "is_reverse_zone")

    @is_reverse_zone.setter
    def is_reverse_zone(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_reverse_zone", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user given name of the zone.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="negativeCache")
    def negative_cache(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Negative caching. E.g. 60
        """
        return pulumi.get(self, "negative_cache")

    @negative_cache.setter
    def negative_cache(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "negative_cache", value)

    @_builtins.property
    @pulumi.getter
    def primaries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Primary name server for secondary zone. E.g. ["1.2.3.4"]
        """
        return pulumi.get(self, "primaries")

    @primaries.setter
    def primaries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "primaries", value)

    @_builtins.property
    @pulumi.getter(name="primaryNameServer")
    def primary_name_server(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Primary name server. FQDN.
        """
        return pulumi.get(self, "primary_name_server")

    @primary_name_server.setter
    def primary_name_server(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "primary_name_server", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        STACKIT project ID to which the dns zone is associated.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="recordCount")
    def record_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Record count how many records are in the zone.
        """
        return pulumi.get(self, "record_count")

    @record_count.setter
    def record_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "record_count", value)

    @_builtins.property
    @pulumi.getter(name="refreshTime")
    def refresh_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Refresh time. E.g. 3600
        """
        return pulumi.get(self, "refresh_time")

    @refresh_time.setter
    def refresh_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "refresh_time", value)

    @_builtins.property
    @pulumi.getter(name="retryTime")
    def retry_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Retry time. E.g. 600
        """
        return pulumi.get(self, "retry_time")

    @retry_time.setter
    def retry_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "retry_time", value)

    @_builtins.property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Serial number. E.g. `2022111400`.
        """
        return pulumi.get(self, "serial_number")

    @serial_number.setter
    def serial_number(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "serial_number", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Zone state. E.g. `CREATE_SUCCEEDED`.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Zone type. Defaults to `primary`. Supported values are: `primary`, `secondary`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def visibility(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Visibility of the zone. E.g. `public`.
        """
        return pulumi.get(self, "visibility")

    @visibility.setter
    def visibility(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "visibility", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The zone ID.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("stackit:index/dnsZone:DnsZone")
class DnsZone(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl: Optional[pulumi.Input[_builtins.str]] = None,
                 active: Optional[pulumi.Input[_builtins.bool]] = None,
                 contact_email: Optional[pulumi.Input[_builtins.str]] = None,
                 default_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_name: Optional[pulumi.Input[_builtins.str]] = None,
                 expire_time: Optional[pulumi.Input[_builtins.int]] = None,
                 is_reverse_zone: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 negative_cache: Optional[pulumi.Input[_builtins.int]] = None,
                 primaries: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 refresh_time: Optional[pulumi.Input[_builtins.int]] = None,
                 retry_time: Optional[pulumi.Input[_builtins.int]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        DNS Zone resource schema.

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] acl: The access control list. E.g. `0.0.0.0/0,::/0`
        :param pulumi.Input[_builtins.str] contact_email: A contact e-mail for the zone.
        :param pulumi.Input[_builtins.int] default_ttl: Default time to live. E.g. 3600.
        :param pulumi.Input[_builtins.str] description: Description of the zone.
        :param pulumi.Input[_builtins.str] dns_name: The zone name. E.g. `example.com`
        :param pulumi.Input[_builtins.int] expire_time: Expire time. E.g. 1209600.
        :param pulumi.Input[_builtins.bool] is_reverse_zone: Specifies, if the zone is a reverse zone or not. Defaults to `false`
        :param pulumi.Input[_builtins.str] name: The user given name of the zone.
        :param pulumi.Input[_builtins.int] negative_cache: Negative caching. E.g. 60
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] primaries: Primary name server for secondary zone. E.g. ["1.2.3.4"]
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the dns zone is associated.
        :param pulumi.Input[_builtins.int] refresh_time: Refresh time. E.g. 3600
        :param pulumi.Input[_builtins.int] retry_time: Retry time. E.g. 600
        :param pulumi.Input[_builtins.str] type: Zone type. Defaults to `primary`. Supported values are: `primary`, `secondary`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DnsZoneArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        DNS Zone resource schema.

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param DnsZoneArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DnsZoneArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl: Optional[pulumi.Input[_builtins.str]] = None,
                 active: Optional[pulumi.Input[_builtins.bool]] = None,
                 contact_email: Optional[pulumi.Input[_builtins.str]] = None,
                 default_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_name: Optional[pulumi.Input[_builtins.str]] = None,
                 expire_time: Optional[pulumi.Input[_builtins.int]] = None,
                 is_reverse_zone: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 negative_cache: Optional[pulumi.Input[_builtins.int]] = None,
                 primaries: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 refresh_time: Optional[pulumi.Input[_builtins.int]] = None,
                 retry_time: Optional[pulumi.Input[_builtins.int]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DnsZoneArgs.__new__(DnsZoneArgs)

            __props__.__dict__["acl"] = acl
            __props__.__dict__["active"] = active
            __props__.__dict__["contact_email"] = contact_email
            __props__.__dict__["default_ttl"] = default_ttl
            __props__.__dict__["description"] = description
            if dns_name is None and not opts.urn:
                raise TypeError("Missing required property 'dns_name'")
            __props__.__dict__["dns_name"] = dns_name
            __props__.__dict__["expire_time"] = expire_time
            __props__.__dict__["is_reverse_zone"] = is_reverse_zone
            __props__.__dict__["name"] = name
            __props__.__dict__["negative_cache"] = negative_cache
            __props__.__dict__["primaries"] = primaries
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["refresh_time"] = refresh_time
            __props__.__dict__["retry_time"] = retry_time
            __props__.__dict__["type"] = type
            __props__.__dict__["primary_name_server"] = None
            __props__.__dict__["record_count"] = None
            __props__.__dict__["serial_number"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["visibility"] = None
            __props__.__dict__["zone_id"] = None
        super(DnsZone, __self__).__init__(
            'stackit:index/dnsZone:DnsZone',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acl: Optional[pulumi.Input[_builtins.str]] = None,
            active: Optional[pulumi.Input[_builtins.bool]] = None,
            contact_email: Optional[pulumi.Input[_builtins.str]] = None,
            default_ttl: Optional[pulumi.Input[_builtins.int]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            dns_name: Optional[pulumi.Input[_builtins.str]] = None,
            expire_time: Optional[pulumi.Input[_builtins.int]] = None,
            is_reverse_zone: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            negative_cache: Optional[pulumi.Input[_builtins.int]] = None,
            primaries: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            primary_name_server: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            record_count: Optional[pulumi.Input[_builtins.int]] = None,
            refresh_time: Optional[pulumi.Input[_builtins.int]] = None,
            retry_time: Optional[pulumi.Input[_builtins.int]] = None,
            serial_number: Optional[pulumi.Input[_builtins.int]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            visibility: Optional[pulumi.Input[_builtins.str]] = None,
            zone_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'DnsZone':
        """
        Get an existing DnsZone resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] acl: The access control list. E.g. `0.0.0.0/0,::/0`
        :param pulumi.Input[_builtins.str] contact_email: A contact e-mail for the zone.
        :param pulumi.Input[_builtins.int] default_ttl: Default time to live. E.g. 3600.
        :param pulumi.Input[_builtins.str] description: Description of the zone.
        :param pulumi.Input[_builtins.str] dns_name: The zone name. E.g. `example.com`
        :param pulumi.Input[_builtins.int] expire_time: Expire time. E.g. 1209600.
        :param pulumi.Input[_builtins.bool] is_reverse_zone: Specifies, if the zone is a reverse zone or not. Defaults to `false`
        :param pulumi.Input[_builtins.str] name: The user given name of the zone.
        :param pulumi.Input[_builtins.int] negative_cache: Negative caching. E.g. 60
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] primaries: Primary name server for secondary zone. E.g. ["1.2.3.4"]
        :param pulumi.Input[_builtins.str] primary_name_server: Primary name server. FQDN.
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the dns zone is associated.
        :param pulumi.Input[_builtins.int] record_count: Record count how many records are in the zone.
        :param pulumi.Input[_builtins.int] refresh_time: Refresh time. E.g. 3600
        :param pulumi.Input[_builtins.int] retry_time: Retry time. E.g. 600
        :param pulumi.Input[_builtins.int] serial_number: Serial number. E.g. `2022111400`.
        :param pulumi.Input[_builtins.str] state: Zone state. E.g. `CREATE_SUCCEEDED`.
        :param pulumi.Input[_builtins.str] type: Zone type. Defaults to `primary`. Supported values are: `primary`, `secondary`.
        :param pulumi.Input[_builtins.str] visibility: Visibility of the zone. E.g. `public`.
        :param pulumi.Input[_builtins.str] zone_id: The zone ID.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DnsZoneState.__new__(_DnsZoneState)

        __props__.__dict__["acl"] = acl
        __props__.__dict__["active"] = active
        __props__.__dict__["contact_email"] = contact_email
        __props__.__dict__["default_ttl"] = default_ttl
        __props__.__dict__["description"] = description
        __props__.__dict__["dns_name"] = dns_name
        __props__.__dict__["expire_time"] = expire_time
        __props__.__dict__["is_reverse_zone"] = is_reverse_zone
        __props__.__dict__["name"] = name
        __props__.__dict__["negative_cache"] = negative_cache
        __props__.__dict__["primaries"] = primaries
        __props__.__dict__["primary_name_server"] = primary_name_server
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["record_count"] = record_count
        __props__.__dict__["refresh_time"] = refresh_time
        __props__.__dict__["retry_time"] = retry_time
        __props__.__dict__["serial_number"] = serial_number
        __props__.__dict__["state"] = state
        __props__.__dict__["type"] = type
        __props__.__dict__["visibility"] = visibility
        __props__.__dict__["zone_id"] = zone_id
        return DnsZone(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def acl(self) -> pulumi.Output[_builtins.str]:
        """
        The access control list. E.g. `0.0.0.0/0,::/0`
        """
        return pulumi.get(self, "acl")

    @_builtins.property
    @pulumi.getter
    def active(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "active")

    @_builtins.property
    @pulumi.getter(name="contactEmail")
    def contact_email(self) -> pulumi.Output[_builtins.str]:
        """
        A contact e-mail for the zone.
        """
        return pulumi.get(self, "contact_email")

    @_builtins.property
    @pulumi.getter(name="defaultTtl")
    def default_ttl(self) -> pulumi.Output[_builtins.int]:
        """
        Default time to live. E.g. 3600.
        """
        return pulumi.get(self, "default_ttl")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        Description of the zone.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> pulumi.Output[_builtins.str]:
        """
        The zone name. E.g. `example.com`
        """
        return pulumi.get(self, "dns_name")

    @_builtins.property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> pulumi.Output[_builtins.int]:
        """
        Expire time. E.g. 1209600.
        """
        return pulumi.get(self, "expire_time")

    @_builtins.property
    @pulumi.getter(name="isReverseZone")
    def is_reverse_zone(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies, if the zone is a reverse zone or not. Defaults to `false`
        """
        return pulumi.get(self, "is_reverse_zone")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The user given name of the zone.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="negativeCache")
    def negative_cache(self) -> pulumi.Output[_builtins.int]:
        """
        Negative caching. E.g. 60
        """
        return pulumi.get(self, "negative_cache")

    @_builtins.property
    @pulumi.getter
    def primaries(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Primary name server for secondary zone. E.g. ["1.2.3.4"]
        """
        return pulumi.get(self, "primaries")

    @_builtins.property
    @pulumi.getter(name="primaryNameServer")
    def primary_name_server(self) -> pulumi.Output[_builtins.str]:
        """
        Primary name server. FQDN.
        """
        return pulumi.get(self, "primary_name_server")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        STACKIT project ID to which the dns zone is associated.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="recordCount")
    def record_count(self) -> pulumi.Output[_builtins.int]:
        """
        Record count how many records are in the zone.
        """
        return pulumi.get(self, "record_count")

    @_builtins.property
    @pulumi.getter(name="refreshTime")
    def refresh_time(self) -> pulumi.Output[_builtins.int]:
        """
        Refresh time. E.g. 3600
        """
        return pulumi.get(self, "refresh_time")

    @_builtins.property
    @pulumi.getter(name="retryTime")
    def retry_time(self) -> pulumi.Output[_builtins.int]:
        """
        Retry time. E.g. 600
        """
        return pulumi.get(self, "retry_time")

    @_builtins.property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> pulumi.Output[_builtins.int]:
        """
        Serial number. E.g. `2022111400`.
        """
        return pulumi.get(self, "serial_number")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        Zone state. E.g. `CREATE_SUCCEEDED`.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        Zone type. Defaults to `primary`. Supported values are: `primary`, `secondary`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def visibility(self) -> pulumi.Output[_builtins.str]:
        """
        Visibility of the zone. E.g. `public`.
        """
        return pulumi.get(self, "visibility")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        The zone ID.
        """
        return pulumi.get(self, "zone_id")

