# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetCdnCustomDomainResult',
    'AwaitableGetCdnCustomDomainResult',
    'get_cdn_custom_domain',
    'get_cdn_custom_domain_output',
]

@pulumi.output_type
class GetCdnCustomDomainResult:
    """
    A collection of values returned by getCdnCustomDomain.
    """
    def __init__(__self__, distribution_id=None, errors=None, id=None, name=None, project_id=None, status=None):
        if distribution_id and not isinstance(distribution_id, str):
            raise TypeError("Expected argument 'distribution_id' to be a str")
        pulumi.set(__self__, "distribution_id", distribution_id)
        if errors and not isinstance(errors, list):
            raise TypeError("Expected argument 'errors' to be a list")
        pulumi.set(__self__, "errors", errors)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="distributionId")
    def distribution_id(self) -> _builtins.str:
        """
        CDN distribution ID
        """
        return pulumi.get(self, "distribution_id")

    @_builtins.property
    @pulumi.getter
    def errors(self) -> Sequence[_builtins.str]:
        """
        List of distribution errors
        """
        return pulumi.get(self, "errors")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        STACKIT project ID associated with the distribution
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of the distribution
        """
        return pulumi.get(self, "status")


class AwaitableGetCdnCustomDomainResult(GetCdnCustomDomainResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCdnCustomDomainResult(
            distribution_id=self.distribution_id,
            errors=self.errors,
            id=self.id,
            name=self.name,
            project_id=self.project_id,
            status=self.status)


def get_cdn_custom_domain(distribution_id: Optional[_builtins.str] = None,
                          name: Optional[_builtins.str] = None,
                          project_id: Optional[_builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCdnCustomDomainResult:
    """
    CDN distribution data source schema.

    > This datasource is in beta and may be subject to breaking changes in the future. Use with caution. See our guide for how to opt-in to use beta resources.

    ## Example Usage


    :param _builtins.str distribution_id: CDN distribution ID
    :param _builtins.str project_id: STACKIT project ID associated with the distribution
    """
    __args__ = dict()
    __args__['distributionId'] = distribution_id
    __args__['name'] = name
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('stackit:index/getCdnCustomDomain:getCdnCustomDomain', __args__, opts=opts, typ=GetCdnCustomDomainResult).value

    return AwaitableGetCdnCustomDomainResult(
        distribution_id=pulumi.get(__ret__, 'distribution_id'),
        errors=pulumi.get(__ret__, 'errors'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        project_id=pulumi.get(__ret__, 'project_id'),
        status=pulumi.get(__ret__, 'status'))
def get_cdn_custom_domain_output(distribution_id: Optional[pulumi.Input[_builtins.str]] = None,
                                 name: Optional[pulumi.Input[_builtins.str]] = None,
                                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCdnCustomDomainResult]:
    """
    CDN distribution data source schema.

    > This datasource is in beta and may be subject to breaking changes in the future. Use with caution. See our guide for how to opt-in to use beta resources.

    ## Example Usage


    :param _builtins.str distribution_id: CDN distribution ID
    :param _builtins.str project_id: STACKIT project ID associated with the distribution
    """
    __args__ = dict()
    __args__['distributionId'] = distribution_id
    __args__['name'] = name
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('stackit:index/getCdnCustomDomain:getCdnCustomDomain', __args__, opts=opts, typ=GetCdnCustomDomainResult)
    return __ret__.apply(lambda __response__: GetCdnCustomDomainResult(
        distribution_id=pulumi.get(__response__, 'distribution_id'),
        errors=pulumi.get(__response__, 'errors'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        project_id=pulumi.get(__response__, 'project_id'),
        status=pulumi.get(__response__, 'status')))
