# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetCdnDistributionResult',
    'AwaitableGetCdnDistributionResult',
    'get_cdn_distribution',
    'get_cdn_distribution_output',
]

@pulumi.output_type
class GetCdnDistributionResult:
    """
    A collection of values returned by getCdnDistribution.
    """
    def __init__(__self__, config=None, created_at=None, distribution_id=None, domains=None, errors=None, id=None, project_id=None, status=None, updated_at=None):
        if config and not isinstance(config, dict):
            raise TypeError("Expected argument 'config' to be a dict")
        pulumi.set(__self__, "config", config)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if distribution_id and not isinstance(distribution_id, str):
            raise TypeError("Expected argument 'distribution_id' to be a str")
        pulumi.set(__self__, "distribution_id", distribution_id)
        if domains and not isinstance(domains, list):
            raise TypeError("Expected argument 'domains' to be a list")
        pulumi.set(__self__, "domains", domains)
        if errors and not isinstance(errors, list):
            raise TypeError("Expected argument 'errors' to be a list")
        pulumi.set(__self__, "errors", errors)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter
    def config(self) -> 'outputs.GetCdnDistributionConfigResult':
        """
        The distribution configuration
        """
        return pulumi.get(self, "config")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        Time when the distribution was created
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="distributionId")
    def distribution_id(self) -> _builtins.str:
        """
        STACKIT project ID associated with the distribution
        """
        return pulumi.get(self, "distribution_id")

    @_builtins.property
    @pulumi.getter
    def domains(self) -> Sequence['outputs.GetCdnDistributionDomainResult']:
        """
        List of configured domains for the distribution
        """
        return pulumi.get(self, "domains")

    @_builtins.property
    @pulumi.getter
    def errors(self) -> Sequence[_builtins.str]:
        """
        List of distribution errors
        """
        return pulumi.get(self, "errors")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        STACKIT project ID associated with the distribution
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of the distribution
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        """
        Time when the distribution was last updated
        """
        return pulumi.get(self, "updated_at")


class AwaitableGetCdnDistributionResult(GetCdnDistributionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCdnDistributionResult(
            config=self.config,
            created_at=self.created_at,
            distribution_id=self.distribution_id,
            domains=self.domains,
            errors=self.errors,
            id=self.id,
            project_id=self.project_id,
            status=self.status,
            updated_at=self.updated_at)


def get_cdn_distribution(distribution_id: Optional[_builtins.str] = None,
                         project_id: Optional[_builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCdnDistributionResult:
    """
    CDN distribution data source schema.

    > This datasource is in beta and may be subject to breaking changes in the future. Use with caution. See our guide for how to opt-in to use beta resources.

    ## Example Usage


    :param _builtins.str distribution_id: STACKIT project ID associated with the distribution
    :param _builtins.str project_id: STACKIT project ID associated with the distribution
    """
    __args__ = dict()
    __args__['distributionId'] = distribution_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('stackit:index/getCdnDistribution:getCdnDistribution', __args__, opts=opts, typ=GetCdnDistributionResult).value

    return AwaitableGetCdnDistributionResult(
        config=pulumi.get(__ret__, 'config'),
        created_at=pulumi.get(__ret__, 'created_at'),
        distribution_id=pulumi.get(__ret__, 'distribution_id'),
        domains=pulumi.get(__ret__, 'domains'),
        errors=pulumi.get(__ret__, 'errors'),
        id=pulumi.get(__ret__, 'id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        status=pulumi.get(__ret__, 'status'),
        updated_at=pulumi.get(__ret__, 'updated_at'))
def get_cdn_distribution_output(distribution_id: Optional[pulumi.Input[_builtins.str]] = None,
                                project_id: Optional[pulumi.Input[_builtins.str]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCdnDistributionResult]:
    """
    CDN distribution data source schema.

    > This datasource is in beta and may be subject to breaking changes in the future. Use with caution. See our guide for how to opt-in to use beta resources.

    ## Example Usage


    :param _builtins.str distribution_id: STACKIT project ID associated with the distribution
    :param _builtins.str project_id: STACKIT project ID associated with the distribution
    """
    __args__ = dict()
    __args__['distributionId'] = distribution_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('stackit:index/getCdnDistribution:getCdnDistribution', __args__, opts=opts, typ=GetCdnDistributionResult)
    return __ret__.apply(lambda __response__: GetCdnDistributionResult(
        config=pulumi.get(__response__, 'config'),
        created_at=pulumi.get(__response__, 'created_at'),
        distribution_id=pulumi.get(__response__, 'distribution_id'),
        domains=pulumi.get(__response__, 'domains'),
        errors=pulumi.get(__response__, 'errors'),
        id=pulumi.get(__response__, 'id'),
        project_id=pulumi.get(__response__, 'project_id'),
        status=pulumi.get(__response__, 'status'),
        updated_at=pulumi.get(__response__, 'updated_at')))
