# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetDnsRecordSetResult',
    'AwaitableGetDnsRecordSetResult',
    'get_dns_record_set',
    'get_dns_record_set_output',
]

@pulumi.output_type
class GetDnsRecordSetResult:
    """
    A collection of values returned by getDnsRecordSet.
    """
    def __init__(__self__, active=None, comment=None, error=None, fqdn=None, id=None, name=None, project_id=None, record_set_id=None, records=None, state=None, ttl=None, type=None, zone_id=None):
        if active and not isinstance(active, bool):
            raise TypeError("Expected argument 'active' to be a bool")
        pulumi.set(__self__, "active", active)
        if comment and not isinstance(comment, str):
            raise TypeError("Expected argument 'comment' to be a str")
        pulumi.set(__self__, "comment", comment)
        if error and not isinstance(error, str):
            raise TypeError("Expected argument 'error' to be a str")
        pulumi.set(__self__, "error", error)
        if fqdn and not isinstance(fqdn, str):
            raise TypeError("Expected argument 'fqdn' to be a str")
        pulumi.set(__self__, "fqdn", fqdn)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if record_set_id and not isinstance(record_set_id, str):
            raise TypeError("Expected argument 'record_set_id' to be a str")
        pulumi.set(__self__, "record_set_id", record_set_id)
        if records and not isinstance(records, list):
            raise TypeError("Expected argument 'records' to be a list")
        pulumi.set(__self__, "records", records)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if ttl and not isinstance(ttl, int):
            raise TypeError("Expected argument 'ttl' to be a int")
        pulumi.set(__self__, "ttl", ttl)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter
    def active(self) -> _builtins.bool:
        """
        Specifies if the record set is active or not.
        """
        return pulumi.get(self, "active")

    @_builtins.property
    @pulumi.getter
    def comment(self) -> _builtins.str:
        """
        Comment.
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter
    def error(self) -> _builtins.str:
        """
        Error shows error in case create/update/delete failed.
        """
        return pulumi.get(self, "error")

    @_builtins.property
    @pulumi.getter
    def fqdn(self) -> _builtins.str:
        """
        Fully qualified domain name (FQDN) of the record set.
        """
        return pulumi.get(self, "fqdn")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the record which should be a valid domain according to rfc1035 Section 2.3.4. E.g. `example.com`
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        STACKIT project ID to which the dns record set is associated.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="recordSetId")
    def record_set_id(self) -> _builtins.str:
        """
        The rr set id.
        """
        return pulumi.get(self, "record_set_id")

    @_builtins.property
    @pulumi.getter
    def records(self) -> Sequence[_builtins.str]:
        """
        Records.
        """
        return pulumi.get(self, "records")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        Record set state.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> _builtins.int:
        """
        Time to live. E.g. 3600
        """
        return pulumi.get(self, "ttl")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The record set type. E.g. `A` or `CNAME`
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> _builtins.str:
        """
        The zone ID to which is dns record set is associated.
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetDnsRecordSetResult(GetDnsRecordSetResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDnsRecordSetResult(
            active=self.active,
            comment=self.comment,
            error=self.error,
            fqdn=self.fqdn,
            id=self.id,
            name=self.name,
            project_id=self.project_id,
            record_set_id=self.record_set_id,
            records=self.records,
            state=self.state,
            ttl=self.ttl,
            type=self.type,
            zone_id=self.zone_id)


def get_dns_record_set(project_id: Optional[_builtins.str] = None,
                       record_set_id: Optional[_builtins.str] = None,
                       zone_id: Optional[_builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDnsRecordSetResult:
    """
    DNS Record Set Resource schema.

    ## Example Usage


    :param _builtins.str project_id: STACKIT project ID to which the dns record set is associated.
    :param _builtins.str record_set_id: The rr set id.
    :param _builtins.str zone_id: The zone ID to which is dns record set is associated.
    """
    __args__ = dict()
    __args__['projectId'] = project_id
    __args__['recordSetId'] = record_set_id
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('stackit:index/getDnsRecordSet:getDnsRecordSet', __args__, opts=opts, typ=GetDnsRecordSetResult).value

    return AwaitableGetDnsRecordSetResult(
        active=pulumi.get(__ret__, 'active'),
        comment=pulumi.get(__ret__, 'comment'),
        error=pulumi.get(__ret__, 'error'),
        fqdn=pulumi.get(__ret__, 'fqdn'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        project_id=pulumi.get(__ret__, 'project_id'),
        record_set_id=pulumi.get(__ret__, 'record_set_id'),
        records=pulumi.get(__ret__, 'records'),
        state=pulumi.get(__ret__, 'state'),
        ttl=pulumi.get(__ret__, 'ttl'),
        type=pulumi.get(__ret__, 'type'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_dns_record_set_output(project_id: Optional[pulumi.Input[_builtins.str]] = None,
                              record_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                              zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDnsRecordSetResult]:
    """
    DNS Record Set Resource schema.

    ## Example Usage


    :param _builtins.str project_id: STACKIT project ID to which the dns record set is associated.
    :param _builtins.str record_set_id: The rr set id.
    :param _builtins.str zone_id: The zone ID to which is dns record set is associated.
    """
    __args__ = dict()
    __args__['projectId'] = project_id
    __args__['recordSetId'] = record_set_id
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('stackit:index/getDnsRecordSet:getDnsRecordSet', __args__, opts=opts, typ=GetDnsRecordSetResult)
    return __ret__.apply(lambda __response__: GetDnsRecordSetResult(
        active=pulumi.get(__response__, 'active'),
        comment=pulumi.get(__response__, 'comment'),
        error=pulumi.get(__response__, 'error'),
        fqdn=pulumi.get(__response__, 'fqdn'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        project_id=pulumi.get(__response__, 'project_id'),
        record_set_id=pulumi.get(__response__, 'record_set_id'),
        records=pulumi.get(__response__, 'records'),
        state=pulumi.get(__response__, 'state'),
        ttl=pulumi.get(__response__, 'ttl'),
        type=pulumi.get(__response__, 'type'),
        zone_id=pulumi.get(__response__, 'zone_id')))
