# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetDnsZoneResult',
    'AwaitableGetDnsZoneResult',
    'get_dns_zone',
    'get_dns_zone_output',
]

@pulumi.output_type
class GetDnsZoneResult:
    """
    A collection of values returned by getDnsZone.
    """
    def __init__(__self__, acl=None, active=None, contact_email=None, default_ttl=None, description=None, dns_name=None, expire_time=None, id=None, is_reverse_zone=None, name=None, negative_cache=None, primaries=None, primary_name_server=None, project_id=None, record_count=None, refresh_time=None, retry_time=None, serial_number=None, state=None, type=None, visibility=None, zone_id=None):
        if acl and not isinstance(acl, str):
            raise TypeError("Expected argument 'acl' to be a str")
        pulumi.set(__self__, "acl", acl)
        if active and not isinstance(active, bool):
            raise TypeError("Expected argument 'active' to be a bool")
        pulumi.set(__self__, "active", active)
        if contact_email and not isinstance(contact_email, str):
            raise TypeError("Expected argument 'contact_email' to be a str")
        pulumi.set(__self__, "contact_email", contact_email)
        if default_ttl and not isinstance(default_ttl, int):
            raise TypeError("Expected argument 'default_ttl' to be a int")
        pulumi.set(__self__, "default_ttl", default_ttl)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if dns_name and not isinstance(dns_name, str):
            raise TypeError("Expected argument 'dns_name' to be a str")
        pulumi.set(__self__, "dns_name", dns_name)
        if expire_time and not isinstance(expire_time, int):
            raise TypeError("Expected argument 'expire_time' to be a int")
        pulumi.set(__self__, "expire_time", expire_time)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_reverse_zone and not isinstance(is_reverse_zone, bool):
            raise TypeError("Expected argument 'is_reverse_zone' to be a bool")
        pulumi.set(__self__, "is_reverse_zone", is_reverse_zone)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if negative_cache and not isinstance(negative_cache, int):
            raise TypeError("Expected argument 'negative_cache' to be a int")
        pulumi.set(__self__, "negative_cache", negative_cache)
        if primaries and not isinstance(primaries, list):
            raise TypeError("Expected argument 'primaries' to be a list")
        pulumi.set(__self__, "primaries", primaries)
        if primary_name_server and not isinstance(primary_name_server, str):
            raise TypeError("Expected argument 'primary_name_server' to be a str")
        pulumi.set(__self__, "primary_name_server", primary_name_server)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if record_count and not isinstance(record_count, int):
            raise TypeError("Expected argument 'record_count' to be a int")
        pulumi.set(__self__, "record_count", record_count)
        if refresh_time and not isinstance(refresh_time, int):
            raise TypeError("Expected argument 'refresh_time' to be a int")
        pulumi.set(__self__, "refresh_time", refresh_time)
        if retry_time and not isinstance(retry_time, int):
            raise TypeError("Expected argument 'retry_time' to be a int")
        pulumi.set(__self__, "retry_time", retry_time)
        if serial_number and not isinstance(serial_number, int):
            raise TypeError("Expected argument 'serial_number' to be a int")
        pulumi.set(__self__, "serial_number", serial_number)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if visibility and not isinstance(visibility, str):
            raise TypeError("Expected argument 'visibility' to be a str")
        pulumi.set(__self__, "visibility", visibility)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter
    def acl(self) -> _builtins.str:
        """
        The access control list.
        """
        return pulumi.get(self, "acl")

    @_builtins.property
    @pulumi.getter
    def active(self) -> _builtins.bool:
        return pulumi.get(self, "active")

    @_builtins.property
    @pulumi.getter(name="contactEmail")
    def contact_email(self) -> _builtins.str:
        """
        A contact e-mail for the zone.
        """
        return pulumi.get(self, "contact_email")

    @_builtins.property
    @pulumi.getter(name="defaultTtl")
    def default_ttl(self) -> _builtins.int:
        """
        Default time to live.
        """
        return pulumi.get(self, "default_ttl")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the zone.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> Optional[_builtins.str]:
        """
        The zone name. E.g. `example.com`
        """
        return pulumi.get(self, "dns_name")

    @_builtins.property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> _builtins.int:
        """
        Expire time.
        """
        return pulumi.get(self, "expire_time")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isReverseZone")
    def is_reverse_zone(self) -> _builtins.bool:
        """
        Specifies, if the zone is a reverse zone or not.
        """
        return pulumi.get(self, "is_reverse_zone")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The user given name of the zone.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="negativeCache")
    def negative_cache(self) -> _builtins.int:
        """
        Negative caching.
        """
        return pulumi.get(self, "negative_cache")

    @_builtins.property
    @pulumi.getter
    def primaries(self) -> Sequence[_builtins.str]:
        """
        Primary name server for secondary zone.
        """
        return pulumi.get(self, "primaries")

    @_builtins.property
    @pulumi.getter(name="primaryNameServer")
    def primary_name_server(self) -> _builtins.str:
        """
        Primary name server. FQDN.
        """
        return pulumi.get(self, "primary_name_server")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        STACKIT project ID to which the dns zone is associated.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="recordCount")
    def record_count(self) -> _builtins.int:
        """
        Record count how many records are in the zone.
        """
        return pulumi.get(self, "record_count")

    @_builtins.property
    @pulumi.getter(name="refreshTime")
    def refresh_time(self) -> _builtins.int:
        """
        Refresh time.
        """
        return pulumi.get(self, "refresh_time")

    @_builtins.property
    @pulumi.getter(name="retryTime")
    def retry_time(self) -> _builtins.int:
        """
        Retry time.
        """
        return pulumi.get(self, "retry_time")

    @_builtins.property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> _builtins.int:
        """
        Serial number.
        """
        return pulumi.get(self, "serial_number")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        Zone state.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Zone type.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def visibility(self) -> _builtins.str:
        """
        Visibility of the zone.
        """
        return pulumi.get(self, "visibility")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[_builtins.str]:
        """
        The zone ID.
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetDnsZoneResult(GetDnsZoneResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDnsZoneResult(
            acl=self.acl,
            active=self.active,
            contact_email=self.contact_email,
            default_ttl=self.default_ttl,
            description=self.description,
            dns_name=self.dns_name,
            expire_time=self.expire_time,
            id=self.id,
            is_reverse_zone=self.is_reverse_zone,
            name=self.name,
            negative_cache=self.negative_cache,
            primaries=self.primaries,
            primary_name_server=self.primary_name_server,
            project_id=self.project_id,
            record_count=self.record_count,
            refresh_time=self.refresh_time,
            retry_time=self.retry_time,
            serial_number=self.serial_number,
            state=self.state,
            type=self.type,
            visibility=self.visibility,
            zone_id=self.zone_id)


def get_dns_zone(dns_name: Optional[_builtins.str] = None,
                 project_id: Optional[_builtins.str] = None,
                 zone_id: Optional[_builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDnsZoneResult:
    """
    DNS Zone resource schema.

    ## Example Usage


    :param _builtins.str dns_name: The zone name. E.g. `example.com`
    :param _builtins.str project_id: STACKIT project ID to which the dns zone is associated.
    :param _builtins.str zone_id: The zone ID.
    """
    __args__ = dict()
    __args__['dnsName'] = dns_name
    __args__['projectId'] = project_id
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('stackit:index/getDnsZone:getDnsZone', __args__, opts=opts, typ=GetDnsZoneResult).value

    return AwaitableGetDnsZoneResult(
        acl=pulumi.get(__ret__, 'acl'),
        active=pulumi.get(__ret__, 'active'),
        contact_email=pulumi.get(__ret__, 'contact_email'),
        default_ttl=pulumi.get(__ret__, 'default_ttl'),
        description=pulumi.get(__ret__, 'description'),
        dns_name=pulumi.get(__ret__, 'dns_name'),
        expire_time=pulumi.get(__ret__, 'expire_time'),
        id=pulumi.get(__ret__, 'id'),
        is_reverse_zone=pulumi.get(__ret__, 'is_reverse_zone'),
        name=pulumi.get(__ret__, 'name'),
        negative_cache=pulumi.get(__ret__, 'negative_cache'),
        primaries=pulumi.get(__ret__, 'primaries'),
        primary_name_server=pulumi.get(__ret__, 'primary_name_server'),
        project_id=pulumi.get(__ret__, 'project_id'),
        record_count=pulumi.get(__ret__, 'record_count'),
        refresh_time=pulumi.get(__ret__, 'refresh_time'),
        retry_time=pulumi.get(__ret__, 'retry_time'),
        serial_number=pulumi.get(__ret__, 'serial_number'),
        state=pulumi.get(__ret__, 'state'),
        type=pulumi.get(__ret__, 'type'),
        visibility=pulumi.get(__ret__, 'visibility'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_dns_zone_output(dns_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        project_id: Optional[pulumi.Input[_builtins.str]] = None,
                        zone_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDnsZoneResult]:
    """
    DNS Zone resource schema.

    ## Example Usage


    :param _builtins.str dns_name: The zone name. E.g. `example.com`
    :param _builtins.str project_id: STACKIT project ID to which the dns zone is associated.
    :param _builtins.str zone_id: The zone ID.
    """
    __args__ = dict()
    __args__['dnsName'] = dns_name
    __args__['projectId'] = project_id
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('stackit:index/getDnsZone:getDnsZone', __args__, opts=opts, typ=GetDnsZoneResult)
    return __ret__.apply(lambda __response__: GetDnsZoneResult(
        acl=pulumi.get(__response__, 'acl'),
        active=pulumi.get(__response__, 'active'),
        contact_email=pulumi.get(__response__, 'contact_email'),
        default_ttl=pulumi.get(__response__, 'default_ttl'),
        description=pulumi.get(__response__, 'description'),
        dns_name=pulumi.get(__response__, 'dns_name'),
        expire_time=pulumi.get(__response__, 'expire_time'),
        id=pulumi.get(__response__, 'id'),
        is_reverse_zone=pulumi.get(__response__, 'is_reverse_zone'),
        name=pulumi.get(__response__, 'name'),
        negative_cache=pulumi.get(__response__, 'negative_cache'),
        primaries=pulumi.get(__response__, 'primaries'),
        primary_name_server=pulumi.get(__response__, 'primary_name_server'),
        project_id=pulumi.get(__response__, 'project_id'),
        record_count=pulumi.get(__response__, 'record_count'),
        refresh_time=pulumi.get(__response__, 'refresh_time'),
        retry_time=pulumi.get(__response__, 'retry_time'),
        serial_number=pulumi.get(__response__, 'serial_number'),
        state=pulumi.get(__response__, 'state'),
        type=pulumi.get(__response__, 'type'),
        visibility=pulumi.get(__response__, 'visibility'),
        zone_id=pulumi.get(__response__, 'zone_id')))
