# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetGitResult',
    'AwaitableGetGitResult',
    'get_git',
    'get_git_output',
]

@pulumi.output_type
class GetGitResult:
    """
    A collection of values returned by getGit.
    """
    def __init__(__self__, acls=None, consumed_disk=None, consumed_object_storage=None, created=None, flavor=None, id=None, instance_id=None, name=None, project_id=None, url=None, version=None):
        if acls and not isinstance(acls, list):
            raise TypeError("Expected argument 'acls' to be a list")
        pulumi.set(__self__, "acls", acls)
        if consumed_disk and not isinstance(consumed_disk, str):
            raise TypeError("Expected argument 'consumed_disk' to be a str")
        pulumi.set(__self__, "consumed_disk", consumed_disk)
        if consumed_object_storage and not isinstance(consumed_object_storage, str):
            raise TypeError("Expected argument 'consumed_object_storage' to be a str")
        pulumi.set(__self__, "consumed_object_storage", consumed_object_storage)
        if created and not isinstance(created, str):
            raise TypeError("Expected argument 'created' to be a str")
        pulumi.set(__self__, "created", created)
        if flavor and not isinstance(flavor, str):
            raise TypeError("Expected argument 'flavor' to be a str")
        pulumi.set(__self__, "flavor", flavor)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if url and not isinstance(url, str):
            raise TypeError("Expected argument 'url' to be a str")
        pulumi.set(__self__, "url", url)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def acls(self) -> Sequence[_builtins.str]:
        """
        Restricted ACL for instance access.
        """
        return pulumi.get(self, "acls")

    @_builtins.property
    @pulumi.getter(name="consumedDisk")
    def consumed_disk(self) -> _builtins.str:
        """
        How many bytes of disk space is consumed.
        """
        return pulumi.get(self, "consumed_disk")

    @_builtins.property
    @pulumi.getter(name="consumedObjectStorage")
    def consumed_object_storage(self) -> _builtins.str:
        """
        How many bytes of Object Storage is consumed.
        """
        return pulumi.get(self, "consumed_object_storage")

    @_builtins.property
    @pulumi.getter
    def created(self) -> _builtins.str:
        """
        Instance creation timestamp in RFC3339 format.
        """
        return pulumi.get(self, "created")

    @_builtins.property
    @pulumi.getter
    def flavor(self) -> _builtins.str:
        """
        Instance flavor. If not provided, defaults to git-100. For a list of available flavors, refer to our API documentation: `https://docs.api.stackit.cloud/documentation/git/version/v1beta`
        """
        return pulumi.get(self, "flavor")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        ID linked to the git instance.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Unique name linked to the git instance.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        STACKIT project ID to which the git instance is associated.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        Url linked to the git instance.
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        Version linked to the git instance.
        """
        return pulumi.get(self, "version")


class AwaitableGetGitResult(GetGitResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGitResult(
            acls=self.acls,
            consumed_disk=self.consumed_disk,
            consumed_object_storage=self.consumed_object_storage,
            created=self.created,
            flavor=self.flavor,
            id=self.id,
            instance_id=self.instance_id,
            name=self.name,
            project_id=self.project_id,
            url=self.url,
            version=self.version)


def get_git(instance_id: Optional[_builtins.str] = None,
            project_id: Optional[_builtins.str] = None,
            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGitResult:
    """
    Git Instance datasource schema.

    > This datasource is in beta and may be subject to breaking changes in the future. Use with caution. See our guide for how to opt-in to use beta resources.

    ## Example Usage


    :param _builtins.str instance_id: ID linked to the git instance.
    :param _builtins.str project_id: STACKIT project ID to which the git instance is associated.
    """
    __args__ = dict()
    __args__['instanceId'] = instance_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('stackit:index/getGit:getGit', __args__, opts=opts, typ=GetGitResult).value

    return AwaitableGetGitResult(
        acls=pulumi.get(__ret__, 'acls'),
        consumed_disk=pulumi.get(__ret__, 'consumed_disk'),
        consumed_object_storage=pulumi.get(__ret__, 'consumed_object_storage'),
        created=pulumi.get(__ret__, 'created'),
        flavor=pulumi.get(__ret__, 'flavor'),
        id=pulumi.get(__ret__, 'id'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        name=pulumi.get(__ret__, 'name'),
        project_id=pulumi.get(__ret__, 'project_id'),
        url=pulumi.get(__ret__, 'url'),
        version=pulumi.get(__ret__, 'version'))
def get_git_output(instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                   project_id: Optional[pulumi.Input[_builtins.str]] = None,
                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetGitResult]:
    """
    Git Instance datasource schema.

    > This datasource is in beta and may be subject to breaking changes in the future. Use with caution. See our guide for how to opt-in to use beta resources.

    ## Example Usage


    :param _builtins.str instance_id: ID linked to the git instance.
    :param _builtins.str project_id: STACKIT project ID to which the git instance is associated.
    """
    __args__ = dict()
    __args__['instanceId'] = instance_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('stackit:index/getGit:getGit', __args__, opts=opts, typ=GetGitResult)
    return __ret__.apply(lambda __response__: GetGitResult(
        acls=pulumi.get(__response__, 'acls'),
        consumed_disk=pulumi.get(__response__, 'consumed_disk'),
        consumed_object_storage=pulumi.get(__response__, 'consumed_object_storage'),
        created=pulumi.get(__response__, 'created'),
        flavor=pulumi.get(__response__, 'flavor'),
        id=pulumi.get(__response__, 'id'),
        instance_id=pulumi.get(__response__, 'instance_id'),
        name=pulumi.get(__response__, 'name'),
        project_id=pulumi.get(__response__, 'project_id'),
        url=pulumi.get(__response__, 'url'),
        version=pulumi.get(__response__, 'version')))
