# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetImageResult',
    'AwaitableGetImageResult',
    'get_image',
    'get_image_output',
]

@pulumi.output_type
class GetImageResult:
    """
    A collection of values returned by getImage.
    """
    def __init__(__self__, checksum=None, config=None, disk_format=None, id=None, image_id=None, labels=None, min_disk_size=None, min_ram=None, name=None, project_id=None, protected=None, scope=None):
        if checksum and not isinstance(checksum, dict):
            raise TypeError("Expected argument 'checksum' to be a dict")
        pulumi.set(__self__, "checksum", checksum)
        if config and not isinstance(config, dict):
            raise TypeError("Expected argument 'config' to be a dict")
        pulumi.set(__self__, "config", config)
        if disk_format and not isinstance(disk_format, str):
            raise TypeError("Expected argument 'disk_format' to be a str")
        pulumi.set(__self__, "disk_format", disk_format)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if image_id and not isinstance(image_id, str):
            raise TypeError("Expected argument 'image_id' to be a str")
        pulumi.set(__self__, "image_id", image_id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if min_disk_size and not isinstance(min_disk_size, int):
            raise TypeError("Expected argument 'min_disk_size' to be a int")
        pulumi.set(__self__, "min_disk_size", min_disk_size)
        if min_ram and not isinstance(min_ram, int):
            raise TypeError("Expected argument 'min_ram' to be a int")
        pulumi.set(__self__, "min_ram", min_ram)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if protected and not isinstance(protected, bool):
            raise TypeError("Expected argument 'protected' to be a bool")
        pulumi.set(__self__, "protected", protected)
        if scope and not isinstance(scope, str):
            raise TypeError("Expected argument 'scope' to be a str")
        pulumi.set(__self__, "scope", scope)

    @_builtins.property
    @pulumi.getter
    def checksum(self) -> 'outputs.GetImageChecksumResult':
        """
        Representation of an image checksum.
        """
        return pulumi.get(self, "checksum")

    @_builtins.property
    @pulumi.getter
    def config(self) -> 'outputs.GetImageConfigResult':
        """
        Properties to set hardware and scheduling settings for an image.
        """
        return pulumi.get(self, "config")

    @_builtins.property
    @pulumi.getter(name="diskFormat")
    def disk_format(self) -> _builtins.str:
        """
        The disk format of the image.
        """
        return pulumi.get(self, "disk_format")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> _builtins.str:
        """
        The image ID.
        """
        return pulumi.get(self, "image_id")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        """
        Labels are key-value string pairs which can be attached to a resource container
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="minDiskSize")
    def min_disk_size(self) -> _builtins.int:
        """
        The minimum disk size of the image in GB.
        """
        return pulumi.get(self, "min_disk_size")

    @_builtins.property
    @pulumi.getter(name="minRam")
    def min_ram(self) -> _builtins.int:
        """
        The minimum RAM of the image in MB.
        """
        return pulumi.get(self, "min_ram")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the image.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        STACKIT project ID to which the image is associated.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def protected(self) -> _builtins.bool:
        """
        Whether the image is protected.
        """
        return pulumi.get(self, "protected")

    @_builtins.property
    @pulumi.getter
    def scope(self) -> _builtins.str:
        """
        The scope of the image.
        """
        return pulumi.get(self, "scope")


class AwaitableGetImageResult(GetImageResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetImageResult(
            checksum=self.checksum,
            config=self.config,
            disk_format=self.disk_format,
            id=self.id,
            image_id=self.image_id,
            labels=self.labels,
            min_disk_size=self.min_disk_size,
            min_ram=self.min_ram,
            name=self.name,
            project_id=self.project_id,
            protected=self.protected,
            scope=self.scope)


def get_image(image_id: Optional[_builtins.str] = None,
              project_id: Optional[_builtins.str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetImageResult:
    """
    Image datasource schema. Must have a `region` specified in the provider configuration.

    ## Example Usage


    :param _builtins.str image_id: The image ID.
    :param _builtins.str project_id: STACKIT project ID to which the image is associated.
    """
    __args__ = dict()
    __args__['imageId'] = image_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('stackit:index/getImage:getImage', __args__, opts=opts, typ=GetImageResult).value

    return AwaitableGetImageResult(
        checksum=pulumi.get(__ret__, 'checksum'),
        config=pulumi.get(__ret__, 'config'),
        disk_format=pulumi.get(__ret__, 'disk_format'),
        id=pulumi.get(__ret__, 'id'),
        image_id=pulumi.get(__ret__, 'image_id'),
        labels=pulumi.get(__ret__, 'labels'),
        min_disk_size=pulumi.get(__ret__, 'min_disk_size'),
        min_ram=pulumi.get(__ret__, 'min_ram'),
        name=pulumi.get(__ret__, 'name'),
        project_id=pulumi.get(__ret__, 'project_id'),
        protected=pulumi.get(__ret__, 'protected'),
        scope=pulumi.get(__ret__, 'scope'))
def get_image_output(image_id: Optional[pulumi.Input[_builtins.str]] = None,
                     project_id: Optional[pulumi.Input[_builtins.str]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetImageResult]:
    """
    Image datasource schema. Must have a `region` specified in the provider configuration.

    ## Example Usage


    :param _builtins.str image_id: The image ID.
    :param _builtins.str project_id: STACKIT project ID to which the image is associated.
    """
    __args__ = dict()
    __args__['imageId'] = image_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('stackit:index/getImage:getImage', __args__, opts=opts, typ=GetImageResult)
    return __ret__.apply(lambda __response__: GetImageResult(
        checksum=pulumi.get(__response__, 'checksum'),
        config=pulumi.get(__response__, 'config'),
        disk_format=pulumi.get(__response__, 'disk_format'),
        id=pulumi.get(__response__, 'id'),
        image_id=pulumi.get(__response__, 'image_id'),
        labels=pulumi.get(__response__, 'labels'),
        min_disk_size=pulumi.get(__response__, 'min_disk_size'),
        min_ram=pulumi.get(__response__, 'min_ram'),
        name=pulumi.get(__response__, 'name'),
        project_id=pulumi.get(__response__, 'project_id'),
        protected=pulumi.get(__response__, 'protected'),
        scope=pulumi.get(__response__, 'scope')))
