# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetKeyPairResult',
    'AwaitableGetKeyPairResult',
    'get_key_pair',
    'get_key_pair_output',
]

@pulumi.output_type
class GetKeyPairResult:
    """
    A collection of values returned by getKeyPair.
    """
    def __init__(__self__, fingerprint=None, id=None, labels=None, name=None, public_key=None):
        if fingerprint and not isinstance(fingerprint, str):
            raise TypeError("Expected argument 'fingerprint' to be a str")
        pulumi.set(__self__, "fingerprint", fingerprint)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if public_key and not isinstance(public_key, str):
            raise TypeError("Expected argument 'public_key' to be a str")
        pulumi.set(__self__, "public_key", public_key)

    @_builtins.property
    @pulumi.getter
    def fingerprint(self) -> _builtins.str:
        """
        The fingerprint of the public SSH key.
        """
        return pulumi.get(self, "fingerprint")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        """
        Labels are key-value string pairs which can be attached to a resource container.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the SSH key pair.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> _builtins.str:
        """
        A string representation of the public SSH key. E.g., `ssh-rsa <key_data>` or `ssh-ed25519 <key-data>`.
        """
        return pulumi.get(self, "public_key")


class AwaitableGetKeyPairResult(GetKeyPairResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetKeyPairResult(
            fingerprint=self.fingerprint,
            id=self.id,
            labels=self.labels,
            name=self.name,
            public_key=self.public_key)


def get_key_pair(name: Optional[_builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetKeyPairResult:
    """
    Key pair resource schema. Must have a `region` specified in the provider configuration.

    ## Example Usage


    :param _builtins.str name: The name of the SSH key pair.
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('stackit:index/getKeyPair:getKeyPair', __args__, opts=opts, typ=GetKeyPairResult).value

    return AwaitableGetKeyPairResult(
        fingerprint=pulumi.get(__ret__, 'fingerprint'),
        id=pulumi.get(__ret__, 'id'),
        labels=pulumi.get(__ret__, 'labels'),
        name=pulumi.get(__ret__, 'name'),
        public_key=pulumi.get(__ret__, 'public_key'))
def get_key_pair_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetKeyPairResult]:
    """
    Key pair resource schema. Must have a `region` specified in the provider configuration.

    ## Example Usage


    :param _builtins.str name: The name of the SSH key pair.
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('stackit:index/getKeyPair:getKeyPair', __args__, opts=opts, typ=GetKeyPairResult)
    return __ret__.apply(lambda __response__: GetKeyPairResult(
        fingerprint=pulumi.get(__response__, 'fingerprint'),
        id=pulumi.get(__response__, 'id'),
        labels=pulumi.get(__response__, 'labels'),
        name=pulumi.get(__response__, 'name'),
        public_key=pulumi.get(__response__, 'public_key')))
