# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetLoadbalancerResult',
    'AwaitableGetLoadbalancerResult',
    'get_loadbalancer',
    'get_loadbalancer_output',
]

@pulumi.output_type
class GetLoadbalancerResult:
    """
    A collection of values returned by getLoadbalancer.
    """
    def __init__(__self__, external_address=None, id=None, listeners=None, name=None, networks=None, options=None, plan_id=None, private_address=None, project_id=None, region=None, target_pools=None):
        if external_address and not isinstance(external_address, str):
            raise TypeError("Expected argument 'external_address' to be a str")
        pulumi.set(__self__, "external_address", external_address)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if listeners and not isinstance(listeners, list):
            raise TypeError("Expected argument 'listeners' to be a list")
        pulumi.set(__self__, "listeners", listeners)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if networks and not isinstance(networks, list):
            raise TypeError("Expected argument 'networks' to be a list")
        pulumi.set(__self__, "networks", networks)
        if options and not isinstance(options, dict):
            raise TypeError("Expected argument 'options' to be a dict")
        pulumi.set(__self__, "options", options)
        if plan_id and not isinstance(plan_id, str):
            raise TypeError("Expected argument 'plan_id' to be a str")
        pulumi.set(__self__, "plan_id", plan_id)
        if private_address and not isinstance(private_address, str):
            raise TypeError("Expected argument 'private_address' to be a str")
        pulumi.set(__self__, "private_address", private_address)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if target_pools and not isinstance(target_pools, list):
            raise TypeError("Expected argument 'target_pools' to be a list")
        pulumi.set(__self__, "target_pools", target_pools)

    @_builtins.property
    @pulumi.getter(name="externalAddress")
    def external_address(self) -> _builtins.str:
        """
        External Load Balancer IP address where this Load Balancer is exposed.
        """
        return pulumi.get(self, "external_address")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def listeners(self) -> Sequence['outputs.GetLoadbalancerListenerResult']:
        """
        List of all listeners which will accept traffic. Limited to 20.
        """
        return pulumi.get(self, "listeners")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Load balancer name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def networks(self) -> Sequence['outputs.GetLoadbalancerNetworkResult']:
        """
        List of networks that listeners and targets reside in.
        """
        return pulumi.get(self, "networks")

    @_builtins.property
    @pulumi.getter
    def options(self) -> 'outputs.GetLoadbalancerOptionsResult':
        """
        Defines any optional functionality you want to have enabled on your load balancer.
        """
        return pulumi.get(self, "options")

    @_builtins.property
    @pulumi.getter(name="planId")
    def plan_id(self) -> _builtins.str:
        """
        The service plan ID. If not defined, the default service plan is `p10`. Possible values are: `p10`, `p50`, `p250`, `p750`.
        """
        return pulumi.get(self, "plan_id")

    @_builtins.property
    @pulumi.getter(name="privateAddress")
    def private_address(self) -> _builtins.str:
        """
        Transient private Load Balancer IP address. It can change any time.
        """
        return pulumi.get(self, "private_address")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        STACKIT project ID to which the Load Balancer is associated.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        """
        The resource region. If not defined, the provider region is used.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="targetPools")
    def target_pools(self) -> Sequence['outputs.GetLoadbalancerTargetPoolResult']:
        """
        List of all target pools which will be used in the Load Balancer. Limited to 20.
        """
        return pulumi.get(self, "target_pools")


class AwaitableGetLoadbalancerResult(GetLoadbalancerResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLoadbalancerResult(
            external_address=self.external_address,
            id=self.id,
            listeners=self.listeners,
            name=self.name,
            networks=self.networks,
            options=self.options,
            plan_id=self.plan_id,
            private_address=self.private_address,
            project_id=self.project_id,
            region=self.region,
            target_pools=self.target_pools)


def get_loadbalancer(name: Optional[_builtins.str] = None,
                     project_id: Optional[_builtins.str] = None,
                     region: Optional[_builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLoadbalancerResult:
    """
    Load Balancer data source schema. Must have a `region` specified in the provider configuration.

    ## Example Usage


    :param _builtins.str name: Load balancer name.
    :param _builtins.str project_id: STACKIT project ID to which the Load Balancer is associated.
    :param _builtins.str region: The resource region. If not defined, the provider region is used.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['projectId'] = project_id
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('stackit:index/getLoadbalancer:getLoadbalancer', __args__, opts=opts, typ=GetLoadbalancerResult).value

    return AwaitableGetLoadbalancerResult(
        external_address=pulumi.get(__ret__, 'external_address'),
        id=pulumi.get(__ret__, 'id'),
        listeners=pulumi.get(__ret__, 'listeners'),
        name=pulumi.get(__ret__, 'name'),
        networks=pulumi.get(__ret__, 'networks'),
        options=pulumi.get(__ret__, 'options'),
        plan_id=pulumi.get(__ret__, 'plan_id'),
        private_address=pulumi.get(__ret__, 'private_address'),
        project_id=pulumi.get(__ret__, 'project_id'),
        region=pulumi.get(__ret__, 'region'),
        target_pools=pulumi.get(__ret__, 'target_pools'))
def get_loadbalancer_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                            project_id: Optional[pulumi.Input[_builtins.str]] = None,
                            region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLoadbalancerResult]:
    """
    Load Balancer data source schema. Must have a `region` specified in the provider configuration.

    ## Example Usage


    :param _builtins.str name: Load balancer name.
    :param _builtins.str project_id: STACKIT project ID to which the Load Balancer is associated.
    :param _builtins.str region: The resource region. If not defined, the provider region is used.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['projectId'] = project_id
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('stackit:index/getLoadbalancer:getLoadbalancer', __args__, opts=opts, typ=GetLoadbalancerResult)
    return __ret__.apply(lambda __response__: GetLoadbalancerResult(
        external_address=pulumi.get(__response__, 'external_address'),
        id=pulumi.get(__response__, 'id'),
        listeners=pulumi.get(__response__, 'listeners'),
        name=pulumi.get(__response__, 'name'),
        networks=pulumi.get(__response__, 'networks'),
        options=pulumi.get(__response__, 'options'),
        plan_id=pulumi.get(__response__, 'plan_id'),
        private_address=pulumi.get(__response__, 'private_address'),
        project_id=pulumi.get(__response__, 'project_id'),
        region=pulumi.get(__response__, 'region'),
        target_pools=pulumi.get(__response__, 'target_pools')))
