# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetLogmeCredentialResult',
    'AwaitableGetLogmeCredentialResult',
    'get_logme_credential',
    'get_logme_credential_output',
]

@pulumi.output_type
class GetLogmeCredentialResult:
    """
    A collection of values returned by getLogmeCredential.
    """
    def __init__(__self__, credential_id=None, host=None, id=None, instance_id=None, password=None, port=None, project_id=None, uri=None, username=None):
        if credential_id and not isinstance(credential_id, str):
            raise TypeError("Expected argument 'credential_id' to be a str")
        pulumi.set(__self__, "credential_id", credential_id)
        if host and not isinstance(host, str):
            raise TypeError("Expected argument 'host' to be a str")
        pulumi.set(__self__, "host", host)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if password and not isinstance(password, str):
            raise TypeError("Expected argument 'password' to be a str")
        pulumi.set(__self__, "password", password)
        if port and not isinstance(port, int):
            raise TypeError("Expected argument 'port' to be a int")
        pulumi.set(__self__, "port", port)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if uri and not isinstance(uri, str):
            raise TypeError("Expected argument 'uri' to be a str")
        pulumi.set(__self__, "uri", uri)
        if username and not isinstance(username, str):
            raise TypeError("Expected argument 'username' to be a str")
        pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter(name="credentialId")
    def credential_id(self) -> _builtins.str:
        """
        The credential's ID.
        """
        return pulumi.get(self, "credential_id")

    @_builtins.property
    @pulumi.getter
    def host(self) -> _builtins.str:
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        ID of the LogMe instance.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def password(self) -> _builtins.str:
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        STACKIT project ID to which the instance is associated.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def uri(self) -> _builtins.str:
        return pulumi.get(self, "uri")

    @_builtins.property
    @pulumi.getter
    def username(self) -> _builtins.str:
        return pulumi.get(self, "username")


class AwaitableGetLogmeCredentialResult(GetLogmeCredentialResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLogmeCredentialResult(
            credential_id=self.credential_id,
            host=self.host,
            id=self.id,
            instance_id=self.instance_id,
            password=self.password,
            port=self.port,
            project_id=self.project_id,
            uri=self.uri,
            username=self.username)


def get_logme_credential(credential_id: Optional[_builtins.str] = None,
                         instance_id: Optional[_builtins.str] = None,
                         project_id: Optional[_builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLogmeCredentialResult:
    """
    LogMe credential data source schema. Must have a `region` specified in the provider configuration.

    ## Example Usage


    :param _builtins.str credential_id: The credential's ID.
    :param _builtins.str instance_id: ID of the LogMe instance.
    :param _builtins.str project_id: STACKIT project ID to which the instance is associated.
    """
    __args__ = dict()
    __args__['credentialId'] = credential_id
    __args__['instanceId'] = instance_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('stackit:index/getLogmeCredential:getLogmeCredential', __args__, opts=opts, typ=GetLogmeCredentialResult).value

    return AwaitableGetLogmeCredentialResult(
        credential_id=pulumi.get(__ret__, 'credential_id'),
        host=pulumi.get(__ret__, 'host'),
        id=pulumi.get(__ret__, 'id'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        password=pulumi.get(__ret__, 'password'),
        port=pulumi.get(__ret__, 'port'),
        project_id=pulumi.get(__ret__, 'project_id'),
        uri=pulumi.get(__ret__, 'uri'),
        username=pulumi.get(__ret__, 'username'))
def get_logme_credential_output(credential_id: Optional[pulumi.Input[_builtins.str]] = None,
                                instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                                project_id: Optional[pulumi.Input[_builtins.str]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLogmeCredentialResult]:
    """
    LogMe credential data source schema. Must have a `region` specified in the provider configuration.

    ## Example Usage


    :param _builtins.str credential_id: The credential's ID.
    :param _builtins.str instance_id: ID of the LogMe instance.
    :param _builtins.str project_id: STACKIT project ID to which the instance is associated.
    """
    __args__ = dict()
    __args__['credentialId'] = credential_id
    __args__['instanceId'] = instance_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('stackit:index/getLogmeCredential:getLogmeCredential', __args__, opts=opts, typ=GetLogmeCredentialResult)
    return __ret__.apply(lambda __response__: GetLogmeCredentialResult(
        credential_id=pulumi.get(__response__, 'credential_id'),
        host=pulumi.get(__response__, 'host'),
        id=pulumi.get(__response__, 'id'),
        instance_id=pulumi.get(__response__, 'instance_id'),
        password=pulumi.get(__response__, 'password'),
        port=pulumi.get(__response__, 'port'),
        project_id=pulumi.get(__response__, 'project_id'),
        uri=pulumi.get(__response__, 'uri'),
        username=pulumi.get(__response__, 'username')))
