# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetNetworkResult',
    'AwaitableGetNetworkResult',
    'get_network',
    'get_network_output',
]

@pulumi.output_type
class GetNetworkResult:
    """
    A collection of values returned by getNetwork.
    """
    def __init__(__self__, id=None, ipv4_gateway=None, ipv4_nameservers=None, ipv4_prefix=None, ipv4_prefix_length=None, ipv4_prefixes=None, ipv6_gateway=None, ipv6_nameservers=None, ipv6_prefix=None, ipv6_prefix_length=None, ipv6_prefixes=None, labels=None, name=None, nameservers=None, network_id=None, prefixes=None, project_id=None, public_ip=None, region=None, routed=None, routing_table_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ipv4_gateway and not isinstance(ipv4_gateway, str):
            raise TypeError("Expected argument 'ipv4_gateway' to be a str")
        pulumi.set(__self__, "ipv4_gateway", ipv4_gateway)
        if ipv4_nameservers and not isinstance(ipv4_nameservers, list):
            raise TypeError("Expected argument 'ipv4_nameservers' to be a list")
        pulumi.set(__self__, "ipv4_nameservers", ipv4_nameservers)
        if ipv4_prefix and not isinstance(ipv4_prefix, str):
            raise TypeError("Expected argument 'ipv4_prefix' to be a str")
        pulumi.set(__self__, "ipv4_prefix", ipv4_prefix)
        if ipv4_prefix_length and not isinstance(ipv4_prefix_length, int):
            raise TypeError("Expected argument 'ipv4_prefix_length' to be a int")
        pulumi.set(__self__, "ipv4_prefix_length", ipv4_prefix_length)
        if ipv4_prefixes and not isinstance(ipv4_prefixes, list):
            raise TypeError("Expected argument 'ipv4_prefixes' to be a list")
        pulumi.set(__self__, "ipv4_prefixes", ipv4_prefixes)
        if ipv6_gateway and not isinstance(ipv6_gateway, str):
            raise TypeError("Expected argument 'ipv6_gateway' to be a str")
        pulumi.set(__self__, "ipv6_gateway", ipv6_gateway)
        if ipv6_nameservers and not isinstance(ipv6_nameservers, list):
            raise TypeError("Expected argument 'ipv6_nameservers' to be a list")
        pulumi.set(__self__, "ipv6_nameservers", ipv6_nameservers)
        if ipv6_prefix and not isinstance(ipv6_prefix, str):
            raise TypeError("Expected argument 'ipv6_prefix' to be a str")
        pulumi.set(__self__, "ipv6_prefix", ipv6_prefix)
        if ipv6_prefix_length and not isinstance(ipv6_prefix_length, int):
            raise TypeError("Expected argument 'ipv6_prefix_length' to be a int")
        pulumi.set(__self__, "ipv6_prefix_length", ipv6_prefix_length)
        if ipv6_prefixes and not isinstance(ipv6_prefixes, list):
            raise TypeError("Expected argument 'ipv6_prefixes' to be a list")
        pulumi.set(__self__, "ipv6_prefixes", ipv6_prefixes)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if nameservers and not isinstance(nameservers, list):
            raise TypeError("Expected argument 'nameservers' to be a list")
        pulumi.set(__self__, "nameservers", nameservers)
        if network_id and not isinstance(network_id, str):
            raise TypeError("Expected argument 'network_id' to be a str")
        pulumi.set(__self__, "network_id", network_id)
        if prefixes and not isinstance(prefixes, list):
            raise TypeError("Expected argument 'prefixes' to be a list")
        pulumi.set(__self__, "prefixes", prefixes)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if public_ip and not isinstance(public_ip, str):
            raise TypeError("Expected argument 'public_ip' to be a str")
        pulumi.set(__self__, "public_ip", public_ip)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if routed and not isinstance(routed, bool):
            raise TypeError("Expected argument 'routed' to be a bool")
        pulumi.set(__self__, "routed", routed)
        if routing_table_id and not isinstance(routing_table_id, str):
            raise TypeError("Expected argument 'routing_table_id' to be a str")
        pulumi.set(__self__, "routing_table_id", routing_table_id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipv4Gateway")
    def ipv4_gateway(self) -> _builtins.str:
        """
        The IPv4 gateway of a network. If not specified, the first IP of the network will be assigned as the gateway.
        """
        return pulumi.get(self, "ipv4_gateway")

    @_builtins.property
    @pulumi.getter(name="ipv4Nameservers")
    def ipv4_nameservers(self) -> Sequence[_builtins.str]:
        """
        The IPv4 nameservers of the network.
        """
        return pulumi.get(self, "ipv4_nameservers")

    @_builtins.property
    @pulumi.getter(name="ipv4Prefix")
    @_utilities.deprecated("""The API supports reading multiple prefixes. So using the attribute 'ipv4_prefixes` should be preferred. This attribute will be populated with the first element from the list""")
    def ipv4_prefix(self) -> _builtins.str:
        """
        The IPv4 prefix of the network (CIDR).
        """
        return pulumi.get(self, "ipv4_prefix")

    @_builtins.property
    @pulumi.getter(name="ipv4PrefixLength")
    def ipv4_prefix_length(self) -> _builtins.int:
        """
        The IPv4 prefix length of the network.
        """
        return pulumi.get(self, "ipv4_prefix_length")

    @_builtins.property
    @pulumi.getter(name="ipv4Prefixes")
    def ipv4_prefixes(self) -> Sequence[_builtins.str]:
        """
        The IPv4 prefixes of the network.
        """
        return pulumi.get(self, "ipv4_prefixes")

    @_builtins.property
    @pulumi.getter(name="ipv6Gateway")
    def ipv6_gateway(self) -> _builtins.str:
        """
        The IPv6 gateway of a network. If not specified, the first IP of the network will be assigned as the gateway.
        """
        return pulumi.get(self, "ipv6_gateway")

    @_builtins.property
    @pulumi.getter(name="ipv6Nameservers")
    def ipv6_nameservers(self) -> Sequence[_builtins.str]:
        """
        The IPv6 nameservers of the network.
        """
        return pulumi.get(self, "ipv6_nameservers")

    @_builtins.property
    @pulumi.getter(name="ipv6Prefix")
    @_utilities.deprecated("""The API supports reading multiple prefixes. So using the attribute 'ipv6_prefixes` should be preferred. This attribute will be populated with the first element from the list""")
    def ipv6_prefix(self) -> _builtins.str:
        """
        The IPv6 prefix of the network (CIDR).
        """
        return pulumi.get(self, "ipv6_prefix")

    @_builtins.property
    @pulumi.getter(name="ipv6PrefixLength")
    def ipv6_prefix_length(self) -> _builtins.int:
        """
        The IPv6 prefix length of the network.
        """
        return pulumi.get(self, "ipv6_prefix_length")

    @_builtins.property
    @pulumi.getter(name="ipv6Prefixes")
    def ipv6_prefixes(self) -> Sequence[_builtins.str]:
        """
        The IPv6 prefixes of the network.
        """
        return pulumi.get(self, "ipv6_prefixes")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        """
        Labels are key-value string pairs which can be attached to a resource container
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the network.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Use `ipv4_nameservers` to configure the nameservers for IPv4.""")
    def nameservers(self) -> Sequence[_builtins.str]:
        """
        The nameservers of the network. This field is deprecated and will be removed soon, use `ipv4_nameservers` to configure the nameservers for IPv4.
        """
        return pulumi.get(self, "nameservers")

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> _builtins.str:
        """
        The network ID.
        """
        return pulumi.get(self, "network_id")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Use `ipv4_prefixes` to read the prefixes of the IPv4 networks.""")
    def prefixes(self) -> Sequence[_builtins.str]:
        """
        The prefixes of the network. This field is deprecated and will be removed soon, use `ipv4_prefixes` to read the prefixes of the IPv4 networks.
        """
        return pulumi.get(self, "prefixes")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        STACKIT project ID to which the network is associated.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> _builtins.str:
        """
        The public IP of the network.
        """
        return pulumi.get(self, "public_ip")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        """
        Can only be used when experimental "network" is set. This is likely going to undergo significant changes or be removed in the future.
        The resource region. If not defined, the provider region is used.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def routed(self) -> _builtins.bool:
        """
        Shows if the network is routed and therefore accessible from other networks.
        """
        return pulumi.get(self, "routed")

    @_builtins.property
    @pulumi.getter(name="routingTableId")
    def routing_table_id(self) -> _builtins.str:
        """
        Can only be used when experimental "network" is set. This is likely going to undergo significant changes or be removed in the future. Use it at your own discretion.
        The ID of the routing table associated with the network.
        """
        return pulumi.get(self, "routing_table_id")


class AwaitableGetNetworkResult(GetNetworkResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNetworkResult(
            id=self.id,
            ipv4_gateway=self.ipv4_gateway,
            ipv4_nameservers=self.ipv4_nameservers,
            ipv4_prefix=self.ipv4_prefix,
            ipv4_prefix_length=self.ipv4_prefix_length,
            ipv4_prefixes=self.ipv4_prefixes,
            ipv6_gateway=self.ipv6_gateway,
            ipv6_nameservers=self.ipv6_nameservers,
            ipv6_prefix=self.ipv6_prefix,
            ipv6_prefix_length=self.ipv6_prefix_length,
            ipv6_prefixes=self.ipv6_prefixes,
            labels=self.labels,
            name=self.name,
            nameservers=self.nameservers,
            network_id=self.network_id,
            prefixes=self.prefixes,
            project_id=self.project_id,
            public_ip=self.public_ip,
            region=self.region,
            routed=self.routed,
            routing_table_id=self.routing_table_id)


def get_network(network_id: Optional[_builtins.str] = None,
                project_id: Optional[_builtins.str] = None,
                region: Optional[_builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNetworkResult:
    """
    Network resource schema. Must have a `region` specified in the provider configuration.

    ## Example Usage


    :param _builtins.str network_id: The network ID.
    :param _builtins.str project_id: STACKIT project ID to which the network is associated.
    :param _builtins.str region: Can only be used when experimental "network" is set. This is likely going to undergo significant changes or be removed in the future.
           The resource region. If not defined, the provider region is used.
    """
    __args__ = dict()
    __args__['networkId'] = network_id
    __args__['projectId'] = project_id
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('stackit:index/getNetwork:getNetwork', __args__, opts=opts, typ=GetNetworkResult).value

    return AwaitableGetNetworkResult(
        id=pulumi.get(__ret__, 'id'),
        ipv4_gateway=pulumi.get(__ret__, 'ipv4_gateway'),
        ipv4_nameservers=pulumi.get(__ret__, 'ipv4_nameservers'),
        ipv4_prefix=pulumi.get(__ret__, 'ipv4_prefix'),
        ipv4_prefix_length=pulumi.get(__ret__, 'ipv4_prefix_length'),
        ipv4_prefixes=pulumi.get(__ret__, 'ipv4_prefixes'),
        ipv6_gateway=pulumi.get(__ret__, 'ipv6_gateway'),
        ipv6_nameservers=pulumi.get(__ret__, 'ipv6_nameservers'),
        ipv6_prefix=pulumi.get(__ret__, 'ipv6_prefix'),
        ipv6_prefix_length=pulumi.get(__ret__, 'ipv6_prefix_length'),
        ipv6_prefixes=pulumi.get(__ret__, 'ipv6_prefixes'),
        labels=pulumi.get(__ret__, 'labels'),
        name=pulumi.get(__ret__, 'name'),
        nameservers=pulumi.get(__ret__, 'nameservers'),
        network_id=pulumi.get(__ret__, 'network_id'),
        prefixes=pulumi.get(__ret__, 'prefixes'),
        project_id=pulumi.get(__ret__, 'project_id'),
        public_ip=pulumi.get(__ret__, 'public_ip'),
        region=pulumi.get(__ret__, 'region'),
        routed=pulumi.get(__ret__, 'routed'),
        routing_table_id=pulumi.get(__ret__, 'routing_table_id'))
def get_network_output(network_id: Optional[pulumi.Input[_builtins.str]] = None,
                       project_id: Optional[pulumi.Input[_builtins.str]] = None,
                       region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNetworkResult]:
    """
    Network resource schema. Must have a `region` specified in the provider configuration.

    ## Example Usage


    :param _builtins.str network_id: The network ID.
    :param _builtins.str project_id: STACKIT project ID to which the network is associated.
    :param _builtins.str region: Can only be used when experimental "network" is set. This is likely going to undergo significant changes or be removed in the future.
           The resource region. If not defined, the provider region is used.
    """
    __args__ = dict()
    __args__['networkId'] = network_id
    __args__['projectId'] = project_id
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('stackit:index/getNetwork:getNetwork', __args__, opts=opts, typ=GetNetworkResult)
    return __ret__.apply(lambda __response__: GetNetworkResult(
        id=pulumi.get(__response__, 'id'),
        ipv4_gateway=pulumi.get(__response__, 'ipv4_gateway'),
        ipv4_nameservers=pulumi.get(__response__, 'ipv4_nameservers'),
        ipv4_prefix=pulumi.get(__response__, 'ipv4_prefix'),
        ipv4_prefix_length=pulumi.get(__response__, 'ipv4_prefix_length'),
        ipv4_prefixes=pulumi.get(__response__, 'ipv4_prefixes'),
        ipv6_gateway=pulumi.get(__response__, 'ipv6_gateway'),
        ipv6_nameservers=pulumi.get(__response__, 'ipv6_nameservers'),
        ipv6_prefix=pulumi.get(__response__, 'ipv6_prefix'),
        ipv6_prefix_length=pulumi.get(__response__, 'ipv6_prefix_length'),
        ipv6_prefixes=pulumi.get(__response__, 'ipv6_prefixes'),
        labels=pulumi.get(__response__, 'labels'),
        name=pulumi.get(__response__, 'name'),
        nameservers=pulumi.get(__response__, 'nameservers'),
        network_id=pulumi.get(__response__, 'network_id'),
        prefixes=pulumi.get(__response__, 'prefixes'),
        project_id=pulumi.get(__response__, 'project_id'),
        public_ip=pulumi.get(__response__, 'public_ip'),
        region=pulumi.get(__response__, 'region'),
        routed=pulumi.get(__response__, 'routed'),
        routing_table_id=pulumi.get(__response__, 'routing_table_id')))
