# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetNetworkAreaRouteResult',
    'AwaitableGetNetworkAreaRouteResult',
    'get_network_area_route',
    'get_network_area_route_output',
]

@pulumi.output_type
class GetNetworkAreaRouteResult:
    """
    A collection of values returned by getNetworkAreaRoute.
    """
    def __init__(__self__, id=None, labels=None, network_area_id=None, network_area_route_id=None, next_hop=None, organization_id=None, prefix=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if network_area_id and not isinstance(network_area_id, str):
            raise TypeError("Expected argument 'network_area_id' to be a str")
        pulumi.set(__self__, "network_area_id", network_area_id)
        if network_area_route_id and not isinstance(network_area_route_id, str):
            raise TypeError("Expected argument 'network_area_route_id' to be a str")
        pulumi.set(__self__, "network_area_route_id", network_area_route_id)
        if next_hop and not isinstance(next_hop, str):
            raise TypeError("Expected argument 'next_hop' to be a str")
        pulumi.set(__self__, "next_hop", next_hop)
        if organization_id and not isinstance(organization_id, str):
            raise TypeError("Expected argument 'organization_id' to be a str")
        pulumi.set(__self__, "organization_id", organization_id)
        if prefix and not isinstance(prefix, str):
            raise TypeError("Expected argument 'prefix' to be a str")
        pulumi.set(__self__, "prefix", prefix)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        """
        Labels are key-value string pairs which can be attached to a resource container
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="networkAreaId")
    def network_area_id(self) -> _builtins.str:
        """
        The network area ID to which the network area route is associated.
        """
        return pulumi.get(self, "network_area_id")

    @_builtins.property
    @pulumi.getter(name="networkAreaRouteId")
    def network_area_route_id(self) -> _builtins.str:
        """
        The network area route ID.
        """
        return pulumi.get(self, "network_area_route_id")

    @_builtins.property
    @pulumi.getter(name="nextHop")
    def next_hop(self) -> _builtins.str:
        """
        The IP address of the routing system, that will route the prefix configured. Should be a valid IPv4 address.
        """
        return pulumi.get(self, "next_hop")

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> _builtins.str:
        """
        STACKIT organization ID to which the network area is associated.
        """
        return pulumi.get(self, "organization_id")

    @_builtins.property
    @pulumi.getter
    def prefix(self) -> _builtins.str:
        """
        The network, that is reachable though the Next Hop. Should use CIDR notation.
        """
        return pulumi.get(self, "prefix")


class AwaitableGetNetworkAreaRouteResult(GetNetworkAreaRouteResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNetworkAreaRouteResult(
            id=self.id,
            labels=self.labels,
            network_area_id=self.network_area_id,
            network_area_route_id=self.network_area_route_id,
            next_hop=self.next_hop,
            organization_id=self.organization_id,
            prefix=self.prefix)


def get_network_area_route(network_area_id: Optional[_builtins.str] = None,
                           network_area_route_id: Optional[_builtins.str] = None,
                           organization_id: Optional[_builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNetworkAreaRouteResult:
    """
    Network area route data resource schema. Must have a `region` specified in the provider configuration.

    ## Example Usage


    :param _builtins.str network_area_id: The network area ID to which the network area route is associated.
    :param _builtins.str network_area_route_id: The network area route ID.
    :param _builtins.str organization_id: STACKIT organization ID to which the network area is associated.
    """
    __args__ = dict()
    __args__['networkAreaId'] = network_area_id
    __args__['networkAreaRouteId'] = network_area_route_id
    __args__['organizationId'] = organization_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('stackit:index/getNetworkAreaRoute:getNetworkAreaRoute', __args__, opts=opts, typ=GetNetworkAreaRouteResult).value

    return AwaitableGetNetworkAreaRouteResult(
        id=pulumi.get(__ret__, 'id'),
        labels=pulumi.get(__ret__, 'labels'),
        network_area_id=pulumi.get(__ret__, 'network_area_id'),
        network_area_route_id=pulumi.get(__ret__, 'network_area_route_id'),
        next_hop=pulumi.get(__ret__, 'next_hop'),
        organization_id=pulumi.get(__ret__, 'organization_id'),
        prefix=pulumi.get(__ret__, 'prefix'))
def get_network_area_route_output(network_area_id: Optional[pulumi.Input[_builtins.str]] = None,
                                  network_area_route_id: Optional[pulumi.Input[_builtins.str]] = None,
                                  organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNetworkAreaRouteResult]:
    """
    Network area route data resource schema. Must have a `region` specified in the provider configuration.

    ## Example Usage


    :param _builtins.str network_area_id: The network area ID to which the network area route is associated.
    :param _builtins.str network_area_route_id: The network area route ID.
    :param _builtins.str organization_id: STACKIT organization ID to which the network area is associated.
    """
    __args__ = dict()
    __args__['networkAreaId'] = network_area_id
    __args__['networkAreaRouteId'] = network_area_route_id
    __args__['organizationId'] = organization_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('stackit:index/getNetworkAreaRoute:getNetworkAreaRoute', __args__, opts=opts, typ=GetNetworkAreaRouteResult)
    return __ret__.apply(lambda __response__: GetNetworkAreaRouteResult(
        id=pulumi.get(__response__, 'id'),
        labels=pulumi.get(__response__, 'labels'),
        network_area_id=pulumi.get(__response__, 'network_area_id'),
        network_area_route_id=pulumi.get(__response__, 'network_area_route_id'),
        next_hop=pulumi.get(__response__, 'next_hop'),
        organization_id=pulumi.get(__response__, 'organization_id'),
        prefix=pulumi.get(__response__, 'prefix')))
