# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetObservabilityInstanceResult',
    'AwaitableGetObservabilityInstanceResult',
    'get_observability_instance',
    'get_observability_instance_output',
]

@pulumi.output_type
class GetObservabilityInstanceResult:
    """
    A collection of values returned by getObservabilityInstance.
    """
    def __init__(__self__, acls=None, alert_config=None, alerting_url=None, dashboard_url=None, grafana_initial_admin_password=None, grafana_initial_admin_user=None, grafana_public_read_access=None, grafana_url=None, id=None, instance_id=None, is_updatable=None, jaeger_traces_url=None, jaeger_ui_url=None, logs_push_url=None, logs_url=None, metrics_push_url=None, metrics_retention_days=None, metrics_retention_days1h_downsampling=None, metrics_retention_days5m_downsampling=None, metrics_url=None, name=None, otlp_traces_url=None, parameters=None, plan_id=None, plan_name=None, project_id=None, targets_url=None, zipkin_spans_url=None):
        if acls and not isinstance(acls, list):
            raise TypeError("Expected argument 'acls' to be a list")
        pulumi.set(__self__, "acls", acls)
        if alert_config and not isinstance(alert_config, dict):
            raise TypeError("Expected argument 'alert_config' to be a dict")
        pulumi.set(__self__, "alert_config", alert_config)
        if alerting_url and not isinstance(alerting_url, str):
            raise TypeError("Expected argument 'alerting_url' to be a str")
        pulumi.set(__self__, "alerting_url", alerting_url)
        if dashboard_url and not isinstance(dashboard_url, str):
            raise TypeError("Expected argument 'dashboard_url' to be a str")
        pulumi.set(__self__, "dashboard_url", dashboard_url)
        if grafana_initial_admin_password and not isinstance(grafana_initial_admin_password, str):
            raise TypeError("Expected argument 'grafana_initial_admin_password' to be a str")
        pulumi.set(__self__, "grafana_initial_admin_password", grafana_initial_admin_password)
        if grafana_initial_admin_user and not isinstance(grafana_initial_admin_user, str):
            raise TypeError("Expected argument 'grafana_initial_admin_user' to be a str")
        pulumi.set(__self__, "grafana_initial_admin_user", grafana_initial_admin_user)
        if grafana_public_read_access and not isinstance(grafana_public_read_access, bool):
            raise TypeError("Expected argument 'grafana_public_read_access' to be a bool")
        pulumi.set(__self__, "grafana_public_read_access", grafana_public_read_access)
        if grafana_url and not isinstance(grafana_url, str):
            raise TypeError("Expected argument 'grafana_url' to be a str")
        pulumi.set(__self__, "grafana_url", grafana_url)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if is_updatable and not isinstance(is_updatable, bool):
            raise TypeError("Expected argument 'is_updatable' to be a bool")
        pulumi.set(__self__, "is_updatable", is_updatable)
        if jaeger_traces_url and not isinstance(jaeger_traces_url, str):
            raise TypeError("Expected argument 'jaeger_traces_url' to be a str")
        pulumi.set(__self__, "jaeger_traces_url", jaeger_traces_url)
        if jaeger_ui_url and not isinstance(jaeger_ui_url, str):
            raise TypeError("Expected argument 'jaeger_ui_url' to be a str")
        pulumi.set(__self__, "jaeger_ui_url", jaeger_ui_url)
        if logs_push_url and not isinstance(logs_push_url, str):
            raise TypeError("Expected argument 'logs_push_url' to be a str")
        pulumi.set(__self__, "logs_push_url", logs_push_url)
        if logs_url and not isinstance(logs_url, str):
            raise TypeError("Expected argument 'logs_url' to be a str")
        pulumi.set(__self__, "logs_url", logs_url)
        if metrics_push_url and not isinstance(metrics_push_url, str):
            raise TypeError("Expected argument 'metrics_push_url' to be a str")
        pulumi.set(__self__, "metrics_push_url", metrics_push_url)
        if metrics_retention_days and not isinstance(metrics_retention_days, int):
            raise TypeError("Expected argument 'metrics_retention_days' to be a int")
        pulumi.set(__self__, "metrics_retention_days", metrics_retention_days)
        if metrics_retention_days1h_downsampling and not isinstance(metrics_retention_days1h_downsampling, int):
            raise TypeError("Expected argument 'metrics_retention_days1h_downsampling' to be a int")
        pulumi.set(__self__, "metrics_retention_days1h_downsampling", metrics_retention_days1h_downsampling)
        if metrics_retention_days5m_downsampling and not isinstance(metrics_retention_days5m_downsampling, int):
            raise TypeError("Expected argument 'metrics_retention_days5m_downsampling' to be a int")
        pulumi.set(__self__, "metrics_retention_days5m_downsampling", metrics_retention_days5m_downsampling)
        if metrics_url and not isinstance(metrics_url, str):
            raise TypeError("Expected argument 'metrics_url' to be a str")
        pulumi.set(__self__, "metrics_url", metrics_url)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if otlp_traces_url and not isinstance(otlp_traces_url, str):
            raise TypeError("Expected argument 'otlp_traces_url' to be a str")
        pulumi.set(__self__, "otlp_traces_url", otlp_traces_url)
        if parameters and not isinstance(parameters, dict):
            raise TypeError("Expected argument 'parameters' to be a dict")
        pulumi.set(__self__, "parameters", parameters)
        if plan_id and not isinstance(plan_id, str):
            raise TypeError("Expected argument 'plan_id' to be a str")
        pulumi.set(__self__, "plan_id", plan_id)
        if plan_name and not isinstance(plan_name, str):
            raise TypeError("Expected argument 'plan_name' to be a str")
        pulumi.set(__self__, "plan_name", plan_name)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if targets_url and not isinstance(targets_url, str):
            raise TypeError("Expected argument 'targets_url' to be a str")
        pulumi.set(__self__, "targets_url", targets_url)
        if zipkin_spans_url and not isinstance(zipkin_spans_url, str):
            raise TypeError("Expected argument 'zipkin_spans_url' to be a str")
        pulumi.set(__self__, "zipkin_spans_url", zipkin_spans_url)

    @_builtins.property
    @pulumi.getter
    def acls(self) -> Sequence[_builtins.str]:
        """
        The access control list for this instance. Each entry is an IP address range that is permitted to access, in CIDR notation.
        """
        return pulumi.get(self, "acls")

    @_builtins.property
    @pulumi.getter(name="alertConfig")
    def alert_config(self) -> 'outputs.GetObservabilityInstanceAlertConfigResult':
        """
        Alert configuration for the instance.
        """
        return pulumi.get(self, "alert_config")

    @_builtins.property
    @pulumi.getter(name="alertingUrl")
    def alerting_url(self) -> _builtins.str:
        """
        Specifies Alerting URL.
        """
        return pulumi.get(self, "alerting_url")

    @_builtins.property
    @pulumi.getter(name="dashboardUrl")
    def dashboard_url(self) -> _builtins.str:
        """
        Specifies Observability instance dashboard URL.
        """
        return pulumi.get(self, "dashboard_url")

    @_builtins.property
    @pulumi.getter(name="grafanaInitialAdminPassword")
    def grafana_initial_admin_password(self) -> _builtins.str:
        """
        Specifies an initial Grafana admin password.
        """
        return pulumi.get(self, "grafana_initial_admin_password")

    @_builtins.property
    @pulumi.getter(name="grafanaInitialAdminUser")
    def grafana_initial_admin_user(self) -> _builtins.str:
        """
        Specifies an initial Grafana admin username.
        """
        return pulumi.get(self, "grafana_initial_admin_user")

    @_builtins.property
    @pulumi.getter(name="grafanaPublicReadAccess")
    def grafana_public_read_access(self) -> _builtins.bool:
        """
        If true, anyone can access Grafana dashboards without logging in.
        """
        return pulumi.get(self, "grafana_public_read_access")

    @_builtins.property
    @pulumi.getter(name="grafanaUrl")
    def grafana_url(self) -> _builtins.str:
        """
        Specifies Grafana URL.
        """
        return pulumi.get(self, "grafana_url")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        The Observability instance ID.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="isUpdatable")
    def is_updatable(self) -> _builtins.bool:
        """
        Specifies if the instance can be updated.
        """
        return pulumi.get(self, "is_updatable")

    @_builtins.property
    @pulumi.getter(name="jaegerTracesUrl")
    def jaeger_traces_url(self) -> _builtins.str:
        return pulumi.get(self, "jaeger_traces_url")

    @_builtins.property
    @pulumi.getter(name="jaegerUiUrl")
    def jaeger_ui_url(self) -> _builtins.str:
        return pulumi.get(self, "jaeger_ui_url")

    @_builtins.property
    @pulumi.getter(name="logsPushUrl")
    def logs_push_url(self) -> _builtins.str:
        """
        Specifies URL for pushing logs.
        """
        return pulumi.get(self, "logs_push_url")

    @_builtins.property
    @pulumi.getter(name="logsUrl")
    def logs_url(self) -> _builtins.str:
        """
        Specifies Logs URL.
        """
        return pulumi.get(self, "logs_url")

    @_builtins.property
    @pulumi.getter(name="metricsPushUrl")
    def metrics_push_url(self) -> _builtins.str:
        """
        Specifies URL for pushing metrics.
        """
        return pulumi.get(self, "metrics_push_url")

    @_builtins.property
    @pulumi.getter(name="metricsRetentionDays")
    def metrics_retention_days(self) -> _builtins.int:
        """
        Specifies for how many days the raw metrics are kept.
        """
        return pulumi.get(self, "metrics_retention_days")

    @_builtins.property
    @pulumi.getter(name="metricsRetentionDays1hDownsampling")
    def metrics_retention_days1h_downsampling(self) -> _builtins.int:
        """
        Specifies for how many days the 1h downsampled metrics are kept. must be less than the value of the 5m downsampling retention. Default is set to `0` (disabled).
        """
        return pulumi.get(self, "metrics_retention_days1h_downsampling")

    @_builtins.property
    @pulumi.getter(name="metricsRetentionDays5mDownsampling")
    def metrics_retention_days5m_downsampling(self) -> _builtins.int:
        """
        Specifies for how many days the 5m downsampled metrics are kept. must be less than the value of the general retention. Default is set to `0` (disabled).
        """
        return pulumi.get(self, "metrics_retention_days5m_downsampling")

    @_builtins.property
    @pulumi.getter(name="metricsUrl")
    def metrics_url(self) -> _builtins.str:
        """
        Specifies metrics URL.
        """
        return pulumi.get(self, "metrics_url")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Observability instance.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="otlpTracesUrl")
    def otlp_traces_url(self) -> _builtins.str:
        return pulumi.get(self, "otlp_traces_url")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Mapping[str, _builtins.str]:
        """
        Additional parameters.
        """
        return pulumi.get(self, "parameters")

    @_builtins.property
    @pulumi.getter(name="planId")
    def plan_id(self) -> _builtins.str:
        """
        The Observability plan ID.
        """
        return pulumi.get(self, "plan_id")

    @_builtins.property
    @pulumi.getter(name="planName")
    def plan_name(self) -> _builtins.str:
        """
        Specifies the Observability plan. E.g. `Observability-Monitoring-Medium-EU01`.
        """
        return pulumi.get(self, "plan_name")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        STACKIT project ID to which the instance is associated.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="targetsUrl")
    def targets_url(self) -> _builtins.str:
        """
        Specifies Targets URL.
        """
        return pulumi.get(self, "targets_url")

    @_builtins.property
    @pulumi.getter(name="zipkinSpansUrl")
    def zipkin_spans_url(self) -> _builtins.str:
        return pulumi.get(self, "zipkin_spans_url")


class AwaitableGetObservabilityInstanceResult(GetObservabilityInstanceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetObservabilityInstanceResult(
            acls=self.acls,
            alert_config=self.alert_config,
            alerting_url=self.alerting_url,
            dashboard_url=self.dashboard_url,
            grafana_initial_admin_password=self.grafana_initial_admin_password,
            grafana_initial_admin_user=self.grafana_initial_admin_user,
            grafana_public_read_access=self.grafana_public_read_access,
            grafana_url=self.grafana_url,
            id=self.id,
            instance_id=self.instance_id,
            is_updatable=self.is_updatable,
            jaeger_traces_url=self.jaeger_traces_url,
            jaeger_ui_url=self.jaeger_ui_url,
            logs_push_url=self.logs_push_url,
            logs_url=self.logs_url,
            metrics_push_url=self.metrics_push_url,
            metrics_retention_days=self.metrics_retention_days,
            metrics_retention_days1h_downsampling=self.metrics_retention_days1h_downsampling,
            metrics_retention_days5m_downsampling=self.metrics_retention_days5m_downsampling,
            metrics_url=self.metrics_url,
            name=self.name,
            otlp_traces_url=self.otlp_traces_url,
            parameters=self.parameters,
            plan_id=self.plan_id,
            plan_name=self.plan_name,
            project_id=self.project_id,
            targets_url=self.targets_url,
            zipkin_spans_url=self.zipkin_spans_url)


def get_observability_instance(instance_id: Optional[_builtins.str] = None,
                               project_id: Optional[_builtins.str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetObservabilityInstanceResult:
    """
    Observability instance data source schema. Must have a `region` specified in the provider configuration.

    ## Example Usage


    :param _builtins.str instance_id: The Observability instance ID.
    :param _builtins.str project_id: STACKIT project ID to which the instance is associated.
    """
    __args__ = dict()
    __args__['instanceId'] = instance_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('stackit:index/getObservabilityInstance:getObservabilityInstance', __args__, opts=opts, typ=GetObservabilityInstanceResult).value

    return AwaitableGetObservabilityInstanceResult(
        acls=pulumi.get(__ret__, 'acls'),
        alert_config=pulumi.get(__ret__, 'alert_config'),
        alerting_url=pulumi.get(__ret__, 'alerting_url'),
        dashboard_url=pulumi.get(__ret__, 'dashboard_url'),
        grafana_initial_admin_password=pulumi.get(__ret__, 'grafana_initial_admin_password'),
        grafana_initial_admin_user=pulumi.get(__ret__, 'grafana_initial_admin_user'),
        grafana_public_read_access=pulumi.get(__ret__, 'grafana_public_read_access'),
        grafana_url=pulumi.get(__ret__, 'grafana_url'),
        id=pulumi.get(__ret__, 'id'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        is_updatable=pulumi.get(__ret__, 'is_updatable'),
        jaeger_traces_url=pulumi.get(__ret__, 'jaeger_traces_url'),
        jaeger_ui_url=pulumi.get(__ret__, 'jaeger_ui_url'),
        logs_push_url=pulumi.get(__ret__, 'logs_push_url'),
        logs_url=pulumi.get(__ret__, 'logs_url'),
        metrics_push_url=pulumi.get(__ret__, 'metrics_push_url'),
        metrics_retention_days=pulumi.get(__ret__, 'metrics_retention_days'),
        metrics_retention_days1h_downsampling=pulumi.get(__ret__, 'metrics_retention_days1h_downsampling'),
        metrics_retention_days5m_downsampling=pulumi.get(__ret__, 'metrics_retention_days5m_downsampling'),
        metrics_url=pulumi.get(__ret__, 'metrics_url'),
        name=pulumi.get(__ret__, 'name'),
        otlp_traces_url=pulumi.get(__ret__, 'otlp_traces_url'),
        parameters=pulumi.get(__ret__, 'parameters'),
        plan_id=pulumi.get(__ret__, 'plan_id'),
        plan_name=pulumi.get(__ret__, 'plan_name'),
        project_id=pulumi.get(__ret__, 'project_id'),
        targets_url=pulumi.get(__ret__, 'targets_url'),
        zipkin_spans_url=pulumi.get(__ret__, 'zipkin_spans_url'))
def get_observability_instance_output(instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                                      project_id: Optional[pulumi.Input[_builtins.str]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetObservabilityInstanceResult]:
    """
    Observability instance data source schema. Must have a `region` specified in the provider configuration.

    ## Example Usage


    :param _builtins.str instance_id: The Observability instance ID.
    :param _builtins.str project_id: STACKIT project ID to which the instance is associated.
    """
    __args__ = dict()
    __args__['instanceId'] = instance_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('stackit:index/getObservabilityInstance:getObservabilityInstance', __args__, opts=opts, typ=GetObservabilityInstanceResult)
    return __ret__.apply(lambda __response__: GetObservabilityInstanceResult(
        acls=pulumi.get(__response__, 'acls'),
        alert_config=pulumi.get(__response__, 'alert_config'),
        alerting_url=pulumi.get(__response__, 'alerting_url'),
        dashboard_url=pulumi.get(__response__, 'dashboard_url'),
        grafana_initial_admin_password=pulumi.get(__response__, 'grafana_initial_admin_password'),
        grafana_initial_admin_user=pulumi.get(__response__, 'grafana_initial_admin_user'),
        grafana_public_read_access=pulumi.get(__response__, 'grafana_public_read_access'),
        grafana_url=pulumi.get(__response__, 'grafana_url'),
        id=pulumi.get(__response__, 'id'),
        instance_id=pulumi.get(__response__, 'instance_id'),
        is_updatable=pulumi.get(__response__, 'is_updatable'),
        jaeger_traces_url=pulumi.get(__response__, 'jaeger_traces_url'),
        jaeger_ui_url=pulumi.get(__response__, 'jaeger_ui_url'),
        logs_push_url=pulumi.get(__response__, 'logs_push_url'),
        logs_url=pulumi.get(__response__, 'logs_url'),
        metrics_push_url=pulumi.get(__response__, 'metrics_push_url'),
        metrics_retention_days=pulumi.get(__response__, 'metrics_retention_days'),
        metrics_retention_days1h_downsampling=pulumi.get(__response__, 'metrics_retention_days1h_downsampling'),
        metrics_retention_days5m_downsampling=pulumi.get(__response__, 'metrics_retention_days5m_downsampling'),
        metrics_url=pulumi.get(__response__, 'metrics_url'),
        name=pulumi.get(__response__, 'name'),
        otlp_traces_url=pulumi.get(__response__, 'otlp_traces_url'),
        parameters=pulumi.get(__response__, 'parameters'),
        plan_id=pulumi.get(__response__, 'plan_id'),
        plan_name=pulumi.get(__response__, 'plan_name'),
        project_id=pulumi.get(__response__, 'project_id'),
        targets_url=pulumi.get(__response__, 'targets_url'),
        zipkin_spans_url=pulumi.get(__response__, 'zipkin_spans_url')))
