# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetPostgresflexDatabaseResult',
    'AwaitableGetPostgresflexDatabaseResult',
    'get_postgresflex_database',
    'get_postgresflex_database_output',
]

@pulumi.output_type
class GetPostgresflexDatabaseResult:
    """
    A collection of values returned by getPostgresflexDatabase.
    """
    def __init__(__self__, database_id=None, id=None, instance_id=None, name=None, owner=None, project_id=None, region=None):
        if database_id and not isinstance(database_id, str):
            raise TypeError("Expected argument 'database_id' to be a str")
        pulumi.set(__self__, "database_id", database_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if owner and not isinstance(owner, str):
            raise TypeError("Expected argument 'owner' to be a str")
        pulumi.set(__self__, "owner", owner)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> _builtins.str:
        """
        Database ID.
        """
        return pulumi.get(self, "database_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        ID of the Postgres Flex instance.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Database name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def owner(self) -> _builtins.str:
        """
        Username of the database owner.
        """
        return pulumi.get(self, "owner")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        STACKIT project ID to which the instance is associated.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        """
        The resource region. If not defined, the provider region is used.
        """
        return pulumi.get(self, "region")


class AwaitableGetPostgresflexDatabaseResult(GetPostgresflexDatabaseResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPostgresflexDatabaseResult(
            database_id=self.database_id,
            id=self.id,
            instance_id=self.instance_id,
            name=self.name,
            owner=self.owner,
            project_id=self.project_id,
            region=self.region)


def get_postgresflex_database(database_id: Optional[_builtins.str] = None,
                              instance_id: Optional[_builtins.str] = None,
                              project_id: Optional[_builtins.str] = None,
                              region: Optional[_builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPostgresflexDatabaseResult:
    """
    Postgres Flex database resource schema. Must have a `region` specified in the provider configuration.

    ## Example Usage


    :param _builtins.str database_id: Database ID.
    :param _builtins.str instance_id: ID of the Postgres Flex instance.
    :param _builtins.str project_id: STACKIT project ID to which the instance is associated.
    :param _builtins.str region: The resource region. If not defined, the provider region is used.
    """
    __args__ = dict()
    __args__['databaseId'] = database_id
    __args__['instanceId'] = instance_id
    __args__['projectId'] = project_id
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('stackit:index/getPostgresflexDatabase:getPostgresflexDatabase', __args__, opts=opts, typ=GetPostgresflexDatabaseResult).value

    return AwaitableGetPostgresflexDatabaseResult(
        database_id=pulumi.get(__ret__, 'database_id'),
        id=pulumi.get(__ret__, 'id'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        name=pulumi.get(__ret__, 'name'),
        owner=pulumi.get(__ret__, 'owner'),
        project_id=pulumi.get(__ret__, 'project_id'),
        region=pulumi.get(__ret__, 'region'))
def get_postgresflex_database_output(database_id: Optional[pulumi.Input[_builtins.str]] = None,
                                     instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                                     project_id: Optional[pulumi.Input[_builtins.str]] = None,
                                     region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPostgresflexDatabaseResult]:
    """
    Postgres Flex database resource schema. Must have a `region` specified in the provider configuration.

    ## Example Usage


    :param _builtins.str database_id: Database ID.
    :param _builtins.str instance_id: ID of the Postgres Flex instance.
    :param _builtins.str project_id: STACKIT project ID to which the instance is associated.
    :param _builtins.str region: The resource region. If not defined, the provider region is used.
    """
    __args__ = dict()
    __args__['databaseId'] = database_id
    __args__['instanceId'] = instance_id
    __args__['projectId'] = project_id
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('stackit:index/getPostgresflexDatabase:getPostgresflexDatabase', __args__, opts=opts, typ=GetPostgresflexDatabaseResult)
    return __ret__.apply(lambda __response__: GetPostgresflexDatabaseResult(
        database_id=pulumi.get(__response__, 'database_id'),
        id=pulumi.get(__response__, 'id'),
        instance_id=pulumi.get(__response__, 'instance_id'),
        name=pulumi.get(__response__, 'name'),
        owner=pulumi.get(__response__, 'owner'),
        project_id=pulumi.get(__response__, 'project_id'),
        region=pulumi.get(__response__, 'region')))
