# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetPublicIpResult',
    'AwaitableGetPublicIpResult',
    'get_public_ip',
    'get_public_ip_output',
]

@pulumi.output_type
class GetPublicIpResult:
    """
    A collection of values returned by getPublicIp.
    """
    def __init__(__self__, id=None, ip=None, labels=None, network_interface_id=None, project_id=None, public_ip_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ip and not isinstance(ip, str):
            raise TypeError("Expected argument 'ip' to be a str")
        pulumi.set(__self__, "ip", ip)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if network_interface_id and not isinstance(network_interface_id, str):
            raise TypeError("Expected argument 'network_interface_id' to be a str")
        pulumi.set(__self__, "network_interface_id", network_interface_id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if public_ip_id and not isinstance(public_ip_id, str):
            raise TypeError("Expected argument 'public_ip_id' to be a str")
        pulumi.set(__self__, "public_ip_id", public_ip_id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ip(self) -> _builtins.str:
        """
        The IP address.
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        """
        Labels are key-value string pairs which can be attached to a resource container
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="networkInterfaceId")
    def network_interface_id(self) -> _builtins.str:
        """
        Associates the public IP with a network interface or a virtual IP (ID).
        """
        return pulumi.get(self, "network_interface_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        STACKIT project ID to which the public IP is associated.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="publicIpId")
    def public_ip_id(self) -> _builtins.str:
        """
        The public IP ID.
        """
        return pulumi.get(self, "public_ip_id")


class AwaitableGetPublicIpResult(GetPublicIpResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPublicIpResult(
            id=self.id,
            ip=self.ip,
            labels=self.labels,
            network_interface_id=self.network_interface_id,
            project_id=self.project_id,
            public_ip_id=self.public_ip_id)


def get_public_ip(project_id: Optional[_builtins.str] = None,
                  public_ip_id: Optional[_builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPublicIpResult:
    """
    Public IP resource schema. Must have a `region` specified in the provider configuration.

    ## Example Usage


    :param _builtins.str project_id: STACKIT project ID to which the public IP is associated.
    :param _builtins.str public_ip_id: The public IP ID.
    """
    __args__ = dict()
    __args__['projectId'] = project_id
    __args__['publicIpId'] = public_ip_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('stackit:index/getPublicIp:getPublicIp', __args__, opts=opts, typ=GetPublicIpResult).value

    return AwaitableGetPublicIpResult(
        id=pulumi.get(__ret__, 'id'),
        ip=pulumi.get(__ret__, 'ip'),
        labels=pulumi.get(__ret__, 'labels'),
        network_interface_id=pulumi.get(__ret__, 'network_interface_id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        public_ip_id=pulumi.get(__ret__, 'public_ip_id'))
def get_public_ip_output(project_id: Optional[pulumi.Input[_builtins.str]] = None,
                         public_ip_id: Optional[pulumi.Input[_builtins.str]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPublicIpResult]:
    """
    Public IP resource schema. Must have a `region` specified in the provider configuration.

    ## Example Usage


    :param _builtins.str project_id: STACKIT project ID to which the public IP is associated.
    :param _builtins.str public_ip_id: The public IP ID.
    """
    __args__ = dict()
    __args__['projectId'] = project_id
    __args__['publicIpId'] = public_ip_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('stackit:index/getPublicIp:getPublicIp', __args__, opts=opts, typ=GetPublicIpResult)
    return __ret__.apply(lambda __response__: GetPublicIpResult(
        id=pulumi.get(__response__, 'id'),
        ip=pulumi.get(__response__, 'ip'),
        labels=pulumi.get(__response__, 'labels'),
        network_interface_id=pulumi.get(__response__, 'network_interface_id'),
        project_id=pulumi.get(__response__, 'project_id'),
        public_ip_id=pulumi.get(__response__, 'public_ip_id')))
