# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetResourcemanagerProjectResult',
    'AwaitableGetResourcemanagerProjectResult',
    'get_resourcemanager_project',
    'get_resourcemanager_project_output',
]

@pulumi.output_type
class GetResourcemanagerProjectResult:
    """
    A collection of values returned by getResourcemanagerProject.
    """
    def __init__(__self__, container_id=None, id=None, labels=None, name=None, parent_container_id=None, project_id=None):
        if container_id and not isinstance(container_id, str):
            raise TypeError("Expected argument 'container_id' to be a str")
        pulumi.set(__self__, "container_id", container_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if parent_container_id and not isinstance(parent_container_id, str):
            raise TypeError("Expected argument 'parent_container_id' to be a str")
        pulumi.set(__self__, "parent_container_id", parent_container_id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)

    @_builtins.property
    @pulumi.getter(name="containerId")
    def container_id(self) -> Optional[_builtins.str]:
        """
        Project container ID. Globally unique, user-friendly identifier.
        """
        return pulumi.get(self, "container_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        """
        Labels are key-value string pairs which can be attached to a resource container. A label key must match the regex [A-ZÄÜÖa-zäüöß0-9*-]{1,64}. A label value must match the regex ^$|[A-ZÄÜÖa-zäüöß0-9*-]{1,64}
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Project name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="parentContainerId")
    def parent_container_id(self) -> _builtins.str:
        """
        Parent resource identifier. Both container ID (user-friendly) and UUID are supported
        """
        return pulumi.get(self, "parent_container_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[_builtins.str]:
        """
        Project UUID identifier. This is the ID that can be used in most of the other resources to identify the project.
        """
        return pulumi.get(self, "project_id")


class AwaitableGetResourcemanagerProjectResult(GetResourcemanagerProjectResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetResourcemanagerProjectResult(
            container_id=self.container_id,
            id=self.id,
            labels=self.labels,
            name=self.name,
            parent_container_id=self.parent_container_id,
            project_id=self.project_id)


def get_resourcemanager_project(container_id: Optional[_builtins.str] = None,
                                project_id: Optional[_builtins.str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetResourcemanagerProjectResult:
    """
    Resource Manager project data source schema. To identify the project, you need to provider either project_id or container_id. If you provide both, project_id will be used.

    ## Example Usage


    :param _builtins.str container_id: Project container ID. Globally unique, user-friendly identifier.
    :param _builtins.str project_id: Project UUID identifier. This is the ID that can be used in most of the other resources to identify the project.
    """
    __args__ = dict()
    __args__['containerId'] = container_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('stackit:index/getResourcemanagerProject:getResourcemanagerProject', __args__, opts=opts, typ=GetResourcemanagerProjectResult).value

    return AwaitableGetResourcemanagerProjectResult(
        container_id=pulumi.get(__ret__, 'container_id'),
        id=pulumi.get(__ret__, 'id'),
        labels=pulumi.get(__ret__, 'labels'),
        name=pulumi.get(__ret__, 'name'),
        parent_container_id=pulumi.get(__ret__, 'parent_container_id'),
        project_id=pulumi.get(__ret__, 'project_id'))
def get_resourcemanager_project_output(container_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       project_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetResourcemanagerProjectResult]:
    """
    Resource Manager project data source schema. To identify the project, you need to provider either project_id or container_id. If you provide both, project_id will be used.

    ## Example Usage


    :param _builtins.str container_id: Project container ID. Globally unique, user-friendly identifier.
    :param _builtins.str project_id: Project UUID identifier. This is the ID that can be used in most of the other resources to identify the project.
    """
    __args__ = dict()
    __args__['containerId'] = container_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('stackit:index/getResourcemanagerProject:getResourcemanagerProject', __args__, opts=opts, typ=GetResourcemanagerProjectResult)
    return __ret__.apply(lambda __response__: GetResourcemanagerProjectResult(
        container_id=pulumi.get(__response__, 'container_id'),
        id=pulumi.get(__response__, 'id'),
        labels=pulumi.get(__response__, 'labels'),
        name=pulumi.get(__response__, 'name'),
        parent_container_id=pulumi.get(__response__, 'parent_container_id'),
        project_id=pulumi.get(__response__, 'project_id')))
