# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetRoutingTableResult',
    'AwaitableGetRoutingTableResult',
    'get_routing_table',
    'get_routing_table_output',
]

@pulumi.output_type
class GetRoutingTableResult:
    """
    A collection of values returned by getRoutingTable.
    """
    def __init__(__self__, created_at=None, default=None, description=None, id=None, labels=None, name=None, network_area_id=None, organization_id=None, region=None, routing_table_id=None, system_routes=None, updated_at=None):
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if default and not isinstance(default, bool):
            raise TypeError("Expected argument 'default' to be a bool")
        pulumi.set(__self__, "default", default)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if network_area_id and not isinstance(network_area_id, str):
            raise TypeError("Expected argument 'network_area_id' to be a str")
        pulumi.set(__self__, "network_area_id", network_area_id)
        if organization_id and not isinstance(organization_id, str):
            raise TypeError("Expected argument 'organization_id' to be a str")
        pulumi.set(__self__, "organization_id", organization_id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if routing_table_id and not isinstance(routing_table_id, str):
            raise TypeError("Expected argument 'routing_table_id' to be a str")
        pulumi.set(__self__, "routing_table_id", routing_table_id)
        if system_routes and not isinstance(system_routes, bool):
            raise TypeError("Expected argument 'system_routes' to be a bool")
        pulumi.set(__self__, "system_routes", system_routes)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        Date-time when the routing table was created
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def default(self) -> _builtins.bool:
        """
        When true this is the default routing table for this network area. It can't be deleted and is used if the user does not specify it otherwise.
        """
        return pulumi.get(self, "default")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the routing table.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        """
        Labels are key-value string pairs which can be attached to a resource container
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the routing table.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkAreaId")
    def network_area_id(self) -> _builtins.str:
        """
        The network area ID to which the routing table is associated.
        """
        return pulumi.get(self, "network_area_id")

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> _builtins.str:
        """
        STACKIT organization ID to which the routing table is associated.
        """
        return pulumi.get(self, "organization_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        """
        The resource region. If not defined, the provider region is used.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="routingTableId")
    def routing_table_id(self) -> _builtins.str:
        """
        The routing tables ID.
        """
        return pulumi.get(self, "routing_table_id")

    @_builtins.property
    @pulumi.getter(name="systemRoutes")
    def system_routes(self) -> _builtins.bool:
        """
        This controls whether the routes for project-to-project communication are created automatically or not.
        """
        return pulumi.get(self, "system_routes")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        """
        Date-time when the routing table was updated
        """
        return pulumi.get(self, "updated_at")


class AwaitableGetRoutingTableResult(GetRoutingTableResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRoutingTableResult(
            created_at=self.created_at,
            default=self.default,
            description=self.description,
            id=self.id,
            labels=self.labels,
            name=self.name,
            network_area_id=self.network_area_id,
            organization_id=self.organization_id,
            region=self.region,
            routing_table_id=self.routing_table_id,
            system_routes=self.system_routes,
            updated_at=self.updated_at)


def get_routing_table(network_area_id: Optional[_builtins.str] = None,
                      organization_id: Optional[_builtins.str] = None,
                      region: Optional[_builtins.str] = None,
                      routing_table_id: Optional[_builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRoutingTableResult:
    """
    Routing table datasource schema. Must have a `region` specified in the provider configuration.

    > This datasource is part of the routing-tables experiment and is likely going to undergo significant changes or be removed in the future. Use it at your own discretion.

    ## Example Usage


    :param _builtins.str network_area_id: The network area ID to which the routing table is associated.
    :param _builtins.str organization_id: STACKIT organization ID to which the routing table is associated.
    :param _builtins.str region: The resource region. If not defined, the provider region is used.
    :param _builtins.str routing_table_id: The routing tables ID.
    """
    __args__ = dict()
    __args__['networkAreaId'] = network_area_id
    __args__['organizationId'] = organization_id
    __args__['region'] = region
    __args__['routingTableId'] = routing_table_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('stackit:index/getRoutingTable:getRoutingTable', __args__, opts=opts, typ=GetRoutingTableResult).value

    return AwaitableGetRoutingTableResult(
        created_at=pulumi.get(__ret__, 'created_at'),
        default=pulumi.get(__ret__, 'default'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        labels=pulumi.get(__ret__, 'labels'),
        name=pulumi.get(__ret__, 'name'),
        network_area_id=pulumi.get(__ret__, 'network_area_id'),
        organization_id=pulumi.get(__ret__, 'organization_id'),
        region=pulumi.get(__ret__, 'region'),
        routing_table_id=pulumi.get(__ret__, 'routing_table_id'),
        system_routes=pulumi.get(__ret__, 'system_routes'),
        updated_at=pulumi.get(__ret__, 'updated_at'))
def get_routing_table_output(network_area_id: Optional[pulumi.Input[_builtins.str]] = None,
                             organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                             region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             routing_table_id: Optional[pulumi.Input[_builtins.str]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRoutingTableResult]:
    """
    Routing table datasource schema. Must have a `region` specified in the provider configuration.

    > This datasource is part of the routing-tables experiment and is likely going to undergo significant changes or be removed in the future. Use it at your own discretion.

    ## Example Usage


    :param _builtins.str network_area_id: The network area ID to which the routing table is associated.
    :param _builtins.str organization_id: STACKIT organization ID to which the routing table is associated.
    :param _builtins.str region: The resource region. If not defined, the provider region is used.
    :param _builtins.str routing_table_id: The routing tables ID.
    """
    __args__ = dict()
    __args__['networkAreaId'] = network_area_id
    __args__['organizationId'] = organization_id
    __args__['region'] = region
    __args__['routingTableId'] = routing_table_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('stackit:index/getRoutingTable:getRoutingTable', __args__, opts=opts, typ=GetRoutingTableResult)
    return __ret__.apply(lambda __response__: GetRoutingTableResult(
        created_at=pulumi.get(__response__, 'created_at'),
        default=pulumi.get(__response__, 'default'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        labels=pulumi.get(__response__, 'labels'),
        name=pulumi.get(__response__, 'name'),
        network_area_id=pulumi.get(__response__, 'network_area_id'),
        organization_id=pulumi.get(__response__, 'organization_id'),
        region=pulumi.get(__response__, 'region'),
        routing_table_id=pulumi.get(__response__, 'routing_table_id'),
        system_routes=pulumi.get(__response__, 'system_routes'),
        updated_at=pulumi.get(__response__, 'updated_at')))
