# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetRoutingTableRouteResult',
    'AwaitableGetRoutingTableRouteResult',
    'get_routing_table_route',
    'get_routing_table_route_output',
]

@pulumi.output_type
class GetRoutingTableRouteResult:
    """
    A collection of values returned by getRoutingTableRoute.
    """
    def __init__(__self__, created_at=None, destination=None, id=None, labels=None, network_area_id=None, next_hop=None, organization_id=None, region=None, route_id=None, routing_table_id=None, updated_at=None):
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if destination and not isinstance(destination, dict):
            raise TypeError("Expected argument 'destination' to be a dict")
        pulumi.set(__self__, "destination", destination)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if network_area_id and not isinstance(network_area_id, str):
            raise TypeError("Expected argument 'network_area_id' to be a str")
        pulumi.set(__self__, "network_area_id", network_area_id)
        if next_hop and not isinstance(next_hop, dict):
            raise TypeError("Expected argument 'next_hop' to be a dict")
        pulumi.set(__self__, "next_hop", next_hop)
        if organization_id and not isinstance(organization_id, str):
            raise TypeError("Expected argument 'organization_id' to be a str")
        pulumi.set(__self__, "organization_id", organization_id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if route_id and not isinstance(route_id, str):
            raise TypeError("Expected argument 'route_id' to be a str")
        pulumi.set(__self__, "route_id", route_id)
        if routing_table_id and not isinstance(routing_table_id, str):
            raise TypeError("Expected argument 'routing_table_id' to be a str")
        pulumi.set(__self__, "routing_table_id", routing_table_id)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        Date-time when the route was created
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def destination(self) -> 'outputs.GetRoutingTableRouteDestinationResult':
        """
        Destination of the route.
        """
        return pulumi.get(self, "destination")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        """
        Labels are key-value string pairs which can be attached to a resource container
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="networkAreaId")
    def network_area_id(self) -> _builtins.str:
        """
        The network area ID to which the routing table is associated.
        """
        return pulumi.get(self, "network_area_id")

    @_builtins.property
    @pulumi.getter(name="nextHop")
    def next_hop(self) -> 'outputs.GetRoutingTableRouteNextHopResult':
        """
        Next hop destination.
        """
        return pulumi.get(self, "next_hop")

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> _builtins.str:
        """
        STACKIT organization ID to which the routing table is associated.
        """
        return pulumi.get(self, "organization_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        """
        The resource region. If not defined, the provider region is used.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="routeId")
    def route_id(self) -> _builtins.str:
        """
        Route ID.
        """
        return pulumi.get(self, "route_id")

    @_builtins.property
    @pulumi.getter(name="routingTableId")
    def routing_table_id(self) -> _builtins.str:
        """
        The routing tables ID.
        """
        return pulumi.get(self, "routing_table_id")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        """
        Date-time when the route was updated
        """
        return pulumi.get(self, "updated_at")


class AwaitableGetRoutingTableRouteResult(GetRoutingTableRouteResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRoutingTableRouteResult(
            created_at=self.created_at,
            destination=self.destination,
            id=self.id,
            labels=self.labels,
            network_area_id=self.network_area_id,
            next_hop=self.next_hop,
            organization_id=self.organization_id,
            region=self.region,
            route_id=self.route_id,
            routing_table_id=self.routing_table_id,
            updated_at=self.updated_at)


def get_routing_table_route(network_area_id: Optional[_builtins.str] = None,
                            organization_id: Optional[_builtins.str] = None,
                            region: Optional[_builtins.str] = None,
                            route_id: Optional[_builtins.str] = None,
                            routing_table_id: Optional[_builtins.str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRoutingTableRouteResult:
    """
    Routing table route datasource schema. Must have a `region` specified in the provider configuration.

    > This datasource is part of the routing-tables experiment and is likely going to undergo significant changes or be removed in the future. Use it at your own discretion.

    ## Example Usage


    :param _builtins.str network_area_id: The network area ID to which the routing table is associated.
    :param _builtins.str organization_id: STACKIT organization ID to which the routing table is associated.
    :param _builtins.str region: The resource region. If not defined, the provider region is used.
    :param _builtins.str route_id: Route ID.
    :param _builtins.str routing_table_id: The routing tables ID.
    """
    __args__ = dict()
    __args__['networkAreaId'] = network_area_id
    __args__['organizationId'] = organization_id
    __args__['region'] = region
    __args__['routeId'] = route_id
    __args__['routingTableId'] = routing_table_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('stackit:index/getRoutingTableRoute:getRoutingTableRoute', __args__, opts=opts, typ=GetRoutingTableRouteResult).value

    return AwaitableGetRoutingTableRouteResult(
        created_at=pulumi.get(__ret__, 'created_at'),
        destination=pulumi.get(__ret__, 'destination'),
        id=pulumi.get(__ret__, 'id'),
        labels=pulumi.get(__ret__, 'labels'),
        network_area_id=pulumi.get(__ret__, 'network_area_id'),
        next_hop=pulumi.get(__ret__, 'next_hop'),
        organization_id=pulumi.get(__ret__, 'organization_id'),
        region=pulumi.get(__ret__, 'region'),
        route_id=pulumi.get(__ret__, 'route_id'),
        routing_table_id=pulumi.get(__ret__, 'routing_table_id'),
        updated_at=pulumi.get(__ret__, 'updated_at'))
def get_routing_table_route_output(network_area_id: Optional[pulumi.Input[_builtins.str]] = None,
                                   organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                                   region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                   route_id: Optional[pulumi.Input[_builtins.str]] = None,
                                   routing_table_id: Optional[pulumi.Input[_builtins.str]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRoutingTableRouteResult]:
    """
    Routing table route datasource schema. Must have a `region` specified in the provider configuration.

    > This datasource is part of the routing-tables experiment and is likely going to undergo significant changes or be removed in the future. Use it at your own discretion.

    ## Example Usage


    :param _builtins.str network_area_id: The network area ID to which the routing table is associated.
    :param _builtins.str organization_id: STACKIT organization ID to which the routing table is associated.
    :param _builtins.str region: The resource region. If not defined, the provider region is used.
    :param _builtins.str route_id: Route ID.
    :param _builtins.str routing_table_id: The routing tables ID.
    """
    __args__ = dict()
    __args__['networkAreaId'] = network_area_id
    __args__['organizationId'] = organization_id
    __args__['region'] = region
    __args__['routeId'] = route_id
    __args__['routingTableId'] = routing_table_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('stackit:index/getRoutingTableRoute:getRoutingTableRoute', __args__, opts=opts, typ=GetRoutingTableRouteResult)
    return __ret__.apply(lambda __response__: GetRoutingTableRouteResult(
        created_at=pulumi.get(__response__, 'created_at'),
        destination=pulumi.get(__response__, 'destination'),
        id=pulumi.get(__response__, 'id'),
        labels=pulumi.get(__response__, 'labels'),
        network_area_id=pulumi.get(__response__, 'network_area_id'),
        next_hop=pulumi.get(__response__, 'next_hop'),
        organization_id=pulumi.get(__response__, 'organization_id'),
        region=pulumi.get(__response__, 'region'),
        route_id=pulumi.get(__response__, 'route_id'),
        routing_table_id=pulumi.get(__response__, 'routing_table_id'),
        updated_at=pulumi.get(__response__, 'updated_at')))
