# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetRoutingTableRoutesResult',
    'AwaitableGetRoutingTableRoutesResult',
    'get_routing_table_routes',
    'get_routing_table_routes_output',
]

@pulumi.output_type
class GetRoutingTableRoutesResult:
    """
    A collection of values returned by getRoutingTableRoutes.
    """
    def __init__(__self__, id=None, network_area_id=None, organization_id=None, region=None, routes=None, routing_table_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if network_area_id and not isinstance(network_area_id, str):
            raise TypeError("Expected argument 'network_area_id' to be a str")
        pulumi.set(__self__, "network_area_id", network_area_id)
        if organization_id and not isinstance(organization_id, str):
            raise TypeError("Expected argument 'organization_id' to be a str")
        pulumi.set(__self__, "organization_id", organization_id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if routes and not isinstance(routes, list):
            raise TypeError("Expected argument 'routes' to be a list")
        pulumi.set(__self__, "routes", routes)
        if routing_table_id and not isinstance(routing_table_id, str):
            raise TypeError("Expected argument 'routing_table_id' to be a str")
        pulumi.set(__self__, "routing_table_id", routing_table_id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="networkAreaId")
    def network_area_id(self) -> _builtins.str:
        """
        The network area ID to which the routing table is associated.
        """
        return pulumi.get(self, "network_area_id")

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> _builtins.str:
        """
        STACKIT organization ID to which the routing table is associated.
        """
        return pulumi.get(self, "organization_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        """
        The datasource region. If not defined, the provider region is used.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def routes(self) -> Sequence['outputs.GetRoutingTableRoutesRouteResult']:
        """
        List of routes.
        """
        return pulumi.get(self, "routes")

    @_builtins.property
    @pulumi.getter(name="routingTableId")
    def routing_table_id(self) -> _builtins.str:
        """
        The routing tables ID.
        """
        return pulumi.get(self, "routing_table_id")


class AwaitableGetRoutingTableRoutesResult(GetRoutingTableRoutesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRoutingTableRoutesResult(
            id=self.id,
            network_area_id=self.network_area_id,
            organization_id=self.organization_id,
            region=self.region,
            routes=self.routes,
            routing_table_id=self.routing_table_id)


def get_routing_table_routes(network_area_id: Optional[_builtins.str] = None,
                             organization_id: Optional[_builtins.str] = None,
                             region: Optional[_builtins.str] = None,
                             routing_table_id: Optional[_builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRoutingTableRoutesResult:
    """
    Routing table routes datasource schema. Must have a `region` specified in the provider configuration.

    > This datasource is part of the routing-tables experiment and is likely going to undergo significant changes or be removed in the future. Use it at your own discretion.

    ## Example Usage


    :param _builtins.str network_area_id: The network area ID to which the routing table is associated.
    :param _builtins.str organization_id: STACKIT organization ID to which the routing table is associated.
    :param _builtins.str region: The datasource region. If not defined, the provider region is used.
    :param _builtins.str routing_table_id: The routing tables ID.
    """
    __args__ = dict()
    __args__['networkAreaId'] = network_area_id
    __args__['organizationId'] = organization_id
    __args__['region'] = region
    __args__['routingTableId'] = routing_table_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('stackit:index/getRoutingTableRoutes:getRoutingTableRoutes', __args__, opts=opts, typ=GetRoutingTableRoutesResult).value

    return AwaitableGetRoutingTableRoutesResult(
        id=pulumi.get(__ret__, 'id'),
        network_area_id=pulumi.get(__ret__, 'network_area_id'),
        organization_id=pulumi.get(__ret__, 'organization_id'),
        region=pulumi.get(__ret__, 'region'),
        routes=pulumi.get(__ret__, 'routes'),
        routing_table_id=pulumi.get(__ret__, 'routing_table_id'))
def get_routing_table_routes_output(network_area_id: Optional[pulumi.Input[_builtins.str]] = None,
                                    organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                                    region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                    routing_table_id: Optional[pulumi.Input[_builtins.str]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRoutingTableRoutesResult]:
    """
    Routing table routes datasource schema. Must have a `region` specified in the provider configuration.

    > This datasource is part of the routing-tables experiment and is likely going to undergo significant changes or be removed in the future. Use it at your own discretion.

    ## Example Usage


    :param _builtins.str network_area_id: The network area ID to which the routing table is associated.
    :param _builtins.str organization_id: STACKIT organization ID to which the routing table is associated.
    :param _builtins.str region: The datasource region. If not defined, the provider region is used.
    :param _builtins.str routing_table_id: The routing tables ID.
    """
    __args__ = dict()
    __args__['networkAreaId'] = network_area_id
    __args__['organizationId'] = organization_id
    __args__['region'] = region
    __args__['routingTableId'] = routing_table_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('stackit:index/getRoutingTableRoutes:getRoutingTableRoutes', __args__, opts=opts, typ=GetRoutingTableRoutesResult)
    return __ret__.apply(lambda __response__: GetRoutingTableRoutesResult(
        id=pulumi.get(__response__, 'id'),
        network_area_id=pulumi.get(__response__, 'network_area_id'),
        organization_id=pulumi.get(__response__, 'organization_id'),
        region=pulumi.get(__response__, 'region'),
        routes=pulumi.get(__response__, 'routes'),
        routing_table_id=pulumi.get(__response__, 'routing_table_id')))
