# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetSecretsmanagerInstanceResult',
    'AwaitableGetSecretsmanagerInstanceResult',
    'get_secretsmanager_instance',
    'get_secretsmanager_instance_output',
]

@pulumi.output_type
class GetSecretsmanagerInstanceResult:
    """
    A collection of values returned by getSecretsmanagerInstance.
    """
    def __init__(__self__, acls=None, id=None, instance_id=None, name=None, project_id=None):
        if acls and not isinstance(acls, list):
            raise TypeError("Expected argument 'acls' to be a list")
        pulumi.set(__self__, "acls", acls)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)

    @_builtins.property
    @pulumi.getter
    def acls(self) -> Sequence[_builtins.str]:
        """
        The access control list for this instance. Each entry is an IP or IP range that is permitted to access, in CIDR notation
        """
        return pulumi.get(self, "acls")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        ID of the Secrets Manager instance.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Instance name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        STACKIT project ID to which the instance is associated.
        """
        return pulumi.get(self, "project_id")


class AwaitableGetSecretsmanagerInstanceResult(GetSecretsmanagerInstanceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSecretsmanagerInstanceResult(
            acls=self.acls,
            id=self.id,
            instance_id=self.instance_id,
            name=self.name,
            project_id=self.project_id)


def get_secretsmanager_instance(instance_id: Optional[_builtins.str] = None,
                                project_id: Optional[_builtins.str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSecretsmanagerInstanceResult:
    """
    Secrets Manager instance data source schema. Must have a `region` specified in the provider configuration.

    ## Example Usage


    :param _builtins.str instance_id: ID of the Secrets Manager instance.
    :param _builtins.str project_id: STACKIT project ID to which the instance is associated.
    """
    __args__ = dict()
    __args__['instanceId'] = instance_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('stackit:index/getSecretsmanagerInstance:getSecretsmanagerInstance', __args__, opts=opts, typ=GetSecretsmanagerInstanceResult).value

    return AwaitableGetSecretsmanagerInstanceResult(
        acls=pulumi.get(__ret__, 'acls'),
        id=pulumi.get(__ret__, 'id'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        name=pulumi.get(__ret__, 'name'),
        project_id=pulumi.get(__ret__, 'project_id'))
def get_secretsmanager_instance_output(instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                                       project_id: Optional[pulumi.Input[_builtins.str]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSecretsmanagerInstanceResult]:
    """
    Secrets Manager instance data source schema. Must have a `region` specified in the provider configuration.

    ## Example Usage


    :param _builtins.str instance_id: ID of the Secrets Manager instance.
    :param _builtins.str project_id: STACKIT project ID to which the instance is associated.
    """
    __args__ = dict()
    __args__['instanceId'] = instance_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('stackit:index/getSecretsmanagerInstance:getSecretsmanagerInstance', __args__, opts=opts, typ=GetSecretsmanagerInstanceResult)
    return __ret__.apply(lambda __response__: GetSecretsmanagerInstanceResult(
        acls=pulumi.get(__response__, 'acls'),
        id=pulumi.get(__response__, 'id'),
        instance_id=pulumi.get(__response__, 'instance_id'),
        name=pulumi.get(__response__, 'name'),
        project_id=pulumi.get(__response__, 'project_id')))
