# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetSecretsmanagerUserResult',
    'AwaitableGetSecretsmanagerUserResult',
    'get_secretsmanager_user',
    'get_secretsmanager_user_output',
]

@pulumi.output_type
class GetSecretsmanagerUserResult:
    """
    A collection of values returned by getSecretsmanagerUser.
    """
    def __init__(__self__, description=None, id=None, instance_id=None, project_id=None, user_id=None, username=None, write_enabled=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if user_id and not isinstance(user_id, str):
            raise TypeError("Expected argument 'user_id' to be a str")
        pulumi.set(__self__, "user_id", user_id)
        if username and not isinstance(username, str):
            raise TypeError("Expected argument 'username' to be a str")
        pulumi.set(__self__, "username", username)
        if write_enabled and not isinstance(write_enabled, bool):
            raise TypeError("Expected argument 'write_enabled' to be a bool")
        pulumi.set(__self__, "write_enabled", write_enabled)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        A user chosen description to differentiate between multiple users. Can't be changed after creation.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        ID of the Secrets Manager instance.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        STACKIT Project ID to which the instance is associated.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> _builtins.str:
        """
        The user's ID.
        """
        return pulumi.get(self, "user_id")

    @_builtins.property
    @pulumi.getter
    def username(self) -> _builtins.str:
        """
        An auto-generated user name.
        """
        return pulumi.get(self, "username")

    @_builtins.property
    @pulumi.getter(name="writeEnabled")
    def write_enabled(self) -> _builtins.bool:
        """
        If true, the user has writeaccess to the secrets engine.
        """
        return pulumi.get(self, "write_enabled")


class AwaitableGetSecretsmanagerUserResult(GetSecretsmanagerUserResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSecretsmanagerUserResult(
            description=self.description,
            id=self.id,
            instance_id=self.instance_id,
            project_id=self.project_id,
            user_id=self.user_id,
            username=self.username,
            write_enabled=self.write_enabled)


def get_secretsmanager_user(instance_id: Optional[_builtins.str] = None,
                            project_id: Optional[_builtins.str] = None,
                            user_id: Optional[_builtins.str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSecretsmanagerUserResult:
    """
    Secrets Manager user data source schema. Must have a `region` specified in the provider configuration.

    ## Example Usage


    :param _builtins.str instance_id: ID of the Secrets Manager instance.
    :param _builtins.str project_id: STACKIT Project ID to which the instance is associated.
    :param _builtins.str user_id: The user's ID.
    """
    __args__ = dict()
    __args__['instanceId'] = instance_id
    __args__['projectId'] = project_id
    __args__['userId'] = user_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('stackit:index/getSecretsmanagerUser:getSecretsmanagerUser', __args__, opts=opts, typ=GetSecretsmanagerUserResult).value

    return AwaitableGetSecretsmanagerUserResult(
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        user_id=pulumi.get(__ret__, 'user_id'),
        username=pulumi.get(__ret__, 'username'),
        write_enabled=pulumi.get(__ret__, 'write_enabled'))
def get_secretsmanager_user_output(instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                                   project_id: Optional[pulumi.Input[_builtins.str]] = None,
                                   user_id: Optional[pulumi.Input[_builtins.str]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSecretsmanagerUserResult]:
    """
    Secrets Manager user data source schema. Must have a `region` specified in the provider configuration.

    ## Example Usage


    :param _builtins.str instance_id: ID of the Secrets Manager instance.
    :param _builtins.str project_id: STACKIT Project ID to which the instance is associated.
    :param _builtins.str user_id: The user's ID.
    """
    __args__ = dict()
    __args__['instanceId'] = instance_id
    __args__['projectId'] = project_id
    __args__['userId'] = user_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('stackit:index/getSecretsmanagerUser:getSecretsmanagerUser', __args__, opts=opts, typ=GetSecretsmanagerUserResult)
    return __ret__.apply(lambda __response__: GetSecretsmanagerUserResult(
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        instance_id=pulumi.get(__response__, 'instance_id'),
        project_id=pulumi.get(__response__, 'project_id'),
        user_id=pulumi.get(__response__, 'user_id'),
        username=pulumi.get(__response__, 'username'),
        write_enabled=pulumi.get(__response__, 'write_enabled')))
