# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetSecurityGroupResult',
    'AwaitableGetSecurityGroupResult',
    'get_security_group',
    'get_security_group_output',
]

@pulumi.output_type
class GetSecurityGroupResult:
    """
    A collection of values returned by getSecurityGroup.
    """
    def __init__(__self__, description=None, id=None, labels=None, name=None, project_id=None, security_group_id=None, stateful=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if security_group_id and not isinstance(security_group_id, str):
            raise TypeError("Expected argument 'security_group_id' to be a str")
        pulumi.set(__self__, "security_group_id", security_group_id)
        if stateful and not isinstance(stateful, bool):
            raise TypeError("Expected argument 'stateful' to be a bool")
        pulumi.set(__self__, "stateful", stateful)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the security group.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        """
        Labels are key-value string pairs which can be attached to a resource container
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the security group.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        STACKIT project ID to which the security group is associated.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> _builtins.str:
        """
        The security group ID.
        """
        return pulumi.get(self, "security_group_id")

    @_builtins.property
    @pulumi.getter
    def stateful(self) -> _builtins.bool:
        """
        Configures if a security group is stateful or stateless. There can only be one type of security groups per network interface/server.
        """
        return pulumi.get(self, "stateful")


class AwaitableGetSecurityGroupResult(GetSecurityGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSecurityGroupResult(
            description=self.description,
            id=self.id,
            labels=self.labels,
            name=self.name,
            project_id=self.project_id,
            security_group_id=self.security_group_id,
            stateful=self.stateful)


def get_security_group(project_id: Optional[_builtins.str] = None,
                       security_group_id: Optional[_builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSecurityGroupResult:
    """
    Security group datasource schema. Must have a `region` specified in the provider configuration.

    ## Example Usage


    :param _builtins.str project_id: STACKIT project ID to which the security group is associated.
    :param _builtins.str security_group_id: The security group ID.
    """
    __args__ = dict()
    __args__['projectId'] = project_id
    __args__['securityGroupId'] = security_group_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('stackit:index/getSecurityGroup:getSecurityGroup', __args__, opts=opts, typ=GetSecurityGroupResult).value

    return AwaitableGetSecurityGroupResult(
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        labels=pulumi.get(__ret__, 'labels'),
        name=pulumi.get(__ret__, 'name'),
        project_id=pulumi.get(__ret__, 'project_id'),
        security_group_id=pulumi.get(__ret__, 'security_group_id'),
        stateful=pulumi.get(__ret__, 'stateful'))
def get_security_group_output(project_id: Optional[pulumi.Input[_builtins.str]] = None,
                              security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSecurityGroupResult]:
    """
    Security group datasource schema. Must have a `region` specified in the provider configuration.

    ## Example Usage


    :param _builtins.str project_id: STACKIT project ID to which the security group is associated.
    :param _builtins.str security_group_id: The security group ID.
    """
    __args__ = dict()
    __args__['projectId'] = project_id
    __args__['securityGroupId'] = security_group_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('stackit:index/getSecurityGroup:getSecurityGroup', __args__, opts=opts, typ=GetSecurityGroupResult)
    return __ret__.apply(lambda __response__: GetSecurityGroupResult(
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        labels=pulumi.get(__response__, 'labels'),
        name=pulumi.get(__response__, 'name'),
        project_id=pulumi.get(__response__, 'project_id'),
        security_group_id=pulumi.get(__response__, 'security_group_id'),
        stateful=pulumi.get(__response__, 'stateful')))
