# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetSecurityGroupRuleResult',
    'AwaitableGetSecurityGroupRuleResult',
    'get_security_group_rule',
    'get_security_group_rule_output',
]

@pulumi.output_type
class GetSecurityGroupRuleResult:
    """
    A collection of values returned by getSecurityGroupRule.
    """
    def __init__(__self__, description=None, direction=None, ether_type=None, icmp_parameters=None, id=None, ip_range=None, port_range=None, project_id=None, protocol=None, remote_security_group_id=None, security_group_id=None, security_group_rule_id=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if direction and not isinstance(direction, str):
            raise TypeError("Expected argument 'direction' to be a str")
        pulumi.set(__self__, "direction", direction)
        if ether_type and not isinstance(ether_type, str):
            raise TypeError("Expected argument 'ether_type' to be a str")
        pulumi.set(__self__, "ether_type", ether_type)
        if icmp_parameters and not isinstance(icmp_parameters, dict):
            raise TypeError("Expected argument 'icmp_parameters' to be a dict")
        pulumi.set(__self__, "icmp_parameters", icmp_parameters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ip_range and not isinstance(ip_range, str):
            raise TypeError("Expected argument 'ip_range' to be a str")
        pulumi.set(__self__, "ip_range", ip_range)
        if port_range and not isinstance(port_range, dict):
            raise TypeError("Expected argument 'port_range' to be a dict")
        pulumi.set(__self__, "port_range", port_range)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if protocol and not isinstance(protocol, dict):
            raise TypeError("Expected argument 'protocol' to be a dict")
        pulumi.set(__self__, "protocol", protocol)
        if remote_security_group_id and not isinstance(remote_security_group_id, str):
            raise TypeError("Expected argument 'remote_security_group_id' to be a str")
        pulumi.set(__self__, "remote_security_group_id", remote_security_group_id)
        if security_group_id and not isinstance(security_group_id, str):
            raise TypeError("Expected argument 'security_group_id' to be a str")
        pulumi.set(__self__, "security_group_id", security_group_id)
        if security_group_rule_id and not isinstance(security_group_rule_id, str):
            raise TypeError("Expected argument 'security_group_rule_id' to be a str")
        pulumi.set(__self__, "security_group_rule_id", security_group_rule_id)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the security group rule.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def direction(self) -> _builtins.str:
        """
        The direction of the traffic which the rule should match. Some of the possible values are: Supported values are: `ingress`, `egress`.
        """
        return pulumi.get(self, "direction")

    @_builtins.property
    @pulumi.getter(name="etherType")
    def ether_type(self) -> _builtins.str:
        """
        The ethertype which the rule should match.
        """
        return pulumi.get(self, "ether_type")

    @_builtins.property
    @pulumi.getter(name="icmpParameters")
    def icmp_parameters(self) -> 'outputs.GetSecurityGroupRuleIcmpParametersResult':
        """
        ICMP Parameters.
        """
        return pulumi.get(self, "icmp_parameters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> _builtins.str:
        """
        The remote IP range which the rule should match.
        """
        return pulumi.get(self, "ip_range")

    @_builtins.property
    @pulumi.getter(name="portRange")
    def port_range(self) -> 'outputs.GetSecurityGroupRulePortRangeResult':
        """
        The range of ports.
        """
        return pulumi.get(self, "port_range")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        STACKIT project ID to which the security group rule is associated.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> 'outputs.GetSecurityGroupRuleProtocolResult':
        """
        The internet protocol which the rule should match.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="remoteSecurityGroupId")
    def remote_security_group_id(self) -> _builtins.str:
        """
        The remote security group which the rule should match.
        """
        return pulumi.get(self, "remote_security_group_id")

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> _builtins.str:
        """
        The security group ID.
        """
        return pulumi.get(self, "security_group_id")

    @_builtins.property
    @pulumi.getter(name="securityGroupRuleId")
    def security_group_rule_id(self) -> _builtins.str:
        """
        The security group rule ID.
        """
        return pulumi.get(self, "security_group_rule_id")


class AwaitableGetSecurityGroupRuleResult(GetSecurityGroupRuleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSecurityGroupRuleResult(
            description=self.description,
            direction=self.direction,
            ether_type=self.ether_type,
            icmp_parameters=self.icmp_parameters,
            id=self.id,
            ip_range=self.ip_range,
            port_range=self.port_range,
            project_id=self.project_id,
            protocol=self.protocol,
            remote_security_group_id=self.remote_security_group_id,
            security_group_id=self.security_group_id,
            security_group_rule_id=self.security_group_rule_id)


def get_security_group_rule(project_id: Optional[_builtins.str] = None,
                            security_group_id: Optional[_builtins.str] = None,
                            security_group_rule_id: Optional[_builtins.str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSecurityGroupRuleResult:
    """
    Security group datasource schema. Must have a `region` specified in the provider configuration.

    ## Example Usage


    :param _builtins.str project_id: STACKIT project ID to which the security group rule is associated.
    :param _builtins.str security_group_id: The security group ID.
    :param _builtins.str security_group_rule_id: The security group rule ID.
    """
    __args__ = dict()
    __args__['projectId'] = project_id
    __args__['securityGroupId'] = security_group_id
    __args__['securityGroupRuleId'] = security_group_rule_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('stackit:index/getSecurityGroupRule:getSecurityGroupRule', __args__, opts=opts, typ=GetSecurityGroupRuleResult).value

    return AwaitableGetSecurityGroupRuleResult(
        description=pulumi.get(__ret__, 'description'),
        direction=pulumi.get(__ret__, 'direction'),
        ether_type=pulumi.get(__ret__, 'ether_type'),
        icmp_parameters=pulumi.get(__ret__, 'icmp_parameters'),
        id=pulumi.get(__ret__, 'id'),
        ip_range=pulumi.get(__ret__, 'ip_range'),
        port_range=pulumi.get(__ret__, 'port_range'),
        project_id=pulumi.get(__ret__, 'project_id'),
        protocol=pulumi.get(__ret__, 'protocol'),
        remote_security_group_id=pulumi.get(__ret__, 'remote_security_group_id'),
        security_group_id=pulumi.get(__ret__, 'security_group_id'),
        security_group_rule_id=pulumi.get(__ret__, 'security_group_rule_id'))
def get_security_group_rule_output(project_id: Optional[pulumi.Input[_builtins.str]] = None,
                                   security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                                   security_group_rule_id: Optional[pulumi.Input[_builtins.str]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSecurityGroupRuleResult]:
    """
    Security group datasource schema. Must have a `region` specified in the provider configuration.

    ## Example Usage


    :param _builtins.str project_id: STACKIT project ID to which the security group rule is associated.
    :param _builtins.str security_group_id: The security group ID.
    :param _builtins.str security_group_rule_id: The security group rule ID.
    """
    __args__ = dict()
    __args__['projectId'] = project_id
    __args__['securityGroupId'] = security_group_id
    __args__['securityGroupRuleId'] = security_group_rule_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('stackit:index/getSecurityGroupRule:getSecurityGroupRule', __args__, opts=opts, typ=GetSecurityGroupRuleResult)
    return __ret__.apply(lambda __response__: GetSecurityGroupRuleResult(
        description=pulumi.get(__response__, 'description'),
        direction=pulumi.get(__response__, 'direction'),
        ether_type=pulumi.get(__response__, 'ether_type'),
        icmp_parameters=pulumi.get(__response__, 'icmp_parameters'),
        id=pulumi.get(__response__, 'id'),
        ip_range=pulumi.get(__response__, 'ip_range'),
        port_range=pulumi.get(__response__, 'port_range'),
        project_id=pulumi.get(__response__, 'project_id'),
        protocol=pulumi.get(__response__, 'protocol'),
        remote_security_group_id=pulumi.get(__response__, 'remote_security_group_id'),
        security_group_id=pulumi.get(__response__, 'security_group_id'),
        security_group_rule_id=pulumi.get(__response__, 'security_group_rule_id')))
