# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetServerResult',
    'AwaitableGetServerResult',
    'get_server',
    'get_server_output',
]

@pulumi.output_type
class GetServerResult:
    """
    A collection of values returned by getServer.
    """
    def __init__(__self__, affinity_group=None, availability_zone=None, boot_volume=None, created_at=None, id=None, image_id=None, keypair_name=None, labels=None, launched_at=None, machine_type=None, name=None, network_interfaces=None, project_id=None, server_id=None, updated_at=None, user_data=None):
        if affinity_group and not isinstance(affinity_group, str):
            raise TypeError("Expected argument 'affinity_group' to be a str")
        pulumi.set(__self__, "affinity_group", affinity_group)
        if availability_zone and not isinstance(availability_zone, str):
            raise TypeError("Expected argument 'availability_zone' to be a str")
        pulumi.set(__self__, "availability_zone", availability_zone)
        if boot_volume and not isinstance(boot_volume, dict):
            raise TypeError("Expected argument 'boot_volume' to be a dict")
        pulumi.set(__self__, "boot_volume", boot_volume)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if image_id and not isinstance(image_id, str):
            raise TypeError("Expected argument 'image_id' to be a str")
        pulumi.set(__self__, "image_id", image_id)
        if keypair_name and not isinstance(keypair_name, str):
            raise TypeError("Expected argument 'keypair_name' to be a str")
        pulumi.set(__self__, "keypair_name", keypair_name)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if launched_at and not isinstance(launched_at, str):
            raise TypeError("Expected argument 'launched_at' to be a str")
        pulumi.set(__self__, "launched_at", launched_at)
        if machine_type and not isinstance(machine_type, str):
            raise TypeError("Expected argument 'machine_type' to be a str")
        pulumi.set(__self__, "machine_type", machine_type)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if network_interfaces and not isinstance(network_interfaces, list):
            raise TypeError("Expected argument 'network_interfaces' to be a list")
        pulumi.set(__self__, "network_interfaces", network_interfaces)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if server_id and not isinstance(server_id, str):
            raise TypeError("Expected argument 'server_id' to be a str")
        pulumi.set(__self__, "server_id", server_id)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)
        if user_data and not isinstance(user_data, str):
            raise TypeError("Expected argument 'user_data' to be a str")
        pulumi.set(__self__, "user_data", user_data)

    @_builtins.property
    @pulumi.getter(name="affinityGroup")
    def affinity_group(self) -> _builtins.str:
        """
        The affinity group the server is assigned to.
        """
        return pulumi.get(self, "affinity_group")

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> _builtins.str:
        """
        The availability zone of the server.
        """
        return pulumi.get(self, "availability_zone")

    @_builtins.property
    @pulumi.getter(name="bootVolume")
    def boot_volume(self) -> 'outputs.GetServerBootVolumeResult':
        """
        The boot volume for the server
        """
        return pulumi.get(self, "boot_volume")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        Date-time when the server was created
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> _builtins.str:
        """
        The image ID to be used for an ephemeral disk on the server.
        """
        return pulumi.get(self, "image_id")

    @_builtins.property
    @pulumi.getter(name="keypairName")
    def keypair_name(self) -> _builtins.str:
        """
        The name of the keypair used during server creation.
        """
        return pulumi.get(self, "keypair_name")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        """
        Labels are key-value string pairs which can be attached to a resource container
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="launchedAt")
    def launched_at(self) -> _builtins.str:
        """
        Date-time when the server was launched
        """
        return pulumi.get(self, "launched_at")

    @_builtins.property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> _builtins.str:
        """
        Name of the type of the machine for the server. Possible values are documented in [Virtual machine flavors](https://docs.stackit.cloud/stackit/en/virtual-machine-flavors-75137231.html)
        """
        return pulumi.get(self, "machine_type")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the server.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Sequence[_builtins.str]:
        """
        The IDs of network interfaces which should be attached to the server. Updating it will recreate the server.
        """
        return pulumi.get(self, "network_interfaces")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        STACKIT project ID to which the server is associated.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="serverId")
    def server_id(self) -> _builtins.str:
        """
        The server ID.
        """
        return pulumi.get(self, "server_id")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        """
        Date-time when the server was updated
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> _builtins.str:
        """
        User data that is passed via cloud-init to the server.
        """
        return pulumi.get(self, "user_data")


class AwaitableGetServerResult(GetServerResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServerResult(
            affinity_group=self.affinity_group,
            availability_zone=self.availability_zone,
            boot_volume=self.boot_volume,
            created_at=self.created_at,
            id=self.id,
            image_id=self.image_id,
            keypair_name=self.keypair_name,
            labels=self.labels,
            launched_at=self.launched_at,
            machine_type=self.machine_type,
            name=self.name,
            network_interfaces=self.network_interfaces,
            project_id=self.project_id,
            server_id=self.server_id,
            updated_at=self.updated_at,
            user_data=self.user_data)


def get_server(project_id: Optional[_builtins.str] = None,
               server_id: Optional[_builtins.str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServerResult:
    """
    Server datasource schema. Must have a `region` specified in the provider configuration.

    ## Example Usage


    :param _builtins.str project_id: STACKIT project ID to which the server is associated.
    :param _builtins.str server_id: The server ID.
    """
    __args__ = dict()
    __args__['projectId'] = project_id
    __args__['serverId'] = server_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('stackit:index/getServer:getServer', __args__, opts=opts, typ=GetServerResult).value

    return AwaitableGetServerResult(
        affinity_group=pulumi.get(__ret__, 'affinity_group'),
        availability_zone=pulumi.get(__ret__, 'availability_zone'),
        boot_volume=pulumi.get(__ret__, 'boot_volume'),
        created_at=pulumi.get(__ret__, 'created_at'),
        id=pulumi.get(__ret__, 'id'),
        image_id=pulumi.get(__ret__, 'image_id'),
        keypair_name=pulumi.get(__ret__, 'keypair_name'),
        labels=pulumi.get(__ret__, 'labels'),
        launched_at=pulumi.get(__ret__, 'launched_at'),
        machine_type=pulumi.get(__ret__, 'machine_type'),
        name=pulumi.get(__ret__, 'name'),
        network_interfaces=pulumi.get(__ret__, 'network_interfaces'),
        project_id=pulumi.get(__ret__, 'project_id'),
        server_id=pulumi.get(__ret__, 'server_id'),
        updated_at=pulumi.get(__ret__, 'updated_at'),
        user_data=pulumi.get(__ret__, 'user_data'))
def get_server_output(project_id: Optional[pulumi.Input[_builtins.str]] = None,
                      server_id: Optional[pulumi.Input[_builtins.str]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetServerResult]:
    """
    Server datasource schema. Must have a `region` specified in the provider configuration.

    ## Example Usage


    :param _builtins.str project_id: STACKIT project ID to which the server is associated.
    :param _builtins.str server_id: The server ID.
    """
    __args__ = dict()
    __args__['projectId'] = project_id
    __args__['serverId'] = server_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('stackit:index/getServer:getServer', __args__, opts=opts, typ=GetServerResult)
    return __ret__.apply(lambda __response__: GetServerResult(
        affinity_group=pulumi.get(__response__, 'affinity_group'),
        availability_zone=pulumi.get(__response__, 'availability_zone'),
        boot_volume=pulumi.get(__response__, 'boot_volume'),
        created_at=pulumi.get(__response__, 'created_at'),
        id=pulumi.get(__response__, 'id'),
        image_id=pulumi.get(__response__, 'image_id'),
        keypair_name=pulumi.get(__response__, 'keypair_name'),
        labels=pulumi.get(__response__, 'labels'),
        launched_at=pulumi.get(__response__, 'launched_at'),
        machine_type=pulumi.get(__response__, 'machine_type'),
        name=pulumi.get(__response__, 'name'),
        network_interfaces=pulumi.get(__response__, 'network_interfaces'),
        project_id=pulumi.get(__response__, 'project_id'),
        server_id=pulumi.get(__response__, 'server_id'),
        updated_at=pulumi.get(__response__, 'updated_at'),
        user_data=pulumi.get(__response__, 'user_data')))
