# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetServerBackupScheduleResult',
    'AwaitableGetServerBackupScheduleResult',
    'get_server_backup_schedule',
    'get_server_backup_schedule_output',
]

@pulumi.output_type
class GetServerBackupScheduleResult:
    """
    A collection of values returned by getServerBackupSchedule.
    """
    def __init__(__self__, backup_properties=None, backup_schedule_id=None, enabled=None, id=None, name=None, project_id=None, region=None, rrule=None, server_id=None):
        if backup_properties and not isinstance(backup_properties, dict):
            raise TypeError("Expected argument 'backup_properties' to be a dict")
        pulumi.set(__self__, "backup_properties", backup_properties)
        if backup_schedule_id and not isinstance(backup_schedule_id, int):
            raise TypeError("Expected argument 'backup_schedule_id' to be a int")
        pulumi.set(__self__, "backup_schedule_id", backup_schedule_id)
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if rrule and not isinstance(rrule, str):
            raise TypeError("Expected argument 'rrule' to be a str")
        pulumi.set(__self__, "rrule", rrule)
        if server_id and not isinstance(server_id, str):
            raise TypeError("Expected argument 'server_id' to be a str")
        pulumi.set(__self__, "server_id", server_id)

    @_builtins.property
    @pulumi.getter(name="backupProperties")
    def backup_properties(self) -> 'outputs.GetServerBackupScheduleBackupPropertiesResult':
        """
        Backup schedule details for the backups.
        """
        return pulumi.get(self, "backup_properties")

    @_builtins.property
    @pulumi.getter(name="backupScheduleId")
    def backup_schedule_id(self) -> _builtins.int:
        """
        Backup schedule ID.
        """
        return pulumi.get(self, "backup_schedule_id")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Is the backup schedule enabled or disabled.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The schedule name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        STACKIT Project ID to which the server is associated.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        """
        The resource region. If not defined, the provider region is used.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def rrule(self) -> _builtins.str:
        """
        Backup schedule described in `rrule` (recurrence rule) format.
        """
        return pulumi.get(self, "rrule")

    @_builtins.property
    @pulumi.getter(name="serverId")
    def server_id(self) -> _builtins.str:
        """
        Server ID for the backup schedule.
        """
        return pulumi.get(self, "server_id")


class AwaitableGetServerBackupScheduleResult(GetServerBackupScheduleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServerBackupScheduleResult(
            backup_properties=self.backup_properties,
            backup_schedule_id=self.backup_schedule_id,
            enabled=self.enabled,
            id=self.id,
            name=self.name,
            project_id=self.project_id,
            region=self.region,
            rrule=self.rrule,
            server_id=self.server_id)


def get_server_backup_schedule(backup_schedule_id: Optional[_builtins.int] = None,
                               project_id: Optional[_builtins.str] = None,
                               region: Optional[_builtins.str] = None,
                               server_id: Optional[_builtins.str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServerBackupScheduleResult:
    """
    Server backup schedule datasource schema. Must have a `region` specified in the provider configuration.

    > This datasource is in beta and may be subject to breaking changes in the future. Use with caution. See our guide for how to opt-in to use beta resources.

    ## Example Usage


    :param _builtins.int backup_schedule_id: Backup schedule ID.
    :param _builtins.str project_id: STACKIT Project ID to which the server is associated.
    :param _builtins.str region: The resource region. If not defined, the provider region is used.
    :param _builtins.str server_id: Server ID for the backup schedule.
    """
    __args__ = dict()
    __args__['backupScheduleId'] = backup_schedule_id
    __args__['projectId'] = project_id
    __args__['region'] = region
    __args__['serverId'] = server_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('stackit:index/getServerBackupSchedule:getServerBackupSchedule', __args__, opts=opts, typ=GetServerBackupScheduleResult).value

    return AwaitableGetServerBackupScheduleResult(
        backup_properties=pulumi.get(__ret__, 'backup_properties'),
        backup_schedule_id=pulumi.get(__ret__, 'backup_schedule_id'),
        enabled=pulumi.get(__ret__, 'enabled'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        project_id=pulumi.get(__ret__, 'project_id'),
        region=pulumi.get(__ret__, 'region'),
        rrule=pulumi.get(__ret__, 'rrule'),
        server_id=pulumi.get(__ret__, 'server_id'))
def get_server_backup_schedule_output(backup_schedule_id: Optional[pulumi.Input[_builtins.int]] = None,
                                      project_id: Optional[pulumi.Input[_builtins.str]] = None,
                                      region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      server_id: Optional[pulumi.Input[_builtins.str]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetServerBackupScheduleResult]:
    """
    Server backup schedule datasource schema. Must have a `region` specified in the provider configuration.

    > This datasource is in beta and may be subject to breaking changes in the future. Use with caution. See our guide for how to opt-in to use beta resources.

    ## Example Usage


    :param _builtins.int backup_schedule_id: Backup schedule ID.
    :param _builtins.str project_id: STACKIT Project ID to which the server is associated.
    :param _builtins.str region: The resource region. If not defined, the provider region is used.
    :param _builtins.str server_id: Server ID for the backup schedule.
    """
    __args__ = dict()
    __args__['backupScheduleId'] = backup_schedule_id
    __args__['projectId'] = project_id
    __args__['region'] = region
    __args__['serverId'] = server_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('stackit:index/getServerBackupSchedule:getServerBackupSchedule', __args__, opts=opts, typ=GetServerBackupScheduleResult)
    return __ret__.apply(lambda __response__: GetServerBackupScheduleResult(
        backup_properties=pulumi.get(__response__, 'backup_properties'),
        backup_schedule_id=pulumi.get(__response__, 'backup_schedule_id'),
        enabled=pulumi.get(__response__, 'enabled'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        project_id=pulumi.get(__response__, 'project_id'),
        region=pulumi.get(__response__, 'region'),
        rrule=pulumi.get(__response__, 'rrule'),
        server_id=pulumi.get(__response__, 'server_id')))
