# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetServerUpdateScheduleResult',
    'AwaitableGetServerUpdateScheduleResult',
    'get_server_update_schedule',
    'get_server_update_schedule_output',
]

@pulumi.output_type
class GetServerUpdateScheduleResult:
    """
    A collection of values returned by getServerUpdateSchedule.
    """
    def __init__(__self__, enabled=None, id=None, maintenance_window=None, name=None, project_id=None, region=None, rrule=None, server_id=None, update_schedule_id=None):
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if maintenance_window and not isinstance(maintenance_window, int):
            raise TypeError("Expected argument 'maintenance_window' to be a int")
        pulumi.set(__self__, "maintenance_window", maintenance_window)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if rrule and not isinstance(rrule, str):
            raise TypeError("Expected argument 'rrule' to be a str")
        pulumi.set(__self__, "rrule", rrule)
        if server_id and not isinstance(server_id, str):
            raise TypeError("Expected argument 'server_id' to be a str")
        pulumi.set(__self__, "server_id", server_id)
        if update_schedule_id and not isinstance(update_schedule_id, int):
            raise TypeError("Expected argument 'update_schedule_id' to be a int")
        pulumi.set(__self__, "update_schedule_id", update_schedule_id)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Is the update schedule enabled or disabled.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> _builtins.int:
        """
        Maintenance window [1..24].
        """
        return pulumi.get(self, "maintenance_window")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The schedule name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        STACKIT Project ID to which the server is associated.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        """
        The resource region. If not defined, the provider region is used.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def rrule(self) -> _builtins.str:
        """
        Update schedule described in `rrule` (recurrence rule) format.
        """
        return pulumi.get(self, "rrule")

    @_builtins.property
    @pulumi.getter(name="serverId")
    def server_id(self) -> _builtins.str:
        """
        Server ID for the update schedule.
        """
        return pulumi.get(self, "server_id")

    @_builtins.property
    @pulumi.getter(name="updateScheduleId")
    def update_schedule_id(self) -> _builtins.int:
        """
        Update schedule ID.
        """
        return pulumi.get(self, "update_schedule_id")


class AwaitableGetServerUpdateScheduleResult(GetServerUpdateScheduleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServerUpdateScheduleResult(
            enabled=self.enabled,
            id=self.id,
            maintenance_window=self.maintenance_window,
            name=self.name,
            project_id=self.project_id,
            region=self.region,
            rrule=self.rrule,
            server_id=self.server_id,
            update_schedule_id=self.update_schedule_id)


def get_server_update_schedule(project_id: Optional[_builtins.str] = None,
                               region: Optional[_builtins.str] = None,
                               server_id: Optional[_builtins.str] = None,
                               update_schedule_id: Optional[_builtins.int] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServerUpdateScheduleResult:
    """
    Server update schedule datasource schema. Must have a `region` specified in the provider configuration.

    > This datasource is in beta and may be subject to breaking changes in the future. Use with caution. See our guide for how to opt-in to use beta resources.

    ## Example Usage


    :param _builtins.str project_id: STACKIT Project ID to which the server is associated.
    :param _builtins.str region: The resource region. If not defined, the provider region is used.
    :param _builtins.str server_id: Server ID for the update schedule.
    :param _builtins.int update_schedule_id: Update schedule ID.
    """
    __args__ = dict()
    __args__['projectId'] = project_id
    __args__['region'] = region
    __args__['serverId'] = server_id
    __args__['updateScheduleId'] = update_schedule_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('stackit:index/getServerUpdateSchedule:getServerUpdateSchedule', __args__, opts=opts, typ=GetServerUpdateScheduleResult).value

    return AwaitableGetServerUpdateScheduleResult(
        enabled=pulumi.get(__ret__, 'enabled'),
        id=pulumi.get(__ret__, 'id'),
        maintenance_window=pulumi.get(__ret__, 'maintenance_window'),
        name=pulumi.get(__ret__, 'name'),
        project_id=pulumi.get(__ret__, 'project_id'),
        region=pulumi.get(__ret__, 'region'),
        rrule=pulumi.get(__ret__, 'rrule'),
        server_id=pulumi.get(__ret__, 'server_id'),
        update_schedule_id=pulumi.get(__ret__, 'update_schedule_id'))
def get_server_update_schedule_output(project_id: Optional[pulumi.Input[_builtins.str]] = None,
                                      region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      server_id: Optional[pulumi.Input[_builtins.str]] = None,
                                      update_schedule_id: Optional[pulumi.Input[_builtins.int]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetServerUpdateScheduleResult]:
    """
    Server update schedule datasource schema. Must have a `region` specified in the provider configuration.

    > This datasource is in beta and may be subject to breaking changes in the future. Use with caution. See our guide for how to opt-in to use beta resources.

    ## Example Usage


    :param _builtins.str project_id: STACKIT Project ID to which the server is associated.
    :param _builtins.str region: The resource region. If not defined, the provider region is used.
    :param _builtins.str server_id: Server ID for the update schedule.
    :param _builtins.int update_schedule_id: Update schedule ID.
    """
    __args__ = dict()
    __args__['projectId'] = project_id
    __args__['region'] = region
    __args__['serverId'] = server_id
    __args__['updateScheduleId'] = update_schedule_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('stackit:index/getServerUpdateSchedule:getServerUpdateSchedule', __args__, opts=opts, typ=GetServerUpdateScheduleResult)
    return __ret__.apply(lambda __response__: GetServerUpdateScheduleResult(
        enabled=pulumi.get(__response__, 'enabled'),
        id=pulumi.get(__response__, 'id'),
        maintenance_window=pulumi.get(__response__, 'maintenance_window'),
        name=pulumi.get(__response__, 'name'),
        project_id=pulumi.get(__response__, 'project_id'),
        region=pulumi.get(__response__, 'region'),
        rrule=pulumi.get(__response__, 'rrule'),
        server_id=pulumi.get(__response__, 'server_id'),
        update_schedule_id=pulumi.get(__response__, 'update_schedule_id')))
