# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetSkeClusterResult',
    'AwaitableGetSkeClusterResult',
    'get_ske_cluster',
    'get_ske_cluster_output',
]

@pulumi.output_type
class GetSkeClusterResult:
    """
    A collection of values returned by getSkeCluster.
    """
    def __init__(__self__, egress_address_ranges=None, extensions=None, hibernations=None, id=None, kubernetes_version_min=None, kubernetes_version_used=None, maintenance=None, name=None, network=None, node_pools=None, pod_address_ranges=None, project_id=None, region=None):
        if egress_address_ranges and not isinstance(egress_address_ranges, list):
            raise TypeError("Expected argument 'egress_address_ranges' to be a list")
        pulumi.set(__self__, "egress_address_ranges", egress_address_ranges)
        if extensions and not isinstance(extensions, dict):
            raise TypeError("Expected argument 'extensions' to be a dict")
        pulumi.set(__self__, "extensions", extensions)
        if hibernations and not isinstance(hibernations, list):
            raise TypeError("Expected argument 'hibernations' to be a list")
        pulumi.set(__self__, "hibernations", hibernations)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if kubernetes_version_min and not isinstance(kubernetes_version_min, str):
            raise TypeError("Expected argument 'kubernetes_version_min' to be a str")
        pulumi.set(__self__, "kubernetes_version_min", kubernetes_version_min)
        if kubernetes_version_used and not isinstance(kubernetes_version_used, str):
            raise TypeError("Expected argument 'kubernetes_version_used' to be a str")
        pulumi.set(__self__, "kubernetes_version_used", kubernetes_version_used)
        if maintenance and not isinstance(maintenance, dict):
            raise TypeError("Expected argument 'maintenance' to be a dict")
        pulumi.set(__self__, "maintenance", maintenance)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if network and not isinstance(network, dict):
            raise TypeError("Expected argument 'network' to be a dict")
        pulumi.set(__self__, "network", network)
        if node_pools and not isinstance(node_pools, list):
            raise TypeError("Expected argument 'node_pools' to be a list")
        pulumi.set(__self__, "node_pools", node_pools)
        if pod_address_ranges and not isinstance(pod_address_ranges, list):
            raise TypeError("Expected argument 'pod_address_ranges' to be a list")
        pulumi.set(__self__, "pod_address_ranges", pod_address_ranges)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="egressAddressRanges")
    def egress_address_ranges(self) -> Sequence[_builtins.str]:
        """
        The outgoing network ranges (in CIDR notation) of traffic originating from workload on the cluster.
        """
        return pulumi.get(self, "egress_address_ranges")

    @_builtins.property
    @pulumi.getter
    def extensions(self) -> 'outputs.GetSkeClusterExtensionsResult':
        """
        A single extensions block as defined below
        """
        return pulumi.get(self, "extensions")

    @_builtins.property
    @pulumi.getter
    def hibernations(self) -> Sequence['outputs.GetSkeClusterHibernationResult']:
        """
        One or more hibernation block as defined below.
        """
        return pulumi.get(self, "hibernations")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="kubernetesVersionMin")
    def kubernetes_version_min(self) -> _builtins.str:
        """
        The minimum Kubernetes version, this field is always nil. SKE automatically updates the cluster Kubernetes version if you have set `maintenance.enable_kubernetes_version_updates` to true or if there is a mandatory update, as described in [Updates for Kubernetes versions and Operating System versions in SKE](https://docs.stackit.cloud/stackit/en/version-updates-in-ske-10125631.html). To get the current kubernetes version being used for your cluster, use the `kubernetes_version_used` field.
        """
        return pulumi.get(self, "kubernetes_version_min")

    @_builtins.property
    @pulumi.getter(name="kubernetesVersionUsed")
    def kubernetes_version_used(self) -> _builtins.str:
        """
        Full Kubernetes version used. For example, if `1.22` was selected, this value may result to `1.22.15`
        """
        return pulumi.get(self, "kubernetes_version_used")

    @_builtins.property
    @pulumi.getter
    def maintenance(self) -> 'outputs.GetSkeClusterMaintenanceResult':
        """
        A single maintenance block as defined below
        """
        return pulumi.get(self, "maintenance")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The cluster name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def network(self) -> 'outputs.GetSkeClusterNetworkResult':
        """
        Network block as defined below.
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter(name="nodePools")
    def node_pools(self) -> Sequence['outputs.GetSkeClusterNodePoolResult']:
        """
        One or more `node_pool` block as defined below.
        """
        return pulumi.get(self, "node_pools")

    @_builtins.property
    @pulumi.getter(name="podAddressRanges")
    def pod_address_ranges(self) -> Sequence[_builtins.str]:
        """
        The network ranges (in CIDR notation) used by pods of the cluster.
        """
        return pulumi.get(self, "pod_address_ranges")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        STACKIT project ID to which the cluster is associated.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        """
        The resource region. If not defined, the provider region is used.
        """
        return pulumi.get(self, "region")


class AwaitableGetSkeClusterResult(GetSkeClusterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSkeClusterResult(
            egress_address_ranges=self.egress_address_ranges,
            extensions=self.extensions,
            hibernations=self.hibernations,
            id=self.id,
            kubernetes_version_min=self.kubernetes_version_min,
            kubernetes_version_used=self.kubernetes_version_used,
            maintenance=self.maintenance,
            name=self.name,
            network=self.network,
            node_pools=self.node_pools,
            pod_address_ranges=self.pod_address_ranges,
            project_id=self.project_id,
            region=self.region)


def get_ske_cluster(name: Optional[_builtins.str] = None,
                    project_id: Optional[_builtins.str] = None,
                    region: Optional[_builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSkeClusterResult:
    """
    SKE Cluster data source schema. Must have a `region` specified in the provider configuration.

    ## Example Usage


    :param _builtins.str name: The cluster name.
    :param _builtins.str project_id: STACKIT project ID to which the cluster is associated.
    :param _builtins.str region: The resource region. If not defined, the provider region is used.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['projectId'] = project_id
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('stackit:index/getSkeCluster:getSkeCluster', __args__, opts=opts, typ=GetSkeClusterResult).value

    return AwaitableGetSkeClusterResult(
        egress_address_ranges=pulumi.get(__ret__, 'egress_address_ranges'),
        extensions=pulumi.get(__ret__, 'extensions'),
        hibernations=pulumi.get(__ret__, 'hibernations'),
        id=pulumi.get(__ret__, 'id'),
        kubernetes_version_min=pulumi.get(__ret__, 'kubernetes_version_min'),
        kubernetes_version_used=pulumi.get(__ret__, 'kubernetes_version_used'),
        maintenance=pulumi.get(__ret__, 'maintenance'),
        name=pulumi.get(__ret__, 'name'),
        network=pulumi.get(__ret__, 'network'),
        node_pools=pulumi.get(__ret__, 'node_pools'),
        pod_address_ranges=pulumi.get(__ret__, 'pod_address_ranges'),
        project_id=pulumi.get(__ret__, 'project_id'),
        region=pulumi.get(__ret__, 'region'))
def get_ske_cluster_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                           project_id: Optional[pulumi.Input[_builtins.str]] = None,
                           region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSkeClusterResult]:
    """
    SKE Cluster data source schema. Must have a `region` specified in the provider configuration.

    ## Example Usage


    :param _builtins.str name: The cluster name.
    :param _builtins.str project_id: STACKIT project ID to which the cluster is associated.
    :param _builtins.str region: The resource region. If not defined, the provider region is used.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['projectId'] = project_id
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('stackit:index/getSkeCluster:getSkeCluster', __args__, opts=opts, typ=GetSkeClusterResult)
    return __ret__.apply(lambda __response__: GetSkeClusterResult(
        egress_address_ranges=pulumi.get(__response__, 'egress_address_ranges'),
        extensions=pulumi.get(__response__, 'extensions'),
        hibernations=pulumi.get(__response__, 'hibernations'),
        id=pulumi.get(__response__, 'id'),
        kubernetes_version_min=pulumi.get(__response__, 'kubernetes_version_min'),
        kubernetes_version_used=pulumi.get(__response__, 'kubernetes_version_used'),
        maintenance=pulumi.get(__response__, 'maintenance'),
        name=pulumi.get(__response__, 'name'),
        network=pulumi.get(__response__, 'network'),
        node_pools=pulumi.get(__response__, 'node_pools'),
        pod_address_ranges=pulumi.get(__response__, 'pod_address_ranges'),
        project_id=pulumi.get(__response__, 'project_id'),
        region=pulumi.get(__response__, 'region')))
