# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetVolumeResult',
    'AwaitableGetVolumeResult',
    'get_volume',
    'get_volume_output',
]

@pulumi.output_type
class GetVolumeResult:
    """
    A collection of values returned by getVolume.
    """
    def __init__(__self__, availability_zone=None, description=None, id=None, labels=None, name=None, performance_class=None, project_id=None, server_id=None, size=None, source=None, volume_id=None):
        if availability_zone and not isinstance(availability_zone, str):
            raise TypeError("Expected argument 'availability_zone' to be a str")
        pulumi.set(__self__, "availability_zone", availability_zone)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if performance_class and not isinstance(performance_class, str):
            raise TypeError("Expected argument 'performance_class' to be a str")
        pulumi.set(__self__, "performance_class", performance_class)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if server_id and not isinstance(server_id, str):
            raise TypeError("Expected argument 'server_id' to be a str")
        pulumi.set(__self__, "server_id", server_id)
        if size and not isinstance(size, int):
            raise TypeError("Expected argument 'size' to be a int")
        pulumi.set(__self__, "size", size)
        if source and not isinstance(source, dict):
            raise TypeError("Expected argument 'source' to be a dict")
        pulumi.set(__self__, "source", source)
        if volume_id and not isinstance(volume_id, str):
            raise TypeError("Expected argument 'volume_id' to be a str")
        pulumi.set(__self__, "volume_id", volume_id)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> _builtins.str:
        """
        The availability zone of the volume.
        """
        return pulumi.get(self, "availability_zone")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the volume.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        """
        Labels are key-value string pairs which can be attached to a resource container
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the volume.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="performanceClass")
    def performance_class(self) -> _builtins.str:
        """
        The performance class of the volume. Possible values are documented in [Service plans BlockStorage](https://docs.stackit.cloud/stackit/en/service-plans-blockstorage-75137974.html#ServiceplansBlockStorage-CurrentlyavailableServicePlans%28performanceclasses%29)
        """
        return pulumi.get(self, "performance_class")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        STACKIT project ID to which the volume is associated.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="serverId")
    def server_id(self) -> _builtins.str:
        """
        The server ID of the server to which the volume is attached to.
        """
        return pulumi.get(self, "server_id")

    @_builtins.property
    @pulumi.getter
    def size(self) -> _builtins.int:
        """
        The size of the volume in GB. It can only be updated to a larger value than the current size
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter
    def source(self) -> 'outputs.GetVolumeSourceResult':
        """
        The source of the volume. It can be either a volume, an image, a snapshot or a backup
        """
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> _builtins.str:
        """
        The volume ID.
        """
        return pulumi.get(self, "volume_id")


class AwaitableGetVolumeResult(GetVolumeResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVolumeResult(
            availability_zone=self.availability_zone,
            description=self.description,
            id=self.id,
            labels=self.labels,
            name=self.name,
            performance_class=self.performance_class,
            project_id=self.project_id,
            server_id=self.server_id,
            size=self.size,
            source=self.source,
            volume_id=self.volume_id)


def get_volume(project_id: Optional[_builtins.str] = None,
               volume_id: Optional[_builtins.str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVolumeResult:
    """
    Volume resource schema. Must have a `region` specified in the provider configuration.

    ## Example Usage


    :param _builtins.str project_id: STACKIT project ID to which the volume is associated.
    :param _builtins.str volume_id: The volume ID.
    """
    __args__ = dict()
    __args__['projectId'] = project_id
    __args__['volumeId'] = volume_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('stackit:index/getVolume:getVolume', __args__, opts=opts, typ=GetVolumeResult).value

    return AwaitableGetVolumeResult(
        availability_zone=pulumi.get(__ret__, 'availability_zone'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        labels=pulumi.get(__ret__, 'labels'),
        name=pulumi.get(__ret__, 'name'),
        performance_class=pulumi.get(__ret__, 'performance_class'),
        project_id=pulumi.get(__ret__, 'project_id'),
        server_id=pulumi.get(__ret__, 'server_id'),
        size=pulumi.get(__ret__, 'size'),
        source=pulumi.get(__ret__, 'source'),
        volume_id=pulumi.get(__ret__, 'volume_id'))
def get_volume_output(project_id: Optional[pulumi.Input[_builtins.str]] = None,
                      volume_id: Optional[pulumi.Input[_builtins.str]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVolumeResult]:
    """
    Volume resource schema. Must have a `region` specified in the provider configuration.

    ## Example Usage


    :param _builtins.str project_id: STACKIT project ID to which the volume is associated.
    :param _builtins.str volume_id: The volume ID.
    """
    __args__ = dict()
    __args__['projectId'] = project_id
    __args__['volumeId'] = volume_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('stackit:index/getVolume:getVolume', __args__, opts=opts, typ=GetVolumeResult)
    return __ret__.apply(lambda __response__: GetVolumeResult(
        availability_zone=pulumi.get(__response__, 'availability_zone'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        labels=pulumi.get(__response__, 'labels'),
        name=pulumi.get(__response__, 'name'),
        performance_class=pulumi.get(__response__, 'performance_class'),
        project_id=pulumi.get(__response__, 'project_id'),
        server_id=pulumi.get(__response__, 'server_id'),
        size=pulumi.get(__response__, 'size'),
        source=pulumi.get(__response__, 'source'),
        volume_id=pulumi.get(__response__, 'volume_id')))
