# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['GitArgs', 'Git']

@pulumi.input_type
class GitArgs:
    def __init__(__self__, *,
                 project_id: pulumi.Input[_builtins.str],
                 acls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 flavor: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Git resource.
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the git instance is associated.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] acls: Restricted ACL for instance access.
        :param pulumi.Input[_builtins.str] flavor: Instance flavor. If not provided, defaults to git-100. For a list of available flavors, refer to our API documentation: `https://docs.api.stackit.cloud/documentation/git/version/v1beta`
        :param pulumi.Input[_builtins.str] name: Unique name linked to the git instance.
        """
        pulumi.set(__self__, "project_id", project_id)
        if acls is not None:
            pulumi.set(__self__, "acls", acls)
        if flavor is not None:
            pulumi.set(__self__, "flavor", flavor)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.str]:
        """
        STACKIT project ID to which the git instance is associated.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def acls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Restricted ACL for instance access.
        """
        return pulumi.get(self, "acls")

    @acls.setter
    def acls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "acls", value)

    @_builtins.property
    @pulumi.getter
    def flavor(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance flavor. If not provided, defaults to git-100. For a list of available flavors, refer to our API documentation: `https://docs.api.stackit.cloud/documentation/git/version/v1beta`
        """
        return pulumi.get(self, "flavor")

    @flavor.setter
    def flavor(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "flavor", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique name linked to the git instance.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _GitState:
    def __init__(__self__, *,
                 acls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 consumed_disk: Optional[pulumi.Input[_builtins.str]] = None,
                 consumed_object_storage: Optional[pulumi.Input[_builtins.str]] = None,
                 created: Optional[pulumi.Input[_builtins.str]] = None,
                 flavor: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Git resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] acls: Restricted ACL for instance access.
        :param pulumi.Input[_builtins.str] consumed_disk: How many bytes of disk space is consumed.
        :param pulumi.Input[_builtins.str] consumed_object_storage: How many bytes of Object Storage is consumed.
        :param pulumi.Input[_builtins.str] created: Instance creation timestamp in RFC3339 format.
        :param pulumi.Input[_builtins.str] flavor: Instance flavor. If not provided, defaults to git-100. For a list of available flavors, refer to our API documentation: `https://docs.api.stackit.cloud/documentation/git/version/v1beta`
        :param pulumi.Input[_builtins.str] instance_id: ID linked to the git instance.
        :param pulumi.Input[_builtins.str] name: Unique name linked to the git instance.
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the git instance is associated.
        :param pulumi.Input[_builtins.str] url: Url linked to the git instance.
        :param pulumi.Input[_builtins.str] version: Version linked to the git instance.
        """
        if acls is not None:
            pulumi.set(__self__, "acls", acls)
        if consumed_disk is not None:
            pulumi.set(__self__, "consumed_disk", consumed_disk)
        if consumed_object_storage is not None:
            pulumi.set(__self__, "consumed_object_storage", consumed_object_storage)
        if created is not None:
            pulumi.set(__self__, "created", created)
        if flavor is not None:
            pulumi.set(__self__, "flavor", flavor)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def acls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Restricted ACL for instance access.
        """
        return pulumi.get(self, "acls")

    @acls.setter
    def acls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "acls", value)

    @_builtins.property
    @pulumi.getter(name="consumedDisk")
    def consumed_disk(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        How many bytes of disk space is consumed.
        """
        return pulumi.get(self, "consumed_disk")

    @consumed_disk.setter
    def consumed_disk(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "consumed_disk", value)

    @_builtins.property
    @pulumi.getter(name="consumedObjectStorage")
    def consumed_object_storage(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        How many bytes of Object Storage is consumed.
        """
        return pulumi.get(self, "consumed_object_storage")

    @consumed_object_storage.setter
    def consumed_object_storage(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "consumed_object_storage", value)

    @_builtins.property
    @pulumi.getter
    def created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance creation timestamp in RFC3339 format.
        """
        return pulumi.get(self, "created")

    @created.setter
    def created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created", value)

    @_builtins.property
    @pulumi.getter
    def flavor(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance flavor. If not provided, defaults to git-100. For a list of available flavors, refer to our API documentation: `https://docs.api.stackit.cloud/documentation/git/version/v1beta`
        """
        return pulumi.get(self, "flavor")

    @flavor.setter
    def flavor(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "flavor", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID linked to the git instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique name linked to the git instance.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        STACKIT project ID to which the git instance is associated.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Url linked to the git instance.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Version linked to the git instance.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("stackit:index/git:Git")
class Git(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 flavor: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Git Instance resource schema.

        > This resource is in beta and may be subject to breaking changes in the future. Use with caution. See our guide for how to opt-in to use beta resources. This resource currently does not support updates. Changing the ACLs, flavor, or name will trigger resource recreation. Update functionality will be added soon. In the meantime, please proceed with caution. To update these attributes, please open a support ticket.

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] acls: Restricted ACL for instance access.
        :param pulumi.Input[_builtins.str] flavor: Instance flavor. If not provided, defaults to git-100. For a list of available flavors, refer to our API documentation: `https://docs.api.stackit.cloud/documentation/git/version/v1beta`
        :param pulumi.Input[_builtins.str] name: Unique name linked to the git instance.
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the git instance is associated.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GitArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Git Instance resource schema.

        > This resource is in beta and may be subject to breaking changes in the future. Use with caution. See our guide for how to opt-in to use beta resources. This resource currently does not support updates. Changing the ACLs, flavor, or name will trigger resource recreation. Update functionality will be added soon. In the meantime, please proceed with caution. To update these attributes, please open a support ticket.

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param GitArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GitArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 flavor: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GitArgs.__new__(GitArgs)

            __props__.__dict__["acls"] = acls
            __props__.__dict__["flavor"] = flavor
            __props__.__dict__["name"] = name
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["consumed_disk"] = None
            __props__.__dict__["consumed_object_storage"] = None
            __props__.__dict__["created"] = None
            __props__.__dict__["instance_id"] = None
            __props__.__dict__["url"] = None
            __props__.__dict__["version"] = None
        super(Git, __self__).__init__(
            'stackit:index/git:Git',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            consumed_disk: Optional[pulumi.Input[_builtins.str]] = None,
            consumed_object_storage: Optional[pulumi.Input[_builtins.str]] = None,
            created: Optional[pulumi.Input[_builtins.str]] = None,
            flavor: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            url: Optional[pulumi.Input[_builtins.str]] = None,
            version: Optional[pulumi.Input[_builtins.str]] = None) -> 'Git':
        """
        Get an existing Git resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] acls: Restricted ACL for instance access.
        :param pulumi.Input[_builtins.str] consumed_disk: How many bytes of disk space is consumed.
        :param pulumi.Input[_builtins.str] consumed_object_storage: How many bytes of Object Storage is consumed.
        :param pulumi.Input[_builtins.str] created: Instance creation timestamp in RFC3339 format.
        :param pulumi.Input[_builtins.str] flavor: Instance flavor. If not provided, defaults to git-100. For a list of available flavors, refer to our API documentation: `https://docs.api.stackit.cloud/documentation/git/version/v1beta`
        :param pulumi.Input[_builtins.str] instance_id: ID linked to the git instance.
        :param pulumi.Input[_builtins.str] name: Unique name linked to the git instance.
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the git instance is associated.
        :param pulumi.Input[_builtins.str] url: Url linked to the git instance.
        :param pulumi.Input[_builtins.str] version: Version linked to the git instance.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GitState.__new__(_GitState)

        __props__.__dict__["acls"] = acls
        __props__.__dict__["consumed_disk"] = consumed_disk
        __props__.__dict__["consumed_object_storage"] = consumed_object_storage
        __props__.__dict__["created"] = created
        __props__.__dict__["flavor"] = flavor
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["name"] = name
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["url"] = url
        __props__.__dict__["version"] = version
        return Git(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def acls(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Restricted ACL for instance access.
        """
        return pulumi.get(self, "acls")

    @_builtins.property
    @pulumi.getter(name="consumedDisk")
    def consumed_disk(self) -> pulumi.Output[_builtins.str]:
        """
        How many bytes of disk space is consumed.
        """
        return pulumi.get(self, "consumed_disk")

    @_builtins.property
    @pulumi.getter(name="consumedObjectStorage")
    def consumed_object_storage(self) -> pulumi.Output[_builtins.str]:
        """
        How many bytes of Object Storage is consumed.
        """
        return pulumi.get(self, "consumed_object_storage")

    @_builtins.property
    @pulumi.getter
    def created(self) -> pulumi.Output[_builtins.str]:
        """
        Instance creation timestamp in RFC3339 format.
        """
        return pulumi.get(self, "created")

    @_builtins.property
    @pulumi.getter
    def flavor(self) -> pulumi.Output[_builtins.str]:
        """
        Instance flavor. If not provided, defaults to git-100. For a list of available flavors, refer to our API documentation: `https://docs.api.stackit.cloud/documentation/git/version/v1beta`
        """
        return pulumi.get(self, "flavor")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID linked to the git instance.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Unique name linked to the git instance.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        STACKIT project ID to which the git instance is associated.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def url(self) -> pulumi.Output[_builtins.str]:
        """
        Url linked to the git instance.
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.str]:
        """
        Version linked to the git instance.
        """
        return pulumi.get(self, "version")

