# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ImageArgs', 'Image']

@pulumi.input_type
class ImageArgs:
    def __init__(__self__, *,
                 disk_format: pulumi.Input[_builtins.str],
                 local_file_path: pulumi.Input[_builtins.str],
                 project_id: pulumi.Input[_builtins.str],
                 config: Optional[pulumi.Input['ImageConfigArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 min_disk_size: Optional[pulumi.Input[_builtins.int]] = None,
                 min_ram: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Image resource.
        :param pulumi.Input[_builtins.str] disk_format: The disk format of the image.
        :param pulumi.Input[_builtins.str] local_file_path: The filepath of the raw image file to be uploaded.
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the image is associated.
        :param pulumi.Input['ImageConfigArgs'] config: Properties to set hardware and scheduling settings for an image.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels are key-value string pairs which can be attached to a resource container
        :param pulumi.Input[_builtins.int] min_disk_size: The minimum disk size of the image in GB.
        :param pulumi.Input[_builtins.int] min_ram: The minimum RAM of the image in MB.
        :param pulumi.Input[_builtins.str] name: The name of the image.
        """
        pulumi.set(__self__, "disk_format", disk_format)
        pulumi.set(__self__, "local_file_path", local_file_path)
        pulumi.set(__self__, "project_id", project_id)
        if config is not None:
            pulumi.set(__self__, "config", config)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if min_disk_size is not None:
            pulumi.set(__self__, "min_disk_size", min_disk_size)
        if min_ram is not None:
            pulumi.set(__self__, "min_ram", min_ram)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="diskFormat")
    def disk_format(self) -> pulumi.Input[_builtins.str]:
        """
        The disk format of the image.
        """
        return pulumi.get(self, "disk_format")

    @disk_format.setter
    def disk_format(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "disk_format", value)

    @_builtins.property
    @pulumi.getter(name="localFilePath")
    def local_file_path(self) -> pulumi.Input[_builtins.str]:
        """
        The filepath of the raw image file to be uploaded.
        """
        return pulumi.get(self, "local_file_path")

    @local_file_path.setter
    def local_file_path(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "local_file_path", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.str]:
        """
        STACKIT project ID to which the image is associated.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input['ImageConfigArgs']]:
        """
        Properties to set hardware and scheduling settings for an image.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input['ImageConfigArgs']]):
        pulumi.set(self, "config", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels are key-value string pairs which can be attached to a resource container
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="minDiskSize")
    def min_disk_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The minimum disk size of the image in GB.
        """
        return pulumi.get(self, "min_disk_size")

    @min_disk_size.setter
    def min_disk_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_disk_size", value)

    @_builtins.property
    @pulumi.getter(name="minRam")
    def min_ram(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The minimum RAM of the image in MB.
        """
        return pulumi.get(self, "min_ram")

    @min_ram.setter
    def min_ram(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_ram", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the image.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _ImageState:
    def __init__(__self__, *,
                 checksum: Optional[pulumi.Input['ImageChecksumArgs']] = None,
                 config: Optional[pulumi.Input['ImageConfigArgs']] = None,
                 disk_format: Optional[pulumi.Input[_builtins.str]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 local_file_path: Optional[pulumi.Input[_builtins.str]] = None,
                 min_disk_size: Optional[pulumi.Input[_builtins.int]] = None,
                 min_ram: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 protected: Optional[pulumi.Input[_builtins.bool]] = None,
                 scope: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Image resources.
        :param pulumi.Input['ImageChecksumArgs'] checksum: Representation of an image checksum.
        :param pulumi.Input['ImageConfigArgs'] config: Properties to set hardware and scheduling settings for an image.
        :param pulumi.Input[_builtins.str] disk_format: The disk format of the image.
        :param pulumi.Input[_builtins.str] image_id: The image ID.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels are key-value string pairs which can be attached to a resource container
        :param pulumi.Input[_builtins.str] local_file_path: The filepath of the raw image file to be uploaded.
        :param pulumi.Input[_builtins.int] min_disk_size: The minimum disk size of the image in GB.
        :param pulumi.Input[_builtins.int] min_ram: The minimum RAM of the image in MB.
        :param pulumi.Input[_builtins.str] name: The name of the image.
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the image is associated.
        :param pulumi.Input[_builtins.bool] protected: Whether the image is protected.
        :param pulumi.Input[_builtins.str] scope: The scope of the image.
        """
        if checksum is not None:
            pulumi.set(__self__, "checksum", checksum)
        if config is not None:
            pulumi.set(__self__, "config", config)
        if disk_format is not None:
            pulumi.set(__self__, "disk_format", disk_format)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if local_file_path is not None:
            pulumi.set(__self__, "local_file_path", local_file_path)
        if min_disk_size is not None:
            pulumi.set(__self__, "min_disk_size", min_disk_size)
        if min_ram is not None:
            pulumi.set(__self__, "min_ram", min_ram)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if protected is not None:
            pulumi.set(__self__, "protected", protected)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @_builtins.property
    @pulumi.getter
    def checksum(self) -> Optional[pulumi.Input['ImageChecksumArgs']]:
        """
        Representation of an image checksum.
        """
        return pulumi.get(self, "checksum")

    @checksum.setter
    def checksum(self, value: Optional[pulumi.Input['ImageChecksumArgs']]):
        pulumi.set(self, "checksum", value)

    @_builtins.property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input['ImageConfigArgs']]:
        """
        Properties to set hardware and scheduling settings for an image.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input['ImageConfigArgs']]):
        pulumi.set(self, "config", value)

    @_builtins.property
    @pulumi.getter(name="diskFormat")
    def disk_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The disk format of the image.
        """
        return pulumi.get(self, "disk_format")

    @disk_format.setter
    def disk_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "disk_format", value)

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The image ID.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_id", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels are key-value string pairs which can be attached to a resource container
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="localFilePath")
    def local_file_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The filepath of the raw image file to be uploaded.
        """
        return pulumi.get(self, "local_file_path")

    @local_file_path.setter
    def local_file_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "local_file_path", value)

    @_builtins.property
    @pulumi.getter(name="minDiskSize")
    def min_disk_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The minimum disk size of the image in GB.
        """
        return pulumi.get(self, "min_disk_size")

    @min_disk_size.setter
    def min_disk_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_disk_size", value)

    @_builtins.property
    @pulumi.getter(name="minRam")
    def min_ram(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The minimum RAM of the image in MB.
        """
        return pulumi.get(self, "min_ram")

    @min_ram.setter
    def min_ram(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_ram", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the image.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        STACKIT project ID to which the image is associated.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def protected(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the image is protected.
        """
        return pulumi.get(self, "protected")

    @protected.setter
    def protected(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "protected", value)

    @_builtins.property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The scope of the image.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scope", value)


@pulumi.type_token("stackit:index/image:Image")
class Image(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config: Optional[pulumi.Input[Union['ImageConfigArgs', 'ImageConfigArgsDict']]] = None,
                 disk_format: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 local_file_path: Optional[pulumi.Input[_builtins.str]] = None,
                 min_disk_size: Optional[pulumi.Input[_builtins.int]] = None,
                 min_ram: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Image resource schema. Must have a `region` specified in the provider configuration.

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ImageConfigArgs', 'ImageConfigArgsDict']] config: Properties to set hardware and scheduling settings for an image.
        :param pulumi.Input[_builtins.str] disk_format: The disk format of the image.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels are key-value string pairs which can be attached to a resource container
        :param pulumi.Input[_builtins.str] local_file_path: The filepath of the raw image file to be uploaded.
        :param pulumi.Input[_builtins.int] min_disk_size: The minimum disk size of the image in GB.
        :param pulumi.Input[_builtins.int] min_ram: The minimum RAM of the image in MB.
        :param pulumi.Input[_builtins.str] name: The name of the image.
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the image is associated.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ImageArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Image resource schema. Must have a `region` specified in the provider configuration.

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param ImageArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ImageArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config: Optional[pulumi.Input[Union['ImageConfigArgs', 'ImageConfigArgsDict']]] = None,
                 disk_format: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 local_file_path: Optional[pulumi.Input[_builtins.str]] = None,
                 min_disk_size: Optional[pulumi.Input[_builtins.int]] = None,
                 min_ram: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ImageArgs.__new__(ImageArgs)

            __props__.__dict__["config"] = config
            if disk_format is None and not opts.urn:
                raise TypeError("Missing required property 'disk_format'")
            __props__.__dict__["disk_format"] = disk_format
            __props__.__dict__["labels"] = labels
            if local_file_path is None and not opts.urn:
                raise TypeError("Missing required property 'local_file_path'")
            __props__.__dict__["local_file_path"] = local_file_path
            __props__.__dict__["min_disk_size"] = min_disk_size
            __props__.__dict__["min_ram"] = min_ram
            __props__.__dict__["name"] = name
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["checksum"] = None
            __props__.__dict__["image_id"] = None
            __props__.__dict__["protected"] = None
            __props__.__dict__["scope"] = None
        super(Image, __self__).__init__(
            'stackit:index/image:Image',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            checksum: Optional[pulumi.Input[Union['ImageChecksumArgs', 'ImageChecksumArgsDict']]] = None,
            config: Optional[pulumi.Input[Union['ImageConfigArgs', 'ImageConfigArgsDict']]] = None,
            disk_format: Optional[pulumi.Input[_builtins.str]] = None,
            image_id: Optional[pulumi.Input[_builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            local_file_path: Optional[pulumi.Input[_builtins.str]] = None,
            min_disk_size: Optional[pulumi.Input[_builtins.int]] = None,
            min_ram: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            protected: Optional[pulumi.Input[_builtins.bool]] = None,
            scope: Optional[pulumi.Input[_builtins.str]] = None) -> 'Image':
        """
        Get an existing Image resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ImageChecksumArgs', 'ImageChecksumArgsDict']] checksum: Representation of an image checksum.
        :param pulumi.Input[Union['ImageConfigArgs', 'ImageConfigArgsDict']] config: Properties to set hardware and scheduling settings for an image.
        :param pulumi.Input[_builtins.str] disk_format: The disk format of the image.
        :param pulumi.Input[_builtins.str] image_id: The image ID.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels are key-value string pairs which can be attached to a resource container
        :param pulumi.Input[_builtins.str] local_file_path: The filepath of the raw image file to be uploaded.
        :param pulumi.Input[_builtins.int] min_disk_size: The minimum disk size of the image in GB.
        :param pulumi.Input[_builtins.int] min_ram: The minimum RAM of the image in MB.
        :param pulumi.Input[_builtins.str] name: The name of the image.
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the image is associated.
        :param pulumi.Input[_builtins.bool] protected: Whether the image is protected.
        :param pulumi.Input[_builtins.str] scope: The scope of the image.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ImageState.__new__(_ImageState)

        __props__.__dict__["checksum"] = checksum
        __props__.__dict__["config"] = config
        __props__.__dict__["disk_format"] = disk_format
        __props__.__dict__["image_id"] = image_id
        __props__.__dict__["labels"] = labels
        __props__.__dict__["local_file_path"] = local_file_path
        __props__.__dict__["min_disk_size"] = min_disk_size
        __props__.__dict__["min_ram"] = min_ram
        __props__.__dict__["name"] = name
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["protected"] = protected
        __props__.__dict__["scope"] = scope
        return Image(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def checksum(self) -> pulumi.Output['outputs.ImageChecksum']:
        """
        Representation of an image checksum.
        """
        return pulumi.get(self, "checksum")

    @_builtins.property
    @pulumi.getter
    def config(self) -> pulumi.Output['outputs.ImageConfig']:
        """
        Properties to set hardware and scheduling settings for an image.
        """
        return pulumi.get(self, "config")

    @_builtins.property
    @pulumi.getter(name="diskFormat")
    def disk_format(self) -> pulumi.Output[_builtins.str]:
        """
        The disk format of the image.
        """
        return pulumi.get(self, "disk_format")

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Output[_builtins.str]:
        """
        The image ID.
        """
        return pulumi.get(self, "image_id")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Labels are key-value string pairs which can be attached to a resource container
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="localFilePath")
    def local_file_path(self) -> pulumi.Output[_builtins.str]:
        """
        The filepath of the raw image file to be uploaded.
        """
        return pulumi.get(self, "local_file_path")

    @_builtins.property
    @pulumi.getter(name="minDiskSize")
    def min_disk_size(self) -> pulumi.Output[_builtins.int]:
        """
        The minimum disk size of the image in GB.
        """
        return pulumi.get(self, "min_disk_size")

    @_builtins.property
    @pulumi.getter(name="minRam")
    def min_ram(self) -> pulumi.Output[_builtins.int]:
        """
        The minimum RAM of the image in MB.
        """
        return pulumi.get(self, "min_ram")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the image.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        STACKIT project ID to which the image is associated.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def protected(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the image is protected.
        """
        return pulumi.get(self, "protected")

    @_builtins.property
    @pulumi.getter
    def scope(self) -> pulumi.Output[_builtins.str]:
        """
        The scope of the image.
        """
        return pulumi.get(self, "scope")

