# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LoadbalancerArgs', 'Loadbalancer']

@pulumi.input_type
class LoadbalancerArgs:
    def __init__(__self__, *,
                 listeners: pulumi.Input[Sequence[pulumi.Input['LoadbalancerListenerArgs']]],
                 networks: pulumi.Input[Sequence[pulumi.Input['LoadbalancerNetworkArgs']]],
                 project_id: pulumi.Input[_builtins.str],
                 target_pools: pulumi.Input[Sequence[pulumi.Input['LoadbalancerTargetPoolArgs']]],
                 external_address: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 options: Optional[pulumi.Input['LoadbalancerOptionsArgs']] = None,
                 plan_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Loadbalancer resource.
        :param pulumi.Input[Sequence[pulumi.Input['LoadbalancerListenerArgs']]] listeners: List of all listeners which will accept traffic. Limited to 20.
        :param pulumi.Input[Sequence[pulumi.Input['LoadbalancerNetworkArgs']]] networks: List of networks that listeners and targets reside in.
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the Load Balancer is associated.
        :param pulumi.Input[Sequence[pulumi.Input['LoadbalancerTargetPoolArgs']]] target_pools: List of all target pools which will be used in the Load Balancer. Limited to 20.
        :param pulumi.Input[_builtins.str] external_address: External Load Balancer IP address where this Load Balancer is exposed.
        :param pulumi.Input[_builtins.str] name: Load balancer name.
        :param pulumi.Input['LoadbalancerOptionsArgs'] options: Defines any optional functionality you want to have enabled on your load balancer.
        :param pulumi.Input[_builtins.str] plan_id: The service plan ID. If not defined, the default service plan is `p10`. Possible values are: `p10`, `p50`, `p250`, `p750`.
        :param pulumi.Input[_builtins.str] region: The resource region. If not defined, the provider region is used.
        """
        pulumi.set(__self__, "listeners", listeners)
        pulumi.set(__self__, "networks", networks)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "target_pools", target_pools)
        if external_address is not None:
            pulumi.set(__self__, "external_address", external_address)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if plan_id is not None:
            pulumi.set(__self__, "plan_id", plan_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def listeners(self) -> pulumi.Input[Sequence[pulumi.Input['LoadbalancerListenerArgs']]]:
        """
        List of all listeners which will accept traffic. Limited to 20.
        """
        return pulumi.get(self, "listeners")

    @listeners.setter
    def listeners(self, value: pulumi.Input[Sequence[pulumi.Input['LoadbalancerListenerArgs']]]):
        pulumi.set(self, "listeners", value)

    @_builtins.property
    @pulumi.getter
    def networks(self) -> pulumi.Input[Sequence[pulumi.Input['LoadbalancerNetworkArgs']]]:
        """
        List of networks that listeners and targets reside in.
        """
        return pulumi.get(self, "networks")

    @networks.setter
    def networks(self, value: pulumi.Input[Sequence[pulumi.Input['LoadbalancerNetworkArgs']]]):
        pulumi.set(self, "networks", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.str]:
        """
        STACKIT project ID to which the Load Balancer is associated.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="targetPools")
    def target_pools(self) -> pulumi.Input[Sequence[pulumi.Input['LoadbalancerTargetPoolArgs']]]:
        """
        List of all target pools which will be used in the Load Balancer. Limited to 20.
        """
        return pulumi.get(self, "target_pools")

    @target_pools.setter
    def target_pools(self, value: pulumi.Input[Sequence[pulumi.Input['LoadbalancerTargetPoolArgs']]]):
        pulumi.set(self, "target_pools", value)

    @_builtins.property
    @pulumi.getter(name="externalAddress")
    def external_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        External Load Balancer IP address where this Load Balancer is exposed.
        """
        return pulumi.get(self, "external_address")

    @external_address.setter
    def external_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_address", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Load balancer name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input['LoadbalancerOptionsArgs']]:
        """
        Defines any optional functionality you want to have enabled on your load balancer.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input['LoadbalancerOptionsArgs']]):
        pulumi.set(self, "options", value)

    @_builtins.property
    @pulumi.getter(name="planId")
    def plan_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The service plan ID. If not defined, the default service plan is `p10`. Possible values are: `p10`, `p50`, `p250`, `p750`.
        """
        return pulumi.get(self, "plan_id")

    @plan_id.setter
    def plan_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plan_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource region. If not defined, the provider region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _LoadbalancerState:
    def __init__(__self__, *,
                 external_address: Optional[pulumi.Input[_builtins.str]] = None,
                 listeners: Optional[pulumi.Input[Sequence[pulumi.Input['LoadbalancerListenerArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input['LoadbalancerNetworkArgs']]]] = None,
                 options: Optional[pulumi.Input['LoadbalancerOptionsArgs']] = None,
                 plan_id: Optional[pulumi.Input[_builtins.str]] = None,
                 private_address: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 target_pools: Optional[pulumi.Input[Sequence[pulumi.Input['LoadbalancerTargetPoolArgs']]]] = None):
        """
        Input properties used for looking up and filtering Loadbalancer resources.
        :param pulumi.Input[_builtins.str] external_address: External Load Balancer IP address where this Load Balancer is exposed.
        :param pulumi.Input[Sequence[pulumi.Input['LoadbalancerListenerArgs']]] listeners: List of all listeners which will accept traffic. Limited to 20.
        :param pulumi.Input[_builtins.str] name: Load balancer name.
        :param pulumi.Input[Sequence[pulumi.Input['LoadbalancerNetworkArgs']]] networks: List of networks that listeners and targets reside in.
        :param pulumi.Input['LoadbalancerOptionsArgs'] options: Defines any optional functionality you want to have enabled on your load balancer.
        :param pulumi.Input[_builtins.str] plan_id: The service plan ID. If not defined, the default service plan is `p10`. Possible values are: `p10`, `p50`, `p250`, `p750`.
        :param pulumi.Input[_builtins.str] private_address: Transient private Load Balancer IP address. It can change any time.
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the Load Balancer is associated.
        :param pulumi.Input[_builtins.str] region: The resource region. If not defined, the provider region is used.
        :param pulumi.Input[Sequence[pulumi.Input['LoadbalancerTargetPoolArgs']]] target_pools: List of all target pools which will be used in the Load Balancer. Limited to 20.
        """
        if external_address is not None:
            pulumi.set(__self__, "external_address", external_address)
        if listeners is not None:
            pulumi.set(__self__, "listeners", listeners)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if networks is not None:
            pulumi.set(__self__, "networks", networks)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if plan_id is not None:
            pulumi.set(__self__, "plan_id", plan_id)
        if private_address is not None:
            pulumi.set(__self__, "private_address", private_address)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if target_pools is not None:
            pulumi.set(__self__, "target_pools", target_pools)

    @_builtins.property
    @pulumi.getter(name="externalAddress")
    def external_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        External Load Balancer IP address where this Load Balancer is exposed.
        """
        return pulumi.get(self, "external_address")

    @external_address.setter
    def external_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_address", value)

    @_builtins.property
    @pulumi.getter
    def listeners(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadbalancerListenerArgs']]]]:
        """
        List of all listeners which will accept traffic. Limited to 20.
        """
        return pulumi.get(self, "listeners")

    @listeners.setter
    def listeners(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadbalancerListenerArgs']]]]):
        pulumi.set(self, "listeners", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Load balancer name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadbalancerNetworkArgs']]]]:
        """
        List of networks that listeners and targets reside in.
        """
        return pulumi.get(self, "networks")

    @networks.setter
    def networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadbalancerNetworkArgs']]]]):
        pulumi.set(self, "networks", value)

    @_builtins.property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input['LoadbalancerOptionsArgs']]:
        """
        Defines any optional functionality you want to have enabled on your load balancer.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input['LoadbalancerOptionsArgs']]):
        pulumi.set(self, "options", value)

    @_builtins.property
    @pulumi.getter(name="planId")
    def plan_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The service plan ID. If not defined, the default service plan is `p10`. Possible values are: `p10`, `p50`, `p250`, `p750`.
        """
        return pulumi.get(self, "plan_id")

    @plan_id.setter
    def plan_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plan_id", value)

    @_builtins.property
    @pulumi.getter(name="privateAddress")
    def private_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Transient private Load Balancer IP address. It can change any time.
        """
        return pulumi.get(self, "private_address")

    @private_address.setter
    def private_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_address", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        STACKIT project ID to which the Load Balancer is associated.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource region. If not defined, the provider region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="targetPools")
    def target_pools(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadbalancerTargetPoolArgs']]]]:
        """
        List of all target pools which will be used in the Load Balancer. Limited to 20.
        """
        return pulumi.get(self, "target_pools")

    @target_pools.setter
    def target_pools(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadbalancerTargetPoolArgs']]]]):
        pulumi.set(self, "target_pools", value)


@pulumi.type_token("stackit:index/loadbalancer:Loadbalancer")
class Loadbalancer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 external_address: Optional[pulumi.Input[_builtins.str]] = None,
                 listeners: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadbalancerListenerArgs', 'LoadbalancerListenerArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadbalancerNetworkArgs', 'LoadbalancerNetworkArgsDict']]]]] = None,
                 options: Optional[pulumi.Input[Union['LoadbalancerOptionsArgs', 'LoadbalancerOptionsArgsDict']]] = None,
                 plan_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 target_pools: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadbalancerTargetPoolArgs', 'LoadbalancerTargetPoolArgsDict']]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] external_address: External Load Balancer IP address where this Load Balancer is exposed.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LoadbalancerListenerArgs', 'LoadbalancerListenerArgsDict']]]] listeners: List of all listeners which will accept traffic. Limited to 20.
        :param pulumi.Input[_builtins.str] name: Load balancer name.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LoadbalancerNetworkArgs', 'LoadbalancerNetworkArgsDict']]]] networks: List of networks that listeners and targets reside in.
        :param pulumi.Input[Union['LoadbalancerOptionsArgs', 'LoadbalancerOptionsArgsDict']] options: Defines any optional functionality you want to have enabled on your load balancer.
        :param pulumi.Input[_builtins.str] plan_id: The service plan ID. If not defined, the default service plan is `p10`. Possible values are: `p10`, `p50`, `p250`, `p750`.
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the Load Balancer is associated.
        :param pulumi.Input[_builtins.str] region: The resource region. If not defined, the provider region is used.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LoadbalancerTargetPoolArgs', 'LoadbalancerTargetPoolArgsDict']]]] target_pools: List of all target pools which will be used in the Load Balancer. Limited to 20.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LoadbalancerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        :param str resource_name: The name of the resource.
        :param LoadbalancerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LoadbalancerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 external_address: Optional[pulumi.Input[_builtins.str]] = None,
                 listeners: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadbalancerListenerArgs', 'LoadbalancerListenerArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadbalancerNetworkArgs', 'LoadbalancerNetworkArgsDict']]]]] = None,
                 options: Optional[pulumi.Input[Union['LoadbalancerOptionsArgs', 'LoadbalancerOptionsArgsDict']]] = None,
                 plan_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 target_pools: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadbalancerTargetPoolArgs', 'LoadbalancerTargetPoolArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LoadbalancerArgs.__new__(LoadbalancerArgs)

            __props__.__dict__["external_address"] = external_address
            if listeners is None and not opts.urn:
                raise TypeError("Missing required property 'listeners'")
            __props__.__dict__["listeners"] = listeners
            __props__.__dict__["name"] = name
            if networks is None and not opts.urn:
                raise TypeError("Missing required property 'networks'")
            __props__.__dict__["networks"] = networks
            __props__.__dict__["options"] = options
            __props__.__dict__["plan_id"] = plan_id
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["region"] = region
            if target_pools is None and not opts.urn:
                raise TypeError("Missing required property 'target_pools'")
            __props__.__dict__["target_pools"] = target_pools
            __props__.__dict__["private_address"] = None
        super(Loadbalancer, __self__).__init__(
            'stackit:index/loadbalancer:Loadbalancer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            external_address: Optional[pulumi.Input[_builtins.str]] = None,
            listeners: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadbalancerListenerArgs', 'LoadbalancerListenerArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            networks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadbalancerNetworkArgs', 'LoadbalancerNetworkArgsDict']]]]] = None,
            options: Optional[pulumi.Input[Union['LoadbalancerOptionsArgs', 'LoadbalancerOptionsArgsDict']]] = None,
            plan_id: Optional[pulumi.Input[_builtins.str]] = None,
            private_address: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            target_pools: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadbalancerTargetPoolArgs', 'LoadbalancerTargetPoolArgsDict']]]]] = None) -> 'Loadbalancer':
        """
        Get an existing Loadbalancer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] external_address: External Load Balancer IP address where this Load Balancer is exposed.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LoadbalancerListenerArgs', 'LoadbalancerListenerArgsDict']]]] listeners: List of all listeners which will accept traffic. Limited to 20.
        :param pulumi.Input[_builtins.str] name: Load balancer name.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LoadbalancerNetworkArgs', 'LoadbalancerNetworkArgsDict']]]] networks: List of networks that listeners and targets reside in.
        :param pulumi.Input[Union['LoadbalancerOptionsArgs', 'LoadbalancerOptionsArgsDict']] options: Defines any optional functionality you want to have enabled on your load balancer.
        :param pulumi.Input[_builtins.str] plan_id: The service plan ID. If not defined, the default service plan is `p10`. Possible values are: `p10`, `p50`, `p250`, `p750`.
        :param pulumi.Input[_builtins.str] private_address: Transient private Load Balancer IP address. It can change any time.
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the Load Balancer is associated.
        :param pulumi.Input[_builtins.str] region: The resource region. If not defined, the provider region is used.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LoadbalancerTargetPoolArgs', 'LoadbalancerTargetPoolArgsDict']]]] target_pools: List of all target pools which will be used in the Load Balancer. Limited to 20.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LoadbalancerState.__new__(_LoadbalancerState)

        __props__.__dict__["external_address"] = external_address
        __props__.__dict__["listeners"] = listeners
        __props__.__dict__["name"] = name
        __props__.__dict__["networks"] = networks
        __props__.__dict__["options"] = options
        __props__.__dict__["plan_id"] = plan_id
        __props__.__dict__["private_address"] = private_address
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["region"] = region
        __props__.__dict__["target_pools"] = target_pools
        return Loadbalancer(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="externalAddress")
    def external_address(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        External Load Balancer IP address where this Load Balancer is exposed.
        """
        return pulumi.get(self, "external_address")

    @_builtins.property
    @pulumi.getter
    def listeners(self) -> pulumi.Output[Sequence['outputs.LoadbalancerListener']]:
        """
        List of all listeners which will accept traffic. Limited to 20.
        """
        return pulumi.get(self, "listeners")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Load balancer name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def networks(self) -> pulumi.Output[Sequence['outputs.LoadbalancerNetwork']]:
        """
        List of networks that listeners and targets reside in.
        """
        return pulumi.get(self, "networks")

    @_builtins.property
    @pulumi.getter
    def options(self) -> pulumi.Output['outputs.LoadbalancerOptions']:
        """
        Defines any optional functionality you want to have enabled on your load balancer.
        """
        return pulumi.get(self, "options")

    @_builtins.property
    @pulumi.getter(name="planId")
    def plan_id(self) -> pulumi.Output[_builtins.str]:
        """
        The service plan ID. If not defined, the default service plan is `p10`. Possible values are: `p10`, `p50`, `p250`, `p750`.
        """
        return pulumi.get(self, "plan_id")

    @_builtins.property
    @pulumi.getter(name="privateAddress")
    def private_address(self) -> pulumi.Output[_builtins.str]:
        """
        Transient private Load Balancer IP address. It can change any time.
        """
        return pulumi.get(self, "private_address")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        STACKIT project ID to which the Load Balancer is associated.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The resource region. If not defined, the provider region is used.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="targetPools")
    def target_pools(self) -> pulumi.Output[Sequence['outputs.LoadbalancerTargetPool']]:
        """
        List of all target pools which will be used in the Load Balancer. Limited to 20.
        """
        return pulumi.get(self, "target_pools")

