# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['LoadbalancerObservabilityCredentialArgs', 'LoadbalancerObservabilityCredential']

@pulumi.input_type
class LoadbalancerObservabilityCredentialArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[_builtins.str],
                 password: pulumi.Input[_builtins.str],
                 project_id: pulumi.Input[_builtins.str],
                 username: pulumi.Input[_builtins.str],
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a LoadbalancerObservabilityCredential resource.
        :param pulumi.Input[_builtins.str] display_name: Observability credential name.
        :param pulumi.Input[_builtins.str] password: The username for the observability service (e.g. Argus) where the logs/metrics will be pushed into.
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the load balancer observability credential is associated.
        :param pulumi.Input[_builtins.str] username: The password for the observability service (e.g. Argus) where the logs/metrics will be pushed into.
        :param pulumi.Input[_builtins.str] region: The resource region. If not defined, the provider region is used.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "username", username)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        Observability credential name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Input[_builtins.str]:
        """
        The username for the observability service (e.g. Argus) where the logs/metrics will be pushed into.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.str]:
        """
        STACKIT project ID to which the load balancer observability credential is associated.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> pulumi.Input[_builtins.str]:
        """
        The password for the observability service (e.g. Argus) where the logs/metrics will be pushed into.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "username", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource region. If not defined, the provider region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _LoadbalancerObservabilityCredentialState:
    def __init__(__self__, *,
                 credentials_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering LoadbalancerObservabilityCredential resources.
        :param pulumi.Input[_builtins.str] credentials_ref: The credentials reference is used by the Load Balancer to define which credentials it will use.
        :param pulumi.Input[_builtins.str] display_name: Observability credential name.
        :param pulumi.Input[_builtins.str] password: The username for the observability service (e.g. Argus) where the logs/metrics will be pushed into.
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the load balancer observability credential is associated.
        :param pulumi.Input[_builtins.str] region: The resource region. If not defined, the provider region is used.
        :param pulumi.Input[_builtins.str] username: The password for the observability service (e.g. Argus) where the logs/metrics will be pushed into.
        """
        if credentials_ref is not None:
            pulumi.set(__self__, "credentials_ref", credentials_ref)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter(name="credentialsRef")
    def credentials_ref(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The credentials reference is used by the Load Balancer to define which credentials it will use.
        """
        return pulumi.get(self, "credentials_ref")

    @credentials_ref.setter
    def credentials_ref(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "credentials_ref", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Observability credential name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The username for the observability service (e.g. Argus) where the logs/metrics will be pushed into.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        STACKIT project ID to which the load balancer observability credential is associated.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource region. If not defined, the provider region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password for the observability service (e.g. Argus) where the logs/metrics will be pushed into.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "username", value)


@pulumi.type_token("stackit:index/loadbalancerObservabilityCredential:LoadbalancerObservabilityCredential")
class LoadbalancerObservabilityCredential(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Load balancer observability credential resource schema. Must have a `region` specified in the provider configuration. These contain the username and password for the observability service (e.g. Argus) where the load balancer logs/metrics will be pushed into

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] display_name: Observability credential name.
        :param pulumi.Input[_builtins.str] password: The username for the observability service (e.g. Argus) where the logs/metrics will be pushed into.
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the load balancer observability credential is associated.
        :param pulumi.Input[_builtins.str] region: The resource region. If not defined, the provider region is used.
        :param pulumi.Input[_builtins.str] username: The password for the observability service (e.g. Argus) where the logs/metrics will be pushed into.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LoadbalancerObservabilityCredentialArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Load balancer observability credential resource schema. Must have a `region` specified in the provider configuration. These contain the username and password for the observability service (e.g. Argus) where the load balancer logs/metrics will be pushed into

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param LoadbalancerObservabilityCredentialArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LoadbalancerObservabilityCredentialArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LoadbalancerObservabilityCredentialArgs.__new__(LoadbalancerObservabilityCredentialArgs)

            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            if password is None and not opts.urn:
                raise TypeError("Missing required property 'password'")
            __props__.__dict__["password"] = password
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["region"] = region
            if username is None and not opts.urn:
                raise TypeError("Missing required property 'username'")
            __props__.__dict__["username"] = username
            __props__.__dict__["credentials_ref"] = None
        super(LoadbalancerObservabilityCredential, __self__).__init__(
            'stackit:index/loadbalancerObservabilityCredential:LoadbalancerObservabilityCredential',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            credentials_ref: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            username: Optional[pulumi.Input[_builtins.str]] = None) -> 'LoadbalancerObservabilityCredential':
        """
        Get an existing LoadbalancerObservabilityCredential resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] credentials_ref: The credentials reference is used by the Load Balancer to define which credentials it will use.
        :param pulumi.Input[_builtins.str] display_name: Observability credential name.
        :param pulumi.Input[_builtins.str] password: The username for the observability service (e.g. Argus) where the logs/metrics will be pushed into.
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the load balancer observability credential is associated.
        :param pulumi.Input[_builtins.str] region: The resource region. If not defined, the provider region is used.
        :param pulumi.Input[_builtins.str] username: The password for the observability service (e.g. Argus) where the logs/metrics will be pushed into.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LoadbalancerObservabilityCredentialState.__new__(_LoadbalancerObservabilityCredentialState)

        __props__.__dict__["credentials_ref"] = credentials_ref
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["password"] = password
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["region"] = region
        __props__.__dict__["username"] = username
        return LoadbalancerObservabilityCredential(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="credentialsRef")
    def credentials_ref(self) -> pulumi.Output[_builtins.str]:
        """
        The credentials reference is used by the Load Balancer to define which credentials it will use.
        """
        return pulumi.get(self, "credentials_ref")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        Observability credential name.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[_builtins.str]:
        """
        The username for the observability service (e.g. Argus) where the logs/metrics will be pushed into.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        STACKIT project ID to which the load balancer observability credential is associated.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The resource region. If not defined, the provider region is used.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def username(self) -> pulumi.Output[_builtins.str]:
        """
        The password for the observability service (e.g. Argus) where the logs/metrics will be pushed into.
        """
        return pulumi.get(self, "username")

