# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ModelservingTokenArgs', 'ModelservingToken']

@pulumi.input_type
class ModelservingTokenArgs:
    def __init__(__self__, *,
                 project_id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 rotate_when_changed: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 ttl_duration: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ModelservingToken resource.
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the AI model serving auth token is associated.
        :param pulumi.Input[_builtins.str] description: The description of the AI model serving auth token.
        :param pulumi.Input[_builtins.str] name: Name of the AI model serving auth token.
        :param pulumi.Input[_builtins.str] region: Region to which the AI model serving auth token is associated. If not defined, the provider region is used
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] rotate_when_changed: A map of arbitrary key/value pairs that will force recreation of the token when they change, enabling token rotation based on external conditions such as a rotating timestamp. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] ttl_duration: The TTL duration of the AI model serving auth token. E.g. 5h30m40s,5h,5h30m,30m,30s
        """
        pulumi.set(__self__, "project_id", project_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if rotate_when_changed is not None:
            pulumi.set(__self__, "rotate_when_changed", rotate_when_changed)
        if ttl_duration is not None:
            pulumi.set(__self__, "ttl_duration", ttl_duration)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.str]:
        """
        STACKIT project ID to which the AI model serving auth token is associated.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the AI model serving auth token.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the AI model serving auth token.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region to which the AI model serving auth token is associated. If not defined, the provider region is used
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="rotateWhenChanged")
    def rotate_when_changed(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of arbitrary key/value pairs that will force recreation of the token when they change, enabling token rotation based on external conditions such as a rotating timestamp. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "rotate_when_changed")

    @rotate_when_changed.setter
    def rotate_when_changed(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "rotate_when_changed", value)

    @_builtins.property
    @pulumi.getter(name="ttlDuration")
    def ttl_duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The TTL duration of the AI model serving auth token. E.g. 5h30m40s,5h,5h30m,30m,30s
        """
        return pulumi.get(self, "ttl_duration")

    @ttl_duration.setter
    def ttl_duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ttl_duration", value)


@pulumi.input_type
class _ModelservingTokenState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 rotate_when_changed: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 token: Optional[pulumi.Input[_builtins.str]] = None,
                 token_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ttl_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 valid_until: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ModelservingToken resources.
        :param pulumi.Input[_builtins.str] description: The description of the AI model serving auth token.
        :param pulumi.Input[_builtins.str] name: Name of the AI model serving auth token.
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the AI model serving auth token is associated.
        :param pulumi.Input[_builtins.str] region: Region to which the AI model serving auth token is associated. If not defined, the provider region is used
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] rotate_when_changed: A map of arbitrary key/value pairs that will force recreation of the token when they change, enabling token rotation based on external conditions such as a rotating timestamp. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] state: State of the AI model serving auth token.
        :param pulumi.Input[_builtins.str] token: Content of the AI model serving auth token.
        :param pulumi.Input[_builtins.str] token_id: The AI model serving auth token ID.
        :param pulumi.Input[_builtins.str] ttl_duration: The TTL duration of the AI model serving auth token. E.g. 5h30m40s,5h,5h30m,30m,30s
        :param pulumi.Input[_builtins.str] valid_until: The time until the AI model serving auth token is valid.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if rotate_when_changed is not None:
            pulumi.set(__self__, "rotate_when_changed", rotate_when_changed)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if token is not None:
            pulumi.set(__self__, "token", token)
        if token_id is not None:
            pulumi.set(__self__, "token_id", token_id)
        if ttl_duration is not None:
            pulumi.set(__self__, "ttl_duration", ttl_duration)
        if valid_until is not None:
            pulumi.set(__self__, "valid_until", valid_until)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the AI model serving auth token.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the AI model serving auth token.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        STACKIT project ID to which the AI model serving auth token is associated.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region to which the AI model serving auth token is associated. If not defined, the provider region is used
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="rotateWhenChanged")
    def rotate_when_changed(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of arbitrary key/value pairs that will force recreation of the token when they change, enabling token rotation based on external conditions such as a rotating timestamp. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "rotate_when_changed")

    @rotate_when_changed.setter
    def rotate_when_changed(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "rotate_when_changed", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        State of the AI model serving auth token.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Content of the AI model serving auth token.
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "token", value)

    @_builtins.property
    @pulumi.getter(name="tokenId")
    def token_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The AI model serving auth token ID.
        """
        return pulumi.get(self, "token_id")

    @token_id.setter
    def token_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "token_id", value)

    @_builtins.property
    @pulumi.getter(name="ttlDuration")
    def ttl_duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The TTL duration of the AI model serving auth token. E.g. 5h30m40s,5h,5h30m,30m,30s
        """
        return pulumi.get(self, "ttl_duration")

    @ttl_duration.setter
    def ttl_duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ttl_duration", value)

    @_builtins.property
    @pulumi.getter(name="validUntil")
    def valid_until(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time until the AI model serving auth token is valid.
        """
        return pulumi.get(self, "valid_until")

    @valid_until.setter
    def valid_until(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "valid_until", value)


@pulumi.type_token("stackit:index/modelservingToken:ModelservingToken")
class ModelservingToken(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 rotate_when_changed: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 ttl_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        AI Model Serving Auth Token Resource schema.

        ## Example Usage

        ### Automatically rotate AI model serving token

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The description of the AI model serving auth token.
        :param pulumi.Input[_builtins.str] name: Name of the AI model serving auth token.
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the AI model serving auth token is associated.
        :param pulumi.Input[_builtins.str] region: Region to which the AI model serving auth token is associated. If not defined, the provider region is used
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] rotate_when_changed: A map of arbitrary key/value pairs that will force recreation of the token when they change, enabling token rotation based on external conditions such as a rotating timestamp. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] ttl_duration: The TTL duration of the AI model serving auth token. E.g. 5h30m40s,5h,5h30m,30m,30s
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ModelservingTokenArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        AI Model Serving Auth Token Resource schema.

        ## Example Usage

        ### Automatically rotate AI model serving token

        :param str resource_name: The name of the resource.
        :param ModelservingTokenArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ModelservingTokenArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 rotate_when_changed: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 ttl_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ModelservingTokenArgs.__new__(ModelservingTokenArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["region"] = region
            __props__.__dict__["rotate_when_changed"] = rotate_when_changed
            __props__.__dict__["ttl_duration"] = ttl_duration
            __props__.__dict__["state"] = None
            __props__.__dict__["token"] = None
            __props__.__dict__["token_id"] = None
            __props__.__dict__["valid_until"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["token"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ModelservingToken, __self__).__init__(
            'stackit:index/modelservingToken:ModelservingToken',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            rotate_when_changed: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            token: Optional[pulumi.Input[_builtins.str]] = None,
            token_id: Optional[pulumi.Input[_builtins.str]] = None,
            ttl_duration: Optional[pulumi.Input[_builtins.str]] = None,
            valid_until: Optional[pulumi.Input[_builtins.str]] = None) -> 'ModelservingToken':
        """
        Get an existing ModelservingToken resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The description of the AI model serving auth token.
        :param pulumi.Input[_builtins.str] name: Name of the AI model serving auth token.
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the AI model serving auth token is associated.
        :param pulumi.Input[_builtins.str] region: Region to which the AI model serving auth token is associated. If not defined, the provider region is used
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] rotate_when_changed: A map of arbitrary key/value pairs that will force recreation of the token when they change, enabling token rotation based on external conditions such as a rotating timestamp. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] state: State of the AI model serving auth token.
        :param pulumi.Input[_builtins.str] token: Content of the AI model serving auth token.
        :param pulumi.Input[_builtins.str] token_id: The AI model serving auth token ID.
        :param pulumi.Input[_builtins.str] ttl_duration: The TTL duration of the AI model serving auth token. E.g. 5h30m40s,5h,5h30m,30m,30s
        :param pulumi.Input[_builtins.str] valid_until: The time until the AI model serving auth token is valid.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ModelservingTokenState.__new__(_ModelservingTokenState)

        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["region"] = region
        __props__.__dict__["rotate_when_changed"] = rotate_when_changed
        __props__.__dict__["state"] = state
        __props__.__dict__["token"] = token
        __props__.__dict__["token_id"] = token_id
        __props__.__dict__["ttl_duration"] = ttl_duration
        __props__.__dict__["valid_until"] = valid_until
        return ModelservingToken(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the AI model serving auth token.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the AI model serving auth token.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        STACKIT project ID to which the AI model serving auth token is associated.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region to which the AI model serving auth token is associated. If not defined, the provider region is used
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="rotateWhenChanged")
    def rotate_when_changed(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of arbitrary key/value pairs that will force recreation of the token when they change, enabling token rotation based on external conditions such as a rotating timestamp. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "rotate_when_changed")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        State of the AI model serving auth token.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def token(self) -> pulumi.Output[_builtins.str]:
        """
        Content of the AI model serving auth token.
        """
        return pulumi.get(self, "token")

    @_builtins.property
    @pulumi.getter(name="tokenId")
    def token_id(self) -> pulumi.Output[_builtins.str]:
        """
        The AI model serving auth token ID.
        """
        return pulumi.get(self, "token_id")

    @_builtins.property
    @pulumi.getter(name="ttlDuration")
    def ttl_duration(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The TTL duration of the AI model serving auth token. E.g. 5h30m40s,5h,5h30m,30m,30s
        """
        return pulumi.get(self, "ttl_duration")

    @_builtins.property
    @pulumi.getter(name="validUntil")
    def valid_until(self) -> pulumi.Output[_builtins.str]:
        """
        The time until the AI model serving auth token is valid.
        """
        return pulumi.get(self, "valid_until")

