# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['NetworkArgs', 'Network']

@pulumi.input_type
class NetworkArgs:
    def __init__(__self__, *,
                 project_id: pulumi.Input[_builtins.str],
                 ipv4_gateway: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv4_nameservers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ipv4_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv4_prefix_length: Optional[pulumi.Input[_builtins.int]] = None,
                 ipv6_gateway: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_nameservers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ipv6_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_prefix_length: Optional[pulumi.Input[_builtins.int]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nameservers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 no_ipv4_gateway: Optional[pulumi.Input[_builtins.bool]] = None,
                 no_ipv6_gateway: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 routed: Optional[pulumi.Input[_builtins.bool]] = None,
                 routing_table_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Network resource.
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the network is associated.
        :param pulumi.Input[_builtins.str] ipv4_gateway: The IPv4 gateway of a network. If not specified, the first IP of the network will be assigned as the gateway.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ipv4_nameservers: The IPv4 nameservers of the network.
        :param pulumi.Input[_builtins.str] ipv4_prefix: The IPv4 prefix of the network (CIDR).
        :param pulumi.Input[_builtins.int] ipv4_prefix_length: The IPv4 prefix length of the network.
        :param pulumi.Input[_builtins.str] ipv6_gateway: The IPv6 gateway of a network. If not specified, the first IP of the network will be assigned as the gateway.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ipv6_nameservers: The IPv6 nameservers of the network.
        :param pulumi.Input[_builtins.str] ipv6_prefix: The IPv6 prefix of the network (CIDR).
        :param pulumi.Input[_builtins.int] ipv6_prefix_length: The IPv6 prefix length of the network.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels are key-value string pairs which can be attached to a resource container
        :param pulumi.Input[_builtins.str] name: The name of the network.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] nameservers: The nameservers of the network. This field is deprecated and will be removed soon, use `ipv4_nameservers` to configure the nameservers for IPv4.
        :param pulumi.Input[_builtins.bool] no_ipv4_gateway: If set to `true`, the network doesn't have a gateway.
        :param pulumi.Input[_builtins.bool] no_ipv6_gateway: If set to `true`, the network doesn't have a gateway.
        :param pulumi.Input[_builtins.str] region: Can only be used when experimental "network" is set.
               The resource region. If not defined, the provider region is used.
        :param pulumi.Input[_builtins.bool] routed: If set to `true`, the network is routed and therefore accessible from other networks.
        :param pulumi.Input[_builtins.str] routing_table_id: Can only be used when experimental "network" is set.
               The ID of the routing table associated with the network.
        """
        pulumi.set(__self__, "project_id", project_id)
        if ipv4_gateway is not None:
            pulumi.set(__self__, "ipv4_gateway", ipv4_gateway)
        if ipv4_nameservers is not None:
            pulumi.set(__self__, "ipv4_nameservers", ipv4_nameservers)
        if ipv4_prefix is not None:
            pulumi.set(__self__, "ipv4_prefix", ipv4_prefix)
        if ipv4_prefix_length is not None:
            pulumi.set(__self__, "ipv4_prefix_length", ipv4_prefix_length)
        if ipv6_gateway is not None:
            pulumi.set(__self__, "ipv6_gateway", ipv6_gateway)
        if ipv6_nameservers is not None:
            pulumi.set(__self__, "ipv6_nameservers", ipv6_nameservers)
        if ipv6_prefix is not None:
            pulumi.set(__self__, "ipv6_prefix", ipv6_prefix)
        if ipv6_prefix_length is not None:
            pulumi.set(__self__, "ipv6_prefix_length", ipv6_prefix_length)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nameservers is not None:
            warnings.warn("""Use `ipv4_nameservers` to configure the nameservers for IPv4.""", DeprecationWarning)
            pulumi.log.warn("""nameservers is deprecated: Use `ipv4_nameservers` to configure the nameservers for IPv4.""")
        if nameservers is not None:
            pulumi.set(__self__, "nameservers", nameservers)
        if no_ipv4_gateway is not None:
            pulumi.set(__self__, "no_ipv4_gateway", no_ipv4_gateway)
        if no_ipv6_gateway is not None:
            pulumi.set(__self__, "no_ipv6_gateway", no_ipv6_gateway)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if routed is not None:
            pulumi.set(__self__, "routed", routed)
        if routing_table_id is not None:
            pulumi.set(__self__, "routing_table_id", routing_table_id)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.str]:
        """
        STACKIT project ID to which the network is associated.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="ipv4Gateway")
    def ipv4_gateway(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IPv4 gateway of a network. If not specified, the first IP of the network will be assigned as the gateway.
        """
        return pulumi.get(self, "ipv4_gateway")

    @ipv4_gateway.setter
    def ipv4_gateway(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv4_gateway", value)

    @_builtins.property
    @pulumi.getter(name="ipv4Nameservers")
    def ipv4_nameservers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The IPv4 nameservers of the network.
        """
        return pulumi.get(self, "ipv4_nameservers")

    @ipv4_nameservers.setter
    def ipv4_nameservers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ipv4_nameservers", value)

    @_builtins.property
    @pulumi.getter(name="ipv4Prefix")
    def ipv4_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IPv4 prefix of the network (CIDR).
        """
        return pulumi.get(self, "ipv4_prefix")

    @ipv4_prefix.setter
    def ipv4_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv4_prefix", value)

    @_builtins.property
    @pulumi.getter(name="ipv4PrefixLength")
    def ipv4_prefix_length(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The IPv4 prefix length of the network.
        """
        return pulumi.get(self, "ipv4_prefix_length")

    @ipv4_prefix_length.setter
    def ipv4_prefix_length(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ipv4_prefix_length", value)

    @_builtins.property
    @pulumi.getter(name="ipv6Gateway")
    def ipv6_gateway(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IPv6 gateway of a network. If not specified, the first IP of the network will be assigned as the gateway.
        """
        return pulumi.get(self, "ipv6_gateway")

    @ipv6_gateway.setter
    def ipv6_gateway(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_gateway", value)

    @_builtins.property
    @pulumi.getter(name="ipv6Nameservers")
    def ipv6_nameservers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The IPv6 nameservers of the network.
        """
        return pulumi.get(self, "ipv6_nameservers")

    @ipv6_nameservers.setter
    def ipv6_nameservers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ipv6_nameservers", value)

    @_builtins.property
    @pulumi.getter(name="ipv6Prefix")
    def ipv6_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IPv6 prefix of the network (CIDR).
        """
        return pulumi.get(self, "ipv6_prefix")

    @ipv6_prefix.setter
    def ipv6_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_prefix", value)

    @_builtins.property
    @pulumi.getter(name="ipv6PrefixLength")
    def ipv6_prefix_length(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The IPv6 prefix length of the network.
        """
        return pulumi.get(self, "ipv6_prefix_length")

    @ipv6_prefix_length.setter
    def ipv6_prefix_length(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ipv6_prefix_length", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels are key-value string pairs which can be attached to a resource container
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the network.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Use `ipv4_nameservers` to configure the nameservers for IPv4.""")
    def nameservers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The nameservers of the network. This field is deprecated and will be removed soon, use `ipv4_nameservers` to configure the nameservers for IPv4.
        """
        return pulumi.get(self, "nameservers")

    @nameservers.setter
    def nameservers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "nameservers", value)

    @_builtins.property
    @pulumi.getter(name="noIpv4Gateway")
    def no_ipv4_gateway(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to `true`, the network doesn't have a gateway.
        """
        return pulumi.get(self, "no_ipv4_gateway")

    @no_ipv4_gateway.setter
    def no_ipv4_gateway(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "no_ipv4_gateway", value)

    @_builtins.property
    @pulumi.getter(name="noIpv6Gateway")
    def no_ipv6_gateway(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to `true`, the network doesn't have a gateway.
        """
        return pulumi.get(self, "no_ipv6_gateway")

    @no_ipv6_gateway.setter
    def no_ipv6_gateway(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "no_ipv6_gateway", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Can only be used when experimental "network" is set.
        The resource region. If not defined, the provider region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def routed(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to `true`, the network is routed and therefore accessible from other networks.
        """
        return pulumi.get(self, "routed")

    @routed.setter
    def routed(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "routed", value)

    @_builtins.property
    @pulumi.getter(name="routingTableId")
    def routing_table_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Can only be used when experimental "network" is set.
        The ID of the routing table associated with the network.
        """
        return pulumi.get(self, "routing_table_id")

    @routing_table_id.setter
    def routing_table_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "routing_table_id", value)


@pulumi.input_type
class _NetworkState:
    def __init__(__self__, *,
                 ipv4_gateway: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv4_nameservers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ipv4_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv4_prefix_length: Optional[pulumi.Input[_builtins.int]] = None,
                 ipv4_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ipv6_gateway: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_nameservers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ipv6_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_prefix_length: Optional[pulumi.Input[_builtins.int]] = None,
                 ipv6_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nameservers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 no_ipv4_gateway: Optional[pulumi.Input[_builtins.bool]] = None,
                 no_ipv6_gateway: Optional[pulumi.Input[_builtins.bool]] = None,
                 prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 routed: Optional[pulumi.Input[_builtins.bool]] = None,
                 routing_table_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Network resources.
        :param pulumi.Input[_builtins.str] ipv4_gateway: The IPv4 gateway of a network. If not specified, the first IP of the network will be assigned as the gateway.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ipv4_nameservers: The IPv4 nameservers of the network.
        :param pulumi.Input[_builtins.str] ipv4_prefix: The IPv4 prefix of the network (CIDR).
        :param pulumi.Input[_builtins.int] ipv4_prefix_length: The IPv4 prefix length of the network.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ipv4_prefixes: The IPv4 prefixes of the network.
        :param pulumi.Input[_builtins.str] ipv6_gateway: The IPv6 gateway of a network. If not specified, the first IP of the network will be assigned as the gateway.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ipv6_nameservers: The IPv6 nameservers of the network.
        :param pulumi.Input[_builtins.str] ipv6_prefix: The IPv6 prefix of the network (CIDR).
        :param pulumi.Input[_builtins.int] ipv6_prefix_length: The IPv6 prefix length of the network.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ipv6_prefixes: The IPv6 prefixes of the network.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels are key-value string pairs which can be attached to a resource container
        :param pulumi.Input[_builtins.str] name: The name of the network.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] nameservers: The nameservers of the network. This field is deprecated and will be removed soon, use `ipv4_nameservers` to configure the nameservers for IPv4.
        :param pulumi.Input[_builtins.str] network_id: The network ID.
        :param pulumi.Input[_builtins.bool] no_ipv4_gateway: If set to `true`, the network doesn't have a gateway.
        :param pulumi.Input[_builtins.bool] no_ipv6_gateway: If set to `true`, the network doesn't have a gateway.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] prefixes: The prefixes of the network. This field is deprecated and will be removed soon, use `ipv4_prefixes` to read the prefixes of the IPv4 networks.
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the network is associated.
        :param pulumi.Input[_builtins.str] public_ip: The public IP of the network.
        :param pulumi.Input[_builtins.str] region: Can only be used when experimental "network" is set.
               The resource region. If not defined, the provider region is used.
        :param pulumi.Input[_builtins.bool] routed: If set to `true`, the network is routed and therefore accessible from other networks.
        :param pulumi.Input[_builtins.str] routing_table_id: Can only be used when experimental "network" is set.
               The ID of the routing table associated with the network.
        """
        if ipv4_gateway is not None:
            pulumi.set(__self__, "ipv4_gateway", ipv4_gateway)
        if ipv4_nameservers is not None:
            pulumi.set(__self__, "ipv4_nameservers", ipv4_nameservers)
        if ipv4_prefix is not None:
            pulumi.set(__self__, "ipv4_prefix", ipv4_prefix)
        if ipv4_prefix_length is not None:
            pulumi.set(__self__, "ipv4_prefix_length", ipv4_prefix_length)
        if ipv4_prefixes is not None:
            pulumi.set(__self__, "ipv4_prefixes", ipv4_prefixes)
        if ipv6_gateway is not None:
            pulumi.set(__self__, "ipv6_gateway", ipv6_gateway)
        if ipv6_nameservers is not None:
            pulumi.set(__self__, "ipv6_nameservers", ipv6_nameservers)
        if ipv6_prefix is not None:
            pulumi.set(__self__, "ipv6_prefix", ipv6_prefix)
        if ipv6_prefix_length is not None:
            pulumi.set(__self__, "ipv6_prefix_length", ipv6_prefix_length)
        if ipv6_prefixes is not None:
            pulumi.set(__self__, "ipv6_prefixes", ipv6_prefixes)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nameservers is not None:
            warnings.warn("""Use `ipv4_nameservers` to configure the nameservers for IPv4.""", DeprecationWarning)
            pulumi.log.warn("""nameservers is deprecated: Use `ipv4_nameservers` to configure the nameservers for IPv4.""")
        if nameservers is not None:
            pulumi.set(__self__, "nameservers", nameservers)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if no_ipv4_gateway is not None:
            pulumi.set(__self__, "no_ipv4_gateway", no_ipv4_gateway)
        if no_ipv6_gateway is not None:
            pulumi.set(__self__, "no_ipv6_gateway", no_ipv6_gateway)
        if prefixes is not None:
            warnings.warn("""Use `ipv4_prefixes` to read the prefixes of the IPv4 networks.""", DeprecationWarning)
            pulumi.log.warn("""prefixes is deprecated: Use `ipv4_prefixes` to read the prefixes of the IPv4 networks.""")
        if prefixes is not None:
            pulumi.set(__self__, "prefixes", prefixes)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if public_ip is not None:
            pulumi.set(__self__, "public_ip", public_ip)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if routed is not None:
            pulumi.set(__self__, "routed", routed)
        if routing_table_id is not None:
            pulumi.set(__self__, "routing_table_id", routing_table_id)

    @_builtins.property
    @pulumi.getter(name="ipv4Gateway")
    def ipv4_gateway(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IPv4 gateway of a network. If not specified, the first IP of the network will be assigned as the gateway.
        """
        return pulumi.get(self, "ipv4_gateway")

    @ipv4_gateway.setter
    def ipv4_gateway(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv4_gateway", value)

    @_builtins.property
    @pulumi.getter(name="ipv4Nameservers")
    def ipv4_nameservers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The IPv4 nameservers of the network.
        """
        return pulumi.get(self, "ipv4_nameservers")

    @ipv4_nameservers.setter
    def ipv4_nameservers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ipv4_nameservers", value)

    @_builtins.property
    @pulumi.getter(name="ipv4Prefix")
    def ipv4_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IPv4 prefix of the network (CIDR).
        """
        return pulumi.get(self, "ipv4_prefix")

    @ipv4_prefix.setter
    def ipv4_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv4_prefix", value)

    @_builtins.property
    @pulumi.getter(name="ipv4PrefixLength")
    def ipv4_prefix_length(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The IPv4 prefix length of the network.
        """
        return pulumi.get(self, "ipv4_prefix_length")

    @ipv4_prefix_length.setter
    def ipv4_prefix_length(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ipv4_prefix_length", value)

    @_builtins.property
    @pulumi.getter(name="ipv4Prefixes")
    def ipv4_prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The IPv4 prefixes of the network.
        """
        return pulumi.get(self, "ipv4_prefixes")

    @ipv4_prefixes.setter
    def ipv4_prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ipv4_prefixes", value)

    @_builtins.property
    @pulumi.getter(name="ipv6Gateway")
    def ipv6_gateway(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IPv6 gateway of a network. If not specified, the first IP of the network will be assigned as the gateway.
        """
        return pulumi.get(self, "ipv6_gateway")

    @ipv6_gateway.setter
    def ipv6_gateway(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_gateway", value)

    @_builtins.property
    @pulumi.getter(name="ipv6Nameservers")
    def ipv6_nameservers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The IPv6 nameservers of the network.
        """
        return pulumi.get(self, "ipv6_nameservers")

    @ipv6_nameservers.setter
    def ipv6_nameservers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ipv6_nameservers", value)

    @_builtins.property
    @pulumi.getter(name="ipv6Prefix")
    def ipv6_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IPv6 prefix of the network (CIDR).
        """
        return pulumi.get(self, "ipv6_prefix")

    @ipv6_prefix.setter
    def ipv6_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_prefix", value)

    @_builtins.property
    @pulumi.getter(name="ipv6PrefixLength")
    def ipv6_prefix_length(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The IPv6 prefix length of the network.
        """
        return pulumi.get(self, "ipv6_prefix_length")

    @ipv6_prefix_length.setter
    def ipv6_prefix_length(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ipv6_prefix_length", value)

    @_builtins.property
    @pulumi.getter(name="ipv6Prefixes")
    def ipv6_prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The IPv6 prefixes of the network.
        """
        return pulumi.get(self, "ipv6_prefixes")

    @ipv6_prefixes.setter
    def ipv6_prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ipv6_prefixes", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels are key-value string pairs which can be attached to a resource container
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the network.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Use `ipv4_nameservers` to configure the nameservers for IPv4.""")
    def nameservers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The nameservers of the network. This field is deprecated and will be removed soon, use `ipv4_nameservers` to configure the nameservers for IPv4.
        """
        return pulumi.get(self, "nameservers")

    @nameservers.setter
    def nameservers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "nameservers", value)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The network ID.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_id", value)

    @_builtins.property
    @pulumi.getter(name="noIpv4Gateway")
    def no_ipv4_gateway(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to `true`, the network doesn't have a gateway.
        """
        return pulumi.get(self, "no_ipv4_gateway")

    @no_ipv4_gateway.setter
    def no_ipv4_gateway(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "no_ipv4_gateway", value)

    @_builtins.property
    @pulumi.getter(name="noIpv6Gateway")
    def no_ipv6_gateway(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to `true`, the network doesn't have a gateway.
        """
        return pulumi.get(self, "no_ipv6_gateway")

    @no_ipv6_gateway.setter
    def no_ipv6_gateway(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "no_ipv6_gateway", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Use `ipv4_prefixes` to read the prefixes of the IPv4 networks.""")
    def prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The prefixes of the network. This field is deprecated and will be removed soon, use `ipv4_prefixes` to read the prefixes of the IPv4 networks.
        """
        return pulumi.get(self, "prefixes")

    @prefixes.setter
    def prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "prefixes", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        STACKIT project ID to which the network is associated.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The public IP of the network.
        """
        return pulumi.get(self, "public_ip")

    @public_ip.setter
    def public_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_ip", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Can only be used when experimental "network" is set.
        The resource region. If not defined, the provider region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def routed(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to `true`, the network is routed and therefore accessible from other networks.
        """
        return pulumi.get(self, "routed")

    @routed.setter
    def routed(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "routed", value)

    @_builtins.property
    @pulumi.getter(name="routingTableId")
    def routing_table_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Can only be used when experimental "network" is set.
        The ID of the routing table associated with the network.
        """
        return pulumi.get(self, "routing_table_id")

    @routing_table_id.setter
    def routing_table_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "routing_table_id", value)


@pulumi.type_token("stackit:index/network:Network")
class Network(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ipv4_gateway: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv4_nameservers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ipv4_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv4_prefix_length: Optional[pulumi.Input[_builtins.int]] = None,
                 ipv6_gateway: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_nameservers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ipv6_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_prefix_length: Optional[pulumi.Input[_builtins.int]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nameservers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 no_ipv4_gateway: Optional[pulumi.Input[_builtins.bool]] = None,
                 no_ipv6_gateway: Optional[pulumi.Input[_builtins.bool]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 routed: Optional[pulumi.Input[_builtins.bool]] = None,
                 routing_table_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Network resource schema. Must have a `region` specified in the provider configuration.

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] ipv4_gateway: The IPv4 gateway of a network. If not specified, the first IP of the network will be assigned as the gateway.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ipv4_nameservers: The IPv4 nameservers of the network.
        :param pulumi.Input[_builtins.str] ipv4_prefix: The IPv4 prefix of the network (CIDR).
        :param pulumi.Input[_builtins.int] ipv4_prefix_length: The IPv4 prefix length of the network.
        :param pulumi.Input[_builtins.str] ipv6_gateway: The IPv6 gateway of a network. If not specified, the first IP of the network will be assigned as the gateway.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ipv6_nameservers: The IPv6 nameservers of the network.
        :param pulumi.Input[_builtins.str] ipv6_prefix: The IPv6 prefix of the network (CIDR).
        :param pulumi.Input[_builtins.int] ipv6_prefix_length: The IPv6 prefix length of the network.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels are key-value string pairs which can be attached to a resource container
        :param pulumi.Input[_builtins.str] name: The name of the network.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] nameservers: The nameservers of the network. This field is deprecated and will be removed soon, use `ipv4_nameservers` to configure the nameservers for IPv4.
        :param pulumi.Input[_builtins.bool] no_ipv4_gateway: If set to `true`, the network doesn't have a gateway.
        :param pulumi.Input[_builtins.bool] no_ipv6_gateway: If set to `true`, the network doesn't have a gateway.
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the network is associated.
        :param pulumi.Input[_builtins.str] region: Can only be used when experimental "network" is set.
               The resource region. If not defined, the provider region is used.
        :param pulumi.Input[_builtins.bool] routed: If set to `true`, the network is routed and therefore accessible from other networks.
        :param pulumi.Input[_builtins.str] routing_table_id: Can only be used when experimental "network" is set.
               The ID of the routing table associated with the network.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Network resource schema. Must have a `region` specified in the provider configuration.

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param NetworkArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ipv4_gateway: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv4_nameservers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ipv4_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv4_prefix_length: Optional[pulumi.Input[_builtins.int]] = None,
                 ipv6_gateway: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_nameservers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ipv6_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_prefix_length: Optional[pulumi.Input[_builtins.int]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nameservers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 no_ipv4_gateway: Optional[pulumi.Input[_builtins.bool]] = None,
                 no_ipv6_gateway: Optional[pulumi.Input[_builtins.bool]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 routed: Optional[pulumi.Input[_builtins.bool]] = None,
                 routing_table_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkArgs.__new__(NetworkArgs)

            __props__.__dict__["ipv4_gateway"] = ipv4_gateway
            __props__.__dict__["ipv4_nameservers"] = ipv4_nameservers
            __props__.__dict__["ipv4_prefix"] = ipv4_prefix
            __props__.__dict__["ipv4_prefix_length"] = ipv4_prefix_length
            __props__.__dict__["ipv6_gateway"] = ipv6_gateway
            __props__.__dict__["ipv6_nameservers"] = ipv6_nameservers
            __props__.__dict__["ipv6_prefix"] = ipv6_prefix
            __props__.__dict__["ipv6_prefix_length"] = ipv6_prefix_length
            __props__.__dict__["labels"] = labels
            __props__.__dict__["name"] = name
            __props__.__dict__["nameservers"] = nameservers
            __props__.__dict__["no_ipv4_gateway"] = no_ipv4_gateway
            __props__.__dict__["no_ipv6_gateway"] = no_ipv6_gateway
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["region"] = region
            __props__.__dict__["routed"] = routed
            __props__.__dict__["routing_table_id"] = routing_table_id
            __props__.__dict__["ipv4_prefixes"] = None
            __props__.__dict__["ipv6_prefixes"] = None
            __props__.__dict__["network_id"] = None
            __props__.__dict__["prefixes"] = None
            __props__.__dict__["public_ip"] = None
        super(Network, __self__).__init__(
            'stackit:index/network:Network',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            ipv4_gateway: Optional[pulumi.Input[_builtins.str]] = None,
            ipv4_nameservers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            ipv4_prefix: Optional[pulumi.Input[_builtins.str]] = None,
            ipv4_prefix_length: Optional[pulumi.Input[_builtins.int]] = None,
            ipv4_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            ipv6_gateway: Optional[pulumi.Input[_builtins.str]] = None,
            ipv6_nameservers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            ipv6_prefix: Optional[pulumi.Input[_builtins.str]] = None,
            ipv6_prefix_length: Optional[pulumi.Input[_builtins.int]] = None,
            ipv6_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            nameservers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            network_id: Optional[pulumi.Input[_builtins.str]] = None,
            no_ipv4_gateway: Optional[pulumi.Input[_builtins.bool]] = None,
            no_ipv6_gateway: Optional[pulumi.Input[_builtins.bool]] = None,
            prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            public_ip: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            routed: Optional[pulumi.Input[_builtins.bool]] = None,
            routing_table_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Network':
        """
        Get an existing Network resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] ipv4_gateway: The IPv4 gateway of a network. If not specified, the first IP of the network will be assigned as the gateway.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ipv4_nameservers: The IPv4 nameservers of the network.
        :param pulumi.Input[_builtins.str] ipv4_prefix: The IPv4 prefix of the network (CIDR).
        :param pulumi.Input[_builtins.int] ipv4_prefix_length: The IPv4 prefix length of the network.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ipv4_prefixes: The IPv4 prefixes of the network.
        :param pulumi.Input[_builtins.str] ipv6_gateway: The IPv6 gateway of a network. If not specified, the first IP of the network will be assigned as the gateway.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ipv6_nameservers: The IPv6 nameservers of the network.
        :param pulumi.Input[_builtins.str] ipv6_prefix: The IPv6 prefix of the network (CIDR).
        :param pulumi.Input[_builtins.int] ipv6_prefix_length: The IPv6 prefix length of the network.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ipv6_prefixes: The IPv6 prefixes of the network.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels are key-value string pairs which can be attached to a resource container
        :param pulumi.Input[_builtins.str] name: The name of the network.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] nameservers: The nameservers of the network. This field is deprecated and will be removed soon, use `ipv4_nameservers` to configure the nameservers for IPv4.
        :param pulumi.Input[_builtins.str] network_id: The network ID.
        :param pulumi.Input[_builtins.bool] no_ipv4_gateway: If set to `true`, the network doesn't have a gateway.
        :param pulumi.Input[_builtins.bool] no_ipv6_gateway: If set to `true`, the network doesn't have a gateway.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] prefixes: The prefixes of the network. This field is deprecated and will be removed soon, use `ipv4_prefixes` to read the prefixes of the IPv4 networks.
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the network is associated.
        :param pulumi.Input[_builtins.str] public_ip: The public IP of the network.
        :param pulumi.Input[_builtins.str] region: Can only be used when experimental "network" is set.
               The resource region. If not defined, the provider region is used.
        :param pulumi.Input[_builtins.bool] routed: If set to `true`, the network is routed and therefore accessible from other networks.
        :param pulumi.Input[_builtins.str] routing_table_id: Can only be used when experimental "network" is set.
               The ID of the routing table associated with the network.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkState.__new__(_NetworkState)

        __props__.__dict__["ipv4_gateway"] = ipv4_gateway
        __props__.__dict__["ipv4_nameservers"] = ipv4_nameservers
        __props__.__dict__["ipv4_prefix"] = ipv4_prefix
        __props__.__dict__["ipv4_prefix_length"] = ipv4_prefix_length
        __props__.__dict__["ipv4_prefixes"] = ipv4_prefixes
        __props__.__dict__["ipv6_gateway"] = ipv6_gateway
        __props__.__dict__["ipv6_nameservers"] = ipv6_nameservers
        __props__.__dict__["ipv6_prefix"] = ipv6_prefix
        __props__.__dict__["ipv6_prefix_length"] = ipv6_prefix_length
        __props__.__dict__["ipv6_prefixes"] = ipv6_prefixes
        __props__.__dict__["labels"] = labels
        __props__.__dict__["name"] = name
        __props__.__dict__["nameservers"] = nameservers
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["no_ipv4_gateway"] = no_ipv4_gateway
        __props__.__dict__["no_ipv6_gateway"] = no_ipv6_gateway
        __props__.__dict__["prefixes"] = prefixes
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["public_ip"] = public_ip
        __props__.__dict__["region"] = region
        __props__.__dict__["routed"] = routed
        __props__.__dict__["routing_table_id"] = routing_table_id
        return Network(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="ipv4Gateway")
    def ipv4_gateway(self) -> pulumi.Output[_builtins.str]:
        """
        The IPv4 gateway of a network. If not specified, the first IP of the network will be assigned as the gateway.
        """
        return pulumi.get(self, "ipv4_gateway")

    @_builtins.property
    @pulumi.getter(name="ipv4Nameservers")
    def ipv4_nameservers(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The IPv4 nameservers of the network.
        """
        return pulumi.get(self, "ipv4_nameservers")

    @_builtins.property
    @pulumi.getter(name="ipv4Prefix")
    def ipv4_prefix(self) -> pulumi.Output[_builtins.str]:
        """
        The IPv4 prefix of the network (CIDR).
        """
        return pulumi.get(self, "ipv4_prefix")

    @_builtins.property
    @pulumi.getter(name="ipv4PrefixLength")
    def ipv4_prefix_length(self) -> pulumi.Output[_builtins.int]:
        """
        The IPv4 prefix length of the network.
        """
        return pulumi.get(self, "ipv4_prefix_length")

    @_builtins.property
    @pulumi.getter(name="ipv4Prefixes")
    def ipv4_prefixes(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The IPv4 prefixes of the network.
        """
        return pulumi.get(self, "ipv4_prefixes")

    @_builtins.property
    @pulumi.getter(name="ipv6Gateway")
    def ipv6_gateway(self) -> pulumi.Output[_builtins.str]:
        """
        The IPv6 gateway of a network. If not specified, the first IP of the network will be assigned as the gateway.
        """
        return pulumi.get(self, "ipv6_gateway")

    @_builtins.property
    @pulumi.getter(name="ipv6Nameservers")
    def ipv6_nameservers(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The IPv6 nameservers of the network.
        """
        return pulumi.get(self, "ipv6_nameservers")

    @_builtins.property
    @pulumi.getter(name="ipv6Prefix")
    def ipv6_prefix(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The IPv6 prefix of the network (CIDR).
        """
        return pulumi.get(self, "ipv6_prefix")

    @_builtins.property
    @pulumi.getter(name="ipv6PrefixLength")
    def ipv6_prefix_length(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The IPv6 prefix length of the network.
        """
        return pulumi.get(self, "ipv6_prefix_length")

    @_builtins.property
    @pulumi.getter(name="ipv6Prefixes")
    def ipv6_prefixes(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The IPv6 prefixes of the network.
        """
        return pulumi.get(self, "ipv6_prefixes")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Labels are key-value string pairs which can be attached to a resource container
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the network.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Use `ipv4_nameservers` to configure the nameservers for IPv4.""")
    def nameservers(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The nameservers of the network. This field is deprecated and will be removed soon, use `ipv4_nameservers` to configure the nameservers for IPv4.
        """
        return pulumi.get(self, "nameservers")

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[_builtins.str]:
        """
        The network ID.
        """
        return pulumi.get(self, "network_id")

    @_builtins.property
    @pulumi.getter(name="noIpv4Gateway")
    def no_ipv4_gateway(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If set to `true`, the network doesn't have a gateway.
        """
        return pulumi.get(self, "no_ipv4_gateway")

    @_builtins.property
    @pulumi.getter(name="noIpv6Gateway")
    def no_ipv6_gateway(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If set to `true`, the network doesn't have a gateway.
        """
        return pulumi.get(self, "no_ipv6_gateway")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Use `ipv4_prefixes` to read the prefixes of the IPv4 networks.""")
    def prefixes(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The prefixes of the network. This field is deprecated and will be removed soon, use `ipv4_prefixes` to read the prefixes of the IPv4 networks.
        """
        return pulumi.get(self, "prefixes")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        STACKIT project ID to which the network is associated.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> pulumi.Output[_builtins.str]:
        """
        The public IP of the network.
        """
        return pulumi.get(self, "public_ip")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Can only be used when experimental "network" is set.
        The resource region. If not defined, the provider region is used.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def routed(self) -> pulumi.Output[_builtins.bool]:
        """
        If set to `true`, the network is routed and therefore accessible from other networks.
        """
        return pulumi.get(self, "routed")

    @_builtins.property
    @pulumi.getter(name="routingTableId")
    def routing_table_id(self) -> pulumi.Output[_builtins.str]:
        """
        Can only be used when experimental "network" is set.
        The ID of the routing table associated with the network.
        """
        return pulumi.get(self, "routing_table_id")

