# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NetworkAreaArgs', 'NetworkArea']

@pulumi.input_type
class NetworkAreaArgs:
    def __init__(__self__, *,
                 network_ranges: pulumi.Input[Sequence[pulumi.Input['NetworkAreaNetworkRangeArgs']]],
                 organization_id: pulumi.Input[_builtins.str],
                 transfer_network: pulumi.Input[_builtins.str],
                 default_nameservers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 default_prefix_length: Optional[pulumi.Input[_builtins.int]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 max_prefix_length: Optional[pulumi.Input[_builtins.int]] = None,
                 min_prefix_length: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a NetworkArea resource.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkAreaNetworkRangeArgs']]] network_ranges: List of Network ranges.
        :param pulumi.Input[_builtins.str] organization_id: STACKIT organization ID to which the network area is associated.
        :param pulumi.Input[_builtins.str] transfer_network: Classless Inter-Domain Routing (CIDR).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] default_nameservers: List of DNS Servers/Nameservers.
        :param pulumi.Input[_builtins.int] default_prefix_length: The default prefix length for networks in the network area.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels are key-value string pairs which can be attached to a resource container
        :param pulumi.Input[_builtins.int] max_prefix_length: The maximal prefix length for networks in the network area.
        :param pulumi.Input[_builtins.int] min_prefix_length: The minimal prefix length for networks in the network area.
        :param pulumi.Input[_builtins.str] name: The name of the network area.
        """
        pulumi.set(__self__, "network_ranges", network_ranges)
        pulumi.set(__self__, "organization_id", organization_id)
        pulumi.set(__self__, "transfer_network", transfer_network)
        if default_nameservers is not None:
            pulumi.set(__self__, "default_nameservers", default_nameservers)
        if default_prefix_length is not None:
            pulumi.set(__self__, "default_prefix_length", default_prefix_length)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if max_prefix_length is not None:
            pulumi.set(__self__, "max_prefix_length", max_prefix_length)
        if min_prefix_length is not None:
            pulumi.set(__self__, "min_prefix_length", min_prefix_length)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="networkRanges")
    def network_ranges(self) -> pulumi.Input[Sequence[pulumi.Input['NetworkAreaNetworkRangeArgs']]]:
        """
        List of Network ranges.
        """
        return pulumi.get(self, "network_ranges")

    @network_ranges.setter
    def network_ranges(self, value: pulumi.Input[Sequence[pulumi.Input['NetworkAreaNetworkRangeArgs']]]):
        pulumi.set(self, "network_ranges", value)

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Input[_builtins.str]:
        """
        STACKIT organization ID to which the network area is associated.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "organization_id", value)

    @_builtins.property
    @pulumi.getter(name="transferNetwork")
    def transfer_network(self) -> pulumi.Input[_builtins.str]:
        """
        Classless Inter-Domain Routing (CIDR).
        """
        return pulumi.get(self, "transfer_network")

    @transfer_network.setter
    def transfer_network(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "transfer_network", value)

    @_builtins.property
    @pulumi.getter(name="defaultNameservers")
    def default_nameservers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of DNS Servers/Nameservers.
        """
        return pulumi.get(self, "default_nameservers")

    @default_nameservers.setter
    def default_nameservers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "default_nameservers", value)

    @_builtins.property
    @pulumi.getter(name="defaultPrefixLength")
    def default_prefix_length(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The default prefix length for networks in the network area.
        """
        return pulumi.get(self, "default_prefix_length")

    @default_prefix_length.setter
    def default_prefix_length(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "default_prefix_length", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels are key-value string pairs which can be attached to a resource container
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="maxPrefixLength")
    def max_prefix_length(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximal prefix length for networks in the network area.
        """
        return pulumi.get(self, "max_prefix_length")

    @max_prefix_length.setter
    def max_prefix_length(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_prefix_length", value)

    @_builtins.property
    @pulumi.getter(name="minPrefixLength")
    def min_prefix_length(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The minimal prefix length for networks in the network area.
        """
        return pulumi.get(self, "min_prefix_length")

    @min_prefix_length.setter
    def min_prefix_length(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_prefix_length", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the network area.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _NetworkAreaState:
    def __init__(__self__, *,
                 default_nameservers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 default_prefix_length: Optional[pulumi.Input[_builtins.int]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 max_prefix_length: Optional[pulumi.Input[_builtins.int]] = None,
                 min_prefix_length: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_area_id: Optional[pulumi.Input[_builtins.str]] = None,
                 network_ranges: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkAreaNetworkRangeArgs']]]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_count: Optional[pulumi.Input[_builtins.int]] = None,
                 transfer_network: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering NetworkArea resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] default_nameservers: List of DNS Servers/Nameservers.
        :param pulumi.Input[_builtins.int] default_prefix_length: The default prefix length for networks in the network area.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels are key-value string pairs which can be attached to a resource container
        :param pulumi.Input[_builtins.int] max_prefix_length: The maximal prefix length for networks in the network area.
        :param pulumi.Input[_builtins.int] min_prefix_length: The minimal prefix length for networks in the network area.
        :param pulumi.Input[_builtins.str] name: The name of the network area.
        :param pulumi.Input[_builtins.str] network_area_id: The network area ID.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkAreaNetworkRangeArgs']]] network_ranges: List of Network ranges.
        :param pulumi.Input[_builtins.str] organization_id: STACKIT organization ID to which the network area is associated.
        :param pulumi.Input[_builtins.int] project_count: The amount of projects currently referencing this area.
        :param pulumi.Input[_builtins.str] transfer_network: Classless Inter-Domain Routing (CIDR).
        """
        if default_nameservers is not None:
            pulumi.set(__self__, "default_nameservers", default_nameservers)
        if default_prefix_length is not None:
            pulumi.set(__self__, "default_prefix_length", default_prefix_length)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if max_prefix_length is not None:
            pulumi.set(__self__, "max_prefix_length", max_prefix_length)
        if min_prefix_length is not None:
            pulumi.set(__self__, "min_prefix_length", min_prefix_length)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_area_id is not None:
            pulumi.set(__self__, "network_area_id", network_area_id)
        if network_ranges is not None:
            pulumi.set(__self__, "network_ranges", network_ranges)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if project_count is not None:
            pulumi.set(__self__, "project_count", project_count)
        if transfer_network is not None:
            pulumi.set(__self__, "transfer_network", transfer_network)

    @_builtins.property
    @pulumi.getter(name="defaultNameservers")
    def default_nameservers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of DNS Servers/Nameservers.
        """
        return pulumi.get(self, "default_nameservers")

    @default_nameservers.setter
    def default_nameservers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "default_nameservers", value)

    @_builtins.property
    @pulumi.getter(name="defaultPrefixLength")
    def default_prefix_length(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The default prefix length for networks in the network area.
        """
        return pulumi.get(self, "default_prefix_length")

    @default_prefix_length.setter
    def default_prefix_length(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "default_prefix_length", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels are key-value string pairs which can be attached to a resource container
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="maxPrefixLength")
    def max_prefix_length(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximal prefix length for networks in the network area.
        """
        return pulumi.get(self, "max_prefix_length")

    @max_prefix_length.setter
    def max_prefix_length(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_prefix_length", value)

    @_builtins.property
    @pulumi.getter(name="minPrefixLength")
    def min_prefix_length(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The minimal prefix length for networks in the network area.
        """
        return pulumi.get(self, "min_prefix_length")

    @min_prefix_length.setter
    def min_prefix_length(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_prefix_length", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the network area.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkAreaId")
    def network_area_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The network area ID.
        """
        return pulumi.get(self, "network_area_id")

    @network_area_id.setter
    def network_area_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_area_id", value)

    @_builtins.property
    @pulumi.getter(name="networkRanges")
    def network_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkAreaNetworkRangeArgs']]]]:
        """
        List of Network ranges.
        """
        return pulumi.get(self, "network_ranges")

    @network_ranges.setter
    def network_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkAreaNetworkRangeArgs']]]]):
        pulumi.set(self, "network_ranges", value)

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        STACKIT organization ID to which the network area is associated.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization_id", value)

    @_builtins.property
    @pulumi.getter(name="projectCount")
    def project_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of projects currently referencing this area.
        """
        return pulumi.get(self, "project_count")

    @project_count.setter
    def project_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "project_count", value)

    @_builtins.property
    @pulumi.getter(name="transferNetwork")
    def transfer_network(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Classless Inter-Domain Routing (CIDR).
        """
        return pulumi.get(self, "transfer_network")

    @transfer_network.setter
    def transfer_network(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transfer_network", value)


@pulumi.type_token("stackit:index/networkArea:NetworkArea")
class NetworkArea(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_nameservers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 default_prefix_length: Optional[pulumi.Input[_builtins.int]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 max_prefix_length: Optional[pulumi.Input[_builtins.int]] = None,
                 min_prefix_length: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkAreaNetworkRangeArgs', 'NetworkAreaNetworkRangeArgsDict']]]]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 transfer_network: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Network area resource schema. Must have a `region` specified in the provider configuration.

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] default_nameservers: List of DNS Servers/Nameservers.
        :param pulumi.Input[_builtins.int] default_prefix_length: The default prefix length for networks in the network area.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels are key-value string pairs which can be attached to a resource container
        :param pulumi.Input[_builtins.int] max_prefix_length: The maximal prefix length for networks in the network area.
        :param pulumi.Input[_builtins.int] min_prefix_length: The minimal prefix length for networks in the network area.
        :param pulumi.Input[_builtins.str] name: The name of the network area.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NetworkAreaNetworkRangeArgs', 'NetworkAreaNetworkRangeArgsDict']]]] network_ranges: List of Network ranges.
        :param pulumi.Input[_builtins.str] organization_id: STACKIT organization ID to which the network area is associated.
        :param pulumi.Input[_builtins.str] transfer_network: Classless Inter-Domain Routing (CIDR).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkAreaArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Network area resource schema. Must have a `region` specified in the provider configuration.

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param NetworkAreaArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkAreaArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_nameservers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 default_prefix_length: Optional[pulumi.Input[_builtins.int]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 max_prefix_length: Optional[pulumi.Input[_builtins.int]] = None,
                 min_prefix_length: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkAreaNetworkRangeArgs', 'NetworkAreaNetworkRangeArgsDict']]]]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 transfer_network: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkAreaArgs.__new__(NetworkAreaArgs)

            __props__.__dict__["default_nameservers"] = default_nameservers
            __props__.__dict__["default_prefix_length"] = default_prefix_length
            __props__.__dict__["labels"] = labels
            __props__.__dict__["max_prefix_length"] = max_prefix_length
            __props__.__dict__["min_prefix_length"] = min_prefix_length
            __props__.__dict__["name"] = name
            if network_ranges is None and not opts.urn:
                raise TypeError("Missing required property 'network_ranges'")
            __props__.__dict__["network_ranges"] = network_ranges
            if organization_id is None and not opts.urn:
                raise TypeError("Missing required property 'organization_id'")
            __props__.__dict__["organization_id"] = organization_id
            if transfer_network is None and not opts.urn:
                raise TypeError("Missing required property 'transfer_network'")
            __props__.__dict__["transfer_network"] = transfer_network
            __props__.__dict__["network_area_id"] = None
            __props__.__dict__["project_count"] = None
        super(NetworkArea, __self__).__init__(
            'stackit:index/networkArea:NetworkArea',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            default_nameservers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            default_prefix_length: Optional[pulumi.Input[_builtins.int]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            max_prefix_length: Optional[pulumi.Input[_builtins.int]] = None,
            min_prefix_length: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_area_id: Optional[pulumi.Input[_builtins.str]] = None,
            network_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkAreaNetworkRangeArgs', 'NetworkAreaNetworkRangeArgsDict']]]]] = None,
            organization_id: Optional[pulumi.Input[_builtins.str]] = None,
            project_count: Optional[pulumi.Input[_builtins.int]] = None,
            transfer_network: Optional[pulumi.Input[_builtins.str]] = None) -> 'NetworkArea':
        """
        Get an existing NetworkArea resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] default_nameservers: List of DNS Servers/Nameservers.
        :param pulumi.Input[_builtins.int] default_prefix_length: The default prefix length for networks in the network area.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels are key-value string pairs which can be attached to a resource container
        :param pulumi.Input[_builtins.int] max_prefix_length: The maximal prefix length for networks in the network area.
        :param pulumi.Input[_builtins.int] min_prefix_length: The minimal prefix length for networks in the network area.
        :param pulumi.Input[_builtins.str] name: The name of the network area.
        :param pulumi.Input[_builtins.str] network_area_id: The network area ID.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NetworkAreaNetworkRangeArgs', 'NetworkAreaNetworkRangeArgsDict']]]] network_ranges: List of Network ranges.
        :param pulumi.Input[_builtins.str] organization_id: STACKIT organization ID to which the network area is associated.
        :param pulumi.Input[_builtins.int] project_count: The amount of projects currently referencing this area.
        :param pulumi.Input[_builtins.str] transfer_network: Classless Inter-Domain Routing (CIDR).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkAreaState.__new__(_NetworkAreaState)

        __props__.__dict__["default_nameservers"] = default_nameservers
        __props__.__dict__["default_prefix_length"] = default_prefix_length
        __props__.__dict__["labels"] = labels
        __props__.__dict__["max_prefix_length"] = max_prefix_length
        __props__.__dict__["min_prefix_length"] = min_prefix_length
        __props__.__dict__["name"] = name
        __props__.__dict__["network_area_id"] = network_area_id
        __props__.__dict__["network_ranges"] = network_ranges
        __props__.__dict__["organization_id"] = organization_id
        __props__.__dict__["project_count"] = project_count
        __props__.__dict__["transfer_network"] = transfer_network
        return NetworkArea(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="defaultNameservers")
    def default_nameservers(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of DNS Servers/Nameservers.
        """
        return pulumi.get(self, "default_nameservers")

    @_builtins.property
    @pulumi.getter(name="defaultPrefixLength")
    def default_prefix_length(self) -> pulumi.Output[_builtins.int]:
        """
        The default prefix length for networks in the network area.
        """
        return pulumi.get(self, "default_prefix_length")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Labels are key-value string pairs which can be attached to a resource container
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="maxPrefixLength")
    def max_prefix_length(self) -> pulumi.Output[_builtins.int]:
        """
        The maximal prefix length for networks in the network area.
        """
        return pulumi.get(self, "max_prefix_length")

    @_builtins.property
    @pulumi.getter(name="minPrefixLength")
    def min_prefix_length(self) -> pulumi.Output[_builtins.int]:
        """
        The minimal prefix length for networks in the network area.
        """
        return pulumi.get(self, "min_prefix_length")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the network area.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkAreaId")
    def network_area_id(self) -> pulumi.Output[_builtins.str]:
        """
        The network area ID.
        """
        return pulumi.get(self, "network_area_id")

    @_builtins.property
    @pulumi.getter(name="networkRanges")
    def network_ranges(self) -> pulumi.Output[Sequence['outputs.NetworkAreaNetworkRange']]:
        """
        List of Network ranges.
        """
        return pulumi.get(self, "network_ranges")

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[_builtins.str]:
        """
        STACKIT organization ID to which the network area is associated.
        """
        return pulumi.get(self, "organization_id")

    @_builtins.property
    @pulumi.getter(name="projectCount")
    def project_count(self) -> pulumi.Output[_builtins.int]:
        """
        The amount of projects currently referencing this area.
        """
        return pulumi.get(self, "project_count")

    @_builtins.property
    @pulumi.getter(name="transferNetwork")
    def transfer_network(self) -> pulumi.Output[_builtins.str]:
        """
        Classless Inter-Domain Routing (CIDR).
        """
        return pulumi.get(self, "transfer_network")

