# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['NetworkAreaRouteArgs', 'NetworkAreaRoute']

@pulumi.input_type
class NetworkAreaRouteArgs:
    def __init__(__self__, *,
                 network_area_id: pulumi.Input[_builtins.str],
                 next_hop: pulumi.Input[_builtins.str],
                 organization_id: pulumi.Input[_builtins.str],
                 prefix: pulumi.Input[_builtins.str],
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a NetworkAreaRoute resource.
        :param pulumi.Input[_builtins.str] network_area_id: The network area ID to which the network area route is associated.
        :param pulumi.Input[_builtins.str] next_hop: The IP address of the routing system, that will route the prefix configured. Should be a valid IPv4 address.
        :param pulumi.Input[_builtins.str] organization_id: STACKIT organization ID to which the network area is associated.
        :param pulumi.Input[_builtins.str] prefix: The network, that is reachable though the Next Hop. Should use CIDR notation.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels are key-value string pairs which can be attached to a resource container
        """
        pulumi.set(__self__, "network_area_id", network_area_id)
        pulumi.set(__self__, "next_hop", next_hop)
        pulumi.set(__self__, "organization_id", organization_id)
        pulumi.set(__self__, "prefix", prefix)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)

    @_builtins.property
    @pulumi.getter(name="networkAreaId")
    def network_area_id(self) -> pulumi.Input[_builtins.str]:
        """
        The network area ID to which the network area route is associated.
        """
        return pulumi.get(self, "network_area_id")

    @network_area_id.setter
    def network_area_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "network_area_id", value)

    @_builtins.property
    @pulumi.getter(name="nextHop")
    def next_hop(self) -> pulumi.Input[_builtins.str]:
        """
        The IP address of the routing system, that will route the prefix configured. Should be a valid IPv4 address.
        """
        return pulumi.get(self, "next_hop")

    @next_hop.setter
    def next_hop(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "next_hop", value)

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Input[_builtins.str]:
        """
        STACKIT organization ID to which the network area is associated.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "organization_id", value)

    @_builtins.property
    @pulumi.getter
    def prefix(self) -> pulumi.Input[_builtins.str]:
        """
        The network, that is reachable though the Next Hop. Should use CIDR notation.
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "prefix", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels are key-value string pairs which can be attached to a resource container
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)


@pulumi.input_type
class _NetworkAreaRouteState:
    def __init__(__self__, *,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 network_area_id: Optional[pulumi.Input[_builtins.str]] = None,
                 network_area_route_id: Optional[pulumi.Input[_builtins.str]] = None,
                 next_hop: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 prefix: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering NetworkAreaRoute resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels are key-value string pairs which can be attached to a resource container
        :param pulumi.Input[_builtins.str] network_area_id: The network area ID to which the network area route is associated.
        :param pulumi.Input[_builtins.str] network_area_route_id: The network area route ID.
        :param pulumi.Input[_builtins.str] next_hop: The IP address of the routing system, that will route the prefix configured. Should be a valid IPv4 address.
        :param pulumi.Input[_builtins.str] organization_id: STACKIT organization ID to which the network area is associated.
        :param pulumi.Input[_builtins.str] prefix: The network, that is reachable though the Next Hop. Should use CIDR notation.
        """
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if network_area_id is not None:
            pulumi.set(__self__, "network_area_id", network_area_id)
        if network_area_route_id is not None:
            pulumi.set(__self__, "network_area_route_id", network_area_route_id)
        if next_hop is not None:
            pulumi.set(__self__, "next_hop", next_hop)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels are key-value string pairs which can be attached to a resource container
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="networkAreaId")
    def network_area_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The network area ID to which the network area route is associated.
        """
        return pulumi.get(self, "network_area_id")

    @network_area_id.setter
    def network_area_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_area_id", value)

    @_builtins.property
    @pulumi.getter(name="networkAreaRouteId")
    def network_area_route_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The network area route ID.
        """
        return pulumi.get(self, "network_area_route_id")

    @network_area_route_id.setter
    def network_area_route_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_area_route_id", value)

    @_builtins.property
    @pulumi.getter(name="nextHop")
    def next_hop(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP address of the routing system, that will route the prefix configured. Should be a valid IPv4 address.
        """
        return pulumi.get(self, "next_hop")

    @next_hop.setter
    def next_hop(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "next_hop", value)

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        STACKIT organization ID to which the network area is associated.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization_id", value)

    @_builtins.property
    @pulumi.getter
    def prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The network, that is reachable though the Next Hop. Should use CIDR notation.
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "prefix", value)


@pulumi.type_token("stackit:index/networkAreaRoute:NetworkAreaRoute")
class NetworkAreaRoute(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 network_area_id: Optional[pulumi.Input[_builtins.str]] = None,
                 next_hop: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Network area route resource schema. Must have a `region` specified in the provider configuration.

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels are key-value string pairs which can be attached to a resource container
        :param pulumi.Input[_builtins.str] network_area_id: The network area ID to which the network area route is associated.
        :param pulumi.Input[_builtins.str] next_hop: The IP address of the routing system, that will route the prefix configured. Should be a valid IPv4 address.
        :param pulumi.Input[_builtins.str] organization_id: STACKIT organization ID to which the network area is associated.
        :param pulumi.Input[_builtins.str] prefix: The network, that is reachable though the Next Hop. Should use CIDR notation.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkAreaRouteArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Network area route resource schema. Must have a `region` specified in the provider configuration.

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param NetworkAreaRouteArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkAreaRouteArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 network_area_id: Optional[pulumi.Input[_builtins.str]] = None,
                 next_hop: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkAreaRouteArgs.__new__(NetworkAreaRouteArgs)

            __props__.__dict__["labels"] = labels
            if network_area_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_area_id'")
            __props__.__dict__["network_area_id"] = network_area_id
            if next_hop is None and not opts.urn:
                raise TypeError("Missing required property 'next_hop'")
            __props__.__dict__["next_hop"] = next_hop
            if organization_id is None and not opts.urn:
                raise TypeError("Missing required property 'organization_id'")
            __props__.__dict__["organization_id"] = organization_id
            if prefix is None and not opts.urn:
                raise TypeError("Missing required property 'prefix'")
            __props__.__dict__["prefix"] = prefix
            __props__.__dict__["network_area_route_id"] = None
        super(NetworkAreaRoute, __self__).__init__(
            'stackit:index/networkAreaRoute:NetworkAreaRoute',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            network_area_id: Optional[pulumi.Input[_builtins.str]] = None,
            network_area_route_id: Optional[pulumi.Input[_builtins.str]] = None,
            next_hop: Optional[pulumi.Input[_builtins.str]] = None,
            organization_id: Optional[pulumi.Input[_builtins.str]] = None,
            prefix: Optional[pulumi.Input[_builtins.str]] = None) -> 'NetworkAreaRoute':
        """
        Get an existing NetworkAreaRoute resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels are key-value string pairs which can be attached to a resource container
        :param pulumi.Input[_builtins.str] network_area_id: The network area ID to which the network area route is associated.
        :param pulumi.Input[_builtins.str] network_area_route_id: The network area route ID.
        :param pulumi.Input[_builtins.str] next_hop: The IP address of the routing system, that will route the prefix configured. Should be a valid IPv4 address.
        :param pulumi.Input[_builtins.str] organization_id: STACKIT organization ID to which the network area is associated.
        :param pulumi.Input[_builtins.str] prefix: The network, that is reachable though the Next Hop. Should use CIDR notation.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkAreaRouteState.__new__(_NetworkAreaRouteState)

        __props__.__dict__["labels"] = labels
        __props__.__dict__["network_area_id"] = network_area_id
        __props__.__dict__["network_area_route_id"] = network_area_route_id
        __props__.__dict__["next_hop"] = next_hop
        __props__.__dict__["organization_id"] = organization_id
        __props__.__dict__["prefix"] = prefix
        return NetworkAreaRoute(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Labels are key-value string pairs which can be attached to a resource container
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="networkAreaId")
    def network_area_id(self) -> pulumi.Output[_builtins.str]:
        """
        The network area ID to which the network area route is associated.
        """
        return pulumi.get(self, "network_area_id")

    @_builtins.property
    @pulumi.getter(name="networkAreaRouteId")
    def network_area_route_id(self) -> pulumi.Output[_builtins.str]:
        """
        The network area route ID.
        """
        return pulumi.get(self, "network_area_route_id")

    @_builtins.property
    @pulumi.getter(name="nextHop")
    def next_hop(self) -> pulumi.Output[_builtins.str]:
        """
        The IP address of the routing system, that will route the prefix configured. Should be a valid IPv4 address.
        """
        return pulumi.get(self, "next_hop")

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[_builtins.str]:
        """
        STACKIT organization ID to which the network area is associated.
        """
        return pulumi.get(self, "organization_id")

    @_builtins.property
    @pulumi.getter
    def prefix(self) -> pulumi.Output[_builtins.str]:
        """
        The network, that is reachable though the Next Hop. Should use CIDR notation.
        """
        return pulumi.get(self, "prefix")

