# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ObjectstorageCredentialsGroupArgs', 'ObjectstorageCredentialsGroup']

@pulumi.input_type
class ObjectstorageCredentialsGroupArgs:
    def __init__(__self__, *,
                 project_id: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ObjectstorageCredentialsGroup resource.
        :param pulumi.Input[_builtins.str] project_id: Project ID to which the credentials group is associated.
        :param pulumi.Input[_builtins.str] name: The credentials group's display name.
        :param pulumi.Input[_builtins.str] region: The resource region. If not defined, the provider region is used.
        """
        pulumi.set(__self__, "project_id", project_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.str]:
        """
        Project ID to which the credentials group is associated.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The credentials group's display name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource region. If not defined, the provider region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _ObjectstorageCredentialsGroupState:
    def __init__(__self__, *,
                 credentials_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 urn: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ObjectstorageCredentialsGroup resources.
        :param pulumi.Input[_builtins.str] credentials_group_id: The credentials group ID
        :param pulumi.Input[_builtins.str] name: The credentials group's display name.
        :param pulumi.Input[_builtins.str] project_id: Project ID to which the credentials group is associated.
        :param pulumi.Input[_builtins.str] region: The resource region. If not defined, the provider region is used.
        :param pulumi.Input[_builtins.str] urn: Credentials group uniform resource name (URN)
        """
        if credentials_group_id is not None:
            pulumi.set(__self__, "credentials_group_id", credentials_group_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if urn is not None:
            pulumi.set(__self__, "urn", urn)

    @_builtins.property
    @pulumi.getter(name="credentialsGroupId")
    def credentials_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The credentials group ID
        """
        return pulumi.get(self, "credentials_group_id")

    @credentials_group_id.setter
    def credentials_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "credentials_group_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The credentials group's display name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Project ID to which the credentials group is associated.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource region. If not defined, the provider region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def urn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Credentials group uniform resource name (URN)
        """
        return pulumi.get(self, "urn")

    @urn.setter
    def urn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "urn", value)


@pulumi.type_token("stackit:index/objectstorageCredentialsGroup:ObjectstorageCredentialsGroup")
class ObjectstorageCredentialsGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ObjectStorage credentials group resource schema. Must have a `region` specified in the provider configuration. If you are creating `credentialsgroup` and `bucket` resources simultaneously, please include the `depends_on` field so that they are created sequentially. This prevents errors from concurrent calls to the service enablement that is done in the background.

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: The credentials group's display name.
        :param pulumi.Input[_builtins.str] project_id: Project ID to which the credentials group is associated.
        :param pulumi.Input[_builtins.str] region: The resource region. If not defined, the provider region is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ObjectstorageCredentialsGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ObjectStorage credentials group resource schema. Must have a `region` specified in the provider configuration. If you are creating `credentialsgroup` and `bucket` resources simultaneously, please include the `depends_on` field so that they are created sequentially. This prevents errors from concurrent calls to the service enablement that is done in the background.

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param ObjectstorageCredentialsGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ObjectstorageCredentialsGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ObjectstorageCredentialsGroupArgs.__new__(ObjectstorageCredentialsGroupArgs)

            __props__.__dict__["name"] = name
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["region"] = region
            __props__.__dict__["credentials_group_id"] = None
            __props__.__dict__["urn"] = None
        super(ObjectstorageCredentialsGroup, __self__).__init__(
            'stackit:index/objectstorageCredentialsGroup:ObjectstorageCredentialsGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            credentials_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            urn: Optional[pulumi.Input[_builtins.str]] = None) -> 'ObjectstorageCredentialsGroup':
        """
        Get an existing ObjectstorageCredentialsGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] credentials_group_id: The credentials group ID
        :param pulumi.Input[_builtins.str] name: The credentials group's display name.
        :param pulumi.Input[_builtins.str] project_id: Project ID to which the credentials group is associated.
        :param pulumi.Input[_builtins.str] region: The resource region. If not defined, the provider region is used.
        :param pulumi.Input[_builtins.str] urn: Credentials group uniform resource name (URN)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ObjectstorageCredentialsGroupState.__new__(_ObjectstorageCredentialsGroupState)

        __props__.__dict__["credentials_group_id"] = credentials_group_id
        __props__.__dict__["name"] = name
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["region"] = region
        __props__.__dict__["urn"] = urn
        return ObjectstorageCredentialsGroup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="credentialsGroupId")
    def credentials_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The credentials group ID
        """
        return pulumi.get(self, "credentials_group_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The credentials group's display name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        Project ID to which the credentials group is associated.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The resource region. If not defined, the provider region is used.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def urn(self) -> pulumi.Output[_builtins.str]:
        """
        Credentials group uniform resource name (URN)
        """
        return pulumi.get(self, "urn")

