# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ObservabilityInstanceArgs', 'ObservabilityInstance']

@pulumi.input_type
class ObservabilityInstanceArgs:
    def __init__(__self__, *,
                 plan_name: pulumi.Input[_builtins.str],
                 project_id: pulumi.Input[_builtins.str],
                 acls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 alert_config: Optional[pulumi.Input['ObservabilityInstanceAlertConfigArgs']] = None,
                 metrics_retention_days: Optional[pulumi.Input[_builtins.int]] = None,
                 metrics_retention_days1h_downsampling: Optional[pulumi.Input[_builtins.int]] = None,
                 metrics_retention_days5m_downsampling: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a ObservabilityInstance resource.
        :param pulumi.Input[_builtins.str] plan_name: Specifies the Observability plan. E.g. `Observability-Monitoring-Medium-EU01`.
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the instance is associated.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] acls: The access control list for this instance. Each entry is an IP address range that is permitted to access, in CIDR notation.
        :param pulumi.Input['ObservabilityInstanceAlertConfigArgs'] alert_config: Alert configuration for the instance.
        :param pulumi.Input[_builtins.int] metrics_retention_days: Specifies for how many days the raw metrics are kept.
        :param pulumi.Input[_builtins.int] metrics_retention_days1h_downsampling: Specifies for how many days the 1h downsampled metrics are kept. must be less than the value of the 5m downsampling retention. Default is set to `0` (disabled).
        :param pulumi.Input[_builtins.int] metrics_retention_days5m_downsampling: Specifies for how many days the 5m downsampled metrics are kept. must be less than the value of the general retention. Default is set to `0` (disabled).
        :param pulumi.Input[_builtins.str] name: The name of the Observability instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameters: Additional parameters.
        """
        pulumi.set(__self__, "plan_name", plan_name)
        pulumi.set(__self__, "project_id", project_id)
        if acls is not None:
            pulumi.set(__self__, "acls", acls)
        if alert_config is not None:
            pulumi.set(__self__, "alert_config", alert_config)
        if metrics_retention_days is not None:
            pulumi.set(__self__, "metrics_retention_days", metrics_retention_days)
        if metrics_retention_days1h_downsampling is not None:
            pulumi.set(__self__, "metrics_retention_days1h_downsampling", metrics_retention_days1h_downsampling)
        if metrics_retention_days5m_downsampling is not None:
            pulumi.set(__self__, "metrics_retention_days5m_downsampling", metrics_retention_days5m_downsampling)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @_builtins.property
    @pulumi.getter(name="planName")
    def plan_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the Observability plan. E.g. `Observability-Monitoring-Medium-EU01`.
        """
        return pulumi.get(self, "plan_name")

    @plan_name.setter
    def plan_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "plan_name", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.str]:
        """
        STACKIT project ID to which the instance is associated.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def acls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The access control list for this instance. Each entry is an IP address range that is permitted to access, in CIDR notation.
        """
        return pulumi.get(self, "acls")

    @acls.setter
    def acls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "acls", value)

    @_builtins.property
    @pulumi.getter(name="alertConfig")
    def alert_config(self) -> Optional[pulumi.Input['ObservabilityInstanceAlertConfigArgs']]:
        """
        Alert configuration for the instance.
        """
        return pulumi.get(self, "alert_config")

    @alert_config.setter
    def alert_config(self, value: Optional[pulumi.Input['ObservabilityInstanceAlertConfigArgs']]):
        pulumi.set(self, "alert_config", value)

    @_builtins.property
    @pulumi.getter(name="metricsRetentionDays")
    def metrics_retention_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies for how many days the raw metrics are kept.
        """
        return pulumi.get(self, "metrics_retention_days")

    @metrics_retention_days.setter
    def metrics_retention_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "metrics_retention_days", value)

    @_builtins.property
    @pulumi.getter(name="metricsRetentionDays1hDownsampling")
    def metrics_retention_days1h_downsampling(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies for how many days the 1h downsampled metrics are kept. must be less than the value of the 5m downsampling retention. Default is set to `0` (disabled).
        """
        return pulumi.get(self, "metrics_retention_days1h_downsampling")

    @metrics_retention_days1h_downsampling.setter
    def metrics_retention_days1h_downsampling(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "metrics_retention_days1h_downsampling", value)

    @_builtins.property
    @pulumi.getter(name="metricsRetentionDays5mDownsampling")
    def metrics_retention_days5m_downsampling(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies for how many days the 5m downsampled metrics are kept. must be less than the value of the general retention. Default is set to `0` (disabled).
        """
        return pulumi.get(self, "metrics_retention_days5m_downsampling")

    @metrics_retention_days5m_downsampling.setter
    def metrics_retention_days5m_downsampling(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "metrics_retention_days5m_downsampling", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Observability instance.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Additional parameters.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class _ObservabilityInstanceState:
    def __init__(__self__, *,
                 acls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 alert_config: Optional[pulumi.Input['ObservabilityInstanceAlertConfigArgs']] = None,
                 alerting_url: Optional[pulumi.Input[_builtins.str]] = None,
                 dashboard_url: Optional[pulumi.Input[_builtins.str]] = None,
                 grafana_initial_admin_password: Optional[pulumi.Input[_builtins.str]] = None,
                 grafana_initial_admin_user: Optional[pulumi.Input[_builtins.str]] = None,
                 grafana_public_read_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 grafana_url: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_updatable: Optional[pulumi.Input[_builtins.bool]] = None,
                 jaeger_traces_url: Optional[pulumi.Input[_builtins.str]] = None,
                 jaeger_ui_url: Optional[pulumi.Input[_builtins.str]] = None,
                 logs_push_url: Optional[pulumi.Input[_builtins.str]] = None,
                 logs_url: Optional[pulumi.Input[_builtins.str]] = None,
                 metrics_push_url: Optional[pulumi.Input[_builtins.str]] = None,
                 metrics_retention_days: Optional[pulumi.Input[_builtins.int]] = None,
                 metrics_retention_days1h_downsampling: Optional[pulumi.Input[_builtins.int]] = None,
                 metrics_retention_days5m_downsampling: Optional[pulumi.Input[_builtins.int]] = None,
                 metrics_url: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 otlp_traces_url: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 plan_id: Optional[pulumi.Input[_builtins.str]] = None,
                 plan_name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 targets_url: Optional[pulumi.Input[_builtins.str]] = None,
                 zipkin_spans_url: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ObservabilityInstance resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] acls: The access control list for this instance. Each entry is an IP address range that is permitted to access, in CIDR notation.
        :param pulumi.Input['ObservabilityInstanceAlertConfigArgs'] alert_config: Alert configuration for the instance.
        :param pulumi.Input[_builtins.str] alerting_url: Specifies Alerting URL.
        :param pulumi.Input[_builtins.str] dashboard_url: Specifies Observability instance dashboard URL.
        :param pulumi.Input[_builtins.str] grafana_initial_admin_password: Specifies an initial Grafana admin password.
        :param pulumi.Input[_builtins.str] grafana_initial_admin_user: Specifies an initial Grafana admin username.
        :param pulumi.Input[_builtins.bool] grafana_public_read_access: If true, anyone can access Grafana dashboards without logging in.
        :param pulumi.Input[_builtins.str] grafana_url: Specifies Grafana URL.
        :param pulumi.Input[_builtins.str] instance_id: The Observability instance ID.
        :param pulumi.Input[_builtins.bool] is_updatable: Specifies if the instance can be updated.
        :param pulumi.Input[_builtins.str] logs_push_url: Specifies URL for pushing logs.
        :param pulumi.Input[_builtins.str] logs_url: Specifies Logs URL.
        :param pulumi.Input[_builtins.str] metrics_push_url: Specifies URL for pushing metrics.
        :param pulumi.Input[_builtins.int] metrics_retention_days: Specifies for how many days the raw metrics are kept.
        :param pulumi.Input[_builtins.int] metrics_retention_days1h_downsampling: Specifies for how many days the 1h downsampled metrics are kept. must be less than the value of the 5m downsampling retention. Default is set to `0` (disabled).
        :param pulumi.Input[_builtins.int] metrics_retention_days5m_downsampling: Specifies for how many days the 5m downsampled metrics are kept. must be less than the value of the general retention. Default is set to `0` (disabled).
        :param pulumi.Input[_builtins.str] metrics_url: Specifies metrics URL.
        :param pulumi.Input[_builtins.str] name: The name of the Observability instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameters: Additional parameters.
        :param pulumi.Input[_builtins.str] plan_id: The Observability plan ID.
        :param pulumi.Input[_builtins.str] plan_name: Specifies the Observability plan. E.g. `Observability-Monitoring-Medium-EU01`.
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the instance is associated.
        :param pulumi.Input[_builtins.str] targets_url: Specifies Targets URL.
        """
        if acls is not None:
            pulumi.set(__self__, "acls", acls)
        if alert_config is not None:
            pulumi.set(__self__, "alert_config", alert_config)
        if alerting_url is not None:
            pulumi.set(__self__, "alerting_url", alerting_url)
        if dashboard_url is not None:
            pulumi.set(__self__, "dashboard_url", dashboard_url)
        if grafana_initial_admin_password is not None:
            pulumi.set(__self__, "grafana_initial_admin_password", grafana_initial_admin_password)
        if grafana_initial_admin_user is not None:
            pulumi.set(__self__, "grafana_initial_admin_user", grafana_initial_admin_user)
        if grafana_public_read_access is not None:
            pulumi.set(__self__, "grafana_public_read_access", grafana_public_read_access)
        if grafana_url is not None:
            pulumi.set(__self__, "grafana_url", grafana_url)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if is_updatable is not None:
            pulumi.set(__self__, "is_updatable", is_updatable)
        if jaeger_traces_url is not None:
            pulumi.set(__self__, "jaeger_traces_url", jaeger_traces_url)
        if jaeger_ui_url is not None:
            pulumi.set(__self__, "jaeger_ui_url", jaeger_ui_url)
        if logs_push_url is not None:
            pulumi.set(__self__, "logs_push_url", logs_push_url)
        if logs_url is not None:
            pulumi.set(__self__, "logs_url", logs_url)
        if metrics_push_url is not None:
            pulumi.set(__self__, "metrics_push_url", metrics_push_url)
        if metrics_retention_days is not None:
            pulumi.set(__self__, "metrics_retention_days", metrics_retention_days)
        if metrics_retention_days1h_downsampling is not None:
            pulumi.set(__self__, "metrics_retention_days1h_downsampling", metrics_retention_days1h_downsampling)
        if metrics_retention_days5m_downsampling is not None:
            pulumi.set(__self__, "metrics_retention_days5m_downsampling", metrics_retention_days5m_downsampling)
        if metrics_url is not None:
            pulumi.set(__self__, "metrics_url", metrics_url)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if otlp_traces_url is not None:
            pulumi.set(__self__, "otlp_traces_url", otlp_traces_url)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if plan_id is not None:
            pulumi.set(__self__, "plan_id", plan_id)
        if plan_name is not None:
            pulumi.set(__self__, "plan_name", plan_name)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if targets_url is not None:
            pulumi.set(__self__, "targets_url", targets_url)
        if zipkin_spans_url is not None:
            pulumi.set(__self__, "zipkin_spans_url", zipkin_spans_url)

    @_builtins.property
    @pulumi.getter
    def acls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The access control list for this instance. Each entry is an IP address range that is permitted to access, in CIDR notation.
        """
        return pulumi.get(self, "acls")

    @acls.setter
    def acls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "acls", value)

    @_builtins.property
    @pulumi.getter(name="alertConfig")
    def alert_config(self) -> Optional[pulumi.Input['ObservabilityInstanceAlertConfigArgs']]:
        """
        Alert configuration for the instance.
        """
        return pulumi.get(self, "alert_config")

    @alert_config.setter
    def alert_config(self, value: Optional[pulumi.Input['ObservabilityInstanceAlertConfigArgs']]):
        pulumi.set(self, "alert_config", value)

    @_builtins.property
    @pulumi.getter(name="alertingUrl")
    def alerting_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies Alerting URL.
        """
        return pulumi.get(self, "alerting_url")

    @alerting_url.setter
    def alerting_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alerting_url", value)

    @_builtins.property
    @pulumi.getter(name="dashboardUrl")
    def dashboard_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies Observability instance dashboard URL.
        """
        return pulumi.get(self, "dashboard_url")

    @dashboard_url.setter
    def dashboard_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dashboard_url", value)

    @_builtins.property
    @pulumi.getter(name="grafanaInitialAdminPassword")
    def grafana_initial_admin_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies an initial Grafana admin password.
        """
        return pulumi.get(self, "grafana_initial_admin_password")

    @grafana_initial_admin_password.setter
    def grafana_initial_admin_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "grafana_initial_admin_password", value)

    @_builtins.property
    @pulumi.getter(name="grafanaInitialAdminUser")
    def grafana_initial_admin_user(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies an initial Grafana admin username.
        """
        return pulumi.get(self, "grafana_initial_admin_user")

    @grafana_initial_admin_user.setter
    def grafana_initial_admin_user(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "grafana_initial_admin_user", value)

    @_builtins.property
    @pulumi.getter(name="grafanaPublicReadAccess")
    def grafana_public_read_access(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, anyone can access Grafana dashboards without logging in.
        """
        return pulumi.get(self, "grafana_public_read_access")

    @grafana_public_read_access.setter
    def grafana_public_read_access(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "grafana_public_read_access", value)

    @_builtins.property
    @pulumi.getter(name="grafanaUrl")
    def grafana_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies Grafana URL.
        """
        return pulumi.get(self, "grafana_url")

    @grafana_url.setter
    def grafana_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "grafana_url", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Observability instance ID.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="isUpdatable")
    def is_updatable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if the instance can be updated.
        """
        return pulumi.get(self, "is_updatable")

    @is_updatable.setter
    def is_updatable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_updatable", value)

    @_builtins.property
    @pulumi.getter(name="jaegerTracesUrl")
    def jaeger_traces_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "jaeger_traces_url")

    @jaeger_traces_url.setter
    def jaeger_traces_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "jaeger_traces_url", value)

    @_builtins.property
    @pulumi.getter(name="jaegerUiUrl")
    def jaeger_ui_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "jaeger_ui_url")

    @jaeger_ui_url.setter
    def jaeger_ui_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "jaeger_ui_url", value)

    @_builtins.property
    @pulumi.getter(name="logsPushUrl")
    def logs_push_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies URL for pushing logs.
        """
        return pulumi.get(self, "logs_push_url")

    @logs_push_url.setter
    def logs_push_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "logs_push_url", value)

    @_builtins.property
    @pulumi.getter(name="logsUrl")
    def logs_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies Logs URL.
        """
        return pulumi.get(self, "logs_url")

    @logs_url.setter
    def logs_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "logs_url", value)

    @_builtins.property
    @pulumi.getter(name="metricsPushUrl")
    def metrics_push_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies URL for pushing metrics.
        """
        return pulumi.get(self, "metrics_push_url")

    @metrics_push_url.setter
    def metrics_push_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metrics_push_url", value)

    @_builtins.property
    @pulumi.getter(name="metricsRetentionDays")
    def metrics_retention_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies for how many days the raw metrics are kept.
        """
        return pulumi.get(self, "metrics_retention_days")

    @metrics_retention_days.setter
    def metrics_retention_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "metrics_retention_days", value)

    @_builtins.property
    @pulumi.getter(name="metricsRetentionDays1hDownsampling")
    def metrics_retention_days1h_downsampling(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies for how many days the 1h downsampled metrics are kept. must be less than the value of the 5m downsampling retention. Default is set to `0` (disabled).
        """
        return pulumi.get(self, "metrics_retention_days1h_downsampling")

    @metrics_retention_days1h_downsampling.setter
    def metrics_retention_days1h_downsampling(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "metrics_retention_days1h_downsampling", value)

    @_builtins.property
    @pulumi.getter(name="metricsRetentionDays5mDownsampling")
    def metrics_retention_days5m_downsampling(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies for how many days the 5m downsampled metrics are kept. must be less than the value of the general retention. Default is set to `0` (disabled).
        """
        return pulumi.get(self, "metrics_retention_days5m_downsampling")

    @metrics_retention_days5m_downsampling.setter
    def metrics_retention_days5m_downsampling(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "metrics_retention_days5m_downsampling", value)

    @_builtins.property
    @pulumi.getter(name="metricsUrl")
    def metrics_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies metrics URL.
        """
        return pulumi.get(self, "metrics_url")

    @metrics_url.setter
    def metrics_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metrics_url", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Observability instance.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="otlpTracesUrl")
    def otlp_traces_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "otlp_traces_url")

    @otlp_traces_url.setter
    def otlp_traces_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "otlp_traces_url", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Additional parameters.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter(name="planId")
    def plan_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Observability plan ID.
        """
        return pulumi.get(self, "plan_id")

    @plan_id.setter
    def plan_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plan_id", value)

    @_builtins.property
    @pulumi.getter(name="planName")
    def plan_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Observability plan. E.g. `Observability-Monitoring-Medium-EU01`.
        """
        return pulumi.get(self, "plan_name")

    @plan_name.setter
    def plan_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plan_name", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        STACKIT project ID to which the instance is associated.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="targetsUrl")
    def targets_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies Targets URL.
        """
        return pulumi.get(self, "targets_url")

    @targets_url.setter
    def targets_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "targets_url", value)

    @_builtins.property
    @pulumi.getter(name="zipkinSpansUrl")
    def zipkin_spans_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "zipkin_spans_url")

    @zipkin_spans_url.setter
    def zipkin_spans_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zipkin_spans_url", value)


@pulumi.type_token("stackit:index/observabilityInstance:ObservabilityInstance")
class ObservabilityInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 alert_config: Optional[pulumi.Input[Union['ObservabilityInstanceAlertConfigArgs', 'ObservabilityInstanceAlertConfigArgsDict']]] = None,
                 metrics_retention_days: Optional[pulumi.Input[_builtins.int]] = None,
                 metrics_retention_days1h_downsampling: Optional[pulumi.Input[_builtins.int]] = None,
                 metrics_retention_days5m_downsampling: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 plan_name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Observability instance resource schema. Must have a `region` specified in the provider configuration.

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] acls: The access control list for this instance. Each entry is an IP address range that is permitted to access, in CIDR notation.
        :param pulumi.Input[Union['ObservabilityInstanceAlertConfigArgs', 'ObservabilityInstanceAlertConfigArgsDict']] alert_config: Alert configuration for the instance.
        :param pulumi.Input[_builtins.int] metrics_retention_days: Specifies for how many days the raw metrics are kept.
        :param pulumi.Input[_builtins.int] metrics_retention_days1h_downsampling: Specifies for how many days the 1h downsampled metrics are kept. must be less than the value of the 5m downsampling retention. Default is set to `0` (disabled).
        :param pulumi.Input[_builtins.int] metrics_retention_days5m_downsampling: Specifies for how many days the 5m downsampled metrics are kept. must be less than the value of the general retention. Default is set to `0` (disabled).
        :param pulumi.Input[_builtins.str] name: The name of the Observability instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameters: Additional parameters.
        :param pulumi.Input[_builtins.str] plan_name: Specifies the Observability plan. E.g. `Observability-Monitoring-Medium-EU01`.
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the instance is associated.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ObservabilityInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Observability instance resource schema. Must have a `region` specified in the provider configuration.

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param ObservabilityInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ObservabilityInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 alert_config: Optional[pulumi.Input[Union['ObservabilityInstanceAlertConfigArgs', 'ObservabilityInstanceAlertConfigArgsDict']]] = None,
                 metrics_retention_days: Optional[pulumi.Input[_builtins.int]] = None,
                 metrics_retention_days1h_downsampling: Optional[pulumi.Input[_builtins.int]] = None,
                 metrics_retention_days5m_downsampling: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 plan_name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ObservabilityInstanceArgs.__new__(ObservabilityInstanceArgs)

            __props__.__dict__["acls"] = acls
            __props__.__dict__["alert_config"] = alert_config
            __props__.__dict__["metrics_retention_days"] = metrics_retention_days
            __props__.__dict__["metrics_retention_days1h_downsampling"] = metrics_retention_days1h_downsampling
            __props__.__dict__["metrics_retention_days5m_downsampling"] = metrics_retention_days5m_downsampling
            __props__.__dict__["name"] = name
            __props__.__dict__["parameters"] = parameters
            if plan_name is None and not opts.urn:
                raise TypeError("Missing required property 'plan_name'")
            __props__.__dict__["plan_name"] = plan_name
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["alerting_url"] = None
            __props__.__dict__["dashboard_url"] = None
            __props__.__dict__["grafana_initial_admin_password"] = None
            __props__.__dict__["grafana_initial_admin_user"] = None
            __props__.__dict__["grafana_public_read_access"] = None
            __props__.__dict__["grafana_url"] = None
            __props__.__dict__["instance_id"] = None
            __props__.__dict__["is_updatable"] = None
            __props__.__dict__["jaeger_traces_url"] = None
            __props__.__dict__["jaeger_ui_url"] = None
            __props__.__dict__["logs_push_url"] = None
            __props__.__dict__["logs_url"] = None
            __props__.__dict__["metrics_push_url"] = None
            __props__.__dict__["metrics_url"] = None
            __props__.__dict__["otlp_traces_url"] = None
            __props__.__dict__["plan_id"] = None
            __props__.__dict__["targets_url"] = None
            __props__.__dict__["zipkin_spans_url"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["grafanaInitialAdminPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ObservabilityInstance, __self__).__init__(
            'stackit:index/observabilityInstance:ObservabilityInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            alert_config: Optional[pulumi.Input[Union['ObservabilityInstanceAlertConfigArgs', 'ObservabilityInstanceAlertConfigArgsDict']]] = None,
            alerting_url: Optional[pulumi.Input[_builtins.str]] = None,
            dashboard_url: Optional[pulumi.Input[_builtins.str]] = None,
            grafana_initial_admin_password: Optional[pulumi.Input[_builtins.str]] = None,
            grafana_initial_admin_user: Optional[pulumi.Input[_builtins.str]] = None,
            grafana_public_read_access: Optional[pulumi.Input[_builtins.bool]] = None,
            grafana_url: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            is_updatable: Optional[pulumi.Input[_builtins.bool]] = None,
            jaeger_traces_url: Optional[pulumi.Input[_builtins.str]] = None,
            jaeger_ui_url: Optional[pulumi.Input[_builtins.str]] = None,
            logs_push_url: Optional[pulumi.Input[_builtins.str]] = None,
            logs_url: Optional[pulumi.Input[_builtins.str]] = None,
            metrics_push_url: Optional[pulumi.Input[_builtins.str]] = None,
            metrics_retention_days: Optional[pulumi.Input[_builtins.int]] = None,
            metrics_retention_days1h_downsampling: Optional[pulumi.Input[_builtins.int]] = None,
            metrics_retention_days5m_downsampling: Optional[pulumi.Input[_builtins.int]] = None,
            metrics_url: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            otlp_traces_url: Optional[pulumi.Input[_builtins.str]] = None,
            parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            plan_id: Optional[pulumi.Input[_builtins.str]] = None,
            plan_name: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            targets_url: Optional[pulumi.Input[_builtins.str]] = None,
            zipkin_spans_url: Optional[pulumi.Input[_builtins.str]] = None) -> 'ObservabilityInstance':
        """
        Get an existing ObservabilityInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] acls: The access control list for this instance. Each entry is an IP address range that is permitted to access, in CIDR notation.
        :param pulumi.Input[Union['ObservabilityInstanceAlertConfigArgs', 'ObservabilityInstanceAlertConfigArgsDict']] alert_config: Alert configuration for the instance.
        :param pulumi.Input[_builtins.str] alerting_url: Specifies Alerting URL.
        :param pulumi.Input[_builtins.str] dashboard_url: Specifies Observability instance dashboard URL.
        :param pulumi.Input[_builtins.str] grafana_initial_admin_password: Specifies an initial Grafana admin password.
        :param pulumi.Input[_builtins.str] grafana_initial_admin_user: Specifies an initial Grafana admin username.
        :param pulumi.Input[_builtins.bool] grafana_public_read_access: If true, anyone can access Grafana dashboards without logging in.
        :param pulumi.Input[_builtins.str] grafana_url: Specifies Grafana URL.
        :param pulumi.Input[_builtins.str] instance_id: The Observability instance ID.
        :param pulumi.Input[_builtins.bool] is_updatable: Specifies if the instance can be updated.
        :param pulumi.Input[_builtins.str] logs_push_url: Specifies URL for pushing logs.
        :param pulumi.Input[_builtins.str] logs_url: Specifies Logs URL.
        :param pulumi.Input[_builtins.str] metrics_push_url: Specifies URL for pushing metrics.
        :param pulumi.Input[_builtins.int] metrics_retention_days: Specifies for how many days the raw metrics are kept.
        :param pulumi.Input[_builtins.int] metrics_retention_days1h_downsampling: Specifies for how many days the 1h downsampled metrics are kept. must be less than the value of the 5m downsampling retention. Default is set to `0` (disabled).
        :param pulumi.Input[_builtins.int] metrics_retention_days5m_downsampling: Specifies for how many days the 5m downsampled metrics are kept. must be less than the value of the general retention. Default is set to `0` (disabled).
        :param pulumi.Input[_builtins.str] metrics_url: Specifies metrics URL.
        :param pulumi.Input[_builtins.str] name: The name of the Observability instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameters: Additional parameters.
        :param pulumi.Input[_builtins.str] plan_id: The Observability plan ID.
        :param pulumi.Input[_builtins.str] plan_name: Specifies the Observability plan. E.g. `Observability-Monitoring-Medium-EU01`.
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the instance is associated.
        :param pulumi.Input[_builtins.str] targets_url: Specifies Targets URL.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ObservabilityInstanceState.__new__(_ObservabilityInstanceState)

        __props__.__dict__["acls"] = acls
        __props__.__dict__["alert_config"] = alert_config
        __props__.__dict__["alerting_url"] = alerting_url
        __props__.__dict__["dashboard_url"] = dashboard_url
        __props__.__dict__["grafana_initial_admin_password"] = grafana_initial_admin_password
        __props__.__dict__["grafana_initial_admin_user"] = grafana_initial_admin_user
        __props__.__dict__["grafana_public_read_access"] = grafana_public_read_access
        __props__.__dict__["grafana_url"] = grafana_url
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["is_updatable"] = is_updatable
        __props__.__dict__["jaeger_traces_url"] = jaeger_traces_url
        __props__.__dict__["jaeger_ui_url"] = jaeger_ui_url
        __props__.__dict__["logs_push_url"] = logs_push_url
        __props__.__dict__["logs_url"] = logs_url
        __props__.__dict__["metrics_push_url"] = metrics_push_url
        __props__.__dict__["metrics_retention_days"] = metrics_retention_days
        __props__.__dict__["metrics_retention_days1h_downsampling"] = metrics_retention_days1h_downsampling
        __props__.__dict__["metrics_retention_days5m_downsampling"] = metrics_retention_days5m_downsampling
        __props__.__dict__["metrics_url"] = metrics_url
        __props__.__dict__["name"] = name
        __props__.__dict__["otlp_traces_url"] = otlp_traces_url
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["plan_id"] = plan_id
        __props__.__dict__["plan_name"] = plan_name
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["targets_url"] = targets_url
        __props__.__dict__["zipkin_spans_url"] = zipkin_spans_url
        return ObservabilityInstance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def acls(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The access control list for this instance. Each entry is an IP address range that is permitted to access, in CIDR notation.
        """
        return pulumi.get(self, "acls")

    @_builtins.property
    @pulumi.getter(name="alertConfig")
    def alert_config(self) -> pulumi.Output[Optional['outputs.ObservabilityInstanceAlertConfig']]:
        """
        Alert configuration for the instance.
        """
        return pulumi.get(self, "alert_config")

    @_builtins.property
    @pulumi.getter(name="alertingUrl")
    def alerting_url(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies Alerting URL.
        """
        return pulumi.get(self, "alerting_url")

    @_builtins.property
    @pulumi.getter(name="dashboardUrl")
    def dashboard_url(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies Observability instance dashboard URL.
        """
        return pulumi.get(self, "dashboard_url")

    @_builtins.property
    @pulumi.getter(name="grafanaInitialAdminPassword")
    def grafana_initial_admin_password(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies an initial Grafana admin password.
        """
        return pulumi.get(self, "grafana_initial_admin_password")

    @_builtins.property
    @pulumi.getter(name="grafanaInitialAdminUser")
    def grafana_initial_admin_user(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies an initial Grafana admin username.
        """
        return pulumi.get(self, "grafana_initial_admin_user")

    @_builtins.property
    @pulumi.getter(name="grafanaPublicReadAccess")
    def grafana_public_read_access(self) -> pulumi.Output[_builtins.bool]:
        """
        If true, anyone can access Grafana dashboards without logging in.
        """
        return pulumi.get(self, "grafana_public_read_access")

    @_builtins.property
    @pulumi.getter(name="grafanaUrl")
    def grafana_url(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies Grafana URL.
        """
        return pulumi.get(self, "grafana_url")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Observability instance ID.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="isUpdatable")
    def is_updatable(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies if the instance can be updated.
        """
        return pulumi.get(self, "is_updatable")

    @_builtins.property
    @pulumi.getter(name="jaegerTracesUrl")
    def jaeger_traces_url(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "jaeger_traces_url")

    @_builtins.property
    @pulumi.getter(name="jaegerUiUrl")
    def jaeger_ui_url(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "jaeger_ui_url")

    @_builtins.property
    @pulumi.getter(name="logsPushUrl")
    def logs_push_url(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies URL for pushing logs.
        """
        return pulumi.get(self, "logs_push_url")

    @_builtins.property
    @pulumi.getter(name="logsUrl")
    def logs_url(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies Logs URL.
        """
        return pulumi.get(self, "logs_url")

    @_builtins.property
    @pulumi.getter(name="metricsPushUrl")
    def metrics_push_url(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies URL for pushing metrics.
        """
        return pulumi.get(self, "metrics_push_url")

    @_builtins.property
    @pulumi.getter(name="metricsRetentionDays")
    def metrics_retention_days(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies for how many days the raw metrics are kept.
        """
        return pulumi.get(self, "metrics_retention_days")

    @_builtins.property
    @pulumi.getter(name="metricsRetentionDays1hDownsampling")
    def metrics_retention_days1h_downsampling(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies for how many days the 1h downsampled metrics are kept. must be less than the value of the 5m downsampling retention. Default is set to `0` (disabled).
        """
        return pulumi.get(self, "metrics_retention_days1h_downsampling")

    @_builtins.property
    @pulumi.getter(name="metricsRetentionDays5mDownsampling")
    def metrics_retention_days5m_downsampling(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies for how many days the 5m downsampled metrics are kept. must be less than the value of the general retention. Default is set to `0` (disabled).
        """
        return pulumi.get(self, "metrics_retention_days5m_downsampling")

    @_builtins.property
    @pulumi.getter(name="metricsUrl")
    def metrics_url(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies metrics URL.
        """
        return pulumi.get(self, "metrics_url")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Observability instance.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="otlpTracesUrl")
    def otlp_traces_url(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "otlp_traces_url")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Additional parameters.
        """
        return pulumi.get(self, "parameters")

    @_builtins.property
    @pulumi.getter(name="planId")
    def plan_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Observability plan ID.
        """
        return pulumi.get(self, "plan_id")

    @_builtins.property
    @pulumi.getter(name="planName")
    def plan_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the Observability plan. E.g. `Observability-Monitoring-Medium-EU01`.
        """
        return pulumi.get(self, "plan_name")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        STACKIT project ID to which the instance is associated.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="targetsUrl")
    def targets_url(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies Targets URL.
        """
        return pulumi.get(self, "targets_url")

    @_builtins.property
    @pulumi.getter(name="zipkinSpansUrl")
    def zipkin_spans_url(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "zipkin_spans_url")

