# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ObservabilityScrapeconfigArgs', 'ObservabilityScrapeconfig']

@pulumi.input_type
class ObservabilityScrapeconfigArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[_builtins.str],
                 metrics_path: pulumi.Input[_builtins.str],
                 project_id: pulumi.Input[_builtins.str],
                 targets: pulumi.Input[Sequence[pulumi.Input['ObservabilityScrapeconfigTargetArgs']]],
                 basic_auth: Optional[pulumi.Input['ObservabilityScrapeconfigBasicAuthArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 saml2: Optional[pulumi.Input['ObservabilityScrapeconfigSaml2Args']] = None,
                 sample_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 scheme: Optional[pulumi.Input[_builtins.str]] = None,
                 scrape_interval: Optional[pulumi.Input[_builtins.str]] = None,
                 scrape_timeout: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ObservabilityScrapeconfig resource.
        :param pulumi.Input[_builtins.str] instance_id: Observability instance ID to which the scraping job is associated.
        :param pulumi.Input[_builtins.str] metrics_path: Specifies the job scraping url path. E.g. `/metrics`.
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the scraping job is associated.
        :param pulumi.Input[Sequence[pulumi.Input['ObservabilityScrapeconfigTargetArgs']]] targets: The targets list (specified by the static config).
        :param pulumi.Input['ObservabilityScrapeconfigBasicAuthArgs'] basic_auth: A basic authentication block.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the scraping job.
        :param pulumi.Input['ObservabilityScrapeconfigSaml2Args'] saml2: A SAML2 configuration block.
        :param pulumi.Input[_builtins.int] sample_limit: Specifies the scrape sample limit. Upper limit depends on the service plan. Defaults to `5000`.
        :param pulumi.Input[_builtins.str] scheme: Specifies the http scheme. Defaults to `https`.
        :param pulumi.Input[_builtins.str] scrape_interval: Specifies the scrape interval as duration string. Defaults to `5m`.
        :param pulumi.Input[_builtins.str] scrape_timeout: Specifies the scrape timeout as duration string. Defaults to `2m`.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "metrics_path", metrics_path)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "targets", targets)
        if basic_auth is not None:
            pulumi.set(__self__, "basic_auth", basic_auth)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if saml2 is not None:
            pulumi.set(__self__, "saml2", saml2)
        if sample_limit is not None:
            pulumi.set(__self__, "sample_limit", sample_limit)
        if scheme is not None:
            pulumi.set(__self__, "scheme", scheme)
        if scrape_interval is not None:
            pulumi.set(__self__, "scrape_interval", scrape_interval)
        if scrape_timeout is not None:
            pulumi.set(__self__, "scrape_timeout", scrape_timeout)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        Observability instance ID to which the scraping job is associated.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="metricsPath")
    def metrics_path(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the job scraping url path. E.g. `/metrics`.
        """
        return pulumi.get(self, "metrics_path")

    @metrics_path.setter
    def metrics_path(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "metrics_path", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.str]:
        """
        STACKIT project ID to which the scraping job is associated.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def targets(self) -> pulumi.Input[Sequence[pulumi.Input['ObservabilityScrapeconfigTargetArgs']]]:
        """
        The targets list (specified by the static config).
        """
        return pulumi.get(self, "targets")

    @targets.setter
    def targets(self, value: pulumi.Input[Sequence[pulumi.Input['ObservabilityScrapeconfigTargetArgs']]]):
        pulumi.set(self, "targets", value)

    @_builtins.property
    @pulumi.getter(name="basicAuth")
    def basic_auth(self) -> Optional[pulumi.Input['ObservabilityScrapeconfigBasicAuthArgs']]:
        """
        A basic authentication block.
        """
        return pulumi.get(self, "basic_auth")

    @basic_auth.setter
    def basic_auth(self, value: Optional[pulumi.Input['ObservabilityScrapeconfigBasicAuthArgs']]):
        pulumi.set(self, "basic_auth", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the scraping job.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def saml2(self) -> Optional[pulumi.Input['ObservabilityScrapeconfigSaml2Args']]:
        """
        A SAML2 configuration block.
        """
        return pulumi.get(self, "saml2")

    @saml2.setter
    def saml2(self, value: Optional[pulumi.Input['ObservabilityScrapeconfigSaml2Args']]):
        pulumi.set(self, "saml2", value)

    @_builtins.property
    @pulumi.getter(name="sampleLimit")
    def sample_limit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the scrape sample limit. Upper limit depends on the service plan. Defaults to `5000`.
        """
        return pulumi.get(self, "sample_limit")

    @sample_limit.setter
    def sample_limit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "sample_limit", value)

    @_builtins.property
    @pulumi.getter
    def scheme(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the http scheme. Defaults to `https`.
        """
        return pulumi.get(self, "scheme")

    @scheme.setter
    def scheme(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scheme", value)

    @_builtins.property
    @pulumi.getter(name="scrapeInterval")
    def scrape_interval(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the scrape interval as duration string. Defaults to `5m`.
        """
        return pulumi.get(self, "scrape_interval")

    @scrape_interval.setter
    def scrape_interval(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scrape_interval", value)

    @_builtins.property
    @pulumi.getter(name="scrapeTimeout")
    def scrape_timeout(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the scrape timeout as duration string. Defaults to `2m`.
        """
        return pulumi.get(self, "scrape_timeout")

    @scrape_timeout.setter
    def scrape_timeout(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scrape_timeout", value)


@pulumi.input_type
class _ObservabilityScrapeconfigState:
    def __init__(__self__, *,
                 basic_auth: Optional[pulumi.Input['ObservabilityScrapeconfigBasicAuthArgs']] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 metrics_path: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 saml2: Optional[pulumi.Input['ObservabilityScrapeconfigSaml2Args']] = None,
                 sample_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 scheme: Optional[pulumi.Input[_builtins.str]] = None,
                 scrape_interval: Optional[pulumi.Input[_builtins.str]] = None,
                 scrape_timeout: Optional[pulumi.Input[_builtins.str]] = None,
                 targets: Optional[pulumi.Input[Sequence[pulumi.Input['ObservabilityScrapeconfigTargetArgs']]]] = None):
        """
        Input properties used for looking up and filtering ObservabilityScrapeconfig resources.
        :param pulumi.Input['ObservabilityScrapeconfigBasicAuthArgs'] basic_auth: A basic authentication block.
        :param pulumi.Input[_builtins.str] instance_id: Observability instance ID to which the scraping job is associated.
        :param pulumi.Input[_builtins.str] metrics_path: Specifies the job scraping url path. E.g. `/metrics`.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the scraping job.
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the scraping job is associated.
        :param pulumi.Input['ObservabilityScrapeconfigSaml2Args'] saml2: A SAML2 configuration block.
        :param pulumi.Input[_builtins.int] sample_limit: Specifies the scrape sample limit. Upper limit depends on the service plan. Defaults to `5000`.
        :param pulumi.Input[_builtins.str] scheme: Specifies the http scheme. Defaults to `https`.
        :param pulumi.Input[_builtins.str] scrape_interval: Specifies the scrape interval as duration string. Defaults to `5m`.
        :param pulumi.Input[_builtins.str] scrape_timeout: Specifies the scrape timeout as duration string. Defaults to `2m`.
        :param pulumi.Input[Sequence[pulumi.Input['ObservabilityScrapeconfigTargetArgs']]] targets: The targets list (specified by the static config).
        """
        if basic_auth is not None:
            pulumi.set(__self__, "basic_auth", basic_auth)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if metrics_path is not None:
            pulumi.set(__self__, "metrics_path", metrics_path)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if saml2 is not None:
            pulumi.set(__self__, "saml2", saml2)
        if sample_limit is not None:
            pulumi.set(__self__, "sample_limit", sample_limit)
        if scheme is not None:
            pulumi.set(__self__, "scheme", scheme)
        if scrape_interval is not None:
            pulumi.set(__self__, "scrape_interval", scrape_interval)
        if scrape_timeout is not None:
            pulumi.set(__self__, "scrape_timeout", scrape_timeout)
        if targets is not None:
            pulumi.set(__self__, "targets", targets)

    @_builtins.property
    @pulumi.getter(name="basicAuth")
    def basic_auth(self) -> Optional[pulumi.Input['ObservabilityScrapeconfigBasicAuthArgs']]:
        """
        A basic authentication block.
        """
        return pulumi.get(self, "basic_auth")

    @basic_auth.setter
    def basic_auth(self, value: Optional[pulumi.Input['ObservabilityScrapeconfigBasicAuthArgs']]):
        pulumi.set(self, "basic_auth", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Observability instance ID to which the scraping job is associated.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="metricsPath")
    def metrics_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the job scraping url path. E.g. `/metrics`.
        """
        return pulumi.get(self, "metrics_path")

    @metrics_path.setter
    def metrics_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metrics_path", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the scraping job.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        STACKIT project ID to which the scraping job is associated.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def saml2(self) -> Optional[pulumi.Input['ObservabilityScrapeconfigSaml2Args']]:
        """
        A SAML2 configuration block.
        """
        return pulumi.get(self, "saml2")

    @saml2.setter
    def saml2(self, value: Optional[pulumi.Input['ObservabilityScrapeconfigSaml2Args']]):
        pulumi.set(self, "saml2", value)

    @_builtins.property
    @pulumi.getter(name="sampleLimit")
    def sample_limit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the scrape sample limit. Upper limit depends on the service plan. Defaults to `5000`.
        """
        return pulumi.get(self, "sample_limit")

    @sample_limit.setter
    def sample_limit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "sample_limit", value)

    @_builtins.property
    @pulumi.getter
    def scheme(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the http scheme. Defaults to `https`.
        """
        return pulumi.get(self, "scheme")

    @scheme.setter
    def scheme(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scheme", value)

    @_builtins.property
    @pulumi.getter(name="scrapeInterval")
    def scrape_interval(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the scrape interval as duration string. Defaults to `5m`.
        """
        return pulumi.get(self, "scrape_interval")

    @scrape_interval.setter
    def scrape_interval(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scrape_interval", value)

    @_builtins.property
    @pulumi.getter(name="scrapeTimeout")
    def scrape_timeout(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the scrape timeout as duration string. Defaults to `2m`.
        """
        return pulumi.get(self, "scrape_timeout")

    @scrape_timeout.setter
    def scrape_timeout(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scrape_timeout", value)

    @_builtins.property
    @pulumi.getter
    def targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ObservabilityScrapeconfigTargetArgs']]]]:
        """
        The targets list (specified by the static config).
        """
        return pulumi.get(self, "targets")

    @targets.setter
    def targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ObservabilityScrapeconfigTargetArgs']]]]):
        pulumi.set(self, "targets", value)


@pulumi.type_token("stackit:index/observabilityScrapeconfig:ObservabilityScrapeconfig")
class ObservabilityScrapeconfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 basic_auth: Optional[pulumi.Input[Union['ObservabilityScrapeconfigBasicAuthArgs', 'ObservabilityScrapeconfigBasicAuthArgsDict']]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 metrics_path: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 saml2: Optional[pulumi.Input[Union['ObservabilityScrapeconfigSaml2Args', 'ObservabilityScrapeconfigSaml2ArgsDict']]] = None,
                 sample_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 scheme: Optional[pulumi.Input[_builtins.str]] = None,
                 scrape_interval: Optional[pulumi.Input[_builtins.str]] = None,
                 scrape_timeout: Optional[pulumi.Input[_builtins.str]] = None,
                 targets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ObservabilityScrapeconfigTargetArgs', 'ObservabilityScrapeconfigTargetArgsDict']]]]] = None,
                 __props__=None):
        """
        Observability scrape config resource schema. Must have a `region` specified in the provider configuration.

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ObservabilityScrapeconfigBasicAuthArgs', 'ObservabilityScrapeconfigBasicAuthArgsDict']] basic_auth: A basic authentication block.
        :param pulumi.Input[_builtins.str] instance_id: Observability instance ID to which the scraping job is associated.
        :param pulumi.Input[_builtins.str] metrics_path: Specifies the job scraping url path. E.g. `/metrics`.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the scraping job.
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the scraping job is associated.
        :param pulumi.Input[Union['ObservabilityScrapeconfigSaml2Args', 'ObservabilityScrapeconfigSaml2ArgsDict']] saml2: A SAML2 configuration block.
        :param pulumi.Input[_builtins.int] sample_limit: Specifies the scrape sample limit. Upper limit depends on the service plan. Defaults to `5000`.
        :param pulumi.Input[_builtins.str] scheme: Specifies the http scheme. Defaults to `https`.
        :param pulumi.Input[_builtins.str] scrape_interval: Specifies the scrape interval as duration string. Defaults to `5m`.
        :param pulumi.Input[_builtins.str] scrape_timeout: Specifies the scrape timeout as duration string. Defaults to `2m`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ObservabilityScrapeconfigTargetArgs', 'ObservabilityScrapeconfigTargetArgsDict']]]] targets: The targets list (specified by the static config).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ObservabilityScrapeconfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Observability scrape config resource schema. Must have a `region` specified in the provider configuration.

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param ObservabilityScrapeconfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ObservabilityScrapeconfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 basic_auth: Optional[pulumi.Input[Union['ObservabilityScrapeconfigBasicAuthArgs', 'ObservabilityScrapeconfigBasicAuthArgsDict']]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 metrics_path: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 saml2: Optional[pulumi.Input[Union['ObservabilityScrapeconfigSaml2Args', 'ObservabilityScrapeconfigSaml2ArgsDict']]] = None,
                 sample_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 scheme: Optional[pulumi.Input[_builtins.str]] = None,
                 scrape_interval: Optional[pulumi.Input[_builtins.str]] = None,
                 scrape_timeout: Optional[pulumi.Input[_builtins.str]] = None,
                 targets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ObservabilityScrapeconfigTargetArgs', 'ObservabilityScrapeconfigTargetArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ObservabilityScrapeconfigArgs.__new__(ObservabilityScrapeconfigArgs)

            __props__.__dict__["basic_auth"] = basic_auth
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            if metrics_path is None and not opts.urn:
                raise TypeError("Missing required property 'metrics_path'")
            __props__.__dict__["metrics_path"] = metrics_path
            __props__.__dict__["name"] = name
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["saml2"] = saml2
            __props__.__dict__["sample_limit"] = sample_limit
            __props__.__dict__["scheme"] = scheme
            __props__.__dict__["scrape_interval"] = scrape_interval
            __props__.__dict__["scrape_timeout"] = scrape_timeout
            if targets is None and not opts.urn:
                raise TypeError("Missing required property 'targets'")
            __props__.__dict__["targets"] = targets
        super(ObservabilityScrapeconfig, __self__).__init__(
            'stackit:index/observabilityScrapeconfig:ObservabilityScrapeconfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            basic_auth: Optional[pulumi.Input[Union['ObservabilityScrapeconfigBasicAuthArgs', 'ObservabilityScrapeconfigBasicAuthArgsDict']]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            metrics_path: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            saml2: Optional[pulumi.Input[Union['ObservabilityScrapeconfigSaml2Args', 'ObservabilityScrapeconfigSaml2ArgsDict']]] = None,
            sample_limit: Optional[pulumi.Input[_builtins.int]] = None,
            scheme: Optional[pulumi.Input[_builtins.str]] = None,
            scrape_interval: Optional[pulumi.Input[_builtins.str]] = None,
            scrape_timeout: Optional[pulumi.Input[_builtins.str]] = None,
            targets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ObservabilityScrapeconfigTargetArgs', 'ObservabilityScrapeconfigTargetArgsDict']]]]] = None) -> 'ObservabilityScrapeconfig':
        """
        Get an existing ObservabilityScrapeconfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ObservabilityScrapeconfigBasicAuthArgs', 'ObservabilityScrapeconfigBasicAuthArgsDict']] basic_auth: A basic authentication block.
        :param pulumi.Input[_builtins.str] instance_id: Observability instance ID to which the scraping job is associated.
        :param pulumi.Input[_builtins.str] metrics_path: Specifies the job scraping url path. E.g. `/metrics`.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the scraping job.
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the scraping job is associated.
        :param pulumi.Input[Union['ObservabilityScrapeconfigSaml2Args', 'ObservabilityScrapeconfigSaml2ArgsDict']] saml2: A SAML2 configuration block.
        :param pulumi.Input[_builtins.int] sample_limit: Specifies the scrape sample limit. Upper limit depends on the service plan. Defaults to `5000`.
        :param pulumi.Input[_builtins.str] scheme: Specifies the http scheme. Defaults to `https`.
        :param pulumi.Input[_builtins.str] scrape_interval: Specifies the scrape interval as duration string. Defaults to `5m`.
        :param pulumi.Input[_builtins.str] scrape_timeout: Specifies the scrape timeout as duration string. Defaults to `2m`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ObservabilityScrapeconfigTargetArgs', 'ObservabilityScrapeconfigTargetArgsDict']]]] targets: The targets list (specified by the static config).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ObservabilityScrapeconfigState.__new__(_ObservabilityScrapeconfigState)

        __props__.__dict__["basic_auth"] = basic_auth
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["metrics_path"] = metrics_path
        __props__.__dict__["name"] = name
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["saml2"] = saml2
        __props__.__dict__["sample_limit"] = sample_limit
        __props__.__dict__["scheme"] = scheme
        __props__.__dict__["scrape_interval"] = scrape_interval
        __props__.__dict__["scrape_timeout"] = scrape_timeout
        __props__.__dict__["targets"] = targets
        return ObservabilityScrapeconfig(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="basicAuth")
    def basic_auth(self) -> pulumi.Output['outputs.ObservabilityScrapeconfigBasicAuth']:
        """
        A basic authentication block.
        """
        return pulumi.get(self, "basic_auth")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        Observability instance ID to which the scraping job is associated.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="metricsPath")
    def metrics_path(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the job scraping url path. E.g. `/metrics`.
        """
        return pulumi.get(self, "metrics_path")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the scraping job.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        STACKIT project ID to which the scraping job is associated.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def saml2(self) -> pulumi.Output['outputs.ObservabilityScrapeconfigSaml2']:
        """
        A SAML2 configuration block.
        """
        return pulumi.get(self, "saml2")

    @_builtins.property
    @pulumi.getter(name="sampleLimit")
    def sample_limit(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the scrape sample limit. Upper limit depends on the service plan. Defaults to `5000`.
        """
        return pulumi.get(self, "sample_limit")

    @_builtins.property
    @pulumi.getter
    def scheme(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the http scheme. Defaults to `https`.
        """
        return pulumi.get(self, "scheme")

    @_builtins.property
    @pulumi.getter(name="scrapeInterval")
    def scrape_interval(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the scrape interval as duration string. Defaults to `5m`.
        """
        return pulumi.get(self, "scrape_interval")

    @_builtins.property
    @pulumi.getter(name="scrapeTimeout")
    def scrape_timeout(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the scrape timeout as duration string. Defaults to `2m`.
        """
        return pulumi.get(self, "scrape_timeout")

    @_builtins.property
    @pulumi.getter
    def targets(self) -> pulumi.Output[Sequence['outputs.ObservabilityScrapeconfigTarget']]:
        """
        The targets list (specified by the static config).
        """
        return pulumi.get(self, "targets")

