# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'CdnDistributionConfig',
    'CdnDistributionConfigBackend',
    'CdnDistributionConfigOptimizer',
    'CdnDistributionDomain',
    'ImageChecksum',
    'ImageConfig',
    'LoadbalancerListener',
    'LoadbalancerListenerServerNameIndicator',
    'LoadbalancerNetwork',
    'LoadbalancerOptions',
    'LoadbalancerOptionsObservability',
    'LoadbalancerOptionsObservabilityLogs',
    'LoadbalancerOptionsObservabilityMetrics',
    'LoadbalancerTargetPool',
    'LoadbalancerTargetPoolActiveHealthCheck',
    'LoadbalancerTargetPoolSessionPersistence',
    'LoadbalancerTargetPoolTarget',
    'LogmeInstanceParameters',
    'MariadbInstanceParameters',
    'MongodbflexInstanceFlavor',
    'MongodbflexInstanceOptions',
    'MongodbflexInstanceStorage',
    'NetworkAreaNetworkRange',
    'ObservabilityAlertgroupRule',
    'ObservabilityInstanceAlertConfig',
    'ObservabilityInstanceAlertConfigGlobal',
    'ObservabilityInstanceAlertConfigReceiver',
    'ObservabilityInstanceAlertConfigReceiverEmailConfig',
    'ObservabilityInstanceAlertConfigReceiverOpsgenieConfig',
    'ObservabilityInstanceAlertConfigReceiverWebhooksConfig',
    'ObservabilityInstanceAlertConfigRoute',
    'ObservabilityInstanceAlertConfigRouteRoute',
    'ObservabilityLogalertgroupRule',
    'ObservabilityScrapeconfigBasicAuth',
    'ObservabilityScrapeconfigSaml2',
    'ObservabilityScrapeconfigTarget',
    'OpensearchInstanceParameters',
    'PostgresflexInstanceFlavor',
    'PostgresflexInstanceStorage',
    'RabbitmqInstanceParameters',
    'RedisInstanceParameters',
    'RoutingTableRouteDestination',
    'RoutingTableRouteNextHop',
    'SecurityGroupRuleIcmpParameters',
    'SecurityGroupRulePortRange',
    'SecurityGroupRuleProtocol',
    'ServerBackupScheduleBackupProperties',
    'ServerBootVolume',
    'SkeClusterExtensions',
    'SkeClusterExtensionsAcl',
    'SkeClusterExtensionsArgus',
    'SkeClusterExtensionsDns',
    'SkeClusterExtensionsObservability',
    'SkeClusterHibernation',
    'SkeClusterMaintenance',
    'SkeClusterNetwork',
    'SkeClusterNodePool',
    'SkeClusterNodePoolTaint',
    'SqlserverflexInstanceFlavor',
    'SqlserverflexInstanceOptions',
    'SqlserverflexInstanceStorage',
    'VolumeSource',
    'GetCdnDistributionConfigResult',
    'GetCdnDistributionConfigBackendResult',
    'GetCdnDistributionConfigOptimizerResult',
    'GetCdnDistributionDomainResult',
    'GetImageChecksumResult',
    'GetImageConfigResult',
    'GetLoadbalancerListenerResult',
    'GetLoadbalancerListenerServerNameIndicatorResult',
    'GetLoadbalancerNetworkResult',
    'GetLoadbalancerOptionsResult',
    'GetLoadbalancerOptionsObservabilityResult',
    'GetLoadbalancerOptionsObservabilityLogsResult',
    'GetLoadbalancerOptionsObservabilityMetricsResult',
    'GetLoadbalancerTargetPoolResult',
    'GetLoadbalancerTargetPoolActiveHealthCheckResult',
    'GetLoadbalancerTargetPoolSessionPersistenceResult',
    'GetLoadbalancerTargetPoolTargetResult',
    'GetLogmeInstanceParametersResult',
    'GetMariadbInstanceParametersResult',
    'GetMongodbflexInstanceFlavorResult',
    'GetMongodbflexInstanceOptionsResult',
    'GetMongodbflexInstanceStorageResult',
    'GetNetworkAreaNetworkRangeResult',
    'GetObservabilityAlertgroupRuleResult',
    'GetObservabilityInstanceAlertConfigResult',
    'GetObservabilityInstanceAlertConfigGlobalResult',
    'GetObservabilityInstanceAlertConfigReceiverResult',
    'GetObservabilityInstanceAlertConfigReceiverEmailConfigResult',
    'GetObservabilityInstanceAlertConfigReceiverOpsgenieConfigResult',
    'GetObservabilityInstanceAlertConfigReceiverWebhooksConfigResult',
    'GetObservabilityInstanceAlertConfigRouteResult',
    'GetObservabilityInstanceAlertConfigRouteRouteResult',
    'GetObservabilityLogalertgroupRuleResult',
    'GetObservabilityScrapeconfigBasicAuthResult',
    'GetObservabilityScrapeconfigSaml2Result',
    'GetObservabilityScrapeconfigTargetResult',
    'GetOpensearchInstanceParametersResult',
    'GetPostgresflexInstanceFlavorResult',
    'GetPostgresflexInstanceStorageResult',
    'GetPublicIpRangesPublicIpRangeResult',
    'GetRabbitmqInstanceParametersResult',
    'GetRedisInstanceParametersResult',
    'GetRoutingTableRouteDestinationResult',
    'GetRoutingTableRouteNextHopResult',
    'GetRoutingTableRoutesRouteResult',
    'GetRoutingTableRoutesRouteDestinationResult',
    'GetRoutingTableRoutesRouteNextHopResult',
    'GetRoutingTablesItemResult',
    'GetSecurityGroupRuleIcmpParametersResult',
    'GetSecurityGroupRulePortRangeResult',
    'GetSecurityGroupRuleProtocolResult',
    'GetServerBackupScheduleBackupPropertiesResult',
    'GetServerBackupSchedulesItemResult',
    'GetServerBackupSchedulesItemBackupPropertiesResult',
    'GetServerBootVolumeResult',
    'GetServerUpdateSchedulesItemResult',
    'GetSkeClusterExtensionsResult',
    'GetSkeClusterExtensionsAclResult',
    'GetSkeClusterExtensionsArgusResult',
    'GetSkeClusterExtensionsDnsResult',
    'GetSkeClusterExtensionsObservabilityResult',
    'GetSkeClusterHibernationResult',
    'GetSkeClusterMaintenanceResult',
    'GetSkeClusterNetworkResult',
    'GetSkeClusterNodePoolResult',
    'GetSkeClusterNodePoolTaintResult',
    'GetSqlserverflexInstanceFlavorResult',
    'GetSqlserverflexInstanceOptionsResult',
    'GetSqlserverflexInstanceStorageResult',
    'GetVolumeSourceResult',
]

@pulumi.output_type
class CdnDistributionConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "blockedCountries":
            suggest = "blocked_countries"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CdnDistributionConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CdnDistributionConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CdnDistributionConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backend: 'outputs.CdnDistributionConfigBackend',
                 regions: Sequence[_builtins.str],
                 blocked_countries: Optional[Sequence[_builtins.str]] = None,
                 optimizer: Optional['outputs.CdnDistributionConfigOptimizer'] = None):
        """
        :param 'CdnDistributionConfigBackendArgs' backend: The configured backend for the distribution
        :param Sequence[_builtins.str] regions: The configured regions where content will be hosted
        :param Sequence[_builtins.str] blocked_countries: The configured countries where distribution of content is blocked
        :param 'CdnDistributionConfigOptimizerArgs' optimizer: Configuration for the Image Optimizer. This is a paid feature that automatically optimizes images to reduce their file size for faster delivery, leading to improved website performance and a better user experience.
        """
        pulumi.set(__self__, "backend", backend)
        pulumi.set(__self__, "regions", regions)
        if blocked_countries is not None:
            pulumi.set(__self__, "blocked_countries", blocked_countries)
        if optimizer is not None:
            pulumi.set(__self__, "optimizer", optimizer)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> 'outputs.CdnDistributionConfigBackend':
        """
        The configured backend for the distribution
        """
        return pulumi.get(self, "backend")

    @_builtins.property
    @pulumi.getter
    def regions(self) -> Sequence[_builtins.str]:
        """
        The configured regions where content will be hosted
        """
        return pulumi.get(self, "regions")

    @_builtins.property
    @pulumi.getter(name="blockedCountries")
    def blocked_countries(self) -> Optional[Sequence[_builtins.str]]:
        """
        The configured countries where distribution of content is blocked
        """
        return pulumi.get(self, "blocked_countries")

    @_builtins.property
    @pulumi.getter
    def optimizer(self) -> Optional['outputs.CdnDistributionConfigOptimizer']:
        """
        Configuration for the Image Optimizer. This is a paid feature that automatically optimizes images to reduce their file size for faster delivery, leading to improved website performance and a better user experience.
        """
        return pulumi.get(self, "optimizer")


@pulumi.output_type
class CdnDistributionConfigBackend(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "originUrl":
            suggest = "origin_url"
        elif key == "originRequestHeaders":
            suggest = "origin_request_headers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CdnDistributionConfigBackend. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CdnDistributionConfigBackend.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CdnDistributionConfigBackend.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 origin_url: _builtins.str,
                 type: _builtins.str,
                 origin_request_headers: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param _builtins.str origin_url: The configured backend type for the distribution
        :param _builtins.str type: The configured backend type. Supported values are: `http`.
        :param Mapping[str, _builtins.str] origin_request_headers: The configured origin request headers for the backend
        """
        pulumi.set(__self__, "origin_url", origin_url)
        pulumi.set(__self__, "type", type)
        if origin_request_headers is not None:
            pulumi.set(__self__, "origin_request_headers", origin_request_headers)

    @_builtins.property
    @pulumi.getter(name="originUrl")
    def origin_url(self) -> _builtins.str:
        """
        The configured backend type for the distribution
        """
        return pulumi.get(self, "origin_url")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The configured backend type. Supported values are: `http`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="originRequestHeaders")
    def origin_request_headers(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        The configured origin request headers for the backend
        """
        return pulumi.get(self, "origin_request_headers")


@pulumi.output_type
class CdnDistributionConfigOptimizer(dict):
    def __init__(__self__, *,
                 enabled: Optional[_builtins.bool] = None):
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "enabled")


@pulumi.output_type
class CdnDistributionDomain(dict):
    def __init__(__self__, *,
                 errors: Optional[Sequence[_builtins.str]] = None,
                 name: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param Sequence[_builtins.str] errors: List of domain errors
        :param _builtins.str name: The name of the domain
        :param _builtins.str status: The status of the domain
        :param _builtins.str type: The type of the domain. Each distribution has one domain of type "managed", and domains of type "custom" may be additionally created by the user
        """
        if errors is not None:
            pulumi.set(__self__, "errors", errors)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def errors(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of domain errors
        """
        return pulumi.get(self, "errors")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of the domain
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The status of the domain
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The type of the domain. Each distribution has one domain of type "managed", and domains of type "custom" may be additionally created by the user
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ImageChecksum(dict):
    def __init__(__self__, *,
                 algorithm: Optional[_builtins.str] = None,
                 digest: Optional[_builtins.str] = None):
        """
        :param _builtins.str algorithm: Algorithm for the checksum of the image data.
        :param _builtins.str digest: Hexdigest of the checksum of the image data.
        """
        if algorithm is not None:
            pulumi.set(__self__, "algorithm", algorithm)
        if digest is not None:
            pulumi.set(__self__, "digest", digest)

    @_builtins.property
    @pulumi.getter
    def algorithm(self) -> Optional[_builtins.str]:
        """
        Algorithm for the checksum of the image data.
        """
        return pulumi.get(self, "algorithm")

    @_builtins.property
    @pulumi.getter
    def digest(self) -> Optional[_builtins.str]:
        """
        Hexdigest of the checksum of the image data.
        """
        return pulumi.get(self, "digest")


@pulumi.output_type
class ImageConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bootMenu":
            suggest = "boot_menu"
        elif key == "cdromBus":
            suggest = "cdrom_bus"
        elif key == "diskBus":
            suggest = "disk_bus"
        elif key == "nicModel":
            suggest = "nic_model"
        elif key == "operatingSystem":
            suggest = "operating_system"
        elif key == "operatingSystemDistro":
            suggest = "operating_system_distro"
        elif key == "operatingSystemVersion":
            suggest = "operating_system_version"
        elif key == "rescueBus":
            suggest = "rescue_bus"
        elif key == "rescueDevice":
            suggest = "rescue_device"
        elif key == "secureBoot":
            suggest = "secure_boot"
        elif key == "videoModel":
            suggest = "video_model"
        elif key == "virtioScsi":
            suggest = "virtio_scsi"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 boot_menu: Optional[_builtins.bool] = None,
                 cdrom_bus: Optional[_builtins.str] = None,
                 disk_bus: Optional[_builtins.str] = None,
                 nic_model: Optional[_builtins.str] = None,
                 operating_system: Optional[_builtins.str] = None,
                 operating_system_distro: Optional[_builtins.str] = None,
                 operating_system_version: Optional[_builtins.str] = None,
                 rescue_bus: Optional[_builtins.str] = None,
                 rescue_device: Optional[_builtins.str] = None,
                 secure_boot: Optional[_builtins.bool] = None,
                 uefi: Optional[_builtins.bool] = None,
                 video_model: Optional[_builtins.str] = None,
                 virtio_scsi: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool boot_menu: Enables the BIOS bootmenu.
        :param _builtins.str cdrom_bus: Sets CDROM bus controller type.
        :param _builtins.str disk_bus: Sets Disk bus controller type.
        :param _builtins.str nic_model: Sets virtual network interface model.
        :param _builtins.str operating_system: Enables operating system specific optimizations.
        :param _builtins.str operating_system_distro: Operating system distribution.
        :param _builtins.str operating_system_version: Version of the operating system.
        :param _builtins.str rescue_bus: Sets the device bus when the image is used as a rescue image.
        :param _builtins.str rescue_device: Sets the device when the image is used as a rescue image.
        :param _builtins.bool secure_boot: Enables Secure Boot.
        :param _builtins.bool uefi: Enables UEFI boot.
        :param _builtins.str video_model: Sets Graphic device model.
        :param _builtins.bool virtio_scsi: Enables the use of VirtIO SCSI to provide block device access. By default instances use VirtIO Block.
        """
        if boot_menu is not None:
            pulumi.set(__self__, "boot_menu", boot_menu)
        if cdrom_bus is not None:
            pulumi.set(__self__, "cdrom_bus", cdrom_bus)
        if disk_bus is not None:
            pulumi.set(__self__, "disk_bus", disk_bus)
        if nic_model is not None:
            pulumi.set(__self__, "nic_model", nic_model)
        if operating_system is not None:
            pulumi.set(__self__, "operating_system", operating_system)
        if operating_system_distro is not None:
            pulumi.set(__self__, "operating_system_distro", operating_system_distro)
        if operating_system_version is not None:
            pulumi.set(__self__, "operating_system_version", operating_system_version)
        if rescue_bus is not None:
            pulumi.set(__self__, "rescue_bus", rescue_bus)
        if rescue_device is not None:
            pulumi.set(__self__, "rescue_device", rescue_device)
        if secure_boot is not None:
            pulumi.set(__self__, "secure_boot", secure_boot)
        if uefi is not None:
            pulumi.set(__self__, "uefi", uefi)
        if video_model is not None:
            pulumi.set(__self__, "video_model", video_model)
        if virtio_scsi is not None:
            pulumi.set(__self__, "virtio_scsi", virtio_scsi)

    @_builtins.property
    @pulumi.getter(name="bootMenu")
    def boot_menu(self) -> Optional[_builtins.bool]:
        """
        Enables the BIOS bootmenu.
        """
        return pulumi.get(self, "boot_menu")

    @_builtins.property
    @pulumi.getter(name="cdromBus")
    def cdrom_bus(self) -> Optional[_builtins.str]:
        """
        Sets CDROM bus controller type.
        """
        return pulumi.get(self, "cdrom_bus")

    @_builtins.property
    @pulumi.getter(name="diskBus")
    def disk_bus(self) -> Optional[_builtins.str]:
        """
        Sets Disk bus controller type.
        """
        return pulumi.get(self, "disk_bus")

    @_builtins.property
    @pulumi.getter(name="nicModel")
    def nic_model(self) -> Optional[_builtins.str]:
        """
        Sets virtual network interface model.
        """
        return pulumi.get(self, "nic_model")

    @_builtins.property
    @pulumi.getter(name="operatingSystem")
    def operating_system(self) -> Optional[_builtins.str]:
        """
        Enables operating system specific optimizations.
        """
        return pulumi.get(self, "operating_system")

    @_builtins.property
    @pulumi.getter(name="operatingSystemDistro")
    def operating_system_distro(self) -> Optional[_builtins.str]:
        """
        Operating system distribution.
        """
        return pulumi.get(self, "operating_system_distro")

    @_builtins.property
    @pulumi.getter(name="operatingSystemVersion")
    def operating_system_version(self) -> Optional[_builtins.str]:
        """
        Version of the operating system.
        """
        return pulumi.get(self, "operating_system_version")

    @_builtins.property
    @pulumi.getter(name="rescueBus")
    def rescue_bus(self) -> Optional[_builtins.str]:
        """
        Sets the device bus when the image is used as a rescue image.
        """
        return pulumi.get(self, "rescue_bus")

    @_builtins.property
    @pulumi.getter(name="rescueDevice")
    def rescue_device(self) -> Optional[_builtins.str]:
        """
        Sets the device when the image is used as a rescue image.
        """
        return pulumi.get(self, "rescue_device")

    @_builtins.property
    @pulumi.getter(name="secureBoot")
    def secure_boot(self) -> Optional[_builtins.bool]:
        """
        Enables Secure Boot.
        """
        return pulumi.get(self, "secure_boot")

    @_builtins.property
    @pulumi.getter
    def uefi(self) -> Optional[_builtins.bool]:
        """
        Enables UEFI boot.
        """
        return pulumi.get(self, "uefi")

    @_builtins.property
    @pulumi.getter(name="videoModel")
    def video_model(self) -> Optional[_builtins.str]:
        """
        Sets Graphic device model.
        """
        return pulumi.get(self, "video_model")

    @_builtins.property
    @pulumi.getter(name="virtioScsi")
    def virtio_scsi(self) -> Optional[_builtins.bool]:
        """
        Enables the use of VirtIO SCSI to provide block device access. By default instances use VirtIO Block.
        """
        return pulumi.get(self, "virtio_scsi")


@pulumi.output_type
class LoadbalancerListener(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetPool":
            suggest = "target_pool"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "serverNameIndicators":
            suggest = "server_name_indicators"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadbalancerListener. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadbalancerListener.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadbalancerListener.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 port: _builtins.int,
                 protocol: _builtins.str,
                 target_pool: _builtins.str,
                 display_name: Optional[_builtins.str] = None,
                 server_name_indicators: Optional[Sequence['outputs.LoadbalancerListenerServerNameIndicator']] = None):
        """
        :param _builtins.int port: Port number where we listen for traffic.
        :param _builtins.str protocol: Protocol is the highest network protocol we understand to load balance. Supported values are: `PROTOCOL_UNSPECIFIED`, `PROTOCOL_TCP`, `PROTOCOL_UDP`, `PROTOCOL_TCP_PROXY`, `PROTOCOL_TLS_PASSTHROUGH`.
        :param _builtins.str target_pool: Reference target pool by target pool name.
        :param Sequence['LoadbalancerListenerServerNameIndicatorArgs'] server_name_indicators: A list of domain names to match in order to pass TLS traffic to the target pool in the current listener
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "target_pool", target_pool)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if server_name_indicators is not None:
            pulumi.set(__self__, "server_name_indicators", server_name_indicators)

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        Port number where we listen for traffic.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        Protocol is the highest network protocol we understand to load balance. Supported values are: `PROTOCOL_UNSPECIFIED`, `PROTOCOL_TCP`, `PROTOCOL_UDP`, `PROTOCOL_TCP_PROXY`, `PROTOCOL_TLS_PASSTHROUGH`.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="targetPool")
    def target_pool(self) -> _builtins.str:
        """
        Reference target pool by target pool name.
        """
        return pulumi.get(self, "target_pool")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="serverNameIndicators")
    def server_name_indicators(self) -> Optional[Sequence['outputs.LoadbalancerListenerServerNameIndicator']]:
        """
        A list of domain names to match in order to pass TLS traffic to the target pool in the current listener
        """
        return pulumi.get(self, "server_name_indicators")


@pulumi.output_type
class LoadbalancerListenerServerNameIndicator(dict):
    def __init__(__self__, *,
                 name: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: A domain name to match in order to pass TLS traffic to the target pool in the current listener
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        A domain name to match in order to pass TLS traffic to the target pool in the current listener
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class LoadbalancerNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkId":
            suggest = "network_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadbalancerNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadbalancerNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadbalancerNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 network_id: _builtins.str,
                 role: _builtins.str):
        """
        :param _builtins.str network_id: Openstack network ID.
        :param _builtins.str role: The role defines how the load balancer is using the network. Supported values are: `ROLE_UNSPECIFIED`, `ROLE_LISTENERS_AND_TARGETS`, `ROLE_LISTENERS`, `ROLE_TARGETS`.
        """
        pulumi.set(__self__, "network_id", network_id)
        pulumi.set(__self__, "role", role)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> _builtins.str:
        """
        Openstack network ID.
        """
        return pulumi.get(self, "network_id")

    @_builtins.property
    @pulumi.getter
    def role(self) -> _builtins.str:
        """
        The role defines how the load balancer is using the network. Supported values are: `ROLE_UNSPECIFIED`, `ROLE_LISTENERS_AND_TARGETS`, `ROLE_LISTENERS`, `ROLE_TARGETS`.
        """
        return pulumi.get(self, "role")


@pulumi.output_type
class LoadbalancerOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateNetworkOnly":
            suggest = "private_network_only"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadbalancerOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadbalancerOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadbalancerOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 acls: Optional[Sequence[_builtins.str]] = None,
                 observability: Optional['outputs.LoadbalancerOptionsObservability'] = None,
                 private_network_only: Optional[_builtins.bool] = None):
        """
        :param Sequence[_builtins.str] acls: Load Balancer is accessible only from an IP address in this range.
        :param 'LoadbalancerOptionsObservabilityArgs' observability: We offer Load Balancer metrics observability via ARGUS or external solutions. Not changeable after creation.
        :param _builtins.bool private_network_only: If true, Load Balancer is accessible only via a private network IP address.
        """
        if acls is not None:
            pulumi.set(__self__, "acls", acls)
        if observability is not None:
            pulumi.set(__self__, "observability", observability)
        if private_network_only is not None:
            pulumi.set(__self__, "private_network_only", private_network_only)

    @_builtins.property
    @pulumi.getter
    def acls(self) -> Optional[Sequence[_builtins.str]]:
        """
        Load Balancer is accessible only from an IP address in this range.
        """
        return pulumi.get(self, "acls")

    @_builtins.property
    @pulumi.getter
    def observability(self) -> Optional['outputs.LoadbalancerOptionsObservability']:
        """
        We offer Load Balancer metrics observability via ARGUS or external solutions. Not changeable after creation.
        """
        return pulumi.get(self, "observability")

    @_builtins.property
    @pulumi.getter(name="privateNetworkOnly")
    def private_network_only(self) -> Optional[_builtins.bool]:
        """
        If true, Load Balancer is accessible only via a private network IP address.
        """
        return pulumi.get(self, "private_network_only")


@pulumi.output_type
class LoadbalancerOptionsObservability(dict):
    def __init__(__self__, *,
                 logs: Optional['outputs.LoadbalancerOptionsObservabilityLogs'] = None,
                 metrics: Optional['outputs.LoadbalancerOptionsObservabilityMetrics'] = None):
        """
        :param 'LoadbalancerOptionsObservabilityLogsArgs' logs: Observability logs configuration. Not changeable after creation.
        :param 'LoadbalancerOptionsObservabilityMetricsArgs' metrics: Observability metrics configuration. Not changeable after creation.
        """
        if logs is not None:
            pulumi.set(__self__, "logs", logs)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)

    @_builtins.property
    @pulumi.getter
    def logs(self) -> Optional['outputs.LoadbalancerOptionsObservabilityLogs']:
        """
        Observability logs configuration. Not changeable after creation.
        """
        return pulumi.get(self, "logs")

    @_builtins.property
    @pulumi.getter
    def metrics(self) -> Optional['outputs.LoadbalancerOptionsObservabilityMetrics']:
        """
        Observability metrics configuration. Not changeable after creation.
        """
        return pulumi.get(self, "metrics")


@pulumi.output_type
class LoadbalancerOptionsObservabilityLogs(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "credentialsRef":
            suggest = "credentials_ref"
        elif key == "pushUrl":
            suggest = "push_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadbalancerOptionsObservabilityLogs. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadbalancerOptionsObservabilityLogs.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadbalancerOptionsObservabilityLogs.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 credentials_ref: Optional[_builtins.str] = None,
                 push_url: Optional[_builtins.str] = None):
        """
        :param _builtins.str credentials_ref: Credentials reference for logs. Not changeable after creation.
        :param _builtins.str push_url: Credentials reference for logs. Not changeable after creation.
        """
        if credentials_ref is not None:
            pulumi.set(__self__, "credentials_ref", credentials_ref)
        if push_url is not None:
            pulumi.set(__self__, "push_url", push_url)

    @_builtins.property
    @pulumi.getter(name="credentialsRef")
    def credentials_ref(self) -> Optional[_builtins.str]:
        """
        Credentials reference for logs. Not changeable after creation.
        """
        return pulumi.get(self, "credentials_ref")

    @_builtins.property
    @pulumi.getter(name="pushUrl")
    def push_url(self) -> Optional[_builtins.str]:
        """
        Credentials reference for logs. Not changeable after creation.
        """
        return pulumi.get(self, "push_url")


@pulumi.output_type
class LoadbalancerOptionsObservabilityMetrics(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "credentialsRef":
            suggest = "credentials_ref"
        elif key == "pushUrl":
            suggest = "push_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadbalancerOptionsObservabilityMetrics. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadbalancerOptionsObservabilityMetrics.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadbalancerOptionsObservabilityMetrics.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 credentials_ref: Optional[_builtins.str] = None,
                 push_url: Optional[_builtins.str] = None):
        """
        :param _builtins.str credentials_ref: Credentials reference for metrics. Not changeable after creation.
        :param _builtins.str push_url: Credentials reference for metrics. Not changeable after creation.
        """
        if credentials_ref is not None:
            pulumi.set(__self__, "credentials_ref", credentials_ref)
        if push_url is not None:
            pulumi.set(__self__, "push_url", push_url)

    @_builtins.property
    @pulumi.getter(name="credentialsRef")
    def credentials_ref(self) -> Optional[_builtins.str]:
        """
        Credentials reference for metrics. Not changeable after creation.
        """
        return pulumi.get(self, "credentials_ref")

    @_builtins.property
    @pulumi.getter(name="pushUrl")
    def push_url(self) -> Optional[_builtins.str]:
        """
        Credentials reference for metrics. Not changeable after creation.
        """
        return pulumi.get(self, "push_url")


@pulumi.output_type
class LoadbalancerTargetPool(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetPort":
            suggest = "target_port"
        elif key == "activeHealthCheck":
            suggest = "active_health_check"
        elif key == "sessionPersistence":
            suggest = "session_persistence"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadbalancerTargetPool. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadbalancerTargetPool.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadbalancerTargetPool.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 target_port: _builtins.int,
                 targets: Sequence['outputs.LoadbalancerTargetPoolTarget'],
                 active_health_check: Optional['outputs.LoadbalancerTargetPoolActiveHealthCheck'] = None,
                 session_persistence: Optional['outputs.LoadbalancerTargetPoolSessionPersistence'] = None):
        """
        :param _builtins.str name: Target pool name.
        :param _builtins.int target_port: Identical port number where each target listens for traffic.
        :param Sequence['LoadbalancerTargetPoolTargetArgs'] targets: List of all targets which will be used in the pool. Limited to 1000.
        :param 'LoadbalancerTargetPoolSessionPersistenceArgs' session_persistence: Here you can setup various session persistence options, so far only "`use_source_ip_address`" is supported.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "target_port", target_port)
        pulumi.set(__self__, "targets", targets)
        if active_health_check is not None:
            pulumi.set(__self__, "active_health_check", active_health_check)
        if session_persistence is not None:
            pulumi.set(__self__, "session_persistence", session_persistence)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Target pool name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="targetPort")
    def target_port(self) -> _builtins.int:
        """
        Identical port number where each target listens for traffic.
        """
        return pulumi.get(self, "target_port")

    @_builtins.property
    @pulumi.getter
    def targets(self) -> Sequence['outputs.LoadbalancerTargetPoolTarget']:
        """
        List of all targets which will be used in the pool. Limited to 1000.
        """
        return pulumi.get(self, "targets")

    @_builtins.property
    @pulumi.getter(name="activeHealthCheck")
    def active_health_check(self) -> Optional['outputs.LoadbalancerTargetPoolActiveHealthCheck']:
        return pulumi.get(self, "active_health_check")

    @_builtins.property
    @pulumi.getter(name="sessionPersistence")
    def session_persistence(self) -> Optional['outputs.LoadbalancerTargetPoolSessionPersistence']:
        """
        Here you can setup various session persistence options, so far only "`use_source_ip_address`" is supported.
        """
        return pulumi.get(self, "session_persistence")


@pulumi.output_type
class LoadbalancerTargetPoolActiveHealthCheck(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "healthyThreshold":
            suggest = "healthy_threshold"
        elif key == "intervalJitter":
            suggest = "interval_jitter"
        elif key == "unhealthyThreshold":
            suggest = "unhealthy_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadbalancerTargetPoolActiveHealthCheck. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadbalancerTargetPoolActiveHealthCheck.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadbalancerTargetPoolActiveHealthCheck.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 healthy_threshold: Optional[_builtins.int] = None,
                 interval: Optional[_builtins.str] = None,
                 interval_jitter: Optional[_builtins.str] = None,
                 timeout: Optional[_builtins.str] = None,
                 unhealthy_threshold: Optional[_builtins.int] = None):
        """
        :param _builtins.int healthy_threshold: Healthy threshold of the health checking.
        :param _builtins.str interval: Interval duration of health checking in seconds.
        :param _builtins.str interval_jitter: Interval duration threshold of the health checking in seconds.
        :param _builtins.str timeout: Active health checking timeout duration in seconds.
        :param _builtins.int unhealthy_threshold: Unhealthy threshold of the health checking.
        """
        if healthy_threshold is not None:
            pulumi.set(__self__, "healthy_threshold", healthy_threshold)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if interval_jitter is not None:
            pulumi.set(__self__, "interval_jitter", interval_jitter)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if unhealthy_threshold is not None:
            pulumi.set(__self__, "unhealthy_threshold", unhealthy_threshold)

    @_builtins.property
    @pulumi.getter(name="healthyThreshold")
    def healthy_threshold(self) -> Optional[_builtins.int]:
        """
        Healthy threshold of the health checking.
        """
        return pulumi.get(self, "healthy_threshold")

    @_builtins.property
    @pulumi.getter
    def interval(self) -> Optional[_builtins.str]:
        """
        Interval duration of health checking in seconds.
        """
        return pulumi.get(self, "interval")

    @_builtins.property
    @pulumi.getter(name="intervalJitter")
    def interval_jitter(self) -> Optional[_builtins.str]:
        """
        Interval duration threshold of the health checking in seconds.
        """
        return pulumi.get(self, "interval_jitter")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[_builtins.str]:
        """
        Active health checking timeout duration in seconds.
        """
        return pulumi.get(self, "timeout")

    @_builtins.property
    @pulumi.getter(name="unhealthyThreshold")
    def unhealthy_threshold(self) -> Optional[_builtins.int]:
        """
        Unhealthy threshold of the health checking.
        """
        return pulumi.get(self, "unhealthy_threshold")


@pulumi.output_type
class LoadbalancerTargetPoolSessionPersistence(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "useSourceIpAddress":
            suggest = "use_source_ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadbalancerTargetPoolSessionPersistence. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadbalancerTargetPoolSessionPersistence.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadbalancerTargetPoolSessionPersistence.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 use_source_ip_address: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool use_source_ip_address: If true then all connections from one source IP address are redirected to the same target. This setting changes the load balancing algorithm to Maglev.
        """
        if use_source_ip_address is not None:
            pulumi.set(__self__, "use_source_ip_address", use_source_ip_address)

    @_builtins.property
    @pulumi.getter(name="useSourceIpAddress")
    def use_source_ip_address(self) -> Optional[_builtins.bool]:
        """
        If true then all connections from one source IP address are redirected to the same target. This setting changes the load balancing algorithm to Maglev.
        """
        return pulumi.get(self, "use_source_ip_address")


@pulumi.output_type
class LoadbalancerTargetPoolTarget(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadbalancerTargetPoolTarget. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadbalancerTargetPoolTarget.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadbalancerTargetPoolTarget.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 display_name: _builtins.str,
                 ip: _builtins.str):
        """
        :param _builtins.str display_name: Target display name
        :param _builtins.str ip: Target IP
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "ip", ip)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        Target display name
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def ip(self) -> _builtins.str:
        """
        Target IP
        """
        return pulumi.get(self, "ip")


@pulumi.output_type
class LogmeInstanceParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableMonitoring":
            suggest = "enable_monitoring"
        elif key == "fluentdTcp":
            suggest = "fluentd_tcp"
        elif key == "fluentdTls":
            suggest = "fluentd_tls"
        elif key == "fluentdTlsCiphers":
            suggest = "fluentd_tls_ciphers"
        elif key == "fluentdTlsMaxVersion":
            suggest = "fluentd_tls_max_version"
        elif key == "fluentdTlsMinVersion":
            suggest = "fluentd_tls_min_version"
        elif key == "fluentdTlsVersion":
            suggest = "fluentd_tls_version"
        elif key == "fluentdUdp":
            suggest = "fluentd_udp"
        elif key == "ismDeletionAfter":
            suggest = "ism_deletion_after"
        elif key == "ismJitter":
            suggest = "ism_jitter"
        elif key == "ismJobInterval":
            suggest = "ism_job_interval"
        elif key == "javaHeapspace":
            suggest = "java_heapspace"
        elif key == "javaMaxmetaspace":
            suggest = "java_maxmetaspace"
        elif key == "maxDiskThreshold":
            suggest = "max_disk_threshold"
        elif key == "metricsFrequency":
            suggest = "metrics_frequency"
        elif key == "metricsPrefix":
            suggest = "metrics_prefix"
        elif key == "monitoringInstanceId":
            suggest = "monitoring_instance_id"
        elif key == "opensearchTlsCiphers":
            suggest = "opensearch_tls_ciphers"
        elif key == "opensearchTlsProtocols":
            suggest = "opensearch_tls_protocols"
        elif key == "sgwAcl":
            suggest = "sgw_acl"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LogmeInstanceParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LogmeInstanceParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LogmeInstanceParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_monitoring: Optional[_builtins.bool] = None,
                 fluentd_tcp: Optional[_builtins.int] = None,
                 fluentd_tls: Optional[_builtins.int] = None,
                 fluentd_tls_ciphers: Optional[_builtins.str] = None,
                 fluentd_tls_max_version: Optional[_builtins.str] = None,
                 fluentd_tls_min_version: Optional[_builtins.str] = None,
                 fluentd_tls_version: Optional[_builtins.str] = None,
                 fluentd_udp: Optional[_builtins.int] = None,
                 graphite: Optional[_builtins.str] = None,
                 ism_deletion_after: Optional[_builtins.str] = None,
                 ism_jitter: Optional[_builtins.float] = None,
                 ism_job_interval: Optional[_builtins.int] = None,
                 java_heapspace: Optional[_builtins.int] = None,
                 java_maxmetaspace: Optional[_builtins.int] = None,
                 max_disk_threshold: Optional[_builtins.int] = None,
                 metrics_frequency: Optional[_builtins.int] = None,
                 metrics_prefix: Optional[_builtins.str] = None,
                 monitoring_instance_id: Optional[_builtins.str] = None,
                 opensearch_tls_ciphers: Optional[Sequence[_builtins.str]] = None,
                 opensearch_tls_protocols: Optional[Sequence[_builtins.str]] = None,
                 sgw_acl: Optional[_builtins.str] = None,
                 syslogs: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.bool enable_monitoring: Enable monitoring.
        :param _builtins.str graphite: If set, monitoring with Graphite will be enabled. Expects the host and port where the Graphite metrics should be sent to (host:port).
        :param _builtins.str ism_deletion_after: Combination of an integer and a timerange when an index will be considered "old" and can be deleted. Possible values for the timerange are `s`, `m`, `h` and `d`.
        :param _builtins.int ism_job_interval: Jitter of the execution time.
        :param _builtins.int java_heapspace: The amount of memory (in MB) allocated as heap by the JVM for OpenSearch.
        :param _builtins.int java_maxmetaspace: The amount of memory (in MB) used by the JVM to store metadata for OpenSearch.
        :param _builtins.int max_disk_threshold: The maximum disk threshold in MB. If the disk usage exceeds this threshold, the instance will be stopped.
        :param _builtins.int metrics_frequency: The frequency in seconds at which metrics are emitted (in seconds).
        :param _builtins.str metrics_prefix: The prefix for the metrics. Could be useful when using Graphite monitoring to prefix the metrics with a certain value, like an API key.
        :param _builtins.str monitoring_instance_id: The ID of the STACKIT monitoring instance.
        :param _builtins.str sgw_acl: Comma separated list of IP networks in CIDR notation which are allowed to access this instance.
        :param Sequence[_builtins.str] syslogs: List of syslog servers to send logs to.
        """
        if enable_monitoring is not None:
            pulumi.set(__self__, "enable_monitoring", enable_monitoring)
        if fluentd_tcp is not None:
            pulumi.set(__self__, "fluentd_tcp", fluentd_tcp)
        if fluentd_tls is not None:
            pulumi.set(__self__, "fluentd_tls", fluentd_tls)
        if fluentd_tls_ciphers is not None:
            pulumi.set(__self__, "fluentd_tls_ciphers", fluentd_tls_ciphers)
        if fluentd_tls_max_version is not None:
            pulumi.set(__self__, "fluentd_tls_max_version", fluentd_tls_max_version)
        if fluentd_tls_min_version is not None:
            pulumi.set(__self__, "fluentd_tls_min_version", fluentd_tls_min_version)
        if fluentd_tls_version is not None:
            pulumi.set(__self__, "fluentd_tls_version", fluentd_tls_version)
        if fluentd_udp is not None:
            pulumi.set(__self__, "fluentd_udp", fluentd_udp)
        if graphite is not None:
            pulumi.set(__self__, "graphite", graphite)
        if ism_deletion_after is not None:
            pulumi.set(__self__, "ism_deletion_after", ism_deletion_after)
        if ism_jitter is not None:
            pulumi.set(__self__, "ism_jitter", ism_jitter)
        if ism_job_interval is not None:
            pulumi.set(__self__, "ism_job_interval", ism_job_interval)
        if java_heapspace is not None:
            pulumi.set(__self__, "java_heapspace", java_heapspace)
        if java_maxmetaspace is not None:
            pulumi.set(__self__, "java_maxmetaspace", java_maxmetaspace)
        if max_disk_threshold is not None:
            pulumi.set(__self__, "max_disk_threshold", max_disk_threshold)
        if metrics_frequency is not None:
            pulumi.set(__self__, "metrics_frequency", metrics_frequency)
        if metrics_prefix is not None:
            pulumi.set(__self__, "metrics_prefix", metrics_prefix)
        if monitoring_instance_id is not None:
            pulumi.set(__self__, "monitoring_instance_id", monitoring_instance_id)
        if opensearch_tls_ciphers is not None:
            pulumi.set(__self__, "opensearch_tls_ciphers", opensearch_tls_ciphers)
        if opensearch_tls_protocols is not None:
            pulumi.set(__self__, "opensearch_tls_protocols", opensearch_tls_protocols)
        if sgw_acl is not None:
            pulumi.set(__self__, "sgw_acl", sgw_acl)
        if syslogs is not None:
            pulumi.set(__self__, "syslogs", syslogs)

    @_builtins.property
    @pulumi.getter(name="enableMonitoring")
    def enable_monitoring(self) -> Optional[_builtins.bool]:
        """
        Enable monitoring.
        """
        return pulumi.get(self, "enable_monitoring")

    @_builtins.property
    @pulumi.getter(name="fluentdTcp")
    def fluentd_tcp(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "fluentd_tcp")

    @_builtins.property
    @pulumi.getter(name="fluentdTls")
    def fluentd_tls(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "fluentd_tls")

    @_builtins.property
    @pulumi.getter(name="fluentdTlsCiphers")
    def fluentd_tls_ciphers(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "fluentd_tls_ciphers")

    @_builtins.property
    @pulumi.getter(name="fluentdTlsMaxVersion")
    def fluentd_tls_max_version(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "fluentd_tls_max_version")

    @_builtins.property
    @pulumi.getter(name="fluentdTlsMinVersion")
    def fluentd_tls_min_version(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "fluentd_tls_min_version")

    @_builtins.property
    @pulumi.getter(name="fluentdTlsVersion")
    def fluentd_tls_version(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "fluentd_tls_version")

    @_builtins.property
    @pulumi.getter(name="fluentdUdp")
    def fluentd_udp(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "fluentd_udp")

    @_builtins.property
    @pulumi.getter
    def graphite(self) -> Optional[_builtins.str]:
        """
        If set, monitoring with Graphite will be enabled. Expects the host and port where the Graphite metrics should be sent to (host:port).
        """
        return pulumi.get(self, "graphite")

    @_builtins.property
    @pulumi.getter(name="ismDeletionAfter")
    def ism_deletion_after(self) -> Optional[_builtins.str]:
        """
        Combination of an integer and a timerange when an index will be considered "old" and can be deleted. Possible values for the timerange are `s`, `m`, `h` and `d`.
        """
        return pulumi.get(self, "ism_deletion_after")

    @_builtins.property
    @pulumi.getter(name="ismJitter")
    def ism_jitter(self) -> Optional[_builtins.float]:
        return pulumi.get(self, "ism_jitter")

    @_builtins.property
    @pulumi.getter(name="ismJobInterval")
    def ism_job_interval(self) -> Optional[_builtins.int]:
        """
        Jitter of the execution time.
        """
        return pulumi.get(self, "ism_job_interval")

    @_builtins.property
    @pulumi.getter(name="javaHeapspace")
    def java_heapspace(self) -> Optional[_builtins.int]:
        """
        The amount of memory (in MB) allocated as heap by the JVM for OpenSearch.
        """
        return pulumi.get(self, "java_heapspace")

    @_builtins.property
    @pulumi.getter(name="javaMaxmetaspace")
    def java_maxmetaspace(self) -> Optional[_builtins.int]:
        """
        The amount of memory (in MB) used by the JVM to store metadata for OpenSearch.
        """
        return pulumi.get(self, "java_maxmetaspace")

    @_builtins.property
    @pulumi.getter(name="maxDiskThreshold")
    def max_disk_threshold(self) -> Optional[_builtins.int]:
        """
        The maximum disk threshold in MB. If the disk usage exceeds this threshold, the instance will be stopped.
        """
        return pulumi.get(self, "max_disk_threshold")

    @_builtins.property
    @pulumi.getter(name="metricsFrequency")
    def metrics_frequency(self) -> Optional[_builtins.int]:
        """
        The frequency in seconds at which metrics are emitted (in seconds).
        """
        return pulumi.get(self, "metrics_frequency")

    @_builtins.property
    @pulumi.getter(name="metricsPrefix")
    def metrics_prefix(self) -> Optional[_builtins.str]:
        """
        The prefix for the metrics. Could be useful when using Graphite monitoring to prefix the metrics with a certain value, like an API key.
        """
        return pulumi.get(self, "metrics_prefix")

    @_builtins.property
    @pulumi.getter(name="monitoringInstanceId")
    def monitoring_instance_id(self) -> Optional[_builtins.str]:
        """
        The ID of the STACKIT monitoring instance.
        """
        return pulumi.get(self, "monitoring_instance_id")

    @_builtins.property
    @pulumi.getter(name="opensearchTlsCiphers")
    def opensearch_tls_ciphers(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "opensearch_tls_ciphers")

    @_builtins.property
    @pulumi.getter(name="opensearchTlsProtocols")
    def opensearch_tls_protocols(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "opensearch_tls_protocols")

    @_builtins.property
    @pulumi.getter(name="sgwAcl")
    def sgw_acl(self) -> Optional[_builtins.str]:
        """
        Comma separated list of IP networks in CIDR notation which are allowed to access this instance.
        """
        return pulumi.get(self, "sgw_acl")

    @_builtins.property
    @pulumi.getter
    def syslogs(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of syslog servers to send logs to.
        """
        return pulumi.get(self, "syslogs")


@pulumi.output_type
class MariadbInstanceParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableMonitoring":
            suggest = "enable_monitoring"
        elif key == "maxDiskThreshold":
            suggest = "max_disk_threshold"
        elif key == "metricsFrequency":
            suggest = "metrics_frequency"
        elif key == "metricsPrefix":
            suggest = "metrics_prefix"
        elif key == "monitoringInstanceId":
            suggest = "monitoring_instance_id"
        elif key == "sgwAcl":
            suggest = "sgw_acl"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MariadbInstanceParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MariadbInstanceParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MariadbInstanceParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_monitoring: Optional[_builtins.bool] = None,
                 graphite: Optional[_builtins.str] = None,
                 max_disk_threshold: Optional[_builtins.int] = None,
                 metrics_frequency: Optional[_builtins.int] = None,
                 metrics_prefix: Optional[_builtins.str] = None,
                 monitoring_instance_id: Optional[_builtins.str] = None,
                 sgw_acl: Optional[_builtins.str] = None,
                 syslogs: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.bool enable_monitoring: Enable monitoring.
        :param _builtins.str graphite: Graphite server URL (host and port). If set, monitoring with Graphite will be enabled.
        :param _builtins.int max_disk_threshold: The maximum disk threshold in MB. If the disk usage exceeds this threshold, the instance will be stopped.
        :param _builtins.int metrics_frequency: The frequency in seconds at which metrics are emitted.
        :param _builtins.str metrics_prefix: The prefix for the metrics. Could be useful when using Graphite monitoring to prefix the metrics with a certain value, like an API key
        :param _builtins.str monitoring_instance_id: The ID of the STACKIT monitoring instance. Monitoring instances with the plan "Observability-Monitoring-Starter" are not supported.
        :param _builtins.str sgw_acl: Comma separated list of IP networks in CIDR notation which are allowed to access this instance.
        :param Sequence[_builtins.str] syslogs: List of syslog servers to send logs to.
        """
        if enable_monitoring is not None:
            pulumi.set(__self__, "enable_monitoring", enable_monitoring)
        if graphite is not None:
            pulumi.set(__self__, "graphite", graphite)
        if max_disk_threshold is not None:
            pulumi.set(__self__, "max_disk_threshold", max_disk_threshold)
        if metrics_frequency is not None:
            pulumi.set(__self__, "metrics_frequency", metrics_frequency)
        if metrics_prefix is not None:
            pulumi.set(__self__, "metrics_prefix", metrics_prefix)
        if monitoring_instance_id is not None:
            pulumi.set(__self__, "monitoring_instance_id", monitoring_instance_id)
        if sgw_acl is not None:
            pulumi.set(__self__, "sgw_acl", sgw_acl)
        if syslogs is not None:
            pulumi.set(__self__, "syslogs", syslogs)

    @_builtins.property
    @pulumi.getter(name="enableMonitoring")
    def enable_monitoring(self) -> Optional[_builtins.bool]:
        """
        Enable monitoring.
        """
        return pulumi.get(self, "enable_monitoring")

    @_builtins.property
    @pulumi.getter
    def graphite(self) -> Optional[_builtins.str]:
        """
        Graphite server URL (host and port). If set, monitoring with Graphite will be enabled.
        """
        return pulumi.get(self, "graphite")

    @_builtins.property
    @pulumi.getter(name="maxDiskThreshold")
    def max_disk_threshold(self) -> Optional[_builtins.int]:
        """
        The maximum disk threshold in MB. If the disk usage exceeds this threshold, the instance will be stopped.
        """
        return pulumi.get(self, "max_disk_threshold")

    @_builtins.property
    @pulumi.getter(name="metricsFrequency")
    def metrics_frequency(self) -> Optional[_builtins.int]:
        """
        The frequency in seconds at which metrics are emitted.
        """
        return pulumi.get(self, "metrics_frequency")

    @_builtins.property
    @pulumi.getter(name="metricsPrefix")
    def metrics_prefix(self) -> Optional[_builtins.str]:
        """
        The prefix for the metrics. Could be useful when using Graphite monitoring to prefix the metrics with a certain value, like an API key
        """
        return pulumi.get(self, "metrics_prefix")

    @_builtins.property
    @pulumi.getter(name="monitoringInstanceId")
    def monitoring_instance_id(self) -> Optional[_builtins.str]:
        """
        The ID of the STACKIT monitoring instance. Monitoring instances with the plan "Observability-Monitoring-Starter" are not supported.
        """
        return pulumi.get(self, "monitoring_instance_id")

    @_builtins.property
    @pulumi.getter(name="sgwAcl")
    def sgw_acl(self) -> Optional[_builtins.str]:
        """
        Comma separated list of IP networks in CIDR notation which are allowed to access this instance.
        """
        return pulumi.get(self, "sgw_acl")

    @_builtins.property
    @pulumi.getter
    def syslogs(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of syslog servers to send logs to.
        """
        return pulumi.get(self, "syslogs")


@pulumi.output_type
class MongodbflexInstanceFlavor(dict):
    def __init__(__self__, *,
                 cpu: _builtins.int,
                 ram: _builtins.int,
                 description: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None):
        pulumi.set(__self__, "cpu", cpu)
        pulumi.set(__self__, "ram", ram)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> _builtins.int:
        return pulumi.get(self, "cpu")

    @_builtins.property
    @pulumi.getter
    def ram(self) -> _builtins.int:
        return pulumi.get(self, "ram")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "id")


@pulumi.output_type
class MongodbflexInstanceOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pointInTimeWindowHours":
            suggest = "point_in_time_window_hours"
        elif key == "dailySnapshotRetentionDays":
            suggest = "daily_snapshot_retention_days"
        elif key == "monthlySnapshotRetentionMonths":
            suggest = "monthly_snapshot_retention_months"
        elif key == "snapshotRetentionDays":
            suggest = "snapshot_retention_days"
        elif key == "weeklySnapshotRetentionWeeks":
            suggest = "weekly_snapshot_retention_weeks"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MongodbflexInstanceOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MongodbflexInstanceOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MongodbflexInstanceOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 point_in_time_window_hours: _builtins.int,
                 type: _builtins.str,
                 daily_snapshot_retention_days: Optional[_builtins.int] = None,
                 monthly_snapshot_retention_months: Optional[_builtins.int] = None,
                 snapshot_retention_days: Optional[_builtins.int] = None,
                 weekly_snapshot_retention_weeks: Optional[_builtins.int] = None):
        """
        :param _builtins.int point_in_time_window_hours: The number of hours back in time the point-in-time recovery feature will be able to recover.
        :param _builtins.str type: Type of the MongoDB Flex instance. Supported values are: `Replica`, `Sharded`, `Single`.
        :param _builtins.int daily_snapshot_retention_days: The number of days that daily backups will be retained.
        :param _builtins.int monthly_snapshot_retention_months: The number of months that monthly backups will be retained.
        :param _builtins.int snapshot_retention_days: The number of days that continuous backups (controlled via the `backup_schedule`) will be retained.
        :param _builtins.int weekly_snapshot_retention_weeks: The number of weeks that weekly backups will be retained.
        """
        pulumi.set(__self__, "point_in_time_window_hours", point_in_time_window_hours)
        pulumi.set(__self__, "type", type)
        if daily_snapshot_retention_days is not None:
            pulumi.set(__self__, "daily_snapshot_retention_days", daily_snapshot_retention_days)
        if monthly_snapshot_retention_months is not None:
            pulumi.set(__self__, "monthly_snapshot_retention_months", monthly_snapshot_retention_months)
        if snapshot_retention_days is not None:
            pulumi.set(__self__, "snapshot_retention_days", snapshot_retention_days)
        if weekly_snapshot_retention_weeks is not None:
            pulumi.set(__self__, "weekly_snapshot_retention_weeks", weekly_snapshot_retention_weeks)

    @_builtins.property
    @pulumi.getter(name="pointInTimeWindowHours")
    def point_in_time_window_hours(self) -> _builtins.int:
        """
        The number of hours back in time the point-in-time recovery feature will be able to recover.
        """
        return pulumi.get(self, "point_in_time_window_hours")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of the MongoDB Flex instance. Supported values are: `Replica`, `Sharded`, `Single`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="dailySnapshotRetentionDays")
    def daily_snapshot_retention_days(self) -> Optional[_builtins.int]:
        """
        The number of days that daily backups will be retained.
        """
        return pulumi.get(self, "daily_snapshot_retention_days")

    @_builtins.property
    @pulumi.getter(name="monthlySnapshotRetentionMonths")
    def monthly_snapshot_retention_months(self) -> Optional[_builtins.int]:
        """
        The number of months that monthly backups will be retained.
        """
        return pulumi.get(self, "monthly_snapshot_retention_months")

    @_builtins.property
    @pulumi.getter(name="snapshotRetentionDays")
    def snapshot_retention_days(self) -> Optional[_builtins.int]:
        """
        The number of days that continuous backups (controlled via the `backup_schedule`) will be retained.
        """
        return pulumi.get(self, "snapshot_retention_days")

    @_builtins.property
    @pulumi.getter(name="weeklySnapshotRetentionWeeks")
    def weekly_snapshot_retention_weeks(self) -> Optional[_builtins.int]:
        """
        The number of weeks that weekly backups will be retained.
        """
        return pulumi.get(self, "weekly_snapshot_retention_weeks")


@pulumi.output_type
class MongodbflexInstanceStorage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "class":
            suggest = "class_"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MongodbflexInstanceStorage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MongodbflexInstanceStorage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MongodbflexInstanceStorage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 class_: _builtins.str,
                 size: _builtins.int):
        pulumi.set(__self__, "class_", class_)
        pulumi.set(__self__, "size", size)

    @_builtins.property
    @pulumi.getter(name="class")
    def class_(self) -> _builtins.str:
        return pulumi.get(self, "class_")

    @_builtins.property
    @pulumi.getter
    def size(self) -> _builtins.int:
        return pulumi.get(self, "size")


@pulumi.output_type
class NetworkAreaNetworkRange(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkRangeId":
            suggest = "network_range_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkAreaNetworkRange. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkAreaNetworkRange.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkAreaNetworkRange.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 prefix: _builtins.str,
                 network_range_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str prefix: Classless Inter-Domain Routing (CIDR).
        """
        pulumi.set(__self__, "prefix", prefix)
        if network_range_id is not None:
            pulumi.set(__self__, "network_range_id", network_range_id)

    @_builtins.property
    @pulumi.getter
    def prefix(self) -> _builtins.str:
        """
        Classless Inter-Domain Routing (CIDR).
        """
        return pulumi.get(self, "prefix")

    @_builtins.property
    @pulumi.getter(name="networkRangeId")
    def network_range_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "network_range_id")


@pulumi.output_type
class ObservabilityAlertgroupRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "for":
            suggest = "for_"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObservabilityAlertgroupRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObservabilityAlertgroupRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObservabilityAlertgroupRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alert: _builtins.str,
                 expression: _builtins.str,
                 annotations: Optional[Mapping[str, _builtins.str]] = None,
                 for_: Optional[_builtins.str] = None,
                 labels: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param _builtins.str alert: The name of the alert rule. Is the identifier and must be unique in the group.
        :param _builtins.str expression: The PromQL expression to evaluate. Every evaluation cycle this is evaluated at the current time, and all resultant time series become pending/firing alerts.
        :param Mapping[str, _builtins.str] annotations: A map of key:value. Annotations to add or overwrite for each alert
        :param _builtins.str for_: Alerts are considered firing once they have been returned for this long. Alerts which have not yet fired for long enough are considered pending. Default is 0s
        :param Mapping[str, _builtins.str] labels: A map of key:value. Labels to add or overwrite for each alert
        """
        pulumi.set(__self__, "alert", alert)
        pulumi.set(__self__, "expression", expression)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if for_ is not None:
            pulumi.set(__self__, "for_", for_)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)

    @_builtins.property
    @pulumi.getter
    def alert(self) -> _builtins.str:
        """
        The name of the alert rule. Is the identifier and must be unique in the group.
        """
        return pulumi.get(self, "alert")

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        """
        The PromQL expression to evaluate. Every evaluation cycle this is evaluated at the current time, and all resultant time series become pending/firing alerts.
        """
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A map of key:value. Annotations to add or overwrite for each alert
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter(name="for")
    def for_(self) -> Optional[_builtins.str]:
        """
        Alerts are considered firing once they have been returned for this long. Alerts which have not yet fired for long enough are considered pending. Default is 0s
        """
        return pulumi.get(self, "for_")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A map of key:value. Labels to add or overwrite for each alert
        """
        return pulumi.get(self, "labels")


@pulumi.output_type
class ObservabilityInstanceAlertConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "global":
            suggest = "global_"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObservabilityInstanceAlertConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObservabilityInstanceAlertConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObservabilityInstanceAlertConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 receivers: Sequence['outputs.ObservabilityInstanceAlertConfigReceiver'],
                 route: 'outputs.ObservabilityInstanceAlertConfigRoute',
                 global_: Optional['outputs.ObservabilityInstanceAlertConfigGlobal'] = None):
        """
        :param Sequence['ObservabilityInstanceAlertConfigReceiverArgs'] receivers: List of alert receivers.
        :param 'ObservabilityInstanceAlertConfigRouteArgs' route: Route configuration for the alerts.
        :param 'ObservabilityInstanceAlertConfigGlobalArgs' global_: Global configuration for the alerts.
        """
        pulumi.set(__self__, "receivers", receivers)
        pulumi.set(__self__, "route", route)
        if global_ is not None:
            pulumi.set(__self__, "global_", global_)

    @_builtins.property
    @pulumi.getter
    def receivers(self) -> Sequence['outputs.ObservabilityInstanceAlertConfigReceiver']:
        """
        List of alert receivers.
        """
        return pulumi.get(self, "receivers")

    @_builtins.property
    @pulumi.getter
    def route(self) -> 'outputs.ObservabilityInstanceAlertConfigRoute':
        """
        Route configuration for the alerts.
        """
        return pulumi.get(self, "route")

    @_builtins.property
    @pulumi.getter(name="global")
    def global_(self) -> Optional['outputs.ObservabilityInstanceAlertConfigGlobal']:
        """
        Global configuration for the alerts.
        """
        return pulumi.get(self, "global_")


@pulumi.output_type
class ObservabilityInstanceAlertConfigGlobal(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "opsgenieApiKey":
            suggest = "opsgenie_api_key"
        elif key == "opsgenieApiUrl":
            suggest = "opsgenie_api_url"
        elif key == "resolveTimeout":
            suggest = "resolve_timeout"
        elif key == "smtpAuthIdentity":
            suggest = "smtp_auth_identity"
        elif key == "smtpAuthPassword":
            suggest = "smtp_auth_password"
        elif key == "smtpAuthUsername":
            suggest = "smtp_auth_username"
        elif key == "smtpFrom":
            suggest = "smtp_from"
        elif key == "smtpSmartHost":
            suggest = "smtp_smart_host"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObservabilityInstanceAlertConfigGlobal. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObservabilityInstanceAlertConfigGlobal.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObservabilityInstanceAlertConfigGlobal.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 opsgenie_api_key: Optional[_builtins.str] = None,
                 opsgenie_api_url: Optional[_builtins.str] = None,
                 resolve_timeout: Optional[_builtins.str] = None,
                 smtp_auth_identity: Optional[_builtins.str] = None,
                 smtp_auth_password: Optional[_builtins.str] = None,
                 smtp_auth_username: Optional[_builtins.str] = None,
                 smtp_from: Optional[_builtins.str] = None,
                 smtp_smart_host: Optional[_builtins.str] = None):
        """
        :param _builtins.str opsgenie_api_key: The API key for OpsGenie.
        :param _builtins.str opsgenie_api_url: The host to send OpsGenie API requests to. Must be a valid URL
        :param _builtins.str resolve_timeout: The default value used by alertmanager if the alert does not include EndsAt. After this time passes, it can declare the alert as resolved if it has not been updated. This has no impact on alerts from Prometheus, as they always include EndsAt.
        :param _builtins.str smtp_auth_identity: SMTP authentication information. Must be a valid email address
        :param _builtins.str smtp_auth_password: SMTP Auth using LOGIN and PLAIN.
        :param _builtins.str smtp_auth_username: SMTP Auth using CRAM-MD5, LOGIN and PLAIN. If empty, Alertmanager doesn't authenticate to the SMTP server.
        :param _builtins.str smtp_from: The default SMTP From header field. Must be a valid email address
        :param _builtins.str smtp_smart_host: The default SMTP smarthost used for sending emails, including port number in format `host:port` (eg. `smtp.example.com:587`). Port number usually is 25, or 587 for SMTP over TLS (sometimes referred to as STARTTLS).
        """
        if opsgenie_api_key is not None:
            pulumi.set(__self__, "opsgenie_api_key", opsgenie_api_key)
        if opsgenie_api_url is not None:
            pulumi.set(__self__, "opsgenie_api_url", opsgenie_api_url)
        if resolve_timeout is not None:
            pulumi.set(__self__, "resolve_timeout", resolve_timeout)
        if smtp_auth_identity is not None:
            pulumi.set(__self__, "smtp_auth_identity", smtp_auth_identity)
        if smtp_auth_password is not None:
            pulumi.set(__self__, "smtp_auth_password", smtp_auth_password)
        if smtp_auth_username is not None:
            pulumi.set(__self__, "smtp_auth_username", smtp_auth_username)
        if smtp_from is not None:
            pulumi.set(__self__, "smtp_from", smtp_from)
        if smtp_smart_host is not None:
            pulumi.set(__self__, "smtp_smart_host", smtp_smart_host)

    @_builtins.property
    @pulumi.getter(name="opsgenieApiKey")
    def opsgenie_api_key(self) -> Optional[_builtins.str]:
        """
        The API key for OpsGenie.
        """
        return pulumi.get(self, "opsgenie_api_key")

    @_builtins.property
    @pulumi.getter(name="opsgenieApiUrl")
    def opsgenie_api_url(self) -> Optional[_builtins.str]:
        """
        The host to send OpsGenie API requests to. Must be a valid URL
        """
        return pulumi.get(self, "opsgenie_api_url")

    @_builtins.property
    @pulumi.getter(name="resolveTimeout")
    def resolve_timeout(self) -> Optional[_builtins.str]:
        """
        The default value used by alertmanager if the alert does not include EndsAt. After this time passes, it can declare the alert as resolved if it has not been updated. This has no impact on alerts from Prometheus, as they always include EndsAt.
        """
        return pulumi.get(self, "resolve_timeout")

    @_builtins.property
    @pulumi.getter(name="smtpAuthIdentity")
    def smtp_auth_identity(self) -> Optional[_builtins.str]:
        """
        SMTP authentication information. Must be a valid email address
        """
        return pulumi.get(self, "smtp_auth_identity")

    @_builtins.property
    @pulumi.getter(name="smtpAuthPassword")
    def smtp_auth_password(self) -> Optional[_builtins.str]:
        """
        SMTP Auth using LOGIN and PLAIN.
        """
        return pulumi.get(self, "smtp_auth_password")

    @_builtins.property
    @pulumi.getter(name="smtpAuthUsername")
    def smtp_auth_username(self) -> Optional[_builtins.str]:
        """
        SMTP Auth using CRAM-MD5, LOGIN and PLAIN. If empty, Alertmanager doesn't authenticate to the SMTP server.
        """
        return pulumi.get(self, "smtp_auth_username")

    @_builtins.property
    @pulumi.getter(name="smtpFrom")
    def smtp_from(self) -> Optional[_builtins.str]:
        """
        The default SMTP From header field. Must be a valid email address
        """
        return pulumi.get(self, "smtp_from")

    @_builtins.property
    @pulumi.getter(name="smtpSmartHost")
    def smtp_smart_host(self) -> Optional[_builtins.str]:
        """
        The default SMTP smarthost used for sending emails, including port number in format `host:port` (eg. `smtp.example.com:587`). Port number usually is 25, or 587 for SMTP over TLS (sometimes referred to as STARTTLS).
        """
        return pulumi.get(self, "smtp_smart_host")


@pulumi.output_type
class ObservabilityInstanceAlertConfigReceiver(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "emailConfigs":
            suggest = "email_configs"
        elif key == "opsgenieConfigs":
            suggest = "opsgenie_configs"
        elif key == "webhooksConfigs":
            suggest = "webhooks_configs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObservabilityInstanceAlertConfigReceiver. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObservabilityInstanceAlertConfigReceiver.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObservabilityInstanceAlertConfigReceiver.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 email_configs: Optional[Sequence['outputs.ObservabilityInstanceAlertConfigReceiverEmailConfig']] = None,
                 opsgenie_configs: Optional[Sequence['outputs.ObservabilityInstanceAlertConfigReceiverOpsgenieConfig']] = None,
                 webhooks_configs: Optional[Sequence['outputs.ObservabilityInstanceAlertConfigReceiverWebhooksConfig']] = None):
        """
        :param _builtins.str name: Name of the receiver.
        :param Sequence['ObservabilityInstanceAlertConfigReceiverEmailConfigArgs'] email_configs: List of email configurations.
        :param Sequence['ObservabilityInstanceAlertConfigReceiverOpsgenieConfigArgs'] opsgenie_configs: List of OpsGenie configurations.
        :param Sequence['ObservabilityInstanceAlertConfigReceiverWebhooksConfigArgs'] webhooks_configs: List of Webhooks configurations.
        """
        pulumi.set(__self__, "name", name)
        if email_configs is not None:
            pulumi.set(__self__, "email_configs", email_configs)
        if opsgenie_configs is not None:
            pulumi.set(__self__, "opsgenie_configs", opsgenie_configs)
        if webhooks_configs is not None:
            pulumi.set(__self__, "webhooks_configs", webhooks_configs)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the receiver.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="emailConfigs")
    def email_configs(self) -> Optional[Sequence['outputs.ObservabilityInstanceAlertConfigReceiverEmailConfig']]:
        """
        List of email configurations.
        """
        return pulumi.get(self, "email_configs")

    @_builtins.property
    @pulumi.getter(name="opsgenieConfigs")
    def opsgenie_configs(self) -> Optional[Sequence['outputs.ObservabilityInstanceAlertConfigReceiverOpsgenieConfig']]:
        """
        List of OpsGenie configurations.
        """
        return pulumi.get(self, "opsgenie_configs")

    @_builtins.property
    @pulumi.getter(name="webhooksConfigs")
    def webhooks_configs(self) -> Optional[Sequence['outputs.ObservabilityInstanceAlertConfigReceiverWebhooksConfig']]:
        """
        List of Webhooks configurations.
        """
        return pulumi.get(self, "webhooks_configs")


@pulumi.output_type
class ObservabilityInstanceAlertConfigReceiverEmailConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authIdentity":
            suggest = "auth_identity"
        elif key == "authPassword":
            suggest = "auth_password"
        elif key == "authUsername":
            suggest = "auth_username"
        elif key == "from":
            suggest = "from_"
        elif key == "smartHost":
            suggest = "smart_host"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObservabilityInstanceAlertConfigReceiverEmailConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObservabilityInstanceAlertConfigReceiverEmailConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObservabilityInstanceAlertConfigReceiverEmailConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auth_identity: Optional[_builtins.str] = None,
                 auth_password: Optional[_builtins.str] = None,
                 auth_username: Optional[_builtins.str] = None,
                 from_: Optional[_builtins.str] = None,
                 smart_host: Optional[_builtins.str] = None,
                 to: Optional[_builtins.str] = None):
        """
        :param _builtins.str auth_identity: SMTP authentication information. Must be a valid email address
        :param _builtins.str auth_password: SMTP authentication password.
        :param _builtins.str auth_username: SMTP authentication username.
        :param _builtins.str from_: The sender email address. Must be a valid email address
        :param _builtins.str smart_host: The SMTP host through which emails are sent.
        :param _builtins.str to: The email address to send notifications to. Must be a valid email address
        """
        if auth_identity is not None:
            pulumi.set(__self__, "auth_identity", auth_identity)
        if auth_password is not None:
            pulumi.set(__self__, "auth_password", auth_password)
        if auth_username is not None:
            pulumi.set(__self__, "auth_username", auth_username)
        if from_ is not None:
            pulumi.set(__self__, "from_", from_)
        if smart_host is not None:
            pulumi.set(__self__, "smart_host", smart_host)
        if to is not None:
            pulumi.set(__self__, "to", to)

    @_builtins.property
    @pulumi.getter(name="authIdentity")
    def auth_identity(self) -> Optional[_builtins.str]:
        """
        SMTP authentication information. Must be a valid email address
        """
        return pulumi.get(self, "auth_identity")

    @_builtins.property
    @pulumi.getter(name="authPassword")
    def auth_password(self) -> Optional[_builtins.str]:
        """
        SMTP authentication password.
        """
        return pulumi.get(self, "auth_password")

    @_builtins.property
    @pulumi.getter(name="authUsername")
    def auth_username(self) -> Optional[_builtins.str]:
        """
        SMTP authentication username.
        """
        return pulumi.get(self, "auth_username")

    @_builtins.property
    @pulumi.getter(name="from")
    def from_(self) -> Optional[_builtins.str]:
        """
        The sender email address. Must be a valid email address
        """
        return pulumi.get(self, "from_")

    @_builtins.property
    @pulumi.getter(name="smartHost")
    def smart_host(self) -> Optional[_builtins.str]:
        """
        The SMTP host through which emails are sent.
        """
        return pulumi.get(self, "smart_host")

    @_builtins.property
    @pulumi.getter
    def to(self) -> Optional[_builtins.str]:
        """
        The email address to send notifications to. Must be a valid email address
        """
        return pulumi.get(self, "to")


@pulumi.output_type
class ObservabilityInstanceAlertConfigReceiverOpsgenieConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiKey":
            suggest = "api_key"
        elif key == "apiUrl":
            suggest = "api_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObservabilityInstanceAlertConfigReceiverOpsgenieConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObservabilityInstanceAlertConfigReceiverOpsgenieConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObservabilityInstanceAlertConfigReceiverOpsgenieConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_key: Optional[_builtins.str] = None,
                 api_url: Optional[_builtins.str] = None,
                 tags: Optional[_builtins.str] = None):
        """
        :param _builtins.str api_key: The API key for OpsGenie.
        :param _builtins.str api_url: The host to send OpsGenie API requests to. Must be a valid URL
        :param _builtins.str tags: Comma separated list of tags attached to the notifications.
        """
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if api_url is not None:
            pulumi.set(__self__, "api_url", api_url)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[_builtins.str]:
        """
        The API key for OpsGenie.
        """
        return pulumi.get(self, "api_key")

    @_builtins.property
    @pulumi.getter(name="apiUrl")
    def api_url(self) -> Optional[_builtins.str]:
        """
        The host to send OpsGenie API requests to. Must be a valid URL
        """
        return pulumi.get(self, "api_url")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[_builtins.str]:
        """
        Comma separated list of tags attached to the notifications.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class ObservabilityInstanceAlertConfigReceiverWebhooksConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "msTeams":
            suggest = "ms_teams"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObservabilityInstanceAlertConfigReceiverWebhooksConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObservabilityInstanceAlertConfigReceiverWebhooksConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObservabilityInstanceAlertConfigReceiverWebhooksConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ms_teams: Optional[_builtins.bool] = None,
                 url: Optional[_builtins.str] = None):
        """
        :param _builtins.bool ms_teams: Microsoft Teams webhooks require special handling, set this to true if the webhook is for Microsoft Teams.
        :param _builtins.str url: The endpoint to send HTTP POST requests to. Must be a valid URL
        """
        if ms_teams is not None:
            pulumi.set(__self__, "ms_teams", ms_teams)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter(name="msTeams")
    def ms_teams(self) -> Optional[_builtins.bool]:
        """
        Microsoft Teams webhooks require special handling, set this to true if the webhook is for Microsoft Teams.
        """
        return pulumi.get(self, "ms_teams")

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[_builtins.str]:
        """
        The endpoint to send HTTP POST requests to. Must be a valid URL
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class ObservabilityInstanceAlertConfigRoute(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupBies":
            suggest = "group_bies"
        elif key == "groupInterval":
            suggest = "group_interval"
        elif key == "groupWait":
            suggest = "group_wait"
        elif key == "matchRegex":
            suggest = "match_regex"
        elif key == "repeatInterval":
            suggest = "repeat_interval"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObservabilityInstanceAlertConfigRoute. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObservabilityInstanceAlertConfigRoute.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObservabilityInstanceAlertConfigRoute.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 receiver: _builtins.str,
                 group_bies: Optional[Sequence[_builtins.str]] = None,
                 group_interval: Optional[_builtins.str] = None,
                 group_wait: Optional[_builtins.str] = None,
                 match: Optional[Mapping[str, _builtins.str]] = None,
                 match_regex: Optional[Mapping[str, _builtins.str]] = None,
                 repeat_interval: Optional[_builtins.str] = None,
                 routes: Optional[Sequence['outputs.ObservabilityInstanceAlertConfigRouteRoute']] = None):
        """
        :param _builtins.str receiver: The name of the receiver to route the alerts to.
        :param Sequence[_builtins.str] group_bies: The labels by which incoming alerts are grouped together. For example, multiple alerts coming in for cluster=A and alertname=LatencyHigh would be batched into a single group. To aggregate by all possible labels use the special value '...' as the sole label name, for example: group_by: ['...']. This effectively disables aggregation entirely, passing through all alerts as-is. This is unlikely to be what you want, unless you have a very low alert volume or your upstream notification system performs its own grouping.
        :param _builtins.str group_interval: How long to wait before sending a notification about new alerts that are added to a group of alerts for which an initial notification has already been sent. (Usually ~5m or more.)
        :param _builtins.str group_wait: How long to initially wait to send a notification for a group of alerts. Allows to wait for an inhibiting alert to arrive or collect more initial alerts for the same group. (Usually ~0s to few minutes.)
        :param Mapping[str, _builtins.str] match: A set of equality matchers an alert has to fulfill to match the node.
        :param Mapping[str, _builtins.str] match_regex: A set of regex-matchers an alert has to fulfill to match the node.
        :param _builtins.str repeat_interval: How long to wait before sending a notification again if it has already been sent successfully for an alert. (Usually ~3h or more).
        :param Sequence['ObservabilityInstanceAlertConfigRouteRouteArgs'] routes: List of child routes.
        """
        pulumi.set(__self__, "receiver", receiver)
        if group_bies is not None:
            pulumi.set(__self__, "group_bies", group_bies)
        if group_interval is not None:
            pulumi.set(__self__, "group_interval", group_interval)
        if group_wait is not None:
            pulumi.set(__self__, "group_wait", group_wait)
        if match is not None:
            pulumi.set(__self__, "match", match)
        if match_regex is not None:
            pulumi.set(__self__, "match_regex", match_regex)
        if repeat_interval is not None:
            pulumi.set(__self__, "repeat_interval", repeat_interval)
        if routes is not None:
            pulumi.set(__self__, "routes", routes)

    @_builtins.property
    @pulumi.getter
    def receiver(self) -> _builtins.str:
        """
        The name of the receiver to route the alerts to.
        """
        return pulumi.get(self, "receiver")

    @_builtins.property
    @pulumi.getter(name="groupBies")
    def group_bies(self) -> Optional[Sequence[_builtins.str]]:
        """
        The labels by which incoming alerts are grouped together. For example, multiple alerts coming in for cluster=A and alertname=LatencyHigh would be batched into a single group. To aggregate by all possible labels use the special value '...' as the sole label name, for example: group_by: ['...']. This effectively disables aggregation entirely, passing through all alerts as-is. This is unlikely to be what you want, unless you have a very low alert volume or your upstream notification system performs its own grouping.
        """
        return pulumi.get(self, "group_bies")

    @_builtins.property
    @pulumi.getter(name="groupInterval")
    def group_interval(self) -> Optional[_builtins.str]:
        """
        How long to wait before sending a notification about new alerts that are added to a group of alerts for which an initial notification has already been sent. (Usually ~5m or more.)
        """
        return pulumi.get(self, "group_interval")

    @_builtins.property
    @pulumi.getter(name="groupWait")
    def group_wait(self) -> Optional[_builtins.str]:
        """
        How long to initially wait to send a notification for a group of alerts. Allows to wait for an inhibiting alert to arrive or collect more initial alerts for the same group. (Usually ~0s to few minutes.)
        """
        return pulumi.get(self, "group_wait")

    @_builtins.property
    @pulumi.getter
    def match(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A set of equality matchers an alert has to fulfill to match the node.
        """
        return pulumi.get(self, "match")

    @_builtins.property
    @pulumi.getter(name="matchRegex")
    def match_regex(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A set of regex-matchers an alert has to fulfill to match the node.
        """
        return pulumi.get(self, "match_regex")

    @_builtins.property
    @pulumi.getter(name="repeatInterval")
    def repeat_interval(self) -> Optional[_builtins.str]:
        """
        How long to wait before sending a notification again if it has already been sent successfully for an alert. (Usually ~3h or more).
        """
        return pulumi.get(self, "repeat_interval")

    @_builtins.property
    @pulumi.getter
    def routes(self) -> Optional[Sequence['outputs.ObservabilityInstanceAlertConfigRouteRoute']]:
        """
        List of child routes.
        """
        return pulumi.get(self, "routes")


@pulumi.output_type
class ObservabilityInstanceAlertConfigRouteRoute(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupBies":
            suggest = "group_bies"
        elif key == "groupInterval":
            suggest = "group_interval"
        elif key == "groupWait":
            suggest = "group_wait"
        elif key == "matchRegex":
            suggest = "match_regex"
        elif key == "repeatInterval":
            suggest = "repeat_interval"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObservabilityInstanceAlertConfigRouteRoute. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObservabilityInstanceAlertConfigRouteRoute.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObservabilityInstanceAlertConfigRouteRoute.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 receiver: _builtins.str,
                 group_bies: Optional[Sequence[_builtins.str]] = None,
                 group_interval: Optional[_builtins.str] = None,
                 group_wait: Optional[_builtins.str] = None,
                 match: Optional[Mapping[str, _builtins.str]] = None,
                 match_regex: Optional[Mapping[str, _builtins.str]] = None,
                 repeat_interval: Optional[_builtins.str] = None):
        """
        :param _builtins.str receiver: The name of the receiver to route the alerts to.
        :param Sequence[_builtins.str] group_bies: The labels by which incoming alerts are grouped together. For example, multiple alerts coming in for cluster=A and alertname=LatencyHigh would be batched into a single group. To aggregate by all possible labels use the special value '...' as the sole label name, for example: group_by: ['...']. This effectively disables aggregation entirely, passing through all alerts as-is. This is unlikely to be what you want, unless you have a very low alert volume or your upstream notification system performs its own grouping.
        :param _builtins.str group_interval: How long to wait before sending a notification about new alerts that are added to a group of alerts for which an initial notification has already been sent. (Usually ~5m or more.)
        :param _builtins.str group_wait: How long to initially wait to send a notification for a group of alerts. Allows to wait for an inhibiting alert to arrive or collect more initial alerts for the same group. (Usually ~0s to few minutes.)
        :param Mapping[str, _builtins.str] match: A set of equality matchers an alert has to fulfill to match the node.
        :param Mapping[str, _builtins.str] match_regex: A set of regex-matchers an alert has to fulfill to match the node.
        :param _builtins.str repeat_interval: How long to wait before sending a notification again if it has already been sent successfully for an alert. (Usually ~3h or more).
        """
        pulumi.set(__self__, "receiver", receiver)
        if group_bies is not None:
            pulumi.set(__self__, "group_bies", group_bies)
        if group_interval is not None:
            pulumi.set(__self__, "group_interval", group_interval)
        if group_wait is not None:
            pulumi.set(__self__, "group_wait", group_wait)
        if match is not None:
            pulumi.set(__self__, "match", match)
        if match_regex is not None:
            pulumi.set(__self__, "match_regex", match_regex)
        if repeat_interval is not None:
            pulumi.set(__self__, "repeat_interval", repeat_interval)

    @_builtins.property
    @pulumi.getter
    def receiver(self) -> _builtins.str:
        """
        The name of the receiver to route the alerts to.
        """
        return pulumi.get(self, "receiver")

    @_builtins.property
    @pulumi.getter(name="groupBies")
    def group_bies(self) -> Optional[Sequence[_builtins.str]]:
        """
        The labels by which incoming alerts are grouped together. For example, multiple alerts coming in for cluster=A and alertname=LatencyHigh would be batched into a single group. To aggregate by all possible labels use the special value '...' as the sole label name, for example: group_by: ['...']. This effectively disables aggregation entirely, passing through all alerts as-is. This is unlikely to be what you want, unless you have a very low alert volume or your upstream notification system performs its own grouping.
        """
        return pulumi.get(self, "group_bies")

    @_builtins.property
    @pulumi.getter(name="groupInterval")
    def group_interval(self) -> Optional[_builtins.str]:
        """
        How long to wait before sending a notification about new alerts that are added to a group of alerts for which an initial notification has already been sent. (Usually ~5m or more.)
        """
        return pulumi.get(self, "group_interval")

    @_builtins.property
    @pulumi.getter(name="groupWait")
    def group_wait(self) -> Optional[_builtins.str]:
        """
        How long to initially wait to send a notification for a group of alerts. Allows to wait for an inhibiting alert to arrive or collect more initial alerts for the same group. (Usually ~0s to few minutes.)
        """
        return pulumi.get(self, "group_wait")

    @_builtins.property
    @pulumi.getter
    def match(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A set of equality matchers an alert has to fulfill to match the node.
        """
        return pulumi.get(self, "match")

    @_builtins.property
    @pulumi.getter(name="matchRegex")
    def match_regex(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A set of regex-matchers an alert has to fulfill to match the node.
        """
        return pulumi.get(self, "match_regex")

    @_builtins.property
    @pulumi.getter(name="repeatInterval")
    def repeat_interval(self) -> Optional[_builtins.str]:
        """
        How long to wait before sending a notification again if it has already been sent successfully for an alert. (Usually ~3h or more).
        """
        return pulumi.get(self, "repeat_interval")


@pulumi.output_type
class ObservabilityLogalertgroupRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "for":
            suggest = "for_"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObservabilityLogalertgroupRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObservabilityLogalertgroupRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObservabilityLogalertgroupRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alert: _builtins.str,
                 expression: _builtins.str,
                 annotations: Optional[Mapping[str, _builtins.str]] = None,
                 for_: Optional[_builtins.str] = None,
                 labels: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param _builtins.str alert: The name of the alert rule. Is the identifier and must be unique in the group.
        :param _builtins.str expression: The LogQL expression to evaluate. Every evaluation cycle this is evaluated at the current time, and all resultant time series become pending/firing alerts.
        :param Mapping[str, _builtins.str] annotations: A map of key:value. Annotations to add or overwrite for each alert
        :param _builtins.str for_: Alerts are considered firing once they have been returned for this long. Alerts which have not yet fired for long enough are considered pending. Default is 0s
        :param Mapping[str, _builtins.str] labels: A map of key:value. Labels to add or overwrite for each alert
        """
        pulumi.set(__self__, "alert", alert)
        pulumi.set(__self__, "expression", expression)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if for_ is not None:
            pulumi.set(__self__, "for_", for_)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)

    @_builtins.property
    @pulumi.getter
    def alert(self) -> _builtins.str:
        """
        The name of the alert rule. Is the identifier and must be unique in the group.
        """
        return pulumi.get(self, "alert")

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        """
        The LogQL expression to evaluate. Every evaluation cycle this is evaluated at the current time, and all resultant time series become pending/firing alerts.
        """
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A map of key:value. Annotations to add or overwrite for each alert
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter(name="for")
    def for_(self) -> Optional[_builtins.str]:
        """
        Alerts are considered firing once they have been returned for this long. Alerts which have not yet fired for long enough are considered pending. Default is 0s
        """
        return pulumi.get(self, "for_")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A map of key:value. Labels to add or overwrite for each alert
        """
        return pulumi.get(self, "labels")


@pulumi.output_type
class ObservabilityScrapeconfigBasicAuth(dict):
    def __init__(__self__, *,
                 password: _builtins.str,
                 username: _builtins.str):
        """
        :param _builtins.str password: Specifies basic auth password.
        :param _builtins.str username: Specifies basic auth username.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter
    def password(self) -> _builtins.str:
        """
        Specifies basic auth password.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def username(self) -> _builtins.str:
        """
        Specifies basic auth username.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class ObservabilityScrapeconfigSaml2(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableUrlParameters":
            suggest = "enable_url_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObservabilityScrapeconfigSaml2. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObservabilityScrapeconfigSaml2.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObservabilityScrapeconfigSaml2.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_url_parameters: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool enable_url_parameters: Specifies if URL parameters are enabled. Defaults to `true`
        """
        if enable_url_parameters is not None:
            pulumi.set(__self__, "enable_url_parameters", enable_url_parameters)

    @_builtins.property
    @pulumi.getter(name="enableUrlParameters")
    def enable_url_parameters(self) -> Optional[_builtins.bool]:
        """
        Specifies if URL parameters are enabled. Defaults to `true`
        """
        return pulumi.get(self, "enable_url_parameters")


@pulumi.output_type
class ObservabilityScrapeconfigTarget(dict):
    def __init__(__self__, *,
                 urls: Sequence[_builtins.str],
                 labels: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param Sequence[_builtins.str] urls: Specifies target URLs.
        :param Mapping[str, _builtins.str] labels: Specifies labels.
        """
        pulumi.set(__self__, "urls", urls)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)

    @_builtins.property
    @pulumi.getter
    def urls(self) -> Sequence[_builtins.str]:
        """
        Specifies target URLs.
        """
        return pulumi.get(self, "urls")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Specifies labels.
        """
        return pulumi.get(self, "labels")


@pulumi.output_type
class OpensearchInstanceParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableMonitoring":
            suggest = "enable_monitoring"
        elif key == "javaGarbageCollector":
            suggest = "java_garbage_collector"
        elif key == "javaHeapspace":
            suggest = "java_heapspace"
        elif key == "javaMaxmetaspace":
            suggest = "java_maxmetaspace"
        elif key == "maxDiskThreshold":
            suggest = "max_disk_threshold"
        elif key == "metricsFrequency":
            suggest = "metrics_frequency"
        elif key == "metricsPrefix":
            suggest = "metrics_prefix"
        elif key == "monitoringInstanceId":
            suggest = "monitoring_instance_id"
        elif key == "sgwAcl":
            suggest = "sgw_acl"
        elif key == "tlsCiphers":
            suggest = "tls_ciphers"
        elif key == "tlsProtocols":
            suggest = "tls_protocols"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OpensearchInstanceParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OpensearchInstanceParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OpensearchInstanceParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_monitoring: Optional[_builtins.bool] = None,
                 graphite: Optional[_builtins.str] = None,
                 java_garbage_collector: Optional[_builtins.str] = None,
                 java_heapspace: Optional[_builtins.int] = None,
                 java_maxmetaspace: Optional[_builtins.int] = None,
                 max_disk_threshold: Optional[_builtins.int] = None,
                 metrics_frequency: Optional[_builtins.int] = None,
                 metrics_prefix: Optional[_builtins.str] = None,
                 monitoring_instance_id: Optional[_builtins.str] = None,
                 plugins: Optional[Sequence[_builtins.str]] = None,
                 sgw_acl: Optional[_builtins.str] = None,
                 syslogs: Optional[Sequence[_builtins.str]] = None,
                 tls_ciphers: Optional[Sequence[_builtins.str]] = None,
                 tls_protocols: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.bool enable_monitoring: Enable monitoring.
        :param _builtins.str graphite: If set, monitoring with Graphite will be enabled. Expects the host and port where the Graphite metrics should be sent to (host:port).
        :param _builtins.str java_garbage_collector: The garbage collector to use for OpenSearch.
        :param _builtins.int java_heapspace: The amount of memory (in MB) allocated as heap by the JVM for OpenSearch.
        :param _builtins.int java_maxmetaspace: The amount of memory (in MB) used by the JVM to store metadata for OpenSearch.
        :param _builtins.int max_disk_threshold: The maximum disk threshold in MB. If the disk usage exceeds this threshold, the instance will be stopped.
        :param _builtins.int metrics_frequency: The frequency in seconds at which metrics are emitted (in seconds).
        :param _builtins.str metrics_prefix: The prefix for the metrics. Could be useful when using Graphite monitoring to prefix the metrics with a certain value, like an API key.
        :param _builtins.str monitoring_instance_id: The ID of the STACKIT monitoring instance.
        :param Sequence[_builtins.str] plugins: List of plugins to install. Must be a supported plugin name. The plugins `repository-s3` and `repository-azure` are enabled by default and cannot be disabled.
        :param _builtins.str sgw_acl: Comma separated list of IP networks in CIDR notation which are allowed to access this instance.
        :param Sequence[_builtins.str] syslogs: List of syslog servers to send logs to.
        :param Sequence[_builtins.str] tls_ciphers: List of TLS ciphers to use.
        :param Sequence[_builtins.str] tls_protocols: The TLS protocol to use.
        """
        if enable_monitoring is not None:
            pulumi.set(__self__, "enable_monitoring", enable_monitoring)
        if graphite is not None:
            pulumi.set(__self__, "graphite", graphite)
        if java_garbage_collector is not None:
            pulumi.set(__self__, "java_garbage_collector", java_garbage_collector)
        if java_heapspace is not None:
            pulumi.set(__self__, "java_heapspace", java_heapspace)
        if java_maxmetaspace is not None:
            pulumi.set(__self__, "java_maxmetaspace", java_maxmetaspace)
        if max_disk_threshold is not None:
            pulumi.set(__self__, "max_disk_threshold", max_disk_threshold)
        if metrics_frequency is not None:
            pulumi.set(__self__, "metrics_frequency", metrics_frequency)
        if metrics_prefix is not None:
            pulumi.set(__self__, "metrics_prefix", metrics_prefix)
        if monitoring_instance_id is not None:
            pulumi.set(__self__, "monitoring_instance_id", monitoring_instance_id)
        if plugins is not None:
            pulumi.set(__self__, "plugins", plugins)
        if sgw_acl is not None:
            pulumi.set(__self__, "sgw_acl", sgw_acl)
        if syslogs is not None:
            pulumi.set(__self__, "syslogs", syslogs)
        if tls_ciphers is not None:
            pulumi.set(__self__, "tls_ciphers", tls_ciphers)
        if tls_protocols is not None:
            pulumi.set(__self__, "tls_protocols", tls_protocols)

    @_builtins.property
    @pulumi.getter(name="enableMonitoring")
    def enable_monitoring(self) -> Optional[_builtins.bool]:
        """
        Enable monitoring.
        """
        return pulumi.get(self, "enable_monitoring")

    @_builtins.property
    @pulumi.getter
    def graphite(self) -> Optional[_builtins.str]:
        """
        If set, monitoring with Graphite will be enabled. Expects the host and port where the Graphite metrics should be sent to (host:port).
        """
        return pulumi.get(self, "graphite")

    @_builtins.property
    @pulumi.getter(name="javaGarbageCollector")
    def java_garbage_collector(self) -> Optional[_builtins.str]:
        """
        The garbage collector to use for OpenSearch.
        """
        return pulumi.get(self, "java_garbage_collector")

    @_builtins.property
    @pulumi.getter(name="javaHeapspace")
    def java_heapspace(self) -> Optional[_builtins.int]:
        """
        The amount of memory (in MB) allocated as heap by the JVM for OpenSearch.
        """
        return pulumi.get(self, "java_heapspace")

    @_builtins.property
    @pulumi.getter(name="javaMaxmetaspace")
    def java_maxmetaspace(self) -> Optional[_builtins.int]:
        """
        The amount of memory (in MB) used by the JVM to store metadata for OpenSearch.
        """
        return pulumi.get(self, "java_maxmetaspace")

    @_builtins.property
    @pulumi.getter(name="maxDiskThreshold")
    def max_disk_threshold(self) -> Optional[_builtins.int]:
        """
        The maximum disk threshold in MB. If the disk usage exceeds this threshold, the instance will be stopped.
        """
        return pulumi.get(self, "max_disk_threshold")

    @_builtins.property
    @pulumi.getter(name="metricsFrequency")
    def metrics_frequency(self) -> Optional[_builtins.int]:
        """
        The frequency in seconds at which metrics are emitted (in seconds).
        """
        return pulumi.get(self, "metrics_frequency")

    @_builtins.property
    @pulumi.getter(name="metricsPrefix")
    def metrics_prefix(self) -> Optional[_builtins.str]:
        """
        The prefix for the metrics. Could be useful when using Graphite monitoring to prefix the metrics with a certain value, like an API key.
        """
        return pulumi.get(self, "metrics_prefix")

    @_builtins.property
    @pulumi.getter(name="monitoringInstanceId")
    def monitoring_instance_id(self) -> Optional[_builtins.str]:
        """
        The ID of the STACKIT monitoring instance.
        """
        return pulumi.get(self, "monitoring_instance_id")

    @_builtins.property
    @pulumi.getter
    def plugins(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of plugins to install. Must be a supported plugin name. The plugins `repository-s3` and `repository-azure` are enabled by default and cannot be disabled.
        """
        return pulumi.get(self, "plugins")

    @_builtins.property
    @pulumi.getter(name="sgwAcl")
    def sgw_acl(self) -> Optional[_builtins.str]:
        """
        Comma separated list of IP networks in CIDR notation which are allowed to access this instance.
        """
        return pulumi.get(self, "sgw_acl")

    @_builtins.property
    @pulumi.getter
    def syslogs(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of syslog servers to send logs to.
        """
        return pulumi.get(self, "syslogs")

    @_builtins.property
    @pulumi.getter(name="tlsCiphers")
    def tls_ciphers(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of TLS ciphers to use.
        """
        return pulumi.get(self, "tls_ciphers")

    @_builtins.property
    @pulumi.getter(name="tlsProtocols")
    def tls_protocols(self) -> Optional[Sequence[_builtins.str]]:
        """
        The TLS protocol to use.
        """
        return pulumi.get(self, "tls_protocols")


@pulumi.output_type
class PostgresflexInstanceFlavor(dict):
    def __init__(__self__, *,
                 cpu: _builtins.int,
                 ram: _builtins.int,
                 description: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None):
        pulumi.set(__self__, "cpu", cpu)
        pulumi.set(__self__, "ram", ram)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> _builtins.int:
        return pulumi.get(self, "cpu")

    @_builtins.property
    @pulumi.getter
    def ram(self) -> _builtins.int:
        return pulumi.get(self, "ram")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "id")


@pulumi.output_type
class PostgresflexInstanceStorage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "class":
            suggest = "class_"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PostgresflexInstanceStorage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PostgresflexInstanceStorage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PostgresflexInstanceStorage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 class_: _builtins.str,
                 size: _builtins.int):
        pulumi.set(__self__, "class_", class_)
        pulumi.set(__self__, "size", size)

    @_builtins.property
    @pulumi.getter(name="class")
    def class_(self) -> _builtins.str:
        return pulumi.get(self, "class_")

    @_builtins.property
    @pulumi.getter
    def size(self) -> _builtins.int:
        return pulumi.get(self, "size")


@pulumi.output_type
class RabbitmqInstanceParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "consumerTimeout":
            suggest = "consumer_timeout"
        elif key == "enableMonitoring":
            suggest = "enable_monitoring"
        elif key == "maxDiskThreshold":
            suggest = "max_disk_threshold"
        elif key == "metricsFrequency":
            suggest = "metrics_frequency"
        elif key == "metricsPrefix":
            suggest = "metrics_prefix"
        elif key == "monitoringInstanceId":
            suggest = "monitoring_instance_id"
        elif key == "sgwAcl":
            suggest = "sgw_acl"
        elif key == "tlsCiphers":
            suggest = "tls_ciphers"
        elif key == "tlsProtocols":
            suggest = "tls_protocols"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RabbitmqInstanceParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RabbitmqInstanceParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RabbitmqInstanceParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 consumer_timeout: Optional[_builtins.int] = None,
                 enable_monitoring: Optional[_builtins.bool] = None,
                 graphite: Optional[_builtins.str] = None,
                 max_disk_threshold: Optional[_builtins.int] = None,
                 metrics_frequency: Optional[_builtins.int] = None,
                 metrics_prefix: Optional[_builtins.str] = None,
                 monitoring_instance_id: Optional[_builtins.str] = None,
                 plugins: Optional[Sequence[_builtins.str]] = None,
                 roles: Optional[Sequence[_builtins.str]] = None,
                 sgw_acl: Optional[_builtins.str] = None,
                 syslogs: Optional[Sequence[_builtins.str]] = None,
                 tls_ciphers: Optional[Sequence[_builtins.str]] = None,
                 tls_protocols: Optional[_builtins.str] = None):
        """
        :param _builtins.int consumer_timeout: The timeout in milliseconds for the consumer.
        :param _builtins.bool enable_monitoring: Enable monitoring.
        :param _builtins.str graphite: Graphite server URL (host and port). If set, monitoring with Graphite will be enabled.
        :param _builtins.int max_disk_threshold: The maximum disk threshold in MB. If the disk usage exceeds this threshold, the instance will be stopped.
        :param _builtins.int metrics_frequency: The frequency in seconds at which metrics are emitted.
        :param _builtins.str metrics_prefix: The prefix for the metrics. Could be useful when using Graphite monitoring to prefix the metrics with a certain value, like an API key
        :param _builtins.str monitoring_instance_id: The ID of the STACKIT monitoring instance.
        :param Sequence[_builtins.str] plugins: List of plugins to install. Must be a supported plugin name.
        :param Sequence[_builtins.str] roles: List of roles to assign to the instance.
        :param _builtins.str sgw_acl: Comma separated list of IP networks in CIDR notation which are allowed to access this instance.
        :param Sequence[_builtins.str] syslogs: List of syslog servers to send logs to.
        :param Sequence[_builtins.str] tls_ciphers: List of TLS ciphers to use.
        :param _builtins.str tls_protocols: TLS protocol to use.
        """
        if consumer_timeout is not None:
            pulumi.set(__self__, "consumer_timeout", consumer_timeout)
        if enable_monitoring is not None:
            pulumi.set(__self__, "enable_monitoring", enable_monitoring)
        if graphite is not None:
            pulumi.set(__self__, "graphite", graphite)
        if max_disk_threshold is not None:
            pulumi.set(__self__, "max_disk_threshold", max_disk_threshold)
        if metrics_frequency is not None:
            pulumi.set(__self__, "metrics_frequency", metrics_frequency)
        if metrics_prefix is not None:
            pulumi.set(__self__, "metrics_prefix", metrics_prefix)
        if monitoring_instance_id is not None:
            pulumi.set(__self__, "monitoring_instance_id", monitoring_instance_id)
        if plugins is not None:
            pulumi.set(__self__, "plugins", plugins)
        if roles is not None:
            pulumi.set(__self__, "roles", roles)
        if sgw_acl is not None:
            pulumi.set(__self__, "sgw_acl", sgw_acl)
        if syslogs is not None:
            pulumi.set(__self__, "syslogs", syslogs)
        if tls_ciphers is not None:
            pulumi.set(__self__, "tls_ciphers", tls_ciphers)
        if tls_protocols is not None:
            pulumi.set(__self__, "tls_protocols", tls_protocols)

    @_builtins.property
    @pulumi.getter(name="consumerTimeout")
    def consumer_timeout(self) -> Optional[_builtins.int]:
        """
        The timeout in milliseconds for the consumer.
        """
        return pulumi.get(self, "consumer_timeout")

    @_builtins.property
    @pulumi.getter(name="enableMonitoring")
    def enable_monitoring(self) -> Optional[_builtins.bool]:
        """
        Enable monitoring.
        """
        return pulumi.get(self, "enable_monitoring")

    @_builtins.property
    @pulumi.getter
    def graphite(self) -> Optional[_builtins.str]:
        """
        Graphite server URL (host and port). If set, monitoring with Graphite will be enabled.
        """
        return pulumi.get(self, "graphite")

    @_builtins.property
    @pulumi.getter(name="maxDiskThreshold")
    def max_disk_threshold(self) -> Optional[_builtins.int]:
        """
        The maximum disk threshold in MB. If the disk usage exceeds this threshold, the instance will be stopped.
        """
        return pulumi.get(self, "max_disk_threshold")

    @_builtins.property
    @pulumi.getter(name="metricsFrequency")
    def metrics_frequency(self) -> Optional[_builtins.int]:
        """
        The frequency in seconds at which metrics are emitted.
        """
        return pulumi.get(self, "metrics_frequency")

    @_builtins.property
    @pulumi.getter(name="metricsPrefix")
    def metrics_prefix(self) -> Optional[_builtins.str]:
        """
        The prefix for the metrics. Could be useful when using Graphite monitoring to prefix the metrics with a certain value, like an API key
        """
        return pulumi.get(self, "metrics_prefix")

    @_builtins.property
    @pulumi.getter(name="monitoringInstanceId")
    def monitoring_instance_id(self) -> Optional[_builtins.str]:
        """
        The ID of the STACKIT monitoring instance.
        """
        return pulumi.get(self, "monitoring_instance_id")

    @_builtins.property
    @pulumi.getter
    def plugins(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of plugins to install. Must be a supported plugin name.
        """
        return pulumi.get(self, "plugins")

    @_builtins.property
    @pulumi.getter
    def roles(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of roles to assign to the instance.
        """
        return pulumi.get(self, "roles")

    @_builtins.property
    @pulumi.getter(name="sgwAcl")
    def sgw_acl(self) -> Optional[_builtins.str]:
        """
        Comma separated list of IP networks in CIDR notation which are allowed to access this instance.
        """
        return pulumi.get(self, "sgw_acl")

    @_builtins.property
    @pulumi.getter
    def syslogs(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of syslog servers to send logs to.
        """
        return pulumi.get(self, "syslogs")

    @_builtins.property
    @pulumi.getter(name="tlsCiphers")
    def tls_ciphers(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of TLS ciphers to use.
        """
        return pulumi.get(self, "tls_ciphers")

    @_builtins.property
    @pulumi.getter(name="tlsProtocols")
    def tls_protocols(self) -> Optional[_builtins.str]:
        """
        TLS protocol to use.
        """
        return pulumi.get(self, "tls_protocols")


@pulumi.output_type
class RedisInstanceParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "downAfterMilliseconds":
            suggest = "down_after_milliseconds"
        elif key == "enableMonitoring":
            suggest = "enable_monitoring"
        elif key == "failoverTimeout":
            suggest = "failover_timeout"
        elif key == "lazyfreeLazyEviction":
            suggest = "lazyfree_lazy_eviction"
        elif key == "lazyfreeLazyExpire":
            suggest = "lazyfree_lazy_expire"
        elif key == "luaTimeLimit":
            suggest = "lua_time_limit"
        elif key == "maxDiskThreshold":
            suggest = "max_disk_threshold"
        elif key == "maxmemoryPolicy":
            suggest = "maxmemory_policy"
        elif key == "maxmemorySamples":
            suggest = "maxmemory_samples"
        elif key == "metricsFrequency":
            suggest = "metrics_frequency"
        elif key == "metricsPrefix":
            suggest = "metrics_prefix"
        elif key == "minReplicasMaxLag":
            suggest = "min_replicas_max_lag"
        elif key == "monitoringInstanceId":
            suggest = "monitoring_instance_id"
        elif key == "notifyKeyspaceEvents":
            suggest = "notify_keyspace_events"
        elif key == "sgwAcl":
            suggest = "sgw_acl"
        elif key == "tlsCiphers":
            suggest = "tls_ciphers"
        elif key == "tlsCiphersuites":
            suggest = "tls_ciphersuites"
        elif key == "tlsProtocols":
            suggest = "tls_protocols"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RedisInstanceParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RedisInstanceParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RedisInstanceParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 down_after_milliseconds: Optional[_builtins.int] = None,
                 enable_monitoring: Optional[_builtins.bool] = None,
                 failover_timeout: Optional[_builtins.int] = None,
                 graphite: Optional[_builtins.str] = None,
                 lazyfree_lazy_eviction: Optional[_builtins.str] = None,
                 lazyfree_lazy_expire: Optional[_builtins.str] = None,
                 lua_time_limit: Optional[_builtins.int] = None,
                 max_disk_threshold: Optional[_builtins.int] = None,
                 maxclients: Optional[_builtins.int] = None,
                 maxmemory_policy: Optional[_builtins.str] = None,
                 maxmemory_samples: Optional[_builtins.int] = None,
                 metrics_frequency: Optional[_builtins.int] = None,
                 metrics_prefix: Optional[_builtins.str] = None,
                 min_replicas_max_lag: Optional[_builtins.int] = None,
                 monitoring_instance_id: Optional[_builtins.str] = None,
                 notify_keyspace_events: Optional[_builtins.str] = None,
                 sgw_acl: Optional[_builtins.str] = None,
                 snapshot: Optional[_builtins.str] = None,
                 syslogs: Optional[Sequence[_builtins.str]] = None,
                 tls_ciphers: Optional[Sequence[_builtins.str]] = None,
                 tls_ciphersuites: Optional[_builtins.str] = None,
                 tls_protocols: Optional[_builtins.str] = None):
        """
        :param _builtins.int down_after_milliseconds: The number of milliseconds after which the instance is considered down.
        :param _builtins.bool enable_monitoring: Enable monitoring.
        :param _builtins.int failover_timeout: The failover timeout in milliseconds.
        :param _builtins.str graphite: Graphite server URL (host and port). If set, monitoring with Graphite will be enabled.
        :param _builtins.str lazyfree_lazy_eviction: The lazy eviction enablement (yes or no).
        :param _builtins.str lazyfree_lazy_expire: The lazy expire enablement (yes or no).
        :param _builtins.int lua_time_limit: The Lua time limit.
        :param _builtins.int max_disk_threshold: The maximum disk threshold in MB. If the disk usage exceeds this threshold, the instance will be stopped.
        :param _builtins.int maxclients: The maximum number of clients.
        :param _builtins.str maxmemory_policy: The policy to handle the maximum memory (volatile-lru, noeviction, etc).
        :param _builtins.int maxmemory_samples: The maximum memory samples.
        :param _builtins.int metrics_frequency: The frequency in seconds at which metrics are emitted.
        :param _builtins.str metrics_prefix: The prefix for the metrics. Could be useful when using Graphite monitoring to prefix the metrics with a certain value, like an API key
        :param _builtins.int min_replicas_max_lag: The minimum replicas maximum lag.
        :param _builtins.str monitoring_instance_id: The ID of the STACKIT monitoring instance.
        :param _builtins.str notify_keyspace_events: The notify keyspace events.
        :param _builtins.str sgw_acl: Comma separated list of IP networks in CIDR notation which are allowed to access this instance.
        :param _builtins.str snapshot: The snapshot configuration.
        :param Sequence[_builtins.str] syslogs: List of syslog servers to send logs to.
        :param Sequence[_builtins.str] tls_ciphers: List of TLS ciphers to use.
        :param _builtins.str tls_ciphersuites: TLS cipher suites to use.
        :param _builtins.str tls_protocols: TLS protocol to use.
        """
        if down_after_milliseconds is not None:
            pulumi.set(__self__, "down_after_milliseconds", down_after_milliseconds)
        if enable_monitoring is not None:
            pulumi.set(__self__, "enable_monitoring", enable_monitoring)
        if failover_timeout is not None:
            pulumi.set(__self__, "failover_timeout", failover_timeout)
        if graphite is not None:
            pulumi.set(__self__, "graphite", graphite)
        if lazyfree_lazy_eviction is not None:
            pulumi.set(__self__, "lazyfree_lazy_eviction", lazyfree_lazy_eviction)
        if lazyfree_lazy_expire is not None:
            pulumi.set(__self__, "lazyfree_lazy_expire", lazyfree_lazy_expire)
        if lua_time_limit is not None:
            pulumi.set(__self__, "lua_time_limit", lua_time_limit)
        if max_disk_threshold is not None:
            pulumi.set(__self__, "max_disk_threshold", max_disk_threshold)
        if maxclients is not None:
            pulumi.set(__self__, "maxclients", maxclients)
        if maxmemory_policy is not None:
            pulumi.set(__self__, "maxmemory_policy", maxmemory_policy)
        if maxmemory_samples is not None:
            pulumi.set(__self__, "maxmemory_samples", maxmemory_samples)
        if metrics_frequency is not None:
            pulumi.set(__self__, "metrics_frequency", metrics_frequency)
        if metrics_prefix is not None:
            pulumi.set(__self__, "metrics_prefix", metrics_prefix)
        if min_replicas_max_lag is not None:
            pulumi.set(__self__, "min_replicas_max_lag", min_replicas_max_lag)
        if monitoring_instance_id is not None:
            pulumi.set(__self__, "monitoring_instance_id", monitoring_instance_id)
        if notify_keyspace_events is not None:
            pulumi.set(__self__, "notify_keyspace_events", notify_keyspace_events)
        if sgw_acl is not None:
            pulumi.set(__self__, "sgw_acl", sgw_acl)
        if snapshot is not None:
            pulumi.set(__self__, "snapshot", snapshot)
        if syslogs is not None:
            pulumi.set(__self__, "syslogs", syslogs)
        if tls_ciphers is not None:
            pulumi.set(__self__, "tls_ciphers", tls_ciphers)
        if tls_ciphersuites is not None:
            pulumi.set(__self__, "tls_ciphersuites", tls_ciphersuites)
        if tls_protocols is not None:
            pulumi.set(__self__, "tls_protocols", tls_protocols)

    @_builtins.property
    @pulumi.getter(name="downAfterMilliseconds")
    def down_after_milliseconds(self) -> Optional[_builtins.int]:
        """
        The number of milliseconds after which the instance is considered down.
        """
        return pulumi.get(self, "down_after_milliseconds")

    @_builtins.property
    @pulumi.getter(name="enableMonitoring")
    def enable_monitoring(self) -> Optional[_builtins.bool]:
        """
        Enable monitoring.
        """
        return pulumi.get(self, "enable_monitoring")

    @_builtins.property
    @pulumi.getter(name="failoverTimeout")
    def failover_timeout(self) -> Optional[_builtins.int]:
        """
        The failover timeout in milliseconds.
        """
        return pulumi.get(self, "failover_timeout")

    @_builtins.property
    @pulumi.getter
    def graphite(self) -> Optional[_builtins.str]:
        """
        Graphite server URL (host and port). If set, monitoring with Graphite will be enabled.
        """
        return pulumi.get(self, "graphite")

    @_builtins.property
    @pulumi.getter(name="lazyfreeLazyEviction")
    def lazyfree_lazy_eviction(self) -> Optional[_builtins.str]:
        """
        The lazy eviction enablement (yes or no).
        """
        return pulumi.get(self, "lazyfree_lazy_eviction")

    @_builtins.property
    @pulumi.getter(name="lazyfreeLazyExpire")
    def lazyfree_lazy_expire(self) -> Optional[_builtins.str]:
        """
        The lazy expire enablement (yes or no).
        """
        return pulumi.get(self, "lazyfree_lazy_expire")

    @_builtins.property
    @pulumi.getter(name="luaTimeLimit")
    def lua_time_limit(self) -> Optional[_builtins.int]:
        """
        The Lua time limit.
        """
        return pulumi.get(self, "lua_time_limit")

    @_builtins.property
    @pulumi.getter(name="maxDiskThreshold")
    def max_disk_threshold(self) -> Optional[_builtins.int]:
        """
        The maximum disk threshold in MB. If the disk usage exceeds this threshold, the instance will be stopped.
        """
        return pulumi.get(self, "max_disk_threshold")

    @_builtins.property
    @pulumi.getter
    def maxclients(self) -> Optional[_builtins.int]:
        """
        The maximum number of clients.
        """
        return pulumi.get(self, "maxclients")

    @_builtins.property
    @pulumi.getter(name="maxmemoryPolicy")
    def maxmemory_policy(self) -> Optional[_builtins.str]:
        """
        The policy to handle the maximum memory (volatile-lru, noeviction, etc).
        """
        return pulumi.get(self, "maxmemory_policy")

    @_builtins.property
    @pulumi.getter(name="maxmemorySamples")
    def maxmemory_samples(self) -> Optional[_builtins.int]:
        """
        The maximum memory samples.
        """
        return pulumi.get(self, "maxmemory_samples")

    @_builtins.property
    @pulumi.getter(name="metricsFrequency")
    def metrics_frequency(self) -> Optional[_builtins.int]:
        """
        The frequency in seconds at which metrics are emitted.
        """
        return pulumi.get(self, "metrics_frequency")

    @_builtins.property
    @pulumi.getter(name="metricsPrefix")
    def metrics_prefix(self) -> Optional[_builtins.str]:
        """
        The prefix for the metrics. Could be useful when using Graphite monitoring to prefix the metrics with a certain value, like an API key
        """
        return pulumi.get(self, "metrics_prefix")

    @_builtins.property
    @pulumi.getter(name="minReplicasMaxLag")
    def min_replicas_max_lag(self) -> Optional[_builtins.int]:
        """
        The minimum replicas maximum lag.
        """
        return pulumi.get(self, "min_replicas_max_lag")

    @_builtins.property
    @pulumi.getter(name="monitoringInstanceId")
    def monitoring_instance_id(self) -> Optional[_builtins.str]:
        """
        The ID of the STACKIT monitoring instance.
        """
        return pulumi.get(self, "monitoring_instance_id")

    @_builtins.property
    @pulumi.getter(name="notifyKeyspaceEvents")
    def notify_keyspace_events(self) -> Optional[_builtins.str]:
        """
        The notify keyspace events.
        """
        return pulumi.get(self, "notify_keyspace_events")

    @_builtins.property
    @pulumi.getter(name="sgwAcl")
    def sgw_acl(self) -> Optional[_builtins.str]:
        """
        Comma separated list of IP networks in CIDR notation which are allowed to access this instance.
        """
        return pulumi.get(self, "sgw_acl")

    @_builtins.property
    @pulumi.getter
    def snapshot(self) -> Optional[_builtins.str]:
        """
        The snapshot configuration.
        """
        return pulumi.get(self, "snapshot")

    @_builtins.property
    @pulumi.getter
    def syslogs(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of syslog servers to send logs to.
        """
        return pulumi.get(self, "syslogs")

    @_builtins.property
    @pulumi.getter(name="tlsCiphers")
    def tls_ciphers(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of TLS ciphers to use.
        """
        return pulumi.get(self, "tls_ciphers")

    @_builtins.property
    @pulumi.getter(name="tlsCiphersuites")
    def tls_ciphersuites(self) -> Optional[_builtins.str]:
        """
        TLS cipher suites to use.
        """
        return pulumi.get(self, "tls_ciphersuites")

    @_builtins.property
    @pulumi.getter(name="tlsProtocols")
    def tls_protocols(self) -> Optional[_builtins.str]:
        """
        TLS protocol to use.
        """
        return pulumi.get(self, "tls_protocols")


@pulumi.output_type
class RoutingTableRouteDestination(dict):
    def __init__(__self__, *,
                 type: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str type: CIDRV type. Possible values are: `cidrv4`, `cidrv6`. Only `cidrv4` is supported during experimental stage.
        :param _builtins.str value: An CIDR string.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        CIDRV type. Possible values are: `cidrv4`, `cidrv6`. Only `cidrv4` is supported during experimental stage.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        An CIDR string.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class RoutingTableRouteNextHop(dict):
    def __init__(__self__, *,
                 type: _builtins.str,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: Possible values are: `blackhole`, `internet`, `ipv4`, `ipv6`. Only `cidrv4` is supported during experimental stage..
        :param _builtins.str value: Either IPv4 or IPv6 (not set for blackhole and internet). Only IPv4 supported during experimental stage.
        """
        pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Possible values are: `blackhole`, `internet`, `ipv4`, `ipv6`. Only `cidrv4` is supported during experimental stage..
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        Either IPv4 or IPv6 (not set for blackhole and internet). Only IPv4 supported during experimental stage.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class SecurityGroupRuleIcmpParameters(dict):
    def __init__(__self__, *,
                 code: _builtins.int,
                 type: _builtins.int):
        """
        :param _builtins.int code: ICMP code. Can be set if the protocol is ICMP.
        :param _builtins.int type: ICMP type. Can be set if the protocol is ICMP.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def code(self) -> _builtins.int:
        """
        ICMP code. Can be set if the protocol is ICMP.
        """
        return pulumi.get(self, "code")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.int:
        """
        ICMP type. Can be set if the protocol is ICMP.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class SecurityGroupRulePortRange(dict):
    def __init__(__self__, *,
                 max: _builtins.int,
                 min: _builtins.int):
        """
        :param _builtins.int max: The maximum port number. Should be greater or equal to the minimum.
        :param _builtins.int min: The minimum port number. Should be less or equal to the maximum.
        """
        pulumi.set(__self__, "max", max)
        pulumi.set(__self__, "min", min)

    @_builtins.property
    @pulumi.getter
    def max(self) -> _builtins.int:
        """
        The maximum port number. Should be greater or equal to the minimum.
        """
        return pulumi.get(self, "max")

    @_builtins.property
    @pulumi.getter
    def min(self) -> _builtins.int:
        """
        The minimum port number. Should be less or equal to the maximum.
        """
        return pulumi.get(self, "min")


@pulumi.output_type
class SecurityGroupRuleProtocol(dict):
    def __init__(__self__, *,
                 name: Optional[_builtins.str] = None,
                 number: Optional[_builtins.int] = None):
        """
        :param _builtins.str name: The protocol name which the rule should match. Either `name` or `number` must be provided. Possible values are: `ah`, `dccp`, `egp`, `esp`, `gre`, `icmp`, `igmp`, `ipip`, `ipv6-encap`, `ipv6-frag`, `ipv6-icmp`, `ipv6-nonxt`, `ipv6-opts`, `ipv6-route`, `ospf`, `pgm`, `rsvp`, `sctp`, `tcp`, `udp`, `udplite`, `vrrp`.
        :param _builtins.int number: The protocol number which the rule should match. Either `name` or `number` must be provided.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if number is not None:
            pulumi.set(__self__, "number", number)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The protocol name which the rule should match. Either `name` or `number` must be provided. Possible values are: `ah`, `dccp`, `egp`, `esp`, `gre`, `icmp`, `igmp`, `ipip`, `ipv6-encap`, `ipv6-frag`, `ipv6-icmp`, `ipv6-nonxt`, `ipv6-opts`, `ipv6-route`, `ospf`, `pgm`, `rsvp`, `sctp`, `tcp`, `udp`, `udplite`, `vrrp`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def number(self) -> Optional[_builtins.int]:
        """
        The protocol number which the rule should match. Either `name` or `number` must be provided.
        """
        return pulumi.get(self, "number")


@pulumi.output_type
class ServerBackupScheduleBackupProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "retentionPeriod":
            suggest = "retention_period"
        elif key == "volumeIds":
            suggest = "volume_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerBackupScheduleBackupProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerBackupScheduleBackupProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerBackupScheduleBackupProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 retention_period: _builtins.int,
                 volume_ids: Optional[Sequence[_builtins.str]] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "retention_period", retention_period)
        if volume_ids is not None:
            pulumi.set(__self__, "volume_ids", volume_ids)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="retentionPeriod")
    def retention_period(self) -> _builtins.int:
        return pulumi.get(self, "retention_period")

    @_builtins.property
    @pulumi.getter(name="volumeIds")
    def volume_ids(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "volume_ids")


@pulumi.output_type
class ServerBootVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceId":
            suggest = "source_id"
        elif key == "sourceType":
            suggest = "source_type"
        elif key == "deleteOnTermination":
            suggest = "delete_on_termination"
        elif key == "performanceClass":
            suggest = "performance_class"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerBootVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerBootVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerBootVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_id: _builtins.str,
                 source_type: _builtins.str,
                 delete_on_termination: Optional[_builtins.bool] = None,
                 id: Optional[_builtins.str] = None,
                 performance_class: Optional[_builtins.str] = None,
                 size: Optional[_builtins.int] = None):
        """
        :param _builtins.str source_id: The ID of the source, either image ID or volume ID
        :param _builtins.str source_type: The type of the source. Supported values are: `volume`, `image`.
        :param _builtins.bool delete_on_termination: Delete the volume during the termination of the server. Only allowed when `source_type` is `image`.
        :param _builtins.str id: The ID of the boot volume
        :param _builtins.str performance_class: The performance class of the server.
        :param _builtins.int size: The size of the boot volume in GB. Must be provided when `source_type` is `image`.
        """
        pulumi.set(__self__, "source_id", source_id)
        pulumi.set(__self__, "source_type", source_type)
        if delete_on_termination is not None:
            pulumi.set(__self__, "delete_on_termination", delete_on_termination)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if performance_class is not None:
            pulumi.set(__self__, "performance_class", performance_class)
        if size is not None:
            pulumi.set(__self__, "size", size)

    @_builtins.property
    @pulumi.getter(name="sourceId")
    def source_id(self) -> _builtins.str:
        """
        The ID of the source, either image ID or volume ID
        """
        return pulumi.get(self, "source_id")

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> _builtins.str:
        """
        The type of the source. Supported values are: `volume`, `image`.
        """
        return pulumi.get(self, "source_type")

    @_builtins.property
    @pulumi.getter(name="deleteOnTermination")
    def delete_on_termination(self) -> Optional[_builtins.bool]:
        """
        Delete the volume during the termination of the server. Only allowed when `source_type` is `image`.
        """
        return pulumi.get(self, "delete_on_termination")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The ID of the boot volume
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="performanceClass")
    def performance_class(self) -> Optional[_builtins.str]:
        """
        The performance class of the server.
        """
        return pulumi.get(self, "performance_class")

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[_builtins.int]:
        """
        The size of the boot volume in GB. Must be provided when `source_type` is `image`.
        """
        return pulumi.get(self, "size")


@pulumi.output_type
class SkeClusterExtensions(dict):
    def __init__(__self__, *,
                 acl: Optional['outputs.SkeClusterExtensionsAcl'] = None,
                 argus: Optional['outputs.SkeClusterExtensionsArgus'] = None,
                 dns: Optional['outputs.SkeClusterExtensionsDns'] = None,
                 observability: Optional['outputs.SkeClusterExtensionsObservability'] = None):
        """
        :param 'SkeClusterExtensionsAclArgs' acl: Cluster access control configuration.
        :param 'SkeClusterExtensionsArgusArgs' argus: A single argus block as defined below. This field is deprecated and will be removed 06 January 2026.
        :param 'SkeClusterExtensionsDnsArgs' dns: DNS extension configuration
        :param 'SkeClusterExtensionsObservabilityArgs' observability: A single observability block as defined below.
        """
        if acl is not None:
            pulumi.set(__self__, "acl", acl)
        if argus is not None:
            pulumi.set(__self__, "argus", argus)
        if dns is not None:
            pulumi.set(__self__, "dns", dns)
        if observability is not None:
            pulumi.set(__self__, "observability", observability)

    @_builtins.property
    @pulumi.getter
    def acl(self) -> Optional['outputs.SkeClusterExtensionsAcl']:
        """
        Cluster access control configuration.
        """
        return pulumi.get(self, "acl")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Use observability instead.""")
    def argus(self) -> Optional['outputs.SkeClusterExtensionsArgus']:
        """
        A single argus block as defined below. This field is deprecated and will be removed 06 January 2026.
        """
        return pulumi.get(self, "argus")

    @_builtins.property
    @pulumi.getter
    def dns(self) -> Optional['outputs.SkeClusterExtensionsDns']:
        """
        DNS extension configuration
        """
        return pulumi.get(self, "dns")

    @_builtins.property
    @pulumi.getter
    def observability(self) -> Optional['outputs.SkeClusterExtensionsObservability']:
        """
        A single observability block as defined below.
        """
        return pulumi.get(self, "observability")


@pulumi.output_type
class SkeClusterExtensionsAcl(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedCidrs":
            suggest = "allowed_cidrs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SkeClusterExtensionsAcl. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SkeClusterExtensionsAcl.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SkeClusterExtensionsAcl.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_cidrs: Sequence[_builtins.str],
                 enabled: _builtins.bool):
        """
        :param Sequence[_builtins.str] allowed_cidrs: Specify a list of CIDRs to whitelist.
        :param _builtins.bool enabled: Is ACL enabled?
        """
        pulumi.set(__self__, "allowed_cidrs", allowed_cidrs)
        pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter(name="allowedCidrs")
    def allowed_cidrs(self) -> Sequence[_builtins.str]:
        """
        Specify a list of CIDRs to whitelist.
        """
        return pulumi.get(self, "allowed_cidrs")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Is ACL enabled?
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class SkeClusterExtensionsArgus(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "argusInstanceId":
            suggest = "argus_instance_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SkeClusterExtensionsArgus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SkeClusterExtensionsArgus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SkeClusterExtensionsArgus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 argus_instance_id: Optional[_builtins.str] = None):
        """
        :param _builtins.bool enabled: Flag to enable/disable Argus extensions.
        :param _builtins.str argus_instance_id: Argus instance ID to choose which Argus instance is used. Required when enabled is set to `true`.
        """
        pulumi.set(__self__, "enabled", enabled)
        if argus_instance_id is not None:
            pulumi.set(__self__, "argus_instance_id", argus_instance_id)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Flag to enable/disable Argus extensions.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="argusInstanceId")
    def argus_instance_id(self) -> Optional[_builtins.str]:
        """
        Argus instance ID to choose which Argus instance is used. Required when enabled is set to `true`.
        """
        return pulumi.get(self, "argus_instance_id")


@pulumi.output_type
class SkeClusterExtensionsDns(dict):
    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 zones: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.bool enabled: Flag to enable/disable DNS extensions
        :param Sequence[_builtins.str] zones: Specify a list of domain filters for externalDNS (e.g., `foo.runs.onstackit.cloud`)
        """
        pulumi.set(__self__, "enabled", enabled)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Flag to enable/disable DNS extensions
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def zones(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specify a list of domain filters for externalDNS (e.g., `foo.runs.onstackit.cloud`)
        """
        return pulumi.get(self, "zones")


@pulumi.output_type
class SkeClusterExtensionsObservability(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceId":
            suggest = "instance_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SkeClusterExtensionsObservability. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SkeClusterExtensionsObservability.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SkeClusterExtensionsObservability.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 instance_id: Optional[_builtins.str] = None):
        """
        :param _builtins.bool enabled: Flag to enable/disable Observability extensions.
        :param _builtins.str instance_id: Observability instance ID to choose which Observability instance is used. Required when enabled is set to `true`.
        """
        pulumi.set(__self__, "enabled", enabled)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Flag to enable/disable Observability extensions.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[_builtins.str]:
        """
        Observability instance ID to choose which Observability instance is used. Required when enabled is set to `true`.
        """
        return pulumi.get(self, "instance_id")


@pulumi.output_type
class SkeClusterHibernation(dict):
    def __init__(__self__, *,
                 end: _builtins.str,
                 start: _builtins.str,
                 timezone: Optional[_builtins.str] = None):
        """
        :param _builtins.str end: End time of hibernation in crontab syntax. E.g. `0 8 * * *` for waking up the cluster at 8am.
        :param _builtins.str start: Start time of cluster hibernation in crontab syntax. E.g. `0 18 * * *` for starting everyday at 6pm.
        :param _builtins.str timezone: Timezone name corresponding to a file in the IANA Time Zone database. i.e. `Europe/Berlin`.
        """
        pulumi.set(__self__, "end", end)
        pulumi.set(__self__, "start", start)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)

    @_builtins.property
    @pulumi.getter
    def end(self) -> _builtins.str:
        """
        End time of hibernation in crontab syntax. E.g. `0 8 * * *` for waking up the cluster at 8am.
        """
        return pulumi.get(self, "end")

    @_builtins.property
    @pulumi.getter
    def start(self) -> _builtins.str:
        """
        Start time of cluster hibernation in crontab syntax. E.g. `0 18 * * *` for starting everyday at 6pm.
        """
        return pulumi.get(self, "start")

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> Optional[_builtins.str]:
        """
        Timezone name corresponding to a file in the IANA Time Zone database. i.e. `Europe/Berlin`.
        """
        return pulumi.get(self, "timezone")


@pulumi.output_type
class SkeClusterMaintenance(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableKubernetesVersionUpdates":
            suggest = "enable_kubernetes_version_updates"
        elif key == "enableMachineImageVersionUpdates":
            suggest = "enable_machine_image_version_updates"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SkeClusterMaintenance. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SkeClusterMaintenance.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SkeClusterMaintenance.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end: _builtins.str,
                 start: _builtins.str,
                 enable_kubernetes_version_updates: Optional[_builtins.bool] = None,
                 enable_machine_image_version_updates: Optional[_builtins.bool] = None):
        """
        :param _builtins.str end: Time for maintenance window end. E.g. `01:23:45Z`, `05:00:00+02:00`.
        :param _builtins.str start: Time for maintenance window start. E.g. `01:23:45Z`, `05:00:00+02:00`.
        :param _builtins.bool enable_kubernetes_version_updates: Flag to enable/disable auto-updates of the Kubernetes version. Defaults to `true`. SKE automatically updates the cluster Kubernetes version if you have set `maintenance.enable_kubernetes_version_updates` to true or if there is a mandatory update, as described in [Updates for Kubernetes versions and Operating System versions in SKE](https://docs.stackit.cloud/stackit/en/version-updates-in-ske-10125631.html).
        :param _builtins.bool enable_machine_image_version_updates: Flag to enable/disable auto-updates of the OS image version. Defaults to `true`. SKE automatically updates the cluster Kubernetes version if you have set `maintenance.enable_kubernetes_version_updates` to true or if there is a mandatory update, as described in [Updates for Kubernetes versions and Operating System versions in SKE](https://docs.stackit.cloud/stackit/en/version-updates-in-ske-10125631.html).
        """
        pulumi.set(__self__, "end", end)
        pulumi.set(__self__, "start", start)
        if enable_kubernetes_version_updates is not None:
            pulumi.set(__self__, "enable_kubernetes_version_updates", enable_kubernetes_version_updates)
        if enable_machine_image_version_updates is not None:
            pulumi.set(__self__, "enable_machine_image_version_updates", enable_machine_image_version_updates)

    @_builtins.property
    @pulumi.getter
    def end(self) -> _builtins.str:
        """
        Time for maintenance window end. E.g. `01:23:45Z`, `05:00:00+02:00`.
        """
        return pulumi.get(self, "end")

    @_builtins.property
    @pulumi.getter
    def start(self) -> _builtins.str:
        """
        Time for maintenance window start. E.g. `01:23:45Z`, `05:00:00+02:00`.
        """
        return pulumi.get(self, "start")

    @_builtins.property
    @pulumi.getter(name="enableKubernetesVersionUpdates")
    def enable_kubernetes_version_updates(self) -> Optional[_builtins.bool]:
        """
        Flag to enable/disable auto-updates of the Kubernetes version. Defaults to `true`. SKE automatically updates the cluster Kubernetes version if you have set `maintenance.enable_kubernetes_version_updates` to true or if there is a mandatory update, as described in [Updates for Kubernetes versions and Operating System versions in SKE](https://docs.stackit.cloud/stackit/en/version-updates-in-ske-10125631.html).
        """
        return pulumi.get(self, "enable_kubernetes_version_updates")

    @_builtins.property
    @pulumi.getter(name="enableMachineImageVersionUpdates")
    def enable_machine_image_version_updates(self) -> Optional[_builtins.bool]:
        """
        Flag to enable/disable auto-updates of the OS image version. Defaults to `true`. SKE automatically updates the cluster Kubernetes version if you have set `maintenance.enable_kubernetes_version_updates` to true or if there is a mandatory update, as described in [Updates for Kubernetes versions and Operating System versions in SKE](https://docs.stackit.cloud/stackit/en/version-updates-in-ske-10125631.html).
        """
        return pulumi.get(self, "enable_machine_image_version_updates")


@pulumi.output_type
class SkeClusterNetwork(dict):
    def __init__(__self__, *,
                 id: Optional[_builtins.str] = None):
        """
        :param _builtins.str id: ID of the STACKIT Network Area (SNA) network into which the cluster will be deployed.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        ID of the STACKIT Network Area (SNA) network into which the cluster will be deployed.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class SkeClusterNodePool(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availabilityZones":
            suggest = "availability_zones"
        elif key == "machineType":
            suggest = "machine_type"
        elif key == "allowSystemComponents":
            suggest = "allow_system_components"
        elif key == "maxSurge":
            suggest = "max_surge"
        elif key == "maxUnavailable":
            suggest = "max_unavailable"
        elif key == "osName":
            suggest = "os_name"
        elif key == "osVersion":
            suggest = "os_version"
        elif key == "osVersionMin":
            suggest = "os_version_min"
        elif key == "osVersionUsed":
            suggest = "os_version_used"
        elif key == "volumeSize":
            suggest = "volume_size"
        elif key == "volumeType":
            suggest = "volume_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SkeClusterNodePool. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SkeClusterNodePool.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SkeClusterNodePool.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 availability_zones: Sequence[_builtins.str],
                 machine_type: _builtins.str,
                 maximum: _builtins.int,
                 minimum: _builtins.int,
                 name: _builtins.str,
                 allow_system_components: Optional[_builtins.bool] = None,
                 cri: Optional[_builtins.str] = None,
                 labels: Optional[Mapping[str, _builtins.str]] = None,
                 max_surge: Optional[_builtins.int] = None,
                 max_unavailable: Optional[_builtins.int] = None,
                 os_name: Optional[_builtins.str] = None,
                 os_version: Optional[_builtins.str] = None,
                 os_version_min: Optional[_builtins.str] = None,
                 os_version_used: Optional[_builtins.str] = None,
                 taints: Optional[Sequence['outputs.SkeClusterNodePoolTaint']] = None,
                 volume_size: Optional[_builtins.int] = None,
                 volume_type: Optional[_builtins.str] = None):
        """
        :param Sequence[_builtins.str] availability_zones: Specify a list of availability zones. E.g. `eu01-m`
        :param _builtins.str machine_type: The machine type.
        :param _builtins.int maximum: Maximum number of nodes in the pool.
        :param _builtins.int minimum: Minimum number of nodes in the pool.
        :param _builtins.str name: Specifies the name of the node pool.
        :param _builtins.bool allow_system_components: Allow system components to run on this node pool.
        :param _builtins.str cri: Specifies the container runtime. Defaults to `containerd`
        :param Mapping[str, _builtins.str] labels: Labels to add to each node.
        :param _builtins.int max_surge: Maximum number of additional VMs that are created during an update. If set (larger than 0), then it must be at least the amount of zones configured for the nodepool. The `max_surge` and `max_unavailable` fields cannot both be unset at the same time.
        :param _builtins.int max_unavailable: Maximum number of VMs that that can be unavailable during an update. If set (larger than 0), then it must be at least the amount of zones configured for the nodepool. The `max_surge` and `max_unavailable` fields cannot both be unset at the same time.
        :param _builtins.str os_name: The name of the OS image. Defaults to `flatcar`.
        :param _builtins.str os_version: This field is deprecated, use `os_version_min` to configure the version and `os_version_used` to get the currently used version instead.
        :param _builtins.str os_version_min: The minimum OS image version. This field will be used to set the minimum OS image version on creation/update of the cluster. If unset, the latest supported OS image version will be used. SKE automatically updates the cluster Kubernetes version if you have set `maintenance.enable_kubernetes_version_updates` to true or if there is a mandatory update, as described in [Updates for Kubernetes versions and Operating System versions in SKE](https://docs.stackit.cloud/stackit/en/version-updates-in-ske-10125631.html). To get the current OS image version being used for the node pool, use the read-only `os_version_used` field.
        :param _builtins.str os_version_used: Full OS image version used. For example, if 3815.2 was set in `os_version_min`, this value may result to 3815.2.2. SKE automatically updates the cluster Kubernetes version if you have set `maintenance.enable_kubernetes_version_updates` to true or if there is a mandatory update, as described in [Updates for Kubernetes versions and Operating System versions in SKE](https://docs.stackit.cloud/stackit/en/version-updates-in-ske-10125631.html).
        :param Sequence['SkeClusterNodePoolTaintArgs'] taints: Specifies a taint list as defined below.
        :param _builtins.int volume_size: The volume size in GB. Defaults to `20`
        :param _builtins.str volume_type: Specifies the volume type. Defaults to `storage_premium_perf1`.
        """
        pulumi.set(__self__, "availability_zones", availability_zones)
        pulumi.set(__self__, "machine_type", machine_type)
        pulumi.set(__self__, "maximum", maximum)
        pulumi.set(__self__, "minimum", minimum)
        pulumi.set(__self__, "name", name)
        if allow_system_components is not None:
            pulumi.set(__self__, "allow_system_components", allow_system_components)
        if cri is not None:
            pulumi.set(__self__, "cri", cri)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if max_surge is not None:
            pulumi.set(__self__, "max_surge", max_surge)
        if max_unavailable is not None:
            pulumi.set(__self__, "max_unavailable", max_unavailable)
        if os_name is not None:
            pulumi.set(__self__, "os_name", os_name)
        if os_version is not None:
            pulumi.set(__self__, "os_version", os_version)
        if os_version_min is not None:
            pulumi.set(__self__, "os_version_min", os_version_min)
        if os_version_used is not None:
            pulumi.set(__self__, "os_version_used", os_version_used)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)
        if volume_size is not None:
            pulumi.set(__self__, "volume_size", volume_size)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @_builtins.property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Sequence[_builtins.str]:
        """
        Specify a list of availability zones. E.g. `eu01-m`
        """
        return pulumi.get(self, "availability_zones")

    @_builtins.property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> _builtins.str:
        """
        The machine type.
        """
        return pulumi.get(self, "machine_type")

    @_builtins.property
    @pulumi.getter
    def maximum(self) -> _builtins.int:
        """
        Maximum number of nodes in the pool.
        """
        return pulumi.get(self, "maximum")

    @_builtins.property
    @pulumi.getter
    def minimum(self) -> _builtins.int:
        """
        Minimum number of nodes in the pool.
        """
        return pulumi.get(self, "minimum")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the name of the node pool.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="allowSystemComponents")
    def allow_system_components(self) -> Optional[_builtins.bool]:
        """
        Allow system components to run on this node pool.
        """
        return pulumi.get(self, "allow_system_components")

    @_builtins.property
    @pulumi.getter
    def cri(self) -> Optional[_builtins.str]:
        """
        Specifies the container runtime. Defaults to `containerd`
        """
        return pulumi.get(self, "cri")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Labels to add to each node.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="maxSurge")
    def max_surge(self) -> Optional[_builtins.int]:
        """
        Maximum number of additional VMs that are created during an update. If set (larger than 0), then it must be at least the amount of zones configured for the nodepool. The `max_surge` and `max_unavailable` fields cannot both be unset at the same time.
        """
        return pulumi.get(self, "max_surge")

    @_builtins.property
    @pulumi.getter(name="maxUnavailable")
    def max_unavailable(self) -> Optional[_builtins.int]:
        """
        Maximum number of VMs that that can be unavailable during an update. If set (larger than 0), then it must be at least the amount of zones configured for the nodepool. The `max_surge` and `max_unavailable` fields cannot both be unset at the same time.
        """
        return pulumi.get(self, "max_unavailable")

    @_builtins.property
    @pulumi.getter(name="osName")
    def os_name(self) -> Optional[_builtins.str]:
        """
        The name of the OS image. Defaults to `flatcar`.
        """
        return pulumi.get(self, "os_name")

    @_builtins.property
    @pulumi.getter(name="osVersion")
    @_utilities.deprecated("""Use `os_version_min` to configure the version and `os_version_used` to get the currently used version instead. Setting a specific OS image version will cause errors during minor OS upgrades due to forced updates.""")
    def os_version(self) -> Optional[_builtins.str]:
        """
        This field is deprecated, use `os_version_min` to configure the version and `os_version_used` to get the currently used version instead.
        """
        return pulumi.get(self, "os_version")

    @_builtins.property
    @pulumi.getter(name="osVersionMin")
    def os_version_min(self) -> Optional[_builtins.str]:
        """
        The minimum OS image version. This field will be used to set the minimum OS image version on creation/update of the cluster. If unset, the latest supported OS image version will be used. SKE automatically updates the cluster Kubernetes version if you have set `maintenance.enable_kubernetes_version_updates` to true or if there is a mandatory update, as described in [Updates for Kubernetes versions and Operating System versions in SKE](https://docs.stackit.cloud/stackit/en/version-updates-in-ske-10125631.html). To get the current OS image version being used for the node pool, use the read-only `os_version_used` field.
        """
        return pulumi.get(self, "os_version_min")

    @_builtins.property
    @pulumi.getter(name="osVersionUsed")
    def os_version_used(self) -> Optional[_builtins.str]:
        """
        Full OS image version used. For example, if 3815.2 was set in `os_version_min`, this value may result to 3815.2.2. SKE automatically updates the cluster Kubernetes version if you have set `maintenance.enable_kubernetes_version_updates` to true or if there is a mandatory update, as described in [Updates for Kubernetes versions and Operating System versions in SKE](https://docs.stackit.cloud/stackit/en/version-updates-in-ske-10125631.html).
        """
        return pulumi.get(self, "os_version_used")

    @_builtins.property
    @pulumi.getter
    def taints(self) -> Optional[Sequence['outputs.SkeClusterNodePoolTaint']]:
        """
        Specifies a taint list as defined below.
        """
        return pulumi.get(self, "taints")

    @_builtins.property
    @pulumi.getter(name="volumeSize")
    def volume_size(self) -> Optional[_builtins.int]:
        """
        The volume size in GB. Defaults to `20`
        """
        return pulumi.get(self, "volume_size")

    @_builtins.property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[_builtins.str]:
        """
        Specifies the volume type. Defaults to `storage_premium_perf1`.
        """
        return pulumi.get(self, "volume_type")


@pulumi.output_type
class SkeClusterNodePoolTaint(dict):
    def __init__(__self__, *,
                 effect: _builtins.str,
                 key: _builtins.str,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str effect: The taint effect. E.g `PreferNoSchedule`.
        :param _builtins.str key: Taint key to be applied to a node.
        :param _builtins.str value: Taint value corresponding to the taint key.
        """
        pulumi.set(__self__, "effect", effect)
        pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def effect(self) -> _builtins.str:
        """
        The taint effect. E.g `PreferNoSchedule`.
        """
        return pulumi.get(self, "effect")

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        Taint key to be applied to a node.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        Taint value corresponding to the taint key.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class SqlserverflexInstanceFlavor(dict):
    def __init__(__self__, *,
                 cpu: _builtins.int,
                 ram: _builtins.int,
                 description: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None):
        pulumi.set(__self__, "cpu", cpu)
        pulumi.set(__self__, "ram", ram)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> _builtins.int:
        return pulumi.get(self, "cpu")

    @_builtins.property
    @pulumi.getter
    def ram(self) -> _builtins.int:
        return pulumi.get(self, "ram")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "id")


@pulumi.output_type
class SqlserverflexInstanceOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "retentionDays":
            suggest = "retention_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SqlserverflexInstanceOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SqlserverflexInstanceOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SqlserverflexInstanceOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 edition: Optional[_builtins.str] = None,
                 retention_days: Optional[_builtins.int] = None):
        if edition is not None:
            pulumi.set(__self__, "edition", edition)
        if retention_days is not None:
            pulumi.set(__self__, "retention_days", retention_days)

    @_builtins.property
    @pulumi.getter
    def edition(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "edition")

    @_builtins.property
    @pulumi.getter(name="retentionDays")
    def retention_days(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "retention_days")


@pulumi.output_type
class SqlserverflexInstanceStorage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "class":
            suggest = "class_"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SqlserverflexInstanceStorage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SqlserverflexInstanceStorage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SqlserverflexInstanceStorage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 class_: Optional[_builtins.str] = None,
                 size: Optional[_builtins.int] = None):
        if class_ is not None:
            pulumi.set(__self__, "class_", class_)
        if size is not None:
            pulumi.set(__self__, "size", size)

    @_builtins.property
    @pulumi.getter(name="class")
    def class_(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "class_")

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "size")


@pulumi.output_type
class VolumeSource(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str id: The ID of the source, e.g. image ID
        :param _builtins.str type: The type of the source. Supported values are: `volume`, `image`, `snapshot`, `backup`.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the source, e.g. image ID
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the source. Supported values are: `volume`, `image`, `snapshot`, `backup`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetCdnDistributionConfigResult(dict):
    def __init__(__self__, *,
                 backend: 'outputs.GetCdnDistributionConfigBackendResult',
                 optimizer: 'outputs.GetCdnDistributionConfigOptimizerResult',
                 regions: Sequence[_builtins.str],
                 blocked_countries: Optional[Sequence[_builtins.str]] = None):
        """
        :param 'GetCdnDistributionConfigBackendArgs' backend: The configured backend for the distribution
        :param 'GetCdnDistributionConfigOptimizerArgs' optimizer: Configuration for the Image Optimizer. This is a paid feature that automatically optimizes images to reduce their file size for faster delivery, leading to improved website performance and a better user experience.
        :param Sequence[_builtins.str] regions: The configured regions where content will be hosted
        :param Sequence[_builtins.str] blocked_countries: The configured countries where distribution of content is blocked
        """
        pulumi.set(__self__, "backend", backend)
        pulumi.set(__self__, "optimizer", optimizer)
        pulumi.set(__self__, "regions", regions)
        if blocked_countries is not None:
            pulumi.set(__self__, "blocked_countries", blocked_countries)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> 'outputs.GetCdnDistributionConfigBackendResult':
        """
        The configured backend for the distribution
        """
        return pulumi.get(self, "backend")

    @_builtins.property
    @pulumi.getter
    def optimizer(self) -> 'outputs.GetCdnDistributionConfigOptimizerResult':
        """
        Configuration for the Image Optimizer. This is a paid feature that automatically optimizes images to reduce their file size for faster delivery, leading to improved website performance and a better user experience.
        """
        return pulumi.get(self, "optimizer")

    @_builtins.property
    @pulumi.getter
    def regions(self) -> Sequence[_builtins.str]:
        """
        The configured regions where content will be hosted
        """
        return pulumi.get(self, "regions")

    @_builtins.property
    @pulumi.getter(name="blockedCountries")
    def blocked_countries(self) -> Optional[Sequence[_builtins.str]]:
        """
        The configured countries where distribution of content is blocked
        """
        return pulumi.get(self, "blocked_countries")


@pulumi.output_type
class GetCdnDistributionConfigBackendResult(dict):
    def __init__(__self__, *,
                 origin_request_headers: Mapping[str, _builtins.str],
                 origin_url: _builtins.str,
                 type: _builtins.str):
        """
        :param Mapping[str, _builtins.str] origin_request_headers: The configured origin request headers for the backend
        :param _builtins.str origin_url: The configured backend type for the distribution
        :param _builtins.str type: The configured backend type. Supported values are: `http`.
        """
        pulumi.set(__self__, "origin_request_headers", origin_request_headers)
        pulumi.set(__self__, "origin_url", origin_url)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="originRequestHeaders")
    def origin_request_headers(self) -> Mapping[str, _builtins.str]:
        """
        The configured origin request headers for the backend
        """
        return pulumi.get(self, "origin_request_headers")

    @_builtins.property
    @pulumi.getter(name="originUrl")
    def origin_url(self) -> _builtins.str:
        """
        The configured backend type for the distribution
        """
        return pulumi.get(self, "origin_url")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The configured backend type. Supported values are: `http`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetCdnDistributionConfigOptimizerResult(dict):
    def __init__(__self__, *,
                 enabled: _builtins.bool):
        pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        return pulumi.get(self, "enabled")


@pulumi.output_type
class GetCdnDistributionDomainResult(dict):
    def __init__(__self__, *,
                 errors: Sequence[_builtins.str],
                 name: _builtins.str,
                 status: _builtins.str,
                 type: _builtins.str):
        """
        :param Sequence[_builtins.str] errors: List of domain errors
        :param _builtins.str name: The name of the domain
        :param _builtins.str status: The status of the domain
        :param _builtins.str type: The type of the domain. Each distribution has one domain of type "managed", and domains of type "custom" may be additionally created by the user
        """
        pulumi.set(__self__, "errors", errors)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def errors(self) -> Sequence[_builtins.str]:
        """
        List of domain errors
        """
        return pulumi.get(self, "errors")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the domain
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the domain
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the domain. Each distribution has one domain of type "managed", and domains of type "custom" may be additionally created by the user
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetImageChecksumResult(dict):
    def __init__(__self__, *,
                 algorithm: _builtins.str,
                 digest: _builtins.str):
        """
        :param _builtins.str algorithm: Algorithm for the checksum of the image data.
        :param _builtins.str digest: Hexdigest of the checksum of the image data.
        """
        pulumi.set(__self__, "algorithm", algorithm)
        pulumi.set(__self__, "digest", digest)

    @_builtins.property
    @pulumi.getter
    def algorithm(self) -> _builtins.str:
        """
        Algorithm for the checksum of the image data.
        """
        return pulumi.get(self, "algorithm")

    @_builtins.property
    @pulumi.getter
    def digest(self) -> _builtins.str:
        """
        Hexdigest of the checksum of the image data.
        """
        return pulumi.get(self, "digest")


@pulumi.output_type
class GetImageConfigResult(dict):
    def __init__(__self__, *,
                 boot_menu: _builtins.bool,
                 cdrom_bus: _builtins.str,
                 disk_bus: _builtins.str,
                 nic_model: _builtins.str,
                 operating_system: _builtins.str,
                 operating_system_distro: _builtins.str,
                 operating_system_version: _builtins.str,
                 rescue_bus: _builtins.str,
                 rescue_device: _builtins.str,
                 secure_boot: _builtins.bool,
                 uefi: _builtins.bool,
                 video_model: _builtins.str,
                 virtio_scsi: _builtins.bool):
        """
        :param _builtins.bool boot_menu: Enables the BIOS bootmenu.
        :param _builtins.str cdrom_bus: Sets CDROM bus controller type.
        :param _builtins.str disk_bus: Sets Disk bus controller type.
        :param _builtins.str nic_model: Sets virtual network interface model.
        :param _builtins.str operating_system: Enables operating system specific optimizations.
        :param _builtins.str operating_system_distro: Operating system distribution.
        :param _builtins.str operating_system_version: Version of the operating system.
        :param _builtins.str rescue_bus: Sets the device bus when the image is used as a rescue image.
        :param _builtins.str rescue_device: Sets the device when the image is used as a rescue image.
        :param _builtins.bool secure_boot: Enables Secure Boot.
        :param _builtins.bool uefi: Enables UEFI boot.
        :param _builtins.str video_model: Sets Graphic device model.
        :param _builtins.bool virtio_scsi: Enables the use of VirtIO SCSI to provide block device access. By default instances use VirtIO Block.
        """
        pulumi.set(__self__, "boot_menu", boot_menu)
        pulumi.set(__self__, "cdrom_bus", cdrom_bus)
        pulumi.set(__self__, "disk_bus", disk_bus)
        pulumi.set(__self__, "nic_model", nic_model)
        pulumi.set(__self__, "operating_system", operating_system)
        pulumi.set(__self__, "operating_system_distro", operating_system_distro)
        pulumi.set(__self__, "operating_system_version", operating_system_version)
        pulumi.set(__self__, "rescue_bus", rescue_bus)
        pulumi.set(__self__, "rescue_device", rescue_device)
        pulumi.set(__self__, "secure_boot", secure_boot)
        pulumi.set(__self__, "uefi", uefi)
        pulumi.set(__self__, "video_model", video_model)
        pulumi.set(__self__, "virtio_scsi", virtio_scsi)

    @_builtins.property
    @pulumi.getter(name="bootMenu")
    def boot_menu(self) -> _builtins.bool:
        """
        Enables the BIOS bootmenu.
        """
        return pulumi.get(self, "boot_menu")

    @_builtins.property
    @pulumi.getter(name="cdromBus")
    def cdrom_bus(self) -> _builtins.str:
        """
        Sets CDROM bus controller type.
        """
        return pulumi.get(self, "cdrom_bus")

    @_builtins.property
    @pulumi.getter(name="diskBus")
    def disk_bus(self) -> _builtins.str:
        """
        Sets Disk bus controller type.
        """
        return pulumi.get(self, "disk_bus")

    @_builtins.property
    @pulumi.getter(name="nicModel")
    def nic_model(self) -> _builtins.str:
        """
        Sets virtual network interface model.
        """
        return pulumi.get(self, "nic_model")

    @_builtins.property
    @pulumi.getter(name="operatingSystem")
    def operating_system(self) -> _builtins.str:
        """
        Enables operating system specific optimizations.
        """
        return pulumi.get(self, "operating_system")

    @_builtins.property
    @pulumi.getter(name="operatingSystemDistro")
    def operating_system_distro(self) -> _builtins.str:
        """
        Operating system distribution.
        """
        return pulumi.get(self, "operating_system_distro")

    @_builtins.property
    @pulumi.getter(name="operatingSystemVersion")
    def operating_system_version(self) -> _builtins.str:
        """
        Version of the operating system.
        """
        return pulumi.get(self, "operating_system_version")

    @_builtins.property
    @pulumi.getter(name="rescueBus")
    def rescue_bus(self) -> _builtins.str:
        """
        Sets the device bus when the image is used as a rescue image.
        """
        return pulumi.get(self, "rescue_bus")

    @_builtins.property
    @pulumi.getter(name="rescueDevice")
    def rescue_device(self) -> _builtins.str:
        """
        Sets the device when the image is used as a rescue image.
        """
        return pulumi.get(self, "rescue_device")

    @_builtins.property
    @pulumi.getter(name="secureBoot")
    def secure_boot(self) -> _builtins.bool:
        """
        Enables Secure Boot.
        """
        return pulumi.get(self, "secure_boot")

    @_builtins.property
    @pulumi.getter
    def uefi(self) -> _builtins.bool:
        """
        Enables UEFI boot.
        """
        return pulumi.get(self, "uefi")

    @_builtins.property
    @pulumi.getter(name="videoModel")
    def video_model(self) -> _builtins.str:
        """
        Sets Graphic device model.
        """
        return pulumi.get(self, "video_model")

    @_builtins.property
    @pulumi.getter(name="virtioScsi")
    def virtio_scsi(self) -> _builtins.bool:
        """
        Enables the use of VirtIO SCSI to provide block device access. By default instances use VirtIO Block.
        """
        return pulumi.get(self, "virtio_scsi")


@pulumi.output_type
class GetLoadbalancerListenerResult(dict):
    def __init__(__self__, *,
                 display_name: _builtins.str,
                 port: _builtins.int,
                 protocol: _builtins.str,
                 target_pool: _builtins.str,
                 server_name_indicators: Optional[Sequence['outputs.GetLoadbalancerListenerServerNameIndicatorResult']] = None):
        """
        :param _builtins.int port: Port number where we listen for traffic.
        :param _builtins.str protocol: Protocol is the highest network protocol we understand to load balance.
        :param _builtins.str target_pool: Reference target pool by target pool name.
        :param Sequence['GetLoadbalancerListenerServerNameIndicatorArgs'] server_name_indicators: A list of domain names to match in order to pass TLS traffic to the target pool in the current listener
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "target_pool", target_pool)
        if server_name_indicators is not None:
            pulumi.set(__self__, "server_name_indicators", server_name_indicators)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        Port number where we listen for traffic.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        Protocol is the highest network protocol we understand to load balance.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="targetPool")
    def target_pool(self) -> _builtins.str:
        """
        Reference target pool by target pool name.
        """
        return pulumi.get(self, "target_pool")

    @_builtins.property
    @pulumi.getter(name="serverNameIndicators")
    def server_name_indicators(self) -> Optional[Sequence['outputs.GetLoadbalancerListenerServerNameIndicatorResult']]:
        """
        A list of domain names to match in order to pass TLS traffic to the target pool in the current listener
        """
        return pulumi.get(self, "server_name_indicators")


@pulumi.output_type
class GetLoadbalancerListenerServerNameIndicatorResult(dict):
    def __init__(__self__, *,
                 name: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: A domain name to match in order to pass TLS traffic to the target pool in the current listener
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        A domain name to match in order to pass TLS traffic to the target pool in the current listener
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetLoadbalancerNetworkResult(dict):
    def __init__(__self__, *,
                 network_id: _builtins.str,
                 role: _builtins.str):
        """
        :param _builtins.str network_id: Openstack network ID.
        :param _builtins.str role: The role defines how the load balancer is using the network.
        """
        pulumi.set(__self__, "network_id", network_id)
        pulumi.set(__self__, "role", role)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> _builtins.str:
        """
        Openstack network ID.
        """
        return pulumi.get(self, "network_id")

    @_builtins.property
    @pulumi.getter
    def role(self) -> _builtins.str:
        """
        The role defines how the load balancer is using the network.
        """
        return pulumi.get(self, "role")


@pulumi.output_type
class GetLoadbalancerOptionsResult(dict):
    def __init__(__self__, *,
                 acls: Sequence[_builtins.str],
                 observability: 'outputs.GetLoadbalancerOptionsObservabilityResult',
                 private_network_only: _builtins.bool):
        """
        :param Sequence[_builtins.str] acls: Load Balancer is accessible only from an IP address in this range.
        :param 'GetLoadbalancerOptionsObservabilityArgs' observability: We offer Load Balancer metrics observability via ARGUS or external solutions.
        :param _builtins.bool private_network_only: If true, Load Balancer is accessible only via a private network IP address.
        """
        pulumi.set(__self__, "acls", acls)
        pulumi.set(__self__, "observability", observability)
        pulumi.set(__self__, "private_network_only", private_network_only)

    @_builtins.property
    @pulumi.getter
    def acls(self) -> Sequence[_builtins.str]:
        """
        Load Balancer is accessible only from an IP address in this range.
        """
        return pulumi.get(self, "acls")

    @_builtins.property
    @pulumi.getter
    def observability(self) -> 'outputs.GetLoadbalancerOptionsObservabilityResult':
        """
        We offer Load Balancer metrics observability via ARGUS or external solutions.
        """
        return pulumi.get(self, "observability")

    @_builtins.property
    @pulumi.getter(name="privateNetworkOnly")
    def private_network_only(self) -> _builtins.bool:
        """
        If true, Load Balancer is accessible only via a private network IP address.
        """
        return pulumi.get(self, "private_network_only")


@pulumi.output_type
class GetLoadbalancerOptionsObservabilityResult(dict):
    def __init__(__self__, *,
                 logs: 'outputs.GetLoadbalancerOptionsObservabilityLogsResult',
                 metrics: 'outputs.GetLoadbalancerOptionsObservabilityMetricsResult'):
        """
        :param 'GetLoadbalancerOptionsObservabilityLogsArgs' logs: Observability logs configuration.
        :param 'GetLoadbalancerOptionsObservabilityMetricsArgs' metrics: Observability metrics configuration.
        """
        pulumi.set(__self__, "logs", logs)
        pulumi.set(__self__, "metrics", metrics)

    @_builtins.property
    @pulumi.getter
    def logs(self) -> 'outputs.GetLoadbalancerOptionsObservabilityLogsResult':
        """
        Observability logs configuration.
        """
        return pulumi.get(self, "logs")

    @_builtins.property
    @pulumi.getter
    def metrics(self) -> 'outputs.GetLoadbalancerOptionsObservabilityMetricsResult':
        """
        Observability metrics configuration.
        """
        return pulumi.get(self, "metrics")


@pulumi.output_type
class GetLoadbalancerOptionsObservabilityLogsResult(dict):
    def __init__(__self__, *,
                 credentials_ref: _builtins.str,
                 push_url: _builtins.str):
        """
        :param _builtins.str credentials_ref: Credentials reference for logs.
        :param _builtins.str push_url: Credentials reference for logs.
        """
        pulumi.set(__self__, "credentials_ref", credentials_ref)
        pulumi.set(__self__, "push_url", push_url)

    @_builtins.property
    @pulumi.getter(name="credentialsRef")
    def credentials_ref(self) -> _builtins.str:
        """
        Credentials reference for logs.
        """
        return pulumi.get(self, "credentials_ref")

    @_builtins.property
    @pulumi.getter(name="pushUrl")
    def push_url(self) -> _builtins.str:
        """
        Credentials reference for logs.
        """
        return pulumi.get(self, "push_url")


@pulumi.output_type
class GetLoadbalancerOptionsObservabilityMetricsResult(dict):
    def __init__(__self__, *,
                 credentials_ref: _builtins.str,
                 push_url: _builtins.str):
        """
        :param _builtins.str credentials_ref: Credentials reference for metrics.
        :param _builtins.str push_url: Credentials reference for metrics.
        """
        pulumi.set(__self__, "credentials_ref", credentials_ref)
        pulumi.set(__self__, "push_url", push_url)

    @_builtins.property
    @pulumi.getter(name="credentialsRef")
    def credentials_ref(self) -> _builtins.str:
        """
        Credentials reference for metrics.
        """
        return pulumi.get(self, "credentials_ref")

    @_builtins.property
    @pulumi.getter(name="pushUrl")
    def push_url(self) -> _builtins.str:
        """
        Credentials reference for metrics.
        """
        return pulumi.get(self, "push_url")


@pulumi.output_type
class GetLoadbalancerTargetPoolResult(dict):
    def __init__(__self__, *,
                 active_health_check: 'outputs.GetLoadbalancerTargetPoolActiveHealthCheckResult',
                 name: _builtins.str,
                 target_port: _builtins.int,
                 targets: Sequence['outputs.GetLoadbalancerTargetPoolTargetResult'],
                 session_persistence: Optional['outputs.GetLoadbalancerTargetPoolSessionPersistenceResult'] = None):
        """
        :param _builtins.str name: Target pool name.
        :param _builtins.int target_port: Identical port number where each target listens for traffic.
        :param Sequence['GetLoadbalancerTargetPoolTargetArgs'] targets: List of all targets which will be used in the pool. Limited to 1000.
        :param 'GetLoadbalancerTargetPoolSessionPersistenceArgs' session_persistence: Here you can setup various session persistence options, so far only "`use_source_ip_address`" is supported.
        """
        pulumi.set(__self__, "active_health_check", active_health_check)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "target_port", target_port)
        pulumi.set(__self__, "targets", targets)
        if session_persistence is not None:
            pulumi.set(__self__, "session_persistence", session_persistence)

    @_builtins.property
    @pulumi.getter(name="activeHealthCheck")
    def active_health_check(self) -> 'outputs.GetLoadbalancerTargetPoolActiveHealthCheckResult':
        return pulumi.get(self, "active_health_check")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Target pool name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="targetPort")
    def target_port(self) -> _builtins.int:
        """
        Identical port number where each target listens for traffic.
        """
        return pulumi.get(self, "target_port")

    @_builtins.property
    @pulumi.getter
    def targets(self) -> Sequence['outputs.GetLoadbalancerTargetPoolTargetResult']:
        """
        List of all targets which will be used in the pool. Limited to 1000.
        """
        return pulumi.get(self, "targets")

    @_builtins.property
    @pulumi.getter(name="sessionPersistence")
    def session_persistence(self) -> Optional['outputs.GetLoadbalancerTargetPoolSessionPersistenceResult']:
        """
        Here you can setup various session persistence options, so far only "`use_source_ip_address`" is supported.
        """
        return pulumi.get(self, "session_persistence")


@pulumi.output_type
class GetLoadbalancerTargetPoolActiveHealthCheckResult(dict):
    def __init__(__self__, *,
                 healthy_threshold: _builtins.int,
                 interval: _builtins.str,
                 interval_jitter: _builtins.str,
                 timeout: _builtins.str,
                 unhealthy_threshold: _builtins.int):
        """
        :param _builtins.int healthy_threshold: Healthy threshold of the health checking.
        :param _builtins.str interval: Interval duration of health checking in seconds.
        :param _builtins.str interval_jitter: Interval duration threshold of the health checking in seconds.
        :param _builtins.str timeout: Active health checking timeout duration in seconds.
        :param _builtins.int unhealthy_threshold: Unhealthy threshold of the health checking.
        """
        pulumi.set(__self__, "healthy_threshold", healthy_threshold)
        pulumi.set(__self__, "interval", interval)
        pulumi.set(__self__, "interval_jitter", interval_jitter)
        pulumi.set(__self__, "timeout", timeout)
        pulumi.set(__self__, "unhealthy_threshold", unhealthy_threshold)

    @_builtins.property
    @pulumi.getter(name="healthyThreshold")
    def healthy_threshold(self) -> _builtins.int:
        """
        Healthy threshold of the health checking.
        """
        return pulumi.get(self, "healthy_threshold")

    @_builtins.property
    @pulumi.getter
    def interval(self) -> _builtins.str:
        """
        Interval duration of health checking in seconds.
        """
        return pulumi.get(self, "interval")

    @_builtins.property
    @pulumi.getter(name="intervalJitter")
    def interval_jitter(self) -> _builtins.str:
        """
        Interval duration threshold of the health checking in seconds.
        """
        return pulumi.get(self, "interval_jitter")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> _builtins.str:
        """
        Active health checking timeout duration in seconds.
        """
        return pulumi.get(self, "timeout")

    @_builtins.property
    @pulumi.getter(name="unhealthyThreshold")
    def unhealthy_threshold(self) -> _builtins.int:
        """
        Unhealthy threshold of the health checking.
        """
        return pulumi.get(self, "unhealthy_threshold")


@pulumi.output_type
class GetLoadbalancerTargetPoolSessionPersistenceResult(dict):
    def __init__(__self__, *,
                 use_source_ip_address: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool use_source_ip_address: If true then all connections from one source IP address are redirected to the same target. This setting changes the load balancing algorithm to Maglev.
        """
        if use_source_ip_address is not None:
            pulumi.set(__self__, "use_source_ip_address", use_source_ip_address)

    @_builtins.property
    @pulumi.getter(name="useSourceIpAddress")
    def use_source_ip_address(self) -> Optional[_builtins.bool]:
        """
        If true then all connections from one source IP address are redirected to the same target. This setting changes the load balancing algorithm to Maglev.
        """
        return pulumi.get(self, "use_source_ip_address")


@pulumi.output_type
class GetLoadbalancerTargetPoolTargetResult(dict):
    def __init__(__self__, *,
                 display_name: _builtins.str,
                 ip: _builtins.str):
        """
        :param _builtins.str display_name: Target display name
        :param _builtins.str ip: Target IP
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "ip", ip)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        Target display name
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def ip(self) -> _builtins.str:
        """
        Target IP
        """
        return pulumi.get(self, "ip")


@pulumi.output_type
class GetLogmeInstanceParametersResult(dict):
    def __init__(__self__, *,
                 enable_monitoring: _builtins.bool,
                 fluentd_tcp: _builtins.int,
                 fluentd_tls: _builtins.int,
                 fluentd_tls_ciphers: _builtins.str,
                 fluentd_tls_max_version: _builtins.str,
                 fluentd_tls_min_version: _builtins.str,
                 fluentd_tls_version: _builtins.str,
                 fluentd_udp: _builtins.int,
                 graphite: _builtins.str,
                 ism_deletion_after: _builtins.str,
                 ism_jitter: _builtins.float,
                 ism_job_interval: _builtins.int,
                 java_heapspace: _builtins.int,
                 java_maxmetaspace: _builtins.int,
                 max_disk_threshold: _builtins.int,
                 metrics_frequency: _builtins.int,
                 metrics_prefix: _builtins.str,
                 monitoring_instance_id: _builtins.str,
                 opensearch_tls_ciphers: Sequence[_builtins.str],
                 opensearch_tls_protocols: Sequence[_builtins.str],
                 sgw_acl: _builtins.str,
                 syslogs: Sequence[_builtins.str]):
        """
        :param _builtins.bool enable_monitoring: Enable monitoring.
        :param _builtins.str graphite: If set, monitoring with Graphite will be enabled. Expects the host and port where the Graphite metrics should be sent to (host:port).
        :param _builtins.str ism_deletion_after: Combination of an integer and a timerange when an index will be considered "old" and can be deleted. Possible values for the timerange are `s`, `m`, `h` and `d`.
        :param _builtins.int ism_job_interval: Jitter of the execution time.
        :param _builtins.int java_heapspace: The amount of memory (in MB) allocated as heap by the JVM for OpenSearch.
        :param _builtins.int java_maxmetaspace: The amount of memory (in MB) used by the JVM to store metadata for OpenSearch.
        :param _builtins.int max_disk_threshold: The maximum disk threshold in MB. If the disk usage exceeds this threshold, the instance will be stopped.
        :param _builtins.int metrics_frequency: The frequency in seconds at which metrics are emitted (in seconds).
        :param _builtins.str metrics_prefix: The prefix for the metrics. Could be useful when using Graphite monitoring to prefix the metrics with a certain value, like an API key.
        :param _builtins.str monitoring_instance_id: The ID of the STACKIT monitoring instance.
        :param _builtins.str sgw_acl: Comma separated list of IP networks in CIDR notation which are allowed to access this instance.
        :param Sequence[_builtins.str] syslogs: List of syslog servers to send logs to.
        """
        pulumi.set(__self__, "enable_monitoring", enable_monitoring)
        pulumi.set(__self__, "fluentd_tcp", fluentd_tcp)
        pulumi.set(__self__, "fluentd_tls", fluentd_tls)
        pulumi.set(__self__, "fluentd_tls_ciphers", fluentd_tls_ciphers)
        pulumi.set(__self__, "fluentd_tls_max_version", fluentd_tls_max_version)
        pulumi.set(__self__, "fluentd_tls_min_version", fluentd_tls_min_version)
        pulumi.set(__self__, "fluentd_tls_version", fluentd_tls_version)
        pulumi.set(__self__, "fluentd_udp", fluentd_udp)
        pulumi.set(__self__, "graphite", graphite)
        pulumi.set(__self__, "ism_deletion_after", ism_deletion_after)
        pulumi.set(__self__, "ism_jitter", ism_jitter)
        pulumi.set(__self__, "ism_job_interval", ism_job_interval)
        pulumi.set(__self__, "java_heapspace", java_heapspace)
        pulumi.set(__self__, "java_maxmetaspace", java_maxmetaspace)
        pulumi.set(__self__, "max_disk_threshold", max_disk_threshold)
        pulumi.set(__self__, "metrics_frequency", metrics_frequency)
        pulumi.set(__self__, "metrics_prefix", metrics_prefix)
        pulumi.set(__self__, "monitoring_instance_id", monitoring_instance_id)
        pulumi.set(__self__, "opensearch_tls_ciphers", opensearch_tls_ciphers)
        pulumi.set(__self__, "opensearch_tls_protocols", opensearch_tls_protocols)
        pulumi.set(__self__, "sgw_acl", sgw_acl)
        pulumi.set(__self__, "syslogs", syslogs)

    @_builtins.property
    @pulumi.getter(name="enableMonitoring")
    def enable_monitoring(self) -> _builtins.bool:
        """
        Enable monitoring.
        """
        return pulumi.get(self, "enable_monitoring")

    @_builtins.property
    @pulumi.getter(name="fluentdTcp")
    def fluentd_tcp(self) -> _builtins.int:
        return pulumi.get(self, "fluentd_tcp")

    @_builtins.property
    @pulumi.getter(name="fluentdTls")
    def fluentd_tls(self) -> _builtins.int:
        return pulumi.get(self, "fluentd_tls")

    @_builtins.property
    @pulumi.getter(name="fluentdTlsCiphers")
    def fluentd_tls_ciphers(self) -> _builtins.str:
        return pulumi.get(self, "fluentd_tls_ciphers")

    @_builtins.property
    @pulumi.getter(name="fluentdTlsMaxVersion")
    def fluentd_tls_max_version(self) -> _builtins.str:
        return pulumi.get(self, "fluentd_tls_max_version")

    @_builtins.property
    @pulumi.getter(name="fluentdTlsMinVersion")
    def fluentd_tls_min_version(self) -> _builtins.str:
        return pulumi.get(self, "fluentd_tls_min_version")

    @_builtins.property
    @pulumi.getter(name="fluentdTlsVersion")
    def fluentd_tls_version(self) -> _builtins.str:
        return pulumi.get(self, "fluentd_tls_version")

    @_builtins.property
    @pulumi.getter(name="fluentdUdp")
    def fluentd_udp(self) -> _builtins.int:
        return pulumi.get(self, "fluentd_udp")

    @_builtins.property
    @pulumi.getter
    def graphite(self) -> _builtins.str:
        """
        If set, monitoring with Graphite will be enabled. Expects the host and port where the Graphite metrics should be sent to (host:port).
        """
        return pulumi.get(self, "graphite")

    @_builtins.property
    @pulumi.getter(name="ismDeletionAfter")
    def ism_deletion_after(self) -> _builtins.str:
        """
        Combination of an integer and a timerange when an index will be considered "old" and can be deleted. Possible values for the timerange are `s`, `m`, `h` and `d`.
        """
        return pulumi.get(self, "ism_deletion_after")

    @_builtins.property
    @pulumi.getter(name="ismJitter")
    def ism_jitter(self) -> _builtins.float:
        return pulumi.get(self, "ism_jitter")

    @_builtins.property
    @pulumi.getter(name="ismJobInterval")
    def ism_job_interval(self) -> _builtins.int:
        """
        Jitter of the execution time.
        """
        return pulumi.get(self, "ism_job_interval")

    @_builtins.property
    @pulumi.getter(name="javaHeapspace")
    def java_heapspace(self) -> _builtins.int:
        """
        The amount of memory (in MB) allocated as heap by the JVM for OpenSearch.
        """
        return pulumi.get(self, "java_heapspace")

    @_builtins.property
    @pulumi.getter(name="javaMaxmetaspace")
    def java_maxmetaspace(self) -> _builtins.int:
        """
        The amount of memory (in MB) used by the JVM to store metadata for OpenSearch.
        """
        return pulumi.get(self, "java_maxmetaspace")

    @_builtins.property
    @pulumi.getter(name="maxDiskThreshold")
    def max_disk_threshold(self) -> _builtins.int:
        """
        The maximum disk threshold in MB. If the disk usage exceeds this threshold, the instance will be stopped.
        """
        return pulumi.get(self, "max_disk_threshold")

    @_builtins.property
    @pulumi.getter(name="metricsFrequency")
    def metrics_frequency(self) -> _builtins.int:
        """
        The frequency in seconds at which metrics are emitted (in seconds).
        """
        return pulumi.get(self, "metrics_frequency")

    @_builtins.property
    @pulumi.getter(name="metricsPrefix")
    def metrics_prefix(self) -> _builtins.str:
        """
        The prefix for the metrics. Could be useful when using Graphite monitoring to prefix the metrics with a certain value, like an API key.
        """
        return pulumi.get(self, "metrics_prefix")

    @_builtins.property
    @pulumi.getter(name="monitoringInstanceId")
    def monitoring_instance_id(self) -> _builtins.str:
        """
        The ID of the STACKIT monitoring instance.
        """
        return pulumi.get(self, "monitoring_instance_id")

    @_builtins.property
    @pulumi.getter(name="opensearchTlsCiphers")
    def opensearch_tls_ciphers(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "opensearch_tls_ciphers")

    @_builtins.property
    @pulumi.getter(name="opensearchTlsProtocols")
    def opensearch_tls_protocols(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "opensearch_tls_protocols")

    @_builtins.property
    @pulumi.getter(name="sgwAcl")
    def sgw_acl(self) -> _builtins.str:
        """
        Comma separated list of IP networks in CIDR notation which are allowed to access this instance.
        """
        return pulumi.get(self, "sgw_acl")

    @_builtins.property
    @pulumi.getter
    def syslogs(self) -> Sequence[_builtins.str]:
        """
        List of syslog servers to send logs to.
        """
        return pulumi.get(self, "syslogs")


@pulumi.output_type
class GetMariadbInstanceParametersResult(dict):
    def __init__(__self__, *,
                 enable_monitoring: _builtins.bool,
                 graphite: _builtins.str,
                 max_disk_threshold: _builtins.int,
                 metrics_frequency: _builtins.int,
                 metrics_prefix: _builtins.str,
                 monitoring_instance_id: _builtins.str,
                 sgw_acl: _builtins.str,
                 syslogs: Sequence[_builtins.str]):
        """
        :param _builtins.bool enable_monitoring: Enable monitoring.
        :param _builtins.int max_disk_threshold: The maximum disk threshold in MB. If the disk usage exceeds this threshold, the instance will be stopped.
        :param _builtins.int metrics_frequency: The frequency in seconds at which metrics are emitted.
        :param _builtins.str metrics_prefix: The prefix for the metrics. Could be useful when using Graphite monitoring to prefix the metrics with a certain value, like an API key
        :param _builtins.str monitoring_instance_id: The ID of the STACKIT monitoring instance.
        :param _builtins.str sgw_acl: Comma separated list of IP networks in CIDR notation which are allowed to access this instance.
        :param Sequence[_builtins.str] syslogs: List of syslog servers to send logs to.
        """
        pulumi.set(__self__, "enable_monitoring", enable_monitoring)
        pulumi.set(__self__, "graphite", graphite)
        pulumi.set(__self__, "max_disk_threshold", max_disk_threshold)
        pulumi.set(__self__, "metrics_frequency", metrics_frequency)
        pulumi.set(__self__, "metrics_prefix", metrics_prefix)
        pulumi.set(__self__, "monitoring_instance_id", monitoring_instance_id)
        pulumi.set(__self__, "sgw_acl", sgw_acl)
        pulumi.set(__self__, "syslogs", syslogs)

    @_builtins.property
    @pulumi.getter(name="enableMonitoring")
    def enable_monitoring(self) -> _builtins.bool:
        """
        Enable monitoring.
        """
        return pulumi.get(self, "enable_monitoring")

    @_builtins.property
    @pulumi.getter
    def graphite(self) -> _builtins.str:
        return pulumi.get(self, "graphite")

    @_builtins.property
    @pulumi.getter(name="maxDiskThreshold")
    def max_disk_threshold(self) -> _builtins.int:
        """
        The maximum disk threshold in MB. If the disk usage exceeds this threshold, the instance will be stopped.
        """
        return pulumi.get(self, "max_disk_threshold")

    @_builtins.property
    @pulumi.getter(name="metricsFrequency")
    def metrics_frequency(self) -> _builtins.int:
        """
        The frequency in seconds at which metrics are emitted.
        """
        return pulumi.get(self, "metrics_frequency")

    @_builtins.property
    @pulumi.getter(name="metricsPrefix")
    def metrics_prefix(self) -> _builtins.str:
        """
        The prefix for the metrics. Could be useful when using Graphite monitoring to prefix the metrics with a certain value, like an API key
        """
        return pulumi.get(self, "metrics_prefix")

    @_builtins.property
    @pulumi.getter(name="monitoringInstanceId")
    def monitoring_instance_id(self) -> _builtins.str:
        """
        The ID of the STACKIT monitoring instance.
        """
        return pulumi.get(self, "monitoring_instance_id")

    @_builtins.property
    @pulumi.getter(name="sgwAcl")
    def sgw_acl(self) -> _builtins.str:
        """
        Comma separated list of IP networks in CIDR notation which are allowed to access this instance.
        """
        return pulumi.get(self, "sgw_acl")

    @_builtins.property
    @pulumi.getter
    def syslogs(self) -> Sequence[_builtins.str]:
        """
        List of syslog servers to send logs to.
        """
        return pulumi.get(self, "syslogs")


@pulumi.output_type
class GetMongodbflexInstanceFlavorResult(dict):
    def __init__(__self__, *,
                 cpu: _builtins.int,
                 description: _builtins.str,
                 id: _builtins.str,
                 ram: _builtins.int):
        pulumi.set(__self__, "cpu", cpu)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ram", ram)

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> _builtins.int:
        return pulumi.get(self, "cpu")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ram(self) -> _builtins.int:
        return pulumi.get(self, "ram")


@pulumi.output_type
class GetMongodbflexInstanceOptionsResult(dict):
    def __init__(__self__, *,
                 daily_snapshot_retention_days: _builtins.int,
                 monthly_snapshot_retention_months: _builtins.int,
                 point_in_time_window_hours: _builtins.int,
                 snapshot_retention_days: _builtins.int,
                 type: _builtins.str,
                 weekly_snapshot_retention_weeks: _builtins.int):
        """
        :param _builtins.int daily_snapshot_retention_days: The number of days that daily backups will be retained.
        :param _builtins.int monthly_snapshot_retention_months: The number of months that monthly backups will be retained.
        :param _builtins.int point_in_time_window_hours: The number of hours back in time the point-in-time recovery feature will be able to recover.
        :param _builtins.int snapshot_retention_days: The number of days that continuous backups (controlled via the `backup_schedule`) will be retained.
        :param _builtins.str type: Type of the MongoDB Flex instance.
        :param _builtins.int weekly_snapshot_retention_weeks: The number of weeks that weekly backups will be retained.
        """
        pulumi.set(__self__, "daily_snapshot_retention_days", daily_snapshot_retention_days)
        pulumi.set(__self__, "monthly_snapshot_retention_months", monthly_snapshot_retention_months)
        pulumi.set(__self__, "point_in_time_window_hours", point_in_time_window_hours)
        pulumi.set(__self__, "snapshot_retention_days", snapshot_retention_days)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "weekly_snapshot_retention_weeks", weekly_snapshot_retention_weeks)

    @_builtins.property
    @pulumi.getter(name="dailySnapshotRetentionDays")
    def daily_snapshot_retention_days(self) -> _builtins.int:
        """
        The number of days that daily backups will be retained.
        """
        return pulumi.get(self, "daily_snapshot_retention_days")

    @_builtins.property
    @pulumi.getter(name="monthlySnapshotRetentionMonths")
    def monthly_snapshot_retention_months(self) -> _builtins.int:
        """
        The number of months that monthly backups will be retained.
        """
        return pulumi.get(self, "monthly_snapshot_retention_months")

    @_builtins.property
    @pulumi.getter(name="pointInTimeWindowHours")
    def point_in_time_window_hours(self) -> _builtins.int:
        """
        The number of hours back in time the point-in-time recovery feature will be able to recover.
        """
        return pulumi.get(self, "point_in_time_window_hours")

    @_builtins.property
    @pulumi.getter(name="snapshotRetentionDays")
    def snapshot_retention_days(self) -> _builtins.int:
        """
        The number of days that continuous backups (controlled via the `backup_schedule`) will be retained.
        """
        return pulumi.get(self, "snapshot_retention_days")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of the MongoDB Flex instance.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="weeklySnapshotRetentionWeeks")
    def weekly_snapshot_retention_weeks(self) -> _builtins.int:
        """
        The number of weeks that weekly backups will be retained.
        """
        return pulumi.get(self, "weekly_snapshot_retention_weeks")


@pulumi.output_type
class GetMongodbflexInstanceStorageResult(dict):
    def __init__(__self__, *,
                 class_: _builtins.str,
                 size: _builtins.int):
        pulumi.set(__self__, "class_", class_)
        pulumi.set(__self__, "size", size)

    @_builtins.property
    @pulumi.getter(name="class")
    def class_(self) -> _builtins.str:
        return pulumi.get(self, "class_")

    @_builtins.property
    @pulumi.getter
    def size(self) -> _builtins.int:
        return pulumi.get(self, "size")


@pulumi.output_type
class GetNetworkAreaNetworkRangeResult(dict):
    def __init__(__self__, *,
                 network_range_id: _builtins.str,
                 prefix: _builtins.str):
        pulumi.set(__self__, "network_range_id", network_range_id)
        pulumi.set(__self__, "prefix", prefix)

    @_builtins.property
    @pulumi.getter(name="networkRangeId")
    def network_range_id(self) -> _builtins.str:
        return pulumi.get(self, "network_range_id")

    @_builtins.property
    @pulumi.getter
    def prefix(self) -> _builtins.str:
        return pulumi.get(self, "prefix")


@pulumi.output_type
class GetObservabilityAlertgroupRuleResult(dict):
    def __init__(__self__, *,
                 alert: _builtins.str,
                 annotations: Mapping[str, _builtins.str],
                 expression: _builtins.str,
                 for_: _builtins.str,
                 labels: Mapping[str, _builtins.str]):
        """
        :param _builtins.str alert: The name of the alert rule. Is the identifier and must be unique in the group.
        :param Mapping[str, _builtins.str] annotations: A map of key:value. Annotations to add or overwrite for each alert
        :param _builtins.str expression: The PromQL expression to evaluate. Every evaluation cycle this is evaluated at the current time, and all resultant time series become pending/firing alerts.
        :param _builtins.str for_: Alerts are considered firing once they have been returned for this long. Alerts which have not yet fired for long enough are considered pending. Default is 0s
        :param Mapping[str, _builtins.str] labels: A map of key:value. Labels to add or overwrite for each alert
        """
        pulumi.set(__self__, "alert", alert)
        pulumi.set(__self__, "annotations", annotations)
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "for_", for_)
        pulumi.set(__self__, "labels", labels)

    @_builtins.property
    @pulumi.getter
    def alert(self) -> _builtins.str:
        """
        The name of the alert rule. Is the identifier and must be unique in the group.
        """
        return pulumi.get(self, "alert")

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Mapping[str, _builtins.str]:
        """
        A map of key:value. Annotations to add or overwrite for each alert
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        """
        The PromQL expression to evaluate. Every evaluation cycle this is evaluated at the current time, and all resultant time series become pending/firing alerts.
        """
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter(name="for")
    def for_(self) -> _builtins.str:
        """
        Alerts are considered firing once they have been returned for this long. Alerts which have not yet fired for long enough are considered pending. Default is 0s
        """
        return pulumi.get(self, "for_")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        """
        A map of key:value. Labels to add or overwrite for each alert
        """
        return pulumi.get(self, "labels")


@pulumi.output_type
class GetObservabilityInstanceAlertConfigResult(dict):
    def __init__(__self__, *,
                 global_: 'outputs.GetObservabilityInstanceAlertConfigGlobalResult',
                 receivers: Sequence['outputs.GetObservabilityInstanceAlertConfigReceiverResult'],
                 route: 'outputs.GetObservabilityInstanceAlertConfigRouteResult'):
        """
        :param 'GetObservabilityInstanceAlertConfigGlobalArgs' global_: Global configuration for the alerts.
        :param Sequence['GetObservabilityInstanceAlertConfigReceiverArgs'] receivers: List of alert receivers.
        :param 'GetObservabilityInstanceAlertConfigRouteArgs' route: The route for the alert.
        """
        pulumi.set(__self__, "global_", global_)
        pulumi.set(__self__, "receivers", receivers)
        pulumi.set(__self__, "route", route)

    @_builtins.property
    @pulumi.getter(name="global")
    def global_(self) -> 'outputs.GetObservabilityInstanceAlertConfigGlobalResult':
        """
        Global configuration for the alerts.
        """
        return pulumi.get(self, "global_")

    @_builtins.property
    @pulumi.getter
    def receivers(self) -> Sequence['outputs.GetObservabilityInstanceAlertConfigReceiverResult']:
        """
        List of alert receivers.
        """
        return pulumi.get(self, "receivers")

    @_builtins.property
    @pulumi.getter
    def route(self) -> 'outputs.GetObservabilityInstanceAlertConfigRouteResult':
        """
        The route for the alert.
        """
        return pulumi.get(self, "route")


@pulumi.output_type
class GetObservabilityInstanceAlertConfigGlobalResult(dict):
    def __init__(__self__, *,
                 opsgenie_api_key: _builtins.str,
                 opsgenie_api_url: _builtins.str,
                 resolve_timeout: _builtins.str,
                 smtp_auth_identity: _builtins.str,
                 smtp_auth_password: _builtins.str,
                 smtp_auth_username: _builtins.str,
                 smtp_from: _builtins.str,
                 smtp_smart_host: _builtins.str):
        """
        :param _builtins.str opsgenie_api_key: The API key for OpsGenie.
        :param _builtins.str opsgenie_api_url: The host to send OpsGenie API requests to. Must be a valid URL
        :param _builtins.str resolve_timeout: The default value used by alertmanager if the alert does not include EndsAt. After this time passes, it can declare the alert as resolved if it has not been updated. This has no impact on alerts from Prometheus, as they always include EndsAt.
        :param _builtins.str smtp_auth_identity: SMTP authentication information. Must be a valid email address
        :param _builtins.str smtp_auth_password: SMTP Auth using LOGIN and PLAIN.
        :param _builtins.str smtp_auth_username: SMTP Auth using CRAM-MD5, LOGIN and PLAIN. If empty, Alertmanager doesn't authenticate to the SMTP server.
        :param _builtins.str smtp_from: The default SMTP From header field. Must be a valid email address
        :param _builtins.str smtp_smart_host: The default SMTP smarthost used for sending emails, including port number. Port number usually is 25, or 587 for SMTP over TLS (sometimes referred to as STARTTLS).
        """
        pulumi.set(__self__, "opsgenie_api_key", opsgenie_api_key)
        pulumi.set(__self__, "opsgenie_api_url", opsgenie_api_url)
        pulumi.set(__self__, "resolve_timeout", resolve_timeout)
        pulumi.set(__self__, "smtp_auth_identity", smtp_auth_identity)
        pulumi.set(__self__, "smtp_auth_password", smtp_auth_password)
        pulumi.set(__self__, "smtp_auth_username", smtp_auth_username)
        pulumi.set(__self__, "smtp_from", smtp_from)
        pulumi.set(__self__, "smtp_smart_host", smtp_smart_host)

    @_builtins.property
    @pulumi.getter(name="opsgenieApiKey")
    def opsgenie_api_key(self) -> _builtins.str:
        """
        The API key for OpsGenie.
        """
        return pulumi.get(self, "opsgenie_api_key")

    @_builtins.property
    @pulumi.getter(name="opsgenieApiUrl")
    def opsgenie_api_url(self) -> _builtins.str:
        """
        The host to send OpsGenie API requests to. Must be a valid URL
        """
        return pulumi.get(self, "opsgenie_api_url")

    @_builtins.property
    @pulumi.getter(name="resolveTimeout")
    def resolve_timeout(self) -> _builtins.str:
        """
        The default value used by alertmanager if the alert does not include EndsAt. After this time passes, it can declare the alert as resolved if it has not been updated. This has no impact on alerts from Prometheus, as they always include EndsAt.
        """
        return pulumi.get(self, "resolve_timeout")

    @_builtins.property
    @pulumi.getter(name="smtpAuthIdentity")
    def smtp_auth_identity(self) -> _builtins.str:
        """
        SMTP authentication information. Must be a valid email address
        """
        return pulumi.get(self, "smtp_auth_identity")

    @_builtins.property
    @pulumi.getter(name="smtpAuthPassword")
    def smtp_auth_password(self) -> _builtins.str:
        """
        SMTP Auth using LOGIN and PLAIN.
        """
        return pulumi.get(self, "smtp_auth_password")

    @_builtins.property
    @pulumi.getter(name="smtpAuthUsername")
    def smtp_auth_username(self) -> _builtins.str:
        """
        SMTP Auth using CRAM-MD5, LOGIN and PLAIN. If empty, Alertmanager doesn't authenticate to the SMTP server.
        """
        return pulumi.get(self, "smtp_auth_username")

    @_builtins.property
    @pulumi.getter(name="smtpFrom")
    def smtp_from(self) -> _builtins.str:
        """
        The default SMTP From header field. Must be a valid email address
        """
        return pulumi.get(self, "smtp_from")

    @_builtins.property
    @pulumi.getter(name="smtpSmartHost")
    def smtp_smart_host(self) -> _builtins.str:
        """
        The default SMTP smarthost used for sending emails, including port number. Port number usually is 25, or 587 for SMTP over TLS (sometimes referred to as STARTTLS).
        """
        return pulumi.get(self, "smtp_smart_host")


@pulumi.output_type
class GetObservabilityInstanceAlertConfigReceiverResult(dict):
    def __init__(__self__, *,
                 email_configs: Sequence['outputs.GetObservabilityInstanceAlertConfigReceiverEmailConfigResult'],
                 name: _builtins.str,
                 opsgenie_configs: Sequence['outputs.GetObservabilityInstanceAlertConfigReceiverOpsgenieConfigResult'],
                 webhooks_configs: Sequence['outputs.GetObservabilityInstanceAlertConfigReceiverWebhooksConfigResult']):
        """
        :param Sequence['GetObservabilityInstanceAlertConfigReceiverEmailConfigArgs'] email_configs: List of email configurations.
        :param _builtins.str name: Name of the receiver.
        :param Sequence['GetObservabilityInstanceAlertConfigReceiverOpsgenieConfigArgs'] opsgenie_configs: List of OpsGenie configurations.
        :param Sequence['GetObservabilityInstanceAlertConfigReceiverWebhooksConfigArgs'] webhooks_configs: List of Webhooks configurations.
        """
        pulumi.set(__self__, "email_configs", email_configs)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "opsgenie_configs", opsgenie_configs)
        pulumi.set(__self__, "webhooks_configs", webhooks_configs)

    @_builtins.property
    @pulumi.getter(name="emailConfigs")
    def email_configs(self) -> Sequence['outputs.GetObservabilityInstanceAlertConfigReceiverEmailConfigResult']:
        """
        List of email configurations.
        """
        return pulumi.get(self, "email_configs")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the receiver.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="opsgenieConfigs")
    def opsgenie_configs(self) -> Sequence['outputs.GetObservabilityInstanceAlertConfigReceiverOpsgenieConfigResult']:
        """
        List of OpsGenie configurations.
        """
        return pulumi.get(self, "opsgenie_configs")

    @_builtins.property
    @pulumi.getter(name="webhooksConfigs")
    def webhooks_configs(self) -> Sequence['outputs.GetObservabilityInstanceAlertConfigReceiverWebhooksConfigResult']:
        """
        List of Webhooks configurations.
        """
        return pulumi.get(self, "webhooks_configs")


@pulumi.output_type
class GetObservabilityInstanceAlertConfigReceiverEmailConfigResult(dict):
    def __init__(__self__, *,
                 auth_identity: _builtins.str,
                 auth_password: _builtins.str,
                 auth_username: _builtins.str,
                 from_: _builtins.str,
                 smart_host: _builtins.str,
                 to: _builtins.str):
        """
        :param _builtins.str auth_identity: SMTP authentication information. Must be a valid email address
        :param _builtins.str auth_password: SMTP authentication password.
        :param _builtins.str auth_username: SMTP authentication username.
        :param _builtins.str from_: The sender email address. Must be a valid email address
        :param _builtins.str smart_host: The SMTP host through which emails are sent.
        :param _builtins.str to: The email address to send notifications to. Must be a valid email address
        """
        pulumi.set(__self__, "auth_identity", auth_identity)
        pulumi.set(__self__, "auth_password", auth_password)
        pulumi.set(__self__, "auth_username", auth_username)
        pulumi.set(__self__, "from_", from_)
        pulumi.set(__self__, "smart_host", smart_host)
        pulumi.set(__self__, "to", to)

    @_builtins.property
    @pulumi.getter(name="authIdentity")
    def auth_identity(self) -> _builtins.str:
        """
        SMTP authentication information. Must be a valid email address
        """
        return pulumi.get(self, "auth_identity")

    @_builtins.property
    @pulumi.getter(name="authPassword")
    def auth_password(self) -> _builtins.str:
        """
        SMTP authentication password.
        """
        return pulumi.get(self, "auth_password")

    @_builtins.property
    @pulumi.getter(name="authUsername")
    def auth_username(self) -> _builtins.str:
        """
        SMTP authentication username.
        """
        return pulumi.get(self, "auth_username")

    @_builtins.property
    @pulumi.getter(name="from")
    def from_(self) -> _builtins.str:
        """
        The sender email address. Must be a valid email address
        """
        return pulumi.get(self, "from_")

    @_builtins.property
    @pulumi.getter(name="smartHost")
    def smart_host(self) -> _builtins.str:
        """
        The SMTP host through which emails are sent.
        """
        return pulumi.get(self, "smart_host")

    @_builtins.property
    @pulumi.getter
    def to(self) -> _builtins.str:
        """
        The email address to send notifications to. Must be a valid email address
        """
        return pulumi.get(self, "to")


@pulumi.output_type
class GetObservabilityInstanceAlertConfigReceiverOpsgenieConfigResult(dict):
    def __init__(__self__, *,
                 api_key: _builtins.str,
                 api_url: _builtins.str,
                 tags: _builtins.str):
        """
        :param _builtins.str api_key: The API key for OpsGenie.
        :param _builtins.str api_url: The host to send OpsGenie API requests to. Must be a valid URL
        :param _builtins.str tags: Comma separated list of tags attached to the notifications.
        """
        pulumi.set(__self__, "api_key", api_key)
        pulumi.set(__self__, "api_url", api_url)
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> _builtins.str:
        """
        The API key for OpsGenie.
        """
        return pulumi.get(self, "api_key")

    @_builtins.property
    @pulumi.getter(name="apiUrl")
    def api_url(self) -> _builtins.str:
        """
        The host to send OpsGenie API requests to. Must be a valid URL
        """
        return pulumi.get(self, "api_url")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> _builtins.str:
        """
        Comma separated list of tags attached to the notifications.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetObservabilityInstanceAlertConfigReceiverWebhooksConfigResult(dict):
    def __init__(__self__, *,
                 ms_teams: _builtins.bool,
                 url: _builtins.str):
        """
        :param _builtins.bool ms_teams: Microsoft Teams webhooks require special handling, set this to true if the webhook is for Microsoft Teams.
        :param _builtins.str url: The endpoint to send HTTP POST requests to. Must be a valid URL
        """
        pulumi.set(__self__, "ms_teams", ms_teams)
        pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter(name="msTeams")
    def ms_teams(self) -> _builtins.bool:
        """
        Microsoft Teams webhooks require special handling, set this to true if the webhook is for Microsoft Teams.
        """
        return pulumi.get(self, "ms_teams")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        The endpoint to send HTTP POST requests to. Must be a valid URL
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class GetObservabilityInstanceAlertConfigRouteResult(dict):
    def __init__(__self__, *,
                 group_bies: Sequence[_builtins.str],
                 group_interval: _builtins.str,
                 group_wait: _builtins.str,
                 match: Mapping[str, _builtins.str],
                 match_regex: Mapping[str, _builtins.str],
                 receiver: _builtins.str,
                 repeat_interval: _builtins.str,
                 routes: Sequence['outputs.GetObservabilityInstanceAlertConfigRouteRouteResult']):
        """
        :param Sequence[_builtins.str] group_bies: The labels by which incoming alerts are grouped together. For example, multiple alerts coming in for cluster=A and alertname=LatencyHigh would be batched into a single group. To aggregate by all possible labels use the special value '...' as the sole label name, for example: group_by: ['...']. This effectively disables aggregation entirely, passing through all alerts as-is. This is unlikely to be what you want, unless you have a very low alert volume or your upstream notification system performs its own grouping.
        :param _builtins.str group_interval: How long to wait before sending a notification about new alerts that are added to a group of alerts for which an initial notification has already been sent. (Usually ~5m or more.)
        :param _builtins.str group_wait: How long to initially wait to send a notification for a group of alerts. Allows to wait for an inhibiting alert to arrive or collect more initial alerts for the same group. (Usually ~0s to few minutes.) .
        :param Mapping[str, _builtins.str] match: A set of equality matchers an alert has to fulfill to match the node.
        :param Mapping[str, _builtins.str] match_regex: A set of regex-matchers an alert has to fulfill to match the node.
        :param _builtins.str receiver: The name of the receiver to route the alerts to.
        :param _builtins.str repeat_interval: How long to wait before sending a notification again if it has already been sent successfully for an alert. (Usually ~3h or more).
        :param Sequence['GetObservabilityInstanceAlertConfigRouteRouteArgs'] routes: List of child routes.
        """
        pulumi.set(__self__, "group_bies", group_bies)
        pulumi.set(__self__, "group_interval", group_interval)
        pulumi.set(__self__, "group_wait", group_wait)
        pulumi.set(__self__, "match", match)
        pulumi.set(__self__, "match_regex", match_regex)
        pulumi.set(__self__, "receiver", receiver)
        pulumi.set(__self__, "repeat_interval", repeat_interval)
        pulumi.set(__self__, "routes", routes)

    @_builtins.property
    @pulumi.getter(name="groupBies")
    def group_bies(self) -> Sequence[_builtins.str]:
        """
        The labels by which incoming alerts are grouped together. For example, multiple alerts coming in for cluster=A and alertname=LatencyHigh would be batched into a single group. To aggregate by all possible labels use the special value '...' as the sole label name, for example: group_by: ['...']. This effectively disables aggregation entirely, passing through all alerts as-is. This is unlikely to be what you want, unless you have a very low alert volume or your upstream notification system performs its own grouping.
        """
        return pulumi.get(self, "group_bies")

    @_builtins.property
    @pulumi.getter(name="groupInterval")
    def group_interval(self) -> _builtins.str:
        """
        How long to wait before sending a notification about new alerts that are added to a group of alerts for which an initial notification has already been sent. (Usually ~5m or more.)
        """
        return pulumi.get(self, "group_interval")

    @_builtins.property
    @pulumi.getter(name="groupWait")
    def group_wait(self) -> _builtins.str:
        """
        How long to initially wait to send a notification for a group of alerts. Allows to wait for an inhibiting alert to arrive or collect more initial alerts for the same group. (Usually ~0s to few minutes.) .
        """
        return pulumi.get(self, "group_wait")

    @_builtins.property
    @pulumi.getter
    def match(self) -> Mapping[str, _builtins.str]:
        """
        A set of equality matchers an alert has to fulfill to match the node.
        """
        return pulumi.get(self, "match")

    @_builtins.property
    @pulumi.getter(name="matchRegex")
    def match_regex(self) -> Mapping[str, _builtins.str]:
        """
        A set of regex-matchers an alert has to fulfill to match the node.
        """
        return pulumi.get(self, "match_regex")

    @_builtins.property
    @pulumi.getter
    def receiver(self) -> _builtins.str:
        """
        The name of the receiver to route the alerts to.
        """
        return pulumi.get(self, "receiver")

    @_builtins.property
    @pulumi.getter(name="repeatInterval")
    def repeat_interval(self) -> _builtins.str:
        """
        How long to wait before sending a notification again if it has already been sent successfully for an alert. (Usually ~3h or more).
        """
        return pulumi.get(self, "repeat_interval")

    @_builtins.property
    @pulumi.getter
    def routes(self) -> Sequence['outputs.GetObservabilityInstanceAlertConfigRouteRouteResult']:
        """
        List of child routes.
        """
        return pulumi.get(self, "routes")


@pulumi.output_type
class GetObservabilityInstanceAlertConfigRouteRouteResult(dict):
    def __init__(__self__, *,
                 group_bies: Sequence[_builtins.str],
                 group_interval: _builtins.str,
                 group_wait: _builtins.str,
                 match: Mapping[str, _builtins.str],
                 match_regex: Mapping[str, _builtins.str],
                 receiver: _builtins.str,
                 repeat_interval: _builtins.str):
        """
        :param Sequence[_builtins.str] group_bies: The labels by which incoming alerts are grouped together. For example, multiple alerts coming in for cluster=A and alertname=LatencyHigh would be batched into a single group. To aggregate by all possible labels use the special value '...' as the sole label name, for example: group_by: ['...']. This effectively disables aggregation entirely, passing through all alerts as-is. This is unlikely to be what you want, unless you have a very low alert volume or your upstream notification system performs its own grouping.
        :param _builtins.str group_interval: How long to wait before sending a notification about new alerts that are added to a group of alerts for which an initial notification has already been sent. (Usually ~5m or more.)
        :param _builtins.str group_wait: How long to initially wait to send a notification for a group of alerts. Allows to wait for an inhibiting alert to arrive or collect more initial alerts for the same group. (Usually ~0s to few minutes.)
        :param Mapping[str, _builtins.str] match: A set of equality matchers an alert has to fulfill to match the node.
        :param Mapping[str, _builtins.str] match_regex: A set of regex-matchers an alert has to fulfill to match the node.
        :param _builtins.str receiver: The name of the receiver to route the alerts to.
        :param _builtins.str repeat_interval: How long to wait before sending a notification again if it has already been sent successfully for an alert. (Usually ~3h or more).
        """
        pulumi.set(__self__, "group_bies", group_bies)
        pulumi.set(__self__, "group_interval", group_interval)
        pulumi.set(__self__, "group_wait", group_wait)
        pulumi.set(__self__, "match", match)
        pulumi.set(__self__, "match_regex", match_regex)
        pulumi.set(__self__, "receiver", receiver)
        pulumi.set(__self__, "repeat_interval", repeat_interval)

    @_builtins.property
    @pulumi.getter(name="groupBies")
    def group_bies(self) -> Sequence[_builtins.str]:
        """
        The labels by which incoming alerts are grouped together. For example, multiple alerts coming in for cluster=A and alertname=LatencyHigh would be batched into a single group. To aggregate by all possible labels use the special value '...' as the sole label name, for example: group_by: ['...']. This effectively disables aggregation entirely, passing through all alerts as-is. This is unlikely to be what you want, unless you have a very low alert volume or your upstream notification system performs its own grouping.
        """
        return pulumi.get(self, "group_bies")

    @_builtins.property
    @pulumi.getter(name="groupInterval")
    def group_interval(self) -> _builtins.str:
        """
        How long to wait before sending a notification about new alerts that are added to a group of alerts for which an initial notification has already been sent. (Usually ~5m or more.)
        """
        return pulumi.get(self, "group_interval")

    @_builtins.property
    @pulumi.getter(name="groupWait")
    def group_wait(self) -> _builtins.str:
        """
        How long to initially wait to send a notification for a group of alerts. Allows to wait for an inhibiting alert to arrive or collect more initial alerts for the same group. (Usually ~0s to few minutes.)
        """
        return pulumi.get(self, "group_wait")

    @_builtins.property
    @pulumi.getter
    def match(self) -> Mapping[str, _builtins.str]:
        """
        A set of equality matchers an alert has to fulfill to match the node.
        """
        return pulumi.get(self, "match")

    @_builtins.property
    @pulumi.getter(name="matchRegex")
    def match_regex(self) -> Mapping[str, _builtins.str]:
        """
        A set of regex-matchers an alert has to fulfill to match the node.
        """
        return pulumi.get(self, "match_regex")

    @_builtins.property
    @pulumi.getter
    def receiver(self) -> _builtins.str:
        """
        The name of the receiver to route the alerts to.
        """
        return pulumi.get(self, "receiver")

    @_builtins.property
    @pulumi.getter(name="repeatInterval")
    def repeat_interval(self) -> _builtins.str:
        """
        How long to wait before sending a notification again if it has already been sent successfully for an alert. (Usually ~3h or more).
        """
        return pulumi.get(self, "repeat_interval")


@pulumi.output_type
class GetObservabilityLogalertgroupRuleResult(dict):
    def __init__(__self__, *,
                 alert: _builtins.str,
                 annotations: Mapping[str, _builtins.str],
                 expression: _builtins.str,
                 for_: _builtins.str,
                 labels: Mapping[str, _builtins.str]):
        """
        :param _builtins.str alert: The name of the alert rule. Is the identifier and must be unique in the group.
        :param Mapping[str, _builtins.str] annotations: A map of key:value. Annotations to add or overwrite for each alert
        :param _builtins.str expression: The LogQL expression to evaluate. Every evaluation cycle this is evaluated at the current time, and all resultant time series become pending/firing alerts.
        :param _builtins.str for_: Alerts are considered firing once they have been returned for this long. Alerts which have not yet fired for long enough are considered pending. Default is 0s
        :param Mapping[str, _builtins.str] labels: A map of key:value. Labels to add or overwrite for each alert
        """
        pulumi.set(__self__, "alert", alert)
        pulumi.set(__self__, "annotations", annotations)
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "for_", for_)
        pulumi.set(__self__, "labels", labels)

    @_builtins.property
    @pulumi.getter
    def alert(self) -> _builtins.str:
        """
        The name of the alert rule. Is the identifier and must be unique in the group.
        """
        return pulumi.get(self, "alert")

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Mapping[str, _builtins.str]:
        """
        A map of key:value. Annotations to add or overwrite for each alert
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        """
        The LogQL expression to evaluate. Every evaluation cycle this is evaluated at the current time, and all resultant time series become pending/firing alerts.
        """
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter(name="for")
    def for_(self) -> _builtins.str:
        """
        Alerts are considered firing once they have been returned for this long. Alerts which have not yet fired for long enough are considered pending. Default is 0s
        """
        return pulumi.get(self, "for_")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        """
        A map of key:value. Labels to add or overwrite for each alert
        """
        return pulumi.get(self, "labels")


@pulumi.output_type
class GetObservabilityScrapeconfigBasicAuthResult(dict):
    def __init__(__self__, *,
                 password: _builtins.str,
                 username: _builtins.str):
        """
        :param _builtins.str password: Specifies basic auth password.
        :param _builtins.str username: Specifies basic auth username.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter
    def password(self) -> _builtins.str:
        """
        Specifies basic auth password.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def username(self) -> _builtins.str:
        """
        Specifies basic auth username.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class GetObservabilityScrapeconfigSaml2Result(dict):
    def __init__(__self__, *,
                 enable_url_parameters: _builtins.bool):
        """
        :param _builtins.bool enable_url_parameters: Specifies if URL parameters are enabled
        """
        pulumi.set(__self__, "enable_url_parameters", enable_url_parameters)

    @_builtins.property
    @pulumi.getter(name="enableUrlParameters")
    def enable_url_parameters(self) -> _builtins.bool:
        """
        Specifies if URL parameters are enabled
        """
        return pulumi.get(self, "enable_url_parameters")


@pulumi.output_type
class GetObservabilityScrapeconfigTargetResult(dict):
    def __init__(__self__, *,
                 labels: Mapping[str, _builtins.str],
                 urls: Sequence[_builtins.str]):
        """
        :param Mapping[str, _builtins.str] labels: Specifies labels.
        :param Sequence[_builtins.str] urls: Specifies target URLs.
        """
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "urls", urls)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        """
        Specifies labels.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def urls(self) -> Sequence[_builtins.str]:
        """
        Specifies target URLs.
        """
        return pulumi.get(self, "urls")


@pulumi.output_type
class GetOpensearchInstanceParametersResult(dict):
    def __init__(__self__, *,
                 enable_monitoring: _builtins.bool,
                 graphite: _builtins.str,
                 java_garbage_collector: _builtins.str,
                 java_heapspace: _builtins.int,
                 java_maxmetaspace: _builtins.int,
                 max_disk_threshold: _builtins.int,
                 metrics_frequency: _builtins.int,
                 metrics_prefix: _builtins.str,
                 monitoring_instance_id: _builtins.str,
                 plugins: Sequence[_builtins.str],
                 sgw_acl: _builtins.str,
                 syslogs: Sequence[_builtins.str],
                 tls_ciphers: Sequence[_builtins.str],
                 tls_protocols: _builtins.str):
        """
        :param _builtins.bool enable_monitoring: Enable monitoring.
        :param _builtins.str graphite: If set, monitoring with Graphite will be enabled. Expects the host and port where the Graphite metrics should be sent to (host:port).
        :param _builtins.str java_garbage_collector: The garbage collector to use for OpenSearch.
        :param _builtins.int java_heapspace: The amount of memory (in MB) allocated as heap by the JVM for OpenSearch.
        :param _builtins.int java_maxmetaspace: The amount of memory (in MB) used by the JVM to store metadata for OpenSearch.
        :param _builtins.int max_disk_threshold: The maximum disk threshold in MB. If the disk usage exceeds this threshold, the instance will be stopped.
        :param _builtins.int metrics_frequency: The frequency in seconds at which metrics are emitted (in seconds).
        :param _builtins.str metrics_prefix: The prefix for the metrics. Could be useful when using Graphite monitoring to prefix the metrics with a certain value, like an API key.
        :param _builtins.str monitoring_instance_id: The ID of the STACKIT monitoring instance.
        :param Sequence[_builtins.str] plugins: List of plugins to install. Must be a supported plugin name. The plugins `repository-s3` and `repository-azure` are enabled by default and cannot be disabled.
        :param _builtins.str sgw_acl: Comma separated list of IP networks in CIDR notation which are allowed to access this instance.
        :param Sequence[_builtins.str] syslogs: List of syslog servers to send logs to.
        :param Sequence[_builtins.str] tls_ciphers: List of TLS ciphers to use.
        :param _builtins.str tls_protocols: The TLS protocol to use.
        """
        pulumi.set(__self__, "enable_monitoring", enable_monitoring)
        pulumi.set(__self__, "graphite", graphite)
        pulumi.set(__self__, "java_garbage_collector", java_garbage_collector)
        pulumi.set(__self__, "java_heapspace", java_heapspace)
        pulumi.set(__self__, "java_maxmetaspace", java_maxmetaspace)
        pulumi.set(__self__, "max_disk_threshold", max_disk_threshold)
        pulumi.set(__self__, "metrics_frequency", metrics_frequency)
        pulumi.set(__self__, "metrics_prefix", metrics_prefix)
        pulumi.set(__self__, "monitoring_instance_id", monitoring_instance_id)
        pulumi.set(__self__, "plugins", plugins)
        pulumi.set(__self__, "sgw_acl", sgw_acl)
        pulumi.set(__self__, "syslogs", syslogs)
        pulumi.set(__self__, "tls_ciphers", tls_ciphers)
        pulumi.set(__self__, "tls_protocols", tls_protocols)

    @_builtins.property
    @pulumi.getter(name="enableMonitoring")
    def enable_monitoring(self) -> _builtins.bool:
        """
        Enable monitoring.
        """
        return pulumi.get(self, "enable_monitoring")

    @_builtins.property
    @pulumi.getter
    def graphite(self) -> _builtins.str:
        """
        If set, monitoring with Graphite will be enabled. Expects the host and port where the Graphite metrics should be sent to (host:port).
        """
        return pulumi.get(self, "graphite")

    @_builtins.property
    @pulumi.getter(name="javaGarbageCollector")
    def java_garbage_collector(self) -> _builtins.str:
        """
        The garbage collector to use for OpenSearch.
        """
        return pulumi.get(self, "java_garbage_collector")

    @_builtins.property
    @pulumi.getter(name="javaHeapspace")
    def java_heapspace(self) -> _builtins.int:
        """
        The amount of memory (in MB) allocated as heap by the JVM for OpenSearch.
        """
        return pulumi.get(self, "java_heapspace")

    @_builtins.property
    @pulumi.getter(name="javaMaxmetaspace")
    def java_maxmetaspace(self) -> _builtins.int:
        """
        The amount of memory (in MB) used by the JVM to store metadata for OpenSearch.
        """
        return pulumi.get(self, "java_maxmetaspace")

    @_builtins.property
    @pulumi.getter(name="maxDiskThreshold")
    def max_disk_threshold(self) -> _builtins.int:
        """
        The maximum disk threshold in MB. If the disk usage exceeds this threshold, the instance will be stopped.
        """
        return pulumi.get(self, "max_disk_threshold")

    @_builtins.property
    @pulumi.getter(name="metricsFrequency")
    def metrics_frequency(self) -> _builtins.int:
        """
        The frequency in seconds at which metrics are emitted (in seconds).
        """
        return pulumi.get(self, "metrics_frequency")

    @_builtins.property
    @pulumi.getter(name="metricsPrefix")
    def metrics_prefix(self) -> _builtins.str:
        """
        The prefix for the metrics. Could be useful when using Graphite monitoring to prefix the metrics with a certain value, like an API key.
        """
        return pulumi.get(self, "metrics_prefix")

    @_builtins.property
    @pulumi.getter(name="monitoringInstanceId")
    def monitoring_instance_id(self) -> _builtins.str:
        """
        The ID of the STACKIT monitoring instance.
        """
        return pulumi.get(self, "monitoring_instance_id")

    @_builtins.property
    @pulumi.getter
    def plugins(self) -> Sequence[_builtins.str]:
        """
        List of plugins to install. Must be a supported plugin name. The plugins `repository-s3` and `repository-azure` are enabled by default and cannot be disabled.
        """
        return pulumi.get(self, "plugins")

    @_builtins.property
    @pulumi.getter(name="sgwAcl")
    def sgw_acl(self) -> _builtins.str:
        """
        Comma separated list of IP networks in CIDR notation which are allowed to access this instance.
        """
        return pulumi.get(self, "sgw_acl")

    @_builtins.property
    @pulumi.getter
    def syslogs(self) -> Sequence[_builtins.str]:
        """
        List of syslog servers to send logs to.
        """
        return pulumi.get(self, "syslogs")

    @_builtins.property
    @pulumi.getter(name="tlsCiphers")
    def tls_ciphers(self) -> Sequence[_builtins.str]:
        """
        List of TLS ciphers to use.
        """
        return pulumi.get(self, "tls_ciphers")

    @_builtins.property
    @pulumi.getter(name="tlsProtocols")
    def tls_protocols(self) -> _builtins.str:
        """
        The TLS protocol to use.
        """
        return pulumi.get(self, "tls_protocols")


@pulumi.output_type
class GetPostgresflexInstanceFlavorResult(dict):
    def __init__(__self__, *,
                 cpu: _builtins.int,
                 description: _builtins.str,
                 id: _builtins.str,
                 ram: _builtins.int):
        pulumi.set(__self__, "cpu", cpu)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ram", ram)

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> _builtins.int:
        return pulumi.get(self, "cpu")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ram(self) -> _builtins.int:
        return pulumi.get(self, "ram")


@pulumi.output_type
class GetPostgresflexInstanceStorageResult(dict):
    def __init__(__self__, *,
                 class_: _builtins.str,
                 size: _builtins.int):
        pulumi.set(__self__, "class_", class_)
        pulumi.set(__self__, "size", size)

    @_builtins.property
    @pulumi.getter(name="class")
    def class_(self) -> _builtins.str:
        return pulumi.get(self, "class_")

    @_builtins.property
    @pulumi.getter
    def size(self) -> _builtins.int:
        return pulumi.get(self, "size")


@pulumi.output_type
class GetPublicIpRangesPublicIpRangeResult(dict):
    def __init__(__self__, *,
                 cidr: _builtins.str):
        """
        :param _builtins.str cidr: Classless Inter-Domain Routing (CIDR)
        """
        pulumi.set(__self__, "cidr", cidr)

    @_builtins.property
    @pulumi.getter
    def cidr(self) -> _builtins.str:
        """
        Classless Inter-Domain Routing (CIDR)
        """
        return pulumi.get(self, "cidr")


@pulumi.output_type
class GetRabbitmqInstanceParametersResult(dict):
    def __init__(__self__, *,
                 consumer_timeout: _builtins.int,
                 enable_monitoring: _builtins.bool,
                 graphite: _builtins.str,
                 max_disk_threshold: _builtins.int,
                 metrics_frequency: _builtins.int,
                 metrics_prefix: _builtins.str,
                 monitoring_instance_id: _builtins.str,
                 plugins: Sequence[_builtins.str],
                 roles: Sequence[_builtins.str],
                 sgw_acl: _builtins.str,
                 syslogs: Sequence[_builtins.str],
                 tls_ciphers: Sequence[_builtins.str],
                 tls_protocols: _builtins.str):
        """
        :param _builtins.int consumer_timeout: The timeout in milliseconds for the consumer.
        :param _builtins.bool enable_monitoring: Enable monitoring.
        :param _builtins.str graphite: Graphite server URL (host and port). If set, monitoring with Graphite will be enabled.
        :param _builtins.int max_disk_threshold: The maximum disk threshold in MB. If the disk usage exceeds this threshold, the instance will be stopped.
        :param _builtins.int metrics_frequency: The frequency in seconds at which metrics are emitted.
        :param _builtins.str metrics_prefix: The prefix for the metrics. Could be useful when using Graphite monitoring to prefix the metrics with a certain value, like an API key
        :param _builtins.str monitoring_instance_id: The ID of the STACKIT monitoring instance.
        :param Sequence[_builtins.str] plugins: List of plugins to install. Must be a supported plugin name.
        :param Sequence[_builtins.str] roles: List of roles to assign to the instance.
        :param _builtins.str sgw_acl: Comma separated list of IP networks in CIDR notation which are allowed to access this instance.
        :param Sequence[_builtins.str] syslogs: List of syslog servers to send logs to.
        :param Sequence[_builtins.str] tls_ciphers: List of TLS ciphers to use.
        :param _builtins.str tls_protocols: TLS protocol to use.
        """
        pulumi.set(__self__, "consumer_timeout", consumer_timeout)
        pulumi.set(__self__, "enable_monitoring", enable_monitoring)
        pulumi.set(__self__, "graphite", graphite)
        pulumi.set(__self__, "max_disk_threshold", max_disk_threshold)
        pulumi.set(__self__, "metrics_frequency", metrics_frequency)
        pulumi.set(__self__, "metrics_prefix", metrics_prefix)
        pulumi.set(__self__, "monitoring_instance_id", monitoring_instance_id)
        pulumi.set(__self__, "plugins", plugins)
        pulumi.set(__self__, "roles", roles)
        pulumi.set(__self__, "sgw_acl", sgw_acl)
        pulumi.set(__self__, "syslogs", syslogs)
        pulumi.set(__self__, "tls_ciphers", tls_ciphers)
        pulumi.set(__self__, "tls_protocols", tls_protocols)

    @_builtins.property
    @pulumi.getter(name="consumerTimeout")
    def consumer_timeout(self) -> _builtins.int:
        """
        The timeout in milliseconds for the consumer.
        """
        return pulumi.get(self, "consumer_timeout")

    @_builtins.property
    @pulumi.getter(name="enableMonitoring")
    def enable_monitoring(self) -> _builtins.bool:
        """
        Enable monitoring.
        """
        return pulumi.get(self, "enable_monitoring")

    @_builtins.property
    @pulumi.getter
    def graphite(self) -> _builtins.str:
        """
        Graphite server URL (host and port). If set, monitoring with Graphite will be enabled.
        """
        return pulumi.get(self, "graphite")

    @_builtins.property
    @pulumi.getter(name="maxDiskThreshold")
    def max_disk_threshold(self) -> _builtins.int:
        """
        The maximum disk threshold in MB. If the disk usage exceeds this threshold, the instance will be stopped.
        """
        return pulumi.get(self, "max_disk_threshold")

    @_builtins.property
    @pulumi.getter(name="metricsFrequency")
    def metrics_frequency(self) -> _builtins.int:
        """
        The frequency in seconds at which metrics are emitted.
        """
        return pulumi.get(self, "metrics_frequency")

    @_builtins.property
    @pulumi.getter(name="metricsPrefix")
    def metrics_prefix(self) -> _builtins.str:
        """
        The prefix for the metrics. Could be useful when using Graphite monitoring to prefix the metrics with a certain value, like an API key
        """
        return pulumi.get(self, "metrics_prefix")

    @_builtins.property
    @pulumi.getter(name="monitoringInstanceId")
    def monitoring_instance_id(self) -> _builtins.str:
        """
        The ID of the STACKIT monitoring instance.
        """
        return pulumi.get(self, "monitoring_instance_id")

    @_builtins.property
    @pulumi.getter
    def plugins(self) -> Sequence[_builtins.str]:
        """
        List of plugins to install. Must be a supported plugin name.
        """
        return pulumi.get(self, "plugins")

    @_builtins.property
    @pulumi.getter
    def roles(self) -> Sequence[_builtins.str]:
        """
        List of roles to assign to the instance.
        """
        return pulumi.get(self, "roles")

    @_builtins.property
    @pulumi.getter(name="sgwAcl")
    def sgw_acl(self) -> _builtins.str:
        """
        Comma separated list of IP networks in CIDR notation which are allowed to access this instance.
        """
        return pulumi.get(self, "sgw_acl")

    @_builtins.property
    @pulumi.getter
    def syslogs(self) -> Sequence[_builtins.str]:
        """
        List of syslog servers to send logs to.
        """
        return pulumi.get(self, "syslogs")

    @_builtins.property
    @pulumi.getter(name="tlsCiphers")
    def tls_ciphers(self) -> Sequence[_builtins.str]:
        """
        List of TLS ciphers to use.
        """
        return pulumi.get(self, "tls_ciphers")

    @_builtins.property
    @pulumi.getter(name="tlsProtocols")
    def tls_protocols(self) -> _builtins.str:
        """
        TLS protocol to use.
        """
        return pulumi.get(self, "tls_protocols")


@pulumi.output_type
class GetRedisInstanceParametersResult(dict):
    def __init__(__self__, *,
                 down_after_milliseconds: _builtins.int,
                 enable_monitoring: _builtins.bool,
                 failover_timeout: _builtins.int,
                 graphite: _builtins.str,
                 lazyfree_lazy_eviction: _builtins.str,
                 lazyfree_lazy_expire: _builtins.str,
                 lua_time_limit: _builtins.int,
                 max_disk_threshold: _builtins.int,
                 maxclients: _builtins.int,
                 maxmemory_policy: _builtins.str,
                 maxmemory_samples: _builtins.int,
                 metrics_frequency: _builtins.int,
                 metrics_prefix: _builtins.str,
                 min_replicas_max_lag: _builtins.int,
                 monitoring_instance_id: _builtins.str,
                 notify_keyspace_events: _builtins.str,
                 sgw_acl: _builtins.str,
                 snapshot: _builtins.str,
                 syslogs: Sequence[_builtins.str],
                 tls_ciphers: Sequence[_builtins.str],
                 tls_ciphersuites: _builtins.str,
                 tls_protocols: _builtins.str):
        """
        :param _builtins.int down_after_milliseconds: The number of milliseconds after which the instance is considered down.
        :param _builtins.bool enable_monitoring: Enable monitoring.
        :param _builtins.int failover_timeout: The failover timeout in milliseconds.
        :param _builtins.str graphite: Graphite server URL (host and port). If set, monitoring with Graphite will be enabled.
        :param _builtins.str lazyfree_lazy_eviction: The lazy eviction enablement (yes or no).
        :param _builtins.str lazyfree_lazy_expire: The lazy expire enablement (yes or no).
        :param _builtins.int lua_time_limit: The Lua time limit.
        :param _builtins.int max_disk_threshold: The maximum disk threshold in MB. If the disk usage exceeds this threshold, the instance will be stopped.
        :param _builtins.int maxclients: The maximum number of clients.
        :param _builtins.str maxmemory_policy: The policy to handle the maximum memory (volatile-lru, noeviction, etc).
        :param _builtins.int maxmemory_samples: The maximum memory samples.
        :param _builtins.int metrics_frequency: The frequency in seconds at which metrics are emitted.
        :param _builtins.str metrics_prefix: The prefix for the metrics. Could be useful when using Graphite monitoring to prefix the metrics with a certain value, like an API key
        :param _builtins.int min_replicas_max_lag: The minimum replicas maximum lag.
        :param _builtins.str monitoring_instance_id: The ID of the STACKIT monitoring instance.
        :param _builtins.str notify_keyspace_events: The notify keyspace events.
        :param _builtins.str sgw_acl: Comma separated list of IP networks in CIDR notation which are allowed to access this instance.
        :param _builtins.str snapshot: The snapshot configuration.
        :param Sequence[_builtins.str] syslogs: List of syslog servers to send logs to.
        :param Sequence[_builtins.str] tls_ciphers: List of TLS ciphers to use.
        :param _builtins.str tls_ciphersuites: TLS cipher suites to use.
        :param _builtins.str tls_protocols: TLS protocol to use.
        """
        pulumi.set(__self__, "down_after_milliseconds", down_after_milliseconds)
        pulumi.set(__self__, "enable_monitoring", enable_monitoring)
        pulumi.set(__self__, "failover_timeout", failover_timeout)
        pulumi.set(__self__, "graphite", graphite)
        pulumi.set(__self__, "lazyfree_lazy_eviction", lazyfree_lazy_eviction)
        pulumi.set(__self__, "lazyfree_lazy_expire", lazyfree_lazy_expire)
        pulumi.set(__self__, "lua_time_limit", lua_time_limit)
        pulumi.set(__self__, "max_disk_threshold", max_disk_threshold)
        pulumi.set(__self__, "maxclients", maxclients)
        pulumi.set(__self__, "maxmemory_policy", maxmemory_policy)
        pulumi.set(__self__, "maxmemory_samples", maxmemory_samples)
        pulumi.set(__self__, "metrics_frequency", metrics_frequency)
        pulumi.set(__self__, "metrics_prefix", metrics_prefix)
        pulumi.set(__self__, "min_replicas_max_lag", min_replicas_max_lag)
        pulumi.set(__self__, "monitoring_instance_id", monitoring_instance_id)
        pulumi.set(__self__, "notify_keyspace_events", notify_keyspace_events)
        pulumi.set(__self__, "sgw_acl", sgw_acl)
        pulumi.set(__self__, "snapshot", snapshot)
        pulumi.set(__self__, "syslogs", syslogs)
        pulumi.set(__self__, "tls_ciphers", tls_ciphers)
        pulumi.set(__self__, "tls_ciphersuites", tls_ciphersuites)
        pulumi.set(__self__, "tls_protocols", tls_protocols)

    @_builtins.property
    @pulumi.getter(name="downAfterMilliseconds")
    def down_after_milliseconds(self) -> _builtins.int:
        """
        The number of milliseconds after which the instance is considered down.
        """
        return pulumi.get(self, "down_after_milliseconds")

    @_builtins.property
    @pulumi.getter(name="enableMonitoring")
    def enable_monitoring(self) -> _builtins.bool:
        """
        Enable monitoring.
        """
        return pulumi.get(self, "enable_monitoring")

    @_builtins.property
    @pulumi.getter(name="failoverTimeout")
    def failover_timeout(self) -> _builtins.int:
        """
        The failover timeout in milliseconds.
        """
        return pulumi.get(self, "failover_timeout")

    @_builtins.property
    @pulumi.getter
    def graphite(self) -> _builtins.str:
        """
        Graphite server URL (host and port). If set, monitoring with Graphite will be enabled.
        """
        return pulumi.get(self, "graphite")

    @_builtins.property
    @pulumi.getter(name="lazyfreeLazyEviction")
    def lazyfree_lazy_eviction(self) -> _builtins.str:
        """
        The lazy eviction enablement (yes or no).
        """
        return pulumi.get(self, "lazyfree_lazy_eviction")

    @_builtins.property
    @pulumi.getter(name="lazyfreeLazyExpire")
    def lazyfree_lazy_expire(self) -> _builtins.str:
        """
        The lazy expire enablement (yes or no).
        """
        return pulumi.get(self, "lazyfree_lazy_expire")

    @_builtins.property
    @pulumi.getter(name="luaTimeLimit")
    def lua_time_limit(self) -> _builtins.int:
        """
        The Lua time limit.
        """
        return pulumi.get(self, "lua_time_limit")

    @_builtins.property
    @pulumi.getter(name="maxDiskThreshold")
    def max_disk_threshold(self) -> _builtins.int:
        """
        The maximum disk threshold in MB. If the disk usage exceeds this threshold, the instance will be stopped.
        """
        return pulumi.get(self, "max_disk_threshold")

    @_builtins.property
    @pulumi.getter
    def maxclients(self) -> _builtins.int:
        """
        The maximum number of clients.
        """
        return pulumi.get(self, "maxclients")

    @_builtins.property
    @pulumi.getter(name="maxmemoryPolicy")
    def maxmemory_policy(self) -> _builtins.str:
        """
        The policy to handle the maximum memory (volatile-lru, noeviction, etc).
        """
        return pulumi.get(self, "maxmemory_policy")

    @_builtins.property
    @pulumi.getter(name="maxmemorySamples")
    def maxmemory_samples(self) -> _builtins.int:
        """
        The maximum memory samples.
        """
        return pulumi.get(self, "maxmemory_samples")

    @_builtins.property
    @pulumi.getter(name="metricsFrequency")
    def metrics_frequency(self) -> _builtins.int:
        """
        The frequency in seconds at which metrics are emitted.
        """
        return pulumi.get(self, "metrics_frequency")

    @_builtins.property
    @pulumi.getter(name="metricsPrefix")
    def metrics_prefix(self) -> _builtins.str:
        """
        The prefix for the metrics. Could be useful when using Graphite monitoring to prefix the metrics with a certain value, like an API key
        """
        return pulumi.get(self, "metrics_prefix")

    @_builtins.property
    @pulumi.getter(name="minReplicasMaxLag")
    def min_replicas_max_lag(self) -> _builtins.int:
        """
        The minimum replicas maximum lag.
        """
        return pulumi.get(self, "min_replicas_max_lag")

    @_builtins.property
    @pulumi.getter(name="monitoringInstanceId")
    def monitoring_instance_id(self) -> _builtins.str:
        """
        The ID of the STACKIT monitoring instance.
        """
        return pulumi.get(self, "monitoring_instance_id")

    @_builtins.property
    @pulumi.getter(name="notifyKeyspaceEvents")
    def notify_keyspace_events(self) -> _builtins.str:
        """
        The notify keyspace events.
        """
        return pulumi.get(self, "notify_keyspace_events")

    @_builtins.property
    @pulumi.getter(name="sgwAcl")
    def sgw_acl(self) -> _builtins.str:
        """
        Comma separated list of IP networks in CIDR notation which are allowed to access this instance.
        """
        return pulumi.get(self, "sgw_acl")

    @_builtins.property
    @pulumi.getter
    def snapshot(self) -> _builtins.str:
        """
        The snapshot configuration.
        """
        return pulumi.get(self, "snapshot")

    @_builtins.property
    @pulumi.getter
    def syslogs(self) -> Sequence[_builtins.str]:
        """
        List of syslog servers to send logs to.
        """
        return pulumi.get(self, "syslogs")

    @_builtins.property
    @pulumi.getter(name="tlsCiphers")
    def tls_ciphers(self) -> Sequence[_builtins.str]:
        """
        List of TLS ciphers to use.
        """
        return pulumi.get(self, "tls_ciphers")

    @_builtins.property
    @pulumi.getter(name="tlsCiphersuites")
    def tls_ciphersuites(self) -> _builtins.str:
        """
        TLS cipher suites to use.
        """
        return pulumi.get(self, "tls_ciphersuites")

    @_builtins.property
    @pulumi.getter(name="tlsProtocols")
    def tls_protocols(self) -> _builtins.str:
        """
        TLS protocol to use.
        """
        return pulumi.get(self, "tls_protocols")


@pulumi.output_type
class GetRoutingTableRouteDestinationResult(dict):
    def __init__(__self__, *,
                 type: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str type: CIDRV type. Possible values are: `cidrv4`, `cidrv6`. Only `cidrv4` is supported during experimental stage.
        :param _builtins.str value: An CIDR string.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        CIDRV type. Possible values are: `cidrv4`, `cidrv6`. Only `cidrv4` is supported during experimental stage.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        An CIDR string.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetRoutingTableRouteNextHopResult(dict):
    def __init__(__self__, *,
                 type: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str type: Possible values are: `blackhole`, `internet`, `ipv4`, `ipv6`. Only `cidrv4` is supported during experimental stage..
        :param _builtins.str value: Either IPv4 or IPv6 (not set for blackhole and internet). Only IPv4 supported during experimental stage.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Possible values are: `blackhole`, `internet`, `ipv4`, `ipv6`. Only `cidrv4` is supported during experimental stage..
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Either IPv4 or IPv6 (not set for blackhole and internet). Only IPv4 supported during experimental stage.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetRoutingTableRoutesRouteResult(dict):
    def __init__(__self__, *,
                 created_at: _builtins.str,
                 destination: 'outputs.GetRoutingTableRoutesRouteDestinationResult',
                 labels: Mapping[str, _builtins.str],
                 next_hop: 'outputs.GetRoutingTableRoutesRouteNextHopResult',
                 route_id: _builtins.str,
                 updated_at: _builtins.str):
        """
        :param _builtins.str created_at: Date-time when the route was created
        :param 'GetRoutingTableRoutesRouteDestinationArgs' destination: Destination of the route.
        :param Mapping[str, _builtins.str] labels: Labels are key-value string pairs which can be attached to a resource container
        :param 'GetRoutingTableRoutesRouteNextHopArgs' next_hop: Next hop destination.
        :param _builtins.str route_id: Route ID.
        :param _builtins.str updated_at: Date-time when the route was updated
        """
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "next_hop", next_hop)
        pulumi.set(__self__, "route_id", route_id)
        pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        Date-time when the route was created
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def destination(self) -> 'outputs.GetRoutingTableRoutesRouteDestinationResult':
        """
        Destination of the route.
        """
        return pulumi.get(self, "destination")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        """
        Labels are key-value string pairs which can be attached to a resource container
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="nextHop")
    def next_hop(self) -> 'outputs.GetRoutingTableRoutesRouteNextHopResult':
        """
        Next hop destination.
        """
        return pulumi.get(self, "next_hop")

    @_builtins.property
    @pulumi.getter(name="routeId")
    def route_id(self) -> _builtins.str:
        """
        Route ID.
        """
        return pulumi.get(self, "route_id")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        """
        Date-time when the route was updated
        """
        return pulumi.get(self, "updated_at")


@pulumi.output_type
class GetRoutingTableRoutesRouteDestinationResult(dict):
    def __init__(__self__, *,
                 type: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str type: CIDRV type. Possible values are: `cidrv4`, `cidrv6`. Only `cidrv4` is supported during experimental stage.
        :param _builtins.str value: An CIDR string.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        CIDRV type. Possible values are: `cidrv4`, `cidrv6`. Only `cidrv4` is supported during experimental stage.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        An CIDR string.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetRoutingTableRoutesRouteNextHopResult(dict):
    def __init__(__self__, *,
                 type: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str type: Possible values are: `blackhole`, `internet`, `ipv4`, `ipv6`. Only `cidrv4` is supported during experimental stage..
        :param _builtins.str value: Either IPv4 or IPv6 (not set for blackhole and internet). Only IPv4 supported during experimental stage.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Possible values are: `blackhole`, `internet`, `ipv4`, `ipv6`. Only `cidrv4` is supported during experimental stage..
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Either IPv4 or IPv6 (not set for blackhole and internet). Only IPv4 supported during experimental stage.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetRoutingTablesItemResult(dict):
    def __init__(__self__, *,
                 created_at: _builtins.str,
                 default: _builtins.bool,
                 description: _builtins.str,
                 labels: Mapping[str, _builtins.str],
                 name: _builtins.str,
                 routing_table_id: _builtins.str,
                 system_routes: _builtins.bool,
                 updated_at: _builtins.str):
        """
        :param _builtins.str created_at: Date-time when the routing table was created
        :param _builtins.bool default: When true this is the default routing table for this network area. It can't be deleted and is used if the user does not specify it otherwise.
        :param _builtins.str description: Description of the routing table.
        :param Mapping[str, _builtins.str] labels: Labels are key-value string pairs which can be attached to a resource container
        :param _builtins.str name: The name of the routing table.
        :param _builtins.str routing_table_id: The routing tables ID.
        :param _builtins.bool system_routes: This controls whether the routes for project-to-project communication are created automatically or not.
        :param _builtins.str updated_at: Date-time when the routing table was updated
        """
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "default", default)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "routing_table_id", routing_table_id)
        pulumi.set(__self__, "system_routes", system_routes)
        pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        Date-time when the routing table was created
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def default(self) -> _builtins.bool:
        """
        When true this is the default routing table for this network area. It can't be deleted and is used if the user does not specify it otherwise.
        """
        return pulumi.get(self, "default")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the routing table.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        """
        Labels are key-value string pairs which can be attached to a resource container
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the routing table.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="routingTableId")
    def routing_table_id(self) -> _builtins.str:
        """
        The routing tables ID.
        """
        return pulumi.get(self, "routing_table_id")

    @_builtins.property
    @pulumi.getter(name="systemRoutes")
    def system_routes(self) -> _builtins.bool:
        """
        This controls whether the routes for project-to-project communication are created automatically or not.
        """
        return pulumi.get(self, "system_routes")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        """
        Date-time when the routing table was updated
        """
        return pulumi.get(self, "updated_at")


@pulumi.output_type
class GetSecurityGroupRuleIcmpParametersResult(dict):
    def __init__(__self__, *,
                 code: _builtins.int,
                 type: _builtins.int):
        """
        :param _builtins.int code: ICMP code. Can be set if the protocol is ICMP.
        :param _builtins.int type: ICMP type. Can be set if the protocol is ICMP.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def code(self) -> _builtins.int:
        """
        ICMP code. Can be set if the protocol is ICMP.
        """
        return pulumi.get(self, "code")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.int:
        """
        ICMP type. Can be set if the protocol is ICMP.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetSecurityGroupRulePortRangeResult(dict):
    def __init__(__self__, *,
                 max: _builtins.int,
                 min: _builtins.int):
        """
        :param _builtins.int max: The maximum port number. Should be greater or equal to the minimum.
        :param _builtins.int min: The minimum port number. Should be less or equal to the minimum.
        """
        pulumi.set(__self__, "max", max)
        pulumi.set(__self__, "min", min)

    @_builtins.property
    @pulumi.getter
    def max(self) -> _builtins.int:
        """
        The maximum port number. Should be greater or equal to the minimum.
        """
        return pulumi.get(self, "max")

    @_builtins.property
    @pulumi.getter
    def min(self) -> _builtins.int:
        """
        The minimum port number. Should be less or equal to the minimum.
        """
        return pulumi.get(self, "min")


@pulumi.output_type
class GetSecurityGroupRuleProtocolResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 number: _builtins.int):
        """
        :param _builtins.str name: The protocol name which the rule should match.
        :param _builtins.int number: The protocol number which the rule should match.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "number", number)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The protocol name which the rule should match.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def number(self) -> _builtins.int:
        """
        The protocol number which the rule should match.
        """
        return pulumi.get(self, "number")


@pulumi.output_type
class GetServerBackupScheduleBackupPropertiesResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 retention_period: _builtins.int,
                 volume_ids: Sequence[_builtins.str]):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "retention_period", retention_period)
        pulumi.set(__self__, "volume_ids", volume_ids)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="retentionPeriod")
    def retention_period(self) -> _builtins.int:
        return pulumi.get(self, "retention_period")

    @_builtins.property
    @pulumi.getter(name="volumeIds")
    def volume_ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "volume_ids")


@pulumi.output_type
class GetServerBackupSchedulesItemResult(dict):
    def __init__(__self__, *,
                 backup_properties: 'outputs.GetServerBackupSchedulesItemBackupPropertiesResult',
                 backup_schedule_id: _builtins.int,
                 enabled: _builtins.bool,
                 name: _builtins.str,
                 rrule: _builtins.str):
        """
        :param 'GetServerBackupSchedulesItemBackupPropertiesArgs' backup_properties: Backup schedule details for the backups.
        :param _builtins.bool enabled: Is the backup schedule enabled or disabled.
        :param _builtins.str name: The backup schedule name.
        :param _builtins.str rrule: Backup schedule described in `rrule` (recurrence rule) format.
        """
        pulumi.set(__self__, "backup_properties", backup_properties)
        pulumi.set(__self__, "backup_schedule_id", backup_schedule_id)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "rrule", rrule)

    @_builtins.property
    @pulumi.getter(name="backupProperties")
    def backup_properties(self) -> 'outputs.GetServerBackupSchedulesItemBackupPropertiesResult':
        """
        Backup schedule details for the backups.
        """
        return pulumi.get(self, "backup_properties")

    @_builtins.property
    @pulumi.getter(name="backupScheduleId")
    def backup_schedule_id(self) -> _builtins.int:
        return pulumi.get(self, "backup_schedule_id")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Is the backup schedule enabled or disabled.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The backup schedule name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def rrule(self) -> _builtins.str:
        """
        Backup schedule described in `rrule` (recurrence rule) format.
        """
        return pulumi.get(self, "rrule")


@pulumi.output_type
class GetServerBackupSchedulesItemBackupPropertiesResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 retention_period: _builtins.int,
                 volume_ids: Sequence[_builtins.str]):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "retention_period", retention_period)
        pulumi.set(__self__, "volume_ids", volume_ids)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="retentionPeriod")
    def retention_period(self) -> _builtins.int:
        return pulumi.get(self, "retention_period")

    @_builtins.property
    @pulumi.getter(name="volumeIds")
    def volume_ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "volume_ids")


@pulumi.output_type
class GetServerBootVolumeResult(dict):
    def __init__(__self__, *,
                 delete_on_termination: _builtins.bool,
                 id: _builtins.str):
        """
        :param _builtins.bool delete_on_termination: Delete the volume during the termination of the server.
        :param _builtins.str id: The ID of the boot volume
        """
        pulumi.set(__self__, "delete_on_termination", delete_on_termination)
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter(name="deleteOnTermination")
    def delete_on_termination(self) -> _builtins.bool:
        """
        Delete the volume during the termination of the server.
        """
        return pulumi.get(self, "delete_on_termination")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the boot volume
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetServerUpdateSchedulesItemResult(dict):
    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 maintenance_window: _builtins.int,
                 name: _builtins.str,
                 rrule: _builtins.str,
                 update_schedule_id: _builtins.int):
        """
        :param _builtins.bool enabled: Is the update schedule enabled or disabled.
        :param _builtins.int maintenance_window: Maintenance window [1..24].
        :param _builtins.str name: The update schedule name.
        :param _builtins.str rrule: Update schedule described in `rrule` (recurrence rule) format.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "maintenance_window", maintenance_window)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "rrule", rrule)
        pulumi.set(__self__, "update_schedule_id", update_schedule_id)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Is the update schedule enabled or disabled.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> _builtins.int:
        """
        Maintenance window [1..24].
        """
        return pulumi.get(self, "maintenance_window")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The update schedule name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def rrule(self) -> _builtins.str:
        """
        Update schedule described in `rrule` (recurrence rule) format.
        """
        return pulumi.get(self, "rrule")

    @_builtins.property
    @pulumi.getter(name="updateScheduleId")
    def update_schedule_id(self) -> _builtins.int:
        return pulumi.get(self, "update_schedule_id")


@pulumi.output_type
class GetSkeClusterExtensionsResult(dict):
    def __init__(__self__, *,
                 acl: 'outputs.GetSkeClusterExtensionsAclResult',
                 argus: 'outputs.GetSkeClusterExtensionsArgusResult',
                 dns: 'outputs.GetSkeClusterExtensionsDnsResult',
                 observability: 'outputs.GetSkeClusterExtensionsObservabilityResult'):
        """
        :param 'GetSkeClusterExtensionsAclArgs' acl: Cluster access control configuration
        :param 'GetSkeClusterExtensionsArgusArgs' argus: A single argus block as defined below. This field is deprecated and will be removed 06 January 2026.
        :param 'GetSkeClusterExtensionsDnsArgs' dns: DNS extension configuration
        :param 'GetSkeClusterExtensionsObservabilityArgs' observability: A single observability block as defined below.
        """
        pulumi.set(__self__, "acl", acl)
        pulumi.set(__self__, "argus", argus)
        pulumi.set(__self__, "dns", dns)
        pulumi.set(__self__, "observability", observability)

    @_builtins.property
    @pulumi.getter
    def acl(self) -> 'outputs.GetSkeClusterExtensionsAclResult':
        """
        Cluster access control configuration
        """
        return pulumi.get(self, "acl")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Use observability instead.""")
    def argus(self) -> 'outputs.GetSkeClusterExtensionsArgusResult':
        """
        A single argus block as defined below. This field is deprecated and will be removed 06 January 2026.
        """
        return pulumi.get(self, "argus")

    @_builtins.property
    @pulumi.getter
    def dns(self) -> 'outputs.GetSkeClusterExtensionsDnsResult':
        """
        DNS extension configuration
        """
        return pulumi.get(self, "dns")

    @_builtins.property
    @pulumi.getter
    def observability(self) -> 'outputs.GetSkeClusterExtensionsObservabilityResult':
        """
        A single observability block as defined below.
        """
        return pulumi.get(self, "observability")


@pulumi.output_type
class GetSkeClusterExtensionsAclResult(dict):
    def __init__(__self__, *,
                 allowed_cidrs: Sequence[_builtins.str],
                 enabled: _builtins.bool):
        """
        :param Sequence[_builtins.str] allowed_cidrs: Specify a list of CIDRs to whitelist
        :param _builtins.bool enabled: Is ACL enabled?
        """
        pulumi.set(__self__, "allowed_cidrs", allowed_cidrs)
        pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter(name="allowedCidrs")
    def allowed_cidrs(self) -> Sequence[_builtins.str]:
        """
        Specify a list of CIDRs to whitelist
        """
        return pulumi.get(self, "allowed_cidrs")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Is ACL enabled?
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class GetSkeClusterExtensionsArgusResult(dict):
    def __init__(__self__, *,
                 argus_instance_id: _builtins.str,
                 enabled: _builtins.bool):
        """
        :param _builtins.str argus_instance_id: Instance ID of argus
        :param _builtins.bool enabled: Flag to enable/disable argus extensions.
        """
        pulumi.set(__self__, "argus_instance_id", argus_instance_id)
        pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter(name="argusInstanceId")
    def argus_instance_id(self) -> _builtins.str:
        """
        Instance ID of argus
        """
        return pulumi.get(self, "argus_instance_id")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Flag to enable/disable argus extensions.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class GetSkeClusterExtensionsDnsResult(dict):
    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 zones: Sequence[_builtins.str]):
        """
        :param _builtins.bool enabled: Flag to enable/disable DNS extensions
        :param Sequence[_builtins.str] zones: Specify a list of domain filters for externalDNS (e.g., `foo.runs.onstackit.cloud`)
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "zones", zones)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Flag to enable/disable DNS extensions
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def zones(self) -> Sequence[_builtins.str]:
        """
        Specify a list of domain filters for externalDNS (e.g., `foo.runs.onstackit.cloud`)
        """
        return pulumi.get(self, "zones")


@pulumi.output_type
class GetSkeClusterExtensionsObservabilityResult(dict):
    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 instance_id: _builtins.str):
        """
        :param _builtins.bool enabled: Flag to enable/disable Observability extensions.
        :param _builtins.str instance_id: Observability instance ID to choose which Observability instance is used. Required when enabled is set to `true`.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "instance_id", instance_id)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Flag to enable/disable Observability extensions.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        Observability instance ID to choose which Observability instance is used. Required when enabled is set to `true`.
        """
        return pulumi.get(self, "instance_id")


@pulumi.output_type
class GetSkeClusterHibernationResult(dict):
    def __init__(__self__, *,
                 end: _builtins.str,
                 start: _builtins.str,
                 timezone: _builtins.str):
        """
        :param _builtins.str end: End time of hibernation, in crontab syntax.
        :param _builtins.str start: Start time of cluster hibernation in crontab syntax.
        :param _builtins.str timezone: Timezone name corresponding to a file in the IANA Time Zone database.
        """
        pulumi.set(__self__, "end", end)
        pulumi.set(__self__, "start", start)
        pulumi.set(__self__, "timezone", timezone)

    @_builtins.property
    @pulumi.getter
    def end(self) -> _builtins.str:
        """
        End time of hibernation, in crontab syntax.
        """
        return pulumi.get(self, "end")

    @_builtins.property
    @pulumi.getter
    def start(self) -> _builtins.str:
        """
        Start time of cluster hibernation in crontab syntax.
        """
        return pulumi.get(self, "start")

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> _builtins.str:
        """
        Timezone name corresponding to a file in the IANA Time Zone database.
        """
        return pulumi.get(self, "timezone")


@pulumi.output_type
class GetSkeClusterMaintenanceResult(dict):
    def __init__(__self__, *,
                 enable_kubernetes_version_updates: _builtins.bool,
                 enable_machine_image_version_updates: _builtins.bool,
                 end: _builtins.str,
                 start: _builtins.str):
        """
        :param _builtins.bool enable_kubernetes_version_updates: Flag to enable/disable auto-updates of the Kubernetes version.
        :param _builtins.bool enable_machine_image_version_updates: Flag to enable/disable auto-updates of the OS image version.
        :param _builtins.str end: Date time for maintenance window end.
        :param _builtins.str start: Date time for maintenance window start.
        """
        pulumi.set(__self__, "enable_kubernetes_version_updates", enable_kubernetes_version_updates)
        pulumi.set(__self__, "enable_machine_image_version_updates", enable_machine_image_version_updates)
        pulumi.set(__self__, "end", end)
        pulumi.set(__self__, "start", start)

    @_builtins.property
    @pulumi.getter(name="enableKubernetesVersionUpdates")
    def enable_kubernetes_version_updates(self) -> _builtins.bool:
        """
        Flag to enable/disable auto-updates of the Kubernetes version.
        """
        return pulumi.get(self, "enable_kubernetes_version_updates")

    @_builtins.property
    @pulumi.getter(name="enableMachineImageVersionUpdates")
    def enable_machine_image_version_updates(self) -> _builtins.bool:
        """
        Flag to enable/disable auto-updates of the OS image version.
        """
        return pulumi.get(self, "enable_machine_image_version_updates")

    @_builtins.property
    @pulumi.getter
    def end(self) -> _builtins.str:
        """
        Date time for maintenance window end.
        """
        return pulumi.get(self, "end")

    @_builtins.property
    @pulumi.getter
    def start(self) -> _builtins.str:
        """
        Date time for maintenance window start.
        """
        return pulumi.get(self, "start")


@pulumi.output_type
class GetSkeClusterNetworkResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str):
        """
        :param _builtins.str id: ID of the STACKIT Network Area (SNA) network into which the cluster will be deployed.
        """
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the STACKIT Network Area (SNA) network into which the cluster will be deployed.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetSkeClusterNodePoolResult(dict):
    def __init__(__self__, *,
                 allow_system_components: _builtins.bool,
                 availability_zones: Sequence[_builtins.str],
                 cri: _builtins.str,
                 labels: Mapping[str, _builtins.str],
                 machine_type: _builtins.str,
                 max_surge: _builtins.int,
                 max_unavailable: _builtins.int,
                 maximum: _builtins.int,
                 minimum: _builtins.int,
                 name: _builtins.str,
                 os_name: _builtins.str,
                 os_version: _builtins.str,
                 os_version_min: _builtins.str,
                 os_version_used: _builtins.str,
                 taints: Sequence['outputs.GetSkeClusterNodePoolTaintResult'],
                 volume_size: _builtins.int,
                 volume_type: _builtins.str):
        """
        :param _builtins.bool allow_system_components: Allow system components to run on this node pool.
        :param Sequence[_builtins.str] availability_zones: Specify a list of availability zones.
        :param _builtins.str cri: Specifies the container runtime.
        :param Mapping[str, _builtins.str] labels: Labels to add to each node.
        :param _builtins.str machine_type: The machine type.
        :param _builtins.int max_surge: The maximum number of nodes upgraded simultaneously.
        :param _builtins.int max_unavailable: The maximum number of nodes unavailable during upgraded.
        :param _builtins.int maximum: Maximum number of nodes in the pool.
        :param _builtins.int minimum: Minimum number of nodes in the pool.
        :param _builtins.str name: Specifies the name of the node pool.
        :param _builtins.str os_name: The name of the OS image.
        :param _builtins.str os_version: The OS image version.
        :param _builtins.str os_version_min: The minimum OS image version, this field is always nil. SKE automatically updates the cluster Kubernetes version if you have set `maintenance.enable_kubernetes_version_updates` to true or if there is a mandatory update, as described in [Updates for Kubernetes versions and Operating System versions in SKE](https://docs.stackit.cloud/stackit/en/version-updates-in-ske-10125631.html). To get the current OS image version being used for the node pool, use the read-only `os_version_used` field.
        :param _builtins.str os_version_used: Full OS image version used. For example, if 3815.2 was set in `os_version_min`, this value may result to 3815.2.2. SKE automatically updates the cluster Kubernetes version if you have set `maintenance.enable_kubernetes_version_updates` to true or if there is a mandatory update, as described in [Updates for Kubernetes versions and Operating System versions in SKE](https://docs.stackit.cloud/stackit/en/version-updates-in-ske-10125631.html).
        :param Sequence['GetSkeClusterNodePoolTaintArgs'] taints: Specifies a taint list as defined below.
        :param _builtins.int volume_size: The volume size in GB.
        :param _builtins.str volume_type: Specifies the volume type.
        """
        pulumi.set(__self__, "allow_system_components", allow_system_components)
        pulumi.set(__self__, "availability_zones", availability_zones)
        pulumi.set(__self__, "cri", cri)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "machine_type", machine_type)
        pulumi.set(__self__, "max_surge", max_surge)
        pulumi.set(__self__, "max_unavailable", max_unavailable)
        pulumi.set(__self__, "maximum", maximum)
        pulumi.set(__self__, "minimum", minimum)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "os_name", os_name)
        pulumi.set(__self__, "os_version", os_version)
        pulumi.set(__self__, "os_version_min", os_version_min)
        pulumi.set(__self__, "os_version_used", os_version_used)
        pulumi.set(__self__, "taints", taints)
        pulumi.set(__self__, "volume_size", volume_size)
        pulumi.set(__self__, "volume_type", volume_type)

    @_builtins.property
    @pulumi.getter(name="allowSystemComponents")
    def allow_system_components(self) -> _builtins.bool:
        """
        Allow system components to run on this node pool.
        """
        return pulumi.get(self, "allow_system_components")

    @_builtins.property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Sequence[_builtins.str]:
        """
        Specify a list of availability zones.
        """
        return pulumi.get(self, "availability_zones")

    @_builtins.property
    @pulumi.getter
    def cri(self) -> _builtins.str:
        """
        Specifies the container runtime.
        """
        return pulumi.get(self, "cri")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        """
        Labels to add to each node.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> _builtins.str:
        """
        The machine type.
        """
        return pulumi.get(self, "machine_type")

    @_builtins.property
    @pulumi.getter(name="maxSurge")
    def max_surge(self) -> _builtins.int:
        """
        The maximum number of nodes upgraded simultaneously.
        """
        return pulumi.get(self, "max_surge")

    @_builtins.property
    @pulumi.getter(name="maxUnavailable")
    def max_unavailable(self) -> _builtins.int:
        """
        The maximum number of nodes unavailable during upgraded.
        """
        return pulumi.get(self, "max_unavailable")

    @_builtins.property
    @pulumi.getter
    def maximum(self) -> _builtins.int:
        """
        Maximum number of nodes in the pool.
        """
        return pulumi.get(self, "maximum")

    @_builtins.property
    @pulumi.getter
    def minimum(self) -> _builtins.int:
        """
        Minimum number of nodes in the pool.
        """
        return pulumi.get(self, "minimum")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the name of the node pool.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="osName")
    def os_name(self) -> _builtins.str:
        """
        The name of the OS image.
        """
        return pulumi.get(self, "os_name")

    @_builtins.property
    @pulumi.getter(name="osVersion")
    def os_version(self) -> _builtins.str:
        """
        The OS image version.
        """
        return pulumi.get(self, "os_version")

    @_builtins.property
    @pulumi.getter(name="osVersionMin")
    def os_version_min(self) -> _builtins.str:
        """
        The minimum OS image version, this field is always nil. SKE automatically updates the cluster Kubernetes version if you have set `maintenance.enable_kubernetes_version_updates` to true or if there is a mandatory update, as described in [Updates for Kubernetes versions and Operating System versions in SKE](https://docs.stackit.cloud/stackit/en/version-updates-in-ske-10125631.html). To get the current OS image version being used for the node pool, use the read-only `os_version_used` field.
        """
        return pulumi.get(self, "os_version_min")

    @_builtins.property
    @pulumi.getter(name="osVersionUsed")
    def os_version_used(self) -> _builtins.str:
        """
        Full OS image version used. For example, if 3815.2 was set in `os_version_min`, this value may result to 3815.2.2. SKE automatically updates the cluster Kubernetes version if you have set `maintenance.enable_kubernetes_version_updates` to true or if there is a mandatory update, as described in [Updates for Kubernetes versions and Operating System versions in SKE](https://docs.stackit.cloud/stackit/en/version-updates-in-ske-10125631.html).
        """
        return pulumi.get(self, "os_version_used")

    @_builtins.property
    @pulumi.getter
    def taints(self) -> Sequence['outputs.GetSkeClusterNodePoolTaintResult']:
        """
        Specifies a taint list as defined below.
        """
        return pulumi.get(self, "taints")

    @_builtins.property
    @pulumi.getter(name="volumeSize")
    def volume_size(self) -> _builtins.int:
        """
        The volume size in GB.
        """
        return pulumi.get(self, "volume_size")

    @_builtins.property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> _builtins.str:
        """
        Specifies the volume type.
        """
        return pulumi.get(self, "volume_type")


@pulumi.output_type
class GetSkeClusterNodePoolTaintResult(dict):
    def __init__(__self__, *,
                 effect: _builtins.str,
                 key: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str effect: The taint effect.
        :param _builtins.str key: Taint key to be applied to a node.
        :param _builtins.str value: Taint value corresponding to the taint key.
        """
        pulumi.set(__self__, "effect", effect)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def effect(self) -> _builtins.str:
        """
        The taint effect.
        """
        return pulumi.get(self, "effect")

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        Taint key to be applied to a node.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Taint value corresponding to the taint key.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetSqlserverflexInstanceFlavorResult(dict):
    def __init__(__self__, *,
                 cpu: _builtins.int,
                 description: _builtins.str,
                 id: _builtins.str,
                 ram: _builtins.int):
        pulumi.set(__self__, "cpu", cpu)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ram", ram)

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> _builtins.int:
        return pulumi.get(self, "cpu")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ram(self) -> _builtins.int:
        return pulumi.get(self, "ram")


@pulumi.output_type
class GetSqlserverflexInstanceOptionsResult(dict):
    def __init__(__self__, *,
                 edition: _builtins.str,
                 retention_days: _builtins.int):
        pulumi.set(__self__, "edition", edition)
        pulumi.set(__self__, "retention_days", retention_days)

    @_builtins.property
    @pulumi.getter
    def edition(self) -> _builtins.str:
        return pulumi.get(self, "edition")

    @_builtins.property
    @pulumi.getter(name="retentionDays")
    def retention_days(self) -> _builtins.int:
        return pulumi.get(self, "retention_days")


@pulumi.output_type
class GetSqlserverflexInstanceStorageResult(dict):
    def __init__(__self__, *,
                 class_: _builtins.str,
                 size: _builtins.int):
        pulumi.set(__self__, "class_", class_)
        pulumi.set(__self__, "size", size)

    @_builtins.property
    @pulumi.getter(name="class")
    def class_(self) -> _builtins.str:
        return pulumi.get(self, "class_")

    @_builtins.property
    @pulumi.getter
    def size(self) -> _builtins.int:
        return pulumi.get(self, "size")


@pulumi.output_type
class GetVolumeSourceResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str id: The ID of the source, e.g. image ID
        :param _builtins.str type: The type of the source. Supported values are: `volume`, `image`, `snapshot`, `backup`.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the source, e.g. image ID
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the source. Supported values are: `volume`, `image`, `snapshot`, `backup`.
        """
        return pulumi.get(self, "type")


